/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.common.TopicAndPartition;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u000f\tY!l[+uS2\u001cH+Z:u\u0015\t\u0019A!A\u0003vi&d7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011A\u0001>l\u0013\ti!B\u0001\u000b[_>\\U-\u001a9feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0003qCRDW#\u0001\f\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u00027b]\u001eT\u0011aG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001e1\t11\u000b\u001e:j]\u001eDaa\b\u0001!\u0002\u00131\u0012!\u00029bi\"\u0004\u0003\"C\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0001#\u0003\u001dQ8.\u0016;jYN,\u0012a\t\t\u0003%\u0011J!!\n\u0002\u0003\u000fi[W\u000b^5mg\"Iq\u0005\u0001a\u0001\u0002\u0004%\t\u0001K\u0001\fu.,F/\u001b7t?\u0012*\u0017\u000f\u0006\u0002*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5u\u0011\u001d\u0001d%!AA\u0002\r\n1\u0001\u001f\u00132\u0011%\u0011\u0004\u00011A\u0001B\u0003&1%\u0001\u0005{WV#\u0018\u000e\\:!\u0011\u0015!\u0004\u0001\"\u00116\u0003\u0015\u0019X\r^+q)\u0005I\u0003FA\u001a8!\tAT(D\u0001:\u0015\tQ4(A\u0003kk:LGOC\u0001=\u0003\ry'oZ\u0005\u0003}e\u0012aAQ3g_J,\u0007\"\u0002!\u0001\t\u0003*\u0014\u0001\u0003;fCJ$un\u001e8)\u0005}\u0012\u0005C\u0001\u001dD\u0013\t!\u0015HA\u0003BMR,'\u000fC\u0003G\u0001\u0011\u0005Q'A\u0012uKN$8+^2dKN\u001ch-\u001e7D_:$\u0017\u000e^5p]\u0006dG)\u001a7fi\u0016\u0004\u0016\r\u001e5)\u0005\u0015C\u0005C\u0001\u001dJ\u0013\tQ\u0015H\u0001\u0003UKN$\b\"\u0002'\u0001\t\u0003)\u0014\u0001\b;fgR\u0004VM]:jgR,g\u000e^*fcV,g\u000e^5bYB\u000bG\u000f\u001b\u0015\u0003\u0017\"CQa\u0014\u0001\u0005\u0002U\n\u0001\u0005^3ti\u0006\u0013wN\u001d;fI\u000e{g\u000eZ5uS>t\u0017\r\u001c#fY\u0016$X\rU1uQ\"\u0012a\n\u0013\u0005\u0006%\u0002!\t!N\u0001!i\u0016\u001cHo\u00117vgR,'/\u00133f]RLg-[3s\u0015N|g\u000eU1sg&tw\r\u000b\u0002R\u0011\")Q\u000b\u0001C\u0001k\u0005QC/Z:u\u000f\u0016$\u0018\t\u001c7QCJ$\u0018\u000e^5p]N$v\u000e]5d/&$\bn\\;u!\u0006\u0014H/\u001b;j_:\u001c\bF\u0001+I\u0011\u0015A\u0006\u0001\"\u00016\u0003\u0011\"Xm\u001d;HKRdU-\u00193fe&\u001b(/\u00118e\u000bB|7\r\u001b$peB\u000b'\u000f^5uS>t\u0007FA,I\u0011\u0015Y\u0006\u0001\"\u00016\u0003]!Xm\u001d;HKR\u001cV-];f]\u000e,\u0017\nZ'fi\"|G\r\u000b\u0002[\u0011\u0002")
public class ZkUtilsTest
extends ZooKeeperTestHarness {
    private final String path;
    private ZkUtils zkUtils;

    public String path() {
        return this.path;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSecurityEnabled()))));
    }

    @Override
    @After
    public void tearDown() {
        if (this.zkUtils() != null) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkUtils().close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        }
        super.tearDown();
    }

    @Test
    public void testSuccessfulConditionalDeletePath() {
        Option optionalData;
        Stat statAfterCreation;
        ZkUtils qual$1 = this.zkUtils();
        String x$1 = this.path();
        String x$2 = qual$1.createPersistentPath$default$2();
        java.util.List x$3 = qual$1.createPersistentPath$default$3();
        qual$1.createPersistentPath(x$1, x$2, x$3);
        Tuple2 tuple2 = this.zkUtils().readData(this.path());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Stat stat = statAfterCreation = (Stat)tuple2._2();
        Stat statAfterCreation2 = stat;
        Assert.assertTrue((String)"Deletion should be successful", (boolean)this.zkUtils().conditionalDeletePath(this.path(), statAfterCreation2.getVersion()));
        Tuple2 tuple22 = this.zkUtils().readDataMaybeNull(this.path());
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option option = optionalData = (Option)tuple22._1();
        Option optionalData2 = option;
        Assert.assertTrue((String)"Node should be deleted", (boolean)optionalData2.isEmpty());
        Assert.assertTrue((String)"Deletion should be successful", (boolean)this.zkUtils().conditionalDeletePath(this.path(), 0));
    }

    @Test
    public void testPersistentSequentialPath() {
        ZkUtils qual$2 = this.zkUtils();
        String x$4 = this.path();
        String x$5 = qual$2.createPersistentPath$default$2();
        java.util.List x$6 = qual$2.createPersistentPath$default$3();
        qual$2.createPersistentPath(x$4, x$5, x$6);
        ZkUtils qual$3 = this.zkUtils();
        String x$7 = new StringBuilder(10).append(this.path()).append("/sequence_").toString();
        String x$8 = qual$3.createSequentialPersistentPath$default$2();
        java.util.List x$9 = qual$3.createSequentialPersistentPath$default$3();
        String result = qual$3.createSequentialPersistentPath(x$7, x$8, x$9);
        Assert.assertEquals((Object)"/path/sequence_0000000000", (Object)result);
        ZkUtils qual$4 = this.zkUtils();
        String x$10 = new StringBuilder(10).append(this.path()).append("/sequence_").toString();
        String x$11 = qual$4.createSequentialPersistentPath$default$2();
        java.util.List x$12 = qual$4.createSequentialPersistentPath$default$3();
        result = qual$4.createSequentialPersistentPath(x$10, x$11, x$12);
        Assert.assertEquals((Object)"/path/sequence_0000000001", (Object)result);
    }

    @Test
    public void testAbortedConditionalDeletePath() {
        Option optionalData;
        Stat statAfterCreation;
        ZkUtils qual$5 = this.zkUtils();
        String x$13 = this.path();
        String x$14 = qual$5.createPersistentPath$default$2();
        java.util.List x$15 = qual$5.createPersistentPath$default$3();
        qual$5.createPersistentPath(x$13, x$14, x$15);
        Tuple2 tuple2 = this.zkUtils().readData(this.path());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Stat stat = statAfterCreation = (Stat)tuple2._2();
        Stat statAfterCreation2 = stat;
        ZkUtils qual$6 = this.zkUtils();
        String x$16 = this.path();
        String x$17 = "data";
        java.util.List x$18 = qual$6.updatePersistentPath$default$3();
        qual$6.updatePersistentPath(x$16, x$17, x$18);
        Assert.assertFalse((String)"Deletion should be aborted", (boolean)this.zkUtils().conditionalDeletePath(this.path(), statAfterCreation2.getVersion()));
        Tuple2 tuple22 = this.zkUtils().readDataMaybeNull(this.path());
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option option = optionalData = (Option)tuple22._1();
        Option optionalData2 = option;
        Assert.assertTrue((String)"Node should still be there", (boolean)optionalData2.isDefined());
    }

    @Test
    public void testClusterIdentifierJsonParsing() {
        String clusterId = "test";
        Assert.assertEquals((Object)this.zkUtils().ClusterId().fromJson(this.zkUtils().ClusterId().toJson(clusterId)), (Object)clusterId);
    }

    @Test
    public void testGetAllPartitionsTopicWithoutPartitions() {
        String topic = "testtopic";
        ZkUtils qual$7 = this.zkUtils();
        String x$19 = ZkUtils$.MODULE$.getTopicPartitionPath(topic, 0);
        String x$20 = qual$7.createPersistentPath$default$2();
        java.util.List x$21 = qual$7.createPersistentPath$default$3();
        qual$7.createPersistentPath(x$19, x$20, x$21);
        ZkUtils qual$8 = this.zkUtils();
        String x$22 = ZkUtils$.MODULE$.getTopicPath("nopartitions");
        String x$23 = qual$8.createPersistentPath$default$2();
        java.util.List x$24 = qual$8.createPersistentPath$default$3();
        qual$8.createPersistentPath(x$22, x$23, x$24);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, 0)})), (Object)this.zkUtils().getAllPartitions());
    }

    @Test
    public void testGetLeaderIsrAndEpochForPartition() {
        String topic = "my-topic-test";
        int partition = 0;
        int leader = 1;
        int leaderEpoch = 1;
        int controllerEpoch = 1;
        List isr = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        String topicPath = new StringBuilder(34).append("/brokers/topics/").append(topic).append("/partitions/").append(partition).append("/state").toString();
        String topicData = Json$.MODULE$.legacyEncodeAsString((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)controllerEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)leader)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versions"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), (Object)isr)})));
        ZkUtils qual$9 = this.zkUtils();
        String x$25 = topicPath;
        String x$26 = topicData;
        java.util.List x$27 = qual$9.createPersistentPath$default$3();
        qual$9.createPersistentPath(x$25, x$26, x$27);
        Option leaderIsrAndControllerEpoch = this.zkUtils().getLeaderIsrAndEpochForPartition(topic, partition);
        LeaderIsrAndControllerEpoch topicDataLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(leader, leaderEpoch, isr, 0), controllerEpoch);
        Assert.assertEquals((Object)topicDataLeaderIsrAndControllerEpoch, (Object)leaderIsrAndControllerEpoch.get());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkUtils().getLeaderIsrAndEpochForPartition(topic, partition + 1));
    }

    @Test
    public void testGetSequenceIdMethod() {
        String path = "/test/seqid";
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)seqid -> {
            ZkUtils qual$10 = this.zkUtils();
            String x$28 = path;
            java.util.List x$29 = qual$10.getSequenceId$default$2();
            Assert.assertEquals((long)seqid, (long)qual$10.getSequenceId(x$28, x$29));
        });
    }

    public ZkUtilsTest() {
        this.path = "/path";
    }
}

