/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.security.auth.Acl;
import kafka.security.auth.Allow$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.ResourceType$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.server.ConfigType$;
import kafka.utils.CoreUtils$;
import kafka.zk.AdminZNode$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.ConsumerOffset$;
import kafka.zk.ControllerEpochZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZkData$;
import kafka.zk.ZkVersion$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.CreateResponse$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.SetDataResponse$;
import kafka.zookeeper.ZNodeChangeHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r\re\u0001B\u0001\u0003\u0001\u001d\u0011\u0011cS1gW\u0006T6n\u00117jK:$H+Z:u\u0015\t\u0019A!\u0001\u0002{W*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001Aq!\u0005\u0001C\u0002\u0013%!#A\u0003he>,\b/F\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003mC:<'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011aa\u0015;sS:<\u0007B\u0002\u000f\u0001A\u0003%1#\u0001\u0004he>,\b\u000f\t\u0005\b=\u0001\u0011\r\u0011\"\u0003\u0013\u0003\u0019!x\u000e]5dc!1\u0001\u0005\u0001Q\u0001\nM\tq\u0001^8qS\u000e\f\u0004\u0005C\u0004#\u0001\t\u0007I\u0011\u0002\n\u0002\rQ|\u0007/[23\u0011\u0019!\u0003\u0001)A\u0005'\u00059Ao\u001c9jGJ\u0002\u0003b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8ocA*\u0012\u0001\u000b\t\u0003SEj\u0011A\u000b\u0006\u0003W1\naaY8n[>t'BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IR#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0015\u0002#Q|\u0007/[2QCJ$\u0018\u000e^5p]F\u0002\u0004\u0005C\u00047\u0001\t\u0007I\u0011A\u0014\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]F\n\u0004B\u0002\u001d\u0001A\u0003%\u0001&A\tu_BL7\rU1si&$\u0018n\u001c82c\u0001BqA\u000f\u0001C\u0002\u0013\u0005q%\u0001\tu_BL7\rU1si&$\u0018n\u001c83a!1A\b\u0001Q\u0001\n!\n\u0011\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gN\r\u0019!\u0011\u001dq\u0004A1A\u0005\u0002}\nA\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u00191?F\nT#\u0001!\u0011\u0007\u00053\u0005&D\u0001C\u0015\t\u0019E)\u0001\u0006d_2dWm\u0019;j_:T\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\n\u00131aU3r\u0011\u0019I\u0005\u0001)A\u0005\u0001\u0006)Bo\u001c9jGB\u000b'\u000f^5uS>t7/\r\u0019`cE\u0002\u0003bB&\u0001\u0005\u0004%\t\u0001T\u0001\u0019G>tGO]8mY\u0016\u0014X\t]8dQj[g+\u001a:tS>tW#A'\u0011\u00059{U\"\u0001#\n\u0005A#%aA%oi\"1!\u000b\u0001Q\u0001\n5\u000b\u0011dY8oiJ|G\u000e\\3s\u000bB|7\r\u001b.l-\u0016\u00148/[8oA!IA\u000b\u0001a\u0001\u0002\u0004%\t!V\u0001\u000e_RDWM\u001d.l\u00072LWM\u001c;\u0016\u0003Y\u0003\"!C,\n\u0005a\u0013!!D&bM.\f'l[\"mS\u0016tG\u000fC\u0005[\u0001\u0001\u0007\t\u0019!C\u00017\u0006\tr\u000e\u001e5fej[7\t\\5f]R|F%Z9\u0015\u0005q{\u0006C\u0001(^\u0013\tqFI\u0001\u0003V]&$\bb\u00021Z\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0004\"\u00032\u0001\u0001\u0004\u0005\t\u0015)\u0003W\u00039yG\u000f[3s5.\u001cE.[3oi\u0002BQ\u0001\u001a\u0001\u0005B\u0015\fQa]3u+B$\u0012\u0001\u0018\u0015\u0003G\u001e\u0004\"\u0001[6\u000e\u0003%T!A[\u0018\u0002\u000b),h.\u001b;\n\u00051L'A\u0002\"fM>\u0014X\rC\u0003o\u0001\u0011\u0005S-\u0001\u0005uK\u0006\u0014Hi\\<oQ\ti\u0007\u000f\u0005\u0002ic&\u0011!/\u001b\u0002\u0006\u0003\u001a$XM\u001d\u0005\bi\u0002\u0011\r\u0011\"\u0003(\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DaA\u001e\u0001!\u0002\u0013A\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\t\u000ba\u0004A\u0011A3\u00027Q,7\u000f^*fi\u0006sGmR3u\u0007>t7/^7fe>3gm]3uQ\t9(\u0010\u0005\u0002iw&\u0011A0\u001b\u0002\u0005)\u0016\u001cH\u000fC\u0003\u007f\u0001\u0011\u0005Q-A\u000euKN$x)\u001a;D_:\u001cX/\\3s\u001f\u001a47/\u001a;O_\u0012\u000bG/\u0019\u0015\u0003{jDa!a\u0001\u0001\t\u0003)\u0017a\u0005;fgR$U\r\\3uKJ+7-\u001e:tSZ,\u0007fAA\u0001u\"1\u0011\u0011\u0002\u0001\u0005\u0002\u0015\f!\u0007^3ti\u0012+G.\u001a;f%\u0016\u001cWO]:jm\u0016<\u0016\u000e\u001e5D_:$(o\u001c7mKJ,\u0005o\\2i-\u0016\u00148/[8o\u0007\",7m\u001b\u0015\u0004\u0003\u000fQ\bBBA\b\u0001\u0011\u0005Q-A\nuKN$8I]3bi\u0016\u0014VmY;sg&4X\rK\u0002\u0002\u000eiDa!!\u0006\u0001\t\u0003)\u0017A\u0007;fgR$v\u000e]5d\u0003N\u001c\u0018n\u001a8nK:$X*\u001a;i_\u0012\u001c\bfAA\nu\"1\u00111\u0004\u0001\u0005\u0002\u0015\fQ\u0003^3ti\u001e+G\u000fR1uC\u0006sGMV3sg&|g\u000eK\u0002\u0002\u001aiDa!!\t\u0001\t\u0003)\u0017!\u0007;fgR\u001cuN\u001c3ji&|g.\u00197Va\u0012\fG/\u001a)bi\"D3!a\b{\u0011\u0019\t9\u0003\u0001C\u0001K\u0006\u0011C/Z:u\u0007J,\u0017\r^3TKF,XM\u001c;jC2\u0004VM]:jgR,g\u000e\u001e)bi\"D3!!\n{\u0011\u0019\ti\u0003\u0001C\u0001K\u00069B/Z:u!J|\u0007/Y4bi\u0016L5O]\"iC:<Wm\u001d\u0015\u0004\u0003WQ\bBBA\u001a\u0001\u0011\u0005Q-\u0001\u0011uKN$\u0018j\u001d:DQ\u0006tw-\u001a(pi&4\u0017nY1uS>tw)\u001a;uKJ\u001c\bfAA\u0019u\"1\u0011\u0011\b\u0001\u0005\u0002\u0015\f!\u0005^3ti&\u001b(o\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]N$U\r\\3uS>t\u0007fAA\u001cu\"1\u0011q\b\u0001\u0005\u0002\u0015\f1\u0003^3tiB\u0013x\u000e]1hCR,Gj\\4ESJD3!!\u0010{\u0011\u0019\t)\u0005\u0001C\u0001K\u0006\tB/Z:u\u0019><G)\u001b:HKR$XM]:)\u0007\u0005\r#\u0010\u0003\u0004\u0002L\u0001!\t!Z\u0001%i\u0016\u001cH\u000fT8h\t&\u0014XI^3oi:{G/\u001b4jG\u0006$\u0018n\u001c8t\t\u0016dW\r^5p]\"\u001a\u0011\u0011\n>\t\r\u0005E\u0003\u0001\"\u0001f\u0003!\"Xm\u001d;TKR<U\r^!oI\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8uQ\r\tyE\u001f\u0005\u0007\u0003/\u0002A\u0011A3\u0002%Q,7\u000f^$fi\u0012\u000bG/Y!oIN#\u0018\r\u001e\u0015\u0004\u0003+R\bBBA/\u0001\u0011\u0005Q-A\buKN$x)\u001a;DQ&dGM]3oQ\r\tYF\u001f\u0005\u0007\u0003G\u0002A\u0011A3\u00021Q,7\u000f^!dY6\u000bg.Y4f[\u0016tG/T3uQ>$7\u000fK\u0002\u0002biDa!!\u001b\u0001\t\u0003)\u0017A\u0004;fgR$U\r\\3uKB\u000bG\u000f\u001b\u0015\u0004\u0003OR\bBBA8\u0001\u0011\u0005Q-\u0001\u000buKN$H)\u001a7fi\u0016$v\u000e]5d5:{G-\u001a\u0015\u0004\u0003[R\bBBA;\u0001\u0011\u0005Q-\u0001\u000euKN$H)\u001a7fi\u0016$v\u000e]5d!\u0006$\b.T3uQ>$7\u000fK\u0002\u0002tiDq!a\u001f\u0001\t\u0013\ti(\u0001\u000ebgN,'\u000f\u001e)bi\",\u00050[:uK:\u001cW-\u00118e\t\u0006$\u0018\rF\u0003]\u0003\u007f\n9\n\u0003\u0005\u0002\u0002\u0006e\u0004\u0019AAB\u00031)\u0007\u0010]3di\u0016$\u0007+\u0019;i!\u0011\t))a%\u000f\t\u0005\u001d\u0015q\u0012\t\u0004\u0003\u0013#UBAAF\u0015\r\tiIB\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005EE)\u0001\u0004Qe\u0016$WMZ\u0005\u00045\u0005U%bAAI\t\"A\u0011\u0011TA=\u0001\u0004\t\u0019)\u0001\u0003eCR\f\u0007BBAO\u0001\u0011\u0005Q-A\u0011uKN$8I]3bi\u0016$vn[3o\u0007\"\fgnZ3O_RLg-[2bi&|g\u000eK\u0002\u0002\u001cjDa!a)\u0001\t\u0003)\u0017!\t;fgR,e\u000e^5us\u000e{gNZ5h\u001b\u0006t\u0017mZ3nK:$X*\u001a;i_\u0012\u001c\bfAAQu\"1\u0011\u0011\u0016\u0001\u0005\u0002\u0015\f!\u0005^3ti\u000e\u0013X-\u0019;f\u0007>tg-[4DQ\u0006tw-\u001a(pi&4\u0017nY1uS>t\u0007fAATu\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0016AD2sK\u0006$X\rT8h!J|\u0007o\u001d\u000b\u0005\u0003g\u000by\f\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tIlF\u0001\u0005kRLG.\u0003\u0003\u0002>\u0006]&A\u0003)s_B,'\u000f^5fg\"9\u0011\u0011YAW\u0001\u0004i\u0015!\u00032zi\u0016\u001c\bK]8q\u0011%\t)\r\u0001b\u0001\n\u0013\t9-\u0001\u0005m_\u001e\u0004&o\u001c9t+\t\t\u0019\f\u0003\u0005\u0002L\u0002\u0001\u000b\u0011BAZ\u0003%awn\u001a)s_B\u001c\b\u0005\u0003\u0004\u0002P\u0002!\t!Z\u0001\u0012i\u0016\u001cHoR3u\u0019><7i\u001c8gS\u001e\u001c\bfAAgu\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0017\u0001E2sK\u0006$XM\u0011:pW\u0016\u0014\u0018J\u001c4p)1\tI.a8\u0002d\u0006\u001d\u00181^A\u0000!\rI\u00111\\\u0005\u0004\u0003;\u0014!A\u0003\"s_.,'/\u00138g_\"9\u0011\u0011]Aj\u0001\u0004i\u0015AA5e\u0011!\t)/a5A\u0002\u0005\r\u0015\u0001\u00025pgRDq!!;\u0002T\u0002\u0007Q*\u0001\u0003q_J$\b\u0002CAw\u0003'\u0004\r!a<\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>d\u0007\u0003BAy\u0003wl!!a=\u000b\t\u0005U\u0018q_\u0001\u0005CV$\bNC\u0002\u0002z*\n\u0001b]3dkJLG/_\u0005\u0005\u0003{\f\u0019P\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"Q!\u0011AAj!\u0003\u0005\rAa\u0001\u0002\tI\f7m\u001b\t\u0006\u001d\n\u0015\u00111Q\u0005\u0004\u0005\u000f!%AB(qi&|g\u000e\u0003\u0004\u0003\f\u0001!\t!Z\u0001\u0017i\u0016\u001cHOU3hSN$XM\u001d\"s_.,'/\u00138g_\"\u001a!\u0011\u0002>\t\r\tE\u0001\u0001\"\u0001f\u0003Q!Xm\u001d;HKR\u0014%o\\6fe6+G\u000f[8eg\"\u001a!q\u0002>\t\r\t]\u0001\u0001\"\u0001f\u0003Q!Xm\u001d;Va\u0012\fG/\u001a\"s_.,'/\u00138g_\"\u001a!Q\u0003>\t\u000f\tu\u0001\u0001\"\u0003\u0003 \u0005y1\u000f^1u/&$\bNV3sg&|g\u000e\u0006\u0003\u0003\"\t=\u0002\u0003\u0002B\u0012\u0005Wi!A!\n\u000b\t\u0005e%q\u0005\u0006\u0004\u0005Si\u0013!\u0003>p_.,W\r]3s\u0013\u0011\u0011iC!\n\u0003\tM#\u0018\r\u001e\u0005\b\u0005c\u0011Y\u00021\u0001N\u0003\u001d1XM]:j_:DqA!\u000e\u0001\t\u0013\u00119$\u0001\u000fmK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r[:\u0015\r\te\"1\nB(!\u001d\t)Ia\u000f)\u0005\u007fIAA!\u0010\u0002\u0016\n\u0019Q*\u00199\u0011\t\t\u0005#qI\u0007\u0003\u0005\u0007R1A!\u0012\u0005\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0005\u0005\u0013\u0012\u0019EA\u000eMK\u0006$WM]%te\u0006sGmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0005\b\u0005\u001b\u0012\u0019\u00041\u0001N\u0003\u0015\u0019H/\u0019;f\u0011\u001d\u0011\tFa\rA\u00025\u000b\u0011B_6WKJ\u001c\u0018n\u001c8\t\u0013\tU\u0003A1A\u0005\u0002\t]\u0013aI5oSRL\u0017\r\u001c'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007n]\u000b\u0003\u0005sA\u0001Ba\u0017\u0001A\u0003%!\u0011H\u0001%S:LG/[1m\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195tA!I!q\f\u0001C\u0002\u0013\u0005!\u0011M\u0001\u0012S:LG/[1m\u0019\u0016\fG-\u001a:JgJ\u001cXC\u0001B2!\u001d\t)Ia\u000f)\u0005K\u0002BAa\u001a\u0003n5\u0011!\u0011\u000e\u0006\u0004\u0005W\"\u0011aA1qS&!!q\u000eB5\u00051aU-\u00193fe\u0006sG-S:s\u0011!\u0011\u0019\b\u0001Q\u0001\n\t\r\u0014AE5oSRL\u0017\r\u001c'fC\u0012,'/S:sg\u0002BqAa\u001e\u0001\t\u0013\u0011I(\u0001\u0006mK\u0006$WM]%teN$bAa\u0019\u0003|\tu\u0004b\u0002B'\u0005k\u0002\r!\u0014\u0005\b\u0005#\u0012)\b1\u0001N\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007\u000bQd\u00195fG.,\u0006\u000fZ1uK2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKN,H\u000e\u001e\u000b\n9\n\u0015%\u0011\u0012BG\u0005oC\u0001Ba\"\u0003\u0000\u0001\u0007!1M\u0001\u001dKb\u0004Xm\u0019;fIN+8mY3tg\u001a,H\u000eU1si&$\u0018n\u001c8t\u0011\u001d\u0011YIa A\u0002\u0001\u000b\u0011$\u001a=qK\u000e$X\r\u001a)beRLG/[8ogR{'+\u001a;ss\"A!q\u0012B@\u0001\u0004\u0011\t*\u0001\rfqB,7\r^3e\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004r!!\"\u0003<!\u0012\u0019\nE\u0004O\u0005+\u0013I*a!\n\u0007\t]EI\u0001\u0004UkBdWM\r\u0019\u0005\u00057\u0013)\u000b\u0005\u0004\u0002\u0006\nu%\u0011U\u0005\u0005\u0005?\u000b)JA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0003$\n\u0015F\u0002\u0001\u0003\r\u0005O\u0013i)!A\u0001\u0002\u000b\u0005!\u0011\u0016\u0002\u0004?\u0012\n\u0014\u0003\u0002BV\u0005c\u00032A\u0014BW\u0013\r\u0011y\u000b\u0012\u0002\b\u001d>$\b.\u001b8h!\rq%1W\u0005\u0004\u0005k#%aA!os\"A!\u0011\u0018B@\u0001\u0004\u0011Y,\u0001\u0010bGR,\u0018\r\\+qI\u0006$X\rT3bI\u0016\u0014\u0018I\u001c3JgJ\u0014Vm];miB!!Q\u0018Bf\u001d\u0011\u0011yLa2\u000f\t\t\u0005'Q\u0019\b\u0005\u0003\u0013\u0013\u0019-C\u0001\u0006\u0013\t\u0019A!C\u0002\u0003J\n\tQbS1gW\u0006T6n\u00117jK:$\u0018\u0002\u0002Bg\u0005\u001f\u0014\u0001$\u00169eCR,G*Z1eKJ\fe\u000eZ%teJ+7/\u001e7u\u0015\r\u0011IM\u0001\u0005\u0007\u0005'\u0004A\u0011A3\u0002-Q,7\u000f^+qI\u0006$X\rT3bI\u0016\u0014\u0018I\u001c3JgJD3A!5{\u0011\u001d\u0011I\u000e\u0001C\u0005\u00057\fAc\u00195fG.<U\r\u001e#bi\u0006\u0014Vm\u001d9p]N,Gc\u0002/\u0003^\n}'\u0011\u001d\u0005\t\u0005k\u00119\u000e1\u0001\u0003:!1AOa6A\u0002!B\u0001Ba9\u0003X\u0002\u0007!Q]\u0001\te\u0016\u001c\bo\u001c8tKB!!q\u001dBv\u001b\t\u0011IOC\u0002\u0003*\u0011IAA!<\u0003j\nyq)\u001a;ECR\f'+Z:q_:\u001cX\rC\u0004\u0003r\u0002!IAa=\u0002E\u0015\u0014\u0018m]3V]\u000eDWmY6fI&sgm\\%o\u0007J,\u0017\r^3SKN\u0004xN\\:f)\u0011\u0011)Pa?\u0011\t\t\u001d(q_\u0005\u0005\u0005s\u0014IO\u0001\bDe\u0016\fG/\u001a*fgB|gn]3\t\u0011\t\r(q\u001ea\u0001\u0005kDaAa@\u0001\t\u0003)\u0017A\u0007;fgR<U\r\u001e+pa&\u001c7/\u00118e!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001B\u007fu\"11Q\u0001\u0001\u0005\u0002\u0015\fq\u0005^3ti\u000e\u0013X-\u0019;f\u0003:$w)\u001a;U_BL7\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d*bo\"\u001a11\u0001>\t\r\r-\u0001\u0001\"\u0001f\u0003y!Xm\u001d;TKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgJ\u000bw\u000fK\u0002\u0004\niDaa!\u0005\u0001\t\u0003)\u0017\u0001\t;fgR\u0014V-Y:tS\u001et\u0007+\u0019:uSRLwN\\:J]B\u0013xn\u001a:fgND3aa\u0004{\u0011\u0019\u00199\u0002\u0001C\u0001K\u0006YB/Z:u\u000f\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000b^1uKND3a!\u0006{\u0011\u001d\u0019i\u0002\u0001C\u0005\u0007?\t1%\u001a:bg\u0016,fn\u00195fG.,G-\u00138g_&s7+\u001a;ECR\f'+Z:q_:\u001cX\r\u0006\u0003\u0004\"\r\u001d\u0002\u0003\u0002Bt\u0007GIAa!\n\u0003j\ny1+\u001a;ECR\f'+Z:q_:\u001cX\r\u0003\u0005\u0003d\u000em\u0001\u0019AB\u0011\u0011\u0019\u0019Y\u0003\u0001C\u0001K\u0006QB/Z:u\u0007>tGO]8mY\u0016\u0014X\t]8dQ6+G\u000f[8eg\"\u001a1\u0011\u0006>\t\r\rE\u0002\u0001\"\u0001f\u0003}!Xm\u001d;D_:$(o\u001c7mKJl\u0015M\\1hK6,g\u000e^'fi\"|Gm\u001d\u0015\u0004\u0007_Q\bBBB\u001c\u0001\u0011\u0005Q-A\u0012uKN$(LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\r>\u0014H)\u0019;b\u0007\"\fgnZ3)\u0007\rU\"\u0010\u0003\u0004\u0004>\u0001!\t!Z\u0001\u0015i\u0016\u001cHo\u00117vgR,'/\u00133NKRDw\u000eZ:)\u0007\rm\"\u0010\u0003\u0004\u0004D\u0001!\t!Z\u0001\u001ci\u0016\u001cHO\u0011:pW\u0016\u00148+Z9vK:\u001cW-\u00133NKRDw\u000eZ:)\u0007\r\u0005#\u0010\u0003\u0004\u0004J\u0001!\t!Z\u0001\u0018i\u0016\u001cHo\u0011:fCR,Gk\u001c9MKZ,G\u000eU1uQND3aa\u0012{\u0011\u0019\u0019y\u0005\u0001C\u0001K\u0006\u0019C/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006,E.Z2uS>tW*\u001a;i_\u0012\u001c\bfAB'u\"91Q\u000b\u0001\u0005\n\r]\u0013\u0001\u00043bi\u0006\f5o\u0015;sS:<G\u0003\u0002B\u0002\u00073B\u0001ba\u0017\u0004T\u0001\u0007\u00111Q\u0001\u0005a\u0006$\b\u000e\u0003\u0004\u0004`\u0001!\t!Z\u0001\u001bi\u0016\u001cH\u000fR3mK\u001e\fG/[8o)>\\WM\\'fi\"|Gm\u001d\u0015\u0004\u0007;R\bBBB3\u0001\u0011\u0005Q-\u0001\fuKN$8i\u001c8tk6,'o\u00144gg\u0016$\b+\u0019;iQ\r\u0019\u0019G\u001f\u0005\n\u0007W\u0002\u0011\u0013!C\u0005\u0007[\n!d\u0019:fCR,'I]8lKJLeNZ8%I\u00164\u0017-\u001e7uIU*\"aa\u001c+\t\t\r1\u0011O\u0016\u0003\u0007g\u0002Ba!\u001e\u0004\u00005\u00111q\u000f\u0006\u0005\u0007s\u001aY(A\u0005v]\u000eDWmY6fI*\u00191Q\u0010#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0002\u000e]$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class KafkaZkClientTest
extends ZooKeeperTestHarness {
    private final String group;
    private final String topic1;
    private final String topic2;
    private final TopicPartition topicPartition10 = new TopicPartition(this.topic1(), 0);
    private final TopicPartition topicPartition11 = new TopicPartition(this.topic1(), 1);
    private final TopicPartition topicPartition20 = new TopicPartition(this.topic2(), 0);
    private final Seq<TopicPartition> topicPartitions10_11 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}));
    private final int controllerEpochZkVersion;
    private KafkaZkClient otherZkClient;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final Properties logProps = this.createLogProps(1024);
    private final scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> initialLeaderIsrAndControllerEpochs = this.leaderIsrAndControllerEpochs(0, 0);
    private final scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> initialLeaderIsrs = this.initialLeaderIsrAndControllerEpochs().mapValues((Function1 & Serializable & scala.Serializable)x$7 -> x$7.leaderAndIsr());

    private String group() {
        return this.group;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    public TopicPartition topicPartition10() {
        return this.topicPartition10;
    }

    public TopicPartition topicPartition11() {
        return this.topicPartition11;
    }

    public TopicPartition topicPartition20() {
        return this.topicPartition20;
    }

    public Seq<TopicPartition> topicPartitions10_11() {
        return this.topicPartitions10_11;
    }

    public int controllerEpochZkVersion() {
        return this.controllerEpochZkVersion;
    }

    public KafkaZkClient otherZkClient() {
        return this.otherZkClient;
    }

    public void otherZkClient_$eq(KafkaZkClient x$1) {
        this.otherZkClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.zkClient().createControllerEpochRaw(1);
        this.otherZkClient_$eq(KafkaZkClient$.MODULE$.apply(this.zkConnect(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSecurityEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8()));
    }

    @Override
    @After
    public void tearDown() {
        if (this.otherZkClient() != null) {
            this.otherZkClient().close();
        }
        this.zkClient().deletePath(ControllerEpochZNode$.MODULE$.path());
        super.tearDown();
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Test
    public void testSetAndGetConsumerOffset() {
        long offset = 123L;
        Assert.assertTrue((boolean)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).isEmpty());
        this.zkClient().setOrCreateConsumerOffset(this.group(), this.topicPartition(), offset);
        Assert.assertEquals((long)offset, (long)BoxesRunTime.unboxToLong((Object)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).get()));
        this.zkClient().setOrCreateConsumerOffset(this.group(), this.topicPartition(), offset + 2L);
        Assert.assertEquals((long)(offset + 2L), (long)BoxesRunTime.unboxToLong((Object)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).get()));
    }

    @Test
    public void testGetConsumerOffsetNoData() {
        KafkaZkClient qual$1 = this.zkClient();
        String x$12 = ConsumerOffset$.MODULE$.path(this.group(), this.topicPartition().topic(), Predef$.MODULE$.int2Integer(this.topicPartition().partition()));
        byte[] x$13 = qual$1.createRecursive$default$2();
        boolean x$14 = qual$1.createRecursive$default$3();
        qual$1.createRecursive(x$12, x$13, x$14);
        Assert.assertTrue((boolean)this.zkClient().getConsumerOffset(this.group(), this.topicPartition()).isEmpty());
    }

    @Test
    public void testDeleteRecursive() {
        KafkaZkClient qual$2 = this.zkClient();
        String x$15 = "/delete/does-not-exist";
        int x$16 = qual$2.deleteRecursive$default$2();
        qual$2.deleteRecursive(x$15, x$16);
        KafkaZkClient qual$3 = this.zkClient();
        String x$17 = "/delete/some/random/path";
        byte[] x$18 = qual$3.createRecursive$default$2();
        boolean x$19 = qual$3.createRecursive$default$3();
        qual$3.createRecursive(x$17, x$18, x$19);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/delete/some/random/path"));
        KafkaZkClient qual$4 = this.zkClient();
        String x$20 = "/delete";
        int x$21 = qual$4.deleteRecursive$default$2();
        Assert.assertTrue((boolean)qual$4.deleteRecursive(x$20, x$21));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete"));
        this.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            KafkaZkClient qual$5 = this.zkClient();
            String x$22 = "delete-invalid-path";
            int x$23 = qual$5.deleteRecursive$default$2();
            return qual$5.deleteRecursive(x$22, x$23);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
    }

    @Test
    public void testDeleteRecursiveWithControllerEpochVersionCheck() {
        Assert.assertFalse((boolean)this.zkClient().deleteRecursive("/delete/does-not-exist", this.controllerEpochZkVersion()));
        KafkaZkClient qual$6 = this.zkClient();
        String x$24 = "/delete/some/random/path";
        byte[] x$25 = qual$6.createRecursive$default$2();
        boolean x$26 = qual$6.createRecursive$default$3();
        qual$6.createRecursive(x$24, x$25, x$26);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/delete/some/random/path"));
        this.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().deleteRecursive("/delete", this.controllerEpochZkVersion() + 1), ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        Assert.assertTrue((boolean)this.zkClient().deleteRecursive("/delete", this.controllerEpochZkVersion()));
        Assert.assertFalse((boolean)this.zkClient().pathExists("/delete"));
        this.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkClient().deleteRecursive("delete-invalid-path", this.controllerEpochZkVersion()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
    }

    @Test
    public void testCreateRecursive() {
        KafkaZkClient qual$7 = this.zkClient();
        String x$27 = "/create-newrootpath";
        byte[] x$28 = qual$7.createRecursive$default$2();
        boolean x$29 = qual$7.createRecursive$default$3();
        qual$7.createRecursive(x$27, x$28, x$29);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/create-newrootpath"));
        KafkaZkClient qual$8 = this.zkClient();
        String x$30 = "/create/some/random/long/path";
        byte[] x$31 = qual$8.createRecursive$default$2();
        boolean x$32 = qual$8.createRecursive$default$3();
        qual$8.createRecursive(x$30, x$31, x$32);
        Assert.assertTrue((boolean)this.zkClient().pathExists("/create/some/random/long/path"));
        KafkaZkClient qual$9 = this.zkClient();
        String x$33 = "/create/some/random/long/path";
        boolean x$34 = false;
        byte[] x$35 = qual$9.createRecursive$default$2();
        qual$9.createRecursive(x$33, x$35, x$34);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            KafkaZkClient qual$10 = this.zkClient();
            String x$36 = "create-invalid-path";
            byte[] x$37 = qual$10.createRecursive$default$2();
            boolean x$38 = qual$10.createRecursive$default$3();
            qual$10.createRecursive(x$36, x$37, x$38);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
    }

    @Test
    public void testTopicAssignmentMethods() {
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().isEmpty());
        Assert.assertFalse((boolean)this.zkClient().topicExists(this.topic1()));
        Assert.assertTrue((boolean)this.zkClient().getTopicPartitionCount(this.topic1()).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getPartitionsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getReplicasForPartition(new TopicPartition(this.topic1(), 2)).isEmpty());
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic1(), 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        this.zkClient().createTopicAssignment(this.topic1(), assignment);
        Assert.assertTrue((boolean)this.zkClient().topicExists(this.topic1()));
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)assignment.map((Function1 & Serializable & scala.Serializable)topicAssignment -> {
            int partition = ((TopicPartition)topicAssignment._1()).partition();
            Seq assignment = (Seq)topicAssignment._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment);
        }, Map$.MODULE$.canBuildFrom());
        Assert.assertEquals((long)assignment.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(this.topic1()).get()));
        Assert.assertEquals((Object)expectedAssignment, (Object)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).get((Object)this.topic1()).get());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)((TraversableOnce)this.zkClient().getPartitionsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).get((Object)this.topic1()).get()).toSet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition(this.topic1(), 2)).toSet());
        scala.collection.immutable.Map updatedAssignment = (scala.collection.immutable.Map)assignment.$minus((Object)new TopicPartition(this.topic1(), 2));
        KafkaZkClient qual$11 = this.zkClient();
        String x$39 = this.topic1();
        scala.collection.immutable.Map x$40 = updatedAssignment;
        int x$41 = qual$11.setTopicAssignment$default$3();
        qual$11.setTopicAssignment(x$39, x$40, x$41);
        Assert.assertEquals((long)updatedAssignment.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(this.topic1()).get()));
        scala.collection.immutable.Map secondAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic2(), 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic2(), 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        this.zkClient().createTopicAssignment(this.topic2(), secondAssignment);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getAllTopicsInCluster().toSet());
    }

    @Test
    public void testGetDataAndVersion() {
        String path = "/testpath";
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(path);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option data0 = (Option)tuple2._1();
        int version0 = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)data0, (Object)BoxesRunTime.boxToInteger((int)version0));
        Tuple2 tuple23 = tuple22;
        Option data02 = (Option)tuple23._1();
        int version02 = tuple23._2$mcI$sp();
        Assert.assertTrue((boolean)data02.isEmpty());
        Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)version02);
        KafkaZkClient qual$12 = this.zkClient();
        String x$42 = path;
        byte[] x$43 = qual$12.createRecursive$default$2();
        boolean x$44 = qual$12.createRecursive$default$3();
        qual$12.createRecursive(x$42, x$43, x$44);
        KafkaZkClient qual$13 = this.zkClient();
        String x$45 = path;
        byte[] x$46 = "version1".getBytes(StandardCharsets.UTF_8);
        int x$47 = 0;
        Option x$48 = qual$13.conditionalUpdatePath$default$4();
        qual$13.conditionalUpdatePath(x$45, x$46, x$47, x$48);
        Tuple2 tuple24 = this.zkClient().getDataAndVersion(path);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Option data1 = (Option)tuple24._1();
        int version1 = tuple24._2$mcI$sp();
        Tuple2 tuple25 = new Tuple2((Object)data1, (Object)BoxesRunTime.boxToInteger((int)version1));
        Tuple2 tuple26 = tuple25;
        Option data12 = (Option)tuple26._1();
        int version12 = tuple26._2$mcI$sp();
        Assert.assertEquals((Object)"version1", (Object)new String((byte[])data12.get(), StandardCharsets.UTF_8));
        Assert.assertEquals((long)1L, (long)version12);
        KafkaZkClient qual$14 = this.zkClient();
        String x$49 = path;
        byte[] x$50 = "version2".getBytes(StandardCharsets.UTF_8);
        int x$51 = 1;
        Option x$52 = qual$14.conditionalUpdatePath$default$4();
        qual$14.conditionalUpdatePath(x$49, x$50, x$51, x$52);
        Tuple2 tuple27 = this.zkClient().getDataAndVersion(path);
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        Option data2 = (Option)tuple27._1();
        int version2 = tuple27._2$mcI$sp();
        Tuple2 tuple28 = new Tuple2((Object)data2, (Object)BoxesRunTime.boxToInteger((int)version2));
        Tuple2 tuple29 = tuple28;
        Option data22 = (Option)tuple29._1();
        int version22 = tuple29._2$mcI$sp();
        Assert.assertEquals((Object)"version2", (Object)new String((byte[])data22.get(), StandardCharsets.UTF_8));
        Assert.assertEquals((long)2L, (long)version22);
    }

    @Test
    public void testConditionalUpdatePath() {
        String path = "/testconditionalpath";
        KafkaZkClient qual$15 = this.zkClient();
        String x$53 = path;
        byte[] x$54 = "version0".getBytes(StandardCharsets.UTF_8);
        int x$55 = 0;
        Option x$56 = qual$15.conditionalUpdatePath$default$4();
        Tuple2 statusAndVersion = qual$15.conditionalUpdatePath(x$53, x$54, x$55, x$56);
        Assert.assertFalse((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)statusAndVersion._2$mcI$sp());
        KafkaZkClient qual$16 = this.zkClient();
        String x$57 = path;
        byte[] x$58 = qual$16.createRecursive$default$2();
        boolean x$59 = qual$16.createRecursive$default$3();
        qual$16.createRecursive(x$57, x$58, x$59);
        KafkaZkClient qual$17 = this.zkClient();
        String x$60 = path;
        byte[] x$61 = "version1".getBytes(StandardCharsets.UTF_8);
        int x$62 = 0;
        Option x$63 = qual$17.conditionalUpdatePath$default$4();
        statusAndVersion = qual$17.conditionalUpdatePath(x$60, x$61, x$62, x$63);
        Assert.assertTrue((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)1L, (long)statusAndVersion._2$mcI$sp());
        KafkaZkClient qual$18 = this.zkClient();
        String x$64 = path;
        byte[] x$65 = "version2".getBytes(StandardCharsets.UTF_8);
        int x$66 = 2;
        Option x$67 = qual$18.conditionalUpdatePath$default$4();
        statusAndVersion = qual$18.conditionalUpdatePath(x$64, x$65, x$66, x$67);
        Assert.assertFalse((boolean)statusAndVersion._1$mcZ$sp());
        Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)statusAndVersion._2$mcI$sp());
    }

    @Test
    public void testCreateSequentialPersistentPath() {
        String path = "/testpath";
        KafkaZkClient qual$19 = this.zkClient();
        String x$68 = path;
        byte[] x$69 = qual$19.createRecursive$default$2();
        boolean x$70 = qual$19.createRecursive$default$3();
        qual$19.createRecursive(x$68, x$69, x$70);
        String result = this.zkClient().createSequentialPersistentPath(new StringBuilder(10).append(path).append("/sequence_").toString(), null);
        Assert.assertEquals((Object)new StringBuilder(20).append(path).append("/sequence_0000000000").toString(), (Object)result);
        Assert.assertTrue((boolean)this.zkClient().pathExists(new StringBuilder(20).append(path).append("/sequence_0000000000").toString()));
        Assert.assertEquals((Object)None$.MODULE$, this.dataAsString(new StringBuilder(20).append(path).append("/sequence_0000000000").toString()));
        result = this.zkClient().createSequentialPersistentPath(new StringBuilder(10).append(path).append("/sequence_").toString(), "some value".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)new StringBuilder(20).append(path).append("/sequence_0000000001").toString(), (Object)result);
        Assert.assertTrue((boolean)this.zkClient().pathExists(new StringBuilder(20).append(path).append("/sequence_0000000001").toString()));
        Assert.assertEquals((Object)new Some((Object)"some value"), this.dataAsString(new StringBuilder(20).append(path).append("/sequence_0000000001").toString()));
    }

    @Test
    public void testPropagateIsrChanges() {
        KafkaZkClient qual$20 = this.zkClient();
        String x$71 = "/isr_change_notification";
        byte[] x$72 = qual$20.createRecursive$default$2();
        boolean x$73 = qual$20.createRecursive$default$3();
        qual$20.createRecursive(x$71, x$72, x$73);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic-a", 0), new TopicPartition("topic-b", 0)})));
        String expectedPath = "/isr_change_notification/isr_change_0000000000";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"topic-a\",\"partition\":0},{\"topic\":\"topic-b\",\"partition\":0}]}"), this.dataAsString(expectedPath));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic-b", 0)})));
        expectedPath = "/isr_change_notification/isr_change_0000000001";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"topic-b\",\"partition\":0}]}"), this.dataAsString(expectedPath));
    }

    @Test
    public void testIsrChangeNotificationGetters() {
        Assert.assertEquals((String)"Failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllIsrChangeNotifications());
        Assert.assertEquals((String)"Failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getPartitionsFromIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        KafkaZkClient qual$21 = this.zkClient();
        String x$74 = "/isr_change_notification";
        byte[] x$75 = qual$21.createRecursive$default$2();
        boolean x$76 = qual$21.createRecursive$default$3();
        qual$21.createRecursive(x$74, x$75, x$76);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10()})));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11(), this.topicPartition10()})), (Object)this.zkClient().getPartitionsFromIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001"}))));
    }

    @Test
    public void testIsrChangeNotificationsDeletion() {
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"})), this.controllerEpochZkVersion());
        KafkaZkClient qual$22 = this.zkClient();
        String x$77 = "/isr_change_notification";
        byte[] x$78 = qual$22.createRecursive$default$2();
        boolean x$79 = qual$22.createRecursive$default$3();
        qual$22.createRecursive(x$77, x$78, x$79);
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10()})));
        this.zkClient().propagateIsrChanges((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition11()})));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), this.controllerEpochZkVersion() + 1), ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001", "0000000002"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), this.controllerEpochZkVersion());
        this.zkClient().deleteIsrChangeNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), (Object)this.zkClient().getAllIsrChangeNotifications().toSet());
        this.zkClient().deleteIsrChangeNotifications(this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllIsrChangeNotifications());
    }

    @Test
    public void testPropagateLogDir() {
        KafkaZkClient qual$23 = this.zkClient();
        String x$80 = "/log_dir_event_notification";
        byte[] x$81 = qual$23.createRecursive$default$2();
        boolean x$82 = qual$23.createRecursive$default$3();
        qual$23.createRecursive(x$80, x$81, x$82);
        int brokerId = 3;
        this.zkClient().propagateLogDirEvent(brokerId);
        String expectedPath = "/log_dir_event_notification/log_dir_event_0000000000";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":3,\"event\":1}"), this.dataAsString(expectedPath));
        this.zkClient().propagateLogDirEvent(brokerId);
        expectedPath = "/log_dir_event_notification/log_dir_event_0000000001";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":3,\"event\":1}"), this.dataAsString(expectedPath));
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        expectedPath = "/log_dir_event_notification/log_dir_event_0000000002";
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)"{\"version\":1,\"broker\":4,\"event\":1}"), this.dataAsString(expectedPath));
    }

    @Test
    public void testLogDirGetters() {
        Assert.assertEquals((String)"getAllLogDirEventNotifications failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllLogDirEventNotifications());
        Assert.assertEquals((String)"getBrokerIdsFromLogDirEvents failed for non existing parent ZK node", (Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getBrokerIdsFromLogDirEvents((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        KafkaZkClient qual$24 = this.zkClient();
        String x$83 = "/log_dir_event_notification";
        byte[] x$84 = qual$24.createRecursive$default$2();
        boolean x$85 = qual$24.createRecursive$default$3();
        qual$24.createRecursive(x$83, x$84, x$85);
        int brokerId = 3;
        this.zkClient().propagateLogDirEvent(brokerId);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getBrokerIdsFromLogDirEvents((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000"}))));
        this.zkClient().propagateLogDirEvent(brokerId);
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        Seq notifications012 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001", "0000000002"}));
        Assert.assertEquals((Object)notifications012.toSet(), (Object)this.zkClient().getAllLogDirEventNotifications().toSet());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 3, 4})), (Object)this.zkClient().getBrokerIdsFromLogDirEvents(notifications012));
    }

    @Test
    public void testLogDirEventNotificationsDeletion() {
        this.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), this.controllerEpochZkVersion());
        KafkaZkClient qual$25 = this.zkClient();
        String x$86 = "/log_dir_event_notification";
        byte[] x$87 = qual$25.createRecursive$default$2();
        boolean x$88 = qual$25.createRecursive$default$3();
        qual$25.createRecursive(x$86, x$87, x$88);
        int brokerId = 3;
        int anotherBrokerId = 4;
        this.zkClient().propagateLogDirEvent(brokerId);
        this.zkClient().propagateLogDirEvent(brokerId);
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), this.controllerEpochZkVersion() + 1), ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000001", "0000000002"})), (Object)this.zkClient().getAllLogDirEventNotifications());
        this.zkClient().deleteLogDirEventNotifications((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000000", "0000000002"})), this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000001"})), (Object)this.zkClient().getAllLogDirEventNotifications());
        this.zkClient().propagateLogDirEvent(anotherBrokerId);
        this.zkClient().deleteLogDirEventNotifications(this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllLogDirEventNotifications());
    }

    @Test
    public void testSetGetAndDeletePartitionReassignment() {
        KafkaZkClient qual$26 = this.zkClient();
        String x$89 = AdminZNode$.MODULE$.path();
        byte[] x$90 = qual$26.createRecursive$default$2();
        boolean x$91 = qual$26.createRecursive$default$3();
        qual$26.createRecursive(x$89, x$90, x$91);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.zkClient().getPartitionReassignment());
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_a", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_a", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_b", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic_c", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 3})))}));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().setOrCreatePartitionReassignment((Map)reassignment, this.controllerEpochZkVersion() + 1), ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        this.zkClient().setOrCreatePartitionReassignment((Map)reassignment, this.controllerEpochZkVersion());
        Assert.assertEquals((Object)reassignment, (Object)this.zkClient().getPartitionReassignment());
        scala.collection.immutable.Map updatedReassignment = (scala.collection.immutable.Map)reassignment.$minus((Object)new TopicPartition("topic_b", 0));
        this.zkClient().setOrCreatePartitionReassignment((Map)updatedReassignment, this.controllerEpochZkVersion());
        Assert.assertEquals((Object)updatedReassignment, (Object)this.zkClient().getPartitionReassignment());
        this.zkClient().deletePartitionReassignment(this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.zkClient().getPartitionReassignment());
        this.zkClient().createPartitionReassignment(reassignment);
        Assert.assertEquals((Object)reassignment, (Object)this.zkClient().getPartitionReassignment());
    }

    @Test
    public void testGetDataAndStat() {
        String path = "/testpath";
        Tuple2 tuple2 = this.zkClient().getDataAndStat(path);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option data0 = (Option)tuple2._1();
        Stat version0 = (Stat)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)data0, (Object)version0);
        Tuple2 tuple23 = tuple22;
        Option data02 = (Option)tuple23._1();
        Stat version02 = (Stat)tuple23._2();
        Assert.assertTrue((boolean)data02.isEmpty());
        Assert.assertEquals((long)0L, (long)version02.getVersion());
        KafkaZkClient qual$27 = this.zkClient();
        String x$92 = path;
        byte[] x$93 = qual$27.createRecursive$default$2();
        boolean x$94 = qual$27.createRecursive$default$3();
        qual$27.createRecursive(x$92, x$93, x$94);
        KafkaZkClient qual$28 = this.zkClient();
        String x$95 = path;
        byte[] x$96 = "version1".getBytes(StandardCharsets.UTF_8);
        int x$97 = 0;
        Option x$98 = qual$28.conditionalUpdatePath$default$4();
        qual$28.conditionalUpdatePath(x$95, x$96, x$97, x$98);
        Tuple2 tuple24 = this.zkClient().getDataAndStat(path);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Option data1 = (Option)tuple24._1();
        Stat version1 = (Stat)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)data1, (Object)version1);
        Tuple2 tuple26 = tuple25;
        Option data12 = (Option)tuple26._1();
        Stat version12 = (Stat)tuple26._2();
        Assert.assertEquals((Object)"version1", (Object)new String((byte[])data12.get(), StandardCharsets.UTF_8));
        Assert.assertEquals((long)1L, (long)version12.getVersion());
        KafkaZkClient qual$29 = this.zkClient();
        String x$99 = path;
        byte[] x$100 = "version2".getBytes(StandardCharsets.UTF_8);
        int x$101 = 1;
        Option x$102 = qual$29.conditionalUpdatePath$default$4();
        qual$29.conditionalUpdatePath(x$99, x$100, x$101, x$102);
        Tuple2 tuple27 = this.zkClient().getDataAndStat(path);
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        Option data2 = (Option)tuple27._1();
        Stat version2 = (Stat)tuple27._2();
        Tuple2 tuple28 = new Tuple2((Object)data2, (Object)version2);
        Tuple2 tuple29 = tuple28;
        Option data22 = (Option)tuple29._1();
        Stat version22 = (Stat)tuple29._2();
        Assert.assertEquals((Object)"version2", (Object)new String((byte[])data22.get(), StandardCharsets.UTF_8));
        Assert.assertEquals((long)2L, (long)version22.getVersion());
    }

    @Test
    public void testGetChildren() {
        String path = "/testpath";
        Assert.assertTrue((boolean)this.zkClient().getChildren(path).isEmpty());
        KafkaZkClient qual$30 = this.zkClient();
        String x$103 = "/testpath/child1";
        byte[] x$104 = qual$30.createRecursive$default$2();
        boolean x$105 = qual$30.createRecursive$default$3();
        qual$30.createRecursive(x$103, x$104, x$105);
        KafkaZkClient qual$31 = this.zkClient();
        String x$106 = "/testpath/child2";
        byte[] x$107 = qual$31.createRecursive$default$2();
        boolean x$108 = qual$31.createRecursive$default$3();
        qual$31.createRecursive(x$106, x$107, x$108);
        KafkaZkClient qual$32 = this.zkClient();
        String x$109 = "/testpath/child3";
        byte[] x$110 = qual$32.createRecursive$default$2();
        boolean x$111 = qual$32.createRecursive$default$3();
        qual$32.createRecursive(x$109, x$110, x$111);
        Seq children = this.zkClient().getChildren(path);
        Assert.assertEquals((long)3L, (long)children.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"child1", "child2", "child3"})), (Object)children.toSet());
    }

    @Test
    public void testAclManagementMethods() {
        ZkAclStore$.MODULE$.stores().foreach((Function1 & Serializable & scala.Serializable)store -> {
            KafkaZkClientTest.$anonfun$testAclManagementMethods$1(this, store);
            return BoxedUnit.UNIT;
        });
        this.zkClient().createAclPaths();
        ZkAclStore$.MODULE$.stores().foreach((Function1 & Serializable & scala.Serializable)store -> {
            KafkaZkClientTest.$anonfun$testAclManagementMethods$3(this, store);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeletePath() {
        String path = "/a/b/c";
        KafkaZkClient qual$33 = this.zkClient();
        String x$112 = path;
        byte[] x$113 = qual$33.createRecursive$default$2();
        boolean x$114 = qual$33.createRecursive$default$3();
        qual$33.createRecursive(x$112, x$113, x$114);
        this.zkClient().deletePath(path);
        Assert.assertFalse((boolean)this.zkClient().pathExists(path));
    }

    @Test
    public void testDeleteTopicZNode() {
        this.zkClient().deleteTopicZNode(this.topic1(), this.controllerEpochZkVersion());
        KafkaZkClient qual$34 = this.zkClient();
        String x$115 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$116 = qual$34.createRecursive$default$2();
        boolean x$117 = qual$34.createRecursive$default$3();
        qual$34.createRecursive(x$115, x$116, x$117);
        this.zkClient().deleteTopicZNode(this.topic1(), this.controllerEpochZkVersion());
        Assert.assertFalse((boolean)this.zkClient().pathExists(TopicZNode$.MODULE$.path(this.topic1())));
    }

    @Test
    public void testDeleteTopicPathMethods() {
        Assert.assertFalse((boolean)this.zkClient().isTopicMarkedForDeletion(this.topic1()));
        Assert.assertTrue((boolean)this.zkClient().getTopicDeletions().isEmpty());
        this.zkClient().createDeleteTopicPath(this.topic1());
        this.zkClient().createDeleteTopicPath(this.topic2());
        Assert.assertTrue((boolean)this.zkClient().isTopicMarkedForDeletion(this.topic1()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getTopicDeletions().toSet());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().deleteTopicDeletions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), this.controllerEpochZkVersion() + 1), ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getTopicDeletions().toSet());
        this.zkClient().deleteTopicDeletions((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), this.controllerEpochZkVersion());
        Assert.assertTrue((boolean)this.zkClient().getTopicDeletions().isEmpty());
    }

    private void assertPathExistenceAndData(String expectedPath, String data) {
        Assert.assertTrue((boolean)this.zkClient().pathExists(expectedPath));
        Assert.assertEquals((Object)new Some((Object)data), this.dataAsString(expectedPath));
    }

    @Test
    public void testCreateTokenChangeNotification() {
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().createTokenChangeNotification("delegationToken"), ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
        this.zkClient().createDelegationTokenPaths();
        this.zkClient().createTokenChangeNotification("delegationToken");
        this.assertPathExistenceAndData("/delegation_token/token_changes/token_change_0000000000", "delegationToken");
    }

    @Test
    public void testEntityConfigManagementMethods() {
        Assert.assertTrue((boolean)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()).isEmpty());
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1(), this.logProps());
        Assert.assertEquals((Object)this.logProps(), (Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()));
        this.logProps().remove(LogConfig$.MODULE$.CleanupPolicyProp());
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1(), this.logProps());
        Assert.assertEquals((Object)this.logProps(), (Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic2(), this.logProps());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getAllEntitiesWithConfig(ConfigType$.MODULE$.Topic()).toSet());
        this.zkClient().deleteTopicConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), this.controllerEpochZkVersion());
        Assert.assertTrue((boolean)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1()).isEmpty());
    }

    @Test
    public void testCreateConfigChangeNotification() {
        Assert.assertFalse((boolean)this.zkClient().pathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path()));
        this.zkClient().createConfigChangeNotification(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), this.topic1()));
        this.assertPathExistenceAndData("/config/changes/config_change_0000000000", "{\"version\":2,\"entity_path\":\"/config/topics/topic1\"}");
        this.zkClient().createConfigChangeNotification(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), this.topic2()));
        this.assertPathExistenceAndData("/config/changes/config_change_0000000001", "{\"version\":2,\"entity_path\":\"/config/topics/topic2\"}");
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProps(int bytesProp) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)bytesProp)).toString());
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)bytesProp)).toString());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        return var2_2;
    }

    private Properties logProps() {
        return this.logProps;
    }

    @Test
    public void testGetLogConfigs() {
        LogConfig emptyConfig = new LogConfig(Collections.emptyMap(), LogConfig$.MODULE$.apply$default$2());
        Assert.assertEquals((String)"Non existent config, no defaults", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)emptyConfig)})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), Collections.emptyMap()));
        Properties logProps2 = this.createLogProps(2048);
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic1(), this.logProps());
        Assert.assertEquals((String)"One existing and one non-existent topic", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), (Object)emptyConfig)})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), Collections.emptyMap()));
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic2(), logProps2);
        Assert.assertEquals((String)"Two existing topics", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic2()), (Object)new LogConfig((java.util.Map)logProps2, LogConfig$.MODULE$.apply$default$2()))})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), Collections.emptyMap()));
        Properties logProps1WithMoreValues = this.createLogProps(1024);
        logProps1WithMoreValues.put(LogConfig$.MODULE$.SegmentJitterMsProp(), "100");
        logProps1WithMoreValues.put(LogConfig$.MODULE$.SegmentBytesProp(), "1024");
        Assert.assertEquals((String)"Config with defaults", (Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic1()), (Object)new LogConfig((java.util.Map)logProps1WithMoreValues, LogConfig$.MODULE$.apply$default$2()))})), (Object)Predef$.MODULE$.Map().empty()), (Object)this.zkClient().getLogConfigs((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp()), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"128")}))).asJava()));
    }

    private BrokerInfo createBrokerInfo(int id, String host, int port, SecurityProtocol securityProtocol, Option<String> rack) {
        return BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol)})), rack), ApiVersion$.MODULE$.latestVersion(), port + 10);
    }

    private Option<String> createBrokerInfo$default$5() {
        return None$.MODULE$;
    }

    @Test
    public void testRegisterBrokerInfo() {
        this.zkClient().createTopLevelPaths();
        BrokerInfo brokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        BrokerInfo differentBrokerInfoWithSameId = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().registerBroker(brokerInfo);
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        Assert.assertEquals((String)"Other ZK clients can read broker info", (Object)new Some((Object)brokerInfo.broker()), (Object)this.otherZkClient().getBroker(1));
        this.zkClient().registerBroker(differentBrokerInfoWithSameId);
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.otherZkClient().registerBroker(differentBrokerInfoWithSameId), ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
        Assert.assertEquals((Object)new Some((Object)brokerInfo.broker()), (Object)this.zkClient().getBroker(1));
    }

    @Test
    public void testGetBrokerMethods() {
        this.zkClient().createTopLevelPaths();
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getAllBrokersInCluster());
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getSortedBrokerList());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getBroker(0));
        BrokerInfo brokerInfo0 = this.createBrokerInfo(0, "test.host0", 9998, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        BrokerInfo brokerInfo1 = this.createBrokerInfo(1, "test.host1", 9999, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().registerBroker(brokerInfo1);
        this.otherZkClient().registerBroker(brokerInfo0);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getSortedBrokerList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{brokerInfo0.broker(), brokerInfo1.broker()})), (Object)this.zkClient().getAllBrokersInCluster());
        Assert.assertEquals((Object)new Some((Object)brokerInfo0.broker()), (Object)this.zkClient().getBroker(0));
    }

    @Test
    public void testUpdateBrokerInfo() {
        this.zkClient().createTopLevelPaths();
        BrokerInfo originalBrokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, this.createBrokerInfo$default$5());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().updateBrokerInfo(originalBrokerInfo), ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 714));
        this.zkClient().registerBroker(originalBrokerInfo);
        BrokerInfo updatedBrokerInfo = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, this.createBrokerInfo$default$5());
        this.zkClient().updateBrokerInfo(updatedBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)updatedBrokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        this.otherZkClient().updateBrokerInfo(originalBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)originalBrokerInfo.broker()), (Object)this.otherZkClient().getBroker(1));
    }

    /*
     * WARNING - void declaration
     */
    private Stat statWithVersion(int version) {
        void var2_2;
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        stat.setVersion(version);
        return var2_2;
    }

    private scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs(int state, int zkVersion) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(1, state, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2 + state, 3 + state})), zkVersion), 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new LeaderIsrAndControllerEpoch(new LeaderAndIsr(0, state + 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1 + state, 2 + state})), zkVersion), 4))}));
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> initialLeaderIsrAndControllerEpochs() {
        return this.initialLeaderIsrAndControllerEpochs;
    }

    public scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> initialLeaderIsrs() {
        return this.initialLeaderIsrs;
    }

    private scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> leaderIsrs(int state, int zkVersion) {
        return this.leaderIsrAndControllerEpochs(state, zkVersion).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> x$8.leaderAndIsr());
    }

    private void checkUpdateLeaderAndIsrResult(scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> expectedSuccessfulPartitions, Seq<TopicPartition> expectedPartitionsToRetry, scala.collection.immutable.Map<TopicPartition, Tuple2<Class<?>, String>> expectedFailedPartitions, KafkaZkClient.UpdateLeaderAndIsrResult actualUpdateLeaderAndIsrResult) {
        scala.collection.immutable.Map failedPartitionsExcerpt = actualUpdateLeaderAndIsrResult.failedPartitions().mapValues((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e.getClass(), (Object)e.getMessage()));
        Assert.assertEquals((String)"Permanently failed updates do not match expected", expectedFailedPartitions, (Object)failedPartitionsExcerpt);
        Assert.assertEquals((String)"Retriable updates (due to BADVERSION) do not match expected", expectedPartitionsToRetry, (Object)actualUpdateLeaderAndIsrResult.partitionsToRetry());
        Assert.assertEquals((String)"Successful updates do not match expected", expectedSuccessfulPartitions, (Object)actualUpdateLeaderAndIsrResult.successfulPartitions());
    }

    @Test
    public void testUpdateLeaderAndIsr() {
        KafkaZkClient qual$35 = this.zkClient();
        String x$118 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$119 = qual$35.createRecursive$default$2();
        boolean x$120 = qual$35.createRecursive$default$3();
        qual$35.createRecursive(x$118, x$119, x$120);
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)Predef$.MODULE$.Map().empty(), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.empty()), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic1/partitions/0/state")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic1/partitions/1/state"))})), this.zkClient().updateLeaderAndIsr(this.initialLeaderIsrs(), 4, this.controllerEpochZkVersion()));
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> this.zkClient().updateLeaderAndIsr(this.initialLeaderIsrs(), 4, this.controllerEpochZkVersion() + 1), ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
        this.checkUpdateLeaderAndIsrResult(this.leaderIsrs(1, 1), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.empty()), Predef$.MODULE$.Map().empty(), this.zkClient().updateLeaderAndIsr(this.leaderIsrs(1, 0), 4, this.controllerEpochZkVersion()));
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)Predef$.MODULE$.Map().empty(), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}))), Predef$.MODULE$.Map().empty(), this.zkClient().updateLeaderAndIsr(this.leaderIsrs(1, 0), 4, this.controllerEpochZkVersion()));
        scala.collection.immutable.Map mixedState = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), (Object)new LeaderAndIsr(1, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition11()), (Object)new LeaderAndIsr(0, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), 0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition20()), (Object)new LeaderAndIsr(0, 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), 0))}));
        this.checkUpdateLeaderAndIsrResult((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)this.leaderIsrs(2, 2).filterKeys((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)KafkaZkClientTest.$anonfun$testUpdateLeaderAndIsr$2(this, x$9))), (Seq<TopicPartition>)((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition11()}))), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition20()), (Object)new Tuple2(KeeperException.NoNodeException.class, (Object)"KeeperErrorCode = NoNode for /brokers/topics/topic2/partitions/0/state"))})), this.zkClient().updateLeaderAndIsr(mixedState, 4, this.controllerEpochZkVersion()));
    }

    private void checkGetDataResponse(scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs, TopicPartition topicPartition, GetDataResponse response) {
        int zkVersion = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochs.apply((Object)topicPartition)).leaderAndIsr().zkVersion();
        Assert.assertEquals((Object)KeeperException.Code.OK, (Object)response.resultCode());
        Assert.assertEquals((Object)TopicPartitionStateZNode$.MODULE$.path(topicPartition), (Object)response.path());
        Assert.assertEquals((Object)new Some((Object)topicPartition), (Object)response.ctx());
        Assert.assertEquals((Object)new Some(leaderIsrAndControllerEpochs.apply((Object)topicPartition)), (Object)TopicPartitionStateZNode$.MODULE$.decode(response.data(), this.statWithVersion(zkVersion)));
    }

    private CreateResponse eraseUncheckedInfoInCreateResponse(CreateResponse response) {
        ResponseMetadata x$121 = new ResponseMetadata(0L, 0L);
        None$ x$122 = None$.MODULE$;
        KeeperException.Code x$123 = response.copy$default$1();
        String x$124 = response.copy$default$2();
        Option x$125 = response.copy$default$3();
        String x$126 = response.copy$default$4();
        return response.copy(x$123, x$124, x$125, x$126, x$121, (Option)x$122);
    }

    @Test
    public void testGetTopicsAndPartitions() {
        Assert.assertTrue((boolean)this.zkClient().getAllTopicsInCluster().isEmpty());
        Assert.assertTrue((boolean)this.zkClient().getAllPartitions().isEmpty());
        KafkaZkClient qual$36 = this.zkClient();
        String x$127 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$128 = qual$36.createRecursive$default$2();
        boolean x$129 = qual$36.createRecursive$default$3();
        qual$36.createRecursive(x$127, x$128, x$129);
        KafkaZkClient qual$37 = this.zkClient();
        String x$130 = TopicZNode$.MODULE$.path(this.topic2());
        byte[] x$131 = qual$37.createRecursive$default$2();
        boolean x$132 = qual$37.createRecursive$default$3();
        qual$37.createRecursive(x$130, x$131, x$132);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1(), this.topic2()})), (Object)this.zkClient().getAllTopicsInCluster().toSet());
        Assert.assertTrue((boolean)this.zkClient().getAllPartitions().isEmpty());
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()})), (Object)this.zkClient().getAllPartitions());
    }

    @Test
    public void testCreateAndGetTopicPartitionStatesRaw() {
        KafkaZkClient qual$38 = this.zkClient();
        String x$133 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$134 = qual$38.createRecursive$default$2();
        boolean x$135 = qual$38.createRecursive$default$3();
        qual$38.createRecursive(x$133, x$134, x$135);
        this.intercept((Function0 & Serializable & scala.Serializable)() -> this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion() + 1), ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.OK, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), (Option)new Some((Object)this.topicPartition10()), TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6()), new CreateResponse(KeeperException.Code.OK, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), (Option)new Some((Object)this.topicPartition11()), TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6())})), (Object)((TraversableOnce)this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion()).map((Function1 & Serializable & scala.Serializable)response -> this.eraseUncheckedInfoInCreateResponse((CreateResponse)response), Seq$.MODULE$.canBuildFrom())).toList());
        Seq getResponses = this.zkClient().getTopicPartitionStatesRaw(this.topicPartitions10_11());
        Assert.assertEquals((long)2L, (long)getResponses.size());
        ((IterableLike)this.topicPartitions10_11().zip((GenIterable)getResponses, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaZkClientTest.$anonfun$testCreateAndGetTopicPartitionStatesRaw$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateResponse[]{new CreateResponse(KeeperException.Code.NODEEXISTS, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition10()), (Option)new Some((Object)this.topicPartition10()), null, new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6()), new CreateResponse(KeeperException.Code.NODEEXISTS, TopicPartitionStateZNode$.MODULE$.path(this.topicPartition11()), (Option)new Some((Object)this.topicPartition11()), null, new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6())})), (Object)((TraversableOnce)this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion()).map((Function1 & Serializable & scala.Serializable)response -> this.eraseUncheckedInfoInCreateResponse((CreateResponse)response), Seq$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testSetTopicPartitionStatesRaw() {
        KafkaZkClient qual$39 = this.zkClient();
        String x$136 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$137 = qual$39.createRecursive$default$2();
        boolean x$138 = qual$39.createRecursive$default$3();
        qual$39.createRecursive(x$136, x$137, x$138);
        Assert.assertEquals((Object)KafkaZkClientTest.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.NONODE, null), (Object)((TraversableOnce)this.zkClient().setTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion()).map((Function1 & Serializable & scala.Serializable)x$10 -> {
            ResponseMetadata x$139 = new ResponseMetadata(0L, 0L);
            None$ x$140 = None$.MODULE$;
            KeeperException.Code x$141 = x$10.copy$default$1();
            String x$142 = x$10.copy$default$2();
            Option x$143 = x$10.copy$default$3();
            Stat x$144 = x$10.copy$default$4();
            return x$10.copy(x$141, x$142, x$143, x$144, x$139, (Option)x$140);
        }, Seq$.MODULE$.canBuildFrom())).toList());
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion());
        Assert.assertEquals((Object)KafkaZkClientTest.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.OK, this.statWithVersion(1)), (Object)((TraversableOnce)this.zkClient().setTopicPartitionStatesRaw(this.leaderIsrAndControllerEpochs(1, 0), this.controllerEpochZkVersion()).map((Function1 & Serializable & scala.Serializable)response -> this.eraseUncheckedInfoInSetDataResponse((SetDataResponse)response), Seq$.MODULE$.canBuildFrom())).toList());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> this.zkClient().setTopicPartitionStatesRaw(this.leaderIsrAndControllerEpochs(1, 0), this.controllerEpochZkVersion() + 1), ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
        Seq getResponses = this.zkClient().getTopicPartitionStatesRaw(this.topicPartitions10_11());
        Assert.assertEquals((long)2L, (long)getResponses.size());
        ((IterableLike)this.topicPartitions10_11().zip((GenIterable)getResponses, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            KafkaZkClientTest.$anonfun$testSetTopicPartitionStatesRaw$5(this, x0$2);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)KafkaZkClientTest.expectedSetDataResponses$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}), KeeperException.Code.OK, this.statWithVersion(2)), (Object)((TraversableOnce)this.otherZkClient().setTopicPartitionStatesRaw(this.leaderIsrAndControllerEpochs(2, 1), this.controllerEpochZkVersion()).map((Function1 & Serializable & scala.Serializable)response -> this.eraseUncheckedInfoInSetDataResponse((SetDataResponse)response), Seq$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testReassignPartitionsInProgress() {
        Assert.assertFalse((boolean)this.zkClient().reassignPartitionsInProgress());
        KafkaZkClient qual$40 = this.zkClient();
        String x$145 = ReassignPartitionsZNode$.MODULE$.path();
        byte[] x$146 = qual$40.createRecursive$default$2();
        boolean x$147 = qual$40.createRecursive$default$3();
        qual$40.createRecursive(x$145, x$146, x$147);
        Assert.assertTrue((boolean)this.zkClient().reassignPartitionsInProgress());
    }

    @Test
    public void testGetTopicPartitionStates() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionState(this.topicPartition10()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getLeaderForPartition(this.topicPartition10()));
        KafkaZkClient qual$41 = this.zkClient();
        String x$148 = TopicZNode$.MODULE$.path(this.topic1());
        byte[] x$149 = qual$41.createRecursive$default$2();
        boolean x$150 = qual$41.createRecursive$default$3();
        qual$41.createRecursive(x$148, x$149, x$150);
        this.zkClient().createTopicPartitionStatesRaw(this.initialLeaderIsrAndControllerEpochs(), this.controllerEpochZkVersion());
        Assert.assertEquals(this.initialLeaderIsrAndControllerEpochs(), (Object)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), this.topicPartition11()}))));
        Assert.assertEquals((Object)new Some(this.initialLeaderIsrAndControllerEpochs().apply((Object)this.topicPartition10())), (Object)this.zkClient().getTopicPartitionState(this.topicPartition10()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.zkClient().getLeaderForPartition(this.topicPartition10()));
        TopicPartition notExistingPartition = new TopicPartition(this.topic1(), 2);
        Assert.assertTrue((boolean)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{notExistingPartition}))).isEmpty());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition10()), this.initialLeaderIsrAndControllerEpochs().apply((Object)this.topicPartition10()))})), (Object)this.zkClient().getTopicPartitionStates((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition10(), notExistingPartition}))));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionState(notExistingPartition));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getLeaderForPartition(notExistingPartition));
    }

    private SetDataResponse eraseUncheckedInfoInSetDataResponse(SetDataResponse response) {
        Stat stat = response.stat() != null ? this.statWithVersion(response.stat().getVersion()) : null;
        ResponseMetadata x$151 = new ResponseMetadata(0L, 0L);
        Stat x$152 = stat;
        None$ x$153 = None$.MODULE$;
        KeeperException.Code x$154 = response.copy$default$1();
        String x$155 = response.copy$default$2();
        Option x$156 = response.copy$default$3();
        return response.copy(x$154, x$155, x$156, x$152, x$151, (Option)x$153);
    }

    @Test
    public void testControllerEpochMethods() {
        this.zkClient().deletePath(ControllerEpochZNode$.MODULE$.path());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerEpoch());
        Assert.assertEquals((String)"Setting non existing nodes should return NONODE results", (Object)new SetDataResponse(KeeperException.Code.NONODE, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L), SetDataResponse$.MODULE$.apply$default$6()), (Object)this.eraseUncheckedInfoInSetDataResponse(this.zkClient().setControllerEpochRaw(1, 0)));
        Assert.assertEquals((String)"Creating non existing nodes is OK", (Object)new CreateResponse(KeeperException.Code.OK, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, ControllerEpochZNode$.MODULE$.path(), new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6()), (Object)this.eraseUncheckedInfoInCreateResponse(this.zkClient().createControllerEpochRaw(0)));
        Assert.assertEquals((long)0L, (long)((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        Assert.assertEquals((String)"Attemt to create existing nodes should return NODEEXISTS", (Object)new CreateResponse(KeeperException.Code.NODEEXISTS, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L), CreateResponse$.MODULE$.apply$default$6()), (Object)this.eraseUncheckedInfoInCreateResponse(this.zkClient().createControllerEpochRaw(0)));
        Assert.assertEquals((String)"Updating existing nodes is OK", (Object)new SetDataResponse(KeeperException.Code.OK, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, this.statWithVersion(1), new ResponseMetadata(0L, 0L), SetDataResponse$.MODULE$.apply$default$6()), (Object)this.eraseUncheckedInfoInSetDataResponse(this.zkClient().setControllerEpochRaw(1, 0)));
        Assert.assertEquals((long)1L, (long)((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        Assert.assertEquals((String)"Updating with wrong ZK version returns BADVERSION", (Object)new SetDataResponse(KeeperException.Code.BADVERSION, ControllerEpochZNode$.MODULE$.path(), (Option)None$.MODULE$, null, new ResponseMetadata(0L, 0L), SetDataResponse$.MODULE$.apply$default$6()), (Object)this.eraseUncheckedInfoInSetDataResponse(this.zkClient().setControllerEpochRaw(1, 0)));
    }

    @Test
    public void testControllerManagementMethods() {
        int newEpochZkVersion;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerId());
        Tuple2 tuple2 = this.zkClient().registerControllerAndIncrementControllerEpoch(1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = newEpochZkVersion = tuple2._2$mcI$sp();
        int newEpochZkVersion2 = n;
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.zkClient().getControllerId());
        this.zkClient().deleteController(newEpochZkVersion2);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getControllerId());
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        String mockPath = "/foo";
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(null, mockPath, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = mockPath$1;
            }
        };
        this.zkClient().registerZNodeChangeHandlerAndCheckExistence(zNodeChangeHandler);
        KafkaZkClient qual$42 = this.zkClient();
        String x$157 = mockPath;
        byte[] x$158 = qual$42.createRecursive$default$2();
        boolean x$159 = qual$42.createRecursive$default$3();
        qual$42.createRecursive(x$157, x$158, x$159);
        Assert.assertTrue((String)"Failed to receive create notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testClusterIdMethods() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        this.zkClient().createOrGetClusterId(clusterId);
        Assert.assertEquals((Object)clusterId, (Object)this.zkClient().getClusterId().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("No cluster id found", new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1016))));
    }

    @Test
    public void testBrokerSequenceIdMethods() {
        int sequenceId = this.zkClient().generateBrokerSequenceId();
        Assert.assertEquals((long)(sequenceId + 1), (long)this.zkClient().generateBrokerSequenceId());
    }

    @Test
    public void testCreateTopLevelPaths() {
        this.zkClient().createTopLevelPaths();
        ZkData$.MODULE$.PersistentZkPaths().foreach((Function1 & Serializable & scala.Serializable)path -> {
            KafkaZkClientTest.$anonfun$testCreateTopLevelPaths$1(this, path);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPreferredReplicaElectionMethods() {
        Assert.assertTrue((boolean)this.zkClient().getPreferredReplicaElection().isEmpty());
        scala.collection.immutable.Set electionPartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0), new TopicPartition(this.topic1(), 1)}));
        this.zkClient().createPreferredReplicaElection(electionPartitions);
        Assert.assertEquals((Object)electionPartitions, (Object)this.zkClient().getPreferredReplicaElection());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().createPreferredReplicaElection(electionPartitions), ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1042));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkClient().deletePreferredReplicaElection(this.controllerEpochZkVersion() + 1), ClassTag$.MODULE$.apply(ControllerMovedException.class), new Position("KafkaZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1047));
        Assert.assertEquals((Object)electionPartitions, (Object)this.zkClient().getPreferredReplicaElection());
        this.zkClient().deletePreferredReplicaElection(this.controllerEpochZkVersion());
        Assert.assertTrue((boolean)this.zkClient().getPreferredReplicaElection().isEmpty());
    }

    private Option<String> dataAsString(String path) {
        Option data;
        Tuple2 tuple2 = this.zkClient().getDataAndStat(path);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option option = data = (Option)tuple2._1();
        Option data2 = option;
        return data2.map((Function1 & Serializable & scala.Serializable)x$11 -> new String((byte[])x$11, StandardCharsets.UTF_8));
    }

    @Test
    public void testDelegationTokenMethods() {
        Assert.assertFalse((boolean)this.zkClient().pathExists(DelegationTokensZNode$.MODULE$.path()));
        Assert.assertFalse((boolean)this.zkClient().pathExists(DelegationTokenChangeNotificationZNode$.MODULE$.path()));
        this.zkClient().createDelegationTokenPaths();
        Assert.assertTrue((boolean)this.zkClient().pathExists(DelegationTokensZNode$.MODULE$.path()));
        Assert.assertTrue((boolean)this.zkClient().pathExists(DelegationTokenChangeNotificationZNode$.MODULE$.path()));
        String tokenId = "token1";
        KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        .colon.colon renewers = new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:renewer1"), (List)new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:renewer1"), (List)Nil$.MODULE$));
        TokenInformation tokenInfo = new TokenInformation(tokenId, owner, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)renewers).asJava(), System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        byte[] bytes = new byte[20];
        Random$.MODULE$.nextBytes(bytes);
        DelegationToken token = new DelegationToken(tokenInfo, bytes);
        Assert.assertTrue((boolean)this.zkClient().getDelegationTokenInfo(tokenId).isEmpty());
        Assert.assertFalse((boolean)this.zkClient().deleteDelegationToken(tokenId));
        this.zkClient().setOrCreateDelegationToken(token);
        Assert.assertEquals((Object)tokenInfo, (Object)this.zkClient().getDelegationTokenInfo(tokenId).get());
        tokenInfo.setExpiryTimestamp(System.currentTimeMillis());
        this.zkClient().setOrCreateDelegationToken(token);
        Assert.assertEquals((Object)tokenInfo, (Object)this.zkClient().getDelegationTokenInfo(tokenId).get());
        Assert.assertTrue((boolean)this.zkClient().deleteDelegationToken(tokenId));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getDelegationTokenInfo(tokenId));
    }

    @Test
    public void testConsumerOffsetPath() {
        String consumerGroup = "test-group";
        String topic = "test-topic";
        int partition = 2;
        String expectedConsumerGroupOffsetsPath = KafkaZkClientTest.getConsumersOffsetsZkPath$1(consumerGroup, topic, partition);
        String actualConsumerGroupOffsetsPath = ConsumerOffset$.MODULE$.path(consumerGroup, topic, Predef$.MODULE$.int2Integer(partition));
        Assert.assertEquals((Object)expectedConsumerGroupOffsetsPath, (Object)actualConsumerGroupOffsetsPath);
    }

    public static final /* synthetic */ void $anonfun$testAclManagementMethods$2(KafkaZkClientTest $this, ZkAclStore store$1, ResourceType resource) {
        Assert.assertFalse((boolean)$this.zkClient().pathExists(store$1.path(resource)));
    }

    public static final /* synthetic */ void $anonfun$testAclManagementMethods$1(KafkaZkClientTest $this, ZkAclStore store) {
        Assert.assertFalse((boolean)$this.zkClient().pathExists(store.aclPath()));
        Assert.assertFalse((boolean)$this.zkClient().pathExists(store.changeStore().aclChangePath()));
        ResourceType$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)resource -> {
            KafkaZkClientTest.$anonfun$testAclManagementMethods$2($this, store, resource);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testAclManagementMethods$4(KafkaZkClientTest $this, ZkAclStore store$2, ResourceType resource) {
        Assert.assertTrue((boolean)$this.zkClient().pathExists(store$2.path(resource)));
    }

    public static final /* synthetic */ void $anonfun$testAclManagementMethods$3(KafkaZkClientTest $this, ZkAclStore store) {
        Assert.assertTrue((boolean)$this.zkClient().pathExists(store.aclPath()));
        Assert.assertTrue((boolean)$this.zkClient().pathExists(store.changeStore().aclChangePath()));
        ResourceType$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)resource -> {
            KafkaZkClientTest.$anonfun$testAclManagementMethods$4($this, store, resource);
            return BoxedUnit.UNIT;
        });
        Resource resource1 = new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString(), store.patternType());
        Resource resource2 = new Resource((ResourceType)Topic$.MODULE$, UUID.randomUUID().toString(), store.patternType());
        SimpleAclAuthorizer.VersionedAcls versionedAcls = $this.zkClient().getVersionedAclsForResource(resource1);
        Assert.assertTrue((boolean)versionedAcls.acls().isEmpty());
        Assert.assertEquals((long)ZkVersion$.MODULE$.UnknownVersion(), (long)versionedAcls.zkVersion());
        Assert.assertFalse((boolean)$this.zkClient().resourceExists(resource1));
        Acl acl1 = new Acl(new KafkaPrincipal("User", "alice"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Allow$.MODULE$, "*", (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Assert.assertFalse((boolean)$this.zkClient().conditionalSetAclsForResource(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), 0)._1$mcZ$sp());
        Assert.assertTrue((boolean)$this.zkClient().createAclsForResourceIfNotExists(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})))._1$mcZ$sp());
        Assert.assertTrue((boolean)$this.zkClient().createAclsForResourceIfNotExists(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})))._1$mcZ$sp());
        Assert.assertFalse((boolean)$this.zkClient().createAclsForResourceIfNotExists(resource2, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})))._1$mcZ$sp());
        versionedAcls = $this.zkClient().getVersionedAclsForResource(resource1);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2})), (Object)versionedAcls.acls());
        Assert.assertEquals((long)0L, (long)versionedAcls.zkVersion());
        Assert.assertTrue((boolean)$this.zkClient().resourceExists(resource1));
        Assert.assertTrue((boolean)$this.zkClient().conditionalSetAclsForResource(resource1, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), 0)._1$mcZ$sp());
        versionedAcls = $this.zkClient().getVersionedAclsForResource(resource1);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl3})), (Object)versionedAcls.acls());
        Assert.assertEquals((long)1L, (long)versionedAcls.zkVersion());
        scala.collection.immutable.Set set = ((TraversableOnce)ResourceType$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)rt -> rt.name(), Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set set2 = $this.zkClient().getResourceTypes(store.patternType()).toSet();
        Assert.assertTrue((!(set != null ? !set.equals(set2) : set2 != null) ? 1 : 0) != 0);
        Seq resourceNames = $this.zkClient().getResourceNames(store.patternType(), (ResourceType)Topic$.MODULE$);
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resource1.name(), resource2.name()}));
        scala.collection.immutable.Set set3 = resourceNames.toSet();
        Assert.assertTrue((!(genTraversable != null ? !genTraversable.equals(set3) : set3 != null) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)$this.zkClient().deleteResource(resource1));
        Assert.assertFalse((boolean)$this.zkClient().resourceExists(resource1));
        Assert.assertFalse((boolean)$this.zkClient().conditionalDelete(resource2, 10));
        Assert.assertTrue((boolean)$this.zkClient().conditionalDelete(resource2, 0));
        $this.zkClient().createAclChangeNotification(new Resource((ResourceType)Group$.MODULE$, "resource1", store.patternType()));
        $this.zkClient().createAclChangeNotification(new Resource((ResourceType)Topic$.MODULE$, "resource2", store.patternType()));
        Assert.assertEquals((long)2L, (long)$this.zkClient().getChildren(store.changeStore().aclChangePath()).size());
        $this.zkClient().deleteAclChangeNotifications();
        Assert.assertTrue((boolean)$this.zkClient().getChildren(store.changeStore().aclChangePath()).isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateLeaderAndIsr$2(KafkaZkClientTest $this, TopicPartition x$9) {
        TopicPartition topicPartition = x$9;
        TopicPartition topicPartition2 = $this.topicPartition10();
        return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
    }

    public static final /* synthetic */ void $anonfun$testCreateAndGetTopicPartitionStatesRaw$3(KafkaZkClientTest $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        GetDataResponse r = (GetDataResponse)tuple2._2();
        $this.checkGetDataResponse($this.initialLeaderIsrAndControllerEpochs(), tp, r);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Seq expectedSetDataResponses$1(Seq topicPartitions, KeeperException.Code resultCode, Stat stat) {
        return (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)topicPartition -> new SetDataResponse(resultCode, TopicPartitionStateZNode$.MODULE$.path(topicPartition), (Option)new Some(topicPartition), stat, new ResponseMetadata(0L, 0L), (Option)None$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testSetTopicPartitionStatesRaw$5(KafkaZkClientTest $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        GetDataResponse r = (GetDataResponse)tuple2._2();
        $this.checkGetDataResponse($this.leaderIsrAndControllerEpochs(1, 0), tp, r);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testCreateTopLevelPaths$1(KafkaZkClientTest $this, String path) {
        Assert.assertTrue((boolean)$this.zkClient().pathExists(path));
    }

    private static final String getConsumersOffsetsZkPath$1(String consumerGroup, String topic, int partition) {
        return new StringBuilder(21).append("/consumers/").append(consumerGroup).append("/offsets/").append(topic).append("/").append(partition).toString();
    }

    public KafkaZkClientTest() {
        this.group = "my-group";
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.controllerEpochZkVersion = 0;
    }
}

