/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import java.nio.charset.StandardCharsets;
import kafka.security.auth.Group$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.Topic$;
import kafka.zk.AclChangeNode;
import kafka.zk.LiteralAclStore$;
import org.apache.kafka.common.resource.PatternType;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u000f\t\u0019B*\u001b;fe\u0006d\u0017i\u00197Ti>\u0014X\rV3ti*\u00111\u0001B\u0001\u0003u.T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013%Q#A\bmSR,'/\u00197SKN|WO]2f+\u00051\u0002CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011\tW\u000f\u001e5\u000b\u0005m!\u0011\u0001C:fGV\u0014\u0018\u000e^=\n\u0005uA\"\u0001\u0003*fg>,(oY3\t\r}\u0001\u0001\u0015!\u0003\u0017\u0003Aa\u0017\u000e^3sC2\u0014Vm]8ve\u000e,\u0007\u0005C\u0004\"\u0001\t\u0007I\u0011B\u000b\u0002!A\u0014XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007BB\u0012\u0001A\u0003%a#A\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0002Bq!\n\u0001C\u0002\u0013%a%A\u0003ti>\u0014X-F\u0001(\u001d\t\u0011\u0002&\u0003\u0002*\u0005\u0005yA*\u001b;fe\u0006d\u0017i\u00197Ti>\u0014X\r\u0003\u0004,\u0001\u0001\u0006IaJ\u0001\u0007gR|'/\u001a\u0011\t\u000b5\u0002A\u0011\u0001\u0018\u0002-MDw.\u001e7e\u0011\u00064XmQ8se\u0016\u001cG\u000fU1uQN$\u0012a\f\t\u0003\u0013AJ!!\r\u0006\u0003\tUs\u0017\u000e\u001e\u0015\u0003YM\u0002\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u000b),h.\u001b;\u000b\u0003a\n1a\u001c:h\u0013\tQTG\u0001\u0003UKN$\b\"\u0002\u001f\u0001\t\u0003q\u0013\u0001H:i_VdG\rS1wK\u000e{'O]3diB\u000bG\u000f^3s]RK\b/\u001a\u0015\u0003wMBQa\u0010\u0001\u0005\u00029\n!e\u001d5pk2$G\u000b\u001b:po\u001a\u0013x.\\#oG>$Wm\u00148O_:,G*\u001b;fe\u0006d\u0007\u0006\u0002 4\u0003\n\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u0007B\u0011A\t\u0014\b\u0003\u000b*s!AR%\u000e\u0003\u001dS!\u0001\u0013\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA&\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0014(\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gN\u0003\u0002L\u0015!)\u0001\u000b\u0001C\u0001]\u0005\u00013\u000f[8vY\u0012<&/\u001b;f\u0007\"\fgnZ3t)>$\u0006.Z,sSR,\u0007+\u0019;iQ\ty5\u0007C\u0003T\u0001\u0011\u0005a&A\rtQ>,H\u000e\u001a*pk:$GK]5q\u0007\"\fgnZ3O_\u0012,\u0007F\u0001*4\u0011\u00151\u0006\u0001\"\u0001/\u0003\u0015\u001a\bn\\;mI\u0012+7m\u001c3f%\u0016\u001cx.\u001e:dKV\u001b\u0018N\\4Uo>\u0004\u0016M\u001d;M_\u001eL7\r\u000b\u0002Vg\u0001")
public class LiteralAclStoreTest {
    private final Resource literalResource = new Resource((ResourceType)Topic$.MODULE$, "some-topic", PatternType.LITERAL);
    private final Resource prefixedResource = new Resource((ResourceType)Topic$.MODULE$, "some-topic", PatternType.PREFIXED);
    private final LiteralAclStore$ store = LiteralAclStore$.MODULE$;

    private Resource literalResource() {
        return this.literalResource;
    }

    private Resource prefixedResource() {
        return this.prefixedResource;
    }

    private LiteralAclStore$ store() {
        return this.store;
    }

    @Test
    public void shouldHaveCorrectPaths() {
        Assert.assertEquals((Object)"/kafka-acl", (Object)this.store().aclPath());
        Assert.assertEquals((Object)"/kafka-acl/Topic", (Object)this.store().path((ResourceType)Topic$.MODULE$));
        Assert.assertEquals((Object)"/kafka-acl-changes", (Object)this.store().changeStore().aclChangePath());
    }

    @Test
    public void shouldHaveCorrectPatternType() {
        Assert.assertEquals((Object)PatternType.LITERAL, (Object)this.store().patternType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowFromEncodeOnNoneLiteral() {
        this.store().changeStore().createChangeNode(this.prefixedResource());
    }

    @Test
    public void shouldWriteChangesToTheWritePath() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.literalResource());
        Assert.assertEquals((Object)"/kafka-acl-changes/acl_changes_", (Object)changeNode.path());
    }

    @Test
    public void shouldRoundTripChangeNode() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.literalResource());
        Resource actual = this.store().changeStore().decode(changeNode.bytes());
        Assert.assertEquals((Object)this.literalResource(), (Object)actual);
    }

    @Test
    public void shouldDecodeResourceUsingTwoPartLogic() {
        Resource resource = new Resource((ResourceType)Group$.MODULE$, "PREFIXED:this, including the PREFIXED part, is a valid two part group name", PatternType.LITERAL);
        byte[] encoded = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)resource.resourceType()), Resource$.MODULE$.Separator())).append(resource.name()).toString().getBytes(StandardCharsets.UTF_8);
        Resource actual = this.store().changeStore().decode(encoded);
        Assert.assertEquals((Object)resource, (Object)actual);
    }
}

