/*
 * Decompiled with CFR 0.152.
 */
package kafka.zookeeper;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateRequest$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteRequest$;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.ExistsRequest;
import kafka.zookeeper.ExistsRequest$;
import kafka.zookeeper.ExistsResponse;
import kafka.zookeeper.GetAclRequest;
import kafka.zookeeper.GetAclRequest$;
import kafka.zookeeper.GetAclResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.SetAclRequest;
import kafka.zookeeper.SetAclRequest$;
import kafka.zookeeper.SetAclResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataRequest$;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.StateChangeHandler;
import kafka.zookeeper.ZNodeChangeHandler;
import kafka.zookeeper.ZNodeChildChangeHandler;
import kafka.zookeeper.ZooKeeperClient;
import kafka.zookeeper.ZooKeeperClientTest$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u0001\u001d\u00111CW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e+fgRT!a\u0001\u0003\u0002\u0013i|wn[3fa\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012\u0001C7pG.\u0004\u0016\r\u001e5\u0016\u0003Y\u0001\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\t1\fgn\u001a\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0004TiJLgn\u001a\u0005\u0007?\u0001\u0001\u000b\u0011\u0002\f\u0002\u00135|7m\u001b)bi\"\u0004\u0003bB\u0011\u0001\u0005\u0004%IAI\u0001\u0005i&lW-F\u0001$!\t!c&D\u0001&\u0015\t1s%A\u0003vi&d7O\u0003\u0002)S\u000511m\\7n_:T!!\u0002\u0016\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0005\u0003_\u0015\u0012A\u0001V5nK\"1\u0011\u0007\u0001Q\u0001\n\r\nQ\u0001^5nK\u0002B\u0011b\r\u0001A\u0002\u0003\u0007I\u0011\u0002\u001b\u0002\u001fi|wnS3fa\u0016\u00148\t\\5f]R,\u0012!\u000e\t\u0003%YJ!a\u000e\u0002\u0003\u001fi{wnS3fa\u0016\u00148\t\\5f]RD\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\u0002'i|wnS3fa\u0016\u00148\t\\5f]R|F%Z9\u0015\u0005m\n\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$\u0001B+oSRDqA\u0011\u001d\u0002\u0002\u0003\u0007Q'A\u0002yIEB\u0011\u0002\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B\u001b\u0002!i|wnS3fa\u0016\u00148\t\\5f]R\u0004\u0003\"\u0002$\u0001\t\u0003:\u0015!B:fiV\u0003H#A\u001e)\u0005\u0015K\u0005C\u0001&N\u001b\u0005Y%B\u0001'-\u0003\u0015QWO\\5u\u0013\tq5J\u0001\u0004CK\u001a|'/\u001a\u0005\u0006!\u0002!\teR\u0001\ti\u0016\f'\u000fR8x]\"\u0012qJ\u0015\t\u0003\u0015NK!\u0001V&\u0003\u000b\u00053G/\u001a:\t\u000bY\u0003A\u0011A$\u0002;Q,7\u000f^+oe\u0016\u001cx\u000e\u001c<bE2,7i\u001c8oK\u000e$8\u000b\u001e:j]\u001eD#!\u0016-\u0011\u0005)K\u0016B\u0001.L\u0005\u0011!Vm\u001d;\t\u000bq\u0003A\u0011B/\u0002)I,hN\\5oOj[7+\u001a8e)\"\u0014X-\u00193t+\u0005q\u0006cA0cI6\t\u0001M\u0003\u0002b{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\r\u0004'aA*fiB\u0011Q\r\u001c\b\u0003M*\u0004\"aZ\u001f\u000e\u0003!T!!\u001b\u0004\u0002\rq\u0012xn\u001c;?\u0013\tYW(\u0001\u0004Qe\u0016$WMZ\u0005\u0003;5T!a[\u001f\t\u000b=\u0004A\u0011A$\u0002+Q,7\u000f^\"p]:,7\r^5p]RKW.Z8vi\"\"a\u000eW9s\u0003!)\u0007\u0010]3di\u0016$7%A:\u0011\u0005I!\u0018BA;\u0003\u0005}Qvn\\&fKB,'o\u00117jK:$H+[7f_V$X\t_2faRLwN\u001c\u0005\u0006o\u0002!\taR\u0001\u000fi\u0016\u001cHoQ8o]\u0016\u001cG/[8oQ\t1\b\fC\u0003{\u0001\u0011\u0005q)\u0001\u000euKN$H)\u001a7fi\u0016tuN\\#ySN$XM\u001c;[\u001d>$W\r\u000b\u0002z1\")Q\u0010\u0001C\u0001\u000f\u00069B/Z:u\t\u0016dW\r^3Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u0003ybCa!!\u0001\u0001\t\u00039\u0015A\u0007;fgR,\u00050[:ug:{g.\u0012=jgR,g\u000e\u001e.O_\u0012,\u0007FA@Y\u0011\u0019\t9\u0001\u0001C\u0001\u000f\u00069B/Z:u\u000bbL7\u000f^:Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u0004\u0003\u000bA\u0006BBA\u0007\u0001\u0011\u0005q)A\u000euKN$x)\u001a;ECR\fgj\u001c8Fq&\u001cH/\u001a8u5:{G-\u001a\u0015\u0004\u0003\u0017A\u0006BBA\n\u0001\u0011\u0005q)\u0001\ruKN$x)\u001a;ECR\fW\t_5ti&twM\u0017(pI\u0016D3!!\u0005Y\u0011\u0019\tI\u0002\u0001C\u0001\u000f\u0006YB/Z:u'\u0016$H)\u0019;b\u001d>tW\t_5ti\u0016tGO\u0017(pI\u0016D3!a\u0006Y\u0011\u0019\ty\u0002\u0001C\u0001\u000f\u0006AB/Z:u'\u0016$H)\u0019;b\u000bbL7\u000f^5oOjsu\u000eZ3)\u0007\u0005u\u0001\f\u0003\u0004\u0002&\u0001!\taR\u0001\u001bi\u0016\u001cHoR3u\u0003\u000edgj\u001c8Fq&\u001cH/\u001a8u5:{G-\u001a\u0015\u0004\u0003GA\u0006BBA\u0016\u0001\u0011\u0005q)A\fuKN$x)\u001a;BG2,\u00050[:uS:<'LT8eK\"\u001a\u0011\u0011\u0006-\t\r\u0005E\u0002\u0001\"\u0001H\u0003i!Xm\u001d;TKR\f5\r\u001c(p]\u0016C\u0018n\u001d;f]RTfj\u001c3fQ\r\ty\u0003\u0017\u0005\u0007\u0003o\u0001A\u0011A$\u0002?Q,7\u000f^$fi\u000eC\u0017\u000e\u001c3sK:tuN\\#ySN$XM\u001c;[\u001d>$W\rK\u0002\u00026aCa!!\u0010\u0001\t\u00039\u0015\u0001\b;fgR<U\r^\"iS2$'/\u001a8Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u0004\u0003wA\u0006BBA\"\u0001\u0011\u0005q)\u0001\u0015uKN$x)\u001a;DQ&dGM]3o\u000bbL7\u000f^5oOjsu\u000eZ3XSRD7\t[5mIJ,g\u000eK\u0002\u0002BaCa!!\u0013\u0001\t\u00039\u0015\u0001\u0006;fgR\u0004\u0016\u000e]3mS:,GmR3u\t\u0006$\u0018\rK\u0002\u0002HaCa!a\u0014\u0001\t\u00039\u0015!\u0005;fgRl\u0015\u000e_3e!&\u0004X\r\\5oK\"\u001a\u0011Q\n-\t\r\u0005U\u0003\u0001\"\u0001H\u0003\u0005\"Xm\u001d;[\u001d>$Wm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014hi\u001c:De\u0016\fG/[8oQ\r\t\u0019\u0006\u0017\u0005\u0007\u00037\u0002A\u0011A$\u0002CQ,7\u000f\u001e.O_\u0012,7\t[1oO\u0016D\u0015M\u001c3mKJ4uN\u001d#fY\u0016$\u0018n\u001c8)\u0007\u0005e\u0003\f\u0003\u0004\u0002b\u0001!\taR\u0001$i\u0016\u001cHO\u0017(pI\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe\u001a{'\u000fR1uC\u000eC\u0017M\\4fQ\r\ty\u0006\u0017\u0005\u0007\u0003O\u0002A\u0011A$\u0002eQ,7\u000f\u001e\"m_\u000e\\wJ\u001c*fcV,7\u000f^\"p[BdW\r^5p]\u001a\u0013x.\\*uCR,7\t[1oO\u0016D\u0015M\u001c3mKJD3!!\u001aY\u0011\u0019\ti\u0007\u0001C\u0001\u000f\u0006AC/Z:u\u000bb\u001cW\r\u001d;j_:LeNQ3g_J,\u0017J\\5uS\u0006d\u0017N_5oON+7o]5p]\"\u001a\u00111\u000e-\t\r\u0005M\u0004\u0001\"\u0001H\u0003%\"Xm\u001d;[\u001d>$Wm\u00115jY\u0012\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe\u001a{'o\u00115jY\u0012\u001c\u0005.\u00198hK\"\u001a\u0011\u0011\u000f-\t\r\u0005e\u0004\u0001\"\u0001H\u0003\u0011\"Xm\u001d;Ti\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014hi\u001c:BkRDg)Y5mkJ,\u0007fAA<1\"1\u0011q\u0010\u0001\u0005\u0002\u001d\u000bA\u0005^3ti\u000e{gN\\3di&|g\u000eT8tgJ+\u0017/^3tiR+'/\\5oCRLwN\u001c\u0015\u0004\u0003{B\u0006BBAC\u0001\u0011\u0005q)A\tuKN$8+Z:tS>tW\t\u001f9jefD3!a!Y\u0011\u0019\tY\t\u0001C\u0001\u000f\u0006aB/Z:u'\u0016\u001c8/[8o\u000bb\u0004\u0018N]=EkJLgnZ\"m_N,\u0007fAAE1\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0015\u0001F5t\u000bb\u0004Xm\u0019;fI6+GO]5d\u001d\u0006lW\r\u0006\u0004\u0002\u0016\u0006m\u0015q\u0017\t\u0004y\u0005]\u0015bAAM{\t9!i\\8mK\u0006t\u0007\u0002CAO\u0003\u001f\u0003\r!a(\u0002\u00155,GO]5d\u001d\u0006lW\r\u0005\u0003\u0002\"\u0006MVBAAR\u0015\u0011\t)+a*\u0002\t\r|'/\u001a\u0006\u0005\u0003S\u000bY+A\u0004nKR\u0014\u0018nY:\u000b\t\u00055\u0016qV\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005E\u0016aA2p[&!\u0011QWAR\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\b\u0003s\u000by\t1\u0001e\u0003\u0011q\u0017-\\3\t\r\u0005u\u0006\u0001\"\u0001H\u0003\r\"Xm\u001d;[_>\\U-\u001a9feN#\u0018\r^3DQ\u0006tw-\u001a*bi\u0016lU\r\u001e:jGND3!a/Y\u0011\u0019\t\u0019\r\u0001C\u0001\u000f\u0006yB/Z:u5>|7*Z3qKJ\u001cVm]:j_:\u001cF/\u0019;f\u001b\u0016$(/[2)\u0007\u0005\u0005\u0007\f\u0003\u0004\u0002J\u0002!IaR\u0001\u0015G2,\u0017M\\'fiJL7m\u001d*fO&\u001cHO]=\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\u0006)!-\u001f;fgV\u0011\u0011\u0011\u001b\t\u0006y\u0005M\u0017q[\u0005\u0004\u0003+l$!B!se\u0006L\bc\u0001\u001f\u0002Z&\u0019\u00111\\\u001f\u0003\t\tKH/\u001a")
public class ZooKeeperClientTest
extends ZooKeeperTestHarness {
    private final String kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    private final Time kafka$zookeeper$ZooKeeperClientTest$$time = Time.SYSTEM;
    private ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("calls", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public String kafka$zookeeper$ZooKeeperClientTest$$mockPath() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    }

    public Time kafka$zookeeper$ZooKeeperClientTest$$time() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$time;
    }

    public ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;
    }

    private void kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        this.cleanMetricsRegistry();
        super.setUp();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "testMetricGroup", "testMetricType"));
    }

    @Override
    @After
    public void tearDown() {
        if (this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() != null) {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        }
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
    }

    @Test
    public void testUnresolvableConnectString() {
        try {
            new ZooKeeperClient("some.invalid.hostname.foo.bar.local", this.zkSessionTimeout(), 10, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");
        }
        catch (ZooKeeperClientTimeoutException e) {
            Assert.assertEquals((String)"ZooKeeper client threads still running", (Object)Predef$.MODULE$.Set().empty(), this.runningZkSendThreads());
        }
    }

    private Set<String> runningZkSendThreads() {
        return (Set)((TraversableLike)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isAlive()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.contains("SendThread()")));
    }

    @Test(expected=ZooKeeperClientTimeoutException.class)
    public void testConnectionTimeout() {
        this.zookeeper().shutdown();
        new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), 10, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType").close();
    }

    @Test
    public void testConnection() {
        new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType").close();
    }

    @Test
    public void testDeleteNonExistentZNode() {
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3(), DeleteRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)deleteResponse.resultCode());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> deleteResponse.maybeThrow(), ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
    }

    @Test
    public void testDeleteExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3(), DeleteRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode());
    }

    @Test
    public void testExistsNonExistentZNode() {
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2(), ExistsRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)existsResponse.resultCode());
    }

    @Test
    public void testExistsExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2(), ExistsRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)existsResponse.resultCode());
    }

    @Test
    public void testGetDataNonExistentZNode() {
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2(), GetDataRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getDataResponse.resultCode());
    }

    @Test
    public void testGetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2(), GetDataRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
        Assert.assertArrayEquals((String)"Data for getData should match created znode data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testSetDataNonExistentZNode() {
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4(), SetDataRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)setDataResponse.resultCode());
    }

    @Test
    public void testSetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, -1, SetDataRequest$.MODULE$.apply$default$4(), SetDataRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode());
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2(), GetDataRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
        Assert.assertArrayEquals((String)"Data for getData should match setData's data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testGetAclNonExistentZNode() {
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetAclRequest$.MODULE$.apply$default$2(), GetAclRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getAclResponse.resultCode());
    }

    @Test
    public void testGetAclExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetAclRequest$.MODULE$.apply$default$2(), GetAclRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for getAcl should be OK", (Object)KeeperException.Code.OK, (Object)getAclResponse.resultCode());
        Assert.assertEquals((String)new StringBuilder(14).append("ACL should be ").append(JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala()).toString(), (Object)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), (Object)getAclResponse.acl());
    }

    @Test
    public void testSetAclNonExistentZNode() {
        SetAclResponse setAclResponse = (SetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), -1, SetAclRequest$.MODULE$.apply$default$4(), SetAclRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)setAclResponse.resultCode());
    }

    @Test
    public void testGetChildrenNonExistentZNode() {
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2(), GetChildrenRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getChildrenResponse.resultCode());
    }

    @Test
    public void testGetChildrenExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2(), GetChildrenRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        Assert.assertEquals((String)"getChildren should return no children", (Object)Seq$.MODULE$.empty(), (Object)getChildrenResponse.children());
    }

    @Test
    public void testGetChildrenExistingZNodeWithChildren() {
        String child1 = "child1";
        String child2 = "child2";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        String child2Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child2).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode());
        CreateResponse createResponseChild2 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child2Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create child2 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild2.resultCode());
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2(), GetChildrenRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        Assert.assertEquals((String)"getChildren should return two children", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{child1, child2})), (Object)getChildrenResponse.children().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testPipelinedGetData() {
        IndexedSeq createRequests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        ZooKeeperClient zooKeeperClient = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient();
        IndexedSeq createResponses = (IndexedSeq)createRequests.map((Function1 & Serializable & scala.Serializable)request -> (CreateResponse)zooKeeperClient.handleRequest((AsyncRequest)request), IndexedSeq$.MODULE$.canBuildFrom());
        createResponses.foreach((Function1 & Serializable & scala.Serializable)createResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$3(createResponse);
            return BoxedUnit.UNIT;
        });
        IndexedSeq getDataRequests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$4(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        Seq getDataResponses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)getDataRequests);
        getDataResponses.foreach((Function1 & Serializable & scala.Serializable)getDataResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$5(getDataResponse);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)getDataResponses.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$6(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMixedPipeline() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetDataRequest getDataRequest = new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2(), GetDataRequest$.MODULE$.apply$default$3());
        SetDataRequest setDataRequest = new SetDataRequest("/nonexistent", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4(), SetDataRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{getDataRequest, setDataRequest})));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        Assert.assertArrayEquals((String)"Data for getData should be empty", (byte[])((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (byte[])((GetDataResponse)responses.head()).data());
        Assert.assertEquals((String)"Response code for setData should be NONODE", (Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.last()).resultCode());
    }

    @Test
    public void testZNodeChangeHandlerForCreation() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2(), ExistsRequest$.MODULE$.apply$default$3());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{existsRequest, createRequest})));
        Assert.assertEquals((String)"Response code for exists should be NONODE", (Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.head()).resultCode());
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertTrue((String)"Failed to receive create notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDeletion() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$2;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                this.znodeChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$2 = znodeChangeHandlerCountDownLatch$2;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2(), ExistsRequest$.MODULE$.apply$default$3());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{createRequest, existsRequest})));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3(), DeleteRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode());
        Assert.assertTrue((String)"Failed to receive delete notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$3;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                this.znodeChangeHandlerCountDownLatch$3.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$3 = znodeChangeHandlerCountDownLatch$3;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2(), ExistsRequest$.MODULE$.apply$default$3());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{createRequest, existsRequest})));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4(), SetDataRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode());
        Assert.assertTrue((String)"Failed to receive data change notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testBlockOnRequestCompletionFromStateChangeHandler() {
        CountDownLatch latch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, latch){
            private final String name;
            private final CountDownLatch latch$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.latch$1.await();
            }
            {
                this.latch$1 = latch$1;
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        ZooKeeperClient client = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");
        client.registerStateChangeHandler(stateChangeHandler);
        Thread requestThread = new Thread(this, latch, client){
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final CountDownLatch latch$1;
            private final ZooKeeperClient client$1;

            public void run() {
                try {
                    this.client$1.handleRequest((AsyncRequest)new CreateRequest(this.$outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
                }
                finally {
                    this.latch$1.countDown();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
                this.client$1 = client$1;
            }
        };
        Thread reinitializeThread = new Thread(null, client){
            private final ZooKeeperClient client$1;

            public void run() {
                this.client$1.forceReinitialize();
            }
            {
                this.client$1 = client$1;
            }
        };
        reinitializeThread.start();
        Thread.sleep(100L);
        requestThread.start();
        reinitializeThread.join();
        requestThread.join();
    }

    @Test
    public void testExceptionInBeforeInitializingSession() {
        Object object;
        StateChangeHandler faultyHandler = new StateChangeHandler(null){
            private final String name;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                throw new RuntimeException();
            }
            {
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        StateChangeHandler goodHandler = new StateChangeHandler(null){
            private final AtomicInteger calls;
            private final String name;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public AtomicInteger calls() {
                return this.calls;
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.calls().incrementAndGet();
            }
            {
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.calls = new AtomicInteger(0);
                this.name = this.getClass().getName();
            }
        };
        ZooKeeperClient client = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");
        client.registerStateChangeHandler(faultyHandler);
        client.registerStateChangeHandler(goodHandler);
        client.forceReinitialize();
        StateChangeHandler qual1 = goodHandler;
        try {
            object = ZooKeeperClientTest.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        Assert.assertEquals((long)1L, (long)((AtomicInteger)object).get());
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChange() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$1;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$1 = zNodeChildChangeHandlerCountDownLatch$1;
                ZNodeChildChangeHandler.$init$((ZNodeChildChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2(), GetChildrenRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6()));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode());
        Assert.assertTrue((String)"Failed to receive child change notification", (boolean)zNodeChildChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testStateChangeHandlerForAuthFailure() {
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        CountDownLatch stateChangeHandlerCountDownLatch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, stateChangeHandlerCountDownLatch){
            private final String name;
            private final CountDownLatch stateChangeHandlerCountDownLatch$1;

            public void beforeInitializingSession() {
                StateChangeHandler.beforeInitializingSession$((StateChangeHandler)this);
            }

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void onAuthFailure() {
                this.stateChangeHandlerCountDownLatch$1.countDown();
            }
            {
                this.stateChangeHandlerCountDownLatch$1 = stateChangeHandlerCountDownLatch$1;
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        try (ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");){
            zooKeeperClient.registerStateChangeHandler(stateChangeHandler);
            zooKeeperClient.forceReinitialize();
            Assert.assertTrue((String)"Failed to receive auth failed notification", (boolean)stateChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
        }
    }

    @Test
    public void testConnectionLossRequestTermination() {
        int batchSize = 10;
        this.zookeeper().shutdown();
        try (ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), 2, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");){
            IndexedSeq requests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), batchSize).map((Function1 & Serializable & scala.Serializable)i -> ZooKeeperClientTest.$anonfun$testConnectionLossRequestTermination$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            AtomicBoolean running = new AtomicBoolean(true);
            ArrayBlockingQueue unexpectedResponses = new ArrayBlockingQueue(batchSize);
            Thread requestThread = new Thread(null, zooKeeperClient, requests, countDownLatch, running, unexpectedResponses){
                private final ZooKeeperClient zooKeeperClient$1;
                private final IndexedSeq requests$1;
                private final CountDownLatch countDownLatch$1;
                private final AtomicBoolean running$1;
                private final ArrayBlockingQueue unexpectedResponses$1;

                public void run() {
                    while (this.running$1.get()) {
                        Seq responses = this.zooKeeperClient$1.handleRequests((Seq)this.requests$1);
                        Seq suffix = (Seq)responses.dropWhile((Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$4.$anonfun$run$1(response)));
                        if (!suffix.forall((Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$4.$anonfun$run$2(response)))) {
                            responses.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$4.$anonfun$run$3(this, x$1)));
                        }
                        if (this.unexpectedResponses$1.isEmpty() && !suffix.nonEmpty()) continue;
                        this.running$1.set(false);
                    }
                    this.countDownLatch$1.countDown();
                }

                public static final /* synthetic */ boolean $anonfun$run$1(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return code == null ? code2 != null : !code.equals(code2);
                }

                public static final /* synthetic */ boolean $anonfun$run$2(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return !(code != null ? !code.equals(code2) : code2 != null);
                }

                public static final /* synthetic */ boolean $anonfun$run$3($anon$4 $this, GetDataResponse x$1) {
                    return $this.unexpectedResponses$1.add(x$1);
                }
                {
                    this.zooKeeperClient$1 = zooKeeperClient$1;
                    this.requests$1 = requests$1;
                    this.countDownLatch$1 = countDownLatch$1;
                    this.running$1 = running$1;
                    this.unexpectedResponses$1 = unexpectedResponses$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$2$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$3$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$4 kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            boolean requestThreadTerminated = countDownLatch.await(30L, TimeUnit.SECONDS);
            if (!requestThreadTerminated) {
                running.set(false);
                requestThread.join(5000L);
                throw this.fail("Failed to receive a CONNECTIONLOSS response code after zookeeper has shutdown.", new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
            }
            if (!unexpectedResponses.isEmpty()) {
                throw this.fail(new StringBuilder(114).append("Received an unexpected non-CONNECTIONLOSS response code after a CONNECTIONLOSS response code from a single batch: ").append(unexpectedResponses).toString(), new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
            }
        }
    }

    @Test
    public void testSessionExpiry() {
        int maxInflightRequests = 2;
        ExecutorService responseExecutor = Executors.newSingleThreadExecutor();
        Semaphore sendSemaphore = new Semaphore(0);
        Semaphore sendCompleteSemaphore = new Semaphore(0);
        int sendSize = maxInflightRequests * 5;
        VolatileObjectRef resultCodes = VolatileObjectRef.create(null);
        ConcurrentLinkedQueue stateChanges = new ConcurrentLinkedQueue();
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this, maxInflightRequests, responseExecutor, sendSemaphore, sendCompleteSemaphore){
            private final ExecutorService responseExecutor$1;
            public final Semaphore sendSemaphore$1;
            public final Semaphore sendCompleteSemaphore$1;

            public <Req extends AsyncRequest> void send(Req request, Function1<AsyncResponse, BoxedUnit> processResponse) {
                super.send(request, (Function1 & Serializable & scala.Serializable)response -> {
                    $anon$1.$anonfun$send$1(this, processResponse, response);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$send$1($anon$1 $this, Function1 processResponse$1, AsyncResponse response) {
                $this.responseExecutor$1.submit(new Runnable($this, processResponse$1, response){
                    private final /* synthetic */ $anon$1 $outer;
                    private final Function1 processResponse$1;
                    private final AsyncResponse response$1;

                    public void run() {
                        this.$outer.sendCompleteSemaphore$1.release();
                        this.$outer.sendSemaphore$1.acquire();
                        this.processResponse$1.apply((Object)this.response$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.processResponse$1 = processResponse$1;
                        this.response$1 = response$1;
                    }
                });
            }
            {
                this.responseExecutor$1 = responseExecutor$1;
                this.sendSemaphore$1 = sendSemaphore$1;
                this.sendCompleteSemaphore$1 = sendCompleteSemaphore$1;
                super($outer.zkConnect(), $outer.zkSessionTimeout(), $outer.zkConnectionTimeout(), maxInflightRequests$1, $outer.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$send$1$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$1 scala.Function1 kafka.zookeeper.AsyncResponse )}, serializedLambda);
            }
        };
        try {
            zooKeeperClient.registerStateChangeHandler(new StateChangeHandler(null, sendSemaphore, sendSize, stateChanges, zooKeeperClient){
                private final String name;
                private final Semaphore sendSemaphore$1;
                private final int sendSize$1;
                private final ConcurrentLinkedQueue stateChanges$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void onAuthFailure() {
                    StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
                }

                public String name() {
                    return this.name;
                }

                public void afterInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("afterInitializingSession");
                }

                public void beforeInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("beforeInitializingSession");
                    this.sendSemaphore$1.release(this.sendSize$1);
                }

                private void verifyHandlerThread() {
                    String threadName = Thread.currentThread().getName();
                    Assert.assertTrue((String)new StringBuilder(20).append("Unexpected thread + ").append(threadName).toString(), (boolean)threadName.startsWith(this.zooKeeperClient$2.expiryScheduler().threadNamePrefix()));
                }
                {
                    this.sendSemaphore$1 = sendSemaphore$1;
                    this.sendSize$1 = sendSize$1;
                    this.stateChanges$1 = stateChanges$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                    StateChangeHandler.$init$((StateChangeHandler)this);
                    this.name = "test-state-change-handler";
                }
            });
            Thread requestThread = new Thread(null, sendSize, resultCodes, zooKeeperClient){
                private final int sendSize$1;
                private final VolatileObjectRef resultCodes$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void run() {
                    IndexedSeq requests = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.sendSize$1).map((Function1 & Serializable & scala.Serializable)i -> $anon$5.$anonfun$run$4(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                    this.resultCodes$1.elem = (Seq)this.zooKeeperClient$2.handleRequests((Seq)requests).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.resultCode(), Seq$.MODULE$.canBuildFrom());
                }

                public static final /* synthetic */ GetDataRequest $anonfun$run$4(int i) {
                    return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), GetDataRequest$.MODULE$.apply$default$2(), GetDataRequest$.MODULE$.apply$default$3());
                }
                {
                    this.sendSize$1 = sendSize$1;
                    this.resultCodes$1 = resultCodes$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$4$adapted(java.lang.Object ), $anonfun$run$5(kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            sendCompleteSemaphore.acquire();
            ZooKeeper anotherZkClient = this.createZooKeeperClientToTriggerSessionExpiry(zooKeeperClient.currentZooKeeper());
            sendSemaphore.release(maxInflightRequests);
            anotherZkClient.close();
            sendSemaphore.release(maxInflightRequests);
            requestThread.join(10000L);
            if (requestThread.isAlive()) {
                requestThread.interrupt();
                throw this.fail("Request thread did not complete", new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
            }
            Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"beforeInitializingSession", "afterInitializingSession"})), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(stateChanges).asScala()).toSeq());
            Assert.assertEquals((long)((Seq)resultCodes.elem).size(), (long)sendSize);
            int connectionLostCount = ((Seq)resultCodes.elem).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$1(x$4)));
            Assert.assertTrue((String)new StringBuilder(36).append("Unexpected connection lost requests ").append((Seq)resultCodes.elem).toString(), (connectionLostCount <= maxInflightRequests ? 1 : 0) != 0);
            int expiredCount = ((Seq)resultCodes.elem).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$2(x$5)));
            Assert.assertTrue((String)new StringBuilder(36).append("Unexpected session expired requests ").append((Seq)resultCodes.elem).toString(), (expiredCount <= maxInflightRequests ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringBuilder(39).append("No connection lost or expired requests ").append((Seq)resultCodes.elem).toString(), (connectionLostCount + expiredCount > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).head());
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).last());
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeeperException.Code[]{KeeperException.Code.NONODE, KeeperException.Code.SESSIONEXPIRED, KeeperException.Code.CONNECTIONLOSS}));
            Assert.assertTrue((String)new StringBuilder(23).append("Unexpected result code ").append((Seq)resultCodes.elem).toString(), (boolean)((SeqLike)((Seq)resultCodes.elem).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)))).isEmpty());
        }
        finally {
            zooKeeperClient.close();
            responseExecutor.shutdownNow();
        }
        Assert.assertFalse((String)"Expiry executor not shutdown", (boolean)zooKeeperClient.expiryScheduler().isStarted());
    }

    @Test
    public void testSessionExpiryDuringClose() {
        Semaphore semaphore = new Semaphore(0);
        ExecutorService closeExecutor = Executors.newSingleThreadExecutor();
        try {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().expiryScheduler().schedule("test", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> semaphore.acquireUninterruptibly(), 0L, -1L, TimeUnit.SECONDS);
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().scheduleSessionExpiryHandler();
            Future<?> closeFuture = closeExecutor.submit(new Runnable(this){
                private final /* synthetic */ ZooKeeperClientTest $outer;

                public void run() {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertFalse((String)"Close completed without shutting down expiry scheduler gracefully", (boolean)closeFuture.isDone());
            semaphore.release();
            closeFuture.get(10L, TimeUnit.SECONDS);
            Assert.assertFalse((String)"Expiry executor not shutdown", (boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().expiryScheduler().isStarted());
        }
        finally {
            closeExecutor.shutdownNow();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExpectedMetricName(MetricName metricName, String name) {
        String string = metricName.getName();
        String string2 = name;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = metricName.getGroup();
        String string4 = "testMetricGroup";
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = metricName.getType();
        String string6 = "testMetricType";
        if (string5 == null) {
            if (string6 == null) return true;
            return false;
        } else {
            if (!string5.equals(string6)) return false;
            return true;
        }
    }

    @Test
    public void testZooKeeperStateChangeRateMetrics() {
        String expiresPerSecName = "ZooKeeperExpiresPerSec";
        String disconnectsPerSecName = "ZooKeeperDisconnectsPerSec";
        this.checkMeterCount$1(expiresPerSecName, 0L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 1L);
    }

    @Test
    public void testZooKeeperSessionStateMetric() {
        Assert.assertEquals((Object)new Some((Object)ZooKeeper.States.CONNECTED.toString()), (Object)this.gaugeValue$1("SessionState"));
        Assert.assertEquals((Object)ZooKeeper.States.CONNECTED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.gaugeValue$1("SessionState"));
        Assert.assertEquals((Object)ZooKeeper.States.CLOSED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
    }

    private void cleanMetricsRegistry() {
        MetricsRegistry metrics = Metrics.defaultRegistry();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(metrics.allMetrics().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            metrics.removeMetric(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private byte[] bytes() {
        return UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    public static final /* synthetic */ CreateRequest $anonfun$testPipelinedGetData$1(int x) {
        return new CreateRequest(new StringBuilder(1).append("/").append(x).toString(), ((Object)BoxesRunTime.boxToInteger((int)(x * 2))).toString().getBytes(), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5(), CreateRequest$.MODULE$.apply$default$6());
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$3(CreateResponse createResponse) {
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testPipelinedGetData$4(int x) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(x).toString(), GetDataRequest$.MODULE$.apply$default$2(), GetDataRequest$.MODULE$.apply$default$3());
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$5(GetDataResponse getDataResponse) {
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        GetDataResponse getDataResponse = (GetDataResponse)tuple2._1();
        int i = tuple2._2$mcI$sp();
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
        Assert.assertEquals((String)"Data for getData should match", (Object)BoxesRunTime.boxToInteger((int)((i + 1) * 2)), (Object)Integer.valueOf(new String(getDataResponse.data())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testConnectionLossRequestTermination$1(int i) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), GetDataRequest$.MODULE$.apply$default$2(), GetDataRequest$.MODULE$.apply$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$1(KeeperException.Code x$4) {
        KeeperException.Code code = x$4;
        KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$2(KeeperException.Code x$5) {
        KeeperException.Code code = x$5;
        KeeperException.Code code2 = KeeperException.Code.SESSIONEXPIRED;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    private final void checkMeterCount$1(String name, long expected) {
        Meter meter = (Meter)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).collectFirst((PartialFunction)new scala.Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    MetricName metricName = (MetricName)A1._1();
                    Metric meter = (Metric)A1._2();
                    if (meter instanceof Meter) {
                        Meter meter2 = (Meter)meter;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$1)) {
                            object = meter2;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                Tuple2<MetricName, Metric> tuple2 = x1;
                if (tuple2 == null) return false;
                MetricName metricName = (MetricName)tuple2._1();
                Metric meter = (Metric)tuple2._2();
                if (!(meter instanceof Meter)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$1)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(31).append("Unable to find meter with name ").append(name).toString()));
        Assert.assertEquals((String)new StringBuilder(27).append("Unexpected meter count for ").append(name).toString(), (long)expected, (long)meter.count());
    }

    private final Option gaugeValue$1(String name) {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).collectFirst((PartialFunction)new scala.Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    MetricName metricName = (MetricName)A1._1();
                    Metric gauge = (Metric)A1._2();
                    if (gauge instanceof Gauge) {
                        Gauge gauge2 = (Gauge)gauge;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$2)) {
                            object = (String)gauge2.value();
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x2) {
                Tuple2<MetricName, Metric> tuple2 = x2;
                if (tuple2 == null) return false;
                MetricName metricName = (MetricName)tuple2._1();
                Metric gauge = (Metric)tuple2._2();
                if (!(gauge instanceof Gauge)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$2)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$2 = name$2;
            }
        });
    }

    public ZooKeeperClientTest() {
        this.kafka$zookeeper$ZooKeeperClientTest$$mockPath = "/foo";
    }
}

