/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogOffsetSnapshot;
import kafka.log.LogSegment;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\b\t\u0003A!j\u0011!\t\u0006\u0003E\r\naaY8n[>t'BA\u0003%\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\n\u0005%\n#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\tW\u0001\u0011\t\u0011)A\u0005?\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0011!\u0018.\\3\u0011\u0005=\nT\"\u0001\u0019\u000b\u0005E\t\u0013B\u0001\u001a1\u0005\u0011!\u0016.\\3\t\u0011Q\u0002!\u0011!Q\u0001\nU\n\u0011$\u001b8ji&\fG\u000eS5hQ^\u000bG/\u001a:nCJ\\g+\u00197vKB\u0011\u0011BN\u0005\u0003o)\u0011A\u0001T8oO\"A\u0011\b\u0001BA\u0002\u0013\u0005!(A\u0002m_\u001e,\u0012a\u000f\t\u0004\u0013qr\u0014BA\u001f\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011q(Q\u0007\u0002\u0001*\u0011\u0011\bB\u0005\u0003\u0005\u0002\u00131\u0001T8h\u0011!!\u0005A!a\u0001\n\u0003)\u0015a\u00027pO~#S-\u001d\u000b\u0003\r&\u0003\"!C$\n\u0005!S!\u0001B+oSRDqAS\"\u0002\u0002\u0003\u00071(A\u0002yIEB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006KaO\u0001\u0005Y><\u0007\u0005\u000b\u0002L\u001dB\u0011\u0011bT\u0005\u0003!*\u0011\u0001B^8mCRLG.\u001a\u0005\u0006%\u0002!\taU\u0001\u0007y%t\u0017\u000e\u001e \u0015\rQ3v\u000bW-[!\t)\u0006!D\u0001\u0003\u0011\u0015)\u0012\u000b1\u0001\u0018\u0011\u0015i\u0012\u000b1\u0001 \u0011\u001di\u0013\u000b%AA\u00029Bq\u0001N)\u0011\u0002\u0003\u0007Q\u0007C\u0004:#B\u0005\t\u0019A\u001e\t\rq\u0003\u0001\u0015)\u0003^\u0003UA\u0017n\u001a5XCR,'/\\1sW6+G/\u00193bi\u0006\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0003\u0002\rM,'O^3s\u0013\t\u0011wLA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006D#a\u0017(\t\r\u0015\u0004\u0001\u0015)\u0003^\u0003QawnZ#oI>3gm]3u\u001b\u0016$\u0018\rZ1uC\"\u0012AM\u0014\u0005\u0007Q\u0002\u0001\u000b\u0015B\u001b\u0002\u001f}cwnZ*uCJ$xJ\u001a4tKRD#a\u001a(\t\r-\u0004\u0001\u0015)\u00036\u0003ma\u0017m\u001d;GKR\u001c\u0007\u000eT3bI\u0016\u0014Hj\\4F]\u0012|eMZ:fi\"\u0012!N\u0014\u0005\u0007]\u0002\u0001\u000b\u0015B\u001b\u0002\u001f1\f7\u000f\u001e$fi\u000eDG+[7f\u001bND#!\u001c(\t\rE\u0004\u0001\u0015)\u00036\u0003MyF.Y:u\u0007\u0006,x\r\u001b;VaRKW.Z'tQ\t\u0001h\nC\u0003u\u0001\u0011\u0005Q/A\u0004jg2{7-\u00197\u0016\u0003Y\u0004\"!C<\n\u0005aT!a\u0002\"p_2,\u0017M\u001c\u0005\u0006u\u0002!\ta_\u0001\u0013Y\u0006\u001cHoQ1vO\"$X\u000b\u001d+j[\u0016l5/F\u00016\u0011\u0015i\b\u0001\"\u0001\u007f\u0003M)\b\u000fZ1uK2{wMU3bIJ+7/\u001e7u)\t1u\u0010C\u0004\u0002\u0002q\u0004\r!a\u0001\u0002\u001b1|wMU3bIJ+7/\u001e7u!\rq\u0016QA\u0005\u0004\u0003\u000fy&!\u0004'pOJ+\u0017\r\u001a*fgVdG\u000fC\u0004\u0002\f\u0001!\t!!\u0004\u0002+I,7/\u001a;MCN$8)Y;hQR,\u0006\u000fV5nKR9a)a\u0004\u0002\u0014\u0005]\u0001bBA\t\u0003\u0013\u0001\r!N\u0001\u0016GV\u0014H*Z1eKJdunZ#oI>3gm]3u\u0011\u001d\t)\"!\u0003A\u0002U\n\u0011bY;s)&lW-T:\t\ri\fI\u00011\u00016\u0011\u001d\tY\u0002\u0001C\u0005\u0003;\t\u0001\u0003\\8h\u000b:$wJ\u001a4tKR|F%Z9\u0015\u0007\u0019\u000by\u0002C\u0004\u0002\"\u0005e\u0001\u0019A/\u0002\u001f9,w\u000fT8h\u000b:$wJ\u001a4tKRDq!!\n\u0001\t\u0003\t9#A\u0006mCR,7\u000f^#q_\u000eDWCAA\u0015!\rIAh\u0006\u0005\b\u0003[\u0001A\u0011AA\u0018\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0005\u0003c\tI\u0004\u0005\u0003\ny\u0005M\u0002c\u00010\u00026%\u0019\u0011qG0\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\"9\u00111HA\u0016\u0001\u00049\u0012a\u00037fC\u0012,'/\u00129pG\"Dq!a\u0010\u0001\t\u0003\t\t%\u0001\u0007m_\u001e,e\u000eZ(gMN,G/F\u0001^\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\nA$\\1zE\u0016Len\u0019:f[\u0016tG\u000fT8h'R\f'\u000f^(gMN,G\u000fF\u0002G\u0003\u0013Bq!a\u0013\u0002D\u0001\u0007Q'A\toK^dunZ*uCJ$xJ\u001a4tKRDq!a\u0014\u0001\t\u0013\t\t&\u0001\nm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;`I\u0015\fHc\u0001$\u0002T!9\u00111JA'\u0001\u0004)\u0004BBA,\u0001\u0011\u000510\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^\u0005\t\u0002.[4i/\u0006$XM]7be.|F%Z9\u0015\u0007\u0019\u000by\u0006C\u0004\u0002b\u0005e\u0003\u0019A/\u0002!9,w\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007bBA3\u0001\u0011\u0005\u0011\u0011I\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\t\u000f\u0005%\u0004\u0001\"\u0001\u0002B\u0005\u0001B.Y:u'R\f'\r\\3PM\u001a\u001cX\r\u001e\u0005\b\u0003[\u0002A\u0011AA8\u0003y\u0019wN\u001c<feRDu\u000bV8M_\u000e\fGn\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\rF\u0001G\u0011\u001d\t\u0019\b\u0001C\u0001\u0003k\nab\u001c4gg\u0016$8K\\1qg\"|G/\u0006\u0002\u0002xA\u0019q(!\u001f\n\u0007\u0005m\u0004IA\tM_\u001e|eMZ:fiNs\u0017\r]:i_RDq!a \u0001\t\u0003\n\t)\u0001\u0004fcV\fGn\u001d\u000b\u0004m\u0006\r\u0005\u0002CAC\u0003{\u0002\r!a\"\u0002\tQD\u0017\r\u001e\t\u0004\u0013\u0005%\u0015bAAF\u0015\t\u0019\u0011I\\=\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\u0006A\u0001.Y:i\u0007>$W\rF\u0001\u0018\u0011\u001d\t)\n\u0001C!\u0003/\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\u0003B!a'\u0002*:!\u0011QTAS!\r\tyJC\u0007\u0003\u0003CS1!a)\u0007\u0003\u0019a$o\\8u}%\u0019\u0011q\u0015\u0006\u0002\rA\u0013X\rZ3g\u0013\u0011\tY+!,\u0003\rM#(/\u001b8h\u0015\r\t9KC\u0004\n\u0003c\u0013\u0011\u0011!E\u0001\u0003g\u000bqAU3qY&\u001c\u0017\rE\u0002V\u0003k3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qW\n\u0004\u0003kC\u0001b\u0002*\u00026\u0012\u0005\u00111\u0018\u000b\u0003\u0003gC!\"a0\u00026F\u0005I\u0011AAa\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0019\u0016\u0004]\u0005\u00157FAAd!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E'\"\u0001\u0006b]:|G/\u0019;j_:LA!!6\u0002L\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005e\u0017QWI\u0001\n\u0003\tY.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003;T3!NAc\u0011)\t\t/!.\u0012\u0002\u0013\u0005\u00111]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\u0015(fA\u001e\u0002F\u0002")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private final long initialHighWatermarkValue;
    private volatile Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    private volatile LogOffsetMetadata logEndOffsetMetadata;
    private volatile long _logStartOffset;
    private volatile long lastFetchLeaderLogEndOffset;
    private volatile long lastFetchTimeMs;
    private volatile long _lastCaughtUpTimeMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public void log_$eq(Option<Log> x$1) {
        this.log = x$1;
    }

    public boolean isLocal() {
        return this.log().isDefined();
    }

    public long lastCaughtUpTimeMs() {
        return this._lastCaughtUpTimeMs;
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= logReadResult.leaderLogEndOffset()) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, logReadResult.fetchTimeMs());
        } else if (logReadResult.info().fetchOffsetMetadata().messageOffset() >= this.lastFetchLeaderLogEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, this.lastFetchTimeMs);
        }
        this.logStartOffset_$eq(logReadResult.followerLogStartOffset());
        this.logEndOffset_$eq(logReadResult.info().fetchOffsetMetadata());
        this.lastFetchLeaderLogEndOffset = logReadResult.leaderLogEndOffset();
        this.lastFetchTimeMs = logReadResult.fetchTimeMs();
    }

    public void resetLastCaughtUpTime(long curLeaderLogEndOffset, long curTimeMs, long lastCaughtUpTimeMs) {
        this.lastFetchLeaderLogEndOffset = curLeaderLogEndOffset;
        this.lastFetchTimeMs = curTimeMs;
        this._lastCaughtUpTimeMs = lastCaughtUpTimeMs;
    }

    private void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringBuilder(60).append("Should not set log end offset on partition ").append(this.topicPartition()).append("'s local replica ").append(this.brokerId()).toString());
        }
        this.logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Setting log end offset for replica ").append(this.brokerId()).append(" for partition ").append(this.topicPartition()).append(" to [").append($this.logEndOffsetMetadata).append("]").toString());
    }

    public Option<Object> latestEpoch() {
        if (!this.isLocal()) {
            throw new KafkaException(new StringBuilder(48).append("Cannot get latest epoch of non-local replica of ").append(this.topicPartition()).toString());
        }
        return ((Log)this.log().get()).latestEpoch();
    }

    public Option<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
        if (!this.isLocal()) {
            throw new KafkaException(new StringBuilder(59).append("Cannot lookup end offset for epoch of non-local replica of ").append(this.topicPartition()).toString());
        }
        return ((Log)this.log().get()).endOffsetForEpoch(leaderEpoch);
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffsetMetadata() : this.logEndOffsetMetadata;
    }

    public void maybeIncrementLogStartOffset(long newLogStartOffset) {
        if (this.isLocal()) {
            if (newLogStartOffset > this.highWatermark().messageOffset()) {
                throw new OffsetOutOfRangeException(new StringBuilder(56).append("Cannot increment the log start offset to ").append(newLogStartOffset).append(" of partition ").append(this.topicPartition()).append(" ").append(new StringBuilder(43).append("since it is larger than the high watermark ").append(this.highWatermark().messageOffset()).toString()).toString());
            }
        } else {
            throw new KafkaException(new StringBuilder(67).append("Should not try to delete records on partition ").append(this.topicPartition()).append("'s non-local replica ").append(this.brokerId()).toString());
        }
        ((Log)this.log().get()).maybeIncrementLogStartOffset(newLogStartOffset);
    }

    private void logStartOffset_$eq(long newLogStartOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringBuilder(110).append("Should not set log start offset on partition ").append(this.topicPartition()).append("'s local replica ").append(this.brokerId()).append(" ").append("without attempting to delete records of the log").toString());
        }
        this._logStartOffset = newLogStartOffset;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Setting log start offset for remote replica ").append(this.brokerId()).append(" for partition ").append(this.topicPartition()).append(" to [").append(newLogStartOffset).append("]").toString());
    }

    public long logStartOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logStartOffset() : this._logStartOffset;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (this.isLocal()) {
            if (newHighWatermark.messageOffset() < 0L) {
                throw new IllegalArgumentException("High watermark offset should be non-negative");
            }
        } else {
            throw new KafkaException(new StringBuilder(64).append("Should not set high watermark on partition ").append(this.topicPartition()).append("'s non-local replica ").append(this.brokerId()).toString());
        }
        this.highWatermarkMetadata = newHighWatermark;
        this.log().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onHighWatermarkIncremented(newHighWatermark.messageOffset());
            return BoxedUnit.UNIT;
        });
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Setting high watermark for replica ").append(this.brokerId()).append(" partition ").append(this.topicPartition()).append(" to [").append(newHighWatermark).append("]").toString());
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public LogOffsetMetadata lastStableOffset() {
        return (LogOffsetMetadata)this.log().map((Function1 & Serializable & scala.Serializable)log -> {
            Some some;
            LogOffsetMetadata offsetMetadata;
            Option<LogOffsetMetadata> option = log.firstUnstableOffset();
            LogOffsetMetadata logOffsetMetadata = option instanceof Some && (offsetMetadata = (LogOffsetMetadata)(some = (Some)option).value()).messageOffset() < this.highWatermark().messageOffset() ? offsetMetadata : this.highWatermark();
            return logOffsetMetadata;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringBuilder(48).append("Cannot fetch last stable offset on partition ").append(this.topicPartition()).append("'s ").append(new StringBuilder(18).append("non-local replica ").append(this.brokerId()).toString()).toString());
        });
    }

    public void convertHWToLocalOffsetMetadata() {
        if (!this.isLocal()) {
            throw new KafkaException(new StringBuilder(79).append("Should not construct complete high watermark on partition ").append(this.topicPartition()).append("'s non-local replica ").append(this.brokerId()).toString());
        }
        this.highWatermarkMetadata = (LogOffsetMetadata)((Log)this.log().get()).convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (LogOffsetMetadata)((Log)this.log().get()).convertToOffsetMetadata(this.logStartOffset()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            long firstSegmentOffset = ((LogSegment)((Log)this.log().get()).logSegments().head()).baseOffset();
            return new LogOffsetMetadata(firstSegmentOffset, firstSegmentOffset, 0);
        }));
    }

    public LogOffsetSnapshot offsetSnapshot() {
        return new LogOffsetSnapshot(this.logStartOffset(), this.logEndOffset(), this.highWatermark(), this.lastStableOffset());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Replica)) return false;
        Replica replica = (Replica)object;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!topicPartition.equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public String toString() {
        BoxedUnit boxedUnit;
        scala.collection.mutable.StringBuilder replicaString = new scala.collection.mutable.StringBuilder();
        replicaString.append(new StringBuilder(18).append("Replica(replicaId=").append(this.brokerId()).toString());
        replicaString.append(new StringBuilder(8).append(", topic=").append(this.topicPartition().topic()).toString());
        replicaString.append(new StringBuilder(12).append(", partition=").append(this.topicPartition().partition()).toString());
        replicaString.append(new StringBuilder(10).append(", isLocal=").append(this.isLocal()).toString());
        replicaString.append(new StringBuilder(21).append(", lastCaughtUpTimeMs=").append(this.lastCaughtUpTimeMs()).toString());
        if (this.isLocal()) {
            replicaString.append(new StringBuilder(16).append(", highWatermark=").append(this.highWatermark()).toString());
            boxedUnit = replicaString.append(new StringBuilder(19).append(", lastStableOffset=").append(this.lastStableOffset()).toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        replicaString.append(")");
        return replicaString.toString();
    }

    public Replica(int brokerId, TopicPartition topicPartition, Time time, long initialHighWatermarkValue, Option<Log> log) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        this.initialHighWatermarkValue = initialHighWatermarkValue;
        this.log = log;
        Logging.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this.logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this._logStartOffset = Log$.MODULE$.UnknownLogStartOffset();
        this.lastFetchLeaderLogEndOffset = 0L;
        this.lastFetchTimeMs = 0L;
        this._lastCaughtUpTimeMs = 0L;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Replica loaded for partition ").append(this.topicPartition()).append(" with initial high watermark ").append($this.initialHighWatermarkValue).toString());
        this.log().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.onHighWatermarkIncremented(this.initialHighWatermarkValue);
            return BoxedUnit.UNIT;
        });
    }
}

