/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.Callbacks;
import kafka.controller.Callbacks$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003\u0019\u0019wN\u001c4jOB\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005mA\"aC&bM.\f7i\u001c8gS\u001eD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bCA\u0010!\u001b\u0005\u0011\u0011BA\u0011\u0003\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0011\u0005})\u0013B\u0001\u0014\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005!Bo\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u0004\"a\b\u0016\n\u0005-\u0012!\u0001\u0006+pa&\u001cG)\u001a7fi&|g.T1oC\u001e,'\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003!Q8n\u00117jK:$\bCA\u00183\u001b\u0005\u0001$BA\u0019\u0005\u0003\tQ8.\u0003\u00024a\ti1*\u00194lCj[7\t\\5f]RD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\re\u0016\u0004H.[2b'R\fG/\u001a\t\u0005oqr\u0014)D\u00019\u0015\tI$(A\u0004nkR\f'\r\\3\u000b\u0005mR\u0011AC2pY2,7\r^5p]&\u0011Q\b\u000f\u0002\u0004\u001b\u0006\u0004\bCA\u0010@\u0013\t\u0001%AA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\r\u0005\u0002 \u0005&\u00111I\u0001\u0002\r%\u0016\u0004H.[2b'R\fG/\u001a\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\u0006a2m\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007CA\u0010H\u0013\tA%A\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\t\u000b)\u0003A\u0011A&\u0002\rqJg.\u001b;?)!aUJT(Q#J\u001b\u0006CA\u0010\u0001\u0011\u0015)\u0012\n1\u0001\u0017\u0011\u0015i\u0012\n1\u0001\u001f\u0011\u0015\u0019\u0013\n1\u0001%\u0011\u0015A\u0013\n1\u0001*\u0011\u0015i\u0013\n1\u0001/\u0011\u0015)\u0014\n1\u00017\u0011\u0015)\u0015\n1\u0001G\u0011\u001d)\u0006A1A\u0005\nY\u000bAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012a\u0016\t\u0003\u0013aK!!\u0017\u0006\u0003\u0007%sG\u000f\u0003\u0004\\\u0001\u0001\u0006IaV\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\t\u000bu\u0003A\u0011\u00010\u0002\u000fM$\u0018M\u001d;vaR\tq\f\u0005\u0002\nA&\u0011\u0011M\u0003\u0002\u0005+:LG\u000fC\u0003d\u0001\u0011\u0005a,\u0001\u0005tQV$Hm\\<o\u0011\u0015)\u0007\u0001\"\u0003_\u0003YIg.\u001b;jC2L'0\u001a*fa2L7-Y*uCR,\u0007\"B4\u0001\t\u0003A\u0017A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$BaX5xs\")!N\u001aa\u0001W\u0006A!/\u001a9mS\u000e\f7\u000fE\u0002mizr!!\u001c:\u000f\u00059\fX\"A8\u000b\u0005A4\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t\u0019(\"A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(aA*fc*\u00111O\u0003\u0005\u0006q\u001a\u0004\r!Q\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\rC\u0004{MB\u0005\t\u0019A>\u0002\u0013\r\fG\u000e\u001c2bG.\u001c\bCA\u0010}\u0013\ti(AA\u0005DC2d'-Y2lg\"1q\u0010\u0001C\u0005\u0003\u0003\tA\u0003Z8IC:$G.Z*uCR,7\t[1oO\u0016\u001cH#C0\u0002\u0004\u0005\u001d\u00111EA\u0013\u0011\u0019\t)A a\u0001/\u0006I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\b\u0003\u0013q\b\u0019AA\u0006\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0005YR\fi\u0001\u0005\u0003\u0002\u0010\u0005}QBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\r\r|W.\\8o\u0015\r)\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003;\t1a\u001c:h\u0013\u0011\t\t#!\u0005\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")\u0001P a\u0001\u0003\")!P a\u0001w\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0012!\u0006:f[>4XMU3qY&\u001c\u0017m\u001d$s_6L5O\u001d\u000b\u0007\u0003[\t\t%a\u0011\u0011\u0011\u0005=\u0012qGA\u0007\u0003wqA!!\r\u00024A\u0011aNC\u0005\u0004\u0003kQ\u0011A\u0002)sK\u0012,g-C\u0002>\u0003sQ1!!\u000e\u000b!\ry\u0012QH\u0005\u0004\u0003\u007f\u0011!a\u0007'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002\u0006\u0005\u001d\u0002\u0019A,\t\u0011\u0005%\u0011q\u0005a\u0001\u0003\u0017Aq!a\u0012\u0001\t\u0013\tI%A\fe_J+Wn\u001c<f%\u0016\u0004H.[2bg\u001a\u0013x.\\%teR1\u00111JA-\u00037\u0002\u0012\"CA'\u0003[\tY!!\u0015\n\u0007\u0005=#B\u0001\u0004UkBdWm\r\t\t\u0003_\t9$!\u0004\u0002TA\u0019A.!\u0016\n\u0007\u0005]cOA\u0005Fq\u000e,\u0007\u000f^5p]\"9\u0011QAA#\u0001\u00049\u0006\u0002CA\u0005\u0003\u000b\u0002\r!a\u0003\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b\u0005ir-\u001a;U_BL7\rU1si&$\u0018n\u001c8Ti\u0006$Xm\u001d$s_6T6\u000e\u0006\u0003\u0002d\u0005M\u0004#C\u0005\u0002N\u0005\u0015\u00141BA)!!\ty#a\u000e\u0002\u000e\u0005\u001d\u0004\u0003BA5\u0003_j!!a\u001b\u000b\u0007\u00055D!A\u0002ba&LA!!\u001d\u0002l\taA*Z1eKJ\fe\u000eZ%te\"A\u0011\u0011BA/\u0001\u0004\tY\u0001C\u0004\u0002x\u0001!\t!!\u001f\u0002S%\u001c\u0018\t\u001e'fCN$xJ\\3SKBd\u0017nY1J]\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012\u001cF/\u0019;f)\u0011\tY(!!\u0011\u0007%\ti(C\u0002\u0002\u0000)\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0004\u0006U\u0004\u0019AAC\u0003\u0015!x\u000e]5d!\u0011\ty#a\"\n\t\u0005%\u0015\u0011\b\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\u0006y!/\u001a9mS\u000e\f7/\u00138Ti\u0006$X\r\u0006\u0004\u0002\u0012\u0006]\u0015\u0011\u0014\t\u0006\u0003_\t\u0019JP\u0005\u0005\u0003+\u000bIDA\u0002TKRD\u0001\"a!\u0002\f\u0002\u0007\u0011Q\u0011\u0005\b\u00037\u000bY\t1\u0001B\u0003\u0015\u0019H/\u0019;f\u0011\u001d\ty\n\u0001C\u0001\u0003C\u000bQ$\u0019:f\u00032d'+\u001a9mS\u000e\f7OR8s)>\u0004\u0018n\u0019#fY\u0016$X\r\u001a\u000b\u0005\u0003w\n\u0019\u000b\u0003\u0005\u0002\u0004\u0006u\u0005\u0019AAC\u0011\u001d\t9\u000b\u0001C\u0001\u0003S\u000b1#[:B]f\u0014V\r\u001d7jG\u0006Len\u0015;bi\u0016$b!a\u001f\u0002,\u00065\u0006\u0002CAB\u0003K\u0003\r!!\"\t\u000f\u0005m\u0015Q\u0015a\u0001\u0003\"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0016!E5t-\u0006d\u0017\u000e\u001a+sC:\u001c\u0018\u000e^5p]R1\u00111PA[\u0003sCq!a.\u00020\u0002\u0007a(A\u0004sKBd\u0017nY1\t\ra\fy\u000b1\u0001B\u0011\u001d\ti\f\u0001C\u0005\u0003\u007f\u000bq\u0003\\8h'V\u001c7-Z:tMVdGK]1og&$\u0018n\u001c8\u0015\u0013}\u000b\t-a1\u0002H\u0006-\u0007bBA\u0003\u0003w\u0003\ra\u0016\u0005\t\u0003\u000b\fY\f1\u0001\u0002\u000e\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0003\u0013\fY\f1\u0001B\u0003%\u0019WO\u001d:Ti\u0006$X\r\u0003\u0004y\u0003w\u0003\r!\u0011\u0005\b\u0003\u001f\u0004A\u0011BAi\u0003QawnZ%om\u0006d\u0017\u000e\u001a+sC:\u001c\u0018\u000e^5p]R)q,a5\u0002V\"9\u0011qWAg\u0001\u0004q\u0004B\u0002=\u0002N\u0002\u0007\u0011\tC\u0004\u0002Z\u0002!I!a7\u0002)1|wMR1jY\u0016$7\u000b^1uK\u000eC\u0017M\\4f)%y\u0016Q\\Ap\u0003C\f\u0019\u000fC\u0004\u00028\u0006]\u0007\u0019\u0001 \t\u000f\u0005%\u0017q\u001ba\u0001\u0003\"1\u00010a6A\u0002\u0005C\u0001\"!:\u0002X\u0002\u0007\u0011q]\u0001\u0002iB\u0019A.!;\n\u0007\u0005-hOA\u0005UQJ|w/\u00192mK\"I\u0011q\u001e\u0001\u0012\u0002\u0013\u0005\u0011\u0011_\u0001\u001dQ\u0006tG\r\\3Ti\u0006$Xm\u00115b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019PK\u0002|\u0003k\\#!a>\u0011\t\u0005e(1A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0003Q\u0011AC1o]>$\u0018\r^5p]&!!QAA~\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ReplicaStateMachine
implements Logging {
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final TopicDeletionManager topicDeletionManager;
    private final KafkaZkClient zkClient;
    private final Map<PartitionAndReplica, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch controllerBrokerRequestBatch;
    private final int controllerId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing replica state");
        this.initializeReplicaState();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Triggering online replica state changes");
        this.handleStateChanges((Seq<PartitionAndReplica>)this.controllerContext.allLiveReplicas().toSeq(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Started replica state machine with initial state -> ").append($this.replicaState).toString());
    }

    public void shutdown() {
        this.replicaState.clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped replica state machine");
    }

    private void initializeReplicaState() {
        this.controllerContext.allPartitions().foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ReplicaStateMachine.$anonfun$initializeReplicaState$1(this, partition);
            return BoxedUnit.UNIT;
        });
    }

    public void handleStateChanges(Seq<PartitionAndReplica> replicas, ReplicaState targetState, Callbacks callbacks) {
        if (replicas.nonEmpty()) {
            try {
                this.controllerBrokerRequestBatch.newBatch();
                replicas.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.replica())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    ReplicaStateMachine.$anonfun$handleStateChanges$2(this, targetState, callbacks, x0$1);
                    return BoxedUnit.UNIT;
                }, Iterable$.MODULE$.canBuildFrom());
                this.controllerBrokerRequestBatch.sendRequestsToBrokers(this.controllerContext.epoch());
            }
            catch (ControllerMovedException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Controller moved to another broker when moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Error while moving some replicas to ").append(targetState).append(" state").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks(Callbacks$.MODULE$.$lessinit$greater$default$1());
    }

    private void doHandleStateChanges(int replicaId, Seq<TopicPartition> partitions, ReplicaState targetState, Callbacks callbacks) {
        Seq replicas = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> new PartitionAndReplica((TopicPartition)partition, replicaId), Seq$.MODULE$.canBuildFrom());
        replicas.foreach((Function1 & Serializable & scala.Serializable)replica -> (ReplicaState)$this.replicaState.getOrElseUpdate(replica, (Function0 & Serializable & scala.Serializable)() -> NonExistentReplica$.MODULE$));
        Tuple2 tuple2 = replicas.partition((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)this.isValidTransition(replica, targetState)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq validReplicas = (Seq)tuple2._1();
        Seq invalidReplicas = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validReplicas, (Object)invalidReplicas);
        Tuple2 tuple23 = tuple22;
        Seq validReplicas2 = (Seq)tuple23._1();
        Seq invalidReplicas2 = (Seq)tuple23._2();
        invalidReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
            this.logInvalidTransition(replica, targetState);
            return BoxedUnit.UNIT;
        });
        ReplicaState replicaState = targetState;
        if (NewReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                Option option;
                TopicPartition partition = replica.topicPartition();
                Option option2 = $this.controllerContext.partitionLeadershipInfo().get((Object)partition);
                if (option2 instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option2;
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                    if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId) {
                        StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Replica ").append(replicaId).append(" for partition ").append(partition).append(" cannot be moved to NewReplica state as it is being requested to become leader").toString());
                        this.logFailedStateChange((PartitionAndReplica)replica, (ReplicaState)$this.replicaState.apply(replica), OfflineReplica$.MODULE$, exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId}))), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(replica.topicPartition()), true);
                        this.logSuccessfulTransition(replicaId, partition, (ReplicaState)$this.replicaState.apply(replica), NewReplica$.MODULE$);
                        boxedUnit = $this.replicaState.put(replica, (Object)NewReplica$.MODULE$);
                    }
                    option = boxedUnit;
                } else if (None$.MODULE$.equals(option2)) {
                    this.logSuccessfulTransition(replicaId, partition, (ReplicaState)$this.replicaState.apply(replica), NewReplica$.MODULE$);
                    option = $this.replicaState.put(replica, (Object)NewReplica$.MODULE$);
                } else {
                    throw new MatchError((Object)option2);
                }
                return option;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OnlineReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                TopicPartition partition = replica.topicPartition();
                ReplicaState replicaState = (ReplicaState)$this.replicaState.apply(replica);
                if (NewReplica$.MODULE$.equals(replicaState)) {
                    BoxedUnit boxedUnit;
                    Seq<Object> assignment = $this.controllerContext.partitionReplicaAssignment(partition);
                    if (!assignment.contains((Object)BoxesRunTime.boxToInteger((int)replicaId))) {
                        $this.controllerContext.updatePartitionReplicaAssignment(partition, (Seq<Object>)((Seq)assignment.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId), Seq$.MODULE$.canBuildFrom())));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    Option option = $this.controllerContext.partitionLeadershipInfo().get((Object)partition);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId}))), replica.topicPartition(), leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(partition), false);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.logSuccessfulTransition(replicaId, partition, (ReplicaState)$this.replicaState.apply(replica), OnlineReplica$.MODULE$);
                return $this.replicaState.put(replica, (Object)OnlineReplica$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OfflineReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId}))), replica.topicPartition(), false, (Function2<AbstractResponse, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$4, x$5) -> {
                    ReplicaStateMachine.$anonfun$doHandleStateChanges$9(x$4, BoxesRunTime.unboxToInt((Object)x$5));
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple24 = validReplicas2.partition((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$doHandleStateChanges$10(this, replica)));
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Seq replicasWithLeadershipInfo = (Seq)tuple24._1();
            Seq replicasWithoutLeadershipInfo = (Seq)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)replicasWithLeadershipInfo, (Object)replicasWithoutLeadershipInfo);
            Tuple2 tuple26 = tuple25;
            Seq replicasWithLeadershipInfo2 = (Seq)tuple26._1();
            Seq replicasWithoutLeadershipInfo2 = (Seq)tuple26._2();
            scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> updatedLeaderIsrAndControllerEpochs = this.removeReplicasFromIsr(replicaId, (Seq<TopicPartition>)((Seq)replicasWithLeadershipInfo2.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.topicPartition(), Seq$.MODULE$.canBuildFrom())));
            updatedLeaderIsrAndControllerEpochs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TopicPartition partition;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    partition = (TopicPartition)tuple2._1();
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                    if (!$this.topicDeletionManager.isTopicQueuedUpForDeletion(partition.topic())) {
                        Seq recipients = (Seq)$this.controllerContext.partitionReplicaAssignment(partition).filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 == replicaId);
                        $this.controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)recipients, partition, leaderIsrAndControllerEpoch, $this.controllerContext.partitionReplicaAssignment(partition), false);
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId);
                this.logSuccessfulTransition(replicaId, partition, (ReplicaState)$this.replicaState.apply((Object)replica), OfflineReplica$.MODULE$);
                Option option = $this.replicaState.put((Object)replica, (Object)OfflineReplica$.MODULE$);
                return option;
            });
            replicasWithoutLeadershipInfo2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                this.logSuccessfulTransition(replicaId, replica.topicPartition(), (ReplicaState)$this.replicaState.apply(replica), OfflineReplica$.MODULE$);
                return $this.replicaState.put(replica, (Object)OfflineReplica$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReplicaDeletionStarted$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                ReplicaStateMachine.$anonfun$doHandleStateChanges$15(this, replicaId, callbacks, replica);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                this.logSuccessfulTransition(replicaId, replica.topicPartition(), (ReplicaState)$this.replicaState.apply(replica), ReplicaDeletionIneligible$.MODULE$);
                return $this.replicaState.put(replica, (Object)ReplicaDeletionIneligible$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                this.logSuccessfulTransition(replicaId, replica.topicPartition(), (ReplicaState)$this.replicaState.apply(replica), ReplicaDeletionSuccessful$.MODULE$);
                return $this.replicaState.put(replica, (Object)ReplicaDeletionSuccessful$.MODULE$);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (NonExistentReplica$.MODULE$.equals(replicaState)) {
            validReplicas2.foreach((Function1 & Serializable & scala.Serializable)replica -> {
                Seq<Object> currentAssignedReplicas = $this.controllerContext.partitionReplicaAssignment(replica.topicPartition());
                $this.controllerContext.updatePartitionReplicaAssignment(replica.topicPartition(), (Seq<Object>)((Seq)currentAssignedReplicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 == replica.replica())));
                this.logSuccessfulTransition(replicaId, replica.topicPartition(), (ReplicaState)$this.replicaState.apply(replica), NonExistentReplica$.MODULE$);
                return $this.replicaState.remove(replica);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)replicaState);
        }
    }

    private scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> removeReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        scala.collection.immutable.Map results = Predef$.MODULE$.Map().empty();
        Seq remaining = partitions;
        while (remaining.nonEmpty()) {
            Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.doRemoveReplicasFromIsr(replicaId, remaining);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            scala.collection.immutable.Map successfulRemovals = (scala.collection.immutable.Map)tuple3._1();
            Seq removalsToRetry = (Seq)tuple3._2();
            scala.collection.immutable.Map failedRemovals = (scala.collection.immutable.Map)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)successfulRemovals, (Object)removalsToRetry, (Object)failedRemovals);
            Tuple3 tuple33 = tuple32;
            scala.collection.immutable.Map successfulRemovals2 = (scala.collection.immutable.Map)tuple33._1();
            Seq removalsToRetry2 = (Seq)tuple33._2();
            scala.collection.immutable.Map failedRemovals2 = (scala.collection.immutable.Map)tuple33._3();
            results = results.$plus$plus((GenTraversableOnce)successfulRemovals2);
            remaining = removalsToRetry2;
            failedRemovals2.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                ReplicaStateMachine.$anonfun$removeReplicasFromIsr$1(this, replicaId, x0$3);
                return BoxedUnit.UNIT;
            });
        }
        return results;
    }

    private Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> doRemoveReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.getTopicPartitionStatesFromZk(partitions);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        scala.collection.immutable.Map leaderAndIsrs = (scala.collection.immutable.Map)tuple3._1();
        Seq partitionsWithNoLeaderAndIsrInZk = (Seq)tuple3._2();
        scala.collection.immutable.Map failedStateReads = (scala.collection.immutable.Map)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)leaderAndIsrs, (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failedStateReads);
        Tuple3 tuple33 = tuple32;
        scala.collection.immutable.Map leaderAndIsrs2 = (scala.collection.immutable.Map)tuple33._1();
        Seq partitionsWithNoLeaderAndIsrInZk2 = (Seq)tuple33._2();
        scala.collection.immutable.Map failedStateReads2 = (scala.collection.immutable.Map)tuple33._3();
        Tuple2 tuple2 = leaderAndIsrs2.partition((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$doRemoveReplicasFromIsr$1(replicaId, x0$4)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Map leaderAndIsrsWithReplica = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map leaderAndIsrsWithoutReplica = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leaderAndIsrsWithReplica, (Object)leaderAndIsrsWithoutReplica);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Map leaderAndIsrsWithReplica2 = (scala.collection.immutable.Map)tuple23._1();
        scala.collection.immutable.Map leaderAndIsrsWithoutReplica2 = (scala.collection.immutable.Map)tuple23._2();
        scala.collection.immutable.Map adjustedLeaderAndIsrs = leaderAndIsrsWithReplica2.mapValues((Function1 & Serializable & scala.Serializable)leaderAndIsr -> {
            int newLeader = replicaId == leaderAndIsr.leader() ? LeaderAndIsr$.MODULE$.NoLeader() : leaderAndIsr.leader();
            List adjustedIsr = leaderAndIsr.isr().size() == 1 ? leaderAndIsr.isr() : (List)leaderAndIsr.isr().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$13 -> x$13 != replicaId);
            return leaderAndIsr.newLeaderAndIsr(newLeader, (List<Object>)adjustedIsr);
        });
        KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.controllerContext.epoch(), this.controllerContext.epochZkVersion());
        if (updateLeaderAndIsrResult == null) {
            throw new MatchError((Object)updateLeaderAndIsrResult);
        }
        scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
        Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
        scala.collection.immutable.Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
        Tuple3 tuple34 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
        Tuple3 tuple35 = tuple34;
        scala.collection.immutable.Map successfulUpdates2 = (scala.collection.immutable.Map)tuple35._1();
        Seq updatesToRetry2 = (Seq)tuple35._2();
        scala.collection.immutable.Map failedUpdates2 = (scala.collection.immutable.Map)tuple35._3();
        scala.collection.immutable.Map exceptionsForPartitionsWithNoLeaderAndIsrInZk = ((TraversableOnce)partitionsWithNoLeaderAndIsrInZk2.flatMap((Function1 & Serializable & scala.Serializable)partition -> {
            Iterable iterable;
            if (!$this.topicDeletionManager.isTopicQueuedUpForDeletion(partition.topic())) {
                StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(101).append("Failed to change state of replica ").append(replicaId).append(" for partition ").append(partition).append(" since the leader and isr path in zookeeper is empty").toString());
                iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)exception)));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map leaderIsrAndControllerEpochs = (scala.collection.immutable.Map)leaderAndIsrsWithoutReplica2.$plus$plus((GenTraversableOnce)successfulUpdates2).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
            $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return new Tuple3((Object)leaderIsrAndControllerEpochs, (Object)updatesToRetry2, (Object)failedStateReads2.$plus$plus((GenTraversableOnce)exceptionsForPartitionsWithNoLeaderAndIsrInZk).$plus$plus((GenTraversableOnce)failedUpdates2));
    }

    private Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> getTopicPartitionStatesFromZk(Seq<TopicPartition> partitions) {
        Seq<GetDataResponse> seq;
        Map leaderAndIsrs = Map$.MODULE$.empty();
        Buffer partitionsWithNoLeaderAndIsrInZk = (Buffer)Buffer$.MODULE$.empty();
        Map failed = Map$.MODULE$.empty();
        try {
            seq = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception e) {
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> failed.put(partition, (Object)e));
            return new Tuple3((Object)leaderAndIsrs.toMap(Predef$.MODULE$.$conforms()), (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failed.toMap(Predef$.MODULE$.$conforms()));
        }
        Seq<GetDataResponse> getDataResponses = seq;
        getDataResponses.foreach((Function1 & Serializable & scala.Serializable)getDataResponse -> {
            Object object;
            TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
            KeeperException.Code code = getDataResponse.resultCode();
            KeeperException.Code code2 = KeeperException.Code.OK;
            if (!(code != null ? !code.equals(code2) : code2 != null)) {
                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                    object = partitionsWithNoLeaderAndIsrInZk.$plus$eq((Object)partition);
                } else {
                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochOpt.get();
                    if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                        StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder(64).append("Leader and isr path written by another controller. This probably").append(new StringBuilder(81).append("means the current controller with epoch ").append($this.controllerContext.epoch()).append(" went through a soft failure and another ").toString()).append(new StringBuilder(76).append("controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(". Aborting state change by this controller").toString()).toString());
                        object = failed.put((Object)partition, (Object)exception);
                    } else {
                        object = leaderAndIsrs.put((Object)partition, (Object)leaderIsrAndControllerEpoch.leaderAndIsr());
                    }
                }
            } else {
                KeeperException.Code code3 = getDataResponse.resultCode();
                KeeperException.Code code4 = KeeperException.Code.NONODE;
                object = !(code3 != null ? !code3.equals(code4) : code4 != null) ? partitionsWithNoLeaderAndIsrInZk.$plus$eq((Object)partition) : failed.put((Object)partition, getDataResponse.resultException().get());
            }
            return object;
        });
        return new Tuple3((Object)leaderAndIsrs.toMap(Predef$.MODULE$.$conforms()), (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failed.toMap(Predef$.MODULE$.$conforms()));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        return this.controllerContext.replicasForTopic(topic).exists((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAtLeastOneReplicaInDeletionStartedState$1(this, replica)));
    }

    public Set<PartitionAndReplica> replicasInState(String topic, ReplicaState state) {
        return ((MapLike)this.replicaState.filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$replicasInState$1(topic, state, x0$6)))).keySet().toSet();
    }

    public boolean areAllReplicasForTopicDeleted(String topic) {
        return this.controllerContext.replicasForTopic(topic).forall((Function1 & Serializable & scala.Serializable)replica -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$areAllReplicasForTopicDeleted$1(this, replica)));
    }

    public boolean isAnyReplicaInState(String topic, ReplicaState state) {
        return this.replicaState.exists((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAnyReplicaInState$1(topic, state, x0$7)));
    }

    private boolean isValidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        return targetState.validPreviousStates().contains(this.replicaState.apply((Object)replica));
    }

    private void logSuccessfulTransition(int replicaId, TopicPartition partition, ReplicaState currState, ReplicaState targetState) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Changed state of replica ").append(replicaId).append(" for partition ").append(partition).append(" from ").append(currState).append(" to ").append(targetState).toString());
    }

    private void logInvalidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        ReplicaState currState = (ReplicaState)this.replicaState.apply((Object)replica);
        IllegalStateException e = new IllegalStateException(new StringBuilder(27).append("Replica ").append(replica).append(" should be in the ").append(targetState.validPreviousStates().mkString(",")).append(" ").append(new StringBuilder(55).append("states before moving to ").append(targetState).append(" state. Instead it is in ").append(currState).append(" state").toString()).toString());
        this.logFailedStateChange(replica, currState, targetState, e);
    }

    private void logFailedStateChange(PartitionAndReplica replica, ReplicaState currState, ReplicaState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.controllerContext.epoch()).error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Controller ").append(this.controllerId()).append(" epoch ").append($this.controllerContext.epoch()).append(" initiated state change of replica ").append(replica.replica()).append(" ").append(new StringBuilder(31).append("for partition ").append(replica.topicPartition()).append(" from ").append(currState).append(" to ").append(targetState).append(" failed").toString()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
    }

    public static final /* synthetic */ Option $anonfun$initializeReplicaState$2(ReplicaStateMachine $this, TopicPartition partition$2, int replicaId) {
        PartitionAndReplica partitionAndReplica = new PartitionAndReplica(partition$2, replicaId);
        return $this.controllerContext.isReplicaOnline(replicaId, partition$2, $this.controllerContext.isReplicaOnline$default$3()) ? $this.replicaState.put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$) : $this.replicaState.put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$initializeReplicaState$1(ReplicaStateMachine $this, TopicPartition partition) {
        Seq<Object> replicas = $this.controllerContext.partitionReplicaAssignment(partition);
        replicas.foreach((Function1 & Serializable & scala.Serializable)replicaId -> ReplicaStateMachine.$anonfun$initializeReplicaState$2($this, partition, BoxesRunTime.unboxToInt((Object)replicaId)));
    }

    public static final /* synthetic */ void $anonfun$handleStateChanges$2(ReplicaStateMachine $this, ReplicaState targetState$1, Callbacks callbacks$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int replicaId = tuple2._1$mcI$sp();
        Seq replicas = (Seq)tuple2._2();
        Seq partitions = (Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicPartition(), Seq$.MODULE$.canBuildFrom());
        $this.doHandleStateChanges(replicaId, (Seq<TopicPartition>)partitions, targetState$1, callbacks$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$9(AbstractResponse x$4, int x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$doHandleStateChanges$10(ReplicaStateMachine $this, PartitionAndReplica replica) {
        return $this.controllerContext.partitionLeadershipInfo().contains((Object)replica.topicPartition());
    }

    public static final /* synthetic */ void $anonfun$doHandleStateChanges$15(ReplicaStateMachine $this, int replicaId$1, Callbacks callbacks$2, PartitionAndReplica replica) {
        $this.logSuccessfulTransition(replicaId$1, replica.topicPartition(), (ReplicaState)$this.replicaState.apply((Object)replica), ReplicaDeletionStarted$.MODULE$);
        $this.replicaState.put((Object)replica, (Object)ReplicaDeletionStarted$.MODULE$);
        $this.controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1}))), replica.topicPartition(), true, callbacks$2.stopReplicaResponseCallback());
    }

    public static final /* synthetic */ void $anonfun$removeReplicasFromIsr$1(ReplicaStateMachine $this, int replicaId$3, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        Exception e = (Exception)tuple2._2();
        PartitionAndReplica replica = new PartitionAndReplica(partition, replicaId$3);
        $this.logFailedStateChange(replica, (ReplicaState)$this.replicaState.apply((Object)replica), OfflineReplica$.MODULE$, e);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveReplicasFromIsr$1(int replicaId$4, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
        boolean bl = leaderAndIsr.isr().contains((Object)BoxesRunTime.boxToInteger((int)replicaId$4));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isAtLeastOneReplicaInDeletionStartedState$1(ReplicaStateMachine $this, PartitionAndReplica replica) {
        Object object = $this.replicaState.apply((Object)replica);
        ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
        return !(object != null ? !object.equals(replicaDeletionStarted$) : replicaDeletionStarted$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replicasInState$1(String topic$1, ReplicaState state$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        PartitionAndReplica replica = (PartitionAndReplica)tuple2._1();
        ReplicaState s = (ReplicaState)tuple2._2();
        if (!replica.topic().equals(topic$1)) return false;
        ReplicaState replicaState = s;
        ReplicaState replicaState2 = state$1;
        if (replicaState != null) {
            if (!replicaState.equals(replicaState2)) return false;
            return true;
        }
        if (replicaState2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$areAllReplicasForTopicDeleted$1(ReplicaStateMachine $this, PartitionAndReplica replica) {
        Object object = $this.replicaState.apply((Object)replica);
        ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
        return !(object != null ? !object.equals(replicaDeletionSuccessful$) : replicaDeletionSuccessful$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isAnyReplicaInState$1(String topic$2, ReplicaState state$2, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        PartitionAndReplica replica = (PartitionAndReplica)tuple2._1();
        ReplicaState s = (ReplicaState)tuple2._2();
        if (!replica.topic().equals(topic$2)) return false;
        ReplicaState replicaState = s;
        ReplicaState replicaState2 = state$2;
        if (replicaState != null) {
            if (!replicaState.equals(replicaState2)) return false;
            return true;
        }
        if (replicaState2 == null) return true;
        return false;
    }

    public ReplicaStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, TopicDeletionManager topicDeletionManager, KafkaZkClient zkClient, Map<PartitionAndReplica, ReplicaState> replicaState, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.stateChangeLogger = stateChangeLogger;
        this.controllerContext = controllerContext;
        this.topicDeletionManager = topicDeletionManager;
        this.zkClient = zkClient;
        this.replicaState = replicaState;
        this.controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.logIdent_$eq(new StringBuilder(36).append("[ReplicaStateMachine controllerId=").append(this.controllerId()).append("] ").toString());
    }
}

