/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.net.SocketTimeoutException;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\t\u001d\u0011!DU3qY&\u001c\u0017MR3uG\",'O\u00117pG.LgnZ*f]\u0012T!a\u0001\u0003\u0002\u000bQ|w\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aD\u0001b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\u0001\u000bg>,(oY3O_\u0012,\u0007CA\t\u001a\u001b\u0005\u0011\"BA\n\u0015\u0003\u0019\u0019w.\\7p]*\u0011Q!\u0006\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014x-\u0003\u0002\u001b%\t!aj\u001c3f\u0011!a\u0002A!A!\u0002\u0013i\u0012AD2p]N,X.\u001a:D_:4\u0017n\u001a\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\n\u0001bY8ogVlWM\u001d\u0006\u0003EQ\tqa\u00197jK:$8/\u0003\u0002%?\tq1i\u001c8tk6,'oQ8oM&<\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000f5,GO]5dgB\u0011\u0001FK\u0007\u0002S)\u0011aEE\u0005\u0003W%\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0011!\u0018.\\3\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\u0012\u0012!B;uS2\u001c\u0018BA\u001a1\u0005\u0011!\u0016.\\3\t\u0011U\u0002!\u0011!Q\u0001\nY\n\u0011BZ3uG\",'/\u00133\u0011\u0005%9\u0014B\u0001\u001d\u000b\u0005\rIe\u000e\u001e\u0005\tu\u0001\u0011\t\u0011)A\u0005w\u0005A1\r\\5f]RLE\r\u0005\u0002=\u0007:\u0011Q(\u0011\t\u0003})i\u0011a\u0010\u0006\u0003\u0001\u001a\ta\u0001\u0010:p_Rt\u0014B\u0001\"\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tS\u0001\"B$\u0001\t\u0003A\u0015A\u0002\u001fj]&$h\bF\u0004J\u00172kej\u0014)\u0011\u0005)\u0003Q\"\u0001\u0002\t\u000b=1\u0005\u0019\u0001\t\t\u000bq1\u0005\u0019A\u000f\t\u000b\u00192\u0005\u0019A\u0014\t\u000b52\u0005\u0019\u0001\u0018\t\u000bU2\u0005\u0019\u0001\u001c\t\u000bi2\u0005\u0019A\u001e\t\u000fI\u0003!\u0019!C\u0005'\u0006i1o\\2lKR$\u0016.\\3pkR,\u0012A\u000e\u0005\u0007+\u0002\u0001\u000b\u0011\u0002\u001c\u0002\u001dM|7m[3u)&lWm\\;uA!9q\u000b\u0001b\u0001\n\u0013A\u0016!\u00048fi^|'o[\"mS\u0016tG/F\u0001Z!\tQ6,D\u0001\"\u0013\ta\u0016EA\u0007OKR<xN]6DY&,g\u000e\u001e\u0005\u0007=\u0002\u0001\u000b\u0011B-\u0002\u001d9,Go^8sW\u000ec\u0017.\u001a8uA!)\u0001\r\u0001C\u0001C\u0006Y1/\u001a8e%\u0016\fX/Z:u)\t\u0011W\r\u0005\u0002[G&\u0011A-\t\u0002\u000f\u00072LWM\u001c;SKN\u0004xN\\:f\u0011\u00151w\f1\u0001h\u00039\u0011X-];fgR\u0014U/\u001b7eKJ\u0004$\u0001[?\u0011\u0007%D8P\u0004\u0002kk:\u00111n\u001d\b\u0003YJt!!\\9\u000f\u00059\u0004hB\u0001 p\u0013\u0005A\u0012B\u0001\f\u0018\u0013\t)Q#\u0003\u0002\u0014)%\u0011AOE\u0001\te\u0016\fX/Z:ug&\u0011ao^\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti*\u0011AOE\u0005\u0003sj\u0014qAQ;jY\u0012,'O\u0003\u0002woB\u0011A0 \u0007\u0001\t%qX-!A\u0001\u0002\u000b\u0005qPA\u0002`IE\nB!!\u0001\u0002\bA\u0019\u0011\"a\u0001\n\u0007\u0005\u0015!BA\u0004O_RD\u0017N\\4\u0011\t\u0005%\u00111B\u0007\u0002o&\u0019\u0011QB<\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDq!!\u0005\u0001\t\u0003\t\u0019\"A\u0003dY>\u001cX\r\u0006\u0002\u0002\u0016A\u0019\u0011\"a\u0006\n\u0007\u0005e!B\u0001\u0003V]&$\b")
public class ReplicaFetcherBlockingSend {
    private final Node sourceNode;
    private final Time time;
    private final int socketTimeout;
    private final NetworkClient networkClient;

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ClientResponse clientResponse;
        try {
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)this.sourceNode, (Time)this.time, (long)this.socketTimeout())) {
                throw new SocketTimeoutException(new StringBuilder(28).append("Failed to connect within ").append(this.socketTimeout()).append(" ms").toString());
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger((int)this.sourceNode.id())).toString(), requestBuilder, this.time.milliseconds(), true);
            clientResponse = NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)clientRequest, (Time)this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger((int)this.sourceNode.id())).toString());
            throw e;
        }
        return clientResponse;
    }

    public void close() {
        this.networkClient().close();
    }

    public ReplicaFetcherBlockingSend(Node sourceNode, ConsumerConfig consumerConfig, Metrics metrics, Time time, int fetcherId, String clientId) {
        this.sourceNode = sourceNode;
        this.time = time;
        this.socketTimeout = Predef$.MODULE$.Integer2int(consumerConfig.getInt("request.timeout.ms"));
        ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder((AbstractConfig)consumerConfig);
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(consumerConfig.getLong("connections.max.idle.ms")), metrics, time, "replica-fetcher", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)sourceNode.id())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)((Object)BoxesRunTime.boxToInteger((int)fetcherId)).toString())}))).asJava(), false, channelBuilder, new LogContext());
        this.networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(consumerConfig.getInt("receive.buffer.bytes")), Predef$.MODULE$.Integer2int(consumerConfig.getInt("request.timeout.ms")), ClientDnsLookup.DEFAULT, time, false, new ApiVersions(), new LogContext());
    }
}

