/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AclCommand;
import kafka.admin.AclCommand$;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.AlterConfigs$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Cluster$;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.DelegationToken$;
import kafka.security.auth.Delete$;
import kafka.security.auth.Describe$;
import kafka.security.auth.DescribeConfigs$;
import kafka.security.auth.Group$;
import kafka.security.auth.IdempotentWrite$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.PermissionType$;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.auth.Topic$;
import kafka.security.auth.TransactionalId$;
import kafka.security.auth.Write$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001\u0002\u001f>\u0001\tCQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001A\u0002\u0013\u0005A\u000bC\u0004j\u0001\u0001\u0007I\u0011\u00016\t\rE\u0004\u0001\u0015)\u0003V\u0011\u001d\u0011\bA1A\u0005\nMDq!a\u0002\u0001A\u0003%A\u000fC\u0005\u0002\n\u0001\u0011\r\u0011\"\u0003\u0002\f!A\u0011Q\u0004\u0001!\u0002\u0013\ti\u0001C\u0005\u0002 \u0001\u0011\r\u0011\"\u0003\u0002\"!A\u0011Q\u0007\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002:!A\u0011\u0011\t\u0001!\u0002\u0013\tY\u0004C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002:!A\u0011Q\t\u0001!\u0002\u0013\tY\u0004C\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u0002J!A\u0011\u0011\f\u0001!\u0002\u0013\tY\u0005C\u0005\u0002\\\u0001\u0011\r\u0011\"\u0003\u0002J!A\u0011Q\f\u0001!\u0002\u0013\tY\u0005C\u0005\u0002`\u0001\u0011\r\u0011\"\u0003\u0002J!A\u0011\u0011\r\u0001!\u0002\u0013\tY\u0005C\u0005\u0002d\u0001\u0011\r\u0011\"\u0003\u0002J!A\u0011Q\r\u0001!\u0002\u0013\tY\u0005C\u0005\u0002h\u0001\u0011\r\u0011\"\u0003\u0002j!A\u0011Q\u0011\u0001!\u0002\u0013\tY\u0007C\u0005\u0002\b\u0002\u0011\r\u0011\"\u0003\u0002\n\"A\u00111\u0014\u0001!\u0002\u0013\tY\tC\u0004\u0002\u001e\u0002!I!a(\t\u0013\u0005U\u0006!%A\u0005\n\u0005]\u0006\"CAg\u0001\t\u0007I\u0011BAh\u0011!\t\t\u000e\u0001Q\u0001\n\u0005\u0005\u0006\"CAj\u0001\t\u0007I\u0011BAk\u0011!\ti\u000e\u0001Q\u0001\n\u0005]\u0007bCAp\u0001\u0001\u0007\t\u0019!C\u0005\u0003CD1\"a<\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002r\"Y\u0011Q\u001f\u0001A\u0002\u0003\u0005\u000b\u0015BAr\u0011-\t9\u0010\u0001a\u0001\u0002\u0004%I!!?\t\u0017\u0005m\b\u00011AA\u0002\u0013%\u0011Q \u0005\f\u0005\u0003\u0001\u0001\u0019!A!B\u0013\ty\bC\u0006\u0003\u0004\u0001\u0001\r\u00111A\u0005\n\u0005e\bb\u0003B\u0003\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u000fA1Ba\u0003\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0000!9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u0010\u0001\u0011\u0005#q\u0002\u0005\b\u0005S\u0001A\u0011\u0001B\b\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005\u001fAqAa\u000e\u0001\t\u0013\u0011y\u0001C\u0004\u0003:\u0001!IAa\u000f\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003\u0010!9!Q\t\u0001\u0005\u0002\t=\u0001b\u0002B%\u0001\u0011%!1\n\u0005\b\u0005\u001f\u0002A\u0011\u0001B\b\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005\u001fAqAa\u0016\u0001\t\u0013\u0011I\u0006C\u0004\u0003^\u0001!\tAa\u0004\t\u000f\t-\u0004\u0001\"\u0001\u0003\u0010!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002B?\u0001\u0011%!q\u0010\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0011\u001d\u00119\n\u0001C\u0005\u00053\u0013a\"Q2m\u0007>lW.\u00198e)\u0016\u001cHO\u0003\u0002?\u007f\u0005)\u0011\rZ7j]*\t\u0001)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0019\u0015\n\u0005\u0002E\u000f6\tQI\u0003\u0002G\u007f\u0005\u0011!p[\u0005\u0003\u0011\u0016\u0013ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\bC\u0001&N\u001b\u0005Y%B\u0001'@\u0003\u0015)H/\u001b7t\u0013\tq5JA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\t\u0006C\u0001*\u0001\u001b\u0005i\u0014aB:feZ,'o]\u000b\u0002+B\u0019a\u000bY2\u000f\u0005]kfB\u0001-\\\u001b\u0005I&B\u0001.B\u0003\u0019a$o\\8u}%\tA,A\u0003tG\u0006d\u0017-\u0003\u0002_?\u00069\u0001/Y2lC\u001e,'\"\u0001/\n\u0005\u0005\u0014'aA*fc*\u0011al\u0018\t\u0003I\u001el\u0011!\u001a\u0006\u0003M~\naa]3sm\u0016\u0014\u0018B\u00015f\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003W>\u0004\"\u0001\\7\u000e\u0003}K!A\\0\u0003\tUs\u0017\u000e\u001e\u0005\ba\u000e\t\t\u00111\u0001V\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005I\u0001O]5oG&\u0004\u0018\r\\\u000b\u0002iB\u0019Q/a\u0001\u000e\u0003YT!a\u001e=\u0002\t\u0005,H\u000f\u001b\u0006\u0003sj\f\u0001b]3dkJLG/\u001f\u0006\u0003wr\faaY8n[>t'B\u0001!~\u0015\tqx0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0003\t1a\u001c:h\u0013\r\t)A\u001e\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003)\u0001(/\u001b8dSB\fG\u000eI\u0001\u0006+N,'o]\u000b\u0003\u0003\u001b\u0001R!a\u0004\u0002\u001aQl!!!\u0005\u000b\t\u0005M\u0011QC\u0001\nS6lW\u000f^1cY\u0016T1!a\u0006`\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t\tBA\u0002TKR\fa!V:feN\u0004\u0013!\u0002%pgR\u001cXCAA\u0012!\u0019\ty!!\u0007\u0002&A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001\u00027b]\u001eT!!a\f\u0002\t)\fg/Y\u0005\u0005\u0003g\tIC\u0001\u0004TiJLgnZ\u0001\u0007\u0011>\u001cHo\u001d\u0011\u0002!\u0005cGn\\<I_N$8i\\7nC:$WCAA\u001e!\u0015a\u0017QHA\u0013\u0013\r\tyd\u0018\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0012\u00032dwn\u001e%pgR\u001cu.\\7b]\u0012\u0004\u0013a\u0004#f]fDun\u001d;D_6l\u0017M\u001c3\u0002!\u0011+g.\u001f%pgR\u001cu.\\7b]\u0012\u0004\u0013A\u0004+pa&\u001c'+Z:pkJ\u001cWm]\u000b\u0003\u0003\u0017\u0002b!a\u0004\u0002\u001a\u00055\u0003\u0003BA(\u0003+j!!!\u0015\u000b\u0007]\f\u0019F\u0003\u0002z\u007f%!\u0011qKA)\u0005!\u0011Vm]8ve\u000e,\u0017a\u0004+pa&\u001c'+Z:pkJ\u001cWm\u001d\u0011\u0002\u001d\u001d\u0013x.\u001e9SKN|WO]2fg\u0006yqI]8vaJ+7o\\;sG\u0016\u001c\b%\u0001\rUe\u0006t7/Y2uS>t\u0017\r\\%e%\u0016\u001cx.\u001e:dKN\f\u0011\u0004\u0016:b]N\f7\r^5p]\u0006d\u0017\n\u001a*fg>,(oY3tA\u0005qAk\\6f]J+7o\\;sG\u0016\u001c\u0018a\u0004+pW\u0016t'+Z:pkJ\u001cWm\u001d\u0011\u0002#I+7o\\;sG\u0016$vnQ8n[\u0006tG-\u0006\u0002\u0002lAA\u0011qBA7\u0003c\ny(\u0003\u0003\u0002p\u0005E!aA'baB1\u00111OA>\u0003\u001brA!!\u001e\u0002xA\u0011\u0001lX\u0005\u0004\u0003sz\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u$bAA=?B)A.!\u0010\u0002\u0002B!\u00111OAB\u0013\u0011\t\u0019$! \u0002%I+7o\\;sG\u0016$vnQ8n[\u0006tG\rI\u0001\u0015%\u0016\u001cx.\u001e:dKR{w\n]3sCRLwN\\:\u0016\u0005\u0005-\u0005\u0003CA\b\u0003[\n\t(!$\u0011\u000f1\fy)a%\u0002\u0000%\u0019\u0011\u0011S0\u0003\rQ+\b\u000f\\33!\u0019\t\u0019(a\u001f\u0002\u0016B!\u0011qJAL\u0013\u0011\tI*!\u0015\u0003\u0013=\u0003XM]1uS>t\u0017!\u0006*fg>,(oY3U_>\u0003XM]1uS>t7\u000fI\u0001\u0017!J|G-^2feJ+7o\\;sG\u0016$v.Q2mgR!\u0011\u0011UAV!!\ty!!\u001c\u0002r\u0005\r\u0006CBA:\u0003w\n)\u000b\u0005\u0003\u0002P\u0005\u001d\u0016\u0002BAU\u0003#\u00121!Q2m\u0011%\tik\u0007I\u0001\u0002\u0004\ty+A\tf]\u0006\u0014G.Z%eK6\u0004x\u000e^3oG\u0016\u00042\u0001\\AY\u0013\r\t\u0019l\u0018\u0002\b\u0005>|G.Z1o\u0003\u0001\u0002&o\u001c3vG\u0016\u0014(+Z:pkJ\u001cW\rV8BG2\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e&\u0006BAX\u0003w[#!!0\u0011\t\u0005}\u0016\u0011Z\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000f|\u0016AC1o]>$\u0018\r^5p]&!\u00111ZAa\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017\u0007>t7/^7feJ+7o\\;sG\u0016$v.Q2mgV\u0011\u0011\u0011U\u0001\u0018\u0007>t7/^7feJ+7o\\;sG\u0016$v.Q2mg\u0002\n1cQ7e)>\u0014Vm]8ve\u000e,7\u000fV8BG2,\"!a6\u0011\u0011\u0005=\u0011QNA@\u00033\u0004\u0002\"a\u001d\u0002\\\u0006E\u00141U\u0005\u0005\u0003_\ni(\u0001\u000bD[\u0012$vNU3t_V\u00148-Z:U_\u0006\u001bG\u000eI\u0001\fEJ|7.\u001a:Qe>\u00048/\u0006\u0002\u0002dB!\u0011Q]Av\u001b\t\t9O\u0003\u0003\u0002j\u00065\u0012\u0001B;uS2LA!!<\u0002h\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u001f\t\u0014xn[3s!J|\u0007o]0%KF$2a[Az\u0011!\u0001(%!AA\u0002\u0005\r\u0018\u0001\u00042s_.,'\u000f\u0015:paN\u0004\u0013A\u0002>l\u0003J<7/\u0006\u0002\u0002\u0000\u0005Q!p[!sON|F%Z9\u0015\u0007-\fy\u0010\u0003\u0005qK\u0005\u0005\t\u0019AA@\u0003\u001dQ8.\u0011:hg\u0002\n\u0011\"\u00193nS:\f%oZ:\u0002\u001b\u0005$W.\u001b8Be\u001e\u001cx\fJ3r)\rY'\u0011\u0002\u0005\ta\"\n\t\u00111\u0001\u0002\u0000\u0005Q\u0011\rZ7j]\u0006\u0013xm\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003-D3A\u000bB\n!\u0011\u0011)Ba\u0007\u000e\u0005\t]!b\u0001B\r\u007f\u0006)!.\u001e8ji&!!Q\u0004B\f\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000eK\u0002,\u0005G\u0001BA!\u0006\u0003&%!!q\u0005B\f\u0005\u0015\te\r^3s\u0003a!Xm\u001d;BG2\u001cE.[,ji\"\fU\u000f\u001e5pe&TXM\u001d\u0015\u0004Y\t5\u0002\u0003\u0002B\u000b\u0005_IAA!\r\u0003\u0018\t!A+Z:u\u0003Y!Xm\u001d;BG2\u001cE.[,ji\"\fE-\\5o\u0003BK\u0005fA\u0017\u0003.\u0005a1M]3bi\u0016\u001cVM\u001d<fe\u0006QA/Z:u\u0003\u000ed7\t\\5\u0015\u0007-\u0014i\u0004C\u0004\u0003@=\u0002\r!a \u0002\u000f\rlG-\u0011:hg\u0006)C/Z:u!J|G-^2fe\u000e{gn];nKJ\u001cE.[,ji\"\fU\u000f\u001e5pe&TXM\u001d\u0015\u0004a\t5\u0012a\t;fgR\u0004&o\u001c3vG\u0016\u00148i\u001c8tk6,'o\u00117j/&$\b.\u00113nS:\f\u0005+\u0013\u0015\u0004c\t5\u0012a\u0006;fgR\u0004&o\u001c3vG\u0016\u00148i\u001c8tk6,'o\u00117j)\rY'Q\n\u0005\b\u0005\u007f\u0011\u0004\u0019AA@\u0003%\"Xm\u001d;BG2\u001cxJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fg^KG\u000f[!vi\"|'/\u001b>fe\"\u001a1G!\f\u0002OQ,7\u000f^!dYN|e\u000e\u0015:fM&DX\r\u001a*fg>,(oY3t/&$\b.\u00113nS:\f\u0005+\u0013\u0015\u0004i\t5\u0012a\u0007;fgR\f5\r\\:P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,7\u000fF\u0002l\u00057BqAa\u00106\u0001\u0004\ty(A\u000fuKN$\u0018J\u001c<bY&$\u0017)\u001e;i_JL'0\u001a:Qe>\u0004XM\u001d;zQ\u001d1$Q\u0006B1\u0005G\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0005K\u00022A\u0016B4\u0013\r\u0011IG\u0019\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0017\u0001\u0005;fgR\u0004\u0016\r\u001e;fe:$\u0016\u0010]3tQ\r9$QF\u0001\u000bi\u0016\u001cHOU3n_Z,GcB6\u0003t\tU$\u0011\u0010\u0005\b\u0005\u007fA\u0004\u0019AA@\u0011\u001d\u00119\b\u000fa\u0001\u0003c\n\u0011B]3t_V\u00148-Z:\t\u000f\tm\u0004\b1\u0001\u0002\u0000\u0005Y!/Z:pkJ\u001cWmQ7e\u0003=9W\r^!dYR{7i\\7nC:$GC\u0002BA\u0005\u0007\u0013i\tE\u0004m\u0003\u001f\u000b\u0019+a \t\u000f\t\u0015\u0015\b1\u0001\u0003\b\u0006q\u0001/\u001a:nSN\u001c\u0018n\u001c8UsB,\u0007\u0003BA(\u0005\u0013KAAa#\u0002R\tq\u0001+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0007b\u0002BHs\u0001\u0007\u00111S\u0001\u000b_B,'/\u0019;j_:\u001c\u0018AB4fi\u000ekG\r\u0006\u0003\u0002\u0000\tU\u0005b\u0002BCu\u0001\u0007!qQ\u0001\u000fo&$\b.Q;uQ>\u0014\u0018N_3s)\t\u0011Y\nF\u0002l\u0005;CqAa(<\u0001\u0004\u0011\t+A\u0001g!\u0019a'1\u0015BTW&\u0019!QU0\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA(\u0005SKAAa+\u0002R\tQ\u0011)\u001e;i_JL'0\u001a:")
public class AclCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private final Set<KafkaPrincipal> Users = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), this.principal(), SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \\\" \\\\ \\< \\> \\; ')")}));
    private final Set<String> Hosts = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"}));
    private final String[] AllowHostCommand = (String[])((Object[])new String[]{"--allow-host", "host1", "--allow-host", "host2"});
    private final String[] DenyHostCommand = (String[])((Object[])new String[]{"--deny-host", "host1", "--deny-host", "host2"});
    private final Set<Resource> TopicResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{new Resource((ResourceType)Topic$.MODULE$, "test-1", PatternType.LITERAL), new Resource((ResourceType)Topic$.MODULE$, "test-2", PatternType.LITERAL)}));
    private final Set<Resource> GroupResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{new Resource((ResourceType)Group$.MODULE$, "testGroup-1", PatternType.LITERAL), new Resource((ResourceType)Group$.MODULE$, "testGroup-2", PatternType.LITERAL)}));
    private final Set<Resource> TransactionalIdResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{new Resource((ResourceType)TransactionalId$.MODULE$, "t0", PatternType.LITERAL), new Resource((ResourceType)TransactionalId$.MODULE$, "t1", PatternType.LITERAL)}));
    private final Set<Resource> TokenResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{new Resource((ResourceType)DelegationToken$.MODULE$, "token1", PatternType.LITERAL), new Resource((ResourceType)DelegationToken$.MODULE$, "token2", PatternType.LITERAL)}));
    private final Map<Set<Resource>, String[]> ResourceToCommand = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new String[]{"--topic", "test-1", "--topic", "test-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{Resource$.MODULE$.ClusterResource()}))), (Object)new String[]{"--cluster"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new String[]{"--group", "testGroup-1", "--group", "testGroup-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new String[]{"--transactional-id", "t0", "--transactional-id", "t1"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new String[]{"--delegation-token", "token1", "--delegation-token", "token2"})}));
    private final Map<Set<Resource>, Tuple2<Set<Operation>, String[]>> ResourceToOperations = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Create$.MODULE$, Describe$.MODULE$, Delete$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$})), (Object)new String[]{"--operation", "Read", "--operation", "Write", "--operation", "Create", "--operation", "Describe", "--operation", "Delete", "--operation", "DescribeConfigs", "--operation", "AlterConfigs"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{Resource$.MODULE$.ClusterResource()}))), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Create$.MODULE$, ClusterAction$.MODULE$, DescribeConfigs$.MODULE$, AlterConfigs$.MODULE$, IdempotentWrite$.MODULE$})), (Object)new String[]{"--operation", "Create", "--operation", "ClusterAction", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "IdempotentWrite"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$})), (Object)new String[]{"--operation", "Read", "--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$, Write$.MODULE$})), (Object)new String[]{"--operation", "Describe", "--operation", "Write"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Describe$.MODULE$})), (Object)new String[]{"--operation", "Describe"}))}));
    private final Map<Set<Resource>, Set<Acl>> ConsumerResourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$})), this.Hosts()))}));
    private final Map<String[], Map<Set<Resource>, Set<Acl>>> CmdToResourcesToAcl = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer"}), this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent"}), this.ProducerResourceToAcls(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--consumer"}), this.ConsumerResourceToAcls()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--consumer"}), this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set k = (Set)tuple2._1();
        Set v = (Set)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1()).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple22;
    }, Map$.MODULE$.canBuildFrom())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent", "--consumer"}), this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set k = (Set)tuple2._1();
        Set v = (Set)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(true).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple22;
    }, Map$.MODULE$.canBuildFrom()))}));
    private Properties brokerProps;
    private String[] zkArgs;
    private String[] adminArgs;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private Set<KafkaPrincipal> Users() {
        return this.Users;
    }

    private Set<String> Hosts() {
        return this.Hosts;
    }

    private String[] AllowHostCommand() {
        return this.AllowHostCommand;
    }

    private String[] DenyHostCommand() {
        return this.DenyHostCommand;
    }

    private Set<Resource> TopicResources() {
        return this.TopicResources;
    }

    private Set<Resource> GroupResources() {
        return this.GroupResources;
    }

    private Set<Resource> TransactionalIdResources() {
        return this.TransactionalIdResources;
    }

    private Set<Resource> TokenResources() {
        return this.TokenResources;
    }

    private Map<Set<Resource>, String[]> ResourceToCommand() {
        return this.ResourceToCommand;
    }

    private Map<Set<Resource>, Tuple2<Set<Operation>, String[]>> ResourceToOperations() {
        return this.ResourceToOperations;
    }

    private Map<Set<Resource>, Set<Acl>> ProducerResourceToAcls(boolean enableIdempotence) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$, Create$.MODULE$})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$})), this.Hosts())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Resource[]{Resource$.MODULE$.ClusterResource()}))), (Object)AclCommand$.MODULE$.getAcls(this.Users(), (PermissionType)Allow$.MODULE$, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{enableIdempotence ? new Some((Object)IdempotentWrite$.MODULE$) : None$.MODULE$})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)), this.Hosts()))}));
    }

    private boolean ProducerResourceToAcls$default$1() {
        return false;
    }

    private Map<Set<Resource>, Set<Acl>> ConsumerResourceToAcls() {
        return this.ConsumerResourceToAcls;
    }

    private Map<String[], Map<Set<Resource>, Set<Acl>>> CmdToResourcesToAcl() {
        return this.CmdToResourcesToAcl;
    }

    private Properties brokerProps() {
        return this.brokerProps;
    }

    private void brokerProps_$eq(Properties x$1) {
        this.brokerProps = x$1;
    }

    private String[] zkArgs() {
        return this.zkArgs;
    }

    private void zkArgs_$eq(String[] x$1) {
        this.zkArgs = x$1;
    }

    private String[] adminArgs() {
        return this.adminArgs;
    }

    private void adminArgs_$eq(String[] x$1) {
        this.adminArgs = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.brokerProps_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
        this.brokerProps().put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), "kafka.security.auth.SimpleAclAuthorizer");
        this.brokerProps().put(SimpleAclAuthorizer$.MODULE$.SuperUsersProp(), "User:ANONYMOUS");
        this.zkArgs_$eq((String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString()}));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAclCliWithAuthorizer() {
        this.testAclCli(this.zkArgs());
    }

    @Test
    public void testAclCliWithAdminAPI() {
        this.createServer();
        this.testAclCli(this.adminArgs());
    }

    private void createServer() {
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(this.brokerProps()), TestUtils$.MODULE$.createServer$default$2())}))));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        this.adminArgs_$eq((String[])((Object[])new String[]{"--bootstrap-server", TestUtils$.MODULE$.bootstrapServers(this.servers(), listenerName)}));
    }

    private void testAclCli(String[] cmdArgs) {
        this.ResourceToCommand().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCli$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            AclCommandTest.$anonfun$testAclCli$2(this, cmdArgs, x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testProducerConsumerCliWithAuthorizer() {
        this.testProducerConsumerCli(this.zkArgs());
    }

    @Test
    public void testProducerConsumerCliWithAdminAPI() {
        this.createServer();
        this.testProducerConsumerCli(this.adminArgs());
    }

    private void testProducerConsumerCli(String[] cmdArgs) {
        this.CmdToResourcesToAcl().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testProducerConsumerCli$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$2(this, cmdArgs, x$6);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAuthorizer() {
        this.testAclsOnPrefixedResources(this.zkArgs());
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAdminAPI() {
        this.createServer();
        this.testAclsOnPrefixedResources(this.adminArgs());
    }

    private void testAclsOnPrefixedResources(String[] cmdArgs) {
        String[] cmd = (String[])((Object[])new String[]{"--allow-principal", this.principal().toString(), "--producer", "--topic", "Test-", "--resource-pattern-type", "Prefixed"});
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$1(this, authorizer);
            return BoxedUnit.UNIT;
        });
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$2(authorizer);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidAuthorizerProperty() {
        String[] args = (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect ").append(this.zkConnect()).toString()});
        AclCommand.AuthorizerService aclCommandService = new AclCommand.AuthorizerService(new AclCommand.AclCommandOptions(args));
        aclCommandService.listAcls();
    }

    @Test
    public void testPatternTypes() {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(status, x$7) -> AclCommandTest.$anonfun$testPatternTypes$1(BoxesRunTime.unboxToInt((Object)status), x$7));
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PatternType.values())).foreach((Function1 & Serializable & scala.Serializable)patternType -> {
                AclCommandTest.$anonfun$testPatternTypes$3(this, patternType);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    private void testRemove(String[] cmdArgs, Set<Resource> resources, String[] resourceCmd) {
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            AclCommandTest.$anonfun$testRemove$1(this, cmdArgs, resourceCmd, resource);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Set<Acl>, String[]> getAclToCommand(PermissionType permissionType, Set<Operation> operations) {
        return new Tuple2((Object)AclCommand$.MODULE$.getAcls(this.Users(), permissionType, operations, this.Hosts()), (Object)this.getCmd(permissionType));
    }

    private String[] getCmd(PermissionType permissionType) {
        PermissionType permissionType2 = permissionType;
        Allow$ allow$ = Allow$.MODULE$;
        String principalCmd = !(permissionType2 != null ? !permissionType2.equals(allow$) : allow$ != null) ? "--allow-principal" : "--deny-principal";
        PermissionType permissionType3 = permissionType;
        Allow$ allow$2 = Allow$.MODULE$;
        String[] cmd2 = !(permissionType3 != null ? !permissionType3.equals(allow$2) : allow$2 != null) ? this.AllowHostCommand() : this.DenyHostCommand();
        return (String[])this.Users().foldLeft((Object)cmd2, (Function2 & Serializable & scala.Serializable)(cmd, user) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{principalCmd, user.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private void withAuthorizer(Function1<Authorizer, BoxedUnit> f) {
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (SimpleAclAuthorizer authZ = new SimpleAclAuthorizer();){
            authZ.configure(kafkaConfig.originals());
            f.apply((Object)authZ);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAclCli$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testAclCli$3(AclCommandTest $this, Set resources$1, String[] cmdArgs$1, String[] resourceCmd$1, PermissionType permissionType) {
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources$1);
        Tuple2<Set<Acl>, String[]> tuple2 = $this.getAclToCommand(permissionType, (Set<Operation>)((Set)operationToCmd._1()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set acls = (Set)tuple2._1();
        String[] cmd = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)acls, (Object)cmd);
        Tuple2 tuple23 = tuple22;
        Set acls2 = (Set)tuple23._1();
        String[] cmd2 = (String[])tuple23._2();
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operationToCmd._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        resources$1.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            $this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
                TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)acls$1, authorizer, resource);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        $this.testRemove(cmdArgs$1, (Set<Resource>)resources$1, resourceCmd$1);
    }

    public static final /* synthetic */ void $anonfun$testAclCli$2(AclCommandTest $this, String[] cmdArgs$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set resources = (Set)tuple2._1();
        String[] resourceCmd = (String[])tuple2._2();
        PermissionType$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)permissionType -> {
            AclCommandTest.$anonfun$testAclCli$3($this, resources, cmdArgs$1, resourceCmd, permissionType);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerConsumerCli$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerConsumerCli$4(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$5(AclCommandTest $this, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set resources = (Set)tuple2._1();
        Set acls = (Set)tuple2._2();
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            $this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
                TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)acls$2, authorizer, resource);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$2(AclCommandTest $this, String[] cmdArgs$2, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] cmd = (String[])tuple2._1();
        Map resourcesToAcls = (Map)tuple2._2();
        String[] resourceCommand = (String[])((TraversableOnce)resourcesToAcls.keys().map($this.ResourceToCommand(), Iterable$.MODULE$.canBuildFrom())).foldLeft(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.getCmd((PermissionType)Allow$.MODULE$))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        resourcesToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testProducerConsumerCli$4(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$5($this, x$5);
            return BoxedUnit.UNIT;
        });
        $this.testRemove(cmdArgs$2, (Set<Resource>)((TraversableOnce)resourcesToAcls.keys().flatten((Function1)Predef$.MODULE$.$conforms())).toSet(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$1(AclCommandTest $this, Authorizer authorizer) {
        Acl writeAcl = new Acl($this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$);
        Acl describeAcl = new Acl($this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        Acl createAcl = new Acl($this.principal(), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Create$.MODULE$);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{writeAcl, describeAcl, createAcl}))), authorizer, new Resource((ResourceType)Topic$.MODULE$, "Test-", PatternType.PREFIXED));
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$2(Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), authorizer, new Resource((ResourceType)Cluster$.MODULE$, "kafka-cluster", PatternType.LITERAL));
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), authorizer, new Resource((ResourceType)Topic$.MODULE$, "Test-", PatternType.PREFIXED));
    }

    public static final /* synthetic */ Nothing$ $anonfun$testPatternTypes$1(int status, Option x$7) {
        if (status == 1) {
            throw new RuntimeException("Exiting command");
        }
        throw new AssertionError((Object)new StringBuilder(28).append("Unexpected exit with status ").append(status).toString());
    }

    private final void verifyPatternType$1(String[] cmd, boolean isValid) {
        if (isValid) {
            AclCommand$.MODULE$.main(cmd);
        } else {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AclCommand$.MODULE$.main(cmd), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("AclCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        }
    }

    public static final /* synthetic */ void $anonfun$testPatternTypes$3(AclCommandTest $this, PatternType patternType) {
        String[] addCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--allow-principal", $this.principal().toString(), "--producer", "--topic", "Test", "--add", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(addCmd, patternType.isSpecific());
        String[] listCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--list", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        PatternType patternType2 = patternType;
        PatternType patternType3 = PatternType.UNKNOWN;
        $this.verifyPatternType$1(listCmd, patternType2 == null ? patternType3 != null : !patternType2.equals(patternType3));
        String[] removeCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--force", "--remove", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        PatternType patternType4 = patternType;
        PatternType patternType5 = PatternType.UNKNOWN;
        $this.verifyPatternType$1(removeCmd, patternType4 == null ? patternType5 != null : !patternType4.equals(patternType5));
    }

    public static final /* synthetic */ void $anonfun$testRemove$1(AclCommandTest $this, String[] cmdArgs$3, String[] resourceCmd$2, Resource resource) {
        AclCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$3)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        $this.withAuthorizer((Function1<Authorizer, BoxedUnit>)(Function1 & Serializable & scala.Serializable)authorizer -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<Acl>)Predef$.MODULE$.Set().empty(), authorizer, resource);
            return BoxedUnit.UNIT;
        });
    }
}

