/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005RUBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004>\u0001\u0001\u0006IA\u000e\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001b\u0001\n\u0003Q\u0005BB,\u0001A\u0003%1\nC\u0004Y\u0001\t\u0007I\u0011A \t\re\u0003\u0001\u0015!\u0003A\u0011\u001dQ\u0006A1A\u0005\u0002)Caa\u0017\u0001!\u0002\u0013Y\u0005b\u0002/\u0001\u0005\u0004%\ta\u0010\u0005\u0007;\u0002\u0001\u000b\u0011\u0002!\t\u000fy\u0003!\u0019!C\u0001\u0015\"1q\f\u0001Q\u0001\n-Cq\u0001\u0019\u0001C\u0002\u0013\u0005q\b\u0003\u0004b\u0001\u0001\u0006I\u0001\u0011\u0005\bE\u0002\u0011\r\u0011\"\u0001K\u0011\u0019\u0019\u0007\u0001)A\u0005\u0017\"9A\r\u0001b\u0001\n\u0003y\u0004BB3\u0001A\u0003%\u0001\tC\u0004g\u0001\t\u0007I\u0011\u0001&\t\r\u001d\u0004\u0001\u0015!\u0003L\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u00151\b\u0001\"\u0001j\u0011\u0015Y\b\u0001\"\u0001j\u0011\u0015i\b\u0001\"\u0001j\u0011\u0015y\b\u0001\"\u0001j\u0011\u0019\t\u0019\u0001\u0001C\u0001S\"1\u0011q\u0001\u0001\u0005\u0002%Dq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002d\u0001!I!!\u001a\t\u0013\u0005=\u0005!%A\u0005\n\u0005E%!E!eIB\u000b'\u000f^5uS>t7\u000fV3ti*\u0011QEJ\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002O\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001+!\tYc&D\u0001-\u0015\tic%\u0001\u0004tKJ4XM]\u0005\u0003_1\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0002\"a\r\u0001\u000e\u0003\u0011\n!B\\;n\u0005J|7.\u001a:t+\u00051\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$aA%oi\u0006Y\u0001/\u0019:uSRLwN\\%e\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0003\u0019!x\u000e]5dcU\t\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006!A.\u00198h\u0015\u0005)\u0015\u0001\u00026bm\u0006L!a\u0012\"\u0003\rM#(/\u001b8h\u0003\u001d!x\u000e]5dc\u0001\n\u0001\u0003^8qS\u000e\f\u0014i]:jO:lWM\u001c;\u0016\u0003-\u0003B\u0001T)7'6\tQJ\u0003\u0002O\u001f\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003!b\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011VJA\u0002NCB\u00042\u0001V+7\u001b\u0005y\u0015B\u0001,P\u0005\r\u0019V-]\u0001\u0012i>\u0004\u0018nY\u0019BgNLwM\\7f]R\u0004\u0013A\u0002;pa&\u001c''A\u0004u_BL7M\r\u0011\u0002!Q|\u0007/[23\u0003N\u001c\u0018n\u001a8nK:$\u0018!\u0005;pa&\u001c''Q:tS\u001etW.\u001a8uA\u00051Ao\u001c9jGN\nq\u0001^8qS\u000e\u001c\u0004%\u0001\tu_BL7mM!tg&<g.\\3oi\u0006\tBo\u001c9jGN\n5o]5h]6,g\u000e\u001e\u0011\u0002\rQ|\u0007/[25\u0003\u001d!x\u000e]5di\u0001\n\u0001\u0003^8qS\u000e$\u0014i]:jO:lWM\u001c;\u0002#Q|\u0007/[25\u0003N\u001c\u0018n\u001a8nK:$\b%\u0001\u0004u_BL7-N\u0001\bi>\u0004\u0018nY\u001b!\u0003A!x\u000e]5dk\u0005\u001b8/[4o[\u0016tG/A\tu_BL7-N!tg&<g.\\3oi\u0002\nQa]3u+B$\u0012A\u001b\t\u0003o-L!\u0001\u001c\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u000339\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\u000b),h.\u001b;\u000b\u0003M\f1a\u001c:h\u0013\t)\bO\u0001\u0004CK\u001a|'/Z\u0001\u0016i\u0016\u001cHo\u0016:p]\u001e\u0014V\r\u001d7jG\u0006\u001cu.\u001e8uQ\tQ\u0002\u0010\u0005\u0002ps&\u0011!\u0010\u001d\u0002\u0005)\u0016\u001cH/A\u000buKN$X*[:tS:<\u0007+\u0019:uSRLwN\u001c\u0019)\u0005mA\u0018a\u0006;fgRLen\u0019:f[\u0016tG\u000fU1si&$\u0018n\u001c8tQ\ta\u00020\u0001\u0010uKN$X*\u00198vC2\f5o]5h]6,g\u000e^(g%\u0016\u0004H.[2bg\"\u0012Q\u0004_\u0001\u001fi\u0016\u001cHOU3qY&\u001c\u0017\r\u00157bG\u0016lWM\u001c;BY2\u001cVM\u001d<feND#A\b=\u0002EQ,7\u000f\u001e*fa2L7-\u0019)mC\u000e,W.\u001a8u!\u0006\u0014H/[1m'\u0016\u0014h/\u001a:tQ\ty\u00020A\rwC2LG-\u0019;f\u0019\u0016\fG-\u001a:B]\u0012\u0014V\r\u001d7jG\u0006\u001cH#\u00036\u0002\u0010\u0005%\u00131JA(\u0011\u001d\t\t\u0002\ta\u0001\u0003'\t\u0001\"\\3uC\u0012\fG/\u0019\t\u0005\u0003+\t\u0019E\u0004\u0003\u0002\u0018\u0005ub\u0002BA\r\u0003oqA!a\u0007\u000229!\u0011QDA\u0017\u001d\u0011\ty\"!\u000b\u000f\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n)\u0003\u0019a$o\\8u}%\t1/C\u0002\u0002,I\fa!\u00199bG\",\u0017bA\u0014\u00020)\u0019\u00111\u0006:\n\t\u0005M\u0012QG\u0001\u0007G>lWn\u001c8\u000b\u0007\u001d\ny#\u0003\u0003\u0002:\u0005m\u0012\u0001\u0003:fcV,7\u000f^:\u000b\t\u0005M\u0012QG\u0005\u0005\u0003\u007f\t\t%\u0001\tNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK*!\u0011\u0011HA\u001e\u0013\u0011\t)%a\u0012\u0003\u001bQ{\u0007/[2NKR\fG-\u0019;b\u0015\u0011\ty$!\u0011\t\u000bq\u0002\u0003\u0019\u0001\u001c\t\r\u00055\u0003\u00051\u00017\u0003A)\u0007\u0010]3di\u0016$G*Z1eKJLE\rC\u0004\u0002R\u0001\u0002\r!a\u0015\u0002!\u0015D\b/Z2uK\u0012\u0014V\r\u001d7jG\u0006\u001c\b#BA+\u0003;2d\u0002BA,\u00033\u00022!!\t9\u0013\r\tY\u0006O\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0013\u0011\r\u0002\u0004'\u0016$(bAA.q\u0005\u00192/\u001a8e\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiR1\u0011qMA8\u0003s\u0002B!!\u001b\u0002l5\u0011\u0011\u0011I\u0005\u0005\u0003[\n\tE\u0001\tNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\"9\u0011\u0011O\u0011A\u0002\u0005M\u0014a\u0002:fcV,7\u000f\u001e\t\u0005\u0003S\n)(\u0003\u0003\u0002x\u0005\u0005#aD'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u0013\u0005m\u0014\u0005%AA\u0002\u0005u\u0014a\u00033fgRLg.\u0019;j_:\u0004RaNA@\u0003\u0007K1!!!9\u0005\u0019y\u0005\u000f^5p]B!\u0011QQAF\u001b\t\t9IC\u0002\u0002\n\u001a\nqA\\3uo>\u00148.\u0003\u0003\u0002\u000e\u0006\u001d%\u0001D*pG.,GoU3sm\u0016\u0014\u0018!H:f]\u0012lU\r^1eCR\f'+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M%\u0006BA?\u0003+[#!a&\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003CC\u0014AC1o]>$\u0018\r^5p]&!\u0011QUAN\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));

    @Override
    public int numBrokers() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, Seq<Object>> topic5Assignment() {
        return this.topic5Assignment;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)this.topic1Assignment());
        this.createTopic(this.topic2(), (Map<Object, Seq<Object>>)this.topic2Assignment());
        this.createTopic(this.topic3(), (Map<Object, Seq<Object>>)this.topic3Assignment());
        this.createTopic(this.topic4(), (Map<Object, Seq<Object>>)this.topic4Assignment());
    }

    @Test
    public void testWrongReplicaCount() {
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic1();
            scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic1Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            int x$6 = 2;
            Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
            throw this.fail("Add partitions should fail", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }
        catch (InvalidReplicaAssignmentException invalidReplicaAssignmentException) {
            return;
        }
    }

    @Test
    public void testMissingPartition0() {
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic5();
            scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic5Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            int x$6 = 2;
            Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))})));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
            throw this.fail("Add partitions should fail", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }
        catch (AdminOperationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
            return;
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic1();
        scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic1Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$12 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$12, x$2);
        int x$6 = 3;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        Buffer partitions = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitions.size(), (long)3L);
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitions.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        Assert.assertTrue((boolean)replicas.contains(((MetadataResponse.PartitionMetadata)partitions.apply(1)).leader()));
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$22 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$22);
        int x$6 = 3;
        Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))})));
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        Buffer partitionMetadata = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)3L, (long)topicMetadata.partitionMetadata().size());
        Assert.assertEquals((long)0L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).replicas();
        Assert.assertEquals((long)2L, (long)replicas.size());
        Assert.assertTrue((((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 0 || ((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 0 || ((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic3();
        scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic3Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$6 = 7;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, Seq<Object>> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$6 = 3;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$3)));
        Assert.assertTrue((String)new StringBuilder(23).append("Partition ").append(partitionId).append(" should exist").toString(), (boolean)partitionOpt.isDefined());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assert.assertNotNull((String)"Partition leader should exist", (Object)partition.leader());
        Assert.assertEquals((String)"Partition leader id should match", (long)expectedLeaderId, (long)partition.leaderId());
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, MetadataResponse.PartitionMetadata x$3) {
        return x$3.partition() == partitionId$1;
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

