/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTestAuthorizer;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0011#\u0001\u001dBQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001A\u0002\u0013\u0005\u0011\bC\u0004O\u0001\u0001\u0007I\u0011A(\t\rY\u0003\u0001\u0015)\u0003;\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0011%\tY\u0001AI\u0001\n\u0013\ti\u0001\u0003\u0004c\u0001\u0011%\u00111\u0005\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001bBq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002X\u0001!I!!\u0017\t\u0013\u0005}\u0003!%A\u0005\n\u0005\u0005\u0004\"CA3\u0001\t\u0007I\u0011AA4\u0011\u001d\tI\u0007\u0001Q\u0001\n9D\u0011\"a\u001b\u0001\u0005\u0004%\t!!\u001c\t\u0011\u0005u\u0004\u0001)A\u0005\u0003_B\u0011\"a \u0001\u0005\u0004%\t!!!\t\u000f\u0005\r\u0005\u0001)A\u0005u\"I\u0011Q\u0011\u0001C\u0002\u0013\u0005\u0011q\u0011\u0005\t\u0003\u001b\u0003\u0001\u0015!\u0003\u0002\n\"1\u0011q\u0012\u0001\u0005\u0002aCa!!'\u0001\t\u0003A\u0006BBAO\u0001\u0011\u0005\u0001\fC\u0004\u0002\"\u0002!I!a)\t\r\u0005u\u0006\u0001\"\u0001Y\u0011\u0019\t\t\r\u0001C\u00011\"1\u0011Q\u0019\u0001\u0005\u0002aCa!!3\u0001\t\u0003A\u0006BBAg\u0001\u0011\u0005\u0001\f\u0003\u0004\u0002R\u0002!\t\u0001\u0017\u0005\u0007\u0003+\u0004A\u0011\u0001-\u0003SA\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7i\\7nC:$G+Z:u\u0015\t\u0019C%A\u0003bI6LgNC\u0001&\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0015/!\tIC&D\u0001+\u0015\tYC%\u0001\u0002{W&\u0011QF\u000b\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0013!B;uS2\u001c\u0018BA\u001a1\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u001c\u0011\u0005]\u0002Q\"\u0001\u0012\u0002\u000fM,'O^3sgV\t!\bE\u0002<\u000b\"s!\u0001\u0010\"\u000f\u0005u\u0002U\"\u0001 \u000b\u0005}2\u0013A\u0002\u001fs_>$h(C\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019E)A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0005K!AR$\u0003\u0007M+\u0017O\u0003\u0002D\tB\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nJ\u0001\u0007g\u0016\u0014h/\u001a:\n\u00055S%aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011\u0001\u000b\u0016\t\u0003#Jk\u0011\u0001R\u0005\u0003'\u0012\u0013A!\u00168ji\"9QkAA\u0001\u0002\u0004Q\u0014a\u0001=%c\u0005A1/\u001a:wKJ\u001c\b%\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005\u0001\u0006FA\u0003[!\tY\u0006-D\u0001]\u0015\tif,A\u0003kk:LGOC\u0001`\u0003\ry'oZ\u0005\u0003Cr\u0013Q!\u00114uKJ\f\u0011d\u0019:fCR,G+Z:u)>\u0004\u0018nY!oI\u000ecWo\u001d;feR\u0019\u0001\u000bZ?\t\u000b\u00154\u0001\u0019\u00014\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!qm\u001b8x\u001d\tA\u0017\u000e\u0005\u0002>\t&\u0011!\u000eR\u0001\u0007!J,G-\u001a4\n\u00051l'aA'ba*\u0011!\u000e\u0012\t\u0003_Vl\u0011\u0001\u001d\u0006\u0003cJ\faaY8n[>t'BA\u0013t\u0015\t!h,\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003mB\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eE\u0002<qjL!!_$\u0003\t1K7\u000f\u001e\t\u0003#nL!\u0001 #\u0003\u0007%sG\u000fC\u0004\u007f\rA\u0005\t\u0019A@\u0002\u0015\u0005,H\u000f[8sSj,'\u000fE\u0003R\u0003\u0003\t)!C\u0002\u0002\u0004\u0011\u0013aa\u00149uS>t\u0007cA4\u0002\b%\u0019\u0011\u0011B7\u0003\rM#(/\u001b8h\u0003\r\u001a'/Z1uKR+7\u000f\u001e+pa&\u001c\u0017I\u001c3DYV\u001cH/\u001a:%I\u00164\u0017-\u001e7uII*\"!a\u0004+\u0007}\f\tb\u000b\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011!C;oG\",7m[3e\u0015\r\ti\u0002R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0011\u0003/\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\u0015\u0001\u0016QEA\u0015\u0011\u0019\t9\u0003\u0003a\u0001M\u0006A\u0002/\u0019:uSRLwN\\:B]\u0012\f5o]5h]6,g\u000e^:\t\u000f\u0005-\u0002\u00021\u0001\u0002.\u0005i!M]8lKJ\u001cuN\u001c4jON\u0004BaO#\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012\u0001B;uS2T!!!\u000f\u0002\t)\fg/Y\u0005\u0005\u0003{\t\u0019D\u0001\u0006Qe>\u0004XM\u001d;jKN\fABY8v]\u000e,7+\u001a:wKJ$R\u0001UA\"\u0003\u000fBa!!\u0012\n\u0001\u0004Q\u0018\u0001\u0004;be\u001e,GoU3sm\u0016\u0014\bBBA%\u0013\u0001\u0007a.A\u0005qCJ$\u0018\u000e^5p]\u0006iq-\u001a;D_:$(o\u001c7mKJ$\"!a\u0014\u0011\tE\u000b\t\u0001S\u0001\nO\u0016$H*Z1eKJ$2A_A+\u0011\u0015)7\u00021\u0001o\u0003=\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014H\u0003BA\u0003\u00037B\u0001\"!\u0018\r!\u0003\u0005\rA_\u0001\u0007EJ|7.\u001a:\u00023\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ$C-\u001a4bk2$H%M\u000b\u0003\u0003GR3A_A\t\u00035!Xm\u001d;QCJ$\u0018\u000e^5p]V\ta.\u0001\buKN$\b+\u0019:uSRLwN\u001c\u0011\u0002/Q,7\u000f\u001e)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$XCAA8!\u0015\t\t(a\u001f{\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!C5n[V$\u0018M\u00197f\u0015\r\tI\bR\u0001\u000bG>dG.Z2uS>t\u0017bA=\u0002t\u0005AB/Z:u!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u0011\u00029Q,7\u000f\u001e)beRLG/[8o!J,g-\u001a:sK\u0012dU-\u00193feV\t!0A\u000fuKN$\b+\u0019:uSRLwN\u001c)sK\u001a,'O]3e\u0019\u0016\fG-\u001a:!\u0003i!Xm\u001d;QCJ$\u0018\u000e^5p]\u0006sG-Q:tS\u001etW.\u001a8u+\t\tI\tE\u0004\u0002r\u0005-e.a\u001c\n\u00071\f\u0019(A\u000euKN$\b+\u0019:uSRLwN\\!oI\u0006\u001b8/[4o[\u0016tG\u000fI\u0001\u0019i\u0016\u001cH/T;mi&\u0004H.\u001a\"s_.,'o]$jm\u0016t\u0007f\u0001\f\u0002\u0014B\u00191,!&\n\u0007\u0005]EL\u0001\u0003UKN$\u0018A\u0006;fgRLeN^1mS\u0012\u0014%o\\6fe\u001eKg/\u001a8)\u0007]\t\u0019*A\u000buKN$hj\u001c)beRLG/[8og\u001eKg/\u001a8)\u0007a\t\u0019*\u0001\u0006u_*\u001bxN\u001c$jY\u0016$B!!*\u00022B!\u0011qUAW\u001b\t\tIK\u0003\u0003\u0002,\u0006]\u0012AA5p\u0013\u0011\ty+!+\u0003\t\u0019KG.\u001a\u0005\b\u0003gK\u0002\u0019AA[\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0003o\u000bIL\\\u0007\u0003\u0003oJA!a/\u0002x\t\u00191+\u001a;\u00027Q,7\u000f^*j]\u001edW\r^8o!\u0006\u0014H/\u001b;j_:<\u0015N^3oQ\rQ\u00121S\u0001\u0016i\u0016\u001cH\u000fV8qS\u000e$u.Z:O_R,\u00050[:uQ\rY\u00121S\u0001%i\u0016\u001cH/T;mi&\u0004H.\u001a)beRLG/[8ogN\u000bW.Z!tg&<g.\\3oi\"\u001aA$a%\u0002!Q,7\u000f\u001e(p_B,E.Z2uS>t\u0007fA\u000f\u0002\u0014\u0006yB/Z:u/&$\bn\u00144gY&tW\r\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1)\u0007y\t\u0019*A\u0006uKN$H+[7f_V$\bfA\u0010\u0002\u0014\u0006\u0001B/Z:u\u0003V$\bN\u001f$bS2,(/\u001a\u0015\u0004A\u0005M\u0005")
public class PreferredReplicaLeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final TopicPartition testPartition = new TopicPartition("test", 0);
    private final List<Object> testPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
    private final int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)this.testPartitionAssignment().head());
    private final Map<TopicPartition, List<Object>> testPartitionAndAssignment = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.testPartition()), this.testPartitionAssignment())}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    private void createTestTopicAndCluster(Map<TopicPartition, List<Object>> topicPartition, Option<String> authorizer) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("auto.leader.rebalance.enable", "false"));
        Option<String> option = authorizer;
        if (option instanceof Some) {
            Some some = (Some)option;
            String className = (String)some.value();
            brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("authorizer.class.name", className));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        this.createTestTopicAndCluster(topicPartition, brokerConfigs);
    }

    private void createTestTopicAndCluster(Map<TopicPartition, List<Object>> partitionsAndAssignments, Seq<Properties> brokerConfigs) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        partitionsAndAssignments.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)partitionsAndAssignments.forall((Function1 & Serializable & scala.Serializable)partitionAndAssignment -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$7(server, partitionAndAssignment))))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private Option<String> createTestTopicAndCluster$default$2() {
        return None$.MODULE$;
    }

    private void bounceServer(int targetServer, TopicPartition partition) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Shutting down server ").append(targetServer).append(" so a non-preferred replica becomes leader").toString());
        ((KafkaServer)this.servers().apply(targetServer)).shutdown();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Starting server ").append(targetServer).append(" now that a non-preferred replica is leader").toString());
        ((KafkaServer)this.servers().apply(targetServer)).startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$4(partition, targetServer, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Replicas for partition ").append(partition).append(" not created").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private Option<KafkaServer> getController() {
        return this.servers().find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$getController$1(p)));
    }

    private int getLeader(TopicPartition topicPartition) {
        return ((UpdateMetadataRequest.PartitionState)((KafkaServer)this.servers().apply((int)0)).metadataCache().getPartitionInfo((String)topicPartition.topic(), (int)topicPartition.partition()).get()).basePartitionState.leader;
    }

    private String bootstrapServer(int broker) {
        int port = ((KafkaServer)this.servers().apply(broker)).socketServer().boundPort(ListenerName.normalised((String)"PLAINTEXT"));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Server bound to port ").append(port).toString());
        return new StringBuilder(10).append("localhost:").append(port).toString();
    }

    private int bootstrapServer$default$1() {
        return 0;
    }

    public TopicPartition testPartition() {
        return this.testPartition;
    }

    public List<Object> testPartitionAssignment() {
        return this.testPartitionAssignment;
    }

    public int testPartitionPreferredLeader() {
        return this.testPartitionPreferredLeader;
    }

    public Map<TopicPartition, List<Object>> testPartitionAndAssignment() {
        return this.testPartitionAndAssignment;
    }

    @Test
    public void testMultipleBrokersGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", new StringBuilder(1).append(this.bootstrapServer(1)).append(",").append(this.bootstrapServer(0)).toString()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
    }

    @Test
    public void testInvalidBrokerGiven() {
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", "example.com:1234"}), 1000);
            throw this.fail(new Position("PreferredReplicaLeaderElectionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }
        catch (AdminCommandFailedException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
            return;
        }
    }

    @Test
    public void testNoPartitionsGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1())}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
    }

    /*
     * WARNING - void declaration
     */
    private File toJsonFile(Set<TopicPartition> partitions) {
        void var2_2;
        File jsonFile = File.createTempFile("preferredreplicaelection", ".js");
        jsonFile.deleteOnExit();
        String jsonString = ZkUtils$.MODULE$.preferredReplicaLeaderElectionZkData((Set)partitions.map((Function1 & Serializable & scala.Serializable)x$1 -> new TopicAndPartition(x$1), Set$.MODULE$.canBuildFrom()));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Using json: ").append(jsonString).toString());
        Files.write(Paths.get(jsonFile.getAbsolutePath(), new String[0]), jsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return var2_2;
    }

    @Test
    public void testSingletonPartitionGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        }
        finally {
            jsonFile.delete();
        }
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
    }

    @Test
    public void testTopicDoesNotExist() {
        TopicPartition nonExistentPartition = new TopicPartition("does.not.exist", 0);
        List nonExistentPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        Map nonExistentPartitionAndAssignment = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentPartition), (Object)nonExistentPartitionAssignment)}));
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        File jsonFile = this.toJsonFile((Set<TopicPartition>)nonExistentPartitionAndAssignment.keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            }
            catch (AdminCommandFailedException e) {
                Throwable suppressed = e.getSuppressed()[0];
                Assert.assertTrue((boolean)(suppressed instanceof UnknownTopicOrPartitionException));
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testMultiplePartitionsSameAssignment() {
        TopicPartition testPartitionA = new TopicPartition("testA", 0);
        TopicPartition testPartitionB = new TopicPartition("testB", 0);
        List testPartitionAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)testPartitionAssignment.head());
        Map testPartitionAndAssignment = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testPartitionA), (Object)testPartitionAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testPartitionB), (Object)testPartitionAssignment)}));
        this.createTestTopicAndCluster((Map<TopicPartition, List<Object>>)testPartitionAndAssignment, this.createTestTopicAndCluster$default$2());
        this.bounceServer(testPartitionPreferredLeader, testPartitionA);
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.getLeader(testPartitionA));
        Assert.assertNotEquals((long)testPartitionPreferredLeader, (long)this.getLeader(testPartitionB));
        File jsonFile = this.toJsonFile((Set<TopicPartition>)testPartitionAndAssignment.keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
        }
        finally {
            jsonFile.delete();
        }
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.getLeader(testPartitionA));
        Assert.assertEquals((long)testPartitionPreferredLeader, (long)this.getLeader(testPartitionB));
    }

    @Test
    public void testNoopElection() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
            Assert.assertEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testWithOfflinePreferredReplica() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.getLeader(this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader);
        ((KafkaServer)this.servers().apply(this.testPartitionPreferredLeader())).shutdown();
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
                throw this.fail(new Position("PreferredReplicaLeaderElectionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            }
            catch (AdminCommandFailedException e) {
                Assert.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)e.getMessage());
                Throwable suppressed = e.getSuppressed()[0];
                Assert.assertTrue((boolean)(suppressed instanceof PreferredLeaderNotAvailableException));
                Assert.assertTrue((String)suppressed.getMessage(), (boolean)suppressed.getMessage().contains("Failed to elect leader for partition test-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
                Assert.assertEquals((long)leader, (long)this.getLeader(this.testPartition()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testTimeout() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), this.createTestTopicAndCluster$default$2());
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.getLeader(this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader);
        int controller = ((KafkaServer)this.getController().get()).config().brokerId();
        ((KafkaServer)this.servers().apply(controller)).shutdown();
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(controller), "--path-to-json-file", jsonFile.getAbsolutePath()}), 2000);
                throw this.fail(new Position("PreferredReplicaLeaderElectionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            }
            catch (AdminCommandFailedException e) {
                Assert.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)e.getMessage());
                Assert.assertTrue((boolean)e.getSuppressed()[0].getMessage().contains("Timed out waiting for a node assignment"));
                Assert.assertEquals((long)leader, (long)this.getLeader(this.testPartition()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testAuthzFailure() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)new Some((Object)PreferredReplicaLeaderElectionCommandTestAuthorizer.class.getName()));
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.getLeader(this.testPartition());
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)leader);
        Assert.assertNotEquals((long)this.testPartitionPreferredLeader(), (long)this.getLeader(this.testPartition()));
        File jsonFile = this.toJsonFile((Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(this.bootstrapServer$default$1()), "--path-to-json-file", jsonFile.getAbsolutePath()}), PreferredReplicaLeaderElectionCommand$.MODULE$.run$default$2());
                throw this.fail(new Position("PreferredReplicaLeaderElectionCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            }
            catch (AdminCommandFailedException e) {
                Assert.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)e.getMessage());
                Assert.assertTrue((boolean)(e.getSuppressed()[0] instanceof ClusterAuthorizationException));
                Assert.assertEquals((long)leader, (long)this.getLeader(this.testPartition()));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    public static final /* synthetic */ void $anonfun$createTestTopicAndCluster$4(PreferredReplicaLeaderElectionCommandTest $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        List assigment = (List)tuple2._2();
        $this.zkClient().createTopicAssignment(tp.topic(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)assigment)})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$7(KafkaServer server$1, Tuple2 partitionAndAssignment) {
        LogManager qual$1 = server$1.getLogManager();
        TopicPartition x$1 = (TopicPartition)partitionAndAssignment._1();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$4(TopicPartition partition$1, int targetServer$1, KafkaServer server) {
        return server.metadataCache().getPartitionInfo(partition$1.topic(), partition$1.partition()).exists((Function1 & Serializable & scala.Serializable)partitionState -> BoxesRunTime.boxToBoolean((boolean)partitionState.basePartitionState.isr.contains(BoxesRunTime.boxToInteger((int)targetServer$1))));
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(KafkaServer p) {
        return p.kafkaController().isActive();
    }
}

