/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0014)\u00015BQA\r\u0001\u0005\u0002MBq!\u000e\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004@\u0001\u0001\u0006Ia\u000e\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u0019A\u0005\u0001)A\u0005\u0005\"9\u0011\n\u0001b\u0001\n\u0003\t\u0005B\u0002&\u0001A\u0003%!\tC\u0003L\u0001\u0011\u0005C\nC\u0003b\u0001\u0011\u0005!\rC\u0003q\u0001\u0011\u0005!\rC\u0003s\u0001\u0011\u0005!\rC\u0003u\u0001\u0011\u0005!\rC\u0003w\u0001\u0011\u0005!\rC\u0003y\u0001\u0011\u0005!\rC\u0003{\u0001\u0011\u0005!\rC\u0003}\u0001\u0011\u0005!\rC\u0003\u007f\u0001\u0011\u0005!\r\u0003\u0004\u0002\u0002\u0001!\tA\u0019\u0005\u0007\u0003\u000b\u0001A\u0011\u00012\t\r\u0005%\u0001\u0001\"\u0001c\u0011\u0019\ti\u0001\u0001C\u0001E\"1\u0011\u0011\u0003\u0001\u0005\u0002\tDa!!\u0006\u0001\t\u0003\u0011\u0007BBA\r\u0001\u0011\u0005!\r\u0003\u0004\u0002\u001e\u0001!\tA\u0019\u0005\u0007\u0003C\u0001A\u0011\u00012\t\r\u0005\u0015\u0002\u0001\"\u0001c\u0011\u0019\tI\u0003\u0001C\u0001E\"9\u0011Q\b\u0001\u0005\n\u0005}\u0002bBA/\u0001\u0011%\u0011q\f\u0005\n\u0003W\u0002\u0011\u0013!C\u0005\u0003[Bq!a!\u0001\t\u0013\t)\tC\u0005\u0002\u0014\u0002\t\n\u0011\"\u0003\u0002\u0016\"9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005\"CA]\u0001E\u0005I\u0011BAK\u0011%\tY\fAI\u0001\n\u0013\ti\fC\u0004\u0002B\u0002!I!a1\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\na\"+Z:fi\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;UKN$(BA\u0015+\u0003\u0015\tG-\\5o\u0015\u0005Y\u0013!B6bM.\f7\u0001A\n\u0003\u00019\u0002\"a\f\u0019\u000e\u0003!J!!\r\u0015\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002iA\u0011q\u0006A\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\tq\u0007\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005!Q\u000f^5m\u0015\u0005a\u0014\u0001\u00026bm\u0006L!AP\u001d\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA\u00051Ao\u001c9jGF*\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bn\nA\u0001\\1oO&\u0011q\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fQ|\u0007/[22A\u00051Ao\u001c9jGJ\nq\u0001^8qS\u000e\u0014\u0004%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005i\u0005c\u0001(Y7:\u0011q*\u0016\b\u0003!Nk\u0011!\u0015\u0006\u0003%2\na\u0001\u0010:p_Rt\u0014\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y;\u0016a\u00029bG.\fw-\u001a\u0006\u0002)&\u0011\u0011L\u0017\u0002\u0004'\u0016\f(B\u0001,X!\tav,D\u0001^\u0015\tq&&\u0001\u0004tKJ4XM]\u0005\u0003Av\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006\u0001C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d(pi\u0016C\u0018n\u001d;j]\u001e<%o\\;q)\u0005\u0019\u0007C\u00013f\u001b\u00059\u0016B\u00014X\u0005\u0011)f.\u001b;)\u0005%A\u0007CA5o\u001b\u0005Q'BA6m\u0003\u0015QWO\\5u\u0015\u0005i\u0017aA8sO&\u0011qN\u001b\u0002\u0005)\u0016\u001cH/A\u000fuKN$(+Z:fi>3gm]3ug\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dQ\tQ\u0001.A\u0010uKN$(+Z:fi>3gm]3ugR{Gj\\2bY\u0012\u000bG/\u001a+j[\u0016D#a\u00035\u0002?Q,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cHk\u001c.p]\u0016$G)\u0019;f)&lW\r\u000b\u0002\rQ\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]\"\u0012Q\u0002[\u0001%i\u0016\u001cHOU3tKR|eMZ:fiN\u0014\u0015\u0010R;sCRLwN\u001c+p\u000b\u0006\u0014H.[3ti\"\u0012a\u0002[\u0001\u001bi\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f\u001e\u0015\u0003\u001f!\f\u0001\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_2\u000bG/Z:uQ\t\u0001\u0002.A\u0010uKN$(+Z:fi>3gm]3ugR{7)\u001e:sK:$xJ\u001a4tKRD#!\u00055\u0002AQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cHk\\*qK\u000eLg-[2PM\u001a\u001cX\r\u001e\u0015\u0003%!\f\u0011\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4G\u000f\u00157vg\"\u00121\u0003[\u0001\u001bi\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u\u001b&tWo\u001d\u0015\u0003)!\f\u0001\u0006^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4GOQ=M_^,'\u000f\u00165b]\u0016\u000b'\u000f\\5fgRD#!\u00065\u0002OQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001c8\u000b[5gi\nK\b*[4iKJ$\u0006.\u00198MCR,7\u000f\u001e\u0015\u0003-!\fA\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_\u0016\u000b'\u000f\\5fgR|en\u00148f)>\u0004\u0018n\u0019\u0015\u0003/!\f\u0001\u0007^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_\u0016\u000b'\u000f\\5fgR|en\u00148f)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007F\u0001\ri\u0003\t\"Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8FCJd\u0017.Z:u\u001f:$v\u000e]5dg\"\u0012\u0011\u0004[\u00010i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o)>\u0004\u0018nY:B]\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u00035!\f\u0001\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:FqB|'\u000f^%na>\u0014H\u000f\u00157b]\"\u00121\u0004[\u0001+i\u0016\u001cHOU3tKR<\u0016\u000e\u001e5V]J,7m\\4oSj,GMT3x\u0007>t7/^7fe>\u0003H/[8oQ\u0019a\u0002.!\f\u00020\u0005AQ\r\u001f9fGR,Gm\t\u0002\u00022A!\u00111GA\u001d\u001b\t\t)D\u0003\u0002\u00028\u0005Q!n\u001c9ug&l\u0007\u000f\\3\n\t\u0005m\u0012Q\u0007\u0002\u0010\u001fB$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u0006y\u0001O]8ek\u000e,W*Z:tC\u001e,7\u000fF\u0003d\u0003\u0003\n\u0019\u0006C\u0004\u0002Du\u0001\r!!\u0012\u0002\u000bQ|\u0007/[2\u0011\t\u0005\u001d\u0013q\n\b\u0005\u0003\u0013\nY\u0005\u0005\u0002Q/&\u0019\u0011QJ,\u0002\rA\u0013X\rZ3g\u0013\r9\u0015\u0011\u000b\u0006\u0004\u0003\u001b:\u0006bBA+;\u0001\u0007\u0011qK\u0001\f]VlW*Z:tC\u001e,7\u000fE\u0002e\u00033J1!a\u0017X\u0005\rIe\u000e^\u0001\u001aaJ|G-^2f\u0007>t7/^7f\u0003:$7\u000b[;uI><h\u000eF\u0004d\u0003C\n\u0019'a\u001a\t\u000f\u0005\rc\u00041\u0001\u0002F!9\u0011Q\r\u0010A\u0002\u0005]\u0013!\u0004;pi\u0006dW*Z:tC\u001e,7\u000fC\u0005\u0002jy\u0001\n\u00111\u0001\u0002X\u0005aa.^7D_:\u001cX/\\3sg\u0006\u0019\u0003O]8ek\u000e,7i\u001c8tk6,\u0017I\u001c3TQV$Hm\\<oI\u0011,g-Y;mi\u0012\u001aTCAA8U\u0011\t9&!\u001d,\u0005\u0005M\u0004\u0003BA;\u0003\u007fj!!a\u001e\u000b\t\u0005e\u00141P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!! X\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\u000b9HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ#Y<bSR\u001cuN\\:v[\u0016\u0014\bK]8he\u0016\u001c8\u000fF\u0003d\u0003\u000f\u000bI\tC\u0005\u0002D\u0001\u0002\n\u00111\u0001\u0002F!9\u00111\u0012\u0011A\u0002\u00055\u0015!B2pk:$\bc\u00013\u0002\u0010&\u0019\u0011\u0011S,\u0003\t1{gnZ\u0001 C^\f\u0017\u000e^\"p]N,X.\u001a:Qe><'/Z:tI\u0011,g-Y;mi\u0012\nTCAALU\u0011\t)%!\u001d\u0002+I,7/\u001a;B]\u0012\f5o]3si>3gm]3ugRI1-!(\u0002(\u0006-\u0016q\u0016\u0005\b\u0003?\u0013\u0003\u0019AAQ\u0003\u0011\t'oZ:\u0011\u000b\u0011\f\u0019+!\u0012\n\u0007\u0005\u0015vKA\u0003BeJ\f\u0017\u0010C\u0004\u0002*\n\u0002\r!!$\u0002\u001d\u0015D\b/Z2uK\u0012|eMZ:fi\"I\u0011Q\u0016\u0012\u0011\u0002\u0003\u0007\u0011QI\u0001\u0006OJ|W\u000f\u001d\u0005\n\u0003c\u0013\u0003\u0013!a\u0001\u0003g\u000ba\u0001\u001a:z%Vt\u0007c\u00013\u00026&\u0019\u0011qW,\u0003\u000f\t{w\u000e\\3b]\u0006y\"/Z:fi\u0006sG-Q:tKJ$xJ\u001a4tKR\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0002?I,7/\u001a;B]\u0012\f5o]3si>3gm]3ug\u0012\"WMZ1vYR$C'\u0006\u0002\u0002@*\"\u00111WA9\u0003y\u0011Xm]3u\u0003:$\u0017i]:feR|eMZ:fiN\u001cu.\\7jiR,G\rF\u0004d\u0003\u000b\fy.a?\t\u000f\u0005\u001dW\u00051\u0001\u0002J\u0006!2m\u001c8tk6,'o\u0012:pkB\u001cVM\u001d<jG\u0016\u0004B!a3\u0002Z:!\u0011QZAk\u001d\u0011\ty-a5\u000f\u0007A\u000b\t.C\u0001,\u0013\tI#&C\u0002\u0002X\"\nAcQ8ogVlWM]$s_V\u00048i\\7nC:$\u0017\u0002BAn\u0003;\u0014AcQ8ogVlWM]$s_V\u00048+\u001a:wS\u000e,'bAAlQ!9\u0011\u0011]\u0013A\u0002\u0005\r\u0018aD3ya\u0016\u001cG/\u001a3PM\u001a\u001cX\r^:\u0011\u0011\u0005\u001d\u0013Q]Au\u0003\u001bKA!a:\u0002R\t\u0019Q*\u00199\u0011\t\u0005-\u0018q_\u0007\u0003\u0003[TA!a<\u0002r\u000611m\\7n_:T1aKAz\u0015\r\t)\u0010\\\u0001\u0007CB\f7\r[3\n\t\u0005e\u0018Q\u001e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\u0019%\na\u0001\u0003\u000b\nAB]3tKR|eMZ:fiN$B!a9\u0003\u0002!9\u0011q\u0019\u0014A\u0002\u0005%\u0007")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "missing.group", "--all-topics", "--to-current", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = consumerGroupCommand.collectGroupState().coordinator().host();
            String string2 = "localhost";
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> "Can't find a coordinator.";
        int x$3 = 3;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long x$5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$5, x$3);
        Map resetOffsets = consumerGroupCommand.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets);
        String x$6 = "missing.group";
        String x$7 = this.committedOffsets$default$1();
        Assert.assertEquals((Object)resetOffsets, this.committedOffsets(x$7, x$6));
    }

    @Test
    public void testResetOffsetsExistingTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "new.group", "--topic", this.topic(), "--to-offset", "50"});
        this.produceMessages(this.topic(), 100);
        String[] x$1 = args;
        long x$2 = 50L;
        boolean x$3 = true;
        String x$4 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$1, x$2, x$4, x$3);
        String[] x$5 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long x$6 = 50L;
        boolean x$7 = true;
        String x$8 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$5, x$6, x$8, x$7);
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, "new.group", this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.produceMessages(this.topic(), 100);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        this.awaitConsumerProgress(x$2, x$1);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"});
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.produceMessages(this.topic(), 50);
        Date checkpoint = new Date();
        this.produceMessages(this.topic(), 50);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        this.awaitConsumerProgress(x$2, x$1);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(checkpoint), "--execute"});
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT1M", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT0.1S", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-latest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-current", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "1", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 1L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "50", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 150L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-50", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-150", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "150", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", this.topic(), "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), 100, this.produceConsumeAndShutdown$default$3());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String topic = "bar";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringBuilder(2).append(topic).append(":1").toString(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic, 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Map expectedOffsets = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), priorCommittedOffsets.apply((Object)tp0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, 100, 1);
        this.produceConsumeAndShutdown(topic2, 100, 1);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupCommand);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), allResetOffsets);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringBuilder(2).append(topic1).append(":1").toString(), "--topic", new StringBuilder(2).append(topic2).append(":1").toString(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, 100, 2);
        this.produceConsumeAndShutdown(topic2, 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupCommand);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)0))})), allResetOffsets);
        Assert.assertEquals((Object)priorCommittedOffsets1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)priorCommittedOffsets2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic, 100, 2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToReset(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)exportedOffsets.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())));
        String[] cgcArgsExec = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)importedOffsets.mapValues((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.offset())));
        this.adminZkClient().deleteTopic(topic);
    }

    @Test(expected=OptionException.class)
    public void testResetWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        this.getConsumerGroupService(cgcArgs);
    }

    private void produceMessages(String topic, int numMessages) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x$4 -> ResetConsumerGroupOffsetTest.$anonfun$produceMessages$1(topic, BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, 1);
    }

    private void produceConsumeAndShutdown(String topic, int totalMessages, int numConsumers) {
        this.produceMessages(topic, totalMessages);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        this.awaitConsumerProgress(topic, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$3() {
        return 1;
    }

    private void awaitConsumerProgress(String topic, long count) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Iterable offsets = this.committedOffsets(topic, this.committedOffsets$default$2()).values();
            return count == BoxesRunTime.unboxToLong((Object)offsets.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected that consumer group has consumed all messages from topic/partition.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private String awaitConsumerProgress$default$1() {
        return this.topic();
    }

    private void resetAndAssertOffsets(String[] args, long expectedOffset, String group, boolean dryRun) {
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);){
            String x$1 = group;
            String x$2 = this.committedOffsets$default$1();
            Map priorOffsets = this.committedOffsets(x$2, x$1);
            Map expectedOffsets = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)BoxesRunTime.boxToLong((long)expectedOffset))}));
            Assert.assertEquals((Object)expectedOffsets, this.resetOffsets(consumerGroupCommand));
            String x$3 = group;
            String x$4 = this.committedOffsets$default$1();
            Assert.assertEquals((Object)(dryRun ? priorOffsets : expectedOffsets), this.committedOffsets(x$4, x$3));
        }
    }

    private String resetAndAssertOffsets$default$3() {
        return this.group();
    }

    private boolean resetAndAssertOffsets$default$4() {
        return false;
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, Map<TopicPartition, Object> expectedOffsets, String topic) {
        Map<TopicPartition, Object> allResetOffsets = this.resetOffsets(consumerGroupService);
        allResetOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$1(expectedOffsets, x0$1);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals(expectedOffsets, this.committedOffsets(topic, this.committedOffsets$default$2()));
    }

    private Map<TopicPartition, Object> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets().mapValues((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset()));
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$1, int x$4) {
        return new ProducerRecord(topic$1, (Object)new byte[100000]);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$1(Map expectedOffsets$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        long offset = tuple2._2$mcJ$sp();
        Assert.assertEquals((long)offset, (long)BoxesRunTime.unboxToLong((Object)expectedOffsets$1.apply((Object)tp)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

