/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001\u0002\u001e<\u0001\u0001CQ!\u0015\u0001\u0005\u0002ICQ\u0001\u0016\u0001\u0005BUC\u0011B\u001b\u0001A\u0002\u0003\u0007I\u0011B6\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0013A\b\"C@\u0001\u0001\u0004\u0005\t\u0015)\u0003m\u0011-\t\t\u0001\u0001a\u0001\u0002\u0004%I!a\u0001\t\u0017\u0005u\u0001\u00011AA\u0002\u0013%\u0011q\u0004\u0005\f\u0003G\u0001\u0001\u0019!A!B\u0013\t)\u0001C\u0006\u0002&\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0002bCA\u001d\u0001\u0001\u0007\t\u0019!C\u0005\u0003wA1\"a\u0010\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002*!I\u0011\u0011\t\u0001C\u0002\u0013%\u00111\t\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002F!9\u0011q\u000b\u0001\u0005\u0002\u0005\r\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!a%\u0001\t\u0003\t)\nC\u0005\u0002 \u0002\t\n\u0011\"\u0001\u0002\"\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBAb\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003\u001b\u0004A\u0011AA]\u0011\u001d\t9\u000e\u0001C\u0001\u0003sCq!a7\u0001\t\u0003\tI\fC\u0004\u0002`\u0002!\t!!/\t\u000f\u0005\r\b\u0001\"\u0001\u0002:\"9\u0011q\u001d\u0001\u0005\u0002\u0005e\u0006bBAv\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003_\u0004A\u0011AA]\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003sCq!a>\u0001\t\u0003\tI\fC\u0004\u0002|\u0002!\t!!/\t\u000f\u0005}\b\u0001\"\u0001\u0002:\"9!1\u0001\u0001\u0005\u0002\u0005e\u0006b\u0002B\u0004\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005\u0017\u0001A\u0011AA]\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003sCqAa\u0005\u0001\t\u0003\tI\fC\u0004\u0003\u0018\u0001!\t!!/\t\u000f\tm\u0001\u0001\"\u0001\u0002:\"9!q\u0004\u0001\u0005\u0002\u0005e\u0006b\u0002B\u0012\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005O\u0001A\u0011AA]\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0003sCqAa\f\u0001\t\u0003\tI\fC\u0004\u00034\u0001!\t!!/\t\u000f\t]\u0002\u0001\"\u0001\u0002:\"9!1\b\u0001\u0005\u0002\u0005e\u0006b\u0002B \u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005\u0007\u0002A\u0011AA]\u0011\u001d\u00119\u0005\u0001C\u0001\u0003sCqAa\u0013\u0001\t\u0003\tI\fC\u0004\u0003P\u0001!\t!!/\t\u000f\tM\u0003\u0001\"\u0001\u0002:\"9!q\u000b\u0001\u0005\u0002\u0005e\u0006b\u0002B.\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005?\u0002A\u0011AA]\u0005}!v\u000e]5d\u0007>lW.\u00198e/&$\b.\u00113nS:\u001cE.[3oiR+7\u000f\u001e\u0006\u0003yu\nQ!\u00193nS:T\u0011AP\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0011iR'\u0011\u0005\t+U\"A\"\u000b\u0005\u0011k\u0014aC5oi\u0016<'/\u0019;j_:L!AR\"\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"\u0001S&\u000e\u0003%S!AS\u001f\u0002\u000bU$\u0018\u000e\\:\n\u00051K%a\u0002'pO\u001eLgn\u001a\t\u0003\u001d>k\u0011aO\u0005\u0003!n\u0012QBU1dW\u0006;\u0018M]3UKN$\u0018A\u0002\u001fj]&$h\bF\u0001T!\tq\u0005!A\bhK:,'/\u0019;f\u0007>tg-[4t+\u00051\u0006cA,bI:\u0011\u0001L\u0018\b\u00033rk\u0011A\u0017\u0006\u00037~\na\u0001\u0010:p_Rt\u0014\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}\u0003\u0017a\u00029bG.\fw-\u001a\u0006\u0002;&\u0011!m\u0019\u0002\u0004'\u0016\f(BA0a!\t)\u0007.D\u0001g\u0015\t9W(\u0001\u0004tKJ4XM]\u0005\u0003S\u001a\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006aAo\u001c9jGN+'O^5dKV\tA\u000e\u0005\u0002ni:\u0011aN\u001d\b\u0003_Ft!!\u00179\n\u0003yJ!\u0001P\u001f\n\u0005M\\\u0014\u0001\u0004+pa&\u001c7i\\7nC:$\u0017BA;w\u0005]\tE-\\5o\u00072LWM\u001c;U_BL7mU3sm&\u001cWM\u0003\u0002tw\u0005\u0001Bo\u001c9jGN+'O^5dK~#S-\u001d\u000b\u0003sv\u0004\"A_>\u000e\u0003\u0001L!\u0001 1\u0003\tUs\u0017\u000e\u001e\u0005\b}\u0012\t\t\u00111\u0001m\u0003\rAH%M\u0001\u000ei>\u0004\u0018nY*feZL7-\u001a\u0011\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u001a5\u0011\u0011\u0011\u0002\u0006\u0004y\u0005-!\u0002BA\u0007\u0003\u001f\tqa\u00197jK:$8OC\u0002?\u0003#QA!a\u0005\u0002\u0016\u00051\u0011\r]1dQ\u0016T!!a\u0006\u0002\u0007=\u0014x-\u0003\u0003\u0002\u001c\u0005%!aC!e[&t7\t\\5f]R\fq\"\u00193nS:\u001cE.[3oi~#S-\u001d\u000b\u0004s\u0006\u0005\u0002\u0002\u0003@\b\u0003\u0003\u0005\r!!\u0002\u0002\u0019\u0005$W.\u001b8DY&,g\u000e\u001e\u0011\u0002\u001bQ,7\u000f\u001e+pa&\u001cg*Y7f+\t\tI\u0003\u0005\u0003\u0002,\u0005Mb\u0002BA\u0017\u0003_\u0001\"!\u00171\n\u0007\u0005E\u0002-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c\u0001\u0017!\u0005;fgR$v\u000e]5d\u001d\u0006lWm\u0018\u0013fcR\u0019\u00110!\u0010\t\u0011yT\u0011\u0011!a\u0001\u0003S\ta\u0002^3tiR{\u0007/[2OC6,\u0007%A\u0005`i\u0016\u001cHOT1nKV\u0011\u0011Q\t\t\u0005\u0003\u000f\n\t&\u0004\u0002\u0002J)!\u00111JA'\u0003\u0015\u0011X\u000f\\3t\u0015\u0011\ty%!\u0006\u0002\u000b),h.\u001b;\n\t\u0005M\u0013\u0011\n\u0002\t)\u0016\u001cHOT1nK\u0006Qq\f^3ti:\u000bW.\u001a\u0011\u0002\u0011Q,7\u000f\u001e(b[\u0016D3ADA.!\u0011\ti&a\u0018\u000e\u0005\u00055\u0013\u0002BA1\u0003\u001b\u0012AAU;mK\u0006q\u0011m]:feR,\u00050\u001b;D_\u0012,G#B=\u0002h\u0005E\u0004bBA5\u001f\u0001\u0007\u00111N\u0001\tKb\u0004Xm\u0019;fIB\u0019!0!\u001c\n\u0007\u0005=\u0004MA\u0002J]RDq!a\u001d\u0010\u0001\u0004\t)(\u0001\u0004nKRDw\u000e\u001a\t\u0005u\u0006]\u00140C\u0002\u0002z\u0001\u0014\u0011BR;oGRLwN\u001c\u0019\u0002/\u0005\u001c8/\u001a:u\u0007\",7m[!sON,\u00050\u001b;D_\u0012,G#B=\u0002\u0000\u0005\u0005\u0005bBA5!\u0001\u0007\u00111\u000e\u0005\b\u0003\u0007\u0003\u0002\u0019AAC\u0003\u001dy\u0007\u000f^5p]N\u00042!\\AD\u0013\r\tII\u001e\u0002\u0014)>\u0004\u0018nY\"p[6\fg\u000eZ(qi&|gn]\u0001\u0013GJ,\u0017\r^3B]\u0012<\u0016-\u001b;U_BL7\rF\u0002z\u0003\u001fCq!!%\u0012\u0001\u0004\t))\u0001\u0003paR\u001c\u0018aE<bSR4uN\u001d+pa&\u001c7I]3bi\u0016$G#B=\u0002\u0018\u0006m\u0005bBAM%\u0001\u0007\u0011\u0011F\u0001\ni>\u0004\u0018n\u0019(b[\u0016D\u0011\"!(\u0013!\u0003\u0005\r!a\u001b\u0002\u000fQLW.Z8vi\u0006ir/Y5u\r>\u0014Hk\u001c9jG\u000e\u0013X-\u0019;fI\u0012\"WMZ1vYR$#'\u0006\u0002\u0002$*\"\u00111NASW\t\t9\u000b\u0005\u0003\u0002*\u0006MVBAAV\u0015\u0011\ti+a,\u0002\u0013Ut7\r[3dW\u0016$'bAAYA\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00161\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!B:fiV\u0004H#A=)\u0007Q\ti\f\u0005\u0003\u0002^\u0005}\u0016\u0002BAa\u0003\u001b\u0012aAQ3g_J,\u0017!B2m_N,\u0007fA\u000b\u0002HB!\u0011QLAe\u0013\u0011\tY-!\u0014\u0003\u000b\u00053G/\u001a:\u0002'Q,7\u000f\u001e)beN,\u0017i]:jO:lWM\u001c;)\u0007Y\t\t\u000e\u0005\u0003\u0002^\u0005M\u0017\u0002BAk\u0003\u001b\u0012A\u0001V3ti\u0006\u0019C/Z:u!\u0006\u00148/Z!tg&<g.\\3oi\u0012+\b\u000f\\5dCR,WI\u001c;sS\u0016\u001c\bfA\f\u0002R\u0006aC/Z:u!\u0006\u00148/Z!tg&<g.\\3oiB\u000b'\u000f^5uS>t7o\u00144ES\u001a4WM]3oiNK'0\u001a\u0015\u00041\u0005E\u0017!\t;fgR\u001cuN\u001c4jO>\u0003HoV5uQ\n{w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001c\bfA\r\u0002R\u0006QA/Z:u\u0007J,\u0017\r^3)\u0007i\t\t.A\u000buKN$8I]3bi\u0016<\u0016\u000e\u001e5D_:4\u0017nZ:)\u0007m\t\t.A\u000euKN$8I]3bi\u0016Le-\u0013;BYJ,\u0017\rZ=Fq&\u001cHo\u001d\u0015\u00049\u0005E\u0017a\b;fgR\u001c%/Z1uK^KG\u000f\u001b*fa2L7-Y!tg&<g.\\3oi\"\u001aQ$!5\u0002MQ,7\u000f^\"sK\u0006$XmV5uQ&sg/\u00197jIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fK\u0002\u001f\u0003#\fq\u0005^3ti\u000e\u0013X-\u0019;f/&$\bNT3hCRLg/\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\"\u001aq$!5\u0002SQ,7\u000f^\"sK\u0006$XmV5uQ\u0006\u001b8/[4o[\u0016tG/\u00118e!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\r\u0001\u0013\u0011[\u0001-i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001c3SKBd\u0017nY1uS>tg)Y2u_JD3!IAi\u0003\u0011\"Xm\u001d;De\u0016\fG/Z,ji\"tUmZ1uSZ,\u0007+\u0019:uSRLwN\\\"pk:$\bf\u0001\u0012\u0002R\u00069C/Z:u\u0007J,\u0017\r^3XSRDWK\\:qK\u000eLg-[3e!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\r\u0019\u0013\u0011[\u0001\u001ci\u0016\u001cH/\u00138wC2LG\rV8qS\u000edUM^3m\u0007>tg-[4)\u0007\u0011\n\t.\u0001\buKN$H*[:u)>\u0004\u0018nY:)\u0007\u0015\n\t.A\u000euKN$H*[:u)>\u0004\u0018nY:XSRDw\u000b[5uK2L7\u000f\u001e\u0015\u0004M\u0005E\u0017!\t;fgRd\u0015n\u001d;U_BL7m],ji\",\u0005p\u00197vI\u0016Le\u000e^3s]\u0006d\u0007fA\u0014\u0002R\u00069B/Z:u\u00032$XM\u001d)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0004Q\u0005E\u0017a\u0005;fgR\fE\u000e^3s\u0003N\u001c\u0018n\u001a8nK:$\bfA\u0015\u0002R\u0006\u0019D/Z:u\u00032$XM]!tg&<g.\\3oi^KG\u000f['pe\u0016\f5o]5h]6,g\u000e\u001e+iC:\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004U\u0005E\u0017a\r;fgR\fE\u000e^3s\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u001b>\u0014X\rU1si&$\u0018n\u001c8t)\"\fg.Q:tS\u001etW.\u001a8uQ\rY\u0013\u0011[\u0001#i\u0016\u001cH/\u00117uKJ<\u0016\u000e\u001e5J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\u00071\n\t.\u0001\u0014uKN$\u0018\t\u001c;fe^KG\u000f[+ogB,7-\u001b4jK\u0012\u0004\u0016M\u001d;ji&|gnQ8v]RD3!LAi\u0003u!Xm\u001d;BYR,'o\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$\bf\u0001\u0018\u0002R\u0006aD/Z:u\u0013\u001a,\u00050[:ug\u0006sG-\u00134O_R,\u00050[:ug>\u0003H/[8og&sg/\u00197jI^KG\u000f\u001b\"p_R\u001cHO]1q'\u0016\u0014h/\u001a:tQ\ry\u0013\u0011[\u0001\"i\u0016\u001cHo\u0011:fCR,\u0017\t\u001c;feR{\u0007/[2XSRD'+Y2l\u0003^\f'/\u001a\u0015\u0004a\u0005E\u0017a\f;fgR\u001cuN\u001c4jOB\u0013Xm]3sm\u0006$\u0018n\u001c8BGJ|7o\u001d)beRLG/[8o\u00032$XM]1uS>t\u0007fA\u0019\u0002R\u0006\tB/Z:u)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0007I\n\t.A\fuKN$H)\u001a7fi\u0016Le\u000e^3s]\u0006dGk\u001c9jG\"\u001a1'!5\u0002%Q,7\u000f\u001e#fY\u0016$X-\u00134Fq&\u001cHo\u001d\u0015\u0004i\u0005E\u0017\u0001\u0004;fgR$Um]2sS\n,\u0007fA\u001b\u0002R\u0006\tC/Z:u\t\u0016\u001c8M]5cKVs\u0017M^1jY\u0006\u0014G.\u001a)beRLG/[8og\"\u001aa'!5\u0002KQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u0012,'O]3qY&\u001c\u0017\r^3e!\u0006\u0014H/\u001b;j_:\u001c\bfA\u001c\u0002R\u0006\u0019C/Z:u\t\u0016\u001c8M]5cKJ+\u0007o\u001c:u\u001fZ,'O]5eI\u0016t7i\u001c8gS\u001e\u001c\bf\u0001\u001d\u0002R\u0006qC/Z:u\t\u0016\u001c8M]5cK\u0006sG\rT5tiR{\u0007/[2t/&$\bn\\;u\u0013:$XM\u001d8bYR{\u0007/[2tQ\rI\u0014\u0011\u001b")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private TopicCommand.AdminClientTopicService topicService;
    private AdminClient adminClient;
    private String testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = 6;
        String x$2 = this.zkConnect();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<Object, String>)x$3, x$13, x$14).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    private TopicCommand.AdminClientTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.topicService = x$1;
    }

    private AdminClient adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(AdminClient x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(exitCode, exitMessage) -> TopicCommandWithAdminClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected));
        try {
            this.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    public void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        this.assertExitCode(expected, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> options.checkArgs());
    }

    public void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    public void waitForTopicCreated(String topicName, int timeout) {
        long finishTime = System.currentTimeMillis() + (long)timeout;
        boolean result = false;
        while (System.currentTimeMillis() < finishTime || !result) {
            Set topics = (Set)this.adminClient().listTopics(new ListTopicsOptions().listInternal(true)).names().get();
            result = topics.contains(topicName);
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)new StringBuilder(50).append("Topic ").append(topicName).append(" has not been created within the given ").append(timeout).append(" time").toString(), (boolean)result);
    }

    public int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Before
    public void setup() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(AdminClient.create((Properties)props));
        this.topicService_$eq(TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @After
    public void close() {
        block0: {
            if (this.topicService() == null) break block0;
            this.topicService().close();
        }
    }

    @Test
    public void testParseAssignment() {
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        Assert.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        this.intercept((Function0 & Serializable & scala.Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        this.intercept((Function0 & Serializable & scala.Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--config", "cleanup.policy=compact"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--delete-config", "cleanup.policy"})));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--topic", this.testTopicName(), "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"}));
        opts.checkArgs();
        Assert.assertTrue((boolean)opts.hasCreateOption());
        Assert.assertEquals((Object)this.brokerList(), (Object)opts.bootstrapServer().get());
        Assert.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        ((Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"})));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateIfItAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)3L, (long)partitions.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)32768)).toString(), "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
    }

    @Test
    public void testCreateWithUnspecifiedPartitionCount() {
        this.assertExitCode(1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replication-factor", "1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
    }

    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, 2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, 2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, 2), (List)Nil$.MODULE$)))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"}))));
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, 2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, 2), (List)Nil$.MODULE$))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, 2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, 2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, 2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, 2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName()})));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicService.alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
    }

    @Test
    public void testIfExistsAndIfNotExistsOptionsInvalidWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--alter", "--if-exists", "--topic", this.testTopicName(), "--partitions", "1"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--create", "--if-not-exists", "--topic", this.testTopicName(), "--partitions", "1", "--replication-factor", "1"})));
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        Assert.assertTrue((String)"Delete path for topic should exist after deletion.", (boolean)this.zkClient().pathExists(deletePath));
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        Assert.assertTrue((String)"Delete path for topic should exist after deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
    }

    @Test
    public void testDeleteIfExists() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
    }

    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, 2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        String[] rows = output.split("\n");
        Assert.assertEquals((long)3L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:2").toString());
    }

    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, 1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertTrue((boolean)rows[0].endsWith("Leader: none\tReplicas: 0\tIsr: "));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderreplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, 6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString(), (boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"}))));
        Assert.assertTrue((String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString(), (boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public TopicCommandWithAdminClientTest() {
        RackAwareTest.$init$(this);
        this._testName = new TestName();
    }
}

