/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.AdminClientIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001\u0002\u0010 \u0001\u0011BQ!\r\u0001\u0005\u0002IBq!\u000e\u0001A\u0002\u0013\u0005a\u0007C\u0004E\u0001\u0001\u0007I\u0011A#\t\r9\u0003\u0001\u0015)\u00038\u0011\u001dy\u0005A1A\u0005\u0002ACa\u0001\u0016\u0001!\u0002\u0013\t\u0006\"B+\u0001\t\u00031\u0006\"\u00023\u0001\t\u0003*\u0007\"\u00026\u0001\t\u0003*\u0007\"B8\u0001\t\u0003\u0001\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\u0007\u0003o\u0001A\u0011A3\t\r\u0005\u0005\u0003\u0001\"\u0001f\u0011\u0019\t)\u0005\u0001C\u0001K\u001e9\u0011\u0011J\u0010\t\u0002\u0005-cA\u0002\u0010 \u0011\u0003\ti\u0005\u0003\u00042!\u0011\u0005\u00111\f\u0004\u0007\u0003;\u0002\u0002!a\u0018\t\rE\u0012B\u0011AA8\u0011-\t)H\u0005a\u0001\u0002\u0004%\t!a\u001e\t\u0017\u0005]%\u00031AA\u0002\u0013\u0005\u0011\u0011\u0014\u0005\f\u0003\u000f\u0013\u0002\u0019!A!B\u0013\tI\bC\u0005\u0002&J\u0001\r\u0011\"\u0001\u0002(\"I\u0011q\u0016\nA\u0002\u0013\u0005\u0011\u0011\u0017\u0005\t\u0003k\u0013\u0002\u0015)\u0003\u0002*\"9\u0011q\u0017\n\u0005\u0002\u0005e\u0006bBAd%\u0011\u0005\u0011\u0011\u001a\u0005\u0007\u0003;\u0014B\u0011A3\t\u0013\u0005}\u0007#!A\u0005\n\u0005\u0005(AJ!e[&t7\t\\5f]R<\u0016\u000e\u001e5Q_2L7-[3t\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011\u0001%I\u0001\u0004CBL'\"\u0001\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!\n\u0013aC5oi\u0016<'/\u0019;j_:L!AK\u0014\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"\u0001L\u0018\u000e\u00035R!AL\u0011\u0002\u000bU$\u0018\u000e\\:\n\u0005Aj#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0002\"\u0001\u000e\u0001\u000e\u0003}\taa\u00197jK:$X#A\u001c\u0011\u0005a\u0012U\"A\u001d\u000b\u0005iZ\u0014!B1e[&t'B\u0001\u001f>\u0003\u001d\u0019G.[3oiNT!A\t \u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\u0005\u0003\u0007f\u00121\"\u00113nS:\u001cE.[3oi\u0006Q1\r\\5f]R|F%Z9\u0015\u0005\u0019c\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%\u0001B+oSRDq!T\u0002\u0002\u0002\u0003\u0007q'A\u0002yIE\nqa\u00197jK:$\b%A\u0006ce>\\WM]\"pk:$X#A)\u0011\u0005\u001d\u0013\u0016BA*I\u0005\rIe\u000e^\u0001\rEJ|7.\u001a:D_VtG\u000fI\u0001\u000eO2|'-\u00197US6,w.\u001e;\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\u000bI,H.Z:\u000b\u0005q\u0003\u0015!\u00026v]&$\u0018B\u00010Z\u0005\u001d!\u0016.\\3pkRD#a\u00021\u0011\u0005\u0005\u0014W\"A.\n\u0005\r\\&\u0001\u0002*vY\u0016\fQa]3u+B$\u0012A\u0012\u0015\u0003\u0011\u001d\u0004\"!\u00195\n\u0005%\\&A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\tIA\u000e\u0005\u0002b[&\u0011an\u0017\u0002\u0006\u0003\u001a$XM]\u0001\rGJ,\u0017\r^3D_:4\u0017nZ\u000b\u0002cB)!o^=\u0002\n5\t1O\u0003\u0002uk\u0006!Q\u000f^5m\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\u00075\u000b\u0007\u000fE\u0002{\u0003\u0007q!a_@\u0011\u0005qDU\"A?\u000b\u0005y\u001c\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0002!\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001\u0011B!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010U\fA\u0001\\1oO&!\u00111CA\u0007\u0005\u0019y%M[3di\u0006yq-\u001a8fe\u0006$XmQ8oM&<7/\u0006\u0002\u0002\u001aA1\u00111DA\u0013\u0003WqA!!\b\u0002\"9\u0019A0a\b\n\u0003%K1!a\tI\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\n\u0002*\t\u00191+Z9\u000b\u0007\u0005\r\u0002\n\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t$I\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005U\u0012q\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u000buKN$h+\u00197jI\u0006cG/\u001a:D_:4\u0017nZ:)\u00071\tY\u0004E\u0002b\u0003{I1!a\u0010\\\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f^%om\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001c\bfA\u0007\u0002<\u0005\u0011C/Z:u\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d#vKR{\u0007k\u001c7jGfD3ADA\u001e\u0003\u0019\nE-\\5o\u00072LWM\u001c;XSRD\u0007k\u001c7jG&,7/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003iA\u0019R\u0001EA(\u0003+\u00022aRA)\u0013\r\t\u0019\u0006\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\u001d\u000b9&C\u0002\u0002Z!\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u0013\u0003\rA{G.[2z'\u0015\u0011\u0012\u0011BA1!\u0011\t\u0019'a\u001b\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\na\u0001]8mS\u000eL(bAA\u0019{%!\u0011QNA3\u0005E\tE\u000e^3s\u0007>tg-[4Q_2L7-\u001f\u000b\u0003\u0003c\u00022!a\u001d\u0013\u001b\u0005\u0001\u0012aB2p]\u001aLwm]\u000b\u0003\u0003s\u0002D!a\u001f\u0002\u0004B1!0! z\u0003\u007fJ1\u0001_A\u0004!\u0011\t\t)a!\r\u0001\u0011Y\u0011Q\u0011\f\u0002\u0002\u0003\u0005)\u0011AAE\u0005\ryF%M\u0001\tG>tg-[4tAE!\u00111RAI!\r9\u0015QR\u0005\u0004\u0003\u001fC%a\u0002(pi\"Lgn\u001a\t\u0004\u000f\u0006M\u0015bAAK\u0011\n\u0019\u0011I\\=\u0002\u0017\r|gNZ5hg~#S-\u001d\u000b\u0004\r\u0006m\u0005\u0002C'\u0016\u0003\u0003\u0005\r!!(1\t\u0005}\u00151\u0015\t\u0007u\u0006u\u00140!)\u0011\t\u0005\u0005\u00151\u0015\u0003\r\u0003\u000b\u000bY*!A\u0001\u0002\u000b\u0005\u0011\u0011R\u0001\u0007G2|7/\u001a3\u0016\u0005\u0005%\u0006cA$\u0002,&\u0019\u0011Q\u0016%\u0003\u000f\t{w\u000e\\3b]\u0006Q1\r\\8tK\u0012|F%Z9\u0015\u0007\u0019\u000b\u0019\f\u0003\u0005N1\u0005\u0005\t\u0019AAU\u0003\u001d\u0019Gn\\:fI\u0002\n\u0011bY8oM&<WO]3\u0015\u0007\u0019\u000bY\fC\u0004\u0002vi\u0001\r!!01\t\u0005}\u00161\u0019\t\u0006e^L\u0018\u0011\u0019\t\u0005\u0003\u0003\u000b\u0019\r\u0002\u0007\u0002F\u0006m\u0016\u0011!A\u0001\u0006\u0003\tIIA\u0002`II\n\u0001B^1mS\u0012\fG/\u001a\u000b\u0004\r\u0006-\u0007bBAg7\u0001\u0007\u0011qZ\u0001\u0010e\u0016\fX/Z:u\u001b\u0016$\u0018\rZ1uCB!\u0011\u0011[Al\u001d\u0011\t\u0019'a5\n\t\u0005U\u0017QM\u0001\u0012\u00032$XM]\"p]\u001aLw\rU8mS\u000eL\u0018\u0002BAm\u00037\u0014qBU3rk\u0016\u001cH/T3uC\u0012\fG/\u0019\u0006\u0005\u0003+\f)'A\u0003dY>\u001cX-A\u0006sK\u0006$'+Z:pYZ,GCAA\u0005\u0001")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private AdminClient client = null;
    private final int brokerCount;

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        configs.foreach((Function1 & Serializable & scala.Serializable)props -> props.put(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), Policy.class));
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testValidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testInvalidAlterConfigsDueToPolicy() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, 1, 1, this.createTopic$default$4());
        List topicConfigEntries1 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2")}))).asJava();
        List topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.8")}))).asJava();
        List topicConfigEntries3 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "-1")}))).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().head()).config().brokerId())).toString());
        List brokerConfigEntries = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "12313")}))).asJava();
        ObjectRef alterResult = ObjectRef.create((Object)this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava()));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135))).getCause() instanceof InvalidRequestException));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.7")}))).asJava();
        alterResult.elem = this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165))).getCause() instanceof InvalidRequestException));
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, ?> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, ?> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, ?> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this.configs_$eq(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(configs).asScala()).toMap(Predef$.MODULE$.$conforms()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable & scala.Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(!this.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(requestMetadata.resource().name())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "resource name should not be empty");
            Predef$.MODULE$.require(requestMetadata.resource().name().contains("topic"));
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

