/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import kafka.api.BaseConsumerTest;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\rg!B(Q\u0003\u0003)\u0006\"\u0002.\u0001\t\u0003Y\u0006bB/\u0001\u0005\u0004%\tA\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B0\t\u000f\u0019\u0004!\u0019!C\u0001O\"11\u000e\u0001Q\u0001\n!Dq\u0001\u001c\u0001C\u0002\u0013\u0005Q\u000e\u0003\u0004w\u0001\u0001\u0006IA\u001c\u0005\bo\u0002\u0011\r\u0011\"\u0001h\u0011\u0019A\b\u0001)A\u0005Q\"9\u0011\u0010\u0001b\u0001\n\u0003Q\bbBA\u0007\u0001\u0001\u0006Ia\u001f\u0005\t\u0003\u001f\u0001!\u0019!C\u0001O\"9\u0011\u0011\u0003\u0001!\u0002\u0013A\u0007\u0002CA\n\u0001\t\u0007I\u0011\u0001>\t\u000f\u0005U\u0001\u0001)A\u0005w\"A\u0011q\u0003\u0001C\u0002\u0013\u0005Q\u000eC\u0004\u0002\u001a\u0001\u0001\u000b\u0011\u00028\t\u0011\u0005m\u0001A1A\u0005\u00025Dq!!\b\u0001A\u0003%a\u000eC\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005]\u0002\u0001\"\u0001\u0002\"!9\u0011\u0011\t\u0001\u0005\u0002\u0005\u0005bABA#\u0001!\t9\u0005\u0003\u0004[/\u0011\u0005\u0011q\f\u0005\t\u0003K:\u0002\u0019!C\u0001O\"I\u0011qM\fA\u0002\u0013\u0005\u0011\u0011\u000e\u0005\b\u0003_:\u0002\u0015)\u0003i\u0011!\t\th\u0006a\u0001\n\u00039\u0007\"CA:/\u0001\u0007I\u0011AA;\u0011\u001d\tIh\u0006Q!\n!Dq!a\u001f\u0018\t\u0003\ti\bC\u0004\u0002\u0010^!\t!!%\t\u000f\u0005U\u0005\u0001\"\u0005\u0002\u0018\"9\u0011q\u001b\u0001\u0005\u0012\u0005e\u0007\"\u0003B\u0007\u0001E\u0005I\u0011\u0003B\b\u0011%\u0011)\u0003AI\u0001\n#\u00119\u0003C\u0005\u0003,\u0001\t\n\u0011\"\u0005\u0003.!I!\u0011\u0007\u0001\u0012\u0002\u0013E!1\u0007\u0005\n\u0005o\u0001\u0011\u0013!C\t\u0005\u001fAqA!\u000f\u0001\t#\u0011Y\u0004C\u0005\u0003z\u0001\t\n\u0011\"\u0005\u0003|!9!\u0011\u0011\u0001\u0005\u0012\t\r\u0005\"\u0003BZ\u0001E\u0005I\u0011\u0003B[\u0011\u001d\u0011y\f\u0001C\t\u0005\u0003DqA!7\u0001\t#\u0011YN\u0002\u0004\u0003r\u0002A!1\u001f\u0005\u00075:\"\tAa?\t\u0011\t}h\u00061A\u0005\u0002\u001dD\u0011b!\u0001/\u0001\u0004%\taa\u0001\t\u000f\r\u001da\u0006)Q\u0005Q\"A1\u0011\u0002\u0018A\u0002\u0013\u0005q\rC\u0005\u0004\f9\u0002\r\u0011\"\u0001\u0004\u000e!91\u0011\u0003\u0018!B\u0013A\u0007\"CB\n]\u0001\u0007I\u0011AB\u000b\u0011%\u0019yB\fa\u0001\n\u0003\u0019\t\u0003\u0003\u0005\u0004&9\u0002\u000b\u0015BB\f\u0011\u001d\u00199C\fC!\u0007S1aaa\u000e\u0001\u0011\re\u0002BCA+u\t\u0005\t\u0015!\u0003\u0002^\"Q1q\t\u001e\u0003\u0002\u0003\u0006Ia!\u0013\t\riSD\u0011AB*\u0011%\u0019YF\u000fa\u0001\n\u0013\u0019i\u0006C\u0005\u0004fi\u0002\r\u0011\"\u0003\u0004h!A11\u000e\u001e!B\u0013\u0019y\u0006C\u0005\u0004vi\u0002\r\u0011\"\u0003\u0004x!I1\u0011\u0010\u001eA\u0002\u0013%11\u0010\u0005\t\u0007\u007fR\u0004\u0015)\u0003\u0004J!I1\u0011\u0011\u001eA\u0002\u0013%11\u0011\u0005\n\u0007\u0017S\u0004\u0019!C\u0005\u0007\u001bC\u0001b!%;A\u0003&1Q\u0011\u0005\n\u0005/T$\u0019!C\u0001\u0007+C\u0001b!(;A\u0003%1q\u0013\u0005\b\u0007?SD\u0011ABQ\u0011\u001d\u0019\u0019K\u000fC\u0001\u0007KCqaa+;\t\u0003\u0019i\u000bC\u0004\u00040j\"\te!,\t\u000f\rE&\b\"\u0011\u0002\"!911\u0017\u0001\u0005\u0002\rU&\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\t\t&+A\u0002ba&T\u0011aU\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u000b\u0005\u0002X16\t\u0001+\u0003\u0002Z!\n1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u00029B\u0011q\u000bA\u0001\bKB\u001c\u0018\u000e\\8o+\u0005y\u0006C\u00011d\u001b\u0005\t'\"\u00012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\f'A\u0002#pk\ndW-\u0001\u0005faNLGn\u001c8!\u0003-\u0019XM\u001d<fe\u000e{WO\u001c;\u0016\u0003!\u0004\"\u0001Y5\n\u0005)\f'aA%oi\u0006a1/\u001a:wKJ\u001cu.\u001e8uA\u0005)Ao\u001c9jGV\ta\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006!A.\u00198h\u0015\u0005\u0019\u0018\u0001\u00026bm\u0006L!!\u001e9\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005!\u0001/\u0019:u\u0003\u0015\u0001\u0018M\u001d;!\u0003\t!\b/F\u0001|!\ra\u0018\u0011B\u0007\u0002{*\u0011ap`\u0001\u0007G>lWn\u001c8\u000b\u0007M\u000b\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB1qC\u000eDWM\u0003\u0002\u0002\b\u0005\u0019qN]4\n\u0007\u0005-QP\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007Q\u0004\b%A\u0003qCJ$('\u0001\u0004qCJ$(\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\n\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0002#A\u0014x\u000eZ;dKJ\u001cE.[3oi&#\u0007%\u0001\td_:\u001cX/\\3s\u00072LWM\u001c;JI\u0006\t2m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005\r\u0002c\u00011\u0002&%\u0019\u0011qE1\u0003\tUs\u0017\u000e\u001e\u0015\u0004)\u0005-\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\t\u0005E\u0012QA\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003k\tyC\u0001\u0004CK\u001a|'/Z\u0001\u0016i\u0016\u001cHoU5na2,7i\u001c8tk6\u0004H/[8oQ\r)\u00121\b\t\u0005\u0003[\ti$\u0003\u0003\u0002@\u0005=\"\u0001\u0002+fgR\fq\u0003^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$bS2|g/\u001a:)\u0007Y\tYD\u0001\u0011UKN$8i\u001c8tk6,'OU3bgNLwM\\7f]Rd\u0015n\u001d;f]\u0016\u00148#B\f\u0002J\u0005=\u0003cA8\u0002L%\u0019\u0011Q\n9\u0003\r=\u0013'.Z2u!\u0011\t\t&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\n\u0001bY8ogVlWM\u001d\u0006\u0004\u00033z\u0018aB2mS\u0016tGo]\u0005\u0005\u0003;\n\u0019FA\rD_:\u001cX/\\3s%\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014HCAA1!\r\t\u0019gF\u0007\u0002\u0001\u0005y1-\u00197mgR{\u0017i]:jO:,G-A\ndC2d7\u000fV8BgNLwM\\3e?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005-\u0004\u0002CA75\u0005\u0005\t\u0019\u00015\u0002\u0007a$\u0013'\u0001\tdC2d7\u000fV8BgNLwM\\3eA\u0005q1-\u00197mgR{'+\u001a<pW\u0016$\u0017AE2bY2\u001cHk\u001c*fm>\\W\rZ0%KF$B!a\t\u0002x!A\u0011QN\u000f\u0002\u0002\u0003\u0007\u0001.A\bdC2d7\u000fV8SKZ|7.\u001a3!\u0003Qyg\u000eU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8fIR!\u00111EA@\u0011\u001d\t\ti\ba\u0001\u0003\u0007\u000b!\u0002]1si&$\u0018n\u001c8t!\u0015\t))a#|\u001b\t\t9IC\u0002\u0002\nJ\fA!\u001e;jY&!\u0011QRAD\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\u0014_:\u0004\u0016M\u001d;ji&|gn\u001d*fm>\\W\r\u001a\u000b\u0005\u0003G\t\u0019\nC\u0004\u0002\u0002\u0002\u0002\r!a!\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\t\u00033\u000bI-!5\u0002VB1\u00111TAV\u0003csA!!(\u0002(:!\u0011qTAS\u001b\t\t\tKC\u0002\u0002$R\u000ba\u0001\u0010:p_Rt\u0014\"\u00012\n\u0007\u0005%\u0016-A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0016q\u0016\u0002\u0004'\u0016\f(bAAUCBA\u00111WA]\u0003{\u000bi,\u0004\u0002\u00026*!\u0011qWA,\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002BA^\u0003k\u0013a\u0002\u0015:pIV\u001cWM\u001d*fG>\u0014H\rE\u0003a\u0003\u007f\u000b\u0019-C\u0002\u0002B\u0006\u0014Q!\u0011:sCf\u00042\u0001YAc\u0013\r\t9-\u0019\u0002\u0005\u0005f$X\rC\u0004\u00028\u0006\u0002\r!a3\u0011\u0011\u0005M\u0016QZA_\u0003{KA!a4\u00026\ni1*\u00194lCB\u0013x\u000eZ;dKJDa!a5\"\u0001\u0004A\u0017A\u00038v[J+7m\u001c:eg\")\u00110\ta\u0001w\u000692m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u000b\u0013\u0003G\tY.a9\u0002f\u0006%\u0018Q^A|\u0005\u000f\u0011I\u0001C\u0004\u0002V\t\u0002\r!!8\u0011\u0011\u0005E\u0013q\\A_\u0003{KA!!9\u0002T\tA1i\u001c8tk6,'\u000f\u0003\u0004\u0002T\n\u0002\r\u0001\u001b\u0005\u0007\u0003O\u0014\u0003\u0019\u00015\u0002\u001dM$\u0018M\u001d;j]\u001e|eMZ:fi\"A\u00111\u001e\u0012\u0011\u0002\u0003\u0007\u0001.\u0001\rti\u0006\u0014H/\u001b8h\u0017\u0016L\u0018I\u001c3WC2,X-\u00138eKbD\u0011\"a<#!\u0003\u0005\r!!=\u0002#M$\u0018M\u001d;j]\u001e$\u0016.\\3ti\u0006l\u0007\u000fE\u0002a\u0003gL1!!>b\u0005\u0011auN\\4\t\u0013\u0005e(\u0005%AA\u0002\u0005m\u0018!\u0004;j[\u0016\u001cH/Y7q)f\u0004X\r\u0005\u0003\u0002~\n\rQBAA\u0000\u0015\r\u0011\t!`\u0001\u0007e\u0016\u001cwN\u001d3\n\t\t\u0015\u0011q \u0002\u000e)&lWm\u001d;b[B$\u0016\u0010]3\t\u000fe\u0014\u0003\u0013!a\u0001w\"A!1\u0002\u0012\u0011\u0002\u0003\u0007\u0001.\u0001\bnCb\u0004v\u000e\u001c7SK\u000e|'\u000fZ:\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tE!f\u00015\u0003\u0014-\u0012!Q\u0003\t\u0005\u0005/\u0011\t#\u0004\u0002\u0003\u001a)!!1\u0004B\u000f\u0003%)hn\u00195fG.,GMC\u0002\u0003 \u0005\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019C!\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$S'\u0006\u0002\u0003*)\"\u0011\u0011\u001fB\n\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011yC\u000b\u0003\u0002|\nM\u0011!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012:TC\u0001B\u001bU\rY(1C\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$H\u0005O\u0001\u000fG>t7/^7f%\u0016\u001cwN\u001d3t+\u0019\u0011iD!\u0017\u0003nQA!q\bB9\u0005k\u00129\b\u0005\u0004\u0003B\t-#qJ\u0007\u0003\u0005\u0007RAA!\u0012\u0003H\u00059Q.\u001e;bE2,'b\u0001B%C\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t5#1\t\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0005\u0002R\tE#Q\u000bB6\u0013\u0011\u0011\u0019&a\u0015\u0003\u001d\r{gn];nKJ\u0014VmY8sIB!!q\u000bB-\u0019\u0001!qAa\u0017)\u0005\u0004\u0011iFA\u0001L#\u0011\u0011yF!\u001a\u0011\u0007\u0001\u0014\t'C\u0002\u0003d\u0005\u0014qAT8uQ&tw\rE\u0002a\u0005OJ1A!\u001bb\u0005\r\te.\u001f\t\u0005\u0005/\u0012i\u0007B\u0004\u0003p!\u0012\rA!\u0018\u0003\u0003YCq!!\u0016)\u0001\u0004\u0011\u0019\b\u0005\u0005\u0002R\u0005}'Q\u000bB6\u0011\u0019\t\u0019\u000e\u000ba\u0001Q\"A!1\u0002\u0015\u0011\u0002\u0003\u0007\u0001.\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*bAa\u0004\u0003~\t}Da\u0002B.S\t\u0007!Q\f\u0003\b\u0005_J#\u0019\u0001B/\u0003]\u0019XM\u001c3B]\u0012\fu/Y5u\u0003NLhnY\"p[6LG/\u0006\u0004\u0003\u0006\n5%\u0011\u0013\u000b\u0007\u0003G\u00119Ia%\t\u000f\u0005U#\u00061\u0001\u0003\nBA\u0011\u0011KAp\u0005\u0017\u0013y\t\u0005\u0003\u0003X\t5Ea\u0002B.U\t\u0007!Q\f\t\u0005\u0005/\u0012\t\nB\u0004\u0003p)\u0012\rA!\u0018\t\u0013\tU%\u0006%AA\u0002\t]\u0015AC8gMN,Go](qiB)\u0001M!'\u0003\u001e&\u0019!1T1\u0003\r=\u0003H/[8o!\u001d\u0011yJa*|\u0005[sAA!)\u0003$B\u0019\u0011qT1\n\u0007\t\u0015\u0016-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005S\u0013YKA\u0002NCBT1A!*b!\u0011\t\tFa,\n\t\tE\u00161\u000b\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f\u0017!I:f]\u0012\fe\u000eZ!xC&$\u0018i]=oG\u000e{W.\\5uI\u0011,g-Y;mi\u0012\u0012TC\u0002B\\\u0005w\u0013i,\u0006\u0002\u0003:*\"!q\u0013B\n\t\u001d\u0011Yf\u000bb\u0001\u0005;\"qAa\u001c,\u0005\u0004\u0011i&\u0001\bbo\u0006LGOU3cC2\fgnY3\u0015\r\u0005\r\"1\u0019Bk\u0011\u001d\t)\u0006\fa\u0001\u0005\u000b\u0004dAa2\u0003L\nE\u0007\u0003CA)\u0003?\u0014IMa4\u0011\t\t]#1\u001a\u0003\r\u0005\u001b\u0014\u0019-!A\u0001\u0002\u000b\u0005!Q\f\u0002\u0004?\u0012\n\u0004\u0003\u0002B,\u0005#$ABa5\u0003D\u0006\u0005\t\u0011!B\u0001\u0005;\u00121a\u0018\u00133\u0011\u001d\u00119\u000e\fa\u0001\u0003C\n\u0011C]3cC2\fgnY3MSN$XM\\3s\u0003E)gn];sK:{'+\u001a2bY\u0006t7-\u001a\u000b\u0007\u0003G\u0011iNa<\t\u000f\u0005US\u00061\u0001\u0003`B2!\u0011\u001dBs\u0005W\u0004\u0002\"!\u0015\u0002`\n\r(\u0011\u001e\t\u0005\u0005/\u0012)\u000f\u0002\u0007\u0003h\nu\u0017\u0011!A\u0001\u0006\u0003\u0011iFA\u0002`IM\u0002BAa\u0016\u0003l\u0012a!Q\u001eBo\u0003\u0003\u0005\tQ!\u0001\u0003^\t\u0019q\f\n\u001b\t\u000f\t]W\u00061\u0001\u0002b\tY2i\\;oi\u000e{gn];nKJ\u001cu.\\7ji\u000e\u000bG\u000e\u001c2bG.\u001cRALA%\u0005k\u0004B!!\u0015\u0003x&!!\u0011`A*\u0005QyeMZ:fi\u000e{W.\\5u\u0007\u0006dGNY1dWR\u0011!Q \t\u0004\u0003Gr\u0013\u0001D:vG\u000e,7o]\"pk:$\u0018\u0001E:vG\u000e,7o]\"pk:$x\fJ3r)\u0011\t\u0019c!\u0002\t\u0011\u00055\u0014'!AA\u0002!\fQb];dG\u0016\u001c8oQ8v]R\u0004\u0013!\u00034bS2\u001cu.\u001e8u\u000351\u0017-\u001b7D_VtGo\u0018\u0013fcR!\u00111EB\b\u0011!\ti\u0007NA\u0001\u0002\u0004A\u0017A\u00034bS2\u001cu.\u001e8uA\u0005IA.Y:u\u000bJ\u0014xN]\u000b\u0003\u0007/\u0001R\u0001\u0019BM\u00073\u0001B!a'\u0004\u001c%!1QDAX\u0005%)\u0005pY3qi&|g.A\u0007mCN$XI\u001d:pe~#S-\u001d\u000b\u0005\u0003G\u0019\u0019\u0003C\u0005\u0002n]\n\t\u00111\u0001\u0004\u0018\u0005QA.Y:u\u000bJ\u0014xN\u001d\u0011\u0002\u0015=t7i\\7qY\u0016$X\r\u0006\u0004\u0002$\r-21\u0007\u0005\b\u0007[I\u0004\u0019AB\u0018\u0003\u001dygMZ:fiN\u0004r!!\"\u00042m\u0014i+\u0003\u0003\u0003*\u0006\u001d\u0005bBB\u001bs\u0001\u00071\u0011D\u0001\nKb\u001cW\r\u001d;j_:\u0014\u0001dQ8ogVlWM]!tg&<g.\\3oiB{G\u000e\\3s'\rQ41\b\t\u0005\u0007{\u0019\u0019%\u0004\u0002\u0004@)\u00191\u0011\t*\u0002\u000bU$\u0018\u000e\\:\n\t\r\u00153q\b\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-A\tu_BL7m\u001d+p'V\u00147o\u0019:jE\u0016\u0004b!a'\u0004L\r=\u0013\u0002BB'\u0003_\u0013A\u0001T5tiB!!qTB)\u0013\r)(1\u0016\u000b\u0007\u0007+\u001a9f!\u0017\u0011\u0007\u0005\r$\bC\u0004\u0002Vu\u0002\r!!8\t\u000f\r\u001dS\b1\u0001\u0004J\u0005\u0019\u0002/\u0019:uSRLwN\\!tg&<g.\\3oiV\u00111q\f\t\u0006\u0005?\u001b\tg_\u0005\u0005\u0007G\u0012YKA\u0002TKR\fq\u0003]1si&$\u0018n\u001c8BgNLwM\\7f]R|F%Z9\u0015\t\u0005\r2\u0011\u000e\u0005\n\u0003[z\u0014\u0011!a\u0001\u0007?\nA\u0003]1si&$\u0018n\u001c8BgNLwM\\7f]R\u0004\u0003f\u0001!\u0004pA\u0019\u0001m!\u001d\n\u0007\rM\u0014M\u0001\u0005w_2\fG/\u001b7f\u0003I!x\u000e]5dgN+(m]2sSB$\u0018n\u001c8\u0016\u0005\r%\u0013A\u0006;pa&\u001c7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:|F%Z9\u0015\t\u0005\r2Q\u0010\u0005\n\u0003[\u0012\u0015\u0011!a\u0001\u0007\u0013\n1\u0003^8qS\u000e\u001c8+\u001e2tGJL\u0007\u000f^5p]\u0002\n1c];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\u0005.\u00198hK\u0012,\"a!\"\u0011\u0007\u0001\u001c9)C\u0002\u0004\n\u0006\u0014qAQ8pY\u0016\fg.A\ftk\n\u001c8M]5qi&|gn\u00115b]\u001e,Gm\u0018\u0013fcR!\u00111EBH\u0011%\ti'RA\u0001\u0002\u0004\u0019))\u0001\u000btk\n\u001c8M]5qi&|gn\u00115b]\u001e,G\r\t\u0015\u0004\r\u000e=TCABL%\u0019\u0019I*!\u0013\u0002P\u0019111\u0014%\u0001\u0007/\u0013A\u0002\u0010:fM&tW-\\3oiz\n!C]3cC2\fgnY3MSN$XM\\3sA\u0005\u00112m\u001c8tk6,'/Q:tS\u001etW.\u001a8u)\t\u0019y&A\u0005tk\n\u001c8M]5cKR!\u00111EBT\u0011\u001d\u0019IK\u0013a\u0001\u0007\u0013\nAC\\3x)>\u0004\u0018nY:U_N+(m]2sS\n,\u0017aG5t'V\u00147o\u0019:jE\u0016\u0014V-];fgR\u0004&o\\2fgN,G\r\u0006\u0002\u0004\u0006\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\\\u0001\u0007I><vN]6\u00025%\u001c\b+\u0019:uSRLwN\\!tg&<g.\\3oiZ\u000bG.\u001b3\u0015\r\r\u00155qWBa\u0011\u001d\u0019IL\u0014a\u0001\u0007w\u000b1\"Y:tS\u001etW.\u001a8ugB1!\u0011IB_\u0007?JAaa0\u0003D\t1!)\u001e4gKJDq!!!O\u0001\u0004\u0019y\u0006")
public abstract class BaseConsumerTest
extends IntegrationTestHarness {
    private final double epsilon;
    private final int serverCount;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String producerClientId;
    private final String consumerClientId;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
    }

    @Test
    public void testSimpleConsumption() {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assert.assertEquals((long)1L, (long)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)consumer, numRecords, 0, this.consumeAndVerifyRecords$default$4(), this.consumeAndVerifyRecords$default$5(), this.consumeAndVerifyRecords$default$6(), this.consumeAndVerifyRecords$default$7(), this.consumeAndVerifyRecords$default$8());
        this.sendAndAwaitAsyncCommit((Consumer)consumer, this.sendAndAwaitAsyncCommit$default$2());
    }

    @Test
    public void testCoordinatorFailover() {
        TestConsumerReassignmentListener listener = new TestConsumerReassignmentListener();
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "2000");
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance((Consumer<?, ?>)consumer, listener);
        Assert.assertEquals((long)1L, (long)listener.callsToAssigned());
        Seq parts = null;
        while (parts == null) {
            parts = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor("__consumer_offsets")).asScala();
        }
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaServer)this.servers().apply(coordinator)).shutdown();
        this.ensureNoRebalance((Consumer<?, ?>)consumer, listener);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> BaseConsumerTest.$anonfun$sendRecords$1(tp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assert.assertEquals((Object)tp.topic(), (Object)record.topic());
            Assert.assertEquals((long)tp.partition(), (long)record.partition());
            TimestampType timestampType = timestampType;
            TimestampType timestampType2 = TimestampType.CREATE_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assert.assertEquals((Object)timestampType, (Object)record.timestampType());
                long timestamp = startingTimestamp + (long)i;
                Assert.assertEquals((long)timestamp, (long)record.timestamp());
            } else {
                Assert.assertTrue((String)new StringBuilder(60).append("Got unexpected timestamp ").append(record.timestamp()).append(". Timestamp should be between [").append(startingTimestamp).append(", ").append(now).append("}]").toString(), (record.timestamp() >= startingTimestamp && record.timestamp() <= now ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)offset, (long)record.offset());
            int keyAndValueIndex = startingKeyAndValueIndex + i;
            Assert.assertEquals((Object)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.key()));
            Assert.assertEquals((Object)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.value()));
            Assert.assertEquals((long)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString().length(), (long)record.serializedKeySize());
            Assert.assertEquals((long)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString().length(), (long)record.serializedValueSize());
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        Consumer<K, V> x$1 = consumer;
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)BaseConsumerTest.pollAction$1(polledRecords, maxPollRecords, records, numRecords));
        long x$3 = 60000L;
        Function0 & Serializable & scala.Serializable x$4 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Timed out before consuming expected ").append(numRecords).append(" records. ").append(new StringBuilder(25).append("The number consumed was ").append(records.size()).append(".").toString()).toString();
        TestUtils$.MODULE$.pollRecordsUntilTrue(x$1, x$2, (Function0<String>)x$4, x$3);
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void sendAndAwaitAsyncCommit(Consumer<K, V> consumer, Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> offsetsOpt) {
        public class Kafka_api_BaseConsumerTest$RetryCommitCallback$1
        implements OffsetCommitCallback {
            private boolean isComplete;
            private Option<Exception> error;
            private final /* synthetic */ BaseConsumerTest $outer;
            private final Option offsetsOpt$1;
            private final Consumer consumer$1;

            public boolean isComplete() {
                return this.isComplete;
            }

            public void isComplete_$eq(boolean x$1) {
                this.isComplete = x$1;
            }

            public Option<Exception> error() {
                return this.error;
            }

            public void error_$eq(Option<Exception> x$1) {
                this.error = x$1;
            }

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                Exception exception2 = exception;
                if (exception2 instanceof RetriableCommitFailedException) {
                    BaseConsumerTest.kafka$api$BaseConsumerTest$$sendAsyncCommit$1(this, this.offsetsOpt$1, this.consumer$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.isComplete_$eq(true);
                    this.error_$eq((Option<Exception>)Option$.MODULE$.apply((Object)exception2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public Kafka_api_BaseConsumerTest$RetryCommitCallback$1(BaseConsumerTest $outer, Option offsetsOpt$1, Consumer consumer$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetsOpt$1 = offsetsOpt$1;
                this.consumer$1 = consumer$1;
                this.isComplete = false;
                this.error = None$.MODULE$;
            }
        }
        Kafka_api_BaseConsumerTest$RetryCommitCallback$1 commitCallback = new Kafka_api_BaseConsumerTest$RetryCommitCallback$1(this, offsetsOpt, consumer);
        BaseConsumerTest.kafka$api$BaseConsumerTest$$sendAsyncCommit$1(commitCallback, offsetsOpt, consumer);
        TestUtils$.MODULE$.pollUntilTrue(consumer, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> commitCallback.isComplete(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to observe commit callback before timeout", 10000L);
        Assert.assertEquals((Object)None$.MODULE$, commitCallback.error());
    }

    public <K, V> Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sendAndAwaitAsyncCommit$default$2() {
        return None$.MODULE$;
    }

    public void awaitRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int numReassignments = rebalanceListener.callsToAssigned();
        TestUtils$.MODULE$.pollUntilTrue(consumer, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> rebalanceListener.callsToAssigned() > numReassignments, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out before expected rebalance completed", TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    public void ensureNoRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int initialRevokeCalls = rebalanceListener.callsToRevoked();
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
        Assert.assertEquals((long)initialRevokeCalls, (long)rebalanceListener.callsToRevoked());
    }

    public boolean isPartitionAssignmentValid(Buffer<Set<TopicPartition>> assignments, Set<TopicPartition> partitions) {
        Set uniqueAssignedPartitions;
        boolean allNonEmptyAssignments = assignments.forall((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)assignment.nonEmpty()));
        if (!allNonEmptyAssignments) {
            return false;
        }
        int n = 0;
        int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToInteger((int)BaseConsumerTest.$anonfun$isPartitionAssignmentValid$2(BoxesRunTime.unboxToInt((Object)x$2), x$3))));
        if (totalPartitionsInAssignments != partitions.size()) {
            return false;
        }
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Set set2 = uniqueAssignedPartitions = (Set)assignments.$div$colon((Object)set, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> (Set)x$5.$plus$plus((GenTraversableOnce)x$6));
        Set<TopicPartition> set3 = partitions;
        return !(set2 != null ? !set2.equals(set3) : set3 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ProducerRecord $anonfun$sendRecords$1(TopicPartition tp$1, KafkaProducer producer$1, int i) {
        void var3_3;
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes());
        producer$1.send(record);
        return var3_3;
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, int maxPollRecords$1, ArrayBuffer records$2, int numRecords$1) {
        Assert.assertTrue((((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala()).size() <= maxPollRecords$1 ? 1 : 0) != 0);
        records$2.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final void kafka$api$BaseConsumerTest$$sendAsyncCommit$1(OffsetCommitCallback callback, Option offsetsOpt$1, Consumer consumer$1) {
        Option option = offsetsOpt$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)some.value();
            consumer$1.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), callback);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            consumer$1.commitAsync(callback);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ int $anonfun$isPartitionAssignmentValid$2(int x$2, Set x$3) {
        return x$2 + x$3.size();
    }

    public BaseConsumerTest() {
        this.epsilon = 0.1;
        this.serverCount = 3;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "10");
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer;
        private volatile Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private List<String> topicsSubscription;
        private volatile boolean subscriptionChanged;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ BaseConsumerTest $outer;

        private Set<TopicPartition> kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(Set<TopicPartition> x$1) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.poll(Duration.ofMillis(50L));
            }
            catch (WakeupException wakeupException) {}
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(BaseConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = Predef$.MODULE$.Set().empty();
            this.topicsSubscription = topicsToSubscribe;
            this.subscriptionChanged = false;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$consumer.assignment()).asScala()).toArray(ClassTag$.MODULE$.apply(TopicPartition.class))))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$BaseConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)Predef$.MODULE$.Set().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;
        private Option<Exception> lastError;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public Option<Exception> lastError() {
            return this.lastError;
        }

        public void lastError_$eq(Option<Exception> x$1) {
            this.lastError = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
                this.lastError_$eq((Option<Exception>)new Some((Object)exception));
            }
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$CountConsumerCommitCallback$$$outer() {
            return BaseConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
            this.lastError = None$.MODULE$;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsAssigned called.");
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsRevoked called.");
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ BaseConsumerTest kafka$api$BaseConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return BaseConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (BaseConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

