/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0017/\u0001MBQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013%q\b\u0003\u0004G\u0001\u0001\u0006I\u0001\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001b\u0001\n\u0013y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0004L\u0001\t\u0007I\u0011B \t\r1\u0003\u0001\u0015!\u0003A\u0011\u001di\u0005A1A\u0005\u0002}BaA\u0014\u0001!\u0002\u0013\u0001\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u00073\u0002\u0001\u000b\u0011B)\t\u000bi\u0003A\u0011A.\t\u000f9\u0004\u0001\u0019!C\u0005_\"I\u0011q\u0001\u0001A\u0002\u0013%\u0011\u0011\u0002\u0005\b\u0003+\u0001\u0001\u0015)\u0003q\u0011!\t9\u0002\u0001a\u0001\n\u0013y\u0007\"CA\r\u0001\u0001\u0007I\u0011BA\u000e\u0011\u001d\ty\u0002\u0001Q!\nAD\u0001\"!\t\u0001\u0001\u0004%Ia\u001c\u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003KAq!!\u000b\u0001A\u0003&\u0001\u000f\u0003\u0005\u0002,\u0001\u0001\r\u0011\"\u0003p\u0011%\ti\u0003\u0001a\u0001\n\u0013\ty\u0003C\u0004\u00024\u0001\u0001\u000b\u0015\u00029\t\u0013\u0005U\u0002A1A\u0005\n\u0005]\u0002\u0002CA#\u0001\u0001\u0006I!!\u000f\t\u0013\u0005\u001d\u0003A1A\u0005\n\u0005]\u0002\u0002CA%\u0001\u0001\u0006I!!\u000f\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u0011Q\f\u0001\u0005B\u00055\u0003bBA4\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003c\u0002A\u0011AA'\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!! \u0001\t\u0003\ti\u0005C\u0004\u0002\u0002\u0002!\t!!\u0014\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002N!9\u0011\u0011\u0012\u0001\u0005\u0002\u00055\u0003bBAG\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003#\u0003A\u0011AA'\u0011\u001d\t)\n\u0001C\u0001\u0003\u001bBq!!'\u0001\t\u0003\ti\u0005C\u0004\u0002\u001e\u0002!\t!!\u0014\u00037A\u0013x\u000eZ;dKJ4\u0015-\u001b7ve\u0016D\u0015M\u001c3mS:<G+Z:u\u0015\ty\u0003'A\u0002ba&T\u0011!M\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0007\u0005\u00026q5\taG\u0003\u00028a\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0013\tIdG\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tA\b\u0005\u0002>\u00015\ta&\u0001\nqe>$WoY3s\u0005V4g-\u001a:TSj,W#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\u0007%sG/A\nqe>$WoY3s\u0005V4g-\u001a:TSj,\u0007%A\u000btKJ4XM]'fgN\fw-Z'bq\nKH/Z:\u0002-M,'O^3s\u001b\u0016\u001c8/Y4f\u001b\u0006D()\u001f;fg\u0002\nQD]3qY&\u001c\u0017MR3uG\"l\u0015\r\u001f)beRLG/[8o\u0005f$Xm]\u0001\u001fe\u0016\u0004H.[2b\r\u0016$8\r['bqB\u000b'\u000f^5uS>t')\u001f;fg\u0002\nAD]3qY&\u001c\u0017MR3uG\"l\u0015\r\u001f*fgB|gn]3CsR,7/A\u000fsKBd\u0017nY1GKR\u001c\u0007.T1y%\u0016\u001c\bo\u001c8tK\nKH/Z:!\u0003)qW/\\*feZ,'o]\u0001\f]Vl7+\u001a:wKJ\u001c\b%A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0011)H/\u001b7\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001/\u0011\u0007u+\u0007N\u0004\u0002_G:\u0011qLY\u0007\u0002A*\u0011\u0011MM\u0001\u0007yI|w\u000e\u001e \n\u0003\rK!\u0001\u001a\"\u0002\u000fA\f7m[1hK&\u0011am\u001a\u0002\u0004'\u0016\f(B\u00013C!\tIG.D\u0001k\u0015\tY\u0007'\u0001\u0004tKJ4XM]\u0005\u0003[*\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006I\u0001O]8ek\u000e,'/M\u000b\u0002aB!\u0011o_?~\u001b\u0005\u0011(BA:u\u0003!\u0001(o\u001c3vG\u0016\u0014(BA;w\u0003\u001d\u0019G.[3oiNT!!M<\u000b\u0005aL\u0018AB1qC\u000eDWMC\u0001{\u0003\ry'oZ\u0005\u0003yJ\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b\u0003B!\u007f\u0003\u0003I!a \"\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0005\u000b\u0019!C\u0002\u0002\u0006\t\u0013AAQ=uK\u0006i\u0001O]8ek\u000e,'/M0%KF$B!a\u0003\u0002\u0012A\u0019\u0011)!\u0004\n\u0007\u0005=!I\u0001\u0003V]&$\b\u0002CA\n!\u0005\u0005\t\u0019\u00019\u0002\u0007a$\u0013'\u0001\u0006qe>$WoY3sc\u0001\n\u0011\u0002\u001d:pIV\u001cWM\u001d\u001a\u0002\u001bA\u0014x\u000eZ;dKJ\u0014t\fJ3r)\u0011\tY!!\b\t\u0011\u0005M1#!AA\u0002A\f!\u0002\u001d:pIV\u001cWM\u001d\u001a!\u0003%\u0001(o\u001c3vG\u0016\u00148'A\u0007qe>$WoY3sg}#S-\u001d\u000b\u0005\u0003\u0017\t9\u0003\u0003\u0005\u0002\u0014Y\t\t\u00111\u0001q\u0003)\u0001(o\u001c3vG\u0016\u00148\u0007I\u0001\naJ|G-^2feR\nQ\u0002\u001d:pIV\u001cWM\u001d\u001b`I\u0015\fH\u0003BA\u0006\u0003cA\u0001\"a\u0005\u001a\u0003\u0003\u0005\r\u0001]\u0001\u000baJ|G-^2feR\u0002\u0013A\u0002;pa&\u001c\u0017'\u0006\u0002\u0002:A!\u00111HA!\u001b\t\tiDC\u0002\u0002@U\u000bA\u0001\\1oO&!\u00111IA\u001f\u0005\u0019\u0019FO]5oO\u00069Ao\u001c9jGF\u0002\u0013A\u0002;pa&\u001c''A\u0004u_BL7M\r\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005-\u0001fA\u0010\u0002RA!\u00111KA-\u001b\t\t)FC\u0002\u0002Xe\fQA[;oSRLA!a\u0017\u0002V\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004A\u0005\u0005\u0004\u0003BA*\u0003GJA!!\u001a\u0002V\t)\u0011I\u001a;fe\u0006iB/Z:u)>|G*\u0019:hKJ+7m\u001c:e/&$\b.Q2l5\u0016\u0014x\u000eK\u0002\"\u0003W\u0002B!a\u0015\u0002n%!\u0011qNA+\u0005\u0011!Vm\u001d;\u00029Q,7\u000f\u001e+p_2\u000b'oZ3SK\u000e|'\u000fZ,ji\"\f5m[(oK\"\u001a!%a\u001b\u0002W\rDWmY6U_>d\u0015M]4f%\u0016\u001cwN\u001d3G_J\u0014V\r\u001d7jG\u0006$\u0018n\u001c8XSRD\u0017iY6BY2$B!a\u0003\u0002z!1\u00111P\u0012A\u0002\u0001\u000bA\"\\1y\r\u0016$8\r[*ju\u0016\fQ\u0006^3tiB\u000b'\u000f^5uS>tGk\\8MCJ<WMR8s%\u0016\u0004H.[2bi&|gnV5uQ\u0006\u001b7.\u00117mQ\r!\u00131N\u0001-i\u0016\u001cHOU3ta>t7/\u001a+p_2\u000b'oZ3G_J\u0014V\r\u001d7jG\u0006$\u0018n\u001c8XSRD\u0017iY6BY2D3!JA6\u0003Q!Xm\u001d;O_:,\u00050[:uK:$Hk\u001c9jG\"\u001aa%a\u001b\u0002'Q,7\u000f^,s_:<'I]8lKJd\u0015n\u001d;)\u0007\u001d\nY'\u0001\u000buKN$\u0018J\u001c<bY&$\u0007+\u0019:uSRLwN\u001c\u0015\u0004Q\u0005-\u0014a\u0005;fgR\u001cVM\u001c3BMR,'o\u00117pg\u0016$\u0007fA\u0015\u0002l\u0005iB/Z:u\u0007\u0006tgn\u001c;TK:$Gk\\%oi\u0016\u0014h.\u00197U_BL7\rK\u0002+\u0003W\nQ\u0003^3ti:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7\u000fK\u0002,\u0003W\n\u0001\u0006^3ti:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7/\u00114uKJ\u0014%o\\6feNCW\u000f\u001e3po:D3\u0001LA6\u0001")
public class ProducerFailureHandlingTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int replicaFetchMaxPartitionBytes = this.serverMessageMaxBytes() + 200;
    private final int replicaFetchMaxResponseBytes = this.replicaFetchMaxPartitionBytes() + 200;
    private final int numServers;
    private final Properties overridingProps = new Properties();
    private KafkaProducer<byte[], byte[]> producer1;
    private KafkaProducer<byte[], byte[]> producer2;
    private KafkaProducer<byte[], byte[]> producer3;
    private KafkaProducer<byte[], byte[]> producer4;
    private final String topic1;
    private final String topic2;

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    private int replicaFetchMaxPartitionBytes() {
        return this.replicaFetchMaxPartitionBytes;
    }

    private int replicaFetchMaxResponseBytes() {
        return this.replicaFetchMaxResponseBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaProducer<byte[], byte[]> producer1() {
        return this.producer1;
    }

    private void producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer1 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer2() {
        return this.producer2;
    }

    private void producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer2 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer3() {
        return this.producer3;
    }

    private void producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer3 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer4() {
        return this.producer4;
    }

    private void producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer4 = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$1 = this.brokerList();
        int x$2 = 0;
        int x$3 = 0;
        int x$4 = 30000;
        long x$5 = 10000L;
        long x$6 = this.producerBufferSize();
        int x$7 = TestUtils$.MODULE$.createProducer$default$6();
        int x$8 = TestUtils$.MODULE$.createProducer$default$7();
        int x$9 = TestUtils$.MODULE$.createProducer$default$8();
        String x$10 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$11 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$12 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$13 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        this.producer1_$eq(TestUtils$.MODULE$.createProducer(x$1, x$2, x$5, x$6, x$3, x$7, x$8, x$9, x$10, x$4, x$11, x$12, x$13, x$14, x$15));
        String x$16 = this.brokerList();
        int x$17 = 1;
        int x$18 = 0;
        int x$19 = 30000;
        long x$20 = 10000L;
        long x$21 = this.producerBufferSize();
        int x$22 = TestUtils$.MODULE$.createProducer$default$6();
        int x$23 = TestUtils$.MODULE$.createProducer$default$7();
        int x$24 = TestUtils$.MODULE$.createProducer$default$8();
        String x$25 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$26 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$27 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$28 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$29 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$30 = TestUtils$.MODULE$.createProducer$default$15();
        this.producer2_$eq(TestUtils$.MODULE$.createProducer(x$16, x$17, x$20, x$21, x$18, x$22, x$23, x$24, x$25, x$19, x$26, x$27, x$28, x$29, x$30));
        String x$31 = this.brokerList();
        int x$32 = -1;
        int x$33 = 0;
        int x$34 = 30000;
        long x$35 = 10000L;
        long x$36 = this.producerBufferSize();
        int x$37 = TestUtils$.MODULE$.createProducer$default$6();
        int x$38 = TestUtils$.MODULE$.createProducer$default$7();
        int x$39 = TestUtils$.MODULE$.createProducer$default$8();
        String x$40 = TestUtils$.MODULE$.createProducer$default$9();
        SecurityProtocol x$41 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$42 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$43 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$44 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$45 = TestUtils$.MODULE$.createProducer$default$15();
        this.producer3_$eq(TestUtils$.MODULE$.createProducer(x$31, x$32, x$35, x$36, x$33, x$37, x$38, x$39, x$40, x$34, x$41, x$42, x$43, x$44, x$45));
    }

    @Override
    @After
    public void tearDown() {
        if (this.producer1() != null) {
            this.producer1().close();
        }
        if (this.producer2() != null) {
            this.producer2().close();
        }
        if (this.producer3() != null) {
            this.producer3().close();
        }
        if (this.producer4() != null) {
            this.producer4().close();
        }
        super.tearDown();
    }

    @Test
    public void testTooLargeRecordWithAckZero() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer1().send(record).get();
        Assert.assertNotNull((Object)recordMetadata);
        Assert.assertFalse((boolean)recordMetadata.hasOffset());
        Assert.assertEquals((long)-1L, (long)recordMetadata.offset());
    }

    @Test
    public void testTooLargeRecordWithAckOne() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        this.intercept((Function0 & Serializable & scala.Serializable)() -> (RecordMetadata)this.producer2().send(record).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }

    private void checkTooLargeRecordForReplicationWithAckAll(int maxFetchSize) {
        int maxMessageSize = maxFetchSize + 100;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
        topicConfig.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)maxMessageSize)).toString());
        String topic10 = "topic10";
        this.createTopic(topic10, this.servers().size(), this.numServers(), topicConfig);
        byte[] value = new byte[maxMessageSize - 61 - 21];
        ProducerRecord record = new ProducerRecord(topic10, null, (Object)value);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer3().send(record).get();
        Assert.assertEquals((Object)topic10, (Object)recordMetadata.topic());
    }

    @Test
    public void testPartitionTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxPartitionBytes());
    }

    @Test
    public void testResponseTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxResponseBytes());
    }

    @Test
    public void testNonExistentTopic() {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> (RecordMetadata)this.producer1().send(record).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }

    @Test
    public void testWrongBrokerList() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        this.producer4_$eq(TestUtils$.MODULE$.createProducer("localhost:8686,localhost:4242", 1, 10000L, this.producerBufferSize(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> (RecordMetadata)this.producer4().send(record).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
    }

    @Test
    public void testInvalidPartition() {
        this.createTopic(this.topic1(), 1, this.numServers(), this.createTopic$default$4());
        ProducerRecord higherRecord = new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        Throwable throwable = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> (RecordMetadata)this.producer1().send(higherRecord).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194))).getCause();
        if (!(throwable instanceof TimeoutException)) {
            throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Test
    public void testSendAfterClosed() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer1().send(record).get();
        this.producer2().send(record).get();
        this.producer3().send(record).get();
        this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            this.producer1().close();
            return this.producer1().send(record);
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            this.producer2().close();
            return this.producer2().send(record);
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            this.producer3().close();
            return this.producer3().send(record);
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
    }

    @Test
    public void testCannotSendToInternalTopic() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ExecutionException thrown = (ExecutionException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (RecordMetadata)this.producer2().send(new ProducerRecord("__consumer_offsets", (Object)"test".getBytes(), (Object)"test".getBytes())).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        Assert.assertTrue((String)new StringBuilder(55).append("Unexpected exception while sending to an invalid topic ").append(thrown.getCause()).toString(), (boolean)(thrown.getCause() instanceof InvalidTopicException));
    }

    @Test
    public void testNotEnoughReplicas() {
        String topicName = "minisrtest";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)(this.numServers() + 1))).toString());
        String x$1 = topicName;
        int x$2 = this.numServers();
        Properties x$3 = topicProps;
        int x$4 = this.createTopic$default$2();
        this.createTopic(x$1, x$4, x$2, x$3);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        try {
            this.producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas", new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof NotEnoughReplicasException)) {
                throw this.fail("Expected NotEnoughReplicasException when producing to topic with fewer brokers than min.insync.replicas", new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            }
            return;
        }
    }

    @Test
    public void testNotEnoughReplicasAfterBrokerShutdown() {
        String topicName = "minisrtest2";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
        String x$1 = topicName;
        int x$2 = this.numServers();
        Properties x$3 = topicProps;
        int x$4 = this.createTopic$default$2();
        this.createTopic(x$1, x$4, x$2, x$3);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer3().send(record).get();
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        try {
            this.producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas", new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof NotEnoughReplicasException || e.getCause() instanceof NotEnoughReplicasAfterAppendException || e.getCause() instanceof TimeoutException)) {
                throw this.fail(new StringBuilder(154).append("Expected NotEnoughReplicasException or NotEnoughReplicasAfterAppendException when producing to topic with fewer brokers than min.insync.replicas, but saw ").append(e.getCause()).toString(), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
            }
            ((KafkaServer)this.servers().head()).startup();
            return;
        }
    }

    public ProducerFailureHandlingTest() {
        this.producerBufferSize = 30000;
        this.numServers = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxPartitionBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxResponseBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.producer1 = null;
        this.producer2 = null;
        this.producer3 = null;
        this.producer4 = null;
        this.topic1 = "topic-1";
        this.topic2 = "topic-2";
    }
}

