/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnKey;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001Q3AAC\u0006\u0001%!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0015\u0001A\u0003%1\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\t\r=\u0002\u0001\u0015!\u0003-\u0011\u001d\u0001\u0004A1A\u0005\u0002EBaA\u0012\u0001!\u0002\u0013\u0011\u0004\"B$\u0001\t\u0003A\u0005\"\u0002*\u0001\t\u0003A%A\u0005+sC:\u001c\u0018m\u0019;j_:dun\u001a+fgRT!\u0001D\u0007\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u001d=\t1bY8pe\u0012Lg.\u0019;pe*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u001c\u001b\u0005)\"B\u0001\f\u0018\u0003\u0015QWO\\5u\u0015\tA\u0012$A\u0005tG\u0006d\u0017\r^3ti*\t!$A\u0002pe\u001eL!\u0001H\u000b\u0003\u0015)+f.\u001b;Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0017\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0006'\"|'\u000f^\u0001\u000faJ|G-^2fe\u0016\u0003xn\u00195!\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;NgV\tA\u0006\u0005\u0002%[%\u0011a&\n\u0002\u0004\u0013:$\u0018!\u0006;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000fI\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogV\t!\u0007E\u00024uur!\u0001\u000e\u001d\u0011\u0005U*S\"\u0001\u001c\u000b\u0005]\n\u0012A\u0002\u001fs_>$h(\u0003\u0002:K\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\u0007M+GO\u0003\u0002:KA\u0011a\bR\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0007G>lWn\u001c8\u000b\u0005A\u0011%BA\"\u001a\u0003\u0019\t\u0007/Y2iK&\u0011Qi\u0010\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0012tQ>,H\u000e\u001a+ie><X\t_2faRLwN\\,sSR,\u0017J\u001c<bY&$G\u000b\u001f8\u0015\u0003%\u0003\"\u0001\n&\n\u0005-+#\u0001B+oSRD#\u0001C'\u0011\u00059\u0003V\"A(\u000b\u0005YI\u0012BA)P\u0005\u0011!Vm\u001d;\u0002/MDw.\u001e7e%\u0016\fGm\u0016:ji\u0016lUm]:bO\u0016\u001c\bFA\u0005N\u0001")
public class TransactionLogTest
extends JUnitSuite {
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final Set<TopicPartition> topicPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)}));

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void shouldThrowExceptionWriteInvalidTxn() {
        String transactionalId = "transactionalId";
        long producerId = 23423L;
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), 0L);
        txnMetadata.addPartitions(this.topicPartitions());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TransactionLogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    @Test
    public void shouldReadWriteMessages() {
        Map pidMappings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zero"), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"one"), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"two"), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"three"), (Object)BoxesRunTime.boxToLong((long)3L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"four"), (Object)BoxesRunTime.boxToLong((long)4L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"five"), (Object)BoxesRunTime.boxToLong((long)5L))}));
        Map transactionStates = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)Empty$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)Ongoing$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)PrepareCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)CompleteCommit$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)4L)), (Object)PrepareAbort$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)5L)), (Object)CompleteAbort$.MODULE$)}));
        Seq txnRecords = ((TraversableOnce)pidMappings.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionMetadata txnMetadata;
            String transactionalId;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long producerId;
                transactionalId = (String)tuple2._1();
                txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId = tuple2._2$mcJ$sp(), this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)transactionStates.apply((Object)BoxesRunTime.boxToLong((long)producerId)), 0L);
                if (!txnMetadata.state().equals(Empty$.MODULE$)) {
                    txnMetadata.addPartitions(this.topicPartitions());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
            byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
            SimpleRecord simpleRecord = new SimpleRecord(keyBytes, valueBytes);
            return simpleRecord;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])txnRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        IntRef count = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionLogTest.$anonfun$shouldReadWriteMessages$2(this, pidMappings, transactionStates, count, record);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)pidMappings.size(), (long)count.elem);
    }

    public static final /* synthetic */ void $anonfun$shouldReadWriteMessages$2(TransactionLogTest $this, Map pidMappings$1, Map transactionStates$1, IntRef count$1, Record record) {
        TxnKey txnKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        String transactionalId = txnKey.transactionalId();
        TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)pidMappings$1.apply((Object)transactionalId)), (long)txnMetadata.producerId());
        Assert.assertEquals((long)$this.producerEpoch(), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)$this.transactionTimeoutMs(), (long)txnMetadata.txnTimeoutMs());
        Assert.assertEquals((Object)transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId())), (Object)txnMetadata.state());
        if (txnMetadata.state().equals(Empty$.MODULE$)) {
            Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)txnMetadata.topicPartitions());
        } else {
            Assert.assertEquals($this.topicPartitions(), (Object)txnMetadata.topicPartitions());
        }
        ++count$1.elem;
    }

    public TransactionLogTest() {
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 1000;
    }
}

