/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerLagIntegrationTest$;
import kafka.log.LogSegment;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001\u0002\r\u001a\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006o\u0001!\t\u0001\u000f\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\t\u0005\u0001)A\u0005{!9!\t\u0001b\u0001\n\u0003a\u0004BB\"\u0001A\u0003%Q\bC\u0004E\u0001\t\u0007I\u0011A#\t\r%\u0003\u0001\u0015!\u0003G\u0011\u001dQ\u0005A1A\u0005\u0002-Caa\u0014\u0001!\u0002\u0013a\u0005b\u0002)\u0001\u0005\u0004%\t\u0001\u0010\u0005\u0007#\u0002\u0001\u000b\u0011B\u001f\t\u000bI\u0003A\u0011I*\t\u000f\u0005\u0004!\u0019!C\u0001E\"1!\u000e\u0001Q\u0001\n\rDQa\u001b\u0001\u0005\u00021DQa\u001e\u0001\u0005\naDq!!\u0004\u0001\t\u0013\tyaB\u0004\u0002FeA\t!a\u0012\u0007\raI\u0002\u0012AA%\u0011\u00199D\u0003\"\u0001\u0002R!9\u00111\u000b\u000b\u0005\u0002\u0005U\u0003bBA5)\u0011\u0005\u0011Q\u000b\u0002\u001d\u0019><7\t\\3b]\u0016\u0014H*Y4J]R,wM]1uS>tG+Z:u\u0015\tQ2$A\u0002m_\u001eT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001qd\t\t\u0003A\u0005j\u0011!G\u0005\u0003Ee\u0011\u0011%\u00112tiJ\f7\r\u001e'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgR\u0004\"\u0001J\u0014\u000e\u0003\u0015R!AJ\u000e\u0002\u000bU$\u0018\u000e\\:\n\u0005!*#a\u0002'pO\u001eLgnZ\u0001\u0015G>l\u0007O]3tg&|gnQ8eK\u000et\u0015-\\3\u0011\u0005-\"dB\u0001\u00173!\ti\u0003'D\u0001/\u0015\tyS$\u0001\u0004=e>|GO\u0010\u0006\u0002c\u0005)1oY1mC&\u00111\u0007M\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024a\u00051A(\u001b8jiz\"\"!\u000f\u001e\u0011\u0005\u0001\u0002\u0001\"B\u0015\u0003\u0001\u0004Q\u0013!C7t!\u0016\u0014\bj\\;s+\u0005i\u0004C\u0001 @\u001b\u0005\u0001\u0014B\u0001!1\u0005\rIe\u000e^\u0001\u000b[N\u0004VM\u001d%pkJ\u0004\u0013!D2p[B\f7\r^5p]2\u000bw-\u0001\bd_6\u0004\u0018m\u0019;j_:d\u0015m\u001a\u0011\u0002\tQLW.Z\u000b\u0002\rB\u0011AeR\u0005\u0003\u0011\u0016\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0011G2,\u0017M\\3s\u0005\u0006\u001c7n\u00144g\u001bN,\u0012\u0001\u0014\t\u0003}5K!A\u0014\u0019\u0003\t1{gnZ\u0001\u0012G2,\u0017M\\3s\u0005\u0006\u001c7n\u00144g\u001bN\u0004\u0013aC:fO6,g\u000e^*ju\u0016\fAb]3h[\u0016tGoU5{K\u0002\nQaY8eK\u000e,\u0012\u0001\u0016\t\u0003+~k\u0011A\u0016\u0006\u0003/b\u000baA]3d_J$'BA-[\u0003\u0019\u0019w.\\7p]*\u0011Ad\u0017\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a-\ny1i\\7qe\u0016\u001c8/[8o)f\u0004X-A\bu_BL7\rU1si&$\u0018n\u001c8t+\u0005\u0019\u0007c\u0001 eM&\u0011Q\r\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003O\"l\u0011\u0001W\u0005\u0003Sb\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\tu_BL7\rU1si&$\u0018n\u001c8tA\u0005Y1\r\\3b]\u0016\u0014H+Z:u)\u0005i\u0007C\u0001 o\u0013\ty\u0007G\u0001\u0003V]&$\bF\u0001\tr!\t\u0011X/D\u0001t\u0015\t!X,A\u0003kk:LG/\u0003\u0002wg\n!A+Z:u\u0003-\u0011X-\u00193Ge>lGj\\4\u0015\u0007e\f)\u0001E\u0002{{~l\u0011a\u001f\u0006\u0003yB\n!bY8mY\u0016\u001cG/[8o\u0013\tq8P\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0015q\u0014\u0011A\u001f>\u0013\r\t\u0019\u0001\r\u0002\u0007)V\u0004H.\u001a\u001a\t\ri\t\u0002\u0019AA\u0004!\r\u0001\u0013\u0011B\u0005\u0004\u0003\u0017I\"a\u0001'pO\u0006IqO]5uK\u0012+\bo\u001d\u000b\r\u0003#\t9\"a\u0007\u0002 \u0005\u0005\u00121\u0005\t\u0005u\u0006Mq0C\u0002\u0002\u0016m\u00141aU3r\u0011\u0019\tIB\u0005a\u0001{\u00059a.^7LKf\u001c\bBBA\u000f%\u0001\u0007Q(A\u0004ok6$U\u000f]:\t\ri\u0011\u0002\u0019AA\u0004\u0011\u0015\u0011&\u00031\u0001U\u0011\u0019\t)C\u0005a\u0001\u0019\u0006IA/[7fgR\fW\u000e\u001d\u0015\b\u0001\u0005%\u0012QGA\u001c!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018g\u00061!/\u001e8oKJLA!a\r\u0002.\t9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA g\u00069!/\u001e8oKJ\u001c\u0018\u0002BA\"\u0003{\u0011Q\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0001\b'pO\u000ecW-\u00198fe2\u000bw-\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003AQ\u00192\u0001FA&!\rq\u0014QJ\u0005\u0004\u0003\u001f\u0002$AB!osJ+g\r\u0006\u0002\u0002H\u0005aqN\\3QCJ\fW.\u001a;feV\u0011\u0011q\u000b\t\u0007\u00033\n\u0019'a\u001a\u000e\u0005\u0005m#\u0002BA/\u0003?\nA!\u001e;jY*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002f\u0005m#AC\"pY2,7\r^5p]B\u0019a\b\u001a\u0016\u0002\u0015A\f'/Y7fi\u0016\u00148\u000fK\u0002\u0018\u0003[\u0002B!a\u001c\u0002\u0002:!\u0011\u0011OA?\u001d\u0011\t\u0019(a\u001f\u000f\t\u0005U\u0014\u0011\u0010\b\u0004[\u0005]\u0014\"\u00010\n\u0005Ql\u0016bAA g&!\u0011qPA\u001f\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u00111QAC\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0005\u0003\u007f\ni\u0004")
public class LogCleanerLagIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements Logging {
    private final String compressionCodecName;
    private final int msPerHour;
    private final int compactionLag;
    private final MockTime time;
    private final long cleanerBackOffMs;
    private final int segmentSize;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerLagIntegrationTest$.MODULE$.parameters();
    }

    public static Collection<String[]> oneParameter() {
        return LogCleanerLagIntegrationTest$.MODULE$.oneParameter();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerLagIntegrationTest logCleanerLagIntegrationTest = this;
        synchronized (logCleanerLagIntegrationTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int msPerHour() {
        return this.msPerHour;
    }

    public int compactionLag() {
        return this.compactionLag;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public long cleanerBackOffMs() {
        return this.cleanerBackOffMs;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    @Override
    public CompressionType codec() {
        return CompressionType.forName((String)this.compressionCodecName);
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$22 = this.cleanerBackOffMs();
        long x$3 = this.compactionLag();
        int x$4 = this.segmentSize();
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        int x$7 = this.makeCleaner$default$5();
        int x$8 = this.makeCleaner$default$7();
        Option<Object> x$9 = this.makeCleaner$default$9();
        Properties x$10 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$5, x$6, x$22, x$7, x$3, x$8, x$4, x$9, x$10));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        long T0 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends0 = this.writeDups(100, 3, log, this.codec(), T0);
        long startSizeBlock0 = log.size();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("total log size at T0: ").append(startSizeBlock0).toString());
        LogSegment activeSegAtT0 = log.activeSegment();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("active segment at T0 has base offset: ").append(activeSegAtT0.baseOffset()).toString());
        int sizeUpToActiveSegmentAtT0 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("log size up to base offset of active segment at T0: ").append(sizeUpToActiveSegmentAtT0).toString());
        this.cleaner().startup();
        this.time().sleep(this.compactionLag() / 2);
        Thread.sleep(5L * this.cleanerBackOffMs());
        Assert.assertEquals((String)"There should be no cleaning until the compaction lag has passed", (long)startSizeBlock0, (long)log.size());
        this.time().sleep(this.compactionLag() / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq appends1 = (Seq)appends0.$plus$plus(this.writeDups(100, 3, log, this.codec(), T1), Seq$.MODULE$.canBuildFrom());
        long firstBlock1SegmentBaseOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$11 = new TopicPartition("log", 0);
        long x$122 = activeSegAtT0.baseOffset();
        long x$13 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$11, x$122, x$13);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends1.toMap(Predef$.MODULE$.$conforms()), (Object)read1.toMap(Predef$.MODULE$.$conforms()));
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("after cleaning the compacted size up to active segment at T0: ").append(compactedSize).toString());
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstBlock1SegmentBaseOffset).append(", but lastCleaned=").append(lastCleaned).toString(), (lastCleaned >= firstBlock1SegmentBaseOffset ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(90).append("log should have been compacted: size up to offset of active segment at T0=").append(sizeUpToActiveSegmentAtT0).append(" compacted size=").append(compactedSize).toString(), (sizeUpToActiveSegmentAtT0 > compactedSize ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log, CompressionType codec, long timestamp) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerLagIntegrationTest.$anonfun$writeDups$1(this, numKeys, log, codec, timestamp, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(LogCleanerLagIntegrationTest $this, Log log$1, CompressionType codec$1, long timestamp$1, int key) {
        int count = $this.counter();
        byte[] x$1 = ((Object)BoxesRunTime.boxToInteger((int)$this.counter())).toString().getBytes();
        CompressionType x$2 = codec$1;
        byte[] x$3 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        long x$4 = timestamp$1;
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$2, x$4, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        $this.incCounter();
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(LogCleanerLagIntegrationTest $this, int numKeys$1, Log log$1, CompressionType codec$1, long timestamp$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerLagIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, timestamp$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerLagIntegrationTest(String compressionCodecName) {
        this.compressionCodecName = compressionCodecName;
        Logging.$init$((Logging)this);
        this.msPerHour = 3600000;
        this.compactionLag = 1 * this.msPerHour();
        Assert.assertTrue((String)"compactionLag must be divisible by 2 for this test", (this.compactionLag() % 2 == 0 ? 1 : 0) != 0);
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerBackOffMs = 200L;
        this.segmentSize = 512;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

