/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\f\u0019\u0001uAQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001A\u0002\u0013\u0005Q\u0006C\u00042\u0001\u0001\u0007I\u0011\u0001\u001a\t\rm\u0002\u0001\u0015)\u0003/\u0011\u001da\u0004A1A\u0005\u0002uBa!\u0011\u0001!\u0002\u0013q\u0004b\u0002\"\u0001\u0005\u0004%\ta\u0011\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002#\t\u000b!\u0003A\u0011A%\t\u000bA\u0003A\u0011A%\t\u000bU\u0003A\u0011A%\t\u000bi\u0003A\u0011A%\t\u000bq\u0003A\u0011A%\t\u000by\u0003A\u0011A%\t\u000b5\u0004A\u0011A%\t\u000b=\u0004A\u0011A%\t\u000bE\u0004A\u0011A%\t\u000bM\u0004A\u0011A%\t\u000bU\u0004A\u0011A%\t\u000b]\u0004A\u0011\u0001=\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011Q\n\u0001\u0005\u0002\u0005=#aD(gMN,G/\u00138eKb$Vm\u001d;\u000b\u0005eQ\u0012a\u00017pO*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010'\u001b\u0005\u0001#BA\u0011#\u0003\u0015QWO\\5u\u0015\t\u0019C%A\u0005tG\u0006d\u0017\r^3ti*\tQ%A\u0002pe\u001eL!a\n\u0011\u0003\u0015)+f.\u001b;Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00021\u0005\u0019\u0011\u000e\u001a=\u0016\u00039\u0002\"aK\u0018\n\u0005AB\"aC(gMN,G/\u00138eKb\fq!\u001b3y?\u0012*\u0017\u000f\u0006\u00024sA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t!QK\\5u\u0011\u001dQ4!!AA\u00029\n1\u0001\u001f\u00132\u0003\u0011IG\r\u001f\u0011\u0002\u00155\f\u00070\u00128ue&,7/F\u0001?!\t!t(\u0003\u0002Ak\t\u0019\u0011J\u001c;\u0002\u00175\f\u00070\u00128ue&,7\u000fI\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$X#\u0001#\u0011\u0005Q*\u0015B\u0001$6\u0005\u0011auN\\4\u0002\u0017\t\f7/Z(gMN,G\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002g!\u0012\u0011b\u0013\t\u0003\u0019:k\u0011!\u0014\u0006\u0003C\u0011J!aT'\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:e_^t\u0007F\u0001\u0006S!\ta5+\u0003\u0002U\u001b\n)\u0011I\u001a;fe\u0006\u0001\"/\u00198e_6dun\\6vaR+7\u000f\u001e\u0015\u0003\u0017]\u0003\"\u0001\u0014-\n\u0005ek%\u0001\u0002+fgR\f!\u0003\\8pWV\u0004X\t\u001f;sK6,7)Y:fg\"\u0012AbV\u0001\u000eCB\u0004XM\u001c3U_>l\u0015M\\=)\u000559\u0016\u0001E1qa\u0016tGmT;u\u001f\u001a|%\u000fZ3sQ\u0011qq\u000bY1\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013A\u0019\t\u0003G.l\u0011\u0001\u001a\u0006\u0003K\u001a\fa!\u001a:s_J\u001c(BA4i\u0003\u0019\u0019w.\\7p]*\u00111$\u001b\u0006\u0003U\u0012\na!\u00199bG\",\u0017B\u00017e\u0005YIeN^1mS\u0012|eMZ:fi\u0016C8-\u001a9uS>t\u0017!\u0007;fgR4U\r^2i+B\u0004XM\u001d\"pk:$wJ\u001a4tKRD#aD,\u0002\u0015Q,7\u000f\u001e*f_B,g\u000e\u000b\u0002\u0011/\u0006AAO];oG\u0006$X\r\u000b\u0002\u0012/\u0006qam\u001c:dKVsW.\u00199UKN$\bF\u0001\nX\u0003\u0015\"Xm\u001d;TC:LG/\u001f'bgR|eMZ:fi\u0016\u000bX/\u00197U_\n\u000b7/Z(gMN,G\u000f\u000b\u0002\u0014/\u0006\u0001\u0012m]:feR<&/\u001b;f\r\u0006LGn]\u000b\u0004s\u0006\rB\u0003C\u001a{\u0003\u001f\t\t\"!\u0006\t\u000bm$\u0002\u0019\u0001?\u0002\u000f5,7o]1hKB\u0019Q0!\u0003\u000f\u0007y\f)\u0001\u0005\u0002\u0000k5\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007a\u0012A\u0002\u001fs_>$h(C\u0002\u0002\bU\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004k!)A\u0006\u0006a\u0001]!1\u00111\u0003\u000bA\u0002y\naa\u001c4gg\u0016$\bbBA\f)\u0001\u0007\u0011\u0011D\u0001\u0006W2\f7o\u001d\t\u0006{\u0006m\u0011qD\u0005\u0005\u0003;\tiAA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0002\"\u0005\rB\u0002\u0001\u0003\b\u0003K!\"\u0019AA\u0014\u0005\u0005!\u0016\u0003BA\u0015\u0003_\u00012\u0001NA\u0016\u0013\r\ti#\u000e\u0002\b\u001d>$\b.\u001b8h!\r!\u0014\u0011G\u0005\u0004\u0003g)$aA!os\u0006aQn\u001c8pi>t\u0017nY*fcR1\u0011\u0011HA#\u0003\u0013\u0002R!a\u000f\u0002Byj!!!\u0010\u000b\u0007\u0005}R'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0011\u0002>\t\u00191+Z9\t\r\u0005\u001dS\u00031\u0001?\u0003\u0011\u0011\u0017m]3\t\r\u0005-S\u00031\u0001?\u0003\raWM\\\u0001\u0014]>tW\t_5ti\u0016tG\u000fV3na\u001aKG.\u001a\u000b\u0003\u0003#\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0002j_*\u0011\u00111L\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002`\u0005U#\u0001\u0002$jY\u0016\u0004")
public class OffsetIndexTest
extends JUnitSuite {
    private OffsetIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, OffsetIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        block0: {
            if (this.idx() == null) break block0;
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$1 -> x$1, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1 & Serializable & scala.Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)OffsetIndexTest.$anonfun$randomLookupTest$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p), Seq$.MODULE$.canBuildFrom()));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(offsets)).take(30))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)offset -> {
            OffsetPosition rightAnswer = offset < BoxesRunTime.unboxToLong((Object)valMap.firstKey()) ? new OffsetPosition(this.idx().baseOffset(), 0) : new OffsetPosition(valMap.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)valMap.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp());
            Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)this.idx().lookup(offset));
        });
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long offset = this.idx().baseOffset() + (long)i + 1L;
            this.idx().append(offset, i);
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OffsetPosition[]{first, second, third, fourth}))).foreach((Function1 & Serializable & scala.Serializable)offsetPosition -> {
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assert.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((long)2L, (long)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.truncate();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> idx.append((long)i, i));
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (long)0L, (long)idx.entries());
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.forceUnmap();
        this.intercept((Function0 & Serializable & scala.Serializable)() -> idx.lookup(1L), ClassTag$.MODULE$.apply(NullPointerException.class), new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            throw this.fail(message, new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, e.getClass());
            return;
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable & scala.Serializable)_ -> OffsetIndexTest.$anonfun$monotonicSeq$1(last, rand, vals, BoxesRunTime.unboxToInt((Object)_)));
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistentTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        Files.delete(file.toPath());
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ boolean $anonfun$randomLookupTest$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long logical = tuple2._1$mcJ$sp();
        int physical = tuple2._2$mcI$sp();
        Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset(), offsetPosition.position());
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int _) {
        last$1.elem += rand$1.nextInt(15) + 1;
        return vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)last$1.elem));
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

