/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import kafka.log.OffsetMapTest$;
import kafka.log.SkimpyOffsetMap;
import kafka.log.SkimpyOffsetMap$;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0007\u000f\u0001MAQA\b\u0001\u0005\u0002}AQA\t\u0001\u0005\u0002\rBQ\u0001\r\u0001\u0005\u0002\rBQA\r\u0001\u0005\u0002\rBQ\u0001\u000e\u0001\u0005\u0002UBQA\u0011\u0001\u0005\u0002\rCq!\u0015\u0001\u0012\u0002\u0013\u0005!kB\u0003^\u001d!\u0005aLB\u0003\u000e\u001d!\u0005q\fC\u0003\u001f\u0013\u0011\u0005a\rC\u0003h\u0013\u0011\u0005\u0001\u000eC\u0004z\u0013\u0005\u0005I\u0011\u0002>\u0003\u001b=3gm]3u\u001b\u0006\u0004H+Z:u\u0015\ty\u0001#A\u0002m_\u001eT\u0011!E\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001695\taC\u0003\u0002\u00181\u0005)!.\u001e8ji*\u0011\u0011DG\u0001\ng\u000e\fG.\u0019;fgRT\u0011aG\u0001\u0004_J<\u0017BA\u000f\u0017\u0005)QUK\\5u'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u00039\t1\u0003^3ti\n\u000b7/[2WC2LG-\u0019;j_:$\u0012\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0005+:LG\u000f\u000b\u0002\u0003WA\u0011AFL\u0007\u0002[)\u0011qCG\u0005\u0003_5\u0012A\u0001V3ti\u0006IA/Z:u\u00072,\u0017M\u001d\u0015\u0003\u0007-\nq\u0002^3ti\u001e+Go\u00165f]\u001a+H\u000e\u001c\u0015\u0003\t-\n1a[3z)\t1d\b\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005\u0019a.[8\u000b\u0003m\nAA[1wC&\u0011Q\b\u000f\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"\u0002\u001b\u0006\u0001\u0004y\u0004CA\u0013A\u0013\t\teE\u0001\u0003M_:<\u0017a\u0003<bY&$\u0017\r^3NCB$2\u0001R$M!\t\tS)\u0003\u0002G\u001d\ty1k[5naf|eMZ:fi6\u000b\u0007\u000fC\u0003I\r\u0001\u0007\u0011*A\u0003ji\u0016l7\u000f\u0005\u0002&\u0015&\u00111J\n\u0002\u0004\u0013:$\bbB'\u0007!\u0003\u0005\rAT\u0001\u000bY>\fGMR1di>\u0014\bCA\u0013P\u0013\t\u0001fE\u0001\u0004E_V\u0014G.Z\u0001\u0016m\u0006d\u0017\u000eZ1uK6\u000b\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005\u0019&F\u0001(UW\u0005)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003%)hn\u00195fG.,GM\u0003\u0002[M\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005q;&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006iqJ\u001a4tKRl\u0015\r\u001d+fgR\u0004\"!I\u0005\u0014\u0007%\u00017\r\u0005\u0002&C&\u0011!M\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015\"\u0017BA3'\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005q\u0016\u0001B7bS:$\"\u0001J5\t\u000b)\\\u0001\u0019A6\u0002\t\u0005\u0014xm\u001d\t\u0004K1t\u0017BA7'\u0005\u0015\t%O]1z!\tygO\u0004\u0002qiB\u0011\u0011OJ\u0007\u0002e*\u00111OE\u0001\u0007yI|w\u000e\u001e \n\u0005U4\u0013A\u0002)sK\u0012,g-\u0003\u0002xq\n11\u000b\u001e:j]\u001eT!!\u001e\u0014\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011aPO\u0001\u0005Y\u0006tw-C\u0002\u0002\u0002u\u0014aa\u00142kK\u000e$\b")
public class OffsetMapTest
extends JUnitSuite {
    public static void main(String[] stringArray) {
        OffsetMapTest$.MODULE$.main(stringArray);
    }

    @Test
    public void testBasicValidation() {
        this.validateMap(10, this.validateMap$default$2());
        this.validateMap(100, this.validateMap$default$2());
        this.validateMap(1000, this.validateMap$default$2());
        this.validateMap(5000, this.validateMap$default$2());
    }

    @Test
    public void testClear() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4000, SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Assert.assertEquals((long)i, (long)map.get(this.key(i))));
        map.clear();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Assert.assertEquals((long)map.get(this.key(i)), (long)-1L));
    }

    @Test
    public void testGetWhenFull() {
        SkimpyOffsetMap map = new SkimpyOffsetMap(4096, SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        long i = 37L;
        while (map.size() < map.slots()) {
            map.put(this.key(i), i);
            ++i;
        }
        Assert.assertEquals((long)map.get(this.key(i)), (long)-1L);
        Assert.assertEquals((long)map.get(this.key(i - 1L)), (long)(i - 1L));
    }

    public ByteBuffer key(long key) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToLong((long)key)).toString().getBytes());
    }

    public SkimpyOffsetMap validateMap(int items, double loadFactor) {
        SkimpyOffsetMap map = new SkimpyOffsetMap((int)((double)items / loadFactor * (double)24), SkimpyOffsetMap$.MODULE$.$lessinit$greater$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> map.put(this.key(i), (long)i));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), items).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Assert.assertEquals((long)map.get(this.key(i)), (long)i));
        return map;
    }

    public double validateMap$default$2() {
        return 0.5;
    }
}

