/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.token.delegation;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Properties;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.DelegationToken$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.server.CreateTokenResult;
import kafka.server.Defaults$;
import kafka.server.DelegationTokenManager;
import kafka.server.DelegationTokenManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001\u0002\u0017.\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004Q\u0001\u0001\u0006Ia\u0011\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u0019Q\u0006\u0001)A\u0005'\"91\f\u0001b\u0001\n\u0003a\u0006BB4\u0001A\u0003%Q\fC\u0004i\u0001\t\u0007I\u0011A5\t\rY\u0004\u0001\u0015!\u0003k\u0011\u001d9\bA1A\u0005\u0002aDq!a\u0001\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001\u0002\b!A\u0011\u0011\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0001\u0002\b!A\u0011Q\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0001\u0002\u001a!I\u00111\u0006\u0001A\u0002\u0013\u0005\u0011Q\u0006\u0005\t\u0003s\u0001\u0001\u0015)\u0003\u0002\u001c!I\u00111\b\u0001A\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0001\u0003\u001bB\u0001\"!\u0015\u0001A\u0003&\u0011q\b\u0005\f\u0003'\u0002\u0001\u0019!a\u0001\n\u0003\t)\u0006C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\u0002\u0005}\u0003bCA2\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/B\u0011\"!\u001a\u0001\u0001\u0004%\t!a\u001a\t\u0013\u0005U\u0004\u00011A\u0005\u0002\u0005]\u0004\u0002CA>\u0001\u0001\u0006K!!\u001b\t\u0013\u0005u\u0004\u00011A\u0005\u0002\u0005\u001d\u0001\"CA@\u0001\u0001\u0007I\u0011AAA\u0011!\t)\t\u0001Q!\n\u0005%\u0001bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u00033\u0003A\u0011IAE\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003\u0013Cq!!,\u0001\t\u0003\tI\tC\u0004\u00022\u0002!\t!!#\t\u000f\u0005U\u0006\u0001\"\u0001\u0002\n\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005%\u0005bBA_\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u0003\u0004A\u0011BAb\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003\u0013CqA!\t\u0001\t\u0013\u0011\u0019\u0003C\u0004\u0003*\u0001!IAa\u000b\t\u000f\tM\u0002\u0001\"\u0003\u00036\tQB)\u001a7fO\u0006$\u0018n\u001c8U_.,g.T1oC\u001e,'\u000fV3ti*\u0011afL\u0001\u000bI\u0016dWmZ1uS>t'B\u0001\u00192\u0003\u0015!xn[3o\u0015\t\u00114'\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005!\u0014!B6bM.\f7\u0001A\n\u0003\u0001]\u0002\"\u0001O\u001e\u000e\u0003eR!AO\u001a\u0002\u0005i\\\u0017B\u0001\u001f:\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u0010\t\u0003\u0001\u0002i\u0011!L\u0001\u0005i&lW-F\u0001D!\t!e*D\u0001F\u0015\t1u)A\u0003vi&d7O\u0003\u0002I\u0013\u000611m\\7n_:T!\u0001\u000e&\u000b\u0005-c\u0015AB1qC\u000eDWMC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u0016\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0006_^tWM]\u000b\u0002'B\u0011A\u000bW\u0007\u0002+*\u0011akV\u0001\u0005CV$\bN\u0003\u00023\u000f&\u0011\u0011,\u0016\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003\u0019ywO\\3sA\u00059!/\u001a8fo\u0016\u0014X#A/\u0011\u0007y+7+D\u0001`\u0015\t\u0001\u0017-A\u0005j[6,H/\u00192mK*\u0011!mY\u0001\u000bG>dG.Z2uS>t'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019|&\u0001\u0002'jgR\f\u0001B]3oK^,'\u000fI\u0001\u000ei>\\WM\\'b]\u0006<WM]:\u0016\u0003)\u00042a\u001b8q\u001b\u0005a'BA7b\u0003\u001diW\u000f^1cY\u0016L!a\u001c7\u0003\r\t+hMZ3s!\t\tH/D\u0001s\u0015\t\u00198'\u0001\u0004tKJ4XM]\u0005\u0003kJ\u0014a\u0003R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\u0001\u000fi>\\WM\\'b]\u0006<WM]:!\u0003%i\u0017m\u001d;fe.+\u00170F\u0001z!\tQx0D\u0001|\u0015\taX0\u0001\u0003mC:<'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(AB*ue&tw-\u0001\u0006nCN$XM]&fs\u0002\nA#\\1y\u0019&4W\rV5nK6\u001bH)\u001a4bk2$XCAA\u0005!\u0011\tY!!\u0004\u000e\u0003\rL1!a\u0004d\u0005\u0011auN\\4\u0002+5\f\u0007\u0010T5gKRKW.Z't\t\u00164\u0017-\u001e7uA\u0005\u0011\"/\u001a8foRKW.Z't\t\u00164\u0017-\u001e7u\u0003M\u0011XM\\3x)&lW-T:EK\u001a\fW\u000f\u001c;!\u0003)!xn[3o\u0007\u0006\u001c\u0007.Z\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005j]R,'O\\1mg*\u0019a&!\n\u000b\u0005A:\u0016\u0002BA\u0015\u0003?\u0011A\u0003R3mK\u001e\fG/[8o)>\\WM\\\"bG\",\u0017A\u0004;pW\u0016t7)Y2iK~#S-\u001d\u000b\u0005\u0003_\t)\u0004\u0005\u0003\u0002\f\u0005E\u0012bAA\u001aG\n!QK\\5u\u0011%\t9$EA\u0001\u0002\u0004\tY\"A\u0002yIE\n1\u0002^8lK:\u001c\u0015m\u00195fA\u0005)\u0001O]8qgV\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI?\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\u001d:paN|F%Z9\u0015\t\u0005=\u0012q\n\u0005\n\u0003o!\u0012\u0011!a\u0001\u0003\u007f\ta\u0001\u001d:paN\u0004\u0013!E2sK\u0006$X\rV8lK:\u0014Vm];miV\u0011\u0011q\u000b\t\u0004c\u0006e\u0013bAA.e\n\t2I]3bi\u0016$vn[3o%\u0016\u001cX\u000f\u001c;\u0002+\r\u0014X-\u0019;f)>\\WM\u001c*fgVdGo\u0018\u0013fcR!\u0011qFA1\u0011%\t9dFA\u0001\u0002\u0004\t9&\u0001\nde\u0016\fG/\u001a+pW\u0016t'+Z:vYR\u0004\u0013!B3se>\u0014XCAA5!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8\u000f\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002t\u00055$AB#se>\u00148/A\u0005feJ|'o\u0018\u0013fcR!\u0011qFA=\u0011%\t9DGA\u0001\u0002\u0004\tI'\u0001\u0004feJ|'\u000fI\u0001\u0010Kb\u0004\u0018N]=US6,7\u000b^1na\u0006\u0019R\r\u001f9jef$\u0016.\\3Ti\u0006l\u0007o\u0018\u0013fcR!\u0011qFAB\u0011%\t9$HA\u0001\u0002\u0004\tI!\u0001\tfqBL'/\u001f+j[\u0016\u001cF/Y7qA\u0005)1/\u001a;VaR\u0011\u0011q\u0006\u0015\u0004?\u00055\u0005\u0003BAH\u0003+k!!!%\u000b\u0007\u0005ME*A\u0003kk:LG/\u0003\u0003\u0002\u0018\u0006E%A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\u0001\u0013Q\u0014\t\u0005\u0003\u001f\u000by*\u0003\u0003\u0002\"\u0006E%!B!gi\u0016\u0014\u0018\u0001\f;fgR$vn[3o%\u0016\fX/Z:ug^KG\u000f\u001b#fY\u0016<\u0017\r^5p]R{7.\u001a8ESN\f'\r\\3eQ\r\t\u0013q\u0015\t\u0005\u0003\u001f\u000bI+\u0003\u0003\u0002,\u0006E%\u0001\u0002+fgR\fq\u0002^3ti\u000e\u0013X-\u0019;f)>\\WM\u001c\u0015\u0004E\u0005\u001d\u0016A\u0004;fgR\u0014VM\\3x)>\\WM\u001c\u0015\u0004G\u0005\u001d\u0016a\u0004;fgR,\u0005\u0010]5sKR{7.\u001a8)\u0007\u0011\n9+A\nuKN$(+Z7pm\u0016$vn[3o\u00116\f7\rK\u0002&\u0003O\u000b\u0011\u0003^3ti\u0012+7o\u0019:jE\u0016$vn[3oQ\r1\u0013qU\u0001\nO\u0016$Hk\\6f]N$B\"!2\u0002d\u0006\u001d\u0018Q\u001fB\n\u0005/\u0001b!a2\u0002X\u0006mg\u0002BAe\u0003'tA!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0004\u0003\u001f,\u0014A\u0002\u001fs_>$h(C\u0001e\u0013\r\t)nY\u0001\ba\u0006\u001c7.Y4f\u0013\r1\u0017\u0011\u001c\u0006\u0004\u0003+\u001c\u0007\u0003BAo\u0003?l!!a\t\n\t\u0005\u0005\u00181\u0005\u0002\u0010\t\u0016dWmZ1uS>tGk\\6f]\"1\u0011Q]\u0014A\u0002A\fA\u0002^8lK:l\u0015M\\1hKJDq!!;(\u0001\u0004\tY/A\ntS6\u0004H.Z!dY\u0006+H\u000f[8sSj,'\u000f\u0005\u0003\u0002n\u0006EXBAAx\u0015\t1\u0016'\u0003\u0003\u0002t\u0006=(aE*j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014\bbBA|O\u0001\u0007\u0011\u0011`\u0001\fQ>\u001cHoU3tg&|g\u000e\u0005\u0003\u0002|\n5a\u0002BA\u007f\u0005\u000fqA!a@\u0003\u00049!\u00111\u001aB\u0001\u0013\u0005!\u0014b\u0001B\u0003g\u00059a.\u001a;x_J\\\u0017\u0002\u0002B\u0005\u0005\u0017\taBU3rk\u0016\u001cHo\u00115b]:,GNC\u0002\u0003\u0006MJAAa\u0004\u0003\u0012\t91+Z:tS>t'\u0002\u0002B\u0005\u0005\u0017AaA!\u0006(\u0001\u0004\u0019\u0016\u0001\u0005:fcV,7\u000f\u001e)sS:\u001c\u0017\u000e]1m\u0011\u001d\u0011Ib\na\u0001\u00057\tqB]3rk\u0016\u001cH/\u001a3Po:,'o\u001d\t\u0006\u0003\u000f\f9nU\u0001\u0018i\u0016\u001cH\u000fU3sS>$\u0017n\u0019+pW\u0016tW\t\u001f9jefD3\u0001KAT\u0003e\u0019'/Z1uKR{7.\u001a8SKN,H\u000e^\"bY2\u0014\u0015mY6\u0015\t\u0005=\"Q\u0005\u0005\b\u0005OI\u0003\u0019AA,\u0003\r\u0011X\r^\u0001\u0016e\u0016tWm\u001e*fgB|gn]3DC2d'-Y2l)\u0019\tyC!\f\u00030!9!q\u0005\u0016A\u0002\u0005%\u0004b\u0002B\u0019U\u0001\u0007\u0011\u0011B\u0001\ni&lWm\u0015;b[B\fAd\u0019:fCR,G)\u001a7fO\u0006$\u0018n\u001c8U_.,g.T1oC\u001e,'\u000fF\u0005q\u0005o\u0011\tEa\u0011\u0003L!9!\u0011H\u0016A\u0002\tm\u0012AB2p]\u001aLw\rE\u0002r\u0005{I1Aa\u0010s\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\u0005]1\u00061\u0001\u0002\u001c!1\u0011i\u000ba\u0001\u0005\u000b\u00022\u0001\u0012B$\u0013\r\u0011I%\u0012\u0002\u0005)&lW\rC\u0004\u0003N-\u0002\rAa\u0014\u0002\u0011i\\7\t\\5f]R\u00042\u0001\u000fB)\u0013\r\u0011\u0019&\u000f\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;")
public class DelegationTokenManagerTest
extends ZooKeeperTestHarness {
    private final MockTime time = new MockTime();
    private final KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner");
    private final List<KafkaPrincipal> renewer = new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:renewer1"), (List)Nil$.MODULE$);
    private final Buffer<DelegationTokenManager> tokenManagers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String masterKey;
    private final long maxLifeTimeMsDefault = Defaults$.MODULE$.DelegationTokenMaxLifeTimeMsDefault();
    private final long renewTimeMsDefault = Defaults$.MODULE$.DelegationTokenExpiryTimeMsDefault();
    private DelegationTokenCache tokenCache = null;
    private Properties props = null;
    private CreateTokenResult createTokenResult;
    private Errors error = Errors.NONE;
    private long expiryTimeStamp = 0L;

    public MockTime time() {
        return this.time;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public List<KafkaPrincipal> renewer() {
        return this.renewer;
    }

    public Buffer<DelegationTokenManager> tokenManagers() {
        return this.tokenManagers;
    }

    public String masterKey() {
        return this.masterKey;
    }

    public long maxLifeTimeMsDefault() {
        return this.maxLifeTimeMsDefault;
    }

    public long renewTimeMsDefault() {
        return this.renewTimeMsDefault;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public void props_$eq(Properties x$1) {
        this.props = x$1;
    }

    public CreateTokenResult createTokenResult() {
        return this.createTokenResult;
    }

    public void createTokenResult_$eq(CreateTokenResult x$1) {
        this.createTokenResult = x$1;
    }

    public Errors error() {
        return this.error;
    }

    public void error_$eq(Errors x$1) {
        this.error = x$1;
    }

    public long expiryTimeStamp() {
        return this.expiryTimeStamp;
    }

    public void expiryTimeStamp_$eq(long x$1) {
        this.expiryTimeStamp = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        int x$1 = 0;
        String x$2 = this.zkConnect();
        boolean x$3 = true;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$18 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        this.props_$eq(TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$3));
        this.props().put(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp(), ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(ScramMechanism.mechanismNames()).asScala()).mkString(","));
        this.props().put(KafkaConfig$.MODULE$.DelegationTokenMasterKeyProp(), this.masterKey());
        this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
    }

    @Override
    @After
    public void tearDown() {
        this.tokenManagers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testTokenRequestsWithDelegationTokenDisabled() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.createTokenResult().error());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.createTokenResult().hmac())), "scala.Predef.byteArrayOps(scala.Array.apply[Byte]()((ClassTag.Byte: scala.reflect.ClassTag[Byte]))).sameElements[Byte](scala.Predef.wrapByteArray(DelegationTokenManagerTest.this.createTokenResult.hmac))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
    }

    @Test
    public void testCreateToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        Option token = tokenManager.getToken(tokenId);
        Assert.assertTrue((!token.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(password)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(((DelegationToken)token.get()).hmac())));
    }

    @Test
    public void testRenewToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        long maxLifeTime = issueTime + this.maxLifeTimeMsDefault();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), maxLifeTime, tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.renewToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + this.renewTimeMsDefault();
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(86400000L);
        expectedExpiryStamp = this.time().milliseconds() + 3600000L;
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 3600000L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(3600000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 691200000L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)maxLifeTime, (long)this.expiryTimeStamp());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(691200000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)this.error());
    }

    @Test
    public void testExpireToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.expireToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + 0x6DDD00L;
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), 0x6DDD00L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        this.time().sleep(3600000L);
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Option $org_scalatest_assert_macro_left = tokenManager.getToken(tokenId);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        Assert.assertEquals((long)this.time().milliseconds(), (long)this.expiryTimeStamp());
    }

    @Test
    public void testRemoveTokenHmac() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.masterKey());
        Assert.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable & scala.Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        String encodedHmac = Base64.getEncoder().encodeToString(password);
        String tokenInformation = tokenManager.tokenCache().tokenIdForHmac(encodedHmac);
        Assert.assertNull((Object)tokenInformation);
        Option $org_scalatest_assert_macro_left = tokenManager.getToken(tokenId);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
    }

    @Test
    public void testDescribeToken() {
        List<DelegationToken> tokens;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        KafkaPrincipal owner1 = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        KafkaPrincipal owner2 = SecurityUtils.parseKafkaPrincipal((String)"User:owner2");
        KafkaPrincipal owner3 = SecurityUtils.parseKafkaPrincipal((String)"User:owner3");
        KafkaPrincipal owner4 = SecurityUtils.parseKafkaPrincipal((String)"User:owner4");
        KafkaPrincipal renewer1 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer1");
        KafkaPrincipal renewer2 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer2");
        KafkaPrincipal renewer3 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer3");
        KafkaPrincipal renewer4 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer4");
        SimpleAclAuthorizer simpleAclAuthorizer = new SimpleAclAuthorizer();
        simpleAclAuthorizer.configure(config.originals());
        RequestChannel.Session hostSession = new RequestChannel.Session(owner1, InetAddress.getByName("192.168.1.1"));
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(owner1, (List)new .colon.colon((Object)renewer1, (List)new .colon.colon((Object)renewer2, (List)Nil$.MODULE$)), 3600000L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(owner2, (List)new .colon.colon((Object)renewer3, (List)Nil$.MODULE$), 3600000L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        String tokenId2 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner3, (List)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$), 0x6DDD00L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        String tokenId3 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner4, (List)new .colon.colon((Object)owner1, (List)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$)), 0x6DDD00L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        List $org_scalatest_assert_macro_left = tokenManager.getAllTokenInformation();
        int $org_scalatest_assert_macro_right = 4;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        List<DelegationToken> $org_scalatest_assert_macro_left2 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)new .colon.colon((Object)SecurityUtils.parseKafkaPrincipal((String)"User:unknown"), (List)Nil$.MODULE$));
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        List<DelegationToken> $org_scalatest_assert_macro_left3 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)Nil$.MODULE$);
        int $org_scalatest_assert_macro_right3 = 0;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        List<DelegationToken> $org_scalatest_assert_macro_left4 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)new .colon.colon((Object)owner1, (List)Nil$.MODULE$));
        int $org_scalatest_assert_macro_right4 = 2;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        List<DelegationToken> $org_scalatest_assert_macro_left5 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, null);
        int $org_scalatest_assert_macro_right5 = 2;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        List<DelegationToken> $org_scalatest_assert_macro_left6 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, SecurityUtils.parseKafkaPrincipal((String)"User:unknown"), null);
        int $org_scalatest_assert_macro_right6 = 0;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        List<DelegationToken> $org_scalatest_assert_macro_left7 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)new .colon.colon((Object)owner1, (List)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$)));
        int $org_scalatest_assert_macro_right7 = 2;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        Acl acl = new Acl(owner1, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        simpleAclAuthorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), new Resource((ResourceType)DelegationToken$.MODULE$, tokenId3, PatternType.LITERAL));
        List<DelegationToken> $org_scalatest_assert_macro_left8 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)new .colon.colon((Object)owner1, (List)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$)));
        int $org_scalatest_assert_macro_right8 = 3;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left8, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        List<DelegationToken> $org_scalatest_assert_macro_left9 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, renewer4, (List<KafkaPrincipal>)new .colon.colon((Object)renewer4, (List)Nil$.MODULE$));
        int $org_scalatest_assert_macro_right9 = 2;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left9, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        List<DelegationToken> $org_scalatest_assert_macro_left10 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)new .colon.colon((Object)renewer2, (List)new .colon.colon((Object)renewer3, (List)Nil$.MODULE$)));
        int $org_scalatest_assert_macro_right10 = 1;
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left10, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        hostSession = new RequestChannel.Session(renewer2, InetAddress.getByName("192.168.1.1"));
        acl = new Acl(renewer2, (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$);
        simpleAclAuthorizer.addAcls((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl})), new Resource((ResourceType)DelegationToken$.MODULE$, tokenId2, PatternType.LITERAL));
        List<DelegationToken> $org_scalatest_assert_macro_left11 = tokens = this.getTokens(tokenManager, simpleAclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)new .colon.colon((Object)renewer2, (List)new .colon.colon((Object)renewer3, (List)Nil$.MODULE$)));
        int $org_scalatest_assert_macro_right11 = 2;
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool($org_scalatest_assert_macro_left11, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        simpleAclAuthorizer.close();
    }

    private List<DelegationToken> getTokens(DelegationTokenManager tokenManager, SimpleAclAuthorizer simpleAclAuthorizer, RequestChannel.Session hostSession, KafkaPrincipal requestPrincipal, List<KafkaPrincipal> requestedOwners) {
        return requestedOwners != null && requestedOwners.isEmpty() ? Nil$.MODULE$ : tokenManager.getTokens((Function1 & Serializable & scala.Serializable)token -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenManagerTest.eligible$1(token, requestPrincipal, requestedOwners, simpleAclAuthorizer, hostSession)));
    }

    @Test
    public void testPeriodicTokenExpiry() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1 & Serializable & scala.Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        List $org_scalatest_assert_macro_left = tokenManager.getAllTokenInformation();
        int $org_scalatest_assert_macro_right = 4;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.time().sleep(0x6DDD00L);
        tokenManager.expireTokens();
        List $org_scalatest_assert_macro_left2 = tokenManager.getAllTokenInformation();
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DelegationTokenManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
    }

    private void createTokenResultCallBack(CreateTokenResult ret) {
        this.createTokenResult_$eq(ret);
    }

    private void renewResponseCallback(Errors ret, long timeStamp) {
        this.error_$eq(ret);
        this.expiryTimeStamp_$eq(timeStamp);
    }

    private DelegationTokenManager createDelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, tokenCache, time, zkClient);
        this.tokenManagers().$plus$eq((Object)tokenManager);
        return tokenManager;
    }

    private static final boolean authorizeToken$1(String tokenId, SimpleAclAuthorizer simpleAclAuthorizer$1, RequestChannel.Session hostSession$1) {
        return simpleAclAuthorizer$1.authorize(hostSession$1, (Operation)Describe$.MODULE$, new Resource((ResourceType)DelegationToken$.MODULE$, tokenId, PatternType.LITERAL));
    }

    private static final boolean eligible$1(TokenInformation token, KafkaPrincipal requestPrincipal$1, List requestedOwners$1, SimpleAclAuthorizer simpleAclAuthorizer$1, RequestChannel.Session hostSession$1) {
        return DelegationTokenManager$.MODULE$.filterToken(requestPrincipal$1, Option$.MODULE$.apply((Object)requestedOwners$1), token, (Function1 & Serializable & scala.Serializable)tokenId -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenManagerTest.authorizeToken$1(tokenId, simpleAclAuthorizer$1, hostSession$1)));
    }

    public DelegationTokenManagerTest() {
        this.masterKey = "masterKey";
    }
}

