/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogAppendInfo;
import kafka.message.CompressionCodec;
import kafka.message.NoCompressionCodec$;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.AbstractFetcherThreadTest$MockFetcherThread$;
import kafka.server.FetcherMetrics$;
import kafka.server.Fetching$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\r]g\u0001\u0002+V\u0001iCQ!\u0019\u0001\u0005\u0002\tDQ!\u001a\u0001\u0005\u0002\u0019DQa\u001d\u0001\u0005\nQDq!!\u0004\u0001\t\u0013\ty\u0001C\u0004\u0002L\u0001!I!!\u0014\t\r\u0005m\u0003\u0001\"\u0001g\u0011\u0019\t)\u0007\u0001C\u0001M\"1\u0011\u0011\u000e\u0001\u0005\u0002\u0019Da!!\u001c\u0001\t\u00031\u0007BBA9\u0001\u0011\u0005a\r\u0003\u0004\u0002v\u0001!\tA\u001a\u0005\u0007\u0003s\u0002A\u0011\u00014\t\r\u0005u\u0004\u0001\"\u0001g\u0011\u0019\t\t\t\u0001C\u0001M\"1\u0011Q\u0011\u0001\u0005\u0002\u0019Da!!#\u0001\t\u00031\u0007BBAG\u0001\u0011\u0005a\r\u0003\u0004\u0002\u0012\u0002!\tA\u001a\u0005\u0007\u0003+\u0003A\u0011\u00014\t\r\u0005e\u0005\u0001\"\u0001g\u0011\u0019\ti\n\u0001C\u0001M\"1\u0011\u0011\u0015\u0001\u0005\u0002\u0019Da!!*\u0001\t\u00031\u0007BBAU\u0001\u0011\u0005a\rC\u0004\u0002.\u0002!I!a,\t\r\u0005U\u0006\u0001\"\u0001g\u0011\u0019\tI\f\u0001C\u0001M\u001e9\u0011Q\u0018\u0001\t\u0002\u0005}faBAb\u0001!\u0005\u0011Q\u0019\u0005\u0007Cv!\t!a2\u0007\r\u0005%W\u0004AAf\u0011)\tim\bBA\u0002\u0013\u0005\u0011q\u001a\u0005\u000b\u0003;|\"\u00111A\u0005\u0002\u0005}\u0007BCAs?\t\u0005\t\u0015)\u0003\u0002R\"Q\u00111G\u0010\u0003\u0002\u0004%\t!a:\t\u0015\u0005%xD!a\u0001\n\u0003\tY\u000f\u0003\u0006\u0002p~\u0011\t\u0011)Q\u0005\u0003kA!\"!= \u0005\u0003\u0007I\u0011AAz\u0011)\t)p\bBA\u0002\u0013\u0005\u0011q\u001f\u0005\u000b\u0003w|\"\u0011!Q!\n\u0005-\u0002BCA\u007f?\t\u0005\r\u0011\"\u0001\u0002t\"Q\u0011q`\u0010\u0003\u0002\u0004%\tA!\u0001\t\u0015\t\u0015qD!A!B\u0013\tY\u0003\u0003\u0006\u0003\b}\u0011\t\u0019!C\u0001\u0003gD!B!\u0003 \u0005\u0003\u0007I\u0011\u0001B\u0006\u0011)\u0011ya\bB\u0001B\u0003&\u00111\u0006\u0005\u0007C~!\tA!\u0005\b\u000f\t\u0005R\u0004#\u0001\u0003$\u00199\u0011\u0011Z\u000f\t\u0002\t\u0015\u0002BB12\t\u0003\u00119\u0003C\u0004\u0003*E\"\tAa\u000b\t\u000f\t%\u0012\u0007\"\u0001\u0003F!I!\u0011J\u000f\u0012\u0002\u0013\u0005!1\n\u0005\n\u0005Cj\u0012\u0013!C\u0001\u0005\u00172a!a1\u0001\u0001\t\r\u0004B\u0003B6o\t\u0015\r\u0011\"\u0001\u0002h\"Q!QN\u001c\u0003\u0002\u0003\u0006I!!\u000e\t\u0015\t=tG!b\u0001\n\u0003\t9\u000f\u0003\u0006\u0003r]\u0012\t\u0011)A\u0005\u0003kAa!Y\u001c\u0005\u0002\tM\u0004\"\u0003B>o\t\u0007I\u0011\u0002B?\u0011!\u0011\tj\u000eQ\u0001\n\t}\u0004\"\u0003BJo\t\u0007I\u0011\u0002B?\u0011!\u0011)j\u000eQ\u0001\n\t}\u0004b\u0002BLo\u0011\u0005!\u0011\u0014\u0005\b\u0005G;D\u0011\u0001BS\u0011\u001d\u0011Yk\u000eC\u0001\u0005[CqA!-8\t\u0003\u0011\u0019\fC\u0004\u00038^\"\tE!/\t\u000f\tmw\u0007\"\u0011\u0003^\"9!1^\u001c\u0005B\t5\bb\u0002B{o\u0011\u0005#q\u001f\u0005\b\u0007g9D\u0011IB\u001b\u0011\u001d\tip\u000eC!\u0007wAqaa\u00108\t\u0003\u001a\t\u0005C\u0004\u0004L]\"Ia!\u0014\t\u000f\r\u0005u\u0007\"\u0003\u0004\u0004\"91qS\u001c\u0005B\re\u0005bBBRo\u0011E3Q\u0015\u0005\b\u0007[;D\u0011IBX\u0011\u001d\u0019il\u000eC\u0005\u0007\u007fCqaa28\t#\u001aI\rC\u0004\u0004P^\"\tf!5\u00033\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bIR+7\u000f\u001e\u0006\u0003-^\u000baa]3sm\u0016\u0014(\"\u0001-\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0019\u0007C\u00013\u0001\u001b\u0005)\u0016aE2mK\u0006tW*\u001a;sS\u000e\u0014VmZ5tiJLH#A4\u0011\u0005qC\u0017BA5^\u0005\u0011)f.\u001b;)\u0005\tY\u0007C\u00017r\u001b\u0005i'B\u00018p\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0018aA8sO&\u0011!/\u001c\u0002\u0007\u0005\u00164wN]3\u0002\u001f\u0005dG.T3ue&\u001c7OT1nKN,\u0012!\u001e\t\u0004mf\\X\"A<\u000b\u0005al\u0016AC2pY2,7\r^5p]&\u0011!p\u001e\u0002\u0004'\u0016$\bc\u0001?\u0002\b9\u0019Q0a\u0001\u0011\u0005ylV\"A@\u000b\u0007\u0005\u0005\u0011,\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000bi\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\n\u0005-!AB*ue&twMC\u0002\u0002\u0006u\u000bq!\\6CCR\u001c\u0007\u000e\u0006\u0005\u0002\u0012\u0005\u001d\u0012\u0011GA\u001e!\u0011\t\u0019\"a\t\u000e\u0005\u0005U!\u0002BA\f\u00033\taA]3d_J$'\u0002BA\u000e\u0003;\taaY8n[>t'b\u0001-\u0002 )\u0019\u0011\u0011E8\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t)#!\u0006\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\b\u0003S!\u0001\u0019AA\u0016\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\t\u00049\u00065\u0012bAA\u0018;\n!Aj\u001c8h\u0011\u001d\t\u0019\u0004\u0002a\u0001\u0003k\t1\u0002\\3bI\u0016\u0014X\t]8dQB\u0019A,a\u000e\n\u0007\u0005eRLA\u0002J]RDq!!\u0010\u0005\u0001\u0004\ty$A\u0004sK\u000e|'\u000fZ:\u0011\u000bq\u000b\t%!\u0012\n\u0007\u0005\rSL\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002B!a\u0005\u0002H%!\u0011\u0011JA\u000b\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u00039ygMZ:fi\u0006sG-\u00129pG\"$b!a\u0014\u0002V\u0005e\u0003c\u00013\u0002R%\u0019\u00111K+\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\"9\u0011qK\u0003A\u0002\u0005-\u0012a\u00034fi\u000eDwJ\u001a4tKRDq!a\r\u0006\u0001\u0004\t)$\u0001\u000fuKN$X*\u001a;sS\u000e\u001c(+Z7pm\u0016$wJ\\*ikR$wn\u001e8)\u0007\u0019\ty\u0006E\u0002m\u0003CJ1!a\u0019n\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f^\"p]N,X.\u001a:MC\u001e\u0014V-\\8wK\u0012<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\"\u001aq!a\u0018\u0002\u001fQ,7\u000f^*j[BdWMR3uG\"D3\u0001CA0\u0003Q!Xm\u001d;GK:\u001cW\r\u001a+sk:\u001c\u0017\r^5p]\"\u001a\u0011\"a\u0018\u0002\u001fQ,7\u000f\u001e$f]\u000e,GMR3uG\"D3ACA0\u0003\t\"Xm\u001d;V].twn\u001e8MK\u0006$WM]#q_\u000eD\u0017J\u001c+sk:\u001c\u0017\r^5p]\"\u001a1\"a\u0018\u0002GQ,7\u000f^+oW:|wO\u001c'fC\u0012,'/\u00129pG\"<\u0006.\u001b7f\r\u0016$8\r[5oO\"\u001aA\"a\u0018\u0002\u001dQ,7\u000f\u001e+sk:\u001c\u0017\r^5p]\"\u001aQ\"a\u0018\u0002wQ,7\u000f\u001e+sk:\u001c\u0017\r^3U_\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0013\u001adU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;O_R\u001cV\u000f\u001d9peR,G\rK\u0002\u000f\u0003?\n\u0001\b^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0017J\u001a'fC\u0012,'/\u00129pG\"LeNZ8O_R\fe/Y5mC\ndW\rK\u0002\u0010\u0003?\n\u0011\u0007^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\G)\u001e:j]\u001e\u0014V-\\8wKB\u000b'\u000f^5uS>t7\u000fK\u0002\u0011\u0003?\nA\u0005^3tiR\u0013XO\\2bi&|gnU6jaB,G-\u00134O_\u0016\u0003xn\u00195DQ\u0006tw-\u001a\u0015\u0004#\u0005}\u0013a\b;fgR4u\u000e\u001c7po\u0016\u0014h)\u001a;dQ>+Ho\u00144SC:<W\rS5hQ\"\u001a!#a\u0018\u0002IQ,7\u000f\u001e$f]\u000e,Gm\u00144gg\u0016$(+Z:fi\u00063G/\u001a:PkR|eMU1oO\u0016D3aEA0\u0003y!Xm\u001d;G_2dwn^3s\r\u0016$8\r[(vi>3'+\u00198hK2{w\u000fK\u0002\u0015\u0003?\n1\u0007^3tiJ+GO]=BMR,'/\u00168l]><h\u000eT3bI\u0016\u0014X\t]8dQ&sG*\u0019;fgR|eMZ:fi\u001a+Go\u00195)\u0007U\ty&\u0001\nuKN$8i\u001c:skB$X*Z:tC\u001e,\u0007f\u0001\f\u0002`\u00051D/Z:u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115b]\u001e,G)\u001e:j]\u001e4UM\\2fI\u001a+Go\u00195Fa>\u001c\u0007n\u001d$s_6dU-\u00193fe\"\u001aq#a\u0018\u0002uQ,7\u000f\u001e'fC\u0012,'/\u00129pG\"\u001c\u0005.\u00198hK\u0012+(/\u001b8h'V\u001c7-Z:tMVdg)\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u0014\bf\u0001\r\u0002`\u0005\u0001D/Z:u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115b]\u001e,G)\u001e:j]\u001e4U\r^2i\u000bB|7\r[:Ge>lG*Z1eKJ$2aZAY\u0011\u001d\t\u0019,\u0007a\u0001\u0003k\t1\u0003\\3bI\u0016\u0014X\t]8dQ>sG*Z1eKJ\f1\u0007^3tiR\u0013XO\\2bi\u0016$v.\u00129pG\",e\u000eZ(gMN,Go\u001d#ve&twMU3n_Z,\u0007+\u0019:uSRLwN\\:)\u0007i\ty&A(uKN$HK];oG\u0006$\u0018n\u001c8UQJ|wo]#yG\u0016\u0004H/[8o\u0013\u001adU-\u00193feJ+G/\u001e:ogB\u000b'\u000f^5uS>t7OT8u%\u0016\fX/Z:uK\u0012LeNR3uG\",\u0005o\\2ig\"\u001a1$a\u0018\u0002#5{7m\u001b$fi\u000eDWM\u001d+ie\u0016\fG\rE\u0002\u0002Bvi\u0011\u0001\u0001\u0002\u0012\u001b>\u001c7NR3uG\",'\u000f\u00165sK\u0006$7CA\u000f\\)\t\tyL\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\u0014\u0005}Y\u0016a\u00017pOV\u0011\u0011\u0011\u001b\t\u0007\u0003'\fI.!\u0005\u000e\u0005\u0005U'bAAlo\u00069Q.\u001e;bE2,\u0017\u0002BAn\u0003+\u0014aAQ;gM\u0016\u0014\u0018a\u00027pO~#S-\u001d\u000b\u0004O\u0006\u0005\b\"CArC\u0005\u0005\t\u0019AAi\u0003\rAH%M\u0001\u0005Y><\u0007%\u0006\u0002\u00026\u0005yA.Z1eKJ,\u0005o\\2i?\u0012*\u0017\u000fF\u0002h\u0003[D\u0011\"a9%\u0003\u0003\u0005\r!!\u000e\u0002\u00191,\u0017\rZ3s\u000bB|7\r\u001b\u0011\u0002\u001d1|wm\u0015;beR|eMZ:fiV\u0011\u00111F\u0001\u0013Y><7\u000b^1si>3gm]3u?\u0012*\u0017\u000fF\u0002h\u0003sD\u0011\"a9(\u0003\u0003\u0005\r!a\u000b\u0002\u001f1|wm\u0015;beR|eMZ:fi\u0002\nA\u0002\\8h\u000b:$wJ\u001a4tKR\f\u0001\u0003\\8h\u000b:$wJ\u001a4tKR|F%Z9\u0015\u0007\u001d\u0014\u0019\u0001C\u0005\u0002d*\n\t\u00111\u0001\u0002,\u0005iAn\\4F]\u0012|eMZ:fi\u0002\nQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0017!\u00055jO\"<\u0016\r^3s[\u0006\u00148n\u0018\u0013fcR\u0019qM!\u0004\t\u0013\u0005\rX&!AA\u0002\u0005-\u0012A\u00045jO\"<\u0016\r^3s[\u0006\u00148\u000e\t\u000b\r\u0005'\u00119B!\u0007\u0003\u001c\tu!q\u0004\t\u0004\u0005+yR\"A\u000f\t\u000f\u00055w\u00061\u0001\u0002R\"9\u00111G\u0018A\u0002\u0005U\u0002bBAy_\u0001\u0007\u00111\u0006\u0005\b\u0003{|\u0003\u0019AA\u0016\u0011\u001d\u00119a\fa\u0001\u0003W\ta\u0002U1si&$\u0018n\u001c8Ti\u0006$X\rE\u0002\u0003\u0016E\u001a\"!M.\u0015\u0005\t\r\u0012!B1qa2LH\u0003\u0003B\n\u0005[\u0011\tEa\u0011\t\u000f\u000557\u00071\u0001\u00030A1!\u0011\u0007B\u001e\u0003#qAAa\r\u000389\u0019aP!\u000e\n\u0003yK1A!\u000f^\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0010\u0003@\t\u00191+Z9\u000b\u0007\teR\fC\u0004\u00024M\u0002\r!!\u000e\t\u000f\t\u001d1\u00071\u0001\u0002,Q!!1\u0003B$\u0011\u001d\t\u0019\u0004\u000ea\u0001\u0003k\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTC\u0001B'U\u0011\t)Da\u0014,\u0005\tE\u0003\u0003\u0002B*\u0005;j!A!\u0016\u000b\t\t]#\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0017^\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005?\u0012)FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u00124cA\u001c\u0003fA\u0019AMa\u001a\n\u0007\t%TKA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\u0013I,\u0007\u000f\\5dC&#\u0017A\u0003:fa2L7-Y%eA\u0005AA.Z1eKJLE-A\u0005mK\u0006$WM]%eAQ1!Q\u000fB<\u0005s\u00022!!18\u0011%\u0011Y\u0007\u0010I\u0001\u0002\u0004\t)\u0004C\u0005\u0003pq\u0002\n\u00111\u0001\u00026\u00051\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,7/\u0006\u0002\u0003\u0000AA\u00111\u001bBA\u0005\u000b\u0013i)\u0003\u0003\u0003\u0004\u0006U'aA'baB!!q\u0011BE\u001b\t\tI\"\u0003\u0003\u0003\f\u0006e!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004\u0005\u001f{bbAAa9\u00059\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,7\u000fI\u0001\u0016Y\u0016\fG-\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3t\u0003YaW-\u00193feB\u000b'\u000f^5uS>t7\u000b^1uKN\u0004\u0013AD:fi2+\u0017\rZ3s'R\fG/\u001a\u000b\u0006O\nm%q\u0014\u0005\b\u0005;\u000b\u0005\u0019\u0001BC\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DqA!)B\u0001\u0004\u0011i)A\u0003ti\u0006$X-A\btKR\u0014V\r\u001d7jG\u0006\u001cF/\u0019;f)\u00159'q\u0015BU\u0011\u001d\u0011iJ\u0011a\u0001\u0005\u000bCqA!)C\u0001\u0004\u0011i)A\u000bsKBd\u0017nY1QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\t\t5%q\u0016\u0005\b\u0005;\u001b\u0005\u0019\u0001BC\u0003QaW-\u00193feB\u000b'\u000f^5uS>t7\u000b^1uKR!!Q\u0012B[\u0011\u001d\u0011i\n\u0012a\u0001\u0005\u000b\u000bA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003\u0003B^\u0005\u0017\u0014iMa4\u0011\u000bq\u0013iL!1\n\u0007\t}VL\u0001\u0004PaRLwN\u001c\t\u0005\u0005\u0007\u00149-\u0004\u0002\u0003F*\u0019\u0011QZ,\n\t\t%'Q\u0019\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\tuU\t1\u0001\u0003\u0006\"9\u0011qK#A\u0002\u0005-\u0002b\u0002Bi\u000b\u0002\u0007!1[\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\tU'q[\u0007\u0002o%!!\u0011\u001cB4\u0005%1U\r^2i\t\u0006$\u0018-\u0001\u0005ueVt7-\u0019;f)\u00159'q\u001cBq\u0011\u001d\u0011iJ\u0012a\u0001\u0005\u000bCqAa9G\u0001\u0004\u0011)/A\bueVt7-\u0019;j_:\u001cF/\u0019;f!\r!'q]\u0005\u0004\u0005S,&!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$Ra\u001aBx\u0005cDqA!(H\u0001\u0004\u0011)\tC\u0004\u0003t\u001e\u0003\r!a\u000b\u0002\r=4gm]3u\u0003)\u0011W/\u001b7e\r\u0016$8\r\u001b\u000b\u0005\u0005s\u001c)\u0003\u0005\u0004\u0003|\u000e%1q\u0002\b\u0005\u0005{\u001c)A\u0004\u0003\u0003\u0000\u000e\rab\u0001@\u0004\u0002%\t\u0001,\u0003\u0002W/&\u00191qA+\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&!11BB\u0007\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og*\u00191qA+\u0011\u000bq\u0013il!\u0005\u0011\t\rM1q\u0004\b\u0005\u0007+\u0019Y\"\u0004\u0002\u0004\u0018)!1\u0011DA\r\u0003!\u0011X-];fgR\u001c\u0018\u0002BB\u000f\u0007/\tABR3uG\"\u0014V-];fgRLAa!\t\u0004$\t9!)^5mI\u0016\u0014(\u0002BB\u000f\u0007/Aqaa\nI\u0001\u0004\u0019I#\u0001\u0007qCJ$\u0018\u000e^5p]6\u000b\u0007\u000fE\u0004w\u0007W\u0011)i!\f\n\u0007\t\ru\u000fE\u0002e\u0007_I1a!\rV\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\t\r]2\u0011\b\t\u00069\nu\u0016Q\u0007\u0005\b\u0005;K\u0005\u0019\u0001BC)\u0011\tYc!\u0010\t\u000f\tu%\n1\u0001\u0003\u0006\u0006\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\r\r3QIB$!\u0015a&QXA(\u0011\u001d\u0011ij\u0013a\u0001\u0005\u000bCqa!\u0013L\u0001\u0004\t)$A\u0003fa>\u001c\u0007.\u0001\rdQ\u0016\u001c7.\u0012=qK\u000e$X\r\u001a'fC\u0012,'/\u00129pG\"$baa\u0014\u0004^\ru\u0004#\u0002/\u0003>\u000eE\u0003\u0003BB*\u00073j!a!\u0016\u000b\t\r]\u0013\u0011D\u0001\taJ|Go\\2pY&!11LB+\u0005\u0019)%O]8sg\"91q\f'A\u0002\r\u0005\u0014\u0001E3ya\u0016\u001cG/\u001a3Fa>\u001c\u0007n\u00149u!\u0019\u0019\u0019g!\u001c\u0004r5\u00111Q\r\u0006\u0005\u0007O\u001aI'\u0001\u0003vi&d'BAB6\u0003\u0011Q\u0017M^1\n\t\r=4Q\r\u0002\t\u001fB$\u0018n\u001c8bYB!11OB=\u001b\t\u0019)H\u0003\u0003\u0004x\r%\u0014\u0001\u00027b]\u001eLAaa\u001f\u0004v\t9\u0011J\u001c;fO\u0016\u0014\bbBB@\u0019\u0002\u0007!QR\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0003]awn\\6va\u0016sGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0004\u0006\u000e-5Q\u0013\t\u0005\u0007+\u00199)\u0003\u0003\u0004\n\u000e]!AD#q_\u000eDWI\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0007\u001bk\u0005\u0019ABH\u0003%)\u0007o\\2i\t\u0006$\u0018\r\u0005\u0003\u0003V\u000eE\u0015\u0002BBJ\u0005O\u0012\u0011\"\u00129pG\"$\u0015\r^1\t\u000f\r}T\n1\u0001\u0003\u000e\u0006!b-\u001a;dQ\u0016\u0003xn\u00195F]\u0012|eMZ:fiN$Baa'\u0004\u001eB9aoa\u000b\u0003\u0006\u000e\u0015\u0005bBBP\u001d\u0002\u00071\u0011U\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bc\u0002<\u0004,\t\u00155qR\u0001 SN|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQN+\b\u000f]8si\u0016$WCABT!\ra6\u0011V\u0005\u0004\u0007Wk&a\u0002\"p_2,\u0017M\\\u0001\u0010M\u0016$8\r\u001b$s_6dU-\u00193feR!1\u0011WB]!\u0019\u0011\tDa\u000f\u00044B9Al!.\u0003\u0006\nM\u0017bAB\\;\n1A+\u001e9mKJBqaa/Q\u0001\u0004\u0019\t\"\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH/\u0001\rdQ\u0016\u001c7\u000eT3bI\u0016\u0014X\t]8dQ\u0006sG\r\u00165s_^$RaZBa\u0007\u000bDqaa1R\u0001\u0004\t)$A\u0007fqB,7\r^3e\u000bB|7\r\u001b\u0005\b\u0007\u007f\n\u0006\u0019\u0001BG\u0003u1W\r^2i\u000b\u0006\u0014H.[3ti>3gm]3u\rJ|W\u000eT3bI\u0016\u0014HCBA\u0016\u0007\u0017\u001ci\rC\u0004\u0003\u001eJ\u0003\rA!\"\t\u000f\u0005M\"\u000b1\u0001\u00026\u0005Yb-\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;Ge>lG*Z1eKJ$b!a\u000b\u0004T\u000eU\u0007b\u0002BO'\u0002\u0007!Q\u0011\u0005\b\u0003g\u0019\u0006\u0019AA\u001b\u0001")
public class AbstractFetcherThreadTest {
    private volatile AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread$module;

    public AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread() {
        if (this.MockFetcherThread$module == null) {
            this.MockFetcherThread$lzycompute$1();
        }
        return this.MockFetcherThread$module;
    }

    @Before
    public void cleanMetricRegistry() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)metricName -> {
            AbstractFetcherThreadTest.$anonfun$cleanMetricRegistry$1(metricName);
            return BoxedUnit.UNIT;
        });
    }

    private Set<String> allMetricsNames() {
        return (Set)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Set$.MODULE$.canBuildFrom());
    }

    private RecordBatch mkBatch(long baseOffset, int leaderEpoch, Seq<SimpleRecord> records) {
        return (RecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(MemoryRecords.withRecords((long)baseOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(leaderEpoch), (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))).batches()).asScala()).head();
    }

    public OffsetAndEpoch kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    @Test
    public void testMetricsRemovedOnShutdown() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.start();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<String> set = this.allMetricsNames();
            GenTraversable genTraversable = Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FetcherMetrics$.MODULE$.BytesPerSec(), FetcherMetrics$.MODULE$.RequestsPerSec(), FetcherMetrics$.MODULE$.ConsumerLag()}));
            return !(set != null ? !set.equals((Object)genTraversable) : genTraversable != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed waiting for all fetcher metrics to be registered", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        fetcher.shutdown();
        Assert.assertTrue((boolean)Metrics.defaultRegistry().allMetrics().isEmpty());
    }

    @Test
    public void testConsumerLagRemovedWithPartition() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.doWork();
        Assert.assertTrue((String)"Failed waiting for consumer lag metric", (boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assert.assertFalse((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
    }

    @Test
    public void testSimpleFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)2L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testFencedFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(0);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testUnknownLeaderEpochInTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.state()));
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.state()));
    }

    @Test
    public void testUnknownLeaderEpochWhileFetching() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1))})));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())}))}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.state()));
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(0);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.state()));
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(1);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.state()));
    }

    @Test
    public void testTruncation() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            fetcher.doWork();
            Buffer<RecordBatch> buffer = fetcher.replicaPartitionState(partition).log();
            Buffer<RecordBatch> buffer2 = fetcher.leaderPartitionState(partition).log();
            return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to reconcile leader and follower logs", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochRequestNotSupported() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$1, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public boolean isOffsetForLeaderEpochSupported() {
                return false;
            }
            {
                this.highWatermark$1 = highWatermark$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochInfoNotAvailable() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$2, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.highWatermark$2 = highWatermark$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    @Test
    public void testTruncateToHighWatermarkDuringRemovePartitions() {
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, partition){
            private final TopicPartition partition$2;

            public void truncateToHighWatermark(Set<TopicPartition> partitions) {
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$2})));
                super.truncateToHighWatermark(partitions);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.partition$2 = partition$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)((RecordBatch)replicaLog.last()).nextOffset(), (long)replicaState.logEndOffset());
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testTruncationSkippedIfNoEpochChange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        MockFetcherThread fetcher = new MockFetcherThread(this, truncations){
            private final IntRef truncations$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$1 = truncations$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(5);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 5))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)1L, (long)truncations.elem);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5))})));
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)truncations.elem);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testFollowerFetchOutOfRangeHigh() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 4))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.state()));
        leaderState.log().clear();
        leaderState.logEndOffset_$eq(0L);
        leaderState.logStartOffset_$eq(0L);
        leaderState.highWatermark_$eq(0L);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
    }

    @Test
    public void testFencedOffsetResetAfterOutOfRange() {
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef fetchedEarliestOffset = BooleanRef.create((boolean)false);
        MockFetcherThread fetcher = new MockFetcherThread(this, fetchedEarliestOffset){
            private final BooleanRef fetchedEarliestOffset$1;

            public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }
            {
                this.fetchedEarliestOffset$1 = fetchedEarliestOffset$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 4))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertTrue((boolean)fetchedEarliestOffset.elem);
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    @Test
    public void testFollowerFetchOutOfRangeLow() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.state()));
        Assert.assertEquals((long)2L, (long)replicaState.logStartOffset());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            fetcher.doWork();
            Buffer<RecordBatch> buffer = fetcher.replicaPartitionState(partition).log();
            Buffer<RecordBatch> buffer2 = fetcher.leaderPartitionState(partition).log();
            return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to reconcile leader and follower logs", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testRetryAfterUnknownLeaderEpochInLatestOffsetFetch() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private final AtomicInteger tries;

            private AtomicInteger tries() {
                return this.tries;
            }

            public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries().getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchLatestOffsetFromLeader(topicPartition, leaderEpoch);
            }
            {
                this.tries = new AtomicInteger(0);
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.state()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            fetcher.doWork();
            Buffer<RecordBatch> buffer = fetcher.replicaPartitionState(partition).log();
            Buffer<RecordBatch> buffer2 = fetcher.leaderPartitionState(partition).log();
            return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to reconcile leader and follower logs", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    @Test
    public void testCorruptMessage() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private boolean fetchedOnce;

            public boolean fetchedOnce() {
                return this.fetchedOnce;
            }

            public void fetchedOnce_$eq(boolean x$1) {
                this.fetchedOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
                void var2_2;
                block0: {
                    Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchedData = super.fetchFromLeader(fetchRequest);
                    if (this.fetchedOnce()) break block0;
                    MemoryRecords records = (MemoryRecords)((FetchResponse.PartitionData)((Tuple2)fetchedData.head())._2()).records;
                    ByteBuffer buffer = records.buffer();
                    buffer.putInt(15, buffer.getInt(15) ^ 0x5B7E);
                    buffer.putInt(30, buffer.getInt(30) ^ 0x16C3A);
                    this.fetchedOnce_$eq(true);
                }
                return var2_2;
            }
            {
                this.fetchedOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testLeaderEpochChangeDuringFencedFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(1);
    }

    @Test
    public void testLeaderEpochChangeDuringSuccessfulFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(0);
    }

    private void testLeaderEpochChangeDuringFetchEpochsFromLeader(int leaderEpochOnLeader) {
        TopicPartition partition = new TopicPartition("topic", 0);
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockFetcherThread fetcher = new MockFetcherThread(this, partition, nextLeaderEpochOnFollower){
            private boolean fetchEpochsFromLeaderOnce;
            private final /* synthetic */ AbstractFetcherThreadTest $outer;
            private final TopicPartition partition$5;
            private final int nextLeaderEpochOnFollower$1;

            public boolean fetchEpochsFromLeaderOnce() {
                return this.fetchEpochsFromLeaderOnce;
            }

            public void fetchEpochsFromLeaderOnce_$eq(boolean x$1) {
                this.fetchEpochsFromLeaderOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                void var2_2;
                block0: {
                    Map<TopicPartition, EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                    if (this.fetchEpochsFromLeaderOnce()) break block0;
                    this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$5})));
                    this.setReplicaState(this.partition$5, this.$outer.MockFetcherThread().PartitionState().apply(this.nextLeaderEpochOnFollower$1));
                    this.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition$5), (Object)this.$outer.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, this.nextLeaderEpochOnFollower$1))})));
                    this.fetchEpochsFromLeaderOnce_$eq(true);
                }
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$5 = partition$5;
                this.nextLeaderEpochOnFollower$1 = nextLeaderEpochOnFollower$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
                this.fetchEpochsFromLeaderOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, initialLeaderEpochOnFollower))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.state()));
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nextLeaderEpochOnFollower)), (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.currentLeaderEpoch())));
        if (leaderEpochOnLeader < nextLeaderEpochOnFollower) {
            fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L));
        }
        fetcher.doWork();
        Assert.assertEquals(fetcher.leaderPartitionState(partition).log(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncateToEpochEndOffsetsDuringRemovePartitions() {
        TopicPartition partition = new TopicPartition("topic", 0);
        int leaderEpochOnLeader = 0;
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockFetcherThread fetcher = new MockFetcherThread(this, partition, nextLeaderEpochOnFollower){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;
            private final TopicPartition partition$6;
            private final int nextLeaderEpochOnFollower$2;

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                void var2_2;
                Map<TopicPartition, EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$6})));
                this.setReplicaState(this.partition$6, this.$outer.MockFetcherThread().PartitionState().apply(this.nextLeaderEpochOnFollower$2));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$6 = partition$6;
                this.nextLeaderEpochOnFollower$2 = nextLeaderEpochOnFollower$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(initialLeaderEpochOnFollower));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, initialLeaderEpochOnFollower))})));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.state()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(partition).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.currentLeaderEpoch())));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L));
        fetcher.doWork();
        Assert.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), fetcher.replicaPartitionState(partition).log());
    }

    @Test
    public void testTruncationThrowsExceptionIfLeaderReturnsPartitionsNotRequestedInFetchEpochs() {
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                TopicPartition unrequestedTp = new TopicPartition("topic2", 0);
                return super.fetchEpochEndOffsets(partitions).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unrequestedTp), (Object)new EpochEndOffset(0, 0L)));
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0))})));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fetcher.doWork(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("AbstractFetcherThreadTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 720));
    }

    private final void MockFetcherThread$lzycompute$1() {
        AbstractFetcherThreadTest abstractFetcherThreadTest = this;
        synchronized (abstractFetcherThreadTest) {
            if (this.MockFetcherThread$module == null) {
                this.MockFetcherThread$module = new AbstractFetcherThreadTest$MockFetcherThread$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$cleanMetricRegistry$1(MetricName metricName) {
        Metrics.defaultRegistry().removeMetric(metricName);
    }

    public class MockFetcherThread
    extends AbstractFetcherThread {
        private final int replicaId;
        private final int leaderId;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates;
        public final /* synthetic */ AbstractFetcherThreadTest $outer;

        public int replicaId() {
            return this.replicaId;
        }

        public int leaderId() {
            return this.leaderId;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
            return this.replicaPartitionStates;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates() {
            return this.leaderPartitionStates;
        }

        public void setLeaderState(TopicPartition topicPartition, PartitionState state) {
            this.leaderPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
            this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public PartitionState replicaPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
            });
        }

        public PartitionState leaderPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.leaderPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
            });
        }

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            if (fetchOffset != state.logEndOffset()) {
                throw new RuntimeException(new StringBuilder(32).append("Offset mismatch for partition ").append(topicPartition).append(": ").append(new StringBuilder(37).append("fetched offset = ").append(fetchOffset).append(", log end offset = ").append(state.logEndOffset()).append(".").toString()).toString());
            }
            Iterable batches = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((Records)partitionData.records).batches()).asScala();
            LongRef maxTimestamp = LongRef.create((long)-1L);
            LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
            LongRef lastOffset = LongRef.create((long)state.logEndOffset());
            batches.foreach((Function1 & Serializable & scala.Serializable)batch -> {
                MockFetcherThread.$anonfun$processPartitionData$1(maxTimestamp, offsetOfMaxTimestamp, state, lastOffset, batch);
                return BoxedUnit.UNIT;
            });
            state.logStartOffset_$eq(partitionData.logStartOffset);
            state.highWatermark_$eq(partitionData.highWatermark);
            return new Some((Object)new LogAppendInfo((Option)new Some((Object)BoxesRunTime.boxToLong((long)fetchOffset)), lastOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordConversionStats.EMPTY, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, batches.size(), partitionData.records.sizeInBytes(), true, BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.lastOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))));
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
            state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$17))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> state.logStartOffset())));
            state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log().clear();
            state.logStartOffset_$eq(offset);
            state.logEndOffset_$eq(offset);
            state.highWatermark_$eq(offset);
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            scala.collection.mutable.Map fetchData = Map$.MODULE$.empty();
            partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    PartitionFetchState state = (PartitionFetchState)tuple2._2();
                    if (state.isReadyForFetch()) {
                        PartitionState replicaState = this.replicaPartitionState(partition);
                        boxedUnit = fetchData.put((Object)partition, (Object)new FetchRequest.PartitionData(state.fetchOffset(), replicaState.logStartOffset(), 0x100000, Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch()))));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            FetchRequest.Builder fetchRequest = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)1, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(fetchData).asJava()));
            return new AbstractFetcherThread.ResultWithPartitions((Object)new Some((Object)fetchRequest), Set$.MODULE$.empty());
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            return state.log().lastOption().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.partitionLeaderEpoch())).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToInteger((int)-1)));
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return this.replicaPartitionState(topicPartition).logEndOffset();
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            OffsetsForLeaderEpochRequest.PartitionData epochData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), epoch);
            EpochEndOffset result = this.lookupEndOffsetForEpoch(epochData, this.replicaPartitionState(topicPartition));
            return result.endOffset() == -1L ? None$.MODULE$ : new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
        }

        private Option<Errors> checkExpectedLeaderEpoch(Optional<Integer> expectedEpochOpt, PartitionState partitionState) {
            Integer expectedEpoch;
            return expectedEpochOpt.isPresent() ? (Predef$.MODULE$.Integer2int(expectedEpoch = expectedEpochOpt.get()) < partitionState.leaderEpoch() ? new Some((Object)Errors.FENCED_LEADER_EPOCH) : (Predef$.MODULE$.Integer2int(expectedEpoch) > partitionState.leaderEpoch() ? new Some((Object)Errors.UNKNOWN_LEADER_EPOCH) : None$.MODULE$)) : None$.MODULE$;
        }

        private EpochEndOffset lookupEndOffsetForEpoch(OffsetsForLeaderEpochRequest.PartitionData epochData, PartitionState partitionState) {
            EpochEndOffset epochEndOffset;
            Object object = new Object();
            try {
                this.checkExpectedLeaderEpoch(epochData.currentLeaderEpoch, partitionState).foreach((Function1 & Serializable & scala.Serializable)error -> {
                    throw new NonLocalReturnControl(object, (Object)new EpochEndOffset(error, -1, -1L));
                });
                IntRef epochLowerBound = IntRef.create((int)-1);
                partitionState.log().foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    MockFetcherThread.$anonfun$lookupEndOffsetForEpoch$2(epochData, object, epochLowerBound, batch);
                    return BoxedUnit.UNIT;
                });
                epochEndOffset = new EpochEndOffset(Errors.NONE, -1, -1L);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    epochEndOffset = (EpochEndOffset)ex.value();
                }
                throw ex;
            }
            return epochEndOffset;
        }

        /*
         * WARNING - void declaration
         */
        public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
            void var2_2;
            scala.collection.mutable.Map endOffsets = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition partition = (TopicPartition)tuple2._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple2._2();
                PartitionState leaderState = this.leaderPartitionState(partition);
                EpochEndOffset epochEndOffset = this.lookupEndOffsetForEpoch(epochData, leaderState);
                Option option = endOffsets.put((Object)partition, (Object)epochEndOffset);
                return option;
            });
            return var2_2;
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return true;
        }

        public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
            return ((scala.collection.mutable.MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchRequest.fetchData()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                PartitionState leaderState;
                TopicPartition partition;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null) {
                    Tuple2 tuple23;
                    Tuple2 tuple24;
                    partition = (TopicPartition)tuple22._1();
                    FetchRequest.PartitionData fetchData = (FetchRequest.PartitionData)tuple22._2();
                    leaderState = this.leaderPartitionState(partition);
                    Option<Errors> epochCheckError = this.checkExpectedLeaderEpoch(fetchData.currentLeaderEpoch, leaderState);
                    if (epochCheckError.isDefined()) {
                        tuple24 = new Tuple2(epochCheckError.get(), (Object)MemoryRecords.EMPTY);
                    } else if (fetchData.fetchOffset > leaderState.logEndOffset() || fetchData.fetchOffset < leaderState.logStartOffset()) {
                        tuple24 = new Tuple2((Object)Errors.OFFSET_OUT_OF_RANGE, (Object)MemoryRecords.EMPTY);
                    } else {
                        MemoryRecords memoryRecords;
                        Option option = leaderState.log().find((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$fetchFromLeader$2(fetchData, x$19)));
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RecordBatch batch = (RecordBatch)some.value();
                            ByteBuffer buffer = ByteBuffer.allocate(batch.sizeInBytes());
                            batch.writeTo(buffer);
                            buffer.flip();
                            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                        } else if (None$.MODULE$.equals(option)) {
                            memoryRecords = MemoryRecords.EMPTY;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        MemoryRecords records = memoryRecords;
                        tuple24 = tuple23 = new Tuple2((Object)Errors.NONE, (Object)records);
                    }
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    Errors error = (Errors)tuple23._1();
                    MemoryRecords records = (MemoryRecords)tuple23._2();
                    tuple2 = new Tuple2((Object)error, (Object)records);
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple25 = tuple2;
                Errors error = (Errors)tuple25._1();
                MemoryRecords records = (MemoryRecords)tuple25._2();
                Tuple2 tuple26 = new Tuple2((Object)partition, (Object)new FetchResponse.PartitionData(error, leaderState.highWatermark(), leaderState.highWatermark(), leaderState.logStartOffset(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava(), (BaseRecords)records));
                return tuple26;
            }, Map$.MODULE$.canBuildFrom())).toSeq();
        }

        private void checkLeaderEpochAndThrow(int expectedEpoch, PartitionState partitionState) {
            this.checkExpectedLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(expectedEpoch)), partitionState).foreach((Function1 & Serializable & scala.Serializable)error -> {
                throw error.exception();
            });
        }

        public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logStartOffset();
        }

        public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logEndOffset();
        }

        public /* synthetic */ AbstractFetcherThreadTest kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$processPartitionData$1(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, PartitionState state$1, LongRef lastOffset$1, RecordBatch batch) {
            batch.ensureValid();
            if (batch.maxTimestamp() > maxTimestamp$1.elem) {
                maxTimestamp$1.elem = batch.maxTimestamp();
                offsetOfMaxTimestamp$1.elem = batch.baseOffset();
            }
            state$1.log().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}));
            state$1.logEndOffset_$eq(batch.nextOffset());
            lastOffset$1.elem = batch.lastOffset();
        }

        public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
            return batch.lastOffset() < truncationState$1.offset();
        }

        public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$17) {
            return x$17.lastOffset() + 1L;
        }

        public static final /* synthetic */ void $anonfun$lookupEndOffsetForEpoch$2(OffsetsForLeaderEpochRequest.PartitionData epochData$1, Object nonLocalReturnKey1$1, IntRef epochLowerBound$1, RecordBatch batch) {
            if (batch.partitionLeaderEpoch() > epochData$1.leaderEpoch) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new EpochEndOffset(Errors.NONE, epochLowerBound$1.elem, batch.baseOffset()));
            }
            epochLowerBound$1.elem = batch.partitionLeaderEpoch();
        }

        public static final /* synthetic */ boolean $anonfun$fetchFromLeader$2(FetchRequest.PartitionData fetchData$2, RecordBatch x$19) {
            return x$19.baseOffset() >= fetchData$2.fetchOffset;
        }

        public MockFetcherThread(AbstractFetcherThreadTest $outer, int replicaId, int leaderId) {
            this.replicaId = replicaId;
            this.leaderId = leaderId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("mock-fetcher", "mock-fetcher", new BrokerEndPoint(leaderId, "localhost", Random$.MODULE$.nextInt()), AbstractFetcherThread$.MODULE$.$lessinit$greater$default$4(), AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5());
            this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.leaderPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        }

        public class PartitionState {
            private Buffer<RecordBatch> log;
            private int leaderEpoch;
            private long logStartOffset;
            private long logEndOffset;
            private long highWatermark;
            public final /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ $outer;

            public Buffer<RecordBatch> log() {
                return this.log;
            }

            public void log_$eq(Buffer<RecordBatch> x$1) {
                this.log = x$1;
            }

            public int leaderEpoch() {
                return this.leaderEpoch;
            }

            public void leaderEpoch_$eq(int x$1) {
                this.leaderEpoch = x$1;
            }

            public long logStartOffset() {
                return this.logStartOffset;
            }

            public void logStartOffset_$eq(long x$1) {
                this.logStartOffset = x$1;
            }

            public long logEndOffset() {
                return this.logEndOffset;
            }

            public void logEndOffset_$eq(long x$1) {
                this.logEndOffset = x$1;
            }

            public long highWatermark() {
                return this.highWatermark;
            }

            public void highWatermark_$eq(long x$1) {
                this.highWatermark = x$1;
            }

            public /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ kafka$server$AbstractFetcherThreadTest$MockFetcherThread$PartitionState$$$outer() {
                return this.$outer;
            }

            public PartitionState(AbstractFetcherThreadTest$MockFetcherThread$ $outer, Buffer<RecordBatch> log, int leaderEpoch, long logStartOffset, long logEndOffset, long highWatermark) {
                this.log = log;
                this.leaderEpoch = leaderEpoch;
                this.logStartOffset = logStartOffset;
                this.logEndOffset = logEndOffset;
                this.highWatermark = highWatermark;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
    }
}

