/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001Q4A\u0001D\u0007\u0001%!)q\u0003\u0001C\u00011!9!\u0004\u0001b\u0001\n\u0003Z\u0002B\u0002\u0012\u0001A\u0003%A\u0004C\u0004$\u0001\t\u0007I\u0011I\u000e\t\r\u0011\u0002\u0001\u0015!\u0003\u001d\u0011\u001d)\u0003A1A\u0005\u0002\u0019Baa\f\u0001!\u0002\u00139\u0003\"\u0002\u0019\u0001\t\u0003\t\u0004\"\u0002 \u0001\t\u0003\t\u0004\"\u0002!\u0001\t\u0013\t\u0005b\u00025\u0001#\u0003%I!\u001b\u0002\u001f\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d*fcV,7\u000f\u001e+fgRT!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\u000b\u000e\u00035I!AF\u0007\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\r\u0011\u0005Q\u0001\u0011a\u00037pO\u0012K'oQ8v]R,\u0012\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0004\u0013:$\u0018\u0001\u00047pO\u0012K'oQ8v]R\u0004\u0013A\u00038v[\n\u0013xn[3sg\u0006Ya.^7Ce>\\WM]:!\u0003\u0015!x\u000e]5d+\u00059\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0011a\u0017M\\4\u000b\u00031\nAA[1wC&\u0011a&\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003y!Xm\u001d;BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148OU3rk\u0016\u001cH\u000fF\u00013!\ti2'\u0003\u00025=\t!QK\\5uQ\tAa\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005)!.\u001e8ji*\t1(A\u0002pe\u001eL!!\u0010\u001d\u0003\tQ+7\u000f^\u0001(i\u0016\u001cH/\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeN\u0014V-];fgR,%O]8s\u0007>$W\r\u000b\u0002\nm\u0005q2/\u001a8e\u00032$XM\u001d*fa2L7-\u0019'pO\u0012K'o\u001d*fcV,7\u000f\u001e\u000b\u0004\u00056\u0003\u0007CA\"L\u001b\u0005!%BA#G\u0003!\u0011X-];fgR\u001c(BA$I\u0003\u0019\u0019w.\\7p]*\u0011\u0001#\u0013\u0006\u0003\u0015j\na!\u00199bG\",\u0017B\u0001'E\u0005m\tE\u000e^3s%\u0016\u0004H.[2b\u0019><G)\u001b:t%\u0016\u001c\bo\u001c8tK\")aJ\u0003a\u0001\u001f\u0006i\u0001/\u0019:uSRLwN\u001c#jeN\u0004B\u0001U,[=:\u0011\u0011+\u0016\t\u0003%zi\u0011a\u0015\u0006\u0003)F\ta\u0001\u0010:p_Rt\u0014B\u0001,\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0004\u001b\u0006\u0004(B\u0001,\u001f!\tYF,D\u0001G\u0013\tifI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005A{\u0016B\u0001\u0018Z\u0011\u001d\t'\u0002%AA\u0002\t\fAb]8dW\u0016$8+\u001a:wKJ\u0004\"a\u00194\u000e\u0003\u0011T!!Z\b\u0002\u000f9,Go^8sW&\u0011q\r\u001a\u0002\r'>\u001c7.\u001a;TKJ4XM]\u0001)g\u0016tG-\u00117uKJ\u0014V\r\u001d7jG\u0006dun\u001a#jeN\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0002U*\u0012!m[\u0016\u0002YB\u0011QN]\u0007\u0002]*\u0011q\u000e]\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001d\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002t]\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class AlterReplicaLogDirsRequestTest
extends BaseRequestTest {
    private final int logDirCount;
    private final int numBrokers;
    private final String topic;

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    public int numBrokers() {
        return this.numBrokers;
    }

    public String topic() {
        return this.topic;
    }

    @Test
    public void testAlterReplicaLogDirsRequest() {
        int partitionNum = 5;
        String logDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs1 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir1), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1, this.sendAlterReplicaLogDirsRequest$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, alterReplicaLogDirsResponse1.responses().get(tp));
            LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$1 = tp;
            boolean x$2 = qual$1.getLog$default$2();
            Assert.assertTrue((boolean)qual$1.getLog(x$1, x$2).isEmpty());
        });
        this.createTopic(this.topic(), partitionNum, 1, this.createTopic$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$3 = new TopicPartition(this.topic(), partition);
            boolean x$4 = qual$2.getLog$default$2();
            Assert.assertEquals((Object)logDir1, (Object)((Log)qual$2.getLog(x$3, x$4).get()).dir().getParent());
        });
        String logDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(Random$.MODULE$.nextInt(this.logDirCount()))).getAbsolutePath();
        Map partitionDirs2 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)partition))), (Object)logDir2), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AlterReplicaLogDirsResponse alterReplicaLogDirsResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2, this.sendAlterReplicaLogDirsRequest$default$2());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionNum).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            Assert.assertEquals((Object)Errors.NONE, alterReplicaLogDirsResponse2.responses().get(tp));
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                String string = logDir2;
                LogManager qual$3 = ((KafkaServer)this.servers().head()).logManager();
                TopicPartition x$5 = new TopicPartition(this.topic(), partition);
                boolean x$6 = qual$3.getLog$default$2();
                String string2 = ((Log)qual$3.getLog(x$5, x$6).get()).dir().getParent();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "timed out waiting for replica movement", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        });
    }

    @Test
    public void testAlterReplicaLogDirsRequestErrorCode() {
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        String validDir1 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(1)).getAbsolutePath();
        String validDir2 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(2)).getAbsolutePath();
        String validDir3 = new File((String)((KafkaServer)this.servers().head()).config().logDirs().apply(3)).getAbsolutePath();
        scala.collection.mutable.Map partitionDirs1 = Map$.MODULE$.empty();
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs1.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir1);
        AlterReplicaLogDirsResponse alterReplicaDirResponse1 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs1.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse1.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, alterReplicaDirResponse1.responses().get(new TopicPartition(this.topic(), 1)));
        this.createTopic(this.topic(), 3, 1, this.createTopic$default$4());
        scala.collection.mutable.Map partitionDirs2 = Map$.MODULE$.empty();
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs2.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir2);
        AlterReplicaLogDirsResponse alterReplicaDirResponse2 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs2.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse2.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.NONE, alterReplicaDirResponse2.responses().get(new TopicPartition(this.topic(), 1)));
        ((KafkaServer)this.servers().head()).logDirFailureChannel().maybeAddOfflineLogDir(offlineDir, (Function0 & Serializable & scala.Serializable)() -> "", new IOException());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !((KafkaServer)this.servers().head()).logManager().isLogDirOnline(offlineDir), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("timed out waiting for ").append(offlineDir).append(" to be offline").toString(), 3000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        scala.collection.mutable.Map partitionDirs3 = Map$.MODULE$.empty();
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 0), (Object)"invalidDir");
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 1), (Object)validDir3);
        partitionDirs3.put((Object)new TopicPartition(this.topic(), 2), (Object)offlineDir);
        AlterReplicaLogDirsResponse alterReplicaDirResponse3 = this.sendAlterReplicaLogDirsRequest((Map<TopicPartition, String>)partitionDirs3.toMap(Predef$.MODULE$.$conforms()), this.sendAlterReplicaLogDirsRequest$default$2());
        Assert.assertEquals((Object)Errors.LOG_DIR_NOT_FOUND, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 0)));
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 1)));
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, alterReplicaDirResponse3.responses().get(new TopicPartition(this.topic(), 2)));
    }

    private AlterReplicaLogDirsResponse sendAlterReplicaLogDirsRequest(Map<TopicPartition, String> partitionDirs, SocketServer socketServer) {
        AlterReplicaLogDirsRequest request = (AlterReplicaLogDirsRequest)new AlterReplicaLogDirsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitionDirs).asJava()).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.ALTER_REPLICA_LOG_DIRS, socketServer, this.connectAndSend$default$4(), this.connectAndSend$default$5());
        return AlterReplicaLogDirsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private SocketServer sendAlterReplicaLogDirsRequest$default$2() {
        return this.controllerSocketServer();
    }

    public AlterReplicaLogDirsRequestTest() {
        this.logDirCount = 5;
        this.numBrokers = 1;
        this.topic = "topic";
    }
}

