/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfig;
import kafka.server.DynamicConfigManager;
import kafka.server.DynamicConfigManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Quota;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\u0002\u0019BQ\u0001\u000e\u0001\u0005\u0002UBQa\u0011\u0001\u0005\u0002UBQ!\u0012\u0001\u0005\n\u0019CQA\u0017\u0001\u0005\u0002UBQ\u0001\u0018\u0001\u0005\u0002UBQA\u0018\u0001\u0005\u0002UBQ\u0001\u0019\u0001\u0005\u0002UBQA\u0019\u0001\u0005\u0002UBQ\u0001\u001a\u0001\u0005\u0002UBQA\u001a\u0001\u0005\u0002UBQ\u0001\u001b\u0001\u0005\u0002UBQA\u001b\u0001\u0005\u0002UBQ\u0001\u001c\u0001\u0005\u0002UBQA\u001c\u0001\u0005\u0002UBQ\u0001\u001d\u0001\u0005\u0002UBQA\u001d\u0001\u0005\u0002UBQ\u0001\u001e\u0001\u0005\u0002U\u0014q\u0003R=oC6L7mQ8oM&<7\t[1oO\u0016$Vm\u001d;\u000b\u0005Y9\u0012AB:feZ,'OC\u0001\u0019\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0005y9\u0012aC5oi\u0016<'/\u0019;j_:L!\u0001I\u000f\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0012\u0011\u0005\u0011\u0002Q\"A\u000b\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\n\t\u0004Q=\nT\"A\u0015\u000b\u0005)Z\u0013!C5n[V$\u0018M\u00197f\u0015\taS&\u0001\u0006d_2dWm\u0019;j_:T\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a%\u0012A\u0001T5tiB\u0011AEM\u0005\u0003gU\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006\u0001B/Z:u\u0007>tg-[4DQ\u0006tw-\u001a\u000b\u0002mA\u0011q\u0007O\u0007\u0002[%\u0011\u0011(\f\u0002\u0005+:LG\u000f\u000b\u0002\u0004wA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\tk$\u0001\u0002+fgR\fA\u0004^3ti\u0012Kh.Y7jGR{\u0007/[2D_:4\u0017nZ\"iC:<W\r\u000b\u0002\u0005w\u0005)B/Z:u#V|G/Y\"p]\u001aLwm\u00115b]\u001e,G#\u0002\u001cH)ZC\u0006\"\u0002%\u0006\u0001\u0004I\u0015\u0001B;tKJ\u0004\"AS)\u000f\u0005-{\u0005C\u0001'.\u001b\u0005i%B\u0001(\u001a\u0003\u0019a$o\\8u}%\u0011\u0001+L\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q[!)Q+\u0002a\u0001\u0013\u0006A1\r\\5f]RLE\rC\u0003X\u000b\u0001\u0007\u0011*\u0001\bs_>$XI\u001c;jif$\u0016\u0010]3\t\u000be+\u0001\u0019A%\u0002!\r|gNZ5h\u000b:$\u0018\u000e^=OC6,\u0017!\b;fgR\u001cE.[3oi&#\u0017+^8uC\u000e{gNZ5h\u0007\"\fgnZ3)\u0005\u0019Y\u0014!\u0007;fgR,6/\u001a:Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#aB\u001e\u00027Q,7\u000f^+tKJ\u001cE.[3oi&#\u0017+^8uC\u000eC\u0017M\\4fQ\tA1(\u0001\u0013uKN$H)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tI1(\u0001\u0011uKN$H)\u001a4bk2$Xk]3s#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001\u0006<\u0003!\"Xm\u001d;EK\u001a\fW\u000f\u001c;Vg\u0016\u00148\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tY1(A\fuKN$\u0018+^8uC&s\u0017\u000e^5bY&T\u0018\r^5p]\"\u0012AbO\u0001#i\u0016\u001cHoQ8oM&<7\t[1oO\u0016|eNT8o\u000bbL7\u000f^5oOR{\u0007/[2)\u00055Y\u0014a\u0006;fgR\u0004&o\\2fgNtu\u000e^5gS\u000e\fG/[8oQ\tq1(A\u0013tQ>,H\u000e\u001a)beN,'+\u001a9mS\u000e\fG/[8o#V|G/\u0019)s_B,'\u000f^5fg\"\u0012qbO\u0001.g\"|W\u000f\u001c3QCJ\u001cXmV5mI\u000e\f'\u000f\u001a*fa2L7-\u0019;j_:\fVo\u001c;b!J|\u0007/\u001a:uS\u0016\u001c\bF\u0001\t<\u0003\u0001\u001a\bn\\;mIB\u000b'o]3SKBd\u0017nY1uS>t\u0017+^8uCJ+7/\u001a;)\u0005EY\u0014!L:i_VdG\rU1sg\u0016\u0014VmZ1sI2,7o](g/\"LG/Z:qC\u000e,\u0017I]8v]\u00124\u0016\r\\;fg\"\u0012!cO\u0001\u0006a\u0006\u00148/\u001a\u000b\u0006m\u0006\u0015\u0011q\u0002\t\u0004or|hB\u0001={\u001d\ta\u00150C\u0001/\u0013\tYX&A\u0004qC\u000e\\\u0017mZ3\n\u0005ut(aA*fc*\u001110\f\t\u0004o\u0005\u0005\u0011bAA\u0002[\t\u0019\u0011J\u001c;\t\u000f\u0005\u001d1\u00031\u0001\u0002\n\u0005i1m\u001c8gS\u001eD\u0015M\u001c3mKJ\u00042\u0001JA\u0006\u0013\r\ti!\u0006\u0002\u0013)>\u0004\u0018nY\"p]\u001aLw\rS1oI2,'\u000f\u0003\u0004\u0002\u0012M\u0001\r!S\u0001\u0006m\u0006dW/\u001a")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18())), (List)Nil$.MODULE$);
    }

    @Test
    public void testConfigChange() {
        Assert.assertTrue((String)"Should contain a ConfigHandler for topics", (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()));
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$1 = tp;
            boolean x$2 = qual$1.getLog$default$2();
            Option logOpt = qual$1.getLog(x$1, x$2);
            Assert.assertTrue((boolean)logOpt.isDefined());
            Assert.assertEquals((Object)oldVal, (Object)((Log)logOpt.get()).config().flushInterval());
        });
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$3 = tp;
            boolean x$4 = qual$2.getLog$default$2();
            Assert.assertEquals((Object)newVal, (Object)((Log)qual$2.getLog(x$3, x$4).get()).config().flushInterval());
        });
    }

    @Test
    public void testDynamicTopicConfigChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)oldSegmentSize)).toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
            TopicPartition x$1 = tp;
            boolean x$2 = qual$1.getLog$default$2();
            Option logOpt = qual$1.getLog(x$1, x$2);
            Assert.assertTrue((boolean)logOpt.isDefined());
            Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)oldSegmentSize), (Object)((Log)logOpt.get()).config().segmentSize());
        });
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$3 = tp;
        boolean x$4 = qual$2.getLog$default$2();
        Log log = (Log)qual$2.getLog(x$3, x$4).get();
        int newSegmentSize = 2000;
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)newSegmentSize)).toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)newSegmentSize), (Object)log.config().segmentSize()));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)this.servers(), tp.topic(), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5()));
        Assert.assertTrue((String)"Log segment size change not applied", (boolean)log.logSegments().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$4(x$1))));
    }

    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assert.assertTrue((String)new StringBuilder(35).append("Should contain a ConfigHandler for ").append(rootEntityType).toString(), (boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType));
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().quotas();
        String string = rootEntityType;
        String string2 = ConfigType$.MODULE$.Client();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, props);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Quota overrideProducerQuota = quotaManagers.produce().quota(user, clientId);
            Quota overrideConsumerQuota = quotaManagers.fetch().quota(user, clientId);
            Assert.assertEquals((String)new StringBuilder(59).append("User ").append(user).append(" clientId ").append(clientId).append(" must have overridden producer quota of 1000").toString(), (Object)Quota.upperBound((double)1000.0), (Object)overrideProducerQuota);
            Assert.assertEquals((String)new StringBuilder(59).append("User ").append(user).append(" clientId ").append(clientId).append(" must have overridden consumer quota of 2000").toString(), (Object)Quota.upperBound((double)2000.0), (Object)overrideConsumerQuota);
        });
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string4 = rootEntityType;
        String string5 = ConfigType$.MODULE$.Client();
        String string6 = string4;
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, emptyProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Quota producerQuota = quotaManagers.produce().quota(user, clientId);
            Quota consumerQuota = quotaManagers.fetch().quota(user, clientId);
            Assert.assertEquals((String)new StringBuilder(50).append("User ").append(user).append(" clientId ").append(clientId).append(" must have reset producer quota to ").append(defaultProducerQuota).toString(), (Object)Quota.upperBound((double)defaultProducerQuota), (Object)producerQuota);
            Assert.assertEquals((String)new StringBuilder(50).append("User ").append(user).append(" clientId ").append(clientId).append(" must have reset consumer quota to ").append(defaultConsumerQuota).toString(), (Object)Quota.upperBound((double)defaultConsumerQuota), (Object)consumerQuota);
        });
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "1000");
        clientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "2000");
        Properties userProps = new Properties();
        userProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "10000");
        userProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), "100000");
        userClientIdProps.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("overriddenUser", userProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable & scala.Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        Assert.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)10000.0), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)20000.0), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)100000.0), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        Assert.assertEquals((Object)Quota.upperBound((double)200000.0), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try {
            Properties logProps = new Properties();
            logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), Predef$.MODULE$.int2Integer(10000));
            this.adminZkClient().changeTopicConfig(topic, logProps);
            throw this.fail("Should fail with AdminOperationException for topic doesn't exist", new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    @Test
    public void testProcessNotification() {
        Properties props = new Properties();
        props.put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})), DynamicConfigManager$.MODULE$.$lessinit$greater$default$3(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$4());
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        try {
            Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter(jsonMap).asJava()));
            throw this.fail(new StringBuilder(69).append("Should have thrown an Exception while parsing incorrect notification ").append(jsonMap).toString(), new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        }
        catch (Throwable throwable) {
            try {
                Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
                configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter(jsonMap).asJava()));
                throw this.fail(new StringBuilder(69).append("Should have thrown an Exception while parsing incorrect notification ").append(jsonMap).toString(), new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            }
            catch (Throwable throwable2) {
                try {
                    Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
                    configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter(jsonMap).asJava()));
                    throw this.fail(new StringBuilder(69).append("Should have thrown an Exception while parsing incorrect notification ").append(jsonMap).toString(), new Position("DynamicConfigChangeTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
                }
                catch (Throwable throwable3) {
                    Map jsonMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
                    configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter(jsonMap).asJava()));
                    EasyMock.verify((Object[])new Object[]{handler});
                    return;
                }
            }
        }
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)configHandler.parseThrottledPartitions(props, 103, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Assert.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), this.parse(configHandler, " "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicTopicConfigChange$4(LogSegment x$1) {
        return x$1.size() > 1000;
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }
}

