/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001\u0002\u0013&\u0001)BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0013\b\u0003\u0004A\u0001\u0001\u0006IA\u000f\u0005\u0006\u0003\u0002!\tF\u0011\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u0019a\u0006\u0001)A\u0005)\"9Q\f\u0001b\u0001\n\u0013q\u0006BB4\u0001A\u0003%q\fC\u0004i\u0001\t\u0007I\u0011B\u001d\t\r%\u0004\u0001\u0015!\u0003;\u0011\u001dQ\u0007A1A\u0005\n-Da\u0001\u001e\u0001!\u0002\u0013a\u0007bB;\u0001\u0005\u0004%IA\u001e\u0005\u0007w\u0002\u0001\u000b\u0011B<\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\bbCA\u0005\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017A!\"a\u0006\u0001\u0001\u0004\u0005\t\u0015)\u0003\u007f\u0011%\tI\u0002\u0001b\u0001\n\u0013\tY\u0002\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u000f\u0011!\tY\u0003\u0001b\u0001\n\u0003\u0019\u0006bBA\u0017\u0001\u0001\u0006I\u0001\u0016\u0005\t\u0003_\u0001!\u0019!C\u0001s!9\u0011\u0011\u0007\u0001!\u0002\u0013Q\u0004\"CA\u001a\u0001\t\u0007I\u0011AA\u001b\u0011!\ty\u0004\u0001Q\u0001\n\u0005]\u0002\u0002CA!\u0001\t\u0007I\u0011B\u001d\t\u000f\u0005\r\u0003\u0001)A\u0005u!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA,\u0001\u0011\u0005\u0013q\t\u0005\b\u0003C\u0002A\u0011AA$\u0011\u001d\tY\u0007\u0001C\u0001\u0003\u000fBq!a\u001c\u0001\t\u0003\t9\u0005C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005m\u0004\u0001\"\u0003\u0002H!9\u0011Q\u0010\u0001\u0005\n\u0005}$\u0001G$tg\u0006\u0004\u0018.Q;uQ\u0016tG/[2bi&|g\u000eV3ti*\u0011aeJ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003!\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001WE\u0002\"\u0001L\u0018\u000e\u00035R!AL\u0014\u0002\u0007\u0005\u0004\u0018.\u0003\u00021[\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002-e%\u00111'\f\u0002\n'\u0006\u001cHnU3ukB\fa\u0001P5oSRtD#\u0001\u001c\u0011\u0005]\u0002Q\"A\u0013\u0002\u0017M,'O^3s\u0007>,h\u000e^\u000b\u0002uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t\u0019\u0011J\u001c;\u0002\u0019M,'O^3s\u0007>,h\u000e\u001e\u0011\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#A\"\u0011\u0005\u0011\u0003V\"A#\u000b\u0005\u0019;\u0015\u0001B1vi\"T!\u0001S%\u0002\u0011M,7-\u001e:jifT!AS&\u0002\r\r|W.\\8o\u0015\tACJ\u0003\u0002N\u001d\u00061\u0011\r]1dQ\u0016T\u0011aT\u0001\u0004_J<\u0017BA)F\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012\u0001\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bA\u0001\\1oO*\t\u0011,\u0001\u0003kCZ\f\u0017BA.W\u0005\u0019\u0019FO]5oO\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003}\u00032\u0001Y3U\u001b\u0005\t'B\u00012d\u0003%IW.\\;uC\ndWM\u0003\u0002ey\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0019\f'\u0001\u0002'jgR\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\n!B\\;n)\"\u0014X-\u00193t\u0003-qW/\u001c+ie\u0016\fGm\u001d\u0011\u0002\u0011\u0015DXmY;u_J,\u0012\u0001\u001c\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\f!bY8oGV\u0014(/\u001a8u\u0015\t\t\b,\u0001\u0003vi&d\u0017BA:o\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!C3yK\u000e,Ho\u001c:!\u00031\u0019G.[3oi\u000e{gNZ5h+\u00059\bC\u0001=z\u001b\u0005\u0001\u0018B\u0001>q\u0005)\u0001&o\u001c9feRLWm]\u0001\u000eG2LWM\u001c;D_:4\u0017n\u001a\u0011\u0002\u0015M,'O^3s\u0003\u0012$'/F\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001Y\u0003\rqW\r^\u0005\u0005\u0003\u000f\t\tAA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgN\fab]3sm\u0016\u0014\u0018\t\u001a3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005M\u0001cA\u001e\u0002\u0010%\u0019\u0011\u0011\u0003\u001f\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003+\u0001\u0012\u0011!a\u0001}\u0006\u0019\u0001\u0010J\u0019\u0002\u0017M,'O^3s\u0003\u0012$'\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002\u001eA!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$%\u000bQ!\u001e;jYNLA!a\n\u0002\"\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0003u_BL7-\u0001\u0004u_BL7\rI\u0001\u0005a\u0006\u0014H/A\u0003qCJ$\b%\u0001\u0002uaV\u0011\u0011q\u0007\t\u0005\u0003s\tY$D\u0001J\u0013\r\ti$\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\r!\b\u000fI\u0001\u001cM\u0006LG.\u001a3BkRDWM\u001c;jG\u0006$\u0018n\u001c8EK2\f\u00170T:\u00029\u0019\f\u0017\u000e\\3e\u0003V$\b.\u001a8uS\u000e\fG/[8o\t\u0016d\u0017-_'tA\u0005)1/\u001a;VaR\u0011\u0011Q\u0002\u0015\u00049\u0005-\u0003\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005Ec*A\u0003kk:LG/\u0003\u0003\u0002V\u0005=#A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\ri\u00121\f\t\u0005\u0003\u001b\ni&\u0003\u0003\u0002`\u0005=#!B!gi\u0016\u0014\u0018\u0001\u0006;fgR\u0014V-];fgRL5/\u0011*fa2\f\u0017\u0010K\u0002\u001f\u0003K\u0002B!!\u0014\u0002h%!\u0011\u0011NA(\u0005\u0011!Vm\u001d;\u0002IQ,7\u000f^*feZ,'OT8u\r>,h\u000eZ%o\u0017\u0016\u0014(-\u001a:pg\u0012\u000bG/\u00192bg\u0016D3aHA3\u0003}!Xm\u001d;TKJ4XM]!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u0015\u0004A\u0005\u0015\u0014a\u000b<fe&4\u0017PU3ue&\f'\r\\3GC&dWO]3t\tV\u0014\u0018N\\4BkRDWM\u001c;jG\u0006$\u0018n\u001c8\u0015\t\u00055\u0011q\u000f\u0005\u0007\u0003s\n\u0003\u0019\u0001\u001e\u0002%9,XnU;dG\u0016\u001c8OZ;m\u0003V$\bn]\u0001(m\u0016\u0014\u0018NZ=O_:\u0014V\r\u001e:jC\ndW-Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X-\u0001\bde\u0016\fG/Z*fY\u0016\u001cGo\u001c:\u0015\u0005\u0005\u0005\u0005\u0003BAB\u0003\u0013k!!!\"\u000b\u0007\u0005\u001d\u0015*A\u0004oKR<xN]6\n\t\u0005-\u0015Q\u0011\u0002\t'\u0016dWm\u0019;pe\u0002")
public class GssapiAuthenticationTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int serverCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final int numThreads;
    private final ExecutorService executor;
    private final Properties clientConfig;
    private InetSocketAddress serverAddr;
    private final MockTime time;
    private final String topic;
    private final int part;
    private final TopicPartition tp;
    private final int failedAuthenticationDelayMs;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private int numThreads() {
        return this.numThreads;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private Properties clientConfig() {
        return this.clientConfig;
    }

    private InetSocketAddress serverAddr() {
        return this.serverAddr;
    }

    private void serverAddr_$eq(InetSocketAddress x$1) {
        this.serverAddr = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    private int failedAuthenticationDelayMs() {
        return this.failedAuthenticationDelayMs;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        this.serverConfig().put(KafkaConfig$.MODULE$.SslClientAuthProp(), "required");
        this.serverConfig().put(KafkaConfig$.MODULE$.FailedAuthenticationDelayMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.failedAuthenticationDelayMs())).toString());
        super.setUp();
        this.serverAddr_$eq(new InetSocketAddress("localhost", ((KafkaServer)this.servers().head()).boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT))));
        this.clientConfig().put("security.protocol", SecurityProtocol.SASL_PLAINTEXT.name);
        this.clientConfig().put("sasl.mechanism", this.kafkaClientSaslMechanism());
        this.clientConfig().put("sasl.jaas.config", this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), this.jaasClientLoginModule$default$2()));
        this.clientConfig().put("connections.max.idle.ms", "5000");
        this.createTopic(this.topic(), 2, this.serverCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        this.executor().shutdownNow();
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testRequestIsAReplay() {
        int successfulAuthsPerThread = 10;
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numThreads()).map((Function1 & Serializable & scala.Serializable)x$1 -> GssapiAuthenticationTest.$anonfun$testRequestIsAReplay$1(this, successfulAuthsPerThread, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        futures.foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(60L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "failed-authentication-total"));
        long successfulAuths = TestUtils$.MODULE$.totalMetricValue((KafkaServer)this.servers().head(), "successful-authentication-total");
        Assert.assertTrue((String)new StringBuilder(25).append("Too few authentications: ").append(successfulAuths).toString(), (successfulAuths > (long)(successfulAuthsPerThread * this.numThreads()) ? 1 : 0) != 0);
    }

    @Test
    public void testServerNotFoundInKerberosDatabase() {
        String jaasConfig = this.clientConfig().getProperty("sasl.jaas.config");
        String invalidServiceConfig = jaasConfig.replace("serviceName=\"kafka\"", "serviceName=\"invalid-service\"");
        this.clientConfig().put("sasl.jaas.config", invalidServiceConfig);
        this.clientConfig().put("sasl.kerberos.service.name", "invalid-service");
        this.verifyNonRetriableAuthenticationFailure();
    }

    @Test
    public void testServerAuthenticationFailure() {
        String clientLoginContext = this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), (Option<String>)new Some((Object)"another-kafka-service"));
        Properties configOverrides = new Properties();
        configOverrides.setProperty("sasl.jaas.config", clientLoginContext);
        Properties x$1 = configOverrides;
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        KafkaConsumer consumer = this.createConsumer(x$2, x$3, x$1, x$4);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        long startMs = System.currentTimeMillis();
        try {
            consumer.poll(Duration.ofMillis(50L));
            throw this.fail(new Position("GssapiAuthenticationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            long endMs = System.currentTimeMillis();
            Predef$.MODULE$.require(endMs - startMs < (long)this.failedAuthenticationDelayMs(), (Function0 & Serializable & scala.Serializable)() -> "Failed authentication must not be delayed on the client");
            consumer.close();
            return;
        }
    }

    public void kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(int numSuccessfulAuths) {
        try (Selector selector = this.createSelector();){
            int actualSuccessfulAuths = 0;
            while (actualSuccessfulAuths < numSuccessfulAuths) {
                String nodeId = ((Object)BoxesRunTime.boxToInteger((int)actualSuccessfulAuths)).toString();
                selector.connect(nodeId, this.serverAddr(), 1024, 1024);
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    selector.poll(100L);
                    ChannelState disconnectState = (ChannelState)selector.disconnected().get(nodeId);
                    if (disconnectState != null) {
                        Assert.assertEquals((String)new StringBuilder(37).append("Authentication failed with exception ").append(disconnectState.exception()).toString(), (Object)ChannelState.State.AUTHENTICATE, (Object)disconnectState.state());
                    }
                    return selector.isChannelReady(nodeId) || disconnectState != null;
                }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Client not ready or disconnected within timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
                if (selector.isChannelReady(nodeId)) {
                    ++actualSuccessfulAuths;
                }
                selector.close(nodeId);
            }
        }
    }

    private void verifyNonRetriableAuthenticationFailure() {
        Selector selector = this.createSelector();
        String nodeId = "1";
        selector.connect(nodeId, this.serverAddr(), 1024, 1024);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            selector.poll(100L);
            ChannelState disconnectState = (ChannelState)selector.disconnected().get(nodeId);
            if (disconnectState != null) {
                Assert.assertEquals((Object)ChannelState.State.AUTHENTICATION_FAILED, (Object)disconnectState.state());
            }
            return disconnectState != null;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Client not disconnected within timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private Selector createSelector() {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.securityProtocol(), (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig((Map)this.clientConfig()), null, (String)this.kafkaClientSaslMechanism(), (Time)this.time(), (boolean)true);
        return NetworkTestUtils.createSelector((ChannelBuilder)channelBuilder, (Time)this.time());
    }

    public static final /* synthetic */ Future $anonfun$testRequestIsAReplay$1(GssapiAuthenticationTest $this, int successfulAuthsPerThread$1, int x$1) {
        return $this.executor().submit(new Runnable($this, successfulAuthsPerThread$1){
            private final /* synthetic */ GssapiAuthenticationTest $outer;
            private final int successfulAuthsPerThread$1;

            public void run() {
                this.$outer.kafka$server$GssapiAuthenticationTest$$verifyRetriableFailuresDuringAuthentication(this.successfulAuthsPerThread$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.successfulAuthsPerThread$1 = successfulAuthsPerThread$1;
            }
        });
    }

    public GssapiAuthenticationTest() {
        SaslSetup.$init$(this);
        this.serverCount = 1;
        this.kafkaClientSaslMechanism = "GSSAPI";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"GSSAPI", (List)Nil$.MODULE$);
        this.numThreads = 10;
        this.executor = Executors.newFixedThreadPool(this.numThreads());
        this.clientConfig = new Properties();
        this.time = new MockTime(10L);
        this.topic = "topic";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.failedAuthenticationDelayMs = 2000;
    }
}

