/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q3AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0013a\u0002B\u0002\u0016\u0001A\u0003%Q\u0004C\u0003,\u0001\u0011\u0005A\u0006C\u00038\u0001\u0011\u0005A\u0006C\u0003:\u0001\u0011\u0005!\bC\u0003F\u0001\u0011\u0005A\u0006C\u0003H\u0001\u0011%\u0001\nC\u0003S\u0001\u0011%1KA\u000eSKBd\u0017nY1uS>t\u0017+^8uC6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u00195\taa]3sm\u0016\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005Y\u0011\u0001\u0002;j[\u0016,\u0012!\b\t\u0003=!j\u0011a\b\u0006\u0003A\u0005\nQ!\u001e;jYNT!AI\u0012\u0002\r\r|W.\\8o\u0015\tqAE\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<\u0017BA\u0015 \u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!I:i_VdG\r\u00165s_R$H.Z(oYf$UMZ5oK\u0012\u0014V\r\u001d7jG\u0006\u001cH#A\u0017\u0011\u0005Iq\u0013BA\u0018\u0014\u0005\u0011)f.\u001b;)\u0005\u0011\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b'\u0003\u0015QWO\\5u\u0013\t14G\u0001\u0003UKN$\u0018!N:i_VdG-\u0012=dK\u0016$\u0017+^8uCRCWM\u001c*fiV\u0014hNQ1dW\n+Gn\\<C_VtG-Q:US6,\u0007+Y:tKND#!B\u0019\u0002\tI\fG/\u001a\u000b\u0003wy\u0002\"A\u0005\u001f\n\u0005u\u001a\"A\u0002#pk\ndW\rC\u0003@\r\u0001\u0007\u0001)A\u0004nKR\u0014\u0018nY:\u0011\u0005\u0005\u001bU\"\u0001\"\u000b\u0005}\n\u0013B\u0001#C\u0005\u001diU\r\u001e:jGN\fae\u001d5pk2$7+\u001e9q_J$x+\u001b7eG\u0006\u0014H\r\u00165s_R$H.\u001a3SKBd\u0017nY1tQ\t9\u0011'A\u0002uaF\"\"!S'\u0011\u0005)[U\"A\u0011\n\u00051\u000b#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006\u001d\"\u0001\raT\u0001\u0003S\u0012\u0004\"A\u0005)\n\u0005E\u001b\"aA%oi\u0006Qa.Z<NKR\u0014\u0018nY:\u0015\u0003\u0001\u0003")
public class ReplicationQuotaManagerTest {
    private final MockTime time = new MockTime();

    private MockTime time() {
        return this.time;
    }

    @Test
    public void shouldThrottleOnlyDefinedReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(ReplicationQuotaManagerConfig$.MODULE$.apply$default$1(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$2(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time());
        quota.markThrottled("topic1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(1)));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(2)));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(3)));
        Assert.assertFalse((boolean)quota.isThrottled(this.tp1(4)));
    }

    @Test
    public void shouldExceedQuotaThenReturnBackBelowBoundAsTimePasses() {
        Metrics metrics = this.newMetrics();
        int x$1 = 10;
        int x$2 = 1;
        long x$3 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(x$3, x$1, x$2), metrics, (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.updateQuota(new Quota(100.0, true));
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        this.time().sleep(1000L);
        this.time().sleep(500L);
        quota.record(1L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(149L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assert.assertEquals((double)100.66666666666667, (double)this.rate(metrics), (double)0.0);
        Assert.assertTrue((boolean)quota.isQuotaExceeded());
        this.time().sleep(500L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)75.5, (double)this.rate(metrics), (double)0.1);
        this.time().sleep(500L);
        quota.record(99L);
        Assert.assertEquals((double)100.0, (double)this.rate(metrics), (double)0.0);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assert.assertTrue((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)100.4, (double)this.rate(metrics), (double)0.0);
        this.time().sleep(2000L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)55.77777777777778, (double)this.rate(metrics), (double)0.0);
    }

    /*
     * WARNING - void declaration
     */
    public double rate(Metrics metrics) {
        void var3_3;
        MetricName metricName = metrics.metricName("byte-rate", QuotaType.LeaderReplication$.MODULE$.toString(), new StringBuilder(23).append("Tracking byte-rate for ").append(QuotaType.LeaderReplication$.MODULE$).toString());
        double leaderThrottledRate = BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics.metrics()).asScala()).apply((Object)metricName)).metricValue());
        return (double)var3_3;
    }

    @Test
    public void shouldSupportWildcardThrottledReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(ReplicationQuotaManagerConfig$.MODULE$.apply$default$1(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$2(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.markThrottled("MyTopic");
        Assert.assertTrue((boolean)quota.isThrottled(new TopicPartition("MyTopic", 0)));
        Assert.assertFalse((boolean)quota.isThrottled(new TopicPartition("MyOtherTopic", 0)));
    }

    private TopicPartition tp1(int id) {
        return new TopicPartition("topic1", id);
    }

    private Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }
}

