/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Properties;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.network.SocketServer;
import kafka.security.minikdc.MiniKdc;
import kafka.server.ApiVersionsRequestTest$;
import kafka.server.BaseRequestTest;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\u000b\u0016\u0001iAQ!\n\u0001\u0005\u0002\u0019BQ\u0001\u000b\u0001\u0005R%Bq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004D\u0001\u0001\u0006Ia\u000f\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019\u0001\u0006\u0001)A\u0005\r\"9\u0011\u000b\u0001b\u0001\n#\u0012\u0006BB/\u0001A\u0003%1\u000bC\u0004_\u0001\t\u0007I\u0011\u000b*\t\r}\u0003\u0001\u0015!\u0003T\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015\t\b\u0001\"\u0011g\u0011\u00151\b\u0001\"\u0001g\u0011\u0015Y\b\u0001\"\u0001g\u0011\u0015i\b\u0001\"\u0001g\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!I\u0011\u0011\b\u0001\u0012\u0002\u0013%\u00111\b\u0005\b\u0003#\u0002A\u0011BA*\u0005i\u0019\u0016m\u001d7Ba&4VM]:j_:\u001c(+Z9vKN$H+Z:u\u0015\t1r#\u0001\u0004tKJ4XM\u001d\u0006\u00021\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u001c?A\u0011A$H\u0007\u0002+%\u0011a$\u0006\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3tiB\u0011\u0001eI\u0007\u0002C)\u0011!eF\u0001\u0004CBL\u0017B\u0001\u0013\"\u0005%\u0019\u0016m\u001d7TKR,\b/\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011A\u0004A\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\u0012A\u000b\t\u0003W]j\u0011\u0001\f\u0006\u0003[9\nA!Y;uQ*\u0011q\u0006M\u0001\tg\u0016\u001cWO]5us*\u0011\u0011GM\u0001\u0007G>lWn\u001c8\u000b\u0005a\u0019$B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001eL!\u0001\u000f\u0017\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017\u0001G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[V\t1\b\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005!A.\u00198h\u0015\u0005\u0001\u0015\u0001\u00026bm\u0006L!AQ\u001f\u0003\rM#(/\u001b8h\u0003eY\u0017MZ6b\u00072LWM\u001c;TCNdW*Z2iC:L7/\u001c\u0011\u00023-\fgm[1TKJ4XM]*bg2lUm\u00195b]&\u001cXn]\u000b\u0002\rB\u0019qIT\u001e\u000e\u0003!S!!\u0013&\u0002\u0013%lW.\u001e;bE2,'BA&M\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0013\u0002\u0005\u0019&\u001cH/\u0001\u000elC\u001a\\\u0017mU3sm\u0016\u00148+Y:m\u001b\u0016\u001c\u0007.\u00198jg6\u001c\b%\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002'B\u0019A+V,\u000e\u00031K!A\u0016'\u0003\tM{W.\u001a\t\u00031nk\u0011!\u0017\u0006\u00035~\nA!\u001e;jY&\u0011A,\u0017\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!F:feZ,'oU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0015G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:\u0002+\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA\u0005Qa.^7Ce>\\WM]:\u0016\u0003\t\u0004\"\u0001V2\n\u0005\u0011d%aA%oi\u0006)1/\u001a;VaR\tq\r\u0005\u0002UQ&\u0011\u0011\u000e\u0014\u0002\u0005+:LG\u000f\u000b\u0002\rWB\u0011An\\\u0007\u0002[*\u0011a.N\u0001\u0006UVt\u0017\u000e^\u0005\u0003a6\u0014aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u00055\u0019\bC\u00017u\u0013\t)XNA\u0003BMR,'/\u0001\u0019uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0005\u00164wN]3TCNd\u0007*\u00198eg\"\f7.\u001a*fcV,7\u000f\u001e\u0015\u0003\u001da\u0004\"\u0001\\=\n\u0005il'\u0001\u0002+fgR\fq\u0006^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f^!gi\u0016\u00148+Y:m\u0011\u0006tGm\u001d5bW\u0016\u0014V-];fgRD#a\u0004=\u0002YQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR<\u0016\u000e\u001e5V]N,\b\u000f]8si\u0016$g+\u001a:tS>t\u0007F\u0001\ty\u0003Y\u0019XM\u001c3Ba&4VM]:j_:\u001c(+Z9vKN$H\u0003CA\u0002\u0003\u001f\ty\"!\u000b\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u00031\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0007\u0003\u000f\u00111#\u00119j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016Dq!!\u0005\u0012\u0001\u0004\t\u0019\"\u0001\u0004t_\u000e\\W\r\u001e\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D \u0002\u00079,G/\u0003\u0003\u0002\u001e\u0005]!AB*pG.,G\u000fC\u0004\u0002\"E\u0001\r!a\t\u0002\u000fI,\u0017/^3tiB!\u0011QAA\u0013\u0013\u0011\t9#a\u0002\u0003%\u0005\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\u0005\n\u0003W\t\u0002\u0013!a\u0001\u0003[\t!\"\u00199j-\u0016\u00148/[8o!\u0015!\u0016qFA\u001a\u0013\r\t\t\u0004\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007Q\u000b)$C\u0002\u000281\u0013Qa\u00155peR\f\u0001e]3oI\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\b\u0016\u0005\u0003[\tyd\u000b\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!C;oG\",7m[3e\u0015\r\tY\u0005T\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003!\u001aXM\u001c3TCNd\u0007*\u00198eg\"\f7.\u001a*fcV,7\u000f\u001e,bY&$\u0017\r^3SKN\u0004xN\\:f)\r9\u0017Q\u000b\u0005\b\u0003#\u0019\u0002\u0019AA\n\u0001")
public class SaslApiVersionsRequestTest
extends BaseRequestTest
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    public int numBrokers() {
        return 1;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testApiVersionsRequestBeforeSaslHandshakeRequest() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$2, x$1);){
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
    }

    @Test
    public void testApiVersionsRequestAfterSaslHandshakeRequest() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$2, x$1);){
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
            ApiVersionsResponse response = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            Assert.assertEquals((Object)Errors.ILLEGAL_SASL_STATE, (Object)response.error());
        }
    }

    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        SecurityProtocol x$1 = this.securityProtocol();
        SocketServer x$2 = this.connect$default$1();
        try (Socket plaintextSocket = this.connect(x$2, x$1);){
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(0);
            ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(plaintextSocket, apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)));
            Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)apiVersionsResponse.error());
            ApiVersionsResponse apiVersionsResponse2 = this.sendApiVersionsRequest(plaintextSocket, new ApiVersionsRequest.Builder().build((short)0), this.sendApiVersionsRequest$default$3());
            ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse2);
            this.sendSaslHandshakeRequestValidateResponse(plaintextSocket);
        }
    }

    private ApiVersionsResponse sendApiVersionsRequest(Socket socket, ApiVersionsRequest request, Option<Object> apiVersion) {
        ByteBuffer response = this.sendAndReceive((AbstractRequest)request, ApiKeys.API_VERSIONS, socket, apiVersion);
        return ApiVersionsResponse.parse((ByteBuffer)response, (short)request.version());
    }

    private Option<Object> sendApiVersionsRequest$default$3() {
        return None$.MODULE$;
    }

    private void sendSaslHandshakeRequestValidateResponse(Socket socket) {
        SaslHandshakeRequest request = new SaslHandshakeRequest("PLAIN");
        ByteBuffer response = this.sendAndReceive((AbstractRequest)request, ApiKeys.SASL_HANDSHAKE, socket, this.sendAndReceive$default$4());
        SaslHandshakeResponse handshakeResponse = SaslHandshakeResponse.parse((ByteBuffer)response, (short)request.version());
        Assert.assertEquals((Object)Errors.NONE, (Object)handshakeResponse.error());
        Assert.assertEquals(Collections.singletonList("PLAIN"), (Object)handshakeResponse.enabledMechanisms());
    }

    public SaslApiVersionsRequestTest() {
        SaslSetup.$init$(this);
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)"PLAIN", (List)Nil$.MODULE$);
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }
}

