/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.metrics.KafkaMetricsGroup;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\t\u0013\u0001]AQA\t\u0001\u0005\u0002\rBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u00045\u0001\u0001\u0006Ia\n\u0005\bk\u0001\u0011\r\u0011\"\u00017\u0011\u0019i\u0004\u0001)A\u0005o!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0003L\u0001\u0011\u0005A\nC\u0003X\u0001\u0011\u0005A\nC\u0003_\u0001\u0011%q\f\u0003\u0004_\u0001\u0011%\u0011Q\u0001\u0005\u0007=\u0002!I!!\u000b\t\r\u0005e\u0002\u0001\"\u0001M\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!!\u0019\u0001\t\u0013\t\u0019\u0007\u0003\u0004\u0002\n\u0002!\t\u0001\u0014\u0002\u001a\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0014)\u0005\u0019An\\4\u000b\u0003U\tQa[1gW\u0006\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003II!a\u0007\n\u0003C\u0005\u00137\u000f\u001e:bGRdunZ\"mK\u0006tWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0012aB7fiJL7m]\u0005\u0003Cy\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002\u001a\u0001\u0005)1m\u001c3fGV\tq\u0005\u0005\u0002)e5\t\u0011F\u0003\u0002+W\u00051!/Z2pe\u0012T!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\t)bF\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<\u0017BA\u001a*\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0017AB2pI\u0016\u001c\u0007%\u0001\u0003uS6,W#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005i\"\u0012!B;uS2\u001c\u0018B\u0001\u001f:\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003\u0001\u00032!\u0011#G\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%!B!se\u0006L\bCA$I\u001b\u0005Y\u0013BA%,\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u000f\rdW-\u00198vaR\tQ\n\u0005\u0002B\u001d&\u0011qJ\u0011\u0002\u0005+:LG\u000f\u000b\u0002\t#B\u0011!+V\u0007\u0002'*\u0011A\u000bM\u0001\u0006UVt\u0017\u000e^\u0005\u0003-N\u0013Q!\u00114uKJ\f!\b^3ti6\u000b'o[:QCJ$\u0018\u000e^5p]N\f5o\u00144gY&tW-\u00118e!>\u0004X\u000f\\1uKN,fn\u00197fC:\f'\r\\3NKR\u0014\u0018nY:)\t%IF,\u0018\t\u0003%jK!aW*\u0003\tQ+7\u000f^\u0001\bi&lWm\\;u=\tQ\u00044\u0001\u0005hKR<\u0015-^4f+\t\u0001g\u000e\u0006\u0002boB\u0019!M\u001b7\u000e\u0003\rT!\u0001Z3\u0002\t\r|'/\u001a\u0006\u0003?\u0019T!a\u001a5\u0002\re\fW.\\3s\u0015\u0005I\u0017aA2p[&\u00111n\u0019\u0002\u0006\u000f\u0006,x-\u001a\t\u0003[:d\u0001\u0001B\u0003p\u0015\t\u0007\u0001OA\u0001U#\t\tH\u000f\u0005\u0002Be&\u00111O\u0011\u0002\b\u001d>$\b.\u001b8h!\t\tU/\u0003\u0002w\u0005\n\u0019\u0011I\\=\t\u000baT\u0001\u0019A=\u0002\r\u0019LG\u000e^3s!\u0011\t%\u0010`@\n\u0005m\u0014%!\u0003$v]\u000e$\u0018n\u001c82!\t\u0011W0\u0003\u0002\u007fG\nQQ*\u001a;sS\u000et\u0015-\\3\u0011\u0007\u0005\u000b\t!C\u0002\u0002\u0004\t\u0013qAQ8pY\u0016\fg.\u0006\u0003\u0002\b\u00055A\u0003BA\u0005\u0003\u001f\u0001BA\u00196\u0002\fA\u0019Q.!\u0004\u0005\u000b=\\!\u0019\u00019\t\u000f\u0005E1\u00021\u0001\u0002\u0014\u0005QQ.\u001a;sS\u000et\u0015-\\3\u0011\t\u0005U\u00111\u0005\b\u0005\u0003/\ty\u0002E\u0002\u0002\u001a\tk!!a\u0007\u000b\u0007\u0005ua#\u0001\u0004=e>|GOP\u0005\u0004\u0003C\u0011\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002&\u0005\u001d\"AB*ue&twMC\u0002\u0002\"\t+B!a\u000b\u00022Q1\u0011QFA\u001a\u0003k\u0001BA\u00196\u00020A\u0019Q.!\r\u0005\u000b=d!\u0019\u00019\t\u000f\u0005EA\u00021\u0001\u0002\u0014!9\u0011q\u0007\u0007A\u0002\u0005M\u0011aC7fiJL7mU2pa\u0016\fq\u0003^3ti6\u000b\u0007\u0010T8h\u0007>l\u0007/Y2uS>tG*Y4)\u00055I\u0016a\u0003:fC\u00124%o\\7M_\u001e$B!!\u0011\u0002ZA1\u00111IA%\u0003\u001bj!!!\u0012\u000b\u0007\u0005\u001d#)\u0001\u0006d_2dWm\u0019;j_:LA!a\u0013\u0002F\tA\u0011\n^3sC\ndW\rE\u0004B\u0003\u001f\n\u0019&a\u0015\n\u0007\u0005E#I\u0001\u0004UkBdWM\r\t\u0004\u0003\u0006U\u0013bAA,\u0005\n\u0019\u0011J\u001c;\t\rMq\u0001\u0019AA.!\rI\u0012QL\u0005\u0004\u0003?\u0012\"a\u0001'pO\u0006aqO]5uK.+\u0017\u0010R;qgR\u0001\u0012QMA6\u0003_\n\u0019(!\u001e\u0002x\u0005\u0005\u0015Q\u0011\t\u0007\u0003\u0007\n9'!\u0014\n\t\u0005%\u0014Q\t\u0002\u0004'\u0016\f\bbBA7\u001f\u0001\u0007\u00111K\u0001\b]Vl7*Z=t\u0011\u001d\t\th\u0004a\u0001\u0003'\nqA\\;n\tV\u00048\u000f\u0003\u0004\u0014\u001f\u0001\u0007\u00111\f\u0005\u0006K=\u0001\ra\n\u0005\b\u0003sz\u0001\u0019AA>\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002B\u0003{J1!a C\u0005\u0011auN\\4\t\u000f\u0005\ru\u00021\u0001\u0002T\u0005Q1\u000f^1siZ\u000bG.^3\t\u000f\u0005\u001du\u00021\u0001\u0002T\u0005!1\u000f^3q\u0003I!Xm\u001d;JgRC'/Z1e\r\u0006LG.\u001a3)\u0005AI\u0006")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements KafkaMetricsGroup {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$((KafkaMetricsGroup)this);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$((KafkaMetricsGroup)this);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$((KafkaMetricsGroup)this);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$((KafkaMetricsGroup)this);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$((KafkaMetricsGroup)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @After
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test(timeout=15000L)
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$3, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Log log2 = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.logSegments().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.logSegments().last()).baseOffset())._2$mcJ$sp();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(expectedTotalUncleanableBytes), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assert.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assert.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
    }

    private <T> Gauge<T> getGauge(Function1<MetricName, Object> filter) {
        Object object;
        Option option = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply(x$1)))).headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            LogCleanerIntegrationTest.$anonfun$getGauge$2();
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this.get();
        }
        return (Gauge)((Tuple2)object)._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Object object;
        Function1 & Serializable & scala.Serializable getGauge_filter = (Function1 & Serializable & scala.Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$3(metricName, mName));
        Option option = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply(x$1)))).headOption();
        if (option == null) {
            throw null;
        }
        Option getGauge_getOrElse_this = option;
        if (getGauge_getOrElse_this.isEmpty()) {
            LogCleanerIntegrationTest.$anonfun$getGauge$2();
            object = BoxedUnit.UNIT;
        } else {
            object = getGauge_getOrElse_this.get();
        }
        return (Gauge)((Tuple2)object)._2();
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Object object;
        Function1 & Serializable & scala.Serializable getGauge_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$4(metricName, metricScope, k));
        Option option = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply(x$1)))).headOption();
        if (option == null) {
            throw null;
        }
        Option getGauge_getOrElse_this = option;
        if (getGauge_getOrElse_this.isEmpty()) {
            LogCleanerIntegrationTest.$anonfun$getGauge$2();
            object = BoxedUnit.UNIT;
        } else {
            object = getGauge_getOrElse_this.get();
        }
        return (Gauge)((Tuple2)object)._2();
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11));
        Log log = (Log)this.cleaner().logs().get((Object)topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assert.assertEquals((String)"There should be no cleaning until the max compaction lag has passed", (long)startSizeBlock0, (long)log.size());
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$12 = new TopicPartition("log", 0);
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, firstBlockCleanableSegmentOffset, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", ").append("but lastCleaned=").append(lastCleaned).toString(), (lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0);
        Assert.assertNotEquals((String)"log should still contain non-zero keys", appends1, read1);
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$15 = new TopicPartition("log", 0);
        long x$16 = activeSegAtT1.baseOffset();
        long x$17 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$15, x$16, x$17);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assert.assertEquals((String)"log should only contains zero keys now", appends1, read2);
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assert.assertTrue((String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", ").append("but lastCleaned=").append(lastCleaned2).toString(), (lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0);
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            String string = TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            int key = new StringOps(string).toInt();
            String string2 = TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            int value = new StringOps(string2).toInt();
            Integer n = BoxesRunTime.boxToInteger((int)value);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, Log log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return (Seq)RichInt$.MODULE$.until$extension0(n, numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$22 = 100000;
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$3, x$22, x$6, x$7, x$8, x$9, x$10, x$11));
        this.cleaner().startup();
        Assert.assertEquals((long)0L, (long)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertEquals((long)this.cleaner().cleaners().size(), (long)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assert.assertEquals((long)this.cleaner().cleaners().size(), (long)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        Log log = (Log)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)log.logSegments().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(Function1 filter$1, MetricName x$1) {
        return BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)x$1));
    }

    public static final /* synthetic */ void $anonfun$getGauge$2() {
        Assert.fail((String)"Unable to find metric");
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$3(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$4(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, Log log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = ((Object)BoxesRunTime.boxToInteger((int)curValue)).toString().getBytes();
        byte[] x$3 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, Log log$1, CompressionType codec$1, long timestamp$1, int step$1, int _) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(n, numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }

    public LogCleanerIntegrationTest() {
        Logging.$init$((Logging)this);
        KafkaMetricsGroup.$init$((KafkaMetricsGroup)this);
        this.codec = CompressionType.LZ4;
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

