/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogAppendInfo;
import kafka.log.LogAppendInfo$;
import kafka.message.CompressionCodec;
import kafka.message.NoCompressionCodec$;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.AbstractFetcherThreadTest$MockFetcherThread$;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetcherMetrics$;
import kafka.server.Fetching$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.UnknownLeaderEpochException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0011Ua\u0001\u00020`\u0001\u0011DQa\u001b\u0001\u0005\u00021Dqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004}\u0001\u0001\u0006I!\u001d\u0005\b{\u0002\u0011\r\u0011\"\u0003q\u0011\u0019q\b\u0001)A\u0005c\"Aq\u0010\u0001b\u0001\n\u0013\t\t\u0001\u0003\u0005\u0002\n\u0001\u0001\u000b\u0011BA\u0002\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001bAq!a\t\u0001\t\u0013\t)\u0003C\u0004\u0002J\u0001!I!a\u0013\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!9\u0011Q\u0012\u0001\u0005\u0002\u00055\u0001bBAL\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u00037\u0003A\u0011AA\u0007\u0011\u001d\ty\n\u0001C\u0001\u0003\u001bAq!a)\u0001\t\u0003\ti\u0001C\u0004\u0002(\u0002!\t!!\u0004\t\u000f\u0005-\u0006\u0001\"\u0001\u0002\u000e!9\u0011q\u0016\u0001\u0005\u0002\u00055\u0001bBAZ\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003o\u0003A\u0011AA\u0007\u0011\u001d\tY\f\u0001C\u0001\u0003\u001bAq!a0\u0001\t\u0003\ti\u0001C\u0004\u0002D\u0002!\t!!\u0004\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002\u000e!9\u00111\u001a\u0001\u0005\u0002\u00055\u0001bBAh\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003'\u0004A\u0011AA\u0007\u0011\u001d\t9\u000e\u0001C\u0001\u0003\u001bAq!a7\u0001\t\u0003\ti\u0001C\u0004\u0002`\u0002!I!!9\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002\u000e!9\u00111\u001e\u0001\u0005\u0002\u00055\u0001bBAx\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003g\u0004A\u0011AA\u0007\u0011\u001d\t9\u0010\u0001C\u0005\u0003s<qA!\r\u0001\u0011\u0003\u0011\u0019DB\u0004\u0003\u0004\u0001A\tA!\u000e\t\r-4C\u0011\u0001B\u001c\r\u0019\u0011ID\n\u0001\u0003<!Q!Q\b\u0015\u0003\u0002\u0004%\tAa\u0010\t\u0015\t\u001d\u0003F!a\u0001\n\u0003\u0011I\u0005\u0003\u0006\u0003P!\u0012\t\u0011)Q\u0005\u0005\u0003B!\"!\u001a)\u0005\u0003\u0007I\u0011\u0001B\b\u0011)\u0011\t\u0006\u000bBA\u0002\u0013\u0005!1\u000b\u0005\u000b\u0005/B#\u0011!Q!\n\u0005\u001d\u0004B\u0003B-Q\t\u0005\r\u0011\"\u0001\u0003\\!Q!Q\f\u0015\u0003\u0002\u0004%\tAa\u0018\t\u0015\t\r\u0004F!A!B\u0013\ti\u0006\u0003\u0006\u0003f!\u0012\t\u0019!C\u0001\u00057B!Ba\u001a)\u0005\u0003\u0007I\u0011\u0001B5\u0011)\u0011i\u0007\u000bB\u0001B\u0003&\u0011Q\f\u0005\u000b\u0005_B#\u00111A\u0005\u0002\tm\u0003B\u0003B9Q\t\u0005\r\u0011\"\u0001\u0003t!Q!q\u000f\u0015\u0003\u0002\u0003\u0006K!!\u0018\t\r-DC\u0011\u0001B=\u000f\u001d\u0011II\nE\u0001\u0005\u00173qA!\u000f'\u0011\u0003\u0011i\t\u0003\u0004lu\u0011\u0005!q\u0012\u0005\b\u0005#SD\u0011\u0001BJ\u0011\u001d\u0011\tJ\u000fC\u0001\u0005[C\u0011B!-'#\u0003%\tAa-\t\u0013\t%g%%A\u0005\u0002\tMfA\u0002B\u0002\u0001\u0001\u0011)\u0001\u0003\u0006\u0003\u000e\u0001\u0013)\u0019!C\u0001\u0005\u001fA!B!\u0005A\u0005\u0003\u0005\u000b\u0011BA4\u0011)\u0011\u0019\u0002\u0011BC\u0002\u0013\u0005!q\u0002\u0005\u000b\u0005+\u0001%\u0011!Q\u0001\n\u0005\u001d\u0004BB6A\t\u0003\u00119\u0002C\u0005\u0003\u001e\u0001\u0013\r\u0011\"\u0003\u0003 !A!1\u001a!!\u0002\u0013\u0011\t\u0003C\u0005\u0003N\u0002\u0013\r\u0011\"\u0003\u0003 !A!q\u001a!!\u0002\u0013\u0011\t\u0003C\u0004\u0003R\u0002#\tAa5\t\u000f\tu\u0007\t\"\u0001\u0003`\"9!Q\u001d!\u0005\u0002\t\u001d\bb\u0002Bv\u0001\u0012\u0005!Q\u001e\u0005\b\u0005c\u0004E\u0011\tBz\u0011\u001d\u0019)\u0002\u0011C!\u0007/Aqa!\nA\t\u0003\u001a9\u0003C\u0004\u00040\u0001#\te!\r\t\u000f\r}\u0003\t\"\u0011\u0004b!9!\u0011\f!\u0005B\r\u001d\u0004b\u0002B3\u0001\u0012\u000531\u000e\u0005\b\u0007_\u0002E\u0011IB9\u0011\u001d\u0019Y\b\u0011C\u0005\u0007{Bqa!-A\t\u0013\u0019\u0019\fC\u0004\u0004N\u0002#\tea4\t\u000f\re\u0007\t\"\u0015\u0004\\\"911\u001d!\u0005B\r\u0015\bbBB~\u0001\u0012%1Q \u0005\b\t\u000b\u0001E\u0011\u000bC\u0004\u0011\u001d!i\u0001\u0011C)\t\u001f\u0011\u0011$\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rV3ti*\u0011\u0001-Y\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\t\fQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001KB\u0011a-[\u0007\u0002O*\t\u0001.A\u0003tG\u0006d\u0017-\u0003\u0002kO\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A7\u0011\u00059\u0004Q\"A0\u0002\u0015A\f'\u000f^5uS>t\u0017'F\u0001r!\t\u0011(0D\u0001t\u0015\t!X/\u0001\u0004d_6lwN\u001c\u0006\u0003EZT!a\u001e=\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0018aA8sO&\u00111p\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003-\u0001\u0018M\u001d;ji&|g.\r\u0011\u0002\u0015A\f'\u000f^5uS>t''A\u0006qCJ$\u0018\u000e^5p]J\u0002\u0013\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t+\t\t\u0019\u0001E\u0002o\u0003\u000bI1!a\u0002`\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/A\tgC&dW\r\u001a)beRLG/[8og\u0002\n1c\u00197fC:lU\r\u001e:jGJ+w-[:uef$\"!a\u0004\u0011\u0007\u0019\f\t\"C\u0002\u0002\u0014\u001d\u0014A!\u00168ji\"\u001a\u0001\"a\u0006\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\by\u0003\u0015QWO\\5u\u0013\u0011\t\t#a\u0007\u0003\r\t+gm\u001c:f\u0003=\tG\u000e\\'fiJL7m\u001d(b[\u0016\u001cXCAA\u0014!\u0019\tI#a\f\u000245\u0011\u00111\u0006\u0006\u0004\u0003[9\u0017AC2pY2,7\r^5p]&!\u0011\u0011GA\u0016\u0005\r\u0019V\r\u001e\t\u0005\u0003k\t\u0019E\u0004\u0003\u00028\u0005}\u0002cAA\u001dO6\u0011\u00111\b\u0006\u0004\u0003{\u0019\u0017A\u0002\u001fs_>$h(C\u0002\u0002B\u001d\fa\u0001\u0015:fI\u00164\u0017\u0002BA#\u0003\u000f\u0012aa\u0015;sS:<'bAA!O\u00069Qn\u001b\"bi\u000eDG\u0003CA'\u00033\n\u0019'!\u001c\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015t\u0003\u0019\u0011XmY8sI&!\u0011qKA)\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u000f\u0005m#\u00021\u0001\u0002^\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0011\u0007\u0019\fy&C\u0002\u0002b\u001d\u0014A\u0001T8oO\"9\u0011Q\r\u0006A\u0002\u0005\u001d\u0014a\u00037fC\u0012,'/\u00129pG\"\u00042AZA5\u0013\r\tYg\u001a\u0002\u0004\u0013:$\bbBA8\u0015\u0001\u0007\u0011\u0011O\u0001\be\u0016\u001cwN\u001d3t!\u00151\u00171OA<\u0013\r\t)h\u001a\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003BA(\u0003sJA!a\u001f\u0002R\ta1+[7qY\u0016\u0014VmY8sI\u0006qqN\u001a4tKR\fe\u000eZ#q_\u000eDGCBAA\u0003\u000f\u000bY\tE\u0002o\u0003\u0007K1!!\"`\u00059yeMZ:fi\u0006sG-\u00129pG\"Dq!!#\f\u0001\u0004\ti&A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBA3\u0017\u0001\u0007\u0011qM\u0001\u001di\u0016\u001cH/T3ue&\u001c7OU3n_Z,Gm\u00148TQV$Hm\\<oQ\ra\u0011\u0011\u0013\t\u0005\u00033\t\u0019*\u0003\u0003\u0002\u0016\u0006m!\u0001\u0002+fgR\f1\u0005^3ti\u000e{gn];nKJd\u0015m\u001a*f[>4X\rZ,ji\"\u0004\u0016M\u001d;ji&|g\u000eK\u0002\u000e\u0003#\u000bq\u0002^3tiNKW\u000e\u001d7f\r\u0016$8\r\u001b\u0015\u0004\u001d\u0005E\u0015\u0001\u0006;fgR4UM\\2fIR\u0013XO\\2bi&|g\u000eK\u0002\u0010\u0003#\u000bq\u0002^3ti\u001a+gnY3e\r\u0016$8\r\u001b\u0015\u0004!\u0005E\u0015A\t;fgR,fn\u001b8po:dU-\u00193fe\u0016\u0003xn\u00195J]R\u0013XO\\2bi&|g\u000eK\u0002\u0012\u0003#\u000b1\u0005^3tiVs7N\\8x]2+\u0017\rZ3s\u000bB|7\r[,iS2,g)\u001a;dQ&tw\rK\u0002\u0013\u0003#\u000ba\u0002^3tiR\u0013XO\\2bi&|g\u000eK\u0002\u0014\u0003#\u000b1\b^3tiR\u0013XO\\2bi\u0016$v\u000eS5hQ^\u000bG/\u001a:nCJ\\\u0017J\u001a'fC\u0012,'/\u00129pG\"\u0014V-];fgRtu\u000e^*vaB|'\u000f^3eQ\r!\u0012\u0011S\u00019i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+p\u0011&<\u0007nV1uKJl\u0017M]6JM2+\u0017\rZ3s\u000bB|7\r[%oM>tu\u000e^!wC&d\u0017M\u00197fQ\r)\u0012\u0011S\u00012i\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+p\u0011&<\u0007nV1uKJl\u0017M]6EkJLgn\u001a*f[>4X\rU1si&$\u0018n\u001c8tQ\r1\u0012\u0011S\u0001%i\u0016\u001cH\u000f\u0016:v]\u000e\fG/[8o'.L\u0007\u000f]3e\u0013\u001atu.\u00129pG\"\u001c\u0005.\u00198hK\"\u001aq#!%\u0002?Q,7\u000f\u001e$pY2|w/\u001a:GKR\u001c\u0007nT;u\u001f\u001a\u0014\u0016M\\4f\u0011&<\u0007\u000eK\u0002\u0019\u0003#\u000bA\u0005^3ti\u001a+gnY3e\u001f\u001a47/\u001a;SKN,G/\u00114uKJ|U\u000f^(g%\u0006tw-\u001a\u0015\u00043\u0005E\u0015A\b;fgR4u\u000e\u001c7po\u0016\u0014h)\u001a;dQ>+Ho\u00144SC:<W\rT8xQ\rQ\u0012\u0011S\u00014i\u0016\u001cHOU3uef\fe\r^3s+:\\gn\\<o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.\u00138MCR,7\u000f^(gMN,GOR3uG\"D3aGAI\u0003I!Xm\u001d;D_J\u0014X\u000f\u001d;NKN\u001c\u0018mZ3)\u0007q\t\t*\u0001\u001cuKN$H*Z1eKJ,\u0005o\\2i\u0007\"\fgnZ3EkJLgn\u001a$f]\u000e,GMR3uG\",\u0005o\\2ig\u001a\u0013x.\u001c'fC\u0012,'\u000fK\u0002\u001e\u0003#\u000b!\b^3ti2+\u0017\rZ3s\u000bB|7\r[\"iC:<W\rR;sS:<7+^2dKN\u001ch-\u001e7GKR\u001c\u0007.\u00129pG\"\u001chI]8n\u0019\u0016\fG-\u001a:)\u0007y\t\t*\u0001\u0019uKN$H*Z1eKJ,\u0005o\\2i\u0007\"\fgnZ3EkJLgn\u001a$fi\u000eDW\t]8dQN4%o\\7MK\u0006$WM\u001d\u000b\u0005\u0003\u001f\t\u0019\u000fC\u0004\u0002f~\u0001\r!a\u001a\u0002'1,\u0017\rZ3s\u000bB|7\r[(o\u0019\u0016\fG-\u001a:\u0002gQ,7\u000f\u001e+sk:\u001c\u0017\r^3U_\u0016\u0003xn\u00195F]\u0012|eMZ:fiN$UO]5oOJ+Wn\u001c<f!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u0011\u0002\u0012\u0006yE/Z:u)J,hnY1uS>tG\u000b\u001b:poN,\u0005pY3qi&|g.\u00134MK\u0006$WM\u001d*fiV\u0014hn\u001d)beRLG/[8og:{GOU3rk\u0016\u001cH/\u001a3J]\u001a+Go\u00195Fa>\u001c\u0007n\u001d\u0015\u0004C\u0005E\u0015\u0001\u000f;fgR4U\r^2iKJ$\u0006N]3bI\"\u000bg\u000e\u001a7j]\u001e\u0004\u0016M\u001d;ji&|gNR1jYV\u0014X\rR;sS:<\u0017\t\u001d9f]\u0012Lgn\u001a\u0015\u0004E\u0005E\u0015!\u000f;fgR4U\r^2iKJ$\u0006N]3bI\"\u000bg\u000e\u001a7j]\u001e\u0004\u0016M\u001d;ji&|gNR1jYV\u0014X\rR;sS:<GK];oG\u0006$\u0018n\u001c8)\u0007\r\n\t*A\u0016wKJLg-\u001f$fi\u000eDWM\u001d+ie\u0016\fG\rS1oI2Lgn\u001a)beRLG/[8o\r\u0006LG.\u001e:f)\u0011\ty!a?\t\u000f\u0005uH\u00051\u0001\u0002\u0000\u00069a-\u001a;dQ\u0016\u0014\bc\u0001B\u0001\u00016\t\u0001AA\tN_\u000e\\g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u001c2\u0001\u0011B\u0004!\rq'\u0011B\u0005\u0004\u0005\u0017y&!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\ne\u0016\u0004H.[2b\u0013\u0012,\"!a\u001a\u0002\u0015I,\u0007\u000f\\5dC&#\u0007%\u0001\u0005mK\u0006$WM]%e\u0003%aW-\u00193fe&#\u0007\u0005\u0006\u0004\u0002\u0000\ne!1\u0004\u0005\n\u0005\u001b)\u0005\u0013!a\u0001\u0003OB\u0011Ba\u0005F!\u0003\u0005\r!a\u001a\u0002-I,\u0007\u000f\\5dCB\u000b'\u000f^5uS>t7\u000b^1uKN,\"A!\t\u0011\u000f\t\r\"\u0011F9\u0003.5\u0011!Q\u0005\u0006\u0005\u0005O\tY#A\u0004nkR\f'\r\\3\n\t\t-\"Q\u0005\u0002\u0004\u001b\u0006\u0004\bc\u0001B\u0018Q9\u0019!\u0011A\u0013\u0002#5{7m\u001b$fi\u000eDWM\u001d+ie\u0016\fG\rE\u0002\u0003\u0002\u0019\u001a\"AJ3\u0015\u0005\tM\"A\u0004)beRLG/[8o'R\fG/Z\n\u0003Q\u0015\f1\u0001\\8h+\t\u0011\t\u0005\u0005\u0004\u0003$\t\r\u0013QJ\u0005\u0005\u0005\u000b\u0012)C\u0001\u0004Ck\u001a4WM]\u0001\bY><w\fJ3r)\u0011\tyAa\u0013\t\u0013\t5#&!AA\u0002\t\u0005\u0013a\u0001=%c\u0005!An\\4!\u0003=aW-\u00193fe\u0016\u0003xn\u00195`I\u0015\fH\u0003BA\b\u0005+B\u0011B!\u0014.\u0003\u0003\u0005\r!a\u001a\u0002\u00191,\u0017\rZ3s\u000bB|7\r\u001b\u0011\u0002\u001d1|wm\u0015;beR|eMZ:fiV\u0011\u0011QL\u0001\u0013Y><7\u000b^1si>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0010\t\u0005\u0004\"\u0003B'a\u0005\u0005\t\u0019AA/\u0003=awnZ*uCJ$xJ\u001a4tKR\u0004\u0013\u0001\u00047pO\u0016sGm\u00144gg\u0016$\u0018\u0001\u00057pO\u0016sGm\u00144gg\u0016$x\fJ3r)\u0011\tyAa\u001b\t\u0013\t53'!AA\u0002\u0005u\u0013!\u00047pO\u0016sGm\u00144gg\u0016$\b%A\u0007iS\u001eDw+\u0019;fe6\f'o[\u0001\u0012Q&<\u0007nV1uKJl\u0017M]6`I\u0015\fH\u0003BA\b\u0005kB\u0011B!\u00147\u0003\u0003\u0005\r!!\u0018\u0002\u001d!Lw\r[,bi\u0016\u0014X.\u0019:lAQa!1\u0010B@\u0005\u0003\u0013\u0019I!\"\u0003\bB\u0019!Q\u0010\u0015\u000e\u0003\u0019BqA!\u00109\u0001\u0004\u0011\t\u0005C\u0004\u0002fa\u0002\r!a\u001a\t\u000f\te\u0003\b1\u0001\u0002^!9!Q\r\u001dA\u0002\u0005u\u0003b\u0002B8q\u0001\u0007\u0011QL\u0001\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f!\r\u0011iHO\n\u0003u\u0015$\"Aa#\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\tm$Q\u0013BU\u0005WCqA!\u0010=\u0001\u0004\u00119\n\u0005\u0004\u0003\u001a\n\r\u0016Q\n\b\u0005\u00057\u0013yJ\u0004\u0003\u0002:\tu\u0015\"\u00015\n\u0007\t\u0005v-A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0015&q\u0015\u0002\u0004'\u0016\f(b\u0001BQO\"9\u0011Q\r\u001fA\u0002\u0005\u001d\u0004b\u0002B8y\u0001\u0007\u0011Q\f\u000b\u0005\u0005w\u0012y\u000bC\u0004\u0002fu\u0002\r!a\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)L\u000b\u0003\u0002h\t]6F\u0001B]!\u0011\u0011YL!2\u000e\u0005\tu&\u0002\u0002B`\u0005\u0003\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\rw-\u0001\u0006b]:|G/\u0019;j_:LAAa2\u0003>\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003]\u0011X\r\u001d7jG\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001c\b%A\u000bmK\u0006$WM\u001d)beRLG/[8o'R\fG/Z:\u0002-1,\u0017\rZ3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fg\u0002\nab]3u\u0019\u0016\fG-\u001a:Ti\u0006$X\r\u0006\u0004\u0002\u0010\tU'\u0011\u001c\u0005\u0007\u0005/T\u0005\u0019A9\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9!1\u001c&A\u0002\t5\u0012!B:uCR,\u0017aD:fiJ+\u0007\u000f\\5dCN#\u0018\r^3\u0015\r\u0005=!\u0011\u001dBr\u0011\u0019\u00119n\u0013a\u0001c\"9!1\\&A\u0002\t5\u0012!\u0006:fa2L7-\u0019)beRLG/[8o'R\fG/\u001a\u000b\u0005\u0005[\u0011I\u000f\u0003\u0004\u0003X2\u0003\r!]\u0001\u0015Y\u0016\fG-\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\t\t5\"q\u001e\u0005\u0007\u0005/l\u0005\u0019A9\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)!\u0011)p!\u0002\u0004\b\r%\u0001#\u00024\u0003x\nm\u0018b\u0001B}O\n1q\n\u001d;j_:\u0004BA!@\u0004\u00025\u0011!q \u0006\u0004\u0005{\t\u0017\u0002BB\u0002\u0005\u007f\u0014Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007B\u0002Bl\u001d\u0002\u0007\u0011\u000fC\u0004\u0002\n:\u0003\r!!\u0018\t\u000f\r-a\n1\u0001\u0004\u000e\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004Baa\u0004\u0004\u00125\t\u0001)\u0003\u0003\u0004\u0014\t%!!\u0003$fi\u000eDG)\u0019;b\u0003!!(/\u001e8dCR,GCBA\b\u00073\u0019Y\u0002\u0003\u0004\u0003X>\u0003\r!\u001d\u0005\b\u0007;y\u0005\u0019AB\u0010\u0003=!(/\u001e8dCRLwN\\*uCR,\u0007c\u00018\u0004\"%\u001911E0\u0003+=3gm]3u)J,hnY1uS>t7\u000b^1uK\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0007\u0003\u001f\u0019Ica\u000b\t\r\t]\u0007\u000b1\u0001r\u0011\u001d\u0019i\u0003\u0015a\u0001\u0003;\naa\u001c4gg\u0016$\u0018A\u00032vS2$g)\u001a;dQR!11GB)!\u0019\u0019)da\u0011\u0004J9!1qGB \u001d\u0011\u0019Id!\u0010\u000f\t\u0005e21H\u0005\u0002E&\u0011\u0001-Y\u0005\u0004\u0007\u0003z\u0016!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u0005\u0007\u000b\u001a9E\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn\u001d\u0006\u0004\u0007\u0003z\u0006#\u00024\u0003x\u000e-\u0003\u0003BB\u001b\u0007\u001bJAaa\u0014\u0004H\ta!+\u001a9mS\u000e\fg)\u001a;dQ\"911K)A\u0002\rU\u0013\u0001\u00049beRLG/[8o\u001b\u0006\u0004\bcBA\u0015\u0007/\n8\u0011L\u0005\u0005\u0005W\tY\u0003E\u0002o\u00077J1a!\u0018`\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\t\r\r4Q\r\t\u0006M\n]\u0018q\r\u0005\u0007\u0005/\u0014\u0006\u0019A9\u0015\t\u0005u3\u0011\u000e\u0005\u0007\u0005/\u001c\u0006\u0019A9\u0015\t\u0005u3Q\u000e\u0005\u0007\u0005/$\u0006\u0019A9\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0004t\rU4q\u000f\t\u0006M\n]\u0018\u0011\u0011\u0005\u0007\u0005/,\u0006\u0019A9\t\u000f\reT\u000b1\u0001\u0002h\u0005)Q\r]8dQ\u0006A2\r[3dW\u0016C\b/Z2uK\u0012dU-\u00193fe\u0016\u0003xn\u00195\u0015\r\r}4QRBW!\u00151'q_BA!\u0011\u0019\u0019i!#\u000e\u0005\r\u0015%bABDg\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0004\f\u000e\u0015%AB#se>\u00148\u000fC\u0004\u0004\u0010Z\u0003\ra!%\u0002!\u0015D\b/Z2uK\u0012,\u0005o\\2i\u001fB$\bCBBJ\u0007;\u001b\t+\u0004\u0002\u0004\u0016*!1qSBM\u0003\u0011)H/\u001b7\u000b\u0005\rm\u0015\u0001\u00026bm\u0006LAaa(\u0004\u0016\nAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0004$\u000e%VBABS\u0015\u0011\u00199k!'\u0002\t1\fgnZ\u0005\u0005\u0007W\u001b)KA\u0004J]R,w-\u001a:\t\u000f\r=f\u000b1\u0001\u0003.\u0005q\u0001/\u0019:uSRLwN\\*uCR,\u0017a\u00067p_.,\b/\u00128e\u001f\u001a47/\u001a;G_J,\u0005o\\2i)\u0019\u0019)l!1\u0004LB!1qWB_\u001b\t\u0019ILC\u0002\u0004<N\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0007\u007f\u001bIL\u0001\bFa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;\t\u000f\r\rw\u000b1\u0001\u0004F\u0006IQ\r]8dQ\u0012\u000bG/\u0019\t\u0005\u0007\u001f\u00199-\u0003\u0003\u0004J\n%!!C#q_\u000eDG)\u0019;b\u0011\u001d\u0019yk\u0016a\u0001\u0005[\tACZ3uG\",\u0005o\\2i\u000b:$wJ\u001a4tKR\u001cH\u0003BBi\u0007'\u0004r!!\u000b\u0004XE\u001c)\fC\u0004\u0004Vb\u0003\raa6\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0004\u0002*\r]\u0013o!2\u0002?%\u001cxJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0004^B\u0019ama8\n\u0007\r\u0005xMA\u0004C_>dW-\u00198\u0002\u001f\u0019,Go\u00195Ge>lG*Z1eKJ$Baa:\u0004jB9\u0011\u0011FB,c\u000e5\u0001bBBv5\u0002\u00071Q^\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0007_\u001c)P\u0004\u0003\u00048\u000eE\u0018\u0002BBz\u0007s\u000bABR3uG\"\u0014V-];fgRLAaa>\u0004z\n9!)^5mI\u0016\u0014(\u0002BBz\u0007s\u000b\u0001d\u00195fG.dU-\u00193fe\u0016\u0003xn\u00195B]\u0012$\u0006N]8x)\u0019\tyaa@\u0005\u0004!9A\u0011A.A\u0002\u0005\u001d\u0014!D3ya\u0016\u001cG/\u001a3Fa>\u001c\u0007\u000eC\u0004\u00040n\u0003\rA!\f\u0002;\u0019,Go\u00195FCJd\u0017.Z:u\u001f\u001a47/\u001a;Ge>lG*Z1eKJ$b!!\u0018\u0005\n\u0011-\u0001B\u0002Bl9\u0002\u0007\u0011\u000fC\u0004\u0002fq\u0003\r!a\u001a\u00027\u0019,Go\u00195MCR,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\ti\u0006\"\u0005\u0005\u0014!1!q[/A\u0002EDq!!\u001a^\u0001\u0004\t9\u0007")
public class AbstractFetcherThreadTest {
    private volatile AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread$module;
    private final TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic2", 0);
    private final FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions = new FailedPartitions();

    public AbstractFetcherThreadTest$MockFetcherThread$ MockFetcherThread() {
        if (this.MockFetcherThread$module == null) {
            this.MockFetcherThread$lzycompute$1();
        }
        return this.MockFetcherThread$module;
    }

    public TopicPartition kafka$server$AbstractFetcherThreadTest$$partition1() {
        return this.kafka$server$AbstractFetcherThreadTest$$partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    public FailedPartitions kafka$server$AbstractFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$AbstractFetcherThreadTest$$failedPartitions;
    }

    @Before
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Set<String> allMetricsNames() {
        return (Set)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), Set$.MODULE$.canBuildFrom());
    }

    private RecordBatch mkBatch(long baseOffset, int leaderEpoch, Seq<SimpleRecord> records) {
        return (RecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(MemoryRecords.withRecords((long)baseOffset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(leaderEpoch), (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))).batches()).asScala()).head();
    }

    public OffsetAndEpoch kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetricsRemovedOnShutdown() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.start();
        scala.collection.immutable.Set brokerTopicStatsMetrics = fetcher.brokerTopicStats().allTopicsStats().metricMap().keySet();
        Set fetcherMetrics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{FetcherMetrics$.MODULE$.BytesPerSec(), FetcherMetrics$.MODULE$.RequestsPerSec(), FetcherMetrics$.MODULE$.ConsumerLag()}));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testMetricsRemovedOnShutdown$1(this, brokerTopicStatsMetrics, fetcherMetrics)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(AbstractFetcherThreadTest.$anonfun$testMetricsRemovedOnShutdown$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        fetcher.shutdown();
        scala.collection.immutable.Set metricNames = ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Set$.MODULE$.canBuildFrom())).toSet();
        Assert.assertTrue((boolean)((SetLike)metricNames.intersect((GenSet)fetcherMetrics)).isEmpty());
        Assert.assertEquals((Object)brokerTopicStatsMetrics, (Object)metricNames.intersect((GenSet)brokerTopicStatsMetrics));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerLagRemovedWithPartition() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        fetcher.doWork();
        Assert.assertTrue((String)"Failed waiting for consumer lag metric", (boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
        Assert.assertFalse((boolean)this.allMetricsNames().apply((Object)FetcherMetrics$.MODULE$.ConsumerLag()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSimpleFetch() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)2L, (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencedTruncation() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        RecordBatch batch = this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assert.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencedFetch() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(0);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assert.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnknownLeaderEpochInTruncation() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Option option = fetcher.fetchState(partition);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this.get()).state());
        Assert.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)object2);
        MockFetcherThread.PartitionState partitionState = fetcher.leaderPartitionState(partition);
        partitionState.leaderEpoch_$eq(partitionState.leaderEpoch() + 1);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Option option2 = fetcher.fetchState(partition);
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object3 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this2.get()).state());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)object3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnknownLeaderEpochWhileFetching() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(1);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())}))}))), 1, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Option option = fetcher.fetchState(partition);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this.get()).state());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)object2);
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(0);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Option option2 = fetcher.fetchState(partition);
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object3 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this2.get()).state());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)object3);
        fetcher.leaderPartitionState(partition).leaderEpoch_$eq(1);
        fetcher.doWork();
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
        Option option3 = fetcher.fetchState(partition);
        if (option3 == null) {
            throw null;
        }
        Option map_this3 = option3;
        Object object4 = map_this3.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this3.get()).state());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)object4);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncation() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, 0L);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testTruncation$1(fetcher, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(AbstractFetcherThreadTest.$anonfun$testTruncation$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochRequestNotSupported() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$1, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public boolean isOffsetForLeaderEpochSupported() {
                return false;
            }
            {
                this.highWatermark$1 = highWatermark$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateToHighWatermarkIfLeaderEpochInfoNotAvailable() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, highWatermark){
            private final long highWatermark$2;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                Assert.assertEquals((long)this.highWatermark$2, (long)truncationState.offset());
                Assert.assertTrue((boolean)truncationState.truncationCompleted());
                super.truncate(topicPartition, truncationState);
            }

            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                throw new UnsupportedOperationException();
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.highWatermark$2 = highWatermark$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        fetcher.doWork();
        Assert.assertEquals((long)highWatermark, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)highWatermark, (long)((PartitionFetchState)fetcher.fetchState(partition).get()).fetchOffset());
        Assert.assertTrue((boolean)((PartitionFetchState)fetcher.fetchState(partition).get()).isReadyForFetch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateToHighWatermarkDuringRemovePartitions() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        long highWatermark = 2L;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, partition){
            private final TopicPartition partition$2;

            public void truncateToHighWatermark(Set<TopicPartition> partitions) {
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$2})));
                super.truncateToHighWatermark(partitions);
            }

            public Option<Object> latestEpoch(TopicPartition topicPartition) {
                return None$.MODULE$;
            }
            {
                this.partition$2 = partition$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 5, highWatermark);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(highWatermark, 5);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        fetcher.doWork();
        Assert.assertEquals((long)((RecordBatch)replicaLog.last()).nextOffset(), (long)replicaState.logEndOffset());
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncationSkippedIfNoEpochChange() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        TopicPartition partition = new TopicPartition("topic", 0);
        IntRef truncations = IntRef.create((int)0);
        MockFetcherThread fetcher = new MockFetcherThread(this, truncations){
            private final IntRef truncations$1;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                ++this.truncations$1.elem;
                super.truncate(topicPartition, truncationState);
            }
            {
                this.truncations$1 = truncations$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply(5);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 5);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 1, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 3, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 5, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 5, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)1L, (long)truncations.elem);
        Tuple2[] tuple2Array2 = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch2 = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 5);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        fetcher.doWork();
        Assert.assertEquals((long)1L, (long)truncations.elem);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerFetchOutOfRangeHigh() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 4);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())})), this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)3L, (long)replicaState.logEndOffset());
        Option option = fetcher.fetchState(partition);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this.get()).state());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)object2);
        leaderState.log().clear();
        leaderState.logEndOffset_$eq(0L);
        leaderState.logStartOffset_$eq(0L);
        leaderState.highWatermark_$eq(0L);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertEquals((long)0L, (long)replicaState.logStartOffset());
        Assert.assertEquals((long)0L, (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencedOffsetResetAfterOutOfRange() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        BooleanRef fetchedEarliestOffset = BooleanRef.create((boolean)false);
        MockFetcherThread fetcher = new MockFetcherThread(this, fetchedEarliestOffset){
            private final BooleanRef fetchedEarliestOffset$1;

            public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                this.fetchedEarliestOffset$1.elem = true;
                throw new FencedLeaderEpochException(new StringBuilder(16).append("Epoch ").append(leaderEpoch).append(" is fenced").toString());
            }
            {
                this.fetchedEarliestOffset$1 = fetchedEarliestOffset$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 4, 0L);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 4);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(1L, 2, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())})), this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 4, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Assert.assertEquals((long)0L, (long)replicaState.logEndOffset());
        Assert.assertTrue((boolean)fetchedEarliestOffset.elem);
        Assert.assertTrue((boolean)fetcher.fetchState(partition).isEmpty());
        Assert.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(partition));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerFetchOutOfRangeLow() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this, this.MockFetcherThread().$lessinit$greater$default$1(), this.MockFetcherThread().$lessinit$greater$default$2());
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Option option = fetcher.fetchState(partition);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this.get()).state());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)object2);
        Assert.assertEquals((long)2L, (long)replicaState.logStartOffset());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)replicaState.log().toList());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testFollowerFetchOutOfRangeLow$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(AbstractFetcherThreadTest.$anonfun$testFollowerFetchOutOfRangeLow$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryAfterUnknownLeaderEpochInLatestOffsetFetch() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private final AtomicInteger tries;

            private AtomicInteger tries() {
                return this.tries;
            }

            public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
                if (this.tries().getAndIncrement() == 0) {
                    throw new UnknownLeaderEpochException("Unexpected leader epoch");
                }
                return super.fetchLatestOffsetFromLeader(topicPartition, leaderEpoch);
            }
            {
                this.tries = new AtomicInteger(0);
            }
        };
        Seq replicaLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))}));
        MockFetcherThread.PartitionState replicaState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)replicaLog, 0, 0L);
        fetcher.setReplicaState(partition, replicaState);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(3L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(2L, 4, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Option option = fetcher.fetchState(partition);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this.get()).state());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)object2);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractFetcherThreadTest.$anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$2(fetcher, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(AbstractFetcherThreadTest.$anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertEquals((long)leaderState.logStartOffset(), (long)replicaState.logStartOffset());
        Assert.assertEquals((long)leaderState.logEndOffset(), (long)replicaState.logEndOffset());
        Assert.assertEquals((long)leaderState.highWatermark(), (long)replicaState.highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptMessage() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){
            private boolean fetchedOnce;

            public boolean fetchedOnce() {
                return this.fetchedOnce;
            }

            public void fetchedOnce_$eq(boolean x$1) {
                this.fetchedOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
                void var2_2;
                Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchedData = super.fetchFromLeader(fetchRequest);
                if (!this.fetchedOnce()) {
                    ByteBuffer buffer = ((MemoryRecords)((FetchResponse.PartitionData)((Tuple2)fetchedData.head())._2()).records).buffer();
                    buffer.putInt(15, buffer.getInt(15) ^ 0x5B7E);
                    buffer.putInt(30, buffer.getInt(30) ^ 0x16C3A);
                    this.fetchedOnce_$eq(true);
                }
                return var2_2;
            }
            {
                this.fetchedOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        RecordBatch batch = this.mkBatch(0L, 0, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}))), 0, 2L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        fetcher.doWork();
        MockFetcherThread.PartitionState replicaState = fetcher.replicaPartitionState(partition);
        Assert.assertEquals((long)2L, (long)replicaState.logEndOffset());
    }

    @Test
    public void testLeaderEpochChangeDuringFencedFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(1);
    }

    @Test
    public void testLeaderEpochChangeDuringSuccessfulFetchEpochsFromLeader() {
        this.testLeaderEpochChangeDuringFetchEpochsFromLeader(0);
    }

    /*
     * WARNING - void declaration
     */
    private void testLeaderEpochChangeDuringFetchEpochsFromLeader(int leaderEpochOnLeader) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockFetcherThread fetcher = new MockFetcherThread(this, partition, nextLeaderEpochOnFollower){
            private boolean fetchEpochsFromLeaderOnce;
            private final /* synthetic */ AbstractFetcherThreadTest $outer;
            private final TopicPartition partition$5;
            private final int nextLeaderEpochOnFollower$1;

            public boolean fetchEpochsFromLeaderOnce() {
                return this.fetchEpochsFromLeaderOnce;
            }

            public void fetchEpochsFromLeaderOnce_$eq(boolean x$1) {
                this.fetchEpochsFromLeaderOnce = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                void var2_2;
                Map<TopicPartition, EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                if (!this.fetchEpochsFromLeaderOnce()) {
                    void $minus$greater$extension_y;
                    void $minus$greater$extension_$this;
                    this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$5})));
                    this.setReplicaState(this.partition$5, this.$outer.MockFetcherThread().PartitionState().apply(this.nextLeaderEpochOnFollower$1));
                    Tuple2[] tuple2Array = new Tuple2[1];
                    OffsetAndEpoch offsetAndEpoch = this.$outer.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, this.nextLeaderEpochOnFollower$1);
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)this.partition$5);
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    this.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
                    this.fetchEpochsFromLeaderOnce_$eq(true);
                }
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$5 = partition$5;
                this.nextLeaderEpochOnFollower$1 = nextLeaderEpochOnFollower$1;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
                this.fetchEpochsFromLeaderOnce = false;
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(initialLeaderEpochOnFollower));
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, initialLeaderEpochOnFollower);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Option option = fetcher.fetchState(partition);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this.get()).state());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)object2);
        Option option2 = fetcher.fetchState(partition);
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object3 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionFetchState)map_this2.get()).currentLeaderEpoch()));
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)nextLeaderEpochOnFollower)), (Object)object3);
        if (leaderEpochOnLeader < nextLeaderEpochOnFollower) {
            fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L));
        }
        fetcher.doWork();
        Assert.assertEquals(fetcher.leaderPartitionState(partition).log(), fetcher.replicaPartitionState(partition).log());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateToEpochEndOffsetsDuringRemovePartitions() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        int leaderEpochOnLeader = 0;
        int initialLeaderEpochOnFollower = 0;
        int nextLeaderEpochOnFollower = initialLeaderEpochOnFollower + 1;
        MockFetcherThread fetcher = new MockFetcherThread(this, partition, nextLeaderEpochOnFollower){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;
            private final TopicPartition partition$6;
            private final int nextLeaderEpochOnFollower$2;

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                void var2_2;
                Map<TopicPartition, EpochEndOffset> fetchedEpochs = super.fetchEpochEndOffsets(partitions);
                this.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition$6})));
                this.setReplicaState(this.partition$6, this.$outer.MockFetcherThread().PartitionState().apply(this.nextLeaderEpochOnFollower$2));
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$6 = partition$6;
                this.nextLeaderEpochOnFollower$2 = nextLeaderEpochOnFollower$2;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(initialLeaderEpochOnFollower));
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, initialLeaderEpochOnFollower);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Seq leaderLog = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{this.mkBatch(0L, initialLeaderEpochOnFollower, (Seq<SimpleRecord>)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}))}));
        MockFetcherThread.PartitionState leaderState = this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, leaderEpochOnLeader, 0L);
        fetcher.setLeaderState(partition, leaderState);
        fetcher.doWork();
        Option option = fetcher.fetchState(partition);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this.get()).state());
        Assert.assertEquals((Object)None$.MODULE$, (Object)object2);
        Option option2 = fetcher.fetchState(partition);
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object3 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionFetchState)map_this2.get()).currentLeaderEpoch()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)object3);
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply((Seq<RecordBatch>)leaderLog, nextLeaderEpochOnFollower, 0L));
        fetcher.doWork();
        Assert.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), fetcher.replicaPartitionState(partition).log());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncationThrowsExceptionIfLeaderReturnsPartitionsNotRequestedInFetchEpochs() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        TopicPartition partition = new TopicPartition("topic", 0);
        MockFetcherThread fetcher = new MockFetcherThread(this){

            /*
             * WARNING - void declaration
             */
            public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                TopicPartition unrequestedTp = new TopicPartition("topic2", 0);
                EpochEndOffset epochEndOffset = new EpochEndOffset(0, 0L);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)unrequestedTp);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                return super.fetchEpochEndOffsets(partitions).$plus(new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y));
            }
        };
        fetcher.setReplicaState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        fetcher.setLeaderState(partition, this.MockFetcherThread().PartitionState().apply(0));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fetcher.doWork(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("AbstractFetcherThreadTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringAppending() {
        MockFetcherThread fetcherForAppend = new MockFetcherThread(this){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new KafkaException();
                }
                return super.processPartitionData(topicPartition, fetchOffset, partitionData);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForAppend);
    }

    @Test
    public void testFetcherThreadHandlingPartitionFailureDuringTruncation() {
        MockFetcherThread fetcherForTruncation = new MockFetcherThread(this){
            private final /* synthetic */ AbstractFetcherThreadTest $outer;

            public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
                TopicPartition topicPartition2 = topicPartition;
                TopicPartition topicPartition3 = this.$outer.kafka$server$AbstractFetcherThreadTest$$partition1();
                if (!(topicPartition2 != null ? !topicPartition2.equals(topicPartition3) : topicPartition3 != null)) {
                    throw new Exception();
                }
                super.truncate(topicPartition, truncationState);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer, $outer.MockFetcherThread().$lessinit$greater$default$1(), $outer.MockFetcherThread().$lessinit$greater$default$2());
            }
        };
        this.verifyFetcherThreadHandlingPartitionFailure(fetcherForTruncation);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyFetcherThreadHandlingPartitionFailure(MockFetcherThread fetcher) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        fetcher.setReplicaState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), this.MockFetcherThread().PartitionState().apply(0));
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        fetcher.setLeaderState(this.kafka$server$AbstractFetcherThreadTest$$partition1(), this.MockFetcherThread().PartitionState().apply(0));
        fetcher.setReplicaState(this.partition2(), this.MockFetcherThread().PartitionState().apply(0));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch2 = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 0);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.partition2());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        fetcher.setLeaderState(this.partition2(), this.MockFetcherThread().PartitionState().apply(0));
        fetcher.doWork();
        Assert.assertTrue((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
        fetcher.doWork();
        Option option = fetcher.fetchState(this.partition2());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object3 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this.get()).state());
        Assert.assertEquals((Object)new Some((Object)Fetching$.MODULE$), (Object)object3);
        Assert.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.partition2()));
        fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().removeAll((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.kafka$server$AbstractFetcherThreadTest$$partition1()})));
        Tuple2[] tuple2Array3 = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch3 = this.kafka$server$AbstractFetcherThreadTest$$offsetAndEpoch(0L, 1);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.kafka$server$AbstractFetcherThreadTest$$partition1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        fetcher.addPartitions((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)));
        Option option2 = fetcher.fetchState(this.kafka$server$AbstractFetcherThreadTest$$partition1());
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object5 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)((PartitionFetchState)map_this2.get()).state());
        Assert.assertEquals((Object)new Some((Object)Truncating$.MODULE$), (Object)object5);
        Assert.assertFalse((boolean)this.kafka$server$AbstractFetcherThreadTest$$failedPartitions().contains(this.kafka$server$AbstractFetcherThreadTest$$partition1()));
    }

    private final void MockFetcherThread$lzycompute$1() {
        synchronized (this) {
            if (this.MockFetcherThread$module == null) {
                this.MockFetcherThread$module = new AbstractFetcherThreadTest$MockFetcherThread$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsRemovedOnShutdown$1(AbstractFetcherThreadTest $this, scala.collection.immutable.Set brokerTopicStatsMetrics$1, Set fetcherMetrics$1) {
        Set<String> set = $this.allMetricsNames();
        Set set2 = brokerTopicStatsMetrics$1.$plus$plus((GenTraversableOnce)fetcherMetrics$1);
        return !(set != null ? !set.equals((Object)set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testMetricsRemovedOnShutdown$2() {
        return "Failed waiting for all fetcher metrics to be registered";
    }

    public static final /* synthetic */ boolean $anonfun$testTruncation$1(MockFetcherThread fetcher$1, TopicPartition partition$1) {
        fetcher$1.doWork();
        Buffer<RecordBatch> buffer = fetcher$1.replicaPartitionState(partition$1).log();
        Buffer<RecordBatch> buffer2 = fetcher$1.leaderPartitionState(partition$1).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTruncation$2() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testFollowerFetchOutOfRangeLow$2(MockFetcherThread fetcher$2, TopicPartition partition$3) {
        fetcher$2.doWork();
        Buffer<RecordBatch> buffer = fetcher$2.replicaPartitionState(partition$3).log();
        Buffer<RecordBatch> buffer2 = fetcher$2.leaderPartitionState(partition$3).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFollowerFetchOutOfRangeLow$3() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ boolean $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$2(MockFetcherThread fetcher$3, TopicPartition partition$4) {
        fetcher$3.doWork();
        Buffer<RecordBatch> buffer = fetcher$3.replicaPartitionState(partition$4).log();
        Buffer<RecordBatch> buffer2 = fetcher$3.leaderPartitionState(partition$4).log();
        return !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
    }

    public static final /* synthetic */ String $anonfun$testRetryAfterUnknownLeaderEpochInLatestOffsetFetch$3() {
        return "Failed to reconcile leader and follower logs";
    }

    public static final /* synthetic */ Object $anonfun$testLeaderEpochChangeDuringFetchEpochsFromLeader$2$adapted(PartitionFetchState x$12) {
        return BoxesRunTime.boxToInteger((int)x$12.currentLeaderEpoch());
    }

    public static final /* synthetic */ Object $anonfun$testTruncateToEpochEndOffsetsDuringRemovePartitions$2$adapted(PartitionFetchState x$14) {
        return BoxesRunTime.boxToInteger((int)x$14.currentLeaderEpoch());
    }

    public class MockFetcherThread
    extends AbstractFetcherThread {
        private final int replicaId;
        private final int leaderId;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
        private final scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates;
        public final /* synthetic */ AbstractFetcherThreadTest $outer;

        public int replicaId() {
            return this.replicaId;
        }

        public int leaderId() {
            return this.leaderId;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
            return this.replicaPartitionStates;
        }

        private scala.collection.mutable.Map<TopicPartition, PartitionState> leaderPartitionStates() {
            return this.leaderPartitionStates;
        }

        public void setLeaderState(TopicPartition topicPartition, PartitionState state) {
            this.leaderPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
            this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
        }

        public PartitionState replicaPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
            });
        }

        public PartitionState leaderPartitionState(TopicPartition topicPartition) {
            return (PartitionState)this.leaderPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(18).append("Unknown partition ").append(topicPartition).toString());
            });
        }

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            if (fetchOffset != state.logEndOffset()) {
                throw new RuntimeException(new StringBuilder(69).append("Offset mismatch for partition ").append(topicPartition).append(": ").append("fetched offset = ").append(fetchOffset).append(", log end offset = ").append(state.logEndOffset()).append(".").toString());
            }
            Iterable batches = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((Records)partitionData.records).batches()).asScala();
            LongRef maxTimestamp = LongRef.create((long)-1L);
            LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
            LongRef lastOffset = LongRef.create((long)state.logEndOffset());
            batches.foreach((Function1 & Serializable & scala.Serializable)batch -> {
                MockFetcherThread.$anonfun$processPartitionData$1(maxTimestamp, offsetOfMaxTimestamp, state, lastOffset, batch);
                return BoxedUnit.UNIT;
            });
            state.logStartOffset_$eq(partitionData.logStartOffset);
            state.highWatermark_$eq(partitionData.highWatermark);
            Option option = batches.headOption();
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((RecordBatch)map_this.get()).lastOffset()));
            if (object == null) {
                throw null;
            }
            Object object2 = object.isEmpty() ? BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$processPartitionData$3()) : object.get();
            return new Some((Object)new LogAppendInfo((Option)new Some((Object)BoxesRunTime.boxToLong((long)fetchOffset)), lastOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordConversionStats.EMPTY, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, batches.size(), partitionData.records.sizeInBytes(), true, BoxesRunTime.unboxToLong((Object)object2), LogAppendInfo$.MODULE$.apply$default$14(), LogAppendInfo$.MODULE$.apply$default$15()));
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
            Option option = state.log().lastOption();
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2((RecordBatch)map_this.get())));
            if (object == null) {
                throw null;
            }
            Object object2 = object.isEmpty() ? BoxesRunTime.boxToLong((long)state.logStartOffset()) : object.get();
            state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)object2));
            state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
            PartitionState state = this.replicaPartitionState(topicPartition);
            state.log().clear();
            state.logStartOffset_$eq(offset);
            state.logEndOffset_$eq(offset);
            state.highWatermark_$eq(offset);
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            scala.collection.mutable.Map fetchData = Map$.MODULE$.empty();
            partitionMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                if (x0$1 != null) {
                    TopicPartition partition = (TopicPartition)x0$1._1();
                    PartitionFetchState state = (PartitionFetchState)x0$1._2();
                    if (state.isReadyForFetch()) {
                        PartitionState replicaState = this.replicaPartitionState(partition);
                        boxedUnit = fetchData.put((Object)partition, (Object)new FetchRequest.PartitionData(state.fetchOffset(), replicaState.logStartOffset(), 0x100000, Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch()))));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError(null);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            FetchRequest.Builder fetchRequest = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)1, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(fetchData).asJava()));
            return new AbstractFetcherThread.ResultWithPartitions((Object)new Some((Object)new AbstractFetcherThread.ReplicaFetch((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(fetchData).asJava(), fetchRequest)), Set$.MODULE$.empty());
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            Option option = this.replicaPartitionState(topicPartition).log().lastOption();
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((RecordBatch)map_this.get()).partitionLeaderEpoch()));
            if (object == null) {
                throw null;
            }
            Object object2 = object.isEmpty() ? MockFetcherThread.$anonfun$latestEpoch$2() : object;
            return object2;
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return this.replicaPartitionState(topicPartition).logStartOffset();
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return this.replicaPartitionState(topicPartition).logEndOffset();
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            OffsetsForLeaderEpochRequest.PartitionData epochData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), epoch);
            EpochEndOffset result = this.lookupEndOffsetForEpoch(epochData, this.replicaPartitionState(topicPartition));
            if (result.endOffset() == -1L) {
                return None$.MODULE$;
            }
            return new Some((Object)new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
        }

        private Option<Errors> checkExpectedLeaderEpoch(Optional<Integer> expectedEpochOpt, PartitionState partitionState) {
            if (expectedEpochOpt.isPresent()) {
                Integer expectedEpoch = expectedEpochOpt.get();
                if (Predef$.MODULE$.Integer2int(expectedEpoch) < partitionState.leaderEpoch()) {
                    return new Some((Object)Errors.FENCED_LEADER_EPOCH);
                }
                if (Predef$.MODULE$.Integer2int(expectedEpoch) > partitionState.leaderEpoch()) {
                    return new Some((Object)Errors.UNKNOWN_LEADER_EPOCH);
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }

        private EpochEndOffset lookupEndOffsetForEpoch(OffsetsForLeaderEpochRequest.PartitionData epochData, PartitionState partitionState) {
            Object object = new Object();
            try {
                Option<Errors> option = this.checkExpectedLeaderEpoch(epochData.currentLeaderEpoch, partitionState);
                if (option == null) {
                    throw null;
                }
                Option<Errors> foreach_this = option;
                if (!foreach_this.isEmpty()) {
                    Errors errors = (Errors)foreach_this.get();
                    throw MockFetcherThread.$anonfun$lookupEndOffsetForEpoch$1(object, errors);
                }
                IntRef epochLowerBound = IntRef.create((int)-1);
                partitionState.log().foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    MockFetcherThread.$anonfun$lookupEndOffsetForEpoch$2(epochData, object, epochLowerBound, batch);
                    return BoxedUnit.UNIT;
                });
                return new EpochEndOffset(Errors.NONE, -1, -1L);
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    return (EpochEndOffset)ex.value();
                }
                throw ex;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
            void var2_2;
            scala.collection.mutable.Map endOffsets = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition partition = (TopicPartition)x0$1._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)x0$1._2();
                PartitionState leaderState = this.leaderPartitionState(partition);
                EpochEndOffset epochEndOffset = this.lookupEndOffsetForEpoch(epochData, leaderState);
                Option option = endOffsets.put((Object)partition, (Object)epochEndOffset);
                return option;
            });
            return var2_2;
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return true;
        }

        public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchRequest.fetchData()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void var12_12;
                void var11_11;
                MemoryRecords memoryRecords;
                Object object;
                PartitionState leaderState;
                TopicPartition partition;
                if (x0$1 != null) {
                    partition = (TopicPartition)x0$1._1();
                    FetchRequest.PartitionData fetchData = (FetchRequest.PartitionData)x0$1._2();
                    leaderState = this.leaderPartitionState(partition);
                    Option<Errors> epochCheckError = this.checkExpectedLeaderEpoch(fetchData.currentLeaderEpoch, leaderState);
                    if (epochCheckError.isDefined()) {
                        object = epochCheckError.get();
                        memoryRecords = MemoryRecords.EMPTY;
                    } else if (fetchData.fetchOffset > leaderState.logEndOffset() || fetchData.fetchOffset < leaderState.logStartOffset()) {
                        object = Errors.OFFSET_OUT_OF_RANGE;
                        memoryRecords = MemoryRecords.EMPTY;
                    } else {
                        MemoryRecords memoryRecords2;
                        Option option = leaderState.log().find((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$fetchFromLeader$2(fetchData, x$22)));
                        if (option instanceof Some) {
                            RecordBatch batch = (RecordBatch)((Some)option).value();
                            ByteBuffer buffer = ByteBuffer.allocate(batch.sizeInBytes());
                            batch.writeTo(buffer);
                            buffer.flip();
                            memoryRecords2 = MemoryRecords.readableRecords((ByteBuffer)buffer);
                        } else if (None$.MODULE$.equals(option)) {
                            memoryRecords2 = MemoryRecords.EMPTY;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        object = Errors.NONE;
                        memoryRecords = memoryRecords2;
                    }
                } else {
                    throw new MatchError(null);
                }
                MemoryRecords memoryRecords3 = memoryRecords;
                Errors error = (Errors)object;
                MemoryRecords records = memoryRecords3;
                Tuple2 tuple2 = new Tuple2((Object)partition, (Object)new FetchResponse.PartitionData((Errors)var11_11, leaderState.highWatermark(), leaderState.highWatermark(), leaderState.logStartOffset(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava(), (BaseRecords)var12_12));
                return tuple2;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }

        private void checkLeaderEpochAndThrow(int expectedEpoch, PartitionState partitionState) {
            Option<Errors> option = this.checkExpectedLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(expectedEpoch)), partitionState);
            if (option == null) {
                throw null;
            }
            Option<Errors> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                throw MockFetcherThread.$anonfun$checkLeaderEpochAndThrow$1((Errors)foreach_this.get());
            }
        }

        public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logStartOffset();
        }

        public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
            PartitionState leaderState = this.leaderPartitionState(topicPartition);
            this.checkLeaderEpochAndThrow(leaderEpoch, leaderState);
            return leaderState.logEndOffset();
        }

        public /* synthetic */ AbstractFetcherThreadTest kafka$server$AbstractFetcherThreadTest$MockFetcherThread$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$processPartitionData$1(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, PartitionState state$1, LongRef lastOffset$1, RecordBatch batch) {
            batch.ensureValid();
            if (batch.maxTimestamp() > maxTimestamp$1.elem) {
                maxTimestamp$1.elem = batch.maxTimestamp();
                offsetOfMaxTimestamp$1.elem = batch.baseOffset();
            }
            state$1.log().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RecordBatch[]{batch}));
            state$1.logEndOffset_$eq(batch.nextOffset());
            lastOffset$1.elem = batch.lastOffset();
        }

        public static final /* synthetic */ long $anonfun$processPartitionData$3() {
            return -1L;
        }

        public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
            return batch.lastOffset() < truncationState$1.offset();
        }

        public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$20) {
            return x$20.lastOffset() + 1L;
        }

        public static final /* synthetic */ Some $anonfun$latestEpoch$2() {
            return new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        }

        public static final /* synthetic */ Nothing$ $anonfun$lookupEndOffsetForEpoch$1(Object nonLocalReturnKey1$1, Errors error) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new EpochEndOffset(error, -1, -1L));
        }

        public static final /* synthetic */ void $anonfun$lookupEndOffsetForEpoch$2(OffsetsForLeaderEpochRequest.PartitionData epochData$1, Object nonLocalReturnKey1$1, IntRef epochLowerBound$1, RecordBatch batch) {
            if (batch.partitionLeaderEpoch() > epochData$1.leaderEpoch) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new EpochEndOffset(Errors.NONE, epochLowerBound$1.elem, batch.baseOffset()));
            }
            epochLowerBound$1.elem = batch.partitionLeaderEpoch();
        }

        public static final /* synthetic */ boolean $anonfun$fetchFromLeader$2(FetchRequest.PartitionData fetchData$2, RecordBatch x$22) {
            return x$22.baseOffset() >= fetchData$2.fetchOffset;
        }

        public static final /* synthetic */ Nothing$ $anonfun$checkLeaderEpochAndThrow$1(Errors error) {
            throw error.exception();
        }

        public MockFetcherThread(AbstractFetcherThreadTest $outer, int replicaId, int leaderId) {
            this.replicaId = replicaId;
            this.leaderId = leaderId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            String x$1 = "mock-fetcher";
            String x$2 = "mock-fetcher";
            BrokerEndPoint x$3 = new BrokerEndPoint(leaderId, "localhost", Random$.MODULE$.nextInt());
            FailedPartitions x$4 = $outer.kafka$server$AbstractFetcherThreadTest$$failedPartitions();
            BrokerTopicStats x$5 = new BrokerTopicStats();
            int x$6 = AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = AbstractFetcherThread$.MODULE$.$lessinit$greater$default$6();
            super(x$1, x$2, x$3, x$4, x$6, x$7, x$5);
            this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.leaderPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        }

        public static final /* synthetic */ Object $anonfun$processPartitionData$2$adapted(RecordBatch x$19) {
            return BoxesRunTime.boxToLong((long)x$19.lastOffset());
        }

        public static final /* synthetic */ Object $anonfun$truncate$2$adapted(RecordBatch x$20) {
            return BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$20));
        }

        public static final /* synthetic */ Object $anonfun$latestEpoch$1$adapted(RecordBatch x$21) {
            return BoxesRunTime.boxToInteger((int)x$21.partitionLeaderEpoch());
        }

        public class PartitionState {
            private Buffer<RecordBatch> log;
            private int leaderEpoch;
            private long logStartOffset;
            private long logEndOffset;
            private long highWatermark;
            public final /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ $outer;

            public Buffer<RecordBatch> log() {
                return this.log;
            }

            public void log_$eq(Buffer<RecordBatch> x$1) {
                this.log = x$1;
            }

            public int leaderEpoch() {
                return this.leaderEpoch;
            }

            public void leaderEpoch_$eq(int x$1) {
                this.leaderEpoch = x$1;
            }

            public long logStartOffset() {
                return this.logStartOffset;
            }

            public void logStartOffset_$eq(long x$1) {
                this.logStartOffset = x$1;
            }

            public long logEndOffset() {
                return this.logEndOffset;
            }

            public void logEndOffset_$eq(long x$1) {
                this.logEndOffset = x$1;
            }

            public long highWatermark() {
                return this.highWatermark;
            }

            public void highWatermark_$eq(long x$1) {
                this.highWatermark = x$1;
            }

            public /* synthetic */ AbstractFetcherThreadTest$MockFetcherThread$ kafka$server$AbstractFetcherThreadTest$MockFetcherThread$PartitionState$$$outer() {
                return this.$outer;
            }

            public PartitionState(AbstractFetcherThreadTest$MockFetcherThread$ $outer, Buffer<RecordBatch> log, int leaderEpoch, long logStartOffset, long logEndOffset, long highWatermark) {
                this.log = log;
                this.leaderEpoch = leaderEpoch;
                this.logStartOffset = logStartOffset;
                this.logEndOffset = logEndOffset;
                this.highWatermark = highWatermark;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
    }
}

