/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import kafka.metrics.KafkaMetricsReporter;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.KafkaServerStartable$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%q!B\n\u0015\u0011\u0003Ib!B\u000e\u0015\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003\"B\u0013\u0002\t\u00031\u0003\"B\u0013\u0002\t\u0003)\bb\u0002=\u0002#\u0003%\t!\u001f\u0004\u00057Q\u0001\u0001\u0006\u0003\u00050\r\t\u0015\r\u0011\"\u00011\u0011!!dA!A!\u0002\u0013\t\u0004\u0002C\u001b\u0007\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011\t3!\u0011!Q\u0001\n\rCQa\t\u0004\u0005\u0002ECq!\u0006\u0004C\u0002\u0013%Q\u000b\u0003\u0004Z\r\u0001\u0006IA\u0016\u0005\u0006G\u0019!\tA\u0017\u0005\u0006;\u001a!\tA\u0018\u0005\u0006E\u001a!\tA\u0018\u0005\u0006G\u001a!\t\u0001\u001a\u0005\u0006U\u001a!\tAX\u0001\u0015\u0017\u000647.Y*feZ,'o\u0015;beR\f'\r\\3\u000b\u0005U1\u0012AB:feZ,'OC\u0001\u0018\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AG\u0001\u000e\u0003Q\u0011AcS1gW\u0006\u001cVM\u001d<feN#\u0018M\u001d;bE2,7CA\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!G\u0001\nMJ|W\u000e\u0015:paN$\"aJ6\u0011\u0005i11c\u0001\u0004\u001eSA\u0011!&L\u0007\u0002W)\u0011AFF\u0001\u0006kRLGn]\u0005\u0003]-\u0012q\u0001T8hO&tw-\u0001\nti\u0006$\u0018nY*feZ,'oQ8oM&<W#A\u0019\u0011\u0005i\u0011\u0014BA\u001a\u0015\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002'M$\u0018\r^5d'\u0016\u0014h/\u001a:D_:4\u0017n\u001a\u0011\u0002\u0013I,\u0007o\u001c:uKJ\u001c\bcA\u001c;y5\t\u0001H\u0003\u0002:?\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005mB$aA*fcB\u0011Q\bQ\u0007\u0002})\u0011qHF\u0001\b[\u0016$(/[2t\u0013\t\teH\u0001\u000bLC\u001a\\\u0017-T3ue&\u001c7OU3q_J$XM]\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb\u00042A\b#G\u0013\t)uD\u0001\u0004PaRLwN\u001c\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%{R\"\u0001&\u000b\u0005-C\u0012A\u0002\u001fs_>$h(\u0003\u0002N?\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\tiu\u0004\u0006\u0003(%N#\u0006\"B\u0018\f\u0001\u0004\t\u0004\"B\u001b\f\u0001\u00041\u0004b\u0002\"\f!\u0003\u0005\raQ\u000b\u0002-B\u0011!dV\u0005\u00031R\u00111bS1gW\u0006\u001cVM\u001d<fe\u000691/\u001a:wKJ\u0004CCA\u0014\\\u0011\u0015af\u00021\u00012\u00031\u0019XM\u001d<fe\u000e{gNZ5h\u0003\u001d\u0019H/\u0019:ukB$\u0012a\u0018\t\u0003=\u0001L!!Y\u0010\u0003\tUs\u0017\u000e^\u0001\tg\",H\u000fZ8x]\u0006q1/\u001a;TKJ4XM]*uCR,GCA0f\u0011\u00151\u0017\u00031\u0001h\u0003!qWm^*uCR,\u0007C\u0001\u0010i\u0013\tIwD\u0001\u0003CsR,\u0017!D1xC&$8\u000b[;uI><h\u000eC\u0003m\u0007\u0001\u0007Q.A\u0006tKJ4XM\u001d)s_B\u001c\bC\u00018t\u001b\u0005y'B\u00019r\u0003\u0011)H/\u001b7\u000b\u0003I\fAA[1wC&\u0011Ao\u001c\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001cHcA\u0014wo\")A\u000e\u0002a\u0001[\")!\t\u0002a\u0001\u0007\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\u0012A\u001f\u0016\u0003\u0007n\\\u0013\u0001 \t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!A\u0005v]\u000eDWmY6fI*\u0019\u00111A\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\by\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class KafkaServerStartable
implements Logging {
    private final KafkaConfig staticServerConfig;
    private final KafkaServer server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return KafkaServerStartable$.MODULE$.$lessinit$greater$default$3();
    }

    public static KafkaServerStartable fromProps(Properties properties, Option<String> option) {
        return KafkaServerStartable$.MODULE$.fromProps(properties, option);
    }

    public static KafkaServerStartable fromProps(Properties properties) {
        return KafkaServerStartable$.MODULE$.fromProps(properties);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig staticServerConfig() {
        return this.staticServerConfig;
    }

    private KafkaServer server() {
        return this.server;
    }

    public void startup() {
        try {
            this.server().startup();
            return;
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Exiting Kafka.");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void shutdown() {
        try {
            this.server().shutdown();
            return;
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Halting Kafka.");
            throw Exit$.MODULE$.halt(1, Exit$.MODULE$.halt$default$2());
        }
    }

    public void setServerState(byte newState) {
        this.server().brokerState().newState(newState);
    }

    public void awaitShutdown() {
        this.server().awaitShutdown();
    }

    public KafkaServerStartable(KafkaConfig staticServerConfig, Seq<KafkaMetricsReporter> reporters, Option<String> threadNamePrefix) {
        this.staticServerConfig = staticServerConfig;
        Logging.$init$(this);
        Time x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        this.server = new KafkaServer(staticServerConfig, x$4, threadNamePrefix, reporters);
    }

    public KafkaServerStartable(KafkaConfig serverConfig) {
        this(serverConfig, (Seq<KafkaMetricsReporter>)((Seq)Seq$.MODULE$.empty()), KafkaServerStartable$.MODULE$.$lessinit$greater$default$3());
    }
}

