/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.controller.ControllerStats;
import kafka.network.Processor;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0017/\u0001MBQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013\u0005q\b\u0003\u0004G\u0001\u0001\u0006I\u0001\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001b\u0001\n\u0003Q\u0005B\u0002(\u0001A\u0003%1\nC\u0004P\u0001\u0001\u0007I\u0011\u0001)\t\u000fe\u0003\u0001\u0019!C\u00015\"1\u0001\r\u0001Q!\nECq!\u0019\u0001A\u0002\u0013\u0005\u0001\u000bC\u0004c\u0001\u0001\u0007I\u0011A2\t\r\u0015\u0004\u0001\u0015)\u0003R\u0011\u001d1\u0007\u00011A\u0005\u0002\u001dDq\u0001\u001e\u0001A\u0002\u0013\u0005Q\u000f\u0003\u0004x\u0001\u0001\u0006K\u0001\u001b\u0005\bq\u0002\u0001\r\u0011\"\u0001z\u0011\u001dq\b\u00011A\u0005\u0002}Dq!a\u0001\u0001A\u0003&!\u0010C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001\u0002\b!A\u00111\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011Q\u0005\u0001!\u0002\u0013\tI\u0002\u0003\u0005\u0002(\u0001\u0011\r\u0011\"\u0001@\u0011\u001d\tI\u0003\u0001Q\u0001\n\u0001C\u0011\"a\u000b\u0001\u0005\u0004%\t!!\f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003_A\u0011\"!\u0012\u0001\u0005\u0004%\t!!\f\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003_Aq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002\\\u0001!\t%a\u0013\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011q\u000e\u0001\u0005\u0002\u0005-\u0003bBA=\u0001\u0011\u0005\u00111\n\u0005\b\u0003{\u0002A\u0011AA&\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0017Bq!!\"\u0001\t\u0003\tY\u0005C\u0004\u0002\n\u0002!\t!a\u0013\t\u000f\u0005-\u0005\u0001\"\u0001\u0002L!9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u0003g\u0003A\u0011AA&\u0011\u001d\t9\f\u0001C\u0005\u0003sCq!a<\u0001\t\u0013\t\tPA\rV]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8UKN$(BA\u00181\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u000b\u0003E\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001iA\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007M\u0001\u0003u.L!!\u000f\u001c\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tA\b\u0005\u0002>\u00015\ta&A\u0005ce>\\WM]%ecU\t\u0001\t\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%IA\u0002J]R\f!B\u0019:pW\u0016\u0014\u0018\nZ\u0019!\u0003%\u0011'o\\6fe&#''\u0001\u0006ce>\\WM]%ee\u0001\n\u0001$\u001a8bE2,7i\u001c8ue>dG.\u001a3TQV$Hm\\<o+\u0005Y\u0005CA!M\u0013\ti%IA\u0004C_>dW-\u00198\u00023\u0015t\u0017M\u00197f\u0007>tGO]8mY\u0016$7\u000b[;uI><h\u000eI\u0001\rG>tg-[4Qe>\u00048/M\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005kRLGNC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&A\u0003)s_B,'\u000f^5fg\u0006\u00012m\u001c8gS\u001e\u0004&o\u001c9tc}#S-\u001d\u000b\u00037z\u0003\"!\u0011/\n\u0005u\u0013%\u0001B+oSRDqaX\u0005\u0002\u0002\u0003\u0007\u0011+A\u0002yIE\nQbY8oM&<\u0007K]8qgF\u0002\u0013\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0014\u0001E2p]\u001aLw\r\u0015:paN\u0014t\fJ3r)\tYF\rC\u0004`\u0019\u0005\u0005\t\u0019A)\u0002\u001b\r|gNZ5h!J|\u0007o\u001d\u001a!\u0003\u001d\u0019wN\u001c4jON,\u0012\u0001\u001b\t\u0004S2tW\"\u00016\u000b\u0005-\u0014\u0015AC2pY2,7\r^5p]&\u0011QN\u001b\u0002\u0004'\u0016\f\bCA8s\u001b\u0005\u0001(BA91\u0003\u0019\u0019XM\u001d<fe&\u00111\u000f\u001d\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006d_:4\u0017nZ:`I\u0015\fHCA.w\u0011\u001dyv\"!AA\u0002!\f\u0001bY8oM&<7\u000fI\u0001\bg\u0016\u0014h/\u001a:t+\u0005Q\bcA5mwB\u0011q\u000e`\u0005\u0003{B\u00141bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\rY\u0016\u0011\u0001\u0005\b?J\t\t\u00111\u0001{\u0003!\u0019XM\u001d<feN\u0004\u0013A\u0002:b]\u0012|W.\u0006\u0002\u0002\nA!\u00111BA\b\u001b\t\tiA\u0003\u0002U\u0005&!\u0011\u0011CA\u0007\u0005\u0019\u0011\u0016M\u001c3p[\u00069!/\u00198e_6\u0004\u0013!\u0002;pa&\u001cWCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010+\u0006!A.\u00198h\u0013\u0011\t\u0019#!\b\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005Y\u0001/\u0019:uSRLwN\\%e\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0003=Y\u0017MZ6b\u0003BL7\u000fT8hO\u0016\u0014XCAA\u0018!\u0011\t\t$a\u0010\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tQ\u0001\\8hi)TA!!\u000f\u0002<\u00051\u0011\r]1dQ\u0016T!!!\u0010\u0002\u0007=\u0014x-\u0003\u0003\u0002B\u0005M\"A\u0002'pO\u001e,'/\u0001\tlC\u001a\\\u0017-\u00119jg2{wmZ3sA\u00051b.\u001a;x_J\\\u0007K]8dKN\u001cxN\u001d'pO\u001e,'/A\foKR<xN]6Qe>\u001cWm]:pe2{wmZ3sA\u0005)1/\u001a;VaR\t1\fK\u0002\u001f\u0003\u001f\u0002B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0005\u0003+\nY$A\u0003kk:LG/\u0003\u0003\u0002Z\u0005M#A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\ry\u0012q\f\t\u0005\u0003#\n\t'\u0003\u0003\u0002d\u0005M#!B!gi\u0016\u0014\u0018\u0001D:uCJ$(I]8lKJ\u001cHcA.\u0002j!9\u00111\u000e\u0011A\u0002\u00055\u0014aB2mkN$XM\u001d\t\u0004S2\f\u0016\u0001\t;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012D3!IA:!\u0011\t\t&!\u001e\n\t\u0005]\u00141\u000b\u0002\u0005)\u0016\u001cH/A\u0011uKN$XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tG)[:bE2,G\rK\u0002#\u0003g\nq\u0006^3tiVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016D3aIA:\u0003A\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8ESN\f'\r\\3e\u0005f$v\u000e]5d\u001fZ,'O]5eK\"\u001aA%a\u001d\u0002[Q,7\u000f^+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\%om\u0006d\u0017\u000e\u001a+pa&\u001cwJ^3se&$W\rK\u0002&\u0003g\n!E^3sS\u001aLXK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016$\u0017a\t<fe&4\u00170\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eR5tC\ndW\rZ\u0001\u000fg\",H\u000fZ8x]N+'O^3s)\rY\u0016\u0011\u0013\u0005\u0006c\"\u0002\ra_\u0001\u0013G>t7/^7f\u00032dW*Z:tC\u001e,7\u000f\u0006\u0004\u0002\u0018\u00065\u0016q\u0016\t\u0005S2\fI\n\u0005\u0003\u0002\u001c\u0006%f\u0002BAO\u0003K\u00032!a(C\u001b\t\t\tKC\u0002\u0002$J\na\u0001\u0010:p_Rt\u0014bAAT\u0005\u00061\u0001K]3eK\u001aLA!a\t\u0002,*\u0019\u0011q\u0015\"\t\u000f\u0005U\u0011\u00061\u0001\u0002\u001a\"1\u0011\u0011W\u0015A\u0002\u0001\u000b1B\\;n\u001b\u0016\u001c8/Y4fg\u0006!C/Z:u)>\u0004\u0018nY+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\rK\u0002+\u0003g\n\u0011#\u00197uKJ$v\u000e]5d\u0007>tg-[4t)!\tY,!4\u0002X\u0006e\u0007\u0003BA_\u0003\u0013l!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0003\u000b\f9-A\u0004dY&,g\u000e^:\u000b\u0007E\n9$\u0003\u0003\u0002L\u0006}&AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDq!a4,\u0001\u0004\t\t.A\u0006bI6Lgn\u00117jK:$\b\u0003BA_\u0003'LA!!6\u0002@\n)\u0011\tZ7j]\"9\u0011QC\u0016A\u0002\u0005e\u0005BBAnW\u0001\u0007\u0011+\u0001\u0007u_BL7mQ8oM&<7\u000fK\u0003,\u0003?\fY\u000f\u0005\u0003\u0002b\u0006\u001dXBAAr\u0015\r\t)OQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAu\u0003G\u0014aA\\8xCJt\u0017EAAw\u0003=\u0019\u0017\r^\u001feKB\u0014XmY1uS>t\u0017!E2sK\u0006$X-\u00113nS:\u001cE.[3oiR\u0011\u0011\u0011\u001b")
public class UncleanLeaderElectionTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1 = null;
    private Properties configProps2 = null;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final Random random = new Random();
    private final String topic = new StringBuilder(5).append("topic").append(this.random().nextLong()).toString();
    private final int partitionId;
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        .colon.colon foreach_these = new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$));
        while (!foreach_these.isEmpty()) {
            Properties properties = (Properties)foreach_these.head();
            UncleanLeaderElectionTest.$anonfun$setUp$1(this, properties);
            foreach_these = (List)foreach_these.tail();
        }
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            CoreUtils$.MODULE$.delete(server.config().logDirs());
            return BoxedUnit.UNIT;
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        super.tearDown();
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable & scala.Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUncleanLeaderElectionEnabled() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers());
        this.verifyUncleanLeaderElectionEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUncleanLeaderElectionDisabled() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers());
        this.verifyUncleanLeaderElectionDisabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUncleanLeaderElectionDisabledByTopicOverride() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1()}))));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1()}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), this.servers(), topicProps);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("UncleanLeaderElectionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = " is elected to be: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString();
        });
        Assert.assertTrue((String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            String string = " is: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString();
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)x$1 -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(x$1);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$6(leaderId, x$2)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$8(followerId, x$3))).get();
        followerServer.startup();
        KafkaZkClient x$32 = this.zkClient();
        String x$4 = this.topic();
        int x$5 = this.partitionId();
        Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$32, x$4, x$5, x$7, x$8, (Option<Object>)x$6);
        Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUncleanLeaderElectionDisabled() {
        KafkaServer followerServer;
        int followerId;
        int leaderId;
        block6: {
            leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = " is elected to be: %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString();
            });
            Assert.assertTrue((String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString(), (leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0);
            followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String string = " is: %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString();
            });
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
            ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            });
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(server);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$6(leaderId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            });
            followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$8(followerId, x$4))).get();
            followerServer.startup();
            KafkaZkClient x$3 = this.zkClient();
            String x$42 = this.topic();
            int x$5 = this.partitionId();
            Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
            long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
            Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$42, x$5, x$7, x$8, (Option<Object>)x$6);
            Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
            try {
                TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
                Assert.fail((String)"Message produced while leader is down should fail, but it succeeded");
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof TimeoutException) break block6;
                throw throwable;
            }
        }
        Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
        ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$9(leaderId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
            server.startup();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$9 = this.zkClient();
        String x$10 = this.topic();
        int x$11 = this.partitionId();
        Some x$12 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        long x$13 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$14 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$9, x$10, x$11, x$13, x$14, (Option<Object>)x$12);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$11(this, followerServer, followerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$12(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$13(leaderId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$15 = this.zkClient();
        String x$16 = this.topic();
        int x$17 = this.partitionId();
        Some x$18 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$19 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$20 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$15, x$16, x$17, x$19, x$20, (Option<Object>)x$18);
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$))), this.consumeAllMessages(this.topic(), 3));
    }

    private void shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        String x$2 = new StringBuilder(5).append("group").append(this.random().nextLong()).toString();
        boolean x$3 = false;
        StringDeserializer x$4 = new StringDeserializer();
        String x$52 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$6 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$8 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$9 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$10 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$10();
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, x$2, x$52, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$4);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, TestUtils$.MODULE$.consumeRecords$default$3()).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.value(), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicUncleanLeaderElectionEnable() {
        KafkaServer followerServer;
        int followerId;
        block3: {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            this.startBrokers((Seq<Properties>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Properties[]{this.configProps1(), this.configProps2()}))));
            Tuple2[] tuple2Array = new Tuple2[1];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment(this.topic(), new Properties(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
            int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
            ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$1(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
            Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
            this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
                UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$3(server);
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$4(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
                this.shutdownServer(server);
                return BoxedUnit.UNIT;
            }, Seq$.MODULE$.canBuildFrom());
            followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$6(followerId, x$6))).get();
            followerServer.startup();
            Assert.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
            try {
                TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", 1000, 1000);
                Assert.fail((String)"Message produced while leader is down should fail, but it succeeded");
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof TimeoutException) break block3;
                throw throwable;
            }
        }
        Assert.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
        Admin adminClient = this.createAdminClient();
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
        adminClient.close();
        KafkaZkClient x$3 = this.zkClient();
        String x$4 = this.topic();
        int x$5 = this.partitionId();
        Some x$62 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$4, x$5, x$7, x$8, (Option<Object>)x$62);
        Assert.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5());
        Assert.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    /*
     * WARNING - void declaration
     */
    private AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        void $minus$greater$extension_$this;
        java.util.List configEntries = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfigs).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            ConfigEntry configEntry = new ConfigEntry(k, v);
            return configEntry;
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)newConfig);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        return adminClient.alterConfigs(configs);
    }

    private Admin createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers(this.servers(), new ListenerName("PLAINTEXT"));
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    public static final /* synthetic */ Object $anonfun$setUp$1(UncleanLeaderElectionTest $this, Properties configProps) {
        configProps.put("controlled.shutdown.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)$this.enableControlledShutdown())).toString());
        configProps.put("controlled.shutdown.max.retries", "1");
        return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
    }

    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
        $this.servers_$eq((Seq<KafkaServer>)((Seq)$this.servers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)server, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaServer server) {
        return server.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionEnabled$5(KafkaServer x$1) {
        ControllerStats qual$1 = x$1.kafkaController().controllerContext().stats();
        String x$12 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$12, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$6(int leaderId$1, KafkaServer x$2) {
        return x$2.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$8(int followerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaServer server) {
        return server.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionDisabled$5(KafkaServer server) {
        ControllerStats qual$1 = server.kafkaController().controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$6(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$8(int followerId$2, KafkaServer x$4) {
        return x$4.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$9(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$11(UncleanLeaderElectionTest $this, KafkaServer followerServer$1, int followerId$2) {
        Option partitionInfoOpt = followerServer$1.metadataCache().getPartitionInfo($this.topic(), $this.partitionId());
        return partitionInfoOpt.isDefined() && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).isr().contains(BoxesRunTime.boxToInteger((int)followerId$2));
    }

    public static final /* synthetic */ String $anonfun$verifyUncleanLeaderElectionDisabled$12() {
        return "Inconsistent metadata after first server startup";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$13(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$1(int followerId$3, KafkaServer server) {
        return server.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ void $anonfun$testTopicUncleanLeaderElectionEnable$3(KafkaServer server) {
        ControllerStats qual$1 = server.kafkaController().controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$4(int leaderId$3, KafkaServer server) {
        return server.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$6(int followerId$3, KafkaServer x$6) {
        return x$6.config().brokerId() == followerId$3;
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

