/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001A\u0002\u0013\u00051\u0006C\u00040\u0001\u0001\u0007I\u0011\u0001\u0019\t\rY\u0002\u0001\u0015)\u0003-\u0011\u001d9\u0004A1A\u0005\u0002aBa\u0001\u0010\u0001!\u0002\u0013I\u0004bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B \t\u000b\r\u0003A\u0011\u0001#\t\u000b9\u0003A\u0011\u0001#\t\u000bM\u0003A\u0011\u0001#\t\u000b\u0005\u0004A\u0011\u0001#\t\u000b\r\u0004A\u0011\u0001#\t\u000b\u0015\u0004A\u0011\u0001#\t\u000bU\u0004A\u0011\u0001#\t\u000b]\u0004A\u0011\u0001#\t\r\u0005-\u0001\u0001\"\u0001E\u0011\u0019\ty\u0001\u0001C\u0001\t\"1\u00111\u0003\u0001\u0005\u0002\u0011Ca!a\u0006\u0001\t\u0003!\u0005BBA\u000e\u0001\u0011\u0005A\tC\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011q\u000f\u0001\u0005\u0002\u0005e$aD(gMN,G/\u00138eKb$Vm\u001d;\u000b\u0005ma\u0012a\u00017pO*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u00025\u0005\u0019\u0011\u000e\u001a=\u0016\u00031\u0002\"!K\u0017\n\u00059R\"aC(gMN,G/\u00138eKb\fq!\u001b3y?\u0012*\u0017\u000f\u0006\u00022iA\u0011\u0011EM\u0005\u0003g\t\u0012A!\u00168ji\"9QgAA\u0001\u0002\u0004a\u0013a\u0001=%c\u0005!\u0011\u000e\u001a=!\u0003)i\u0017\r_#oiJLWm]\u000b\u0002sA\u0011\u0011EO\u0005\u0003w\t\u00121!\u00138u\u0003-i\u0017\r_#oiJLWm\u001d\u0011\u0002\u0015\t\f7/Z(gMN,G/F\u0001@!\t\t\u0003)\u0003\u0002BE\t!Aj\u001c8h\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\u0002\u000bM,G/\u001e9\u0015\u0003EB#!\u0003$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015!\u00026v]&$(\"A&\u0002\u0007=\u0014x-\u0003\u0002N\u0011\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\u0015A\u0003\"aR)\n\u0005IC%!B!gi\u0016\u0014\u0018\u0001\u0005:b]\u0012|W\u000eT8pWV\u0004H+Z:uQ\tYQ\u000b\u0005\u0002H-&\u0011q\u000b\u0013\u0002\u0005)\u0016\u001cH\u000fK\u0002\f3~\u0003\"AW/\u000e\u0003mS!\u0001\u0018\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002_7\n1an\\<be:\f\u0013\u0001Y\u0001\u0010G\u0006$X\bZ3qe\u0016\u001c\u0017\r^5p]\u0006\u0011Bn\\8lkB,\u0005\u0010\u001e:f[\u0016\u001c\u0015m]3tQ\taQ+A\u0005uKN$XI\u001c;ss\"\u0012Q\"V\u0001\u0012i\u0016\u001cH/\u00128uef|e/\u001a:gY><\b\u0006\u0002\bVO\"\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002SB\u0011!N\u001d\b\u0003WBt!\u0001\\8\u000e\u00035T!A\u001c\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013BA9#\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001d;\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gN\u0003\u0002rE\u0005i\u0011\r\u001d9f]\u0012$vn\\'b]fD#aD+\u0002!\u0005\u0004\b/\u001a8e\u001fV$xJZ(sI\u0016\u0014\b\u0006\u0002\tVOf\u001c\u0013A\u001f\t\u0004w\u0006\u001dQ\"\u0001?\u000b\u0005ut\u0018AB3se>\u00148OC\u0002\u0000\u0003\u0003\taaY8n[>t'bA\u000f\u0002\u0004)\u0019\u0011Q\u0001&\u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\tI\u0001 \u0002\u0017\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;Fq\u000e,\u0007\u000f^5p]\u0006IB/Z:u\r\u0016$8\r[+qa\u0016\u0014(i\\;oI>3gm]3uQ\t\tR+\u0001\u0006uKN$(+Z8qK:D#AE+\u0002\u0011Q\u0014XO\\2bi\u0016D#aE+\u0002\u001d\u0019|'oY3V]6\f\u0007\u000fV3ti\"\u0012A#V\u0001&i\u0016\u001cHoU1oSRLH*Y:u\u001f\u001a47/\u001a;FcV\fG\u000eV8CCN,wJ\u001a4tKRD#!F+\u0002!\u0005\u001c8/\u001a:u/JLG/\u001a$bS2\u001cX\u0003BA\u0012\u0003\u001b\"\u0012\"MA\u0013\u0003s\tY$a\u0010\t\u000f\u0005\u001db\u00031\u0001\u0002*\u00059Q.Z:tC\u001e,\u0007\u0003BA\u0016\u0003gqA!!\f\u00020A\u0011ANI\u0005\u0004\u0003c\u0011\u0013A\u0002)sK\u0012,g-\u0003\u0003\u00026\u0005]\"AB*ue&twMC\u0002\u00022\tBQA\u000b\fA\u00021Ba!!\u0010\u0017\u0001\u0004I\u0014AB8gMN,G\u000fC\u0004\u0002BY\u0001\r!a\u0011\u0002\u000b-d\u0017m]:\u0011\r\u0005-\u0012QIA%\u0013\u0011\t9%a\u000e\u0003\u000b\rc\u0017m]:\u0011\t\u0005-\u0013Q\n\u0007\u0001\t\u001d\tyE\u0006b\u0001\u0003#\u0012\u0011\u0001V\t\u0005\u0003'\nI\u0006E\u0002\"\u0003+J1!a\u0016#\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!IA.\u0013\r\tiF\t\u0002\u0004\u0003:L\u0018\u0001D7p]>$xN\\5d'\u0016\fHCBA2\u0003_\n\u0019\bE\u0003\u0002f\u0005-\u0014(\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002n\u0005\u001d$aA*fc\"1\u0011\u0011O\fA\u0002e\nAAY1tK\"1\u0011QO\fA\u0002e\n1\u0001\\3o\u0003MqwN\\#ySN$XM\u001c;UK6\u0004h)\u001b7f)\t\tY\b\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\u0005%|'BAAC\u0003\u0011Q\u0017M^1\n\t\u0005%\u0015q\u0010\u0002\u0005\r&dW\r")
public class OffsetIndexTest {
    private OffsetIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, OffsetIndex$.MODULE$.$lessinit$greater$default$4()));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$1 -> x$1, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1 & Serializable & scala.Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p), Seq$.MODULE$.canBuildFrom()));
        long l = this.idx().baseOffset();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        long[] offsets = (long[])new RichLong(l).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        ArrayOps.ofLong foreach_this = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(offsets)).take(30)));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            long l2 = BoxesRunTime.unboxToLong((Object)foreach_this.apply(foreach_i));
            OffsetIndexTest.$anonfun$randomLookupTest$6(this, valMap, l2);
        }
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.idx().maxEntries());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$lookupExtremeCases$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.idx().maxEntries());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$testEntry$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n2, this.idx().maxEntries());
        if (range2 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this2 = range2;
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                OffsetIndexTest.$anonfun$testEntry$2(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntryOverflow() {
        this.idx().entry(0);
    }

    @Test
    public void appendTooMany() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.idx().maxEntries());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$appendTooMany$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OffsetPosition[]{first, second, third, fourth}))).foreach((Function1 & Serializable & scala.Serializable)offsetPosition -> {
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assert.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((long)2L, (long)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.truncate();
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 10);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                idx.append((long)foreach$mVc$sp_i, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (long)0L, (long)idx.entries());
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.forceUnmap();
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> idx.lookup(1L), ClassTag$.MODULE$.apply(NullPointerException.class), new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            Assert.fail((String)message);
            return;
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, e.getClass());
            return;
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, len);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$monotonicSeq$1(last, rand, vals, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistentTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        Files.delete(file.toPath());
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$2) {
        if (x$2 != null) {
            long logical = x$2._1$mcJ$sp();
            int physical = x$2._2$mcI$sp();
            Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$6(OffsetIndexTest $this, TreeMap valMap$1, long offset) {
        OffsetPosition rightAnswer = offset < BoxesRunTime.unboxToLong((Object)valMap$1.firstKey()) ? new OffsetPosition($this.idx().baseOffset(), 0) : new OffsetPosition(valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)valMap$1.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp());
        Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)$this.idx().lookup(offset));
    }

    public static final /* synthetic */ void $anonfun$lookupExtremeCases$1(OffsetIndexTest $this, int i) {
        $this.idx().append($this.idx().baseOffset() + (long)i + 1L, i);
    }

    public static final /* synthetic */ void $anonfun$testEntry$1(OffsetIndexTest $this, int i) {
        $this.idx().append($this.idx().baseOffset() + (long)i + 1L, i);
    }

    public static final /* synthetic */ void $anonfun$testEntry$2(OffsetIndexTest $this, int i) {
        Assert.assertEquals((Object)new OffsetPosition($this.idx().baseOffset() + (long)i + 1L, i), (Object)$this.idx().entry(i));
    }

    public static final /* synthetic */ void $anonfun$appendTooMany$1(OffsetIndexTest $this, int i) {
        long offset = $this.idx().baseOffset() + (long)i + 1L;
        $this.idx().append(offset, i);
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset(), offsetPosition.position());
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int _) {
        last$1.elem += rand$1.nextInt(15) + 1;
        return vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)last$1.elem));
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1$adapted(IntRef last$1, Random rand$1, ArrayBuffer vals$1, Object _) {
        return OffsetIndexTest.$anonfun$monotonicSeq$1(last$1, rand$1, vals$1, BoxesRunTime.unboxToInt((Object)_));
    }
}

