/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.DynamicConfig;
import kafka.utils.CoreUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.config.ConfigException;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u001ba\u0002B\u0002\u0016\u0001A\u00035Q\u0004C\u0004,\u0001\t\u0007IQ\u0002\u000f\t\r1\u0002\u0001\u0015!\u0004\u001e\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u00159\u0005\u0001\"\u0001/\u0011\u0015I\u0005\u0001\"\u0001/\u0011\u00159\u0006\u0001\"\u0001/\u0005E!\u0015P\\1nS\u000e\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003\u00195\taa]3sm\u0016\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0003)5\t!A_6\n\u0005Y\u0019\"\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0017\u0005\tbn\u001c8Fq&\u001cH/\u001a8u\u0007>tg-[4\u0016\u0003u\u0001\"AH\u0014\u000f\u0005})\u0003C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0010\u0003\u0019a$o\\8u})\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t13%\u0001\no_:,\u00050[:uK:$8i\u001c8gS\u001e\u0004\u0013!C:p[\u00164\u0016\r\\;f\u0003)\u0019x.\\3WC2,X\rI\u0001,g\"|W\u000f\u001c3GC&dw\u000b[3o\u0007\"\fgnZ5oO\u000ec\u0017.\u001a8u\u0013\u0012,fn\u001b8po:\u001cuN\u001c4jOR\tq\u0006\u0005\u00021c5\t1%\u0003\u00023G\t!QK\\5uQ\u00111A\u0007P\u001f\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014!\u00026v]&$(\"A\u001d\u0002\u0007=\u0014x-\u0003\u0002<m\t!A+Z:u\u0003!)\u0007\u0010]3di\u0016$7%\u0001 \u0011\u0005}\"eB\u0001!C\u001d\t\u0001\u0013)C\u0001%\u0013\t\u00195%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u00111iI\u0001(g\"|W\u000f\u001c3GC&dw\u000b[3o\u0007\"\fgnZ5oOV\u001bXM]+oW:|wO\\\"p]\u001aLw\r\u000b\u0003\biqj\u0014\u0001K:i_VdGMR1jY2+\u0017\rZ3s\u0007>tg-[4t/&$\b.\u00138wC2LGMV1mk\u0016\u001c\b\u0006\u0002\u00055y-\u001b\u0013\u0001\u0014\t\u0003\u001bVk\u0011A\u0014\u0006\u0003\u001fB\u000baaY8oM&<'BA)S\u0003\u0019\u0019w.\\7p]*\u0011ab\u0015\u0006\u0003)b\na!\u00199bG\",\u0017B\u0001,O\u0005=\u0019uN\u001c4jO\u0016C8-\u001a9uS>t\u0017AK:i_VdGMR1jY\u001a{G\u000e\\8xKJ\u001cuN\u001c4jON<\u0016\u000e\u001e5J]Z\fG.\u001b3WC2,Xm\u001d\u0015\u0005\u0013Qb4\n")
public class DynamicConfigTest
extends ZooKeeperTestHarness {
    private final String nonExistentConfig;
    private final String someValue;

    private final String nonExistentConfig() {
        return this.nonExistentConfig;
    }

    private final String someValue() {
        return this.someValue;
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingClientIdUnknownConfig() {
        this.adminZkClient().changeClientIdConfig("ClientId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailWhenChangingUserUnknownConfig() {
        this.adminZkClient().changeUserOrUserClientIdConfig("UserId", CoreUtils$.MODULE$.propsWith(this.nonExistentConfig(), this.someValue()));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailLeaderConfigsWithInvalidValues() {
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "-100"));
    }

    @Test(expected=ConfigException.class)
    public void shouldFailFollowerConfigsWithInvalidValues() {
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "-100"));
    }

    public DynamicConfigTest() {
        this.nonExistentConfig = "some.config.that.does.not.exist";
        this.someValue = "some interesting value";
    }
}

