/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$;
import kafka.raft.KafkaNetworkChannel;
import kafka.server.ApiRequestHandler;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.AckMode;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Some;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001\u0002\u0007\u000e\u0001IA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!1\u0005A!A!\u0002\u00139\u0005\"B&\u0001\t\u0003a\u0005\"\u0002+\u0001\t\u0003*\u0006\"\u00022\u0001\t\u0013\u0019\u0007\"B:\u0001\t\u0013!\bbBA\r\u0001\u0011%\u00111\u0004\u0005\b\u00033\u0001A\u0011BA\u001b\u0005Y!Vm\u001d;SC\u001a$(+Z9vKN$\b*\u00198eY\u0016\u0014(B\u0001\b\u0010\u0003\u0015!xn\u001c7t\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0005\u0001MIr\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035ui\u0011a\u0007\u0006\u00039=\taa]3sm\u0016\u0014\u0018B\u0001\u0010\u001c\u0005E\t\u0005/\u001b*fcV,7\u000f\u001e%b]\u0012dWM\u001d\t\u0003A\rj\u0011!\t\u0006\u0003E=\tQ!\u001e;jYNL!\u0001J\u0011\u0003\u000f1{wmZ5oO\u0006qa.\u001a;x_J\\7\t[1o]\u0016d\u0007CA\u0014+\u001b\u0005A#BA\u0015\u0010\u0003\u0011\u0011\u0018M\u001a;\n\u0005-B#aE&bM.\fg*\u001a;x_J\\7\t[1o]\u0016d\u0017A\u0004:fcV,7\u000f^\"iC:tW\r\u001c\t\u0003]Ej\u0011a\f\u0006\u0003a=\tqA\\3uo>\u00148.\u0003\u00023_\tq!+Z9vKN$8\t[1o]\u0016d\u0017\u0001\u0002;j[\u0016\u0004\"!\u000e \u000e\u0003YR!AI\u001c\u000b\u0005aJ\u0014AB2p[6|gN\u0003\u0002\u0011u)\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h\u0013\tydG\u0001\u0003US6,\u0017AB2mS\u0016tG\u000f\u0005\u0002C\t6\t1I\u0003\u0002*s%\u0011Qi\u0011\u0002\u000b%\u00064Go\u00117jK:$\u0018!E7fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]B\u0011\u0001*S\u0007\u0002o%\u0011!j\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0019a\u0014N\\5u}Q1Qj\u0014)R%N\u0003\"A\u0014\u0001\u000e\u00035AQ!\n\u0004A\u0002\u0019BQ\u0001\f\u0004A\u00025BQa\r\u0004A\u0002QBQ\u0001\u0011\u0004A\u0002\u0005CQA\u0012\u0004A\u0002\u001d\u000ba\u0001[1oI2,GC\u0001,Z!\t!r+\u0003\u0002Y+\t!QK\\5u\u0011\u0015Qv\u00011\u0001\\\u0003\u001d\u0011X-];fgR\u0004\"\u0001X0\u000f\u00059j\u0016B\u000100\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!\u0001Y1\u0003\u000fI+\u0017/^3ti*\u0011alL\u0001\fQ\u0006tG\r\\3FeJ|'\u000fF\u0002WI\u0016DQA\u0017\u0005A\u0002mCQA\u001a\u0005A\u0002\u001d\f1!\u001a:s!\tA\u0007O\u0004\u0002j]:\u0011!.\\\u0007\u0002W*\u0011A.E\u0001\u0007yI|w\u000e\u001e \n\u0003YI!a\\\u000b\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\n)\"\u0014xn^1cY\u0016T!a\\\u000b\u0002\u001f\rdwn]3D_:tWm\u0019;j_:$2AV;w\u0011\u0015Q\u0016\u00021\u0001\\\u0011\u00159\u0018\u00021\u0001y\u0003-)'O]8s\u0007>,h\u000e^:\u0011\ret\u0018\u0011AA\u0007\u001b\u0005Q(BA>}\u0003\u0011)H/\u001b7\u000b\u0003u\fAA[1wC&\u0011qP\u001f\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dq'\u0001\u0005qe>$xnY8m\u0013\u0011\tY!!\u0002\u0003\r\u0015\u0013(o\u001c:t!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\ny\u0006!A.\u00198h\u0013\u0011\t9\"!\u0005\u0003\u000f%sG/Z4fe\u0006a1/\u001a8e%\u0016\u001c\bo\u001c8tKR)a+!\b\u0002 !)!L\u0003a\u00017\"9\u0011\u0011\u0005\u0006A\u0002\u0005\r\u0012a\u0003:fgB|gn]3PaR\u0004R\u0001FA\u0013\u0003SI1!a\n\u0016\u0005\u0019y\u0005\u000f^5p]B!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020]\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003g\tiC\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tKR\u0019a+a\u000e\t\u000f\u0005e2\u00021\u0001\u0002<\u0005A!/Z:q_:\u001cX\rE\u0002]\u0003{I1!a\u0010b\u0005!\u0011Vm\u001d9p]N,\u0007")
public class TestRaftRequestHandler
implements ApiRequestHandler,
Logging {
    private final KafkaNetworkChannel networkChannel;
    private final RequestChannel requestChannel;
    private final Time time;
    private final RaftClient client;
    private final TopicPartition metadataPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void handle(RequestChannel.Request request) {
        block17: {
            try {
                try {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Handling request:").append(request.requestDesc(true)).append(" from connection ").append(request$1.context().connectionId).append(";").append("securityProtocol:").append(request$1.context().securityProtocol).append(",principal:").append(request$1.context().principal).toString());
                    ApiKeys apiKeys = request.header().apiKey();
                    boolean bl = ApiKeys.VOTE.equals(apiKeys) ? true : (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys) ? true : (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys) ? true : ApiKeys.FETCH.equals(apiKeys)));
                    if (bl) {
                        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
                        this.networkChannel.postInboundRequest(request.header(), (AbstractRequest)requestBody, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                            this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)response));
                            return BoxedUnit.UNIT;
                        });
                        break block17;
                    }
                    if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                        this.sendResponse(request, (Option<AbstractResponse>)Option$.MODULE$.apply((Object)ApiVersionsResponse.apiVersionsResponse((int)0, (byte)2, (Features)Features.emptySupportedFeatures())));
                        break block17;
                    }
                    if (ApiKeys.METADATA.equals(apiKeys)) {
                        MetadataRequest metadataRequest = (MetadataRequest)request.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
                        MetadataResponseData.MetadataResponseTopicCollection topics = new MetadataResponseData.MetadataResponseTopicCollection();
                        if (!metadataRequest.data().topics().isEmpty()) {
                            LeaderAndEpoch leaderAndEpoch = this.client.currentLeaderAndEpoch();
                            if (metadataRequest.data().topics().size() != 1 || !((MetadataRequestData.MetadataRequestTopic)metadataRequest.data().topics().get(0)).name().equals(this.metadataPartition.topic())) {
                                throw new IllegalArgumentException(new StringBuilder(62).append("Should only handle metadata request querying for ").append("`").append(this.metadataPartition.topic()).append(", but found ").append(metadataRequest.data().topics()).toString());
                            }
                            topics.add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(this.metadataPartition.topic()).setIsInternal(true).setPartitions(Collections.singletonList(new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NONE.code()).setPartitionIndex(this.metadataPartition.partition()).setLeaderId(leaderAndEpoch.leaderId.orElse(-1)))));
                        }
                        MetadataResponseData.MetadataResponseBrokerCollection brokers = new MetadataResponseData.MetadataResponseBrokerCollection();
                        this.networkChannel.allConnections().foreach((Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToBoolean((boolean)brokers.add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setNodeId(connection.id()).setHost(connection.host()).setPort(connection.port()))));
                        this.sendResponse(request, (Option<AbstractResponse>)Option$.MODULE$.apply((Object)new MetadataResponse(new MetadataResponseData().setTopics(topics).setBrokers(brokers))));
                        break block17;
                    }
                    if (ApiKeys.PRODUCE.equals(apiKeys)) {
                        AckMode ackMode;
                        ProduceRequest produceRequest = (ProduceRequest)request.body(ClassTag$.MODULE$.apply(ProduceRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
                        MemoryRecords records = (MemoryRecords)produceRequest.partitionRecordsOrFail().get(this.metadataPartition);
                        switch (produceRequest.acks()) {
                            case 1: {
                                ackMode = AckMode.LEADER;
                                break;
                            }
                            case -1: {
                                ackMode = AckMode.QUORUM;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(new StringBuilder(90).append("Unsupported ack mode ").append(produceRequest.acks()).append(" ").append("in Produce request (the only supported modes are acks=1 and acks=-1)").toString());
                            }
                        }
                        AckMode ackMode2 = ackMode;
                        this.client.append((Records)records, ackMode2, (long)produceRequest.timeout()).whenComplete((x$1, exception) -> {
                            Errors error = exception == null ? Errors.NONE : Errors.forException((Throwable)exception);
                            this.sendResponse(request, (Option<AbstractResponse>)Option$.MODULE$.apply((Object)new ProduceResponse(Collections.singletonMap($this.metadataPartition, new ProduceResponse.PartitionResponse(error)))));
                        });
                        break block17;
                    }
                    throw new IllegalArgumentException(new StringBuilder(21).append("Unsupported api key: ").append(request.header().apiKey()).toString());
                }
                catch (FatalExitError fatalExitError) {
                    throw fatalExitError;
                }
                catch (Throwable e) {
                    this.handleError(request, e);
                }
            }
            finally {
                if (request.apiLocalCompleteTimeNanos() < 0L) {
                    request.apiLocalCompleteTimeNanos_$eq(this.time.nanoseconds());
                }
            }
        }
    }

    private void handleError(RequestChannel.Request request, Throwable err) {
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Error when handling request: ").append("clientId=").append(request.header().clientId()).append(", ").append("correlationId=").append(request.header().correlationId()).append(", ").append("api=").append(request.header().apiKey()).append(", ").append("version=").append(request.header().apiVersion()).append(", ").append("body=").append(request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> err);
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        AbstractResponse response = requestBody.getErrorResponse(0, err);
        if (response == null) {
            this.closeConnection(request, requestBody.errorCounts(err));
            return;
        }
        this.sendResponse(request, (Option<AbstractResponse>)new Some((Object)response));
    }

    private void closeConnection(RequestChannel.Request request, java.util.Map<Errors, Integer> errorCounts) {
        this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(errorCounts).asScala()));
        this.requestChannel.sendResponse(new RequestChannel.CloseConnectionResponse(request));
    }

    private void sendResponse(RequestChannel.Request request, Option<AbstractResponse> responseOpt) {
        RequestChannel.Response response;
        if (responseOpt == null) {
            throw null;
        }
        if (!responseOpt.isEmpty()) {
            AbstractResponse abstractResponse = (AbstractResponse)responseOpt.get();
            this.requestChannel.updateErrorMetrics(request.header().apiKey(), (Map<Errors, Integer>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(abstractResponse.errorCounts()).asScala()));
        }
        if (responseOpt instanceof Some) {
            AbstractResponse response2 = (AbstractResponse)((Some)responseOpt).value();
            Send responseSend = request.context().buildResponse(response2);
            None$ responseString = RequestChannel$.MODULE$.isRequestLoggingEnabled() ? new Some((Object)response2.toString(request.context().apiVersion())) : None$.MODULE$;
            response = new RequestChannel.SendResponse(request, responseSend, (Option<String>)responseString, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        } else if (None$.MODULE$.equals(responseOpt)) {
            response = new RequestChannel.NoOpResponse(request);
        } else {
            throw new MatchError(responseOpt);
        }
        this.sendResponse(response);
    }

    private void sendResponse(RequestChannel.Response response) {
        this.requestChannel.sendResponse(response);
    }

    public TestRaftRequestHandler(KafkaNetworkChannel networkChannel, RequestChannel requestChannel, Time time, RaftClient client, TopicPartition metadataPartition) {
        this.networkChannel = networkChannel;
        this.requestChannel = requestChannel;
        this.time = time;
        this.client = client;
        this.metadataPartition = metadataPartition;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$sendResponse$1$adapted(TestRaftRequestHandler $this, RequestChannel.Request request$3, AbstractResponse response) {
        $this.requestChannel.updateErrorMetrics(request$3.header().apiKey(), (Map<Errors, Integer>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()));
        return BoxedUnit.UNIT;
    }
}

