/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Exit$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025BQ\u0001\r\u0001\u0005\u0002EBQA\u0011\u0001\u0005\u0002EBQa\u0012\u0001\u0005\u0002EBQ\u0001\u0014\u0001\u0005\u0002EBQA\u0014\u0001\u0005\u0002EBQ\u0001\u0015\u0001\u0005\nECQA\u0018\u0001\u0005\u0002EBQ\u0001\u0019\u0001\u0005\u0002EBQA\u0019\u0001\u0005\u0002EBQ\u0001\u001a\u0001\u0005\u0002EBQA\u001a\u0001\u0005\u0002EBQ\u0001\u001b\u0001\u0005\u0002EBQA\u001b\u0001\u0005\u0002EBQ\u0001\u001c\u0001\u0005\u0002EBQA\u001c\u0001\u0005\u0002EBQ\u0001\u001d\u0001\u0005\u0002EBQA\u001d\u0001\u0005\u0002EBQ\u0001\u001e\u0001\u0005\u0002EBQA\u001e\u0001\u0005\u0002EBQ\u0001\u001f\u0001\u0005\u0002EBQA\u001f\u0001\u0005\u0002EBQ\u0001 \u0001\u0005\u0002EBQA \u0001\u0005\u0002EBq!!\u0001\u0001\t\u0013\t\u0019\u0001\u0003\u0004\u0002\u001e\u0001!\t!\r\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u0019\t)\u0005\u0001C\u0001c!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003BBA+\u0001\u0011\u0005\u0011G\u0001\u000eSK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001cXK\\5u)\u0016\u001cHO\u0003\u0002\"E\u0005)\u0011\rZ7j]*\t1%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u0002A\u0005)1/\u001a;VaR\t!\u0007\u0005\u0002(g%\u0011A\u0007\u000b\u0002\u0005+:LG\u000f\u000b\u0002\u0003mA\u0011q\u0007Q\u0007\u0002q)\u0011\u0011HO\u0001\u0004CBL'BA\u001e=\u0003\u001dQW\u000f]5uKJT!!\u0010 \u0002\u000b),h.\u001b;\u000b\u0003}\n1a\u001c:h\u0013\t\t\u0005H\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u0007\u0011\u0003\"aN#\n\u0005\u0019C$!C!gi\u0016\u0014X)Y2i\u0003i!Xm\u001d;D_6\u0004\u0018M]3U_BL7\rU1si&$\u0018n\u001c8tQ\t!\u0011\n\u0005\u00028\u0015&\u00111\n\u000f\u0002\u0005)\u0016\u001cH/A\u0011uKN$8i\\7qCJ,Gk\u001c9jGB\u000b'\u000f^5uS>t'+\u001a9mS\u000e\f7\u000f\u000b\u0002\u0006\u0013\u0006\u0019C/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001et7\u000b^1uKN$vn\u0015;sS:<\u0007F\u0001\u0004J\u0003%\tG\r\u001a+pa&\u001c7\u000f\u0006\u00023%\")1k\u0002a\u0001)\u0006Y\u0011\rZ7j]\u000ec\u0017.\u001a8u!\t)F,D\u0001W\u0015\t\tsK\u0003\u0002Y3\u000691\r\\5f]R\u001c(BA\u0012[\u0015\tYf(\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003;Z\u0013q\"T8dW\u0006#W.\u001b8DY&,g\u000e^\u0001$i\u0016\u001cHOR5oIB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oiN#\u0018\r^3tQ\tA\u0011*\u0001\ruKN$h)\u001b8e\u0019><G)\u001b:N_Z,7\u000b^1uKND#!C%\u0002;Q,7\u000f\u001e*fa2L7-Y'pm\u0016\u001cF/\u0019;fgR{7\u000b\u001e:j]\u001eD#AC%\u00023Q,7\u000f^$fiJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tGo\u001d\u0015\u0003\u0017%\u000bA\u0004^3ti\u001e+GO\u0011:pW\u0016\u0014(+Y2l\u0013:4wN]7bi&|g\u000e\u000b\u0002\r\u0013\u0006yB/Z:u!\u0006\u00148/Z$f]\u0016\u0014\u0018\r^3BgNLwM\\7f]R\f%oZ:)\u00055I\u0015\u0001\r;fgR<UM\\3sCR,\u0017i]:jO:lWM\u001c;GC&d7oV5uQ>,H/\u00128pk\u001eD'+\u001a9mS\u000e\f7\u000f\u000b\u0002\u000f\u0013\u0006YC/Z:u\u000f\u0016tWM]1uK\u0006\u001b8/[4o[\u0016tGoV5uQ&s7m\u001c8tSN$XM\u001c;SC\u000e\\7\u000f\u000b\u0002\u0010\u0013\u00061C/Z:u\u000f\u0016tWM]1uK\u0006\u001b8/[4o[\u0016tGoV5uQ\u001a+w/\u001a:Ce>\\WM]:)\u0005AI\u0015!\f;fgR\u001cUO\u001d:f]R\u0004\u0016M\u001d;ji&|gNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)>\u001cFO]5oO\"\u0012\u0011#S\u0001\fi\u0016\u001cH/T8wK6\u000b\u0007\u000f\u000b\u0002\u0013\u0013\u0006qB/Z:u!\u0006\u00148/Z#yK\u000e,H/Z!tg&<g.\\3oi\u0006\u0013xm\u001d\u0015\u0003'%\u000bQ\u0005^3ti\u0016CXmY;uK^KG\u000f[%om\u0006d\u0017\u000e\u001a)beRLG/[8og\u001a\u000b\u0017\u000e\\:)\u0005QI\u0015a\t;fgR,\u00050Z2vi\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3Ce>\\WM]%e\r\u0006LGn\u001d\u0015\u0003+%\u000b1\u0005^3ti6{G-\u001b4z\u0005J|7.\u001a:J]R,'O\u0011:pW\u0016\u0014H\u000b\u001b:piRdW\r\u000b\u0002\u0017\u0013\u0006AB/Z:u\u001b>$\u0017NZ=M_\u001e$\u0015N\u001d+ie>$H\u000f\\3)\u0005]I\u0015\u0001\b;fgR\u001cUO\u001d*fCN\u001c\u0018n\u001a8nK:$8\u000fV8TiJLgn\u001a\u0015\u00031%\u000b1D^3sS\u001aL(I]8lKJ$\u0006N]8ui2,'+Z:vYR\u001cHc\u0002\u001a\u0002\u0006\u0005=\u0011\u0011\u0004\u0005\b\u0003\u000fI\u0002\u0019AA\u0005\u0003\u0019\u0019wN\u001c4jOB\u0019Q+a\u0003\n\u0007\u00055aK\u0001\u0004D_:4\u0017n\u001a\u0005\b\u0003#I\u0002\u0019AA\n\u0003m)\u0007\u0010]3di\u0016$\u0017J\u001c;fe\n\u0013xn[3s)\"\u0014x\u000e\u001e;mKB\u0019q%!\u0006\n\u0007\u0005]\u0001F\u0001\u0003M_:<\u0007bBA\u000e3\u0001\u0007\u00111C\u0001$Kb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dC\u0006cG/\u001a:M_\u001e$\u0015N]:UQJ|G\u000f\u001e7f\u0003a!Xm\u001d;N_\u0012Lg-\u001f+pa&\u001cG\u000b\u001b:piRdWm\u001d\u0015\u00035%\u000b!D^3sS\u001aLHk\u001c9jGRC'o\u001c;uY\u0016\u0014Vm];miN$rAMA\u0013\u0003O\t\t\u0005C\u0004\u0002\bm\u0001\r!!\u0003\t\u000f\u0005%2\u00041\u0001\u0002,\u00051R\r\u001f9fGR,G\rT3bI\u0016\u0014H\u000b\u001b:piRdW\r\u0005\u0003\u0002.\u0005mb\u0002BA\u0018\u0003o\u00012!!\r)\u001b\t\t\u0019DC\u0002\u00026\u0011\na\u0001\u0010:p_Rt\u0014bAA\u001dQ\u00051\u0001K]3eK\u001aLA!!\u0010\u0002@\t11\u000b\u001e:j]\u001eT1!!\u000f)\u0011\u001d\t\u0019e\u0007a\u0001\u0003W\t\u0001$\u001a=qK\u000e$X\r\u001a$pY2|w/\u001a:UQJ|G\u000f\u001e7f\u0003]!Xm\u001d;BYR,'OU3qY&\u001c\u0017\rT8h\t&\u00148\u000f\u000b\u0002\u001d\u0013\u0006\u0001\u0012m]:feR\u001cF/\u0019:ug^KG\u000f\u001b\u000b\u0006e\u00055\u0013\u0011\u000b\u0005\b\u0003\u001fj\u0002\u0019AA\u0016\u0003\u0019\u0001(/\u001a4jq\"9\u00111K\u000fA\u0002\u0005-\u0012aA:ue\u0006iB/Z:u!J|\u0007/Y4bi\u0016LeN^1mS\u0012T5o\u001c8FeJ|'\u000f\u000b\u0002\u001f\u0013\":\u0001!a\u0017\u0002b\u0005\r\u0004cA\u001c\u0002^%\u0019\u0011q\f\u001d\u0003\u000fQKW.Z8vi\u0006)a/\u00197vKz\tA\b")
public class ReassignPartitionsUnitTest {
    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, message) -> ReassignPartitionsUnitTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testCompareTopicPartitions() {
        Assertions.assertTrue((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(new TopicPartition("abc", 0), new TopicPartition("abc", 1)));
        Assertions.assertFalse((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(new TopicPartition("def", 0), new TopicPartition("abc", 1)));
    }

    @Test
    public void testCompareTopicPartitionReplicas() {
        Assertions.assertTrue((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(new TopicPartitionReplica("def", 0, 0), new TopicPartitionReplica("abc", 0, 1)));
        Assertions.assertFalse((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(new TopicPartitionReplica("def", 0, 0), new TopicPartitionReplica("cde", 0, 0)));
    }

    @Test
    public void testPartitionReassignStatesToString() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"Status of partition reassignment:", (List)new .colon.colon((Object)"Reassignment of partition bar-0 is still in progress.", (List)new .colon.colon((Object)"Reassignment of partition foo-0 is complete.", (List)new .colon.colon((Object)"Reassignment of partition foo-1 is still in progress.", (List)Nil$.MODULE$)))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.partitionReassignmentStatesToString((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), false))}))));
    }

    private void addTopics(MockAdminClient adminClient) {
        java.util.List b = adminClient.brokers();
        adminClient.addTopic(false, "foo", Arrays.asList((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, (Node)b.get(0), Arrays.asList((Object[])new Node[]{(Node)b.get(0), (Node)b.get(1), (Node)b.get(2)}), Arrays.asList((Object[])new Node[]{(Node)b.get(0), (Node)b.get(1)})), new TopicPartitionInfo(1, (Node)b.get(1), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}))}), Collections.emptyMap());
        adminClient.addTopic(false, "bar", Arrays.asList((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Object[])new Node[]{(Node)b.get(2), (Node)b.get(3), (Node)b.get(0)}), Arrays.asList((Object[])new Node[]{(Node)b.get(2), (Node)b.get(3), (Node)b.get(0)}))}), Collections.emptyMap());
    }

    @Test
    public void testFindPartitionReassignmentStates() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            scala.collection.immutable.Map reassignmentResult = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.alterPartitionReassignments((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                Throwable v = (Throwable)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                return tuple2;
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 0)), UnknownTopicOrPartitionException.class)})), (Object)reassignmentResult);
            Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true))})), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)ReassignPartitionsCommand$.MODULE$.findPartitionReassignmentStates((Admin)adminClient, (Seq)new .colon.colon((Object)new Tuple2((Object)new TopicPartition("foo", 0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), (List)new .colon.colon((Object)new Tuple2((Object)new TopicPartition("foo", 1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)Nil$.MODULE$))));
            scala.collection.immutable.Map cancelResult = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.cancelPartitionReassignments((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("quux", 2)}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$2._1();
                Throwable v = (Throwable)x0$2._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                return tuple2;
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 2)), UnknownTopicOrPartitionException.class)})), (Object)cancelResult);
            Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true))})), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)ReassignPartitionsCommand$.MODULE$.findPartitionReassignmentStates((Admin)adminClient, (Seq)new .colon.colon((Object)new Tuple2((Object)new TopicPartition("foo", 0), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}))), (List)new .colon.colon((Object)new Tuple2((Object)new TopicPartition("foo", 1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)Nil$.MODULE$))));
        }
    }

    @Test
    public void testFindLogDirMoveStates() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}), Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}), Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}), Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", null})})).build();){
            this.addTopics(adminClient);
            java.util.List b = adminClient.brokers();
            adminClient.addTopic(false, "quux", Arrays.asList((Object[])new TopicPartitionInfo[]{new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}), Arrays.asList((Object[])new Node[]{(Node)b.get(1), (Node)b.get(2), (Node)b.get(3)}))}), Collections.emptyMap());
            adminClient.alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 0, 0)), (Object)"/tmp/kafka-logs1")}))).asJava()).all().get();
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState("/tmp/kafka-logs0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0)), (Object)new ReassignPartitionsCommand.CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0)), (Object)new ReassignPartitionsCommand.MissingLogDirMoveState("/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quuz", 0, 0)), (Object)new ReassignPartitionsCommand.MissingReplicaMoveState("/tmp/kafka-logs0"))})), (Object)ReassignPartitionsCommand$.MODULE$.findLogDirMoveStates((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0)), (Object)"/tmp/kafka-logs0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quuz", 0, 0)), (Object)"/tmp/kafka-logs0")}))));
        }
    }

    @Test
    public void testReplicaMoveStatesToString() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"Reassignment of replica bar-0-0 completed successfully.", (List)new .colon.colon((Object)"Reassignment of replica foo-0-0 is still in progress.", (List)new .colon.colon((Object)"Partition foo-1 on broker 0 is not being moved from log dir /tmp/kafka-logs0 to /tmp/kafka-logs1.", (List)new .colon.colon((Object)"Partition quux-0 cannot be found in any live log directory on broker 0.", (List)new .colon.colon((Object)"Partition quux-1 on broker 1 is being moved to log dir /tmp/kafka-logs2 instead of /tmp/kafka-logs1.", (List)new .colon.colon((Object)"Partition quux-2 is not found in any live log dir on broker 1. There is likely an offline log directory on the broker.", (List)Nil$.MODULE$)))))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.replicaMoveStatesToString((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState("/tmp/kafka-logs0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0)), (Object)new ReassignPartitionsCommand.CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 0, 0)), (Object)new ReassignPartitionsCommand.MissingReplicaMoveState("/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 1)), (Object)new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 2, 1)), (Object)new ReassignPartitionsCommand.MissingLogDirMoveState("/tmp/kafka-logs1"))}))));
    }

    @Test
    public void testGetReplicaAssignments() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForTopics((Admin)adminClient, (Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0})))})), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForPartitions((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0)}))));
        }
    }

    @Test
    public void testGetBrokerRackInformation() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList((Object[])new Node[]{new Node(0, "locahost", 9092, "rack0"), new Node(1, "locahost", 9093, "rack1"), new Node(2, "locahost", 9094, null)})).build();){
            Assertions.assertEquals((Object)new .colon.colon((Object)new BrokerMetadata(0, (Option)new Some((Object)"rack0")), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)new Some((Object)"rack1")), (List)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), true));
            Assertions.assertEquals((Object)new .colon.colon((Object)new BrokerMetadata(0, (Option)None$.MODULE$), (List)new .colon.colon((Object)new BrokerMetadata(1, (Option)None$.MODULE$), (List)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), false));
            this.assertStartsWith("Not all brokers have rack information", Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), true)).getMessage());
            Assertions.assertEquals((Object)new .colon.colon((Object)new BrokerMetadata(1, (Option)None$.MODULE$), (List)new .colon.colon((Object)new BrokerMetadata(2, (Option)None$.MODULE$), (List)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), false));
        }
    }

    @Test
    public void testParseGenerateAssignmentArgs() {
        this.assertStartsWith("Broker list contains duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "1,1,2"), () -> "Expected to detect duplicate broker list entries").getMessage());
        this.assertStartsWith("Broker list contains duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4,5"), () -> "Expected to detect duplicate broker list entries").getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 2, 3, 4})), (Object)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4"));
        this.assertStartsWith("List of topics to reassign contains duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4"), () -> "Expected to detect duplicate topic entries").getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 3, 4})), (Object)new .colon.colon((Object)"foo", (List)new .colon.colon((Object)"bar", (List)Nil$.MODULE$))), (Object)ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"bar\"}], \"version\":1}", "5,3,4"));
    }

    @Test
    public void testGenerateAssignmentFailsWithoutEnoughReplicas() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Replication factor: 3 larger than available brokers: 2", Assertions.assertThrows(InvalidReplicationFactorException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", "0,1", false), () -> "Expected generateAssignment to fail").getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGenerateAssignmentWithInconsistentRacks() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList((Object[])new Node[]{new Node(0, "locahost", 9092, "rack0"), new Node(1, "locahost", 9093, "rack0"), new Node(2, "locahost", 9094, null), new Node(3, "locahost", 9095, "rack1"), new Node(4, "locahost", 9096, "rack1"), new Node(5, "locahost", 9097, "rack2")})).build();){
            void var3_3;
            this.addTopics(adminClient);
            this.assertStartsWith("Not all brokers have rack information.", Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"}]}", "0,1,2,3", true), () -> "Expected generateAssignment to fail").getMessage());
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"}]}", "0,1,2,3", false);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map current = (Map)tuple2._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})), (Object)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGenerateAssignmentWithFewerBrokers() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            void var5_5;
            void var4_4;
            this.addTopics(adminClient);
            scala.collection.immutable.Set goalBrokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 3}));
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", goalBrokers.mkString(","), false);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map proposed = (Map)tuple2._1();
            Map current = (Map)tuple2._2();
            void proposed2 = var4_4;
            void current2 = var5_5;
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0})))})), (Object)current2);
            proposed2.values().foreach(arg_0 -> ReassignPartitionsUnitTest.$anonfun$testGenerateAssignmentWithFewerBrokers$1$adapted(goalBrokers, (Map)proposed2, arg_0));
        }
    }

    @Test
    public void testCurrentPartitionReplicaAssignmentToString() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"Current partition replica assignment", (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"{\"version\":1,\"partitions\":[{\"topic\":\"bar\",\"partition\":0,\"replicas\":[7,8],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[4,5,6],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"Save this to use as the --reassignment-json-file option during rollback", (List)Nil$.MODULE$))))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.currentPartitionReplicaAssignmentToString((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 11, 12})))}))));
    }

    @Test
    public void testMoveMap() {
        scala.collection.mutable.Map moveMap = ReassignPartitionsCommand$.MODULE$.calculateProposedMoveMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6), Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)new PartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 5}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))))})))})), (Object)moveMap);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"0:1,0:2,0:3,1:4,1:5,1:6,2:1,2:2,3:1,3:2,4:1,4:2,5:1,5:2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"0:2,0:3,0:4")})), (Object)ReassignPartitionsCommand$.MODULE$.calculateLeaderThrottles(moveMap));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"0:5,1:7,1:8,2:3,2:4,3:5,3:6,4:3,5:3,5:4,5:5,5:6"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"0:1")})), (Object)ReassignPartitionsCommand$.MODULE$.calculateFollowerThrottles(moveMap));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 8})), (Object)ReassignPartitionsCommand$.MODULE$.calculateReassigningBrokers(moveMap));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})), (Object)ReassignPartitionsCommand$.MODULE$.calculateMovingBrokers((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{new TopicPartitionReplica("quux", 0, 0), new TopicPartitionReplica("quux", 1, 2)}))));
    }

    @Test
    public void testParseExecuteAssignmentArgs() {
        this.assertStartsWith("Partition reassignment list cannot be empty", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[]}"), () -> "Expected to detect empty partition reassignment list").getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}"), () -> "Expected to detect a partition list with duplicate entries").getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}"), () -> "Expected to detect a partition replica list with duplicate entries").getMessage());
        this.assertStartsWith("Partition replica lists may not contain duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,0],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}"), () -> "Expected to detect a partition replica list with duplicate entries").getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})))})), (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[3,4,5],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}"));
        Assertions.assertEquals((Object)new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))})), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 1)), (Object)"/tmp/a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 2)), (Object)"/tmp/b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 3)), (Object)"/tmp/c")}))), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"/tmp/a\",\"/tmp/b\",\"/tmp/c\"]}]}"));
    }

    @Test
    public void testExecuteWithInvalidPartitionsFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(5).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Topic quux not found", Assertions.assertThrows(ExecutionException.class, () -> ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"quux\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", ReassignPartitionsCommand$.MODULE$.executeAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7()), () -> "Expected reassignment with non-existent topic to fail").getCause().getMessage());
        }
    }

    @Test
    public void testExecuteWithInvalidBrokerIdFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Unknown broker id 4", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", ReassignPartitionsCommand$.MODULE$.executeAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7()), () -> "Expected reassignment with non-existent broker id to fail").getMessage());
        }
    }

    @Test
    public void testModifyBrokerInterBrokerThrottle() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            ReassignPartitionsCommand$.MODULE$.modifyInterBrokerThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 1000L);
            ReassignPartitionsCommand$.MODULE$.modifyInterBrokerThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), 100L);
            Seq brokers = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)id -> ReassignPartitionsUnitTest.$anonfun$testModifyBrokerInterBrokerThrottle$1(BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).all().get();
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(0)), 100L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(1)), 1000L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(2)), 1000L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(3)), 100L, -1L);
        }
    }

    @Test
    public void testModifyLogDirThrottle() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            ReassignPartitionsCommand$.MODULE$.modifyLogDirThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 2000L);
            ReassignPartitionsCommand$.MODULE$.modifyLogDirThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), -1L);
            Seq brokers = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)id -> ReassignPartitionsUnitTest.$anonfun$testModifyLogDirThrottle$1(BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava()).all().get();
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(0)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(1)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(2)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(3)), -1L, -1L);
        }
    }

    @Test
    public void testCurReassignmentsToString() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)"No partition reassignments found.", (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
            scala.collection.immutable.Map reassignmentResult = ((TraversableOnce)ReassignPartitionsCommand$.MODULE$.alterPartitionReassignments((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 4, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                Throwable v = (Throwable)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                return tuple2;
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)reassignmentResult);
            Assertions.assertEquals((Object)new .colon.colon((Object)"Current partition reassignments:", (List)new .colon.colon((Object)"bar-0: replicas: 2,3,0. removing: 0.", (List)new .colon.colon((Object)"foo-0: replicas: 0,1,2. adding: 4.", (List)new .colon.colon((Object)"foo-1: replicas: 1,2,3. adding: 4,5. removing: 1,2.", (List)Nil$.MODULE$)))).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
        }
    }

    private void verifyBrokerThrottleResults(Config config, long expectedInterBrokerThrottle, long expectedReplicaAlterLogDirsThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put((Object)entry.name(), (Object)entry.value()));
        if (expectedInterBrokerThrottle >= 0L) {
            Assertions.assertEquals((Object)Long.toString(expectedInterBrokerThrottle), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
            Assertions.assertEquals((Object)Long.toString(expectedInterBrokerThrottle), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
        }
        if (expectedReplicaAlterLogDirsThrottle >= 0L) {
            Assertions.assertEquals((Object)Long.toString(expectedReplicaAlterLogDirsThrottle), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
        }
    }

    @Test
    public void testModifyTopicThrottles() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            ReassignPartitionsCommand$.MODULE$.modifyTopicThrottles((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"leaderFoo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"leaderBar")})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"followerBar")})));
            Seq topics = (Seq)new .colon.colon((Object)"bar", (List)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)id -> new ConfigResource(ConfigResource.Type.TOPIC, id), Seq$.MODULE$.canBuildFrom());
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
            this.verifyTopicThrottleResults((Config)results.get(topics.apply(0)), "leaderBar", "followerBar");
            this.verifyTopicThrottleResults((Config)results.get(topics.apply(1)), "leaderFoo", "");
        }
    }

    private void verifyTopicThrottleResults(Config config, String expectedLeaderThrottle, String expectedFollowerThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put((Object)entry.name(), (Object)entry.value()));
        Assertions.assertEquals((Object)expectedLeaderThrottle, (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.topicLevelLeaderThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
        Assertions.assertEquals((Object)expectedFollowerThrottle, (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.topicLevelFollowerThrottle(), (Function0 & Serializable & scala.Serializable)() -> ""));
    }

    @Test
    public void testAlterReplicaLogDirs() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Collections.nCopies(4, Arrays.asList((Object[])new String[]{"/tmp/kafka-logs0", "/tmp/kafka-logs1"}))).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{new TopicPartitionReplica("foo", 0, 0)})), (Object)ReassignPartitionsCommand$.MODULE$.alterReplicaLogDirs((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0)), (Object)"/tmp/kafka-logs1")}))));
        }
    }

    public void assertStartsWith(String prefix, String str) {
        Assertions.assertTrue((boolean)str.startsWith(prefix), (String)new StringOps(Predef$.MODULE$.augmentString("Expected the string to start with %s, but it was %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, str})));
    }

    @Test
    public void testPropagateInvalidJsonError() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Unexpected character", Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, "{invalid_json", ReassignPartitionsCommand$.MODULE$.executeAssignment$default$4(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7())).getMessage());
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ void $anonfun$testGenerateAssignmentWithFewerBrokers$1(scala.collection.immutable.Set goalBrokers$1, Map proposed$1, Seq replicas) {
        Assertions.assertTrue((boolean)replicas.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> goalBrokers$1.contains((Object)BoxesRunTime.boxToInteger((int)elem))), (String)new StringBuilder(57).append("Proposed assignment ").append(proposed$1).append(" puts replicas on brokers other than ").append(goalBrokers$1).toString());
    }

    public static final /* synthetic */ ConfigResource $anonfun$testModifyBrokerInterBrokerThrottle$1(int id) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(id));
    }

    public static final /* synthetic */ ConfigResource $anonfun$testModifyLogDirThrottle$1(int id) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(id));
    }

    public static final /* synthetic */ Object $anonfun$testGenerateAssignmentWithFewerBrokers$1$adapted(scala.collection.immutable.Set goalBrokers$1, Map proposed$1, Seq replicas) {
        ReassignPartitionsUnitTest.$anonfun$testGenerateAssignmentWithFewerBrokers$1(goalBrokers$1, proposed$1, replicas);
        return BoxedUnit.UNIT;
    }
}

