/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0010!\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004;\u0001\u0001\u0006I\u0001\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0001\u0005\u0001)A\u0005{!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005BB&\u0001A\u0003%1\tC\u0003M\u0001\u0011\u0005Q\nC\u0003_\u0001\u0011\u0005Q\nC\u0003a\u0001\u0011\u0005Q\nC\u0003c\u0001\u0011\u0005Q\nC\u0003e\u0001\u0011\u0005Q\nC\u0003g\u0001\u0011\u0005Q\nC\u0003i\u0001\u0011\u0005Q\nC\u0003k\u0001\u0011\u0005Q\nC\u0003m\u0001\u0011\u0005Q\nC\u0003o\u0001\u0011\u0005Q\nC\u0003q\u0001\u0011\u0005Q\nC\u0003s\u0001\u0011\u0005Q\nC\u0003u\u0001\u0011\u0005Q\nC\u0003w\u0001\u0011\u0005Q\nC\u0003y\u0001\u0011\u0005Q\nC\u0003{\u0001\u0011\u0005Q\nC\u0003}\u0001\u0011\u0005Q\nC\u0003\u007f\u0001\u0011\u0005Q\n\u0003\u0004\u0002\u0002\u0001!\t!\u0014\u0005\u0007\u0003\u000b\u0001A\u0011A'\t\rY\u0004A\u0011BA\u0005\u0011\u001d\t)\u0002\u0001C\u0005\u0003/A\u0011\"a\u0010\u0001#\u0003%I!!\u0011\u0003/Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1UKN$(BA\u0011#\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\r\"\u0013aC2p_J$\u0017N\\1u_JT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"!\r\u0001\u000e\u0003\u0001\nA\u0001^5nKV\tA\u0007\u0005\u00026q5\taG\u0003\u00028I\u0005)Q\u000f^5mg&\u0011\u0011H\u000e\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005Q\u0001O]8ek\u000e,'/\u00133\u0016\u0003u\u0002\"!\u000b \n\u0005}R#\u0001\u0002'p]\u001e\f1\u0002\u001d:pIV\u001cWM]%eA\u0005yAO]1og\u0006\u001cG/[8oC2LE-F\u0001D!\t!\u0015*D\u0001F\u0015\t1u)\u0001\u0003mC:<'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0016\u0013aa\u0015;sS:<\u0017\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133!\u0003M!Xm\u001d;J]&$\u0018.\u00197ju\u0016,\u0005o\\2i)\u0005q\u0005CA\u0015P\u0013\t\u0001&F\u0001\u0003V]&$\bF\u0001\u0005S!\t\u0019F,D\u0001U\u0015\t)f+A\u0002ba&T!a\u0016-\u0002\u000f),\b/\u001b;fe*\u0011\u0011LW\u0001\u0006UVt\u0017\u000e\u001e\u0006\u00027\u0006\u0019qN]4\n\u0005u#&\u0001\u0002+fgR\f1\u0003^3ti:{'/\\1m\u000bB|7\r\u001b\"v[BD#!\u0003*\u0002QQ,7\u000f\u001e\"v[B,\u0005o\\2i\u001d>$\u0018\t\u001c7po\u0016$\u0017JZ#q_\u000eD7/\u0012=iCV\u001cH/\u001a3)\u0005)\u0011\u0016A\u000b;fgR$v\u000e\\3sCR,W\u000b\u001d3bi\u0016$\u0016.\\3TQ&4G\u000fR;sS:<W\t]8dQ\n+X\u000e\u001d\u0015\u0003\u0017I\u000b1\u0007^3tiR{G.\u001a:bi\u0016,\u0006\u000fZ1uKRKW.\u001a*fg\u0016$H)\u001e:j]\u001e\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a*pi\u0006$\u0018n\u001c8)\u00051\u0011\u0016\u0001\u000b;fgR$v\u000e\\3sCR,G+[7f'\"Lg\r\u001e#ve&tw-\u00113e!\u0006\u0014H/\u001b;j_:\u001c\bFA\u0007S\u0003!\"Xm\u001d;U_2,'/\u0019;f)&lWm\u00155jMR$UO]5oOB\u0013X\r]1sK\u000e{W.\\5uQ\tq!+A\u0014uKN$Hk\u001c7fe\u0006$X\rV5nKNC\u0017N\u001a;EkJLgn\u001a)sKB\f'/Z!c_J$\bFA\bS\u0003%\"Xm\u001d;U_2,'/\u0019;f)&lWm\u00155jMR$UO]5oO\u000e{W\u000e\u001d7fi\u0016\u001cu.\\7ji\"\u0012\u0001CU\u0001)i\u0016\u001cH\u000fV8mKJ\fG/\u001a+j[\u0016\u001c\u0006.\u001b4u\tV\u0014\u0018N\\4D_6\u0004H.\u001a;f\u0003\n|'\u000f\u001e\u0015\u0003#I\u000bQ\u0005^3ti\u001a+gnY3Qe>$WoY3s\u0003\u001a$XM]#q_\u000eD7/\u0012=iCV\u001cH/\u001a3)\u0005I\u0011\u0016\u0001\f;fgR4UM\\2f!J|G-^2fe:{G/\u00117m_^,G-\u00134Ji^{W\u000f\u001c3Pm\u0016\u0014h\r\\8xQ\t\u0019\"+\u0001\u000buKN$(k\u001c;bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u0015\u0003)I\u000b!\u0005^3tiJ{G/\u0019;f!J|G-^2fe&#\u0017J\\(oO>LgnZ*uCR,\u0007FA\u000bS\u0003\u001d\"Xm\u001d;S_R\fG/\u001a)s_\u0012,8-\u001a:JI&s\u0007K]3qCJ,\u0017IY8siN#\u0018\r^3)\u0005Y\u0011\u0016\u0001\u000b;fgR\u0014v\u000e^1uKB\u0013x\u000eZ;dKJLE-\u00138Qe\u0016\u0004\u0018M]3D_6l\u0017\u000e^*uCR,\u0007FA\fS\u00039\"Xm\u001d;BiR,W\u000e\u001d;fI\u0016\u0003xn\u00195Ck6\u0004x+\u001b;i\u001d\u0016<H._\"sK\u0006$X\rZ'fi\u0006$\u0017\r^1)\u0005a\u0011\u0016!\n;fgR,\u0005o\\2i\u0005Vl\u0007oV5uQ\u000e+(O]3oi\u0016\u0003xn\u00195Qe>4\u0018\u000eZ3eQ\tI\"+A\u0012uKN$\u0018\t\u001e;f[B$X\rZ#q_\u000eD')^7q/&$\b\u000eT1ti\u0016\u0003xn\u00195)\u0005i\u0011\u0016!\n;fgR\fE\u000f^3naR,G-\u00129pG\"\u0014U/\u001c9XSRDg)\u001a8dK\u0012,\u0005o\\2iQ\tY\"\u000bF\u0002O\u0003\u0017Aq!!\u0004\u001d\u0001\u0004\ty!A\u0003ti\u0006$X\rE\u00022\u0003#I1!a\u0005!\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-A\u0014qe\u0016\u0004\u0018M]3Tk\u000e\u001cWm]:gk2Len\u0019:f[\u0016tG\u000f\u0015:pIV\u001cWM]#q_\u000eDG\u0003CA\r\u0003?\tI#!\u000f\u0011\u0007E\nY\"C\u0002\u0002\u001e\u0001\u0012!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\"9\u0011\u0011E\u000fA\u0002\u0005\r\u0012a\u0003;y]6+G/\u00193bi\u0006\u00042!MA\u0013\u0013\r\t9\u0003\t\u0002\u0014)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u0005\b\u0003Wi\u0002\u0019AA\u0017\u0003U)\u0007\u0010]3di\u0016$\u0007K]8ek\u000e,'/\u00129pG\"\u0004R!KA\u0018\u0003gI1!!\r+\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011&!\u000e\n\u0007\u0005]\"FA\u0003TQ>\u0014H\u000fC\u0005\u0002<u\u0001\n\u00111\u0001\u0002>\u0005\u0019an\\<\u0011\t%\ny#P\u00012aJ,\u0007/\u0019:f'V\u001c7-Z:tMVd\u0017J\\2sK6,g\u000e\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019E\u000b\u0003\u0002>\u0005\u00153FAA$!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E#&\u0001\u0006b]:|G/\u0019;j_:LA!!\u0016\u0002L\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TransactionMetadataTest {
    private final MockTime time = new MockTime();
    private final long producerId;
    private final String transactionalId;

    public MockTime time() {
        return this.time;
    }

    public long producerId() {
        return this.producerId;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    @Test
    public void testInitializeEpoch() {
        short producerEpoch = -1;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, this.prepareSuccessfulIncrementProducerEpoch$default$3());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testNormalEpochBump() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, this.prepareSuccessfulIncrementProducerEpoch$default$3());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testBumpEpochNotAllowedIfEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds()));
    }

    @Test
    public void testTolerateUpdateTimeShiftDuringEpochBump() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)producerEpoch)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time().milliseconds() - 1L))));
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateUpdateTimeResetDuringProducerIdRotation() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(this.producerId() + 1L, 30000, this.time().milliseconds() - 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)(this.producerId() + 1L), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringAddPartitions() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
        transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds() - 2L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic2", 0)})), (Object)txnMetadata.topicPartitions());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 2L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)PrepareCommit$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)PrepareAbort$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareCommit$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareAbort$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((Object)CompleteAbort$.MODULE$, (Object)txnMetadata.state());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assertions.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testFenceProducerAfterEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        TxnTransitMetadata fencingTransitMetadata = txnMetadata.prepareFenceProducerEpoch();
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)fencingTransitMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)fencingTransitMetadata.lastProducerEpoch());
        Assertions.assertEquals((Object)new Some((Object)PrepareEpochFence$.MODULE$), (Object)txnMetadata.pendingState());
        txnMetadata.pendingState_$eq((Option)None$.MODULE$);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)transitMetadata.producerId());
    }

    @Test
    public void testFenceProducerNotAllowedIfItWouldOverflow() {
        short producerEpoch = Short.MAX_VALUE;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        Assertions.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        Assertions.assertThrows(IllegalStateException.class, () -> txnMetadata.prepareFenceProducerEpoch());
    }

    @Test
    public void testRotateProducerId() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.lastProducerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testRotateProducerIdInOngoingState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)Ongoing$.MODULE$));
    }

    @Test
    public void testRotateProducerIdInPrepareAbortState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)PrepareAbort$.MODULE$));
    }

    @Test
    public void testRotateProducerIdInPrepareCommitState() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.testRotateProducerIdInOngoingState((TransactionState)PrepareCommit$.MODULE$));
    }

    @Test
    public void testAttemptedEpochBumpWithNewlyCreatedMetadata() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$4 = -1;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), this.prepareSuccessfulIncrementProducerEpoch$default$3());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)0, (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)-1, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testEpochBumpWithCurrentEpochProvided() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), this.prepareSuccessfulIncrementProducerEpoch$default$3());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((int)(producerEpoch + 1), (int)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithLastEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, lastProducerEpoch, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)lastProducerEpoch)), this.prepareSuccessfulIncrementProducerEpoch$default$3());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assertions.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assertions.assertEquals((short)producerEpoch, (short)txnMetadata.producerEpoch());
        Assertions.assertEquals((short)lastProducerEpoch, (short)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithFencedEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        Either result = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, lastProducerEpoch, x$6, (TransactionState)x$7, x$8, x$10, x$9).prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)((short)(lastProducerEpoch - 1)))), this.time().milliseconds());
        Assertions.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED), (Object)result);
    }

    private void testRotateProducerIdInOngoingState(TransactionState state) {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        short x$5 = -1;
        int x$6 = 30000;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, state, x$8, x$10, x$9);
        long newProducerId = 9893L;
        txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), false);
    }

    private TxnTransitMetadata prepareSuccessfulIncrementProducerEpoch(TransactionMetadata txnMetadata, Option<Object> expectedProducerEpoch, Option<Object> now) {
        Either result = txnMetadata.prepareIncrementProducerEpoch(30000, expectedProducerEpoch, BoxesRunTime.unboxToLong((Object)now.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.time().milliseconds())));
        return (TxnTransitMetadata)result.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(42).append("prepareIncrementProducerEpoch failed with ").append(result).toString());
        });
    }

    private Option<Object> prepareSuccessfulIncrementProducerEpoch$default$3() {
        return None$.MODULE$;
    }

    public TransactionMetadataTest() {
        this.producerId = 23423L;
        this.transactionalId = "txnlId";
    }
}

