/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.common.RecordValidationException;
import kafka.log.AppendOrigin;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\rEf\u0001\u0002.\\\u0001\u0001DQa\u001a\u0001\u0005\u0002!Dqa\u001b\u0001C\u0002\u0013\u0005A\u000e\u0003\u0004{\u0001\u0001\u0006I!\u001c\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nuD\u0011\"!\u0002\u0001\u0005\u0004%\t!a\u0002\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u0013A\u0011\"a\u0006\u0001\u0005\u0004%\t!!\u0007\t\u0011\u0005\r\u0003\u0001)A\u0005\u00037Aq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002f\u0001!\t!a\u0012\t\u000f\u0005%\u0004\u0001\"\u0001\u0002H!9\u0011Q\u000e\u0001\u0005\u0002\u0005\u001d\u0003bBA9\u0001\u0011%\u00111\u000f\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\ti\n\u0001C\u0005\u0003?Cq!!,\u0001\t\u0013\ty\u000bC\u0004\u0002^\u0002!\t!a\u0012\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002H!9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bbBAv\u0001\u0011\u0005\u0011q\t\u0005\b\u0003_\u0004A\u0011BAy\u0011\u001d\t9\u0010\u0001C\u0001\u0003\u000fBq!a?\u0001\t\u0003\t9\u0005C\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t\u0015\u0001\u0001\"\u0001\u0002H!9!\u0011\u0002\u0001\u0005\n\t-\u0001b\u0002B\u000e\u0001\u0011%!Q\u0004\u0005\b\u0005G\u0001A\u0011AA$\u0011\u001d\u00119\u0003\u0001C\u0001\u0003\u000fBqAa\u000b\u0001\t\u0013\u0011i\u0003C\u0004\u00032\u0001!\t!a\u0012\t\u000f\tU\u0002\u0001\"\u0001\u0002H!9!\u0011\b\u0001\u0005\n\tm\u0002b\u0002B \u0001\u0011\u0005\u0011q\t\u0005\b\u0005\u0007\u0002A\u0011AA$\u0011\u001d\u00119\u0005\u0001C\u0005\u0005\u0013BqAa\u0014\u0001\t\u0003\t9\u0005C\u0004\u0003T\u0001!\t!a\u0012\t\u000f\t]\u0003\u0001\"\u0001\u0002H!9!1\f\u0001\u0005\n\tu\u0003b\u0002B1\u0001\u0011\u0005\u0011q\t\u0005\b\u0005K\u0002A\u0011AA$\u0011\u001d\u0011I\u0007\u0001C\u0001\u0003\u000fBqA!\u001c\u0001\t\u0003\t9\u0005C\u0004\u0003r\u0001!\t!a\u0012\t\u000f\tU\u0004\u0001\"\u0001\u0002H!9!\u0011\u0010\u0001\u0005\u0002\u0005\u001d\u0003b\u0002B?\u0001\u0011\u0005\u0011q\t\u0005\b\u0005\u0003\u0003A\u0011AA$\u0011\u001d\u0011)\t\u0001C\u0001\u0003\u000fBqA!#\u0001\t\u0003\t9\u0005C\u0004\u0003\u000e\u0002!\t!a\u0012\t\u000f\tE\u0005\u0001\"\u0001\u0002H!9!Q\u0013\u0001\u0005\u0002\u0005\u001d\u0003b\u0002BM\u0001\u0011\u0005\u0011q\t\u0005\b\u0005;\u0003A\u0011AA$\u0011\u001d\u0011\t\u000b\u0001C\u0001\u0003\u000fBqA!*\u0001\t\u0003\t9\u0005C\u0004\u0003*\u0002!\t!a\u0012\t\u000f\t5\u0006\u0001\"\u0001\u0002H!9!\u0011\u0017\u0001\u0005\u0002\u0005\u001d\u0003b\u0002B[\u0001\u0011\u0005\u0011q\t\u0005\b\u0005s\u0003A\u0011AA$\u0011\u001d\u0011i\f\u0001C\u0001\u0003\u000fBqA!1\u0001\t\u0003\t9\u0005C\u0004\u0003F\u0002!\t!a\u0012\t\u000f\t%\u0007\u0001\"\u0001\u0002H!9!Q\u001a\u0001\u0005\u0002\u0005\u001d\u0003b\u0002Bi\u0001\u0011\u0005\u0011q\t\u0005\b\u0005+\u0004A\u0011AA$\u0011\u001d\u0011I\u000e\u0001C\u0001\u0003\u000fBqA!8\u0001\t\u0003\t9\u0005C\u0004\u0003b\u0002!\t!a\u0012\t\u000f\t\u0015\b\u0001\"\u0001\u0002H!9!\u0011\u001e\u0001\u0005\u0002\u0005\u001d\u0003b\u0002Bw\u0001\u0011%!q\u001e\u0005\b\u0007\u000b\u0001A\u0011BB\u0004\u0011%\u0019Y\u0002AI\u0001\n\u0013\u0019i\u0002C\u0004\u00044\u0001!Ia!\u000e\t\u0013\ru\u0002!%A\u0005\n\ru\u0001\"CB \u0001E\u0005I\u0011BB!\u0011\u001d\u0019)\u0005\u0001C\u0005\u0007\u000fBqaa\u0014\u0001\t\u0003\u0019\t\u0006C\u0004\u0004Z\u0001!Iaa\u0017\t\u000f\r\u0015\u0004\u0001\"\u0003\u0004h!911\u000f\u0001\u0005\u0002\rU\u0004bBBC\u0001\u0011\u00051q\u0011\u0005\b\u0007'\u0003A\u0011ABK\u0005Aaun\u001a,bY&$\u0017\r^8s)\u0016\u001cHO\u0003\u0002];\u0006\u0019An\\4\u000b\u0003y\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001CB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A5\u0011\u0005)\u0004Q\"A.\u0002\tQLW.Z\u000b\u0002[B\u0011a\u000e_\u0007\u0002_*\u0011\u0001/]\u0001\u0006kRLGn\u001d\u0006\u0003eN\faaY8n[>t'B\u00010u\u0015\t)h/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0006\u0019qN]4\n\u0005e|'\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001~!\tqx0D\u0001r\u0013\r\t\t!\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t+\t\tI\u0001\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!X\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005M\u0011Q\u0002\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\f\u0011C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:!\u00035iW\r\u001e:jGN\\U-_*fiV\u0011\u00111\u0004\t\u0007\u0003;\t9#a\u000b\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tq!\\;uC\ndWMC\u0002\u0002&\r\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI#a\b\u0003\u0007M+G\u000f\u0005\u0003\u0002.\u0005}RBAA\u0018\u0015\u0011\t\t$a\r\u0002\t\r|'/\u001a\u0006\u0005\u0003k\t9$A\u0004nKR\u0014\u0018nY:\u000b\t\u0005e\u00121H\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005u\u0012aA2p[&!\u0011\u0011IA\u0018\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\u000f[\u0016$(/[2t\u0017\u0016L8+\u001a;!\u0003A!Xm\u001d;P]2LxJ\\3CCR\u001c\u0007\u000e\u0006\u0002\u0002JA\u0019!-a\u0013\n\u0007\u000553M\u0001\u0003V]&$\bf\u0001\u0006\u0002RA!\u00111KA1\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013aA1qS*!\u00111LA/\u0003\u001dQW\u000f]5uKJT1!a\u0018w\u0003\u0015QWO\\5u\u0013\u0011\t\u0019'!\u0016\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cH/\u00117m_^lU\u000f\u001c;j\u0005\u0006$8\r\u001b\u0015\u0004\u0017\u0005E\u0013\u0001\u000e;fgR4\u0016\r\\5eCRLwN\\(g\u0005\u0006$8\r[3t/&$\bNT8o'\u0016\fX/\u001a8uS\u0006d\u0017J\u001c8fe>3gm]3ug\"\u001aA\"!\u0015\u0002#Q,7\u000f^'jg6\u000bGo\u00195NC\u001eL7\rK\u0002\u000e\u0003#\n\u0011c\u00195fG.|e\u000e\\=P]\u0016\u0014\u0015\r^2i)!\tI%!\u001e\u0002\u0000\u0005=\u0005bBA<\u001d\u0001\u0007\u0011\u0011P\u0001\u0006[\u0006<\u0017n\u0019\t\u0004E\u0006m\u0014bAA?G\n!!)\u001f;f\u0011\u001d\t\tI\u0004a\u0001\u0003\u0007\u000bQc]8ve\u000e,7i\\7qe\u0016\u001c8/[8o)f\u0004X\r\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tI)]\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u00055\u0015q\u0011\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"9\u0011\u0011\u0013\bA\u0002\u0005\r\u0015!\u0006;be\u001e,GoQ8naJ,7o]5p]RK\b/Z\u0001\u0015G\",7m[!mY><X*\u001e7uS\n\u000bGo\u00195\u0015\u0011\u0005%\u0013qSAM\u00037Cq!a\u001e\u0010\u0001\u0004\tI\bC\u0004\u0002\u0002>\u0001\r!a!\t\u000f\u0005Eu\u00021\u0001\u0002\u0004\u0006\u00112\r[3dW6K7/\\1uG\"l\u0015mZ5d)!\tI%!)\u0002&\u0006%\u0006bBAR!\u0001\u0007\u0011\u0011P\u0001\u000bE\u0006$8\r['bO&\u001c\u0007bBAT!\u0001\u0007\u0011\u0011P\u0001\fe\u0016\u001cwN\u001d3NC\u001eL7\rC\u0004\u0002,B\u0001\r!a!\u0002\u001f\r|W\u000e\u001d:fgNLwN\u001c+za\u0016\f\u0001C^1mS\u0012\fG/Z'fgN\fw-Z:\u0015\u0015\u0005E\u0016QZAl\u00033\fY\u000e\u0005\u0003\u00024\u0006\u001dg\u0002BA[\u0003\u0007tA!a.\u0002B:!\u0011\u0011XA`\u001b\t\tYLC\u0002\u0002>~\u000ba\u0001\u0010:p_Rt\u0014\"\u00010\n\u0005qk\u0016bAAc7\u0006aAj\\4WC2LG-\u0019;pe&!\u0011\u0011ZAf\u0005}1\u0016\r\\5eCRLwN\\!oI>3gm]3u\u0003N\u001c\u0018n\u001a8SKN,H\u000e\u001e\u0006\u0004\u0003\u000b\\\u0006bBAh#\u0001\u0007\u0011\u0011[\u0001\be\u0016\u001cwN\u001d3t!\u0011\t))a5\n\t\u0005U\u0017q\u0011\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\u0005]\u0014\u00031\u0001\u0002z!9\u0011\u0011Q\tA\u0002\u0005\r\u0005bBAI#\u0001\u0007\u00111Q\u0001!i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,gj\u001c8D_6\u0004(/Z:tK\u00124\u0016\u0007K\u0002\u0013\u0003#\n\u0001\u0005^3ti2{w-\u00119qK:$G+[7f\u001d>t7i\\7qe\u0016\u001c8/\u001a3We!\u001a1#!\u0015\u0002?\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,G\r\u0006\u0003\u0002J\u0005%\bbBA<)\u0001\u0007\u0011\u0011P\u0001%i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Wc!\u001aQ#!\u0015\u0002G\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]R!\u0011\u0011JAz\u0011\u001d\t)P\u0006a\u0001\u0003s\n1\u0002^1sO\u0016$X*Y4jG\u0006!C/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRD'+Z2p[B\u0014Xm]:j_:4&\u0007K\u0002\u0018\u0003#\nq\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Wc!\u001a\u0001$!\u0015\u0002M\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"|W\u000f\u001e*fG>l\u0007O]3tg&|g\u000e\u0006\u0003\u0002J\t\r\u0001bBA<3\u0001\u0007\u0011\u0011P\u0001%i\u0016\u001cH/\u00138wC2LGm\u00144gg\u0016$(+\u00198hK\u0006sGMU3d_J$7i\\;oi\"\u001a!$!\u0015\u0002A\u0005\u001c8/\u001a:u\u0013:4\u0018\r\\5e\u0005\u0006$8\r[\"pk:$xJ^3se&$Wm\u001d\u000b\u0007\u0003\u0013\u0012iAa\u0006\t\u000f\t=1\u00041\u0001\u0003\u0012\u0005yA.Y:u\u001f\u001a47/\u001a;EK2$\u0018\rE\u0002c\u0005'I1A!\u0006d\u0005\rIe\u000e\u001e\u0005\b\u00053Y\u0002\u0019\u0001B\t\u0003\u0015\u0019w.\u001e8u\u0003\u00152\u0018\r\\5eCR,'+Z2pe\u0012\u0014\u0015\r^2i/&$\bnQ8v]R|e/\u001a:sS\u0012,7\u000f\u0006\u0004\u0002J\t}!\u0011\u0005\u0005\b\u0005\u001fa\u0002\u0019\u0001B\t\u0011\u001d\u0011I\u0002\ba\u0001\u0005#\tq\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8We!\u001aQ$!\u0015\u0002'Q,7\u000f\u001e(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007y\t\t&\u0001\ndQ\u0016\u001c7NT8o\u0007>l\u0007O]3tg\u0016$G\u0003BA%\u0005_Aq!a\u001e \u0001\u0004\tI(A\nuKN$hj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u0002!\u0003#\n1\u0003^3tiJ+7m\\7qe\u0016\u001c8/[8o-FB3!IA)\u0003I\u0019\u0007.Z2l%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8\u0015\t\u0005%#Q\b\u0005\b\u0003o\u0012\u0003\u0019AA=\u0003M!Xm\u001d;SK\u000e|W\u000e\u001d:fgNLwN\u001c,3Q\r\u0019\u0013\u0011K\u0001!i\u0016\u001cHo\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c,1)>4\u0016\u0007K\u0002%\u0003#\n\u0011e\u00195fG.\u001c%/Z1uKRKW.Z+q\u0007>tg/\u001a:tS>tgI]8n-B\"B!!\u0013\u0003L!9!QJ\u0013A\u0002\u0005e\u0014a\u0002;p\u001b\u0006<\u0017nY\u0001!i\u0016\u001cHo\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c,1)>4&\u0007K\u0002'\u0003#\n\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0016\u0007V8We!\u001aq%!\u0015\u0002!Q,7\u000f^\"p[B\u0014Xm]:fIZ\u000b\u0004f\u0001\u0015\u0002R\u0005y1\r[3dW\u000e{W\u000e\u001d:fgN,G\r\u0006\u0003\u0002J\t}\u0003bBA<S\u0001\u0007\u0011\u0011P\u0001\u0011i\u0016\u001cHoQ8naJ,7o]3e-JB3AKA)\u0003\u0011\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016tuN\\\"p[B\u0014Xm]:fIZ\u000b\u0004fA\u0016\u0002R\u0005!C/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,gj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u0002-\u0003#\n\u0011\u0005^3ti&sg/\u00197jI\u000e\u0013X-\u0019;f)&lWmQ8naJ,7o]3e-FB3!LA)\u0003\u0005\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\rq\u0013\u0011K\u0001*i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007=\n\t&\u0001\u0014uKN$\u0018IY:pYV$Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;D_6\u0004(/Z:tK\u0012D3\u0001MA)\u0003-\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]RtuN\\\"p[B\u0014Xm]:fIZ\u000b\u0004fA\u0019\u0002R\u0005YC/Z:u%\u0016d\u0017\r^5wK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$hj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u00023\u0003#\n\u0001\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGoQ8naJ,7o]3e-FB3aMA)\u0003!\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]R\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\r!\u0014\u0011K\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8Wc9{gnQ8naJ,7o]3eQ\r)\u0014\u0011K\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8We9{gnQ8naJ,7o]3eQ\r1\u0014\u0011K\u00016i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8Wc\r{W\u000e\u001d:fgN,G\rK\u00028\u0003#\nQ\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{gKM\"p[B\u0014Xm]:fI\"\u001a\u0001(!\u0015\u0002OQ,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014Hm\u001d(pi\u0006cGn\\<fI\u001a\u0013x.\\\"mS\u0016tGo\u001d\u0015\u0004s\u0005E\u0013a\b;fgR\u001cuN\u001c;s_2\u0014VmY8sINtu\u000e^\"p[B\u0014Xm]:fI\"\u001a!(!\u0015\u0002uQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,2)>4\u0006GT8o\u0007>l\u0007O]3tg\u0016$\u0007fA\u001e\u0002R\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-F\"vN\u0016\u0019D_6\u0004(/Z:tK\u0012D3\u0001PA)\u0003a\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gNV\u0019U_Z\u0013dj\u001c8D_6\u0004(/Z:tK\u0012D3!PA)\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gNV\u0019U_Z\u00134i\\7qe\u0016\u001c8/\u001a3)\u0007y\n\t&\u0001\u001euKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014Hi\\<o\u0007>tg/\u001a:tS>tgK\r+p-FruN\\\"p[B\u0014Xm]:fI\"\u001aq(!\u0015\u0002oQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0016gQ8naJ,7o]3eQ\r\u0001\u0015\u0011K\u00015i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gn\u00144Ue\u0006t7/Y2uS>t\u0017\r\u001c*fG>\u0014Hm\u001d(piB+'/\\5ui\u0016$\u0007fA!\u0002R\u0005\tD/Z:u\t><hnQ8om\u0016\u00148/[8o\u001f\u001aLE-Z7q_R,g\u000e\u001e*fG>\u0014Hm\u001d(piB+'/\\5ui\u0016$\u0007f\u0001\"\u0002R\u0005QD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vN\u0016\u0019O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004\u0007\u0006E\u0013a\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4&\u0007V8Wa\r{W\u000e\u001d:fgN,G\rK\u0002E\u0003#\n!\u0007^3ti:{g.\u00138de\u0016\f7/\u001b8h\u001f\u001a47/\u001a;SK\u000e|'\u000f\u001a\"bi\u000eD\u0007*Y:NKR\u0014\u0018nY:M_\u001e<W\r\u001a\u0015\u0004\u000b\u0006E\u0013a\u000b;fgR\u001cu.\u001c9sKN\u001cX\r\u001a\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3)\u0007\u0019\u000b\t&A\u0016uKN$(l\u0015;e\u0007>l\u0007O]3tg\u0016$w+\u001b;i+:\fg/Y5mC\ndW-\u0013\"Q-\u0016\u00148/[8oQ\r9\u0015\u0011K\u0001.i\u0016\u001cH/\u00168d_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007f\u0001%\u0002R\u0005iC/Z:u%\u0016\u001cw.\u001c9sKN\u001cX\r\u001a\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3)\u0007%\u000b\t&\u0001\u0016uKN$\u0018J\u001c<bY&$G+[7fgR\fW\u000e]#yG\u0016\u0004H/[8o\u0011\u0006\u001c()\u0019;dQ&sG-\u001a=)\u0007)\u000b\t&A\u0014uKN$\u0018J\u001c<bY&$'+Z2pe\u0012,\u0005pY3qi&|g\u000eS1t\u0005\u0006$8\r[%oI\u0016D\bfA&\u0002R\u0005qC/Z:u\u0005\u0006$8\r[,ji\"LeN^1mS\u0012\u0014VmY8sIN\fe\u000eZ%om\u0006d\u0017\u000e\u001a+j[\u0016\u001cH/Y7qQ\ra\u0015\u0011K\u0001\"i\u0016\u001cHOQ1uG\"<\u0016\u000e\u001e5pkR\u0014VmY8sINtu\u000e^!mY><X\r\u001a\u000b\u0007\u0003\u0013\u0012\tp!\u0001\t\u000f\tMX\n1\u0001\u0003v\u0006Y1o\\;sG\u0016\u001cu\u000eZ3d!\u0011\u00119P!@\u000e\u0005\te(b\u0001B~;\u00069Q.Z:tC\u001e,\u0017\u0002\u0002B\u0000\u0005s\u0014\u0001cQ8naJ,7o]5p]\u000e{G-Z2\t\u000f\r\rQ\n1\u0001\u0003v\u0006YA/\u0019:hKR\u001cu\u000eZ3d\u00035\u0019'/Z1uKJ+7m\u001c:egRA\u0011\u0011[B\u0005\u0007\u001b\u00199\u0002C\u0004\u0004\f9\u0003\r!!\u001f\u0002\u00155\fw-[2WC2,X\rC\u0005\u0004\u00109\u0003\n\u00111\u0001\u0004\u0012\u0005IA/[7fgR\fW\u000e\u001d\t\u0004E\u000eM\u0011bAB\u000bG\n!Aj\u001c8h\u0011\u001d\u0019IB\u0014a\u0001\u0003\u0007\u000bQaY8eK\u000e\fqc\u0019:fCR,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r}!\u0006BB\t\u0007CY#aa\t\u0011\t\r\u00152qF\u0007\u0003\u0007OQAa!\u000b\u0004,\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007[\u0019\u0017AC1o]>$\u0018\r^5p]&!1\u0011GB\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001!GJ,\u0017\r^3O_:Len\u0019:fCNLgnZ(gMN,GOU3d_J$7\u000f\u0006\u0005\u0002R\u000e]2\u0011HB\u001e\u0011\u001d\u0019Y\u0001\u0015a\u0001\u0003sB\u0011ba\u0004Q!\u0003\u0005\ra!\u0005\t\u0013\re\u0001\u000b%AA\u0002\u0005\r\u0015AK2sK\u0006$XMT8o\u0013:\u001c'/Z1tS:<wJ\u001a4tKR\u0014VmY8sIN$C-\u001a4bk2$HEM\u0001+GJ,\u0017\r^3O_:Len\u0019:fCNLgnZ(gMN,GOU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\u0019E\u000b\u0003\u0002\u0004\u000e\u0005\u0012aF2sK\u0006$X\rV<p\u0005\u0006$8\r[3e%\u0016\u001cwN\u001d3t)!\t\tn!\u0013\u0004L\r5\u0003bBB\u0006'\u0002\u0007\u0011\u0011\u0010\u0005\b\u0007\u001f\u0019\u0006\u0019AB\t\u0011\u001d\u0019Ib\u0015a\u0001\u0003\u0007\u000bAb\u00195fG.|eMZ:fiN$b!!\u0013\u0004T\rU\u0003bBAh)\u0002\u0007\u0011\u0011\u001b\u0005\b\u0007/\"\u0006\u0019AB\t\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u0001%e\u0016\u001cwN\u001d3t/&$\bNT8o'\u0016\fX/\u001a8uS\u0006d\u0017J\u001c8fe>3gm]3ugRA\u0011\u0011[B/\u0007?\u001a\t\u0007C\u0004\u0004\fU\u0003\r!!\u001f\t\u000f\reQ\u000b1\u0001\u0002\u0004\"911M+A\u0002\tE\u0011A\u00038v[J+7m\u001c:eg\u0006a\"/Z2pe\u0012\u001cx+\u001b;i\u0013:4\u0018\r\\5e\u0013:tWM]'bO&\u001cG\u0003CAi\u0007S\u001aig!\u001d\t\u000f\r-d\u000b1\u0001\u0002z\u0005y!-\u0019;dQ6\u000bw-[2WC2,X\rC\u0004\u0004pY\u0003\r!!\u001f\u0002!I,7m\u001c:e\u001b\u0006<\u0017n\u0019,bYV,\u0007bBB\r-\u0002\u0007\u00111Q\u0001\u0018[\u0006L(-Z\"iK\u000e\\')Y:f)&lWm\u001d;b[B$b!!\u0013\u0004x\rm\u0004bBB=/\u0002\u00071\u0011C\u0001\tKb\u0004Xm\u0019;fI\"91QP,A\u0002\r}\u0014!\u00022bi\u000eD\u0007\u0003BAC\u0007\u0003KAaa!\u0002\b\nY!+Z2pe\u0012\u0014\u0015\r^2i\u0003U1\u0018\r\\5eCR,Gj\\4BaB,g\u000e\u001a+j[\u0016$\u0002\"!\u0013\u0004\n\u000e55\u0011\u0013\u0005\b\u0007\u0017C\u0006\u0019AB\t\u0003U)\u0007\u0010]3di\u0016$Gj\\4BaB,g\u000e\u001a+j[\u0016Dqaa$Y\u0001\u0004\u0019\t\"A\u000bfqB,7\r^3e\u0005\u0006\u001cX\rV5nKN$\u0018-\u001c9\t\u000f\ru\u0004\f1\u0001\u0004\u0000\u0005Yb/\u001a:jMf\u0014VmY8sI\u000e{gN^3sg&|gn\u0015;biN$\"\"!\u0013\u0004\u0018\u000e\u00056QUBT\u0011\u001d\u0019I*\u0017a\u0001\u00077\u000bQa\u001d;biN\u0004B!!\"\u0004\u001e&!1qTAD\u0005U\u0011VmY8sI\u000e{gN^3sg&|gn\u0015;biNDqaa)Z\u0001\u0004\u0011\t\"A\nok6\u001cuN\u001c<feR,GMU3d_J$7\u000fC\u0004\u0002Pf\u0003\r!!5\t\u000f\r%\u0016\f1\u0001\u0004,\u0006Q1m\\7qe\u0016\u001c8/\u001a3\u0011\u0007\t\u001ci+C\u0002\u00040\u000e\u0014qAQ8pY\u0016\fg\u000e")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Set<MetricName> metricsKeySet = (Set)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testValidationOfBatchesWithNonSequentialInnerOffsets() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RecordVersion.values())).foreach((Function1 & Serializable & scala.Serializable)version -> {
            this.testMessageValidation$1(version.value);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(this.recordsWithInvalidInnerMagic(batchMagic, recordMagic, compressionType), batchMagic, compressionType, compressionType));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$checkMismatchMagic$2(x$2))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    private LogValidator.ValidationAndOffsetAssignResult validateMessages(MemoryRecords records, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), 0L, CompressionCodec$.MODULE$.getCompressionCodec(sourceCompressionType.name), CompressionCodec$.MODULE$.getCompressionCodec(targetCompressionType.name), false, magic, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_3_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    @Test
    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size(), (String)"message set size should not change");
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should not have been changed");
        int expectedMaxTimestampOffset = magic >= 2 ? 2 : 0;
        Assertions.assertEquals((long)expectedMaxTimestampOffset, (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(expectedMaxTimestampOffset).toString());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size(), (String)"message set size should not change");
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, -1L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size may have been changed");
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size(), (String)"message set size should not change");
        validatedRecords.batches().forEach(batch -> this.validateLogAppendTime(now, 1234L, (RecordBatch)batch));
        Assertions.assertTrue((boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid(), (String)"MessageSet should still valid");
        Assertions.assertEquals((long)now, (long)validatedResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions.assertThrows(InvalidRecordException.class, () -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonCompressed(byte magic) {
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (int)var11_9, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkNonCompressed$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (boolean)var10_8, (int)var11_9, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp(), (String)"Offset of max timestamp should be 1");
        Assertions.assertFalse((boolean)validatingResults.messageSizeMaybeChanged(), (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRecompression(byte magic) {
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (int)var11_9, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkRecompression$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (int)var11_9, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatingResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp(), (String)"Offset of max timestamp should be 2");
        Assertions.assertTrue((boolean)validatingResults.messageSizeMaybeChanged(), (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        int x$15 = -1;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, toMagic, x$13, x$14, x$15, (AppendOrigin)x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)validatedResults.maxTimestamp(), (long)-1L, (String)new StringBuilder(24).append("Max timestamp should be ").append(-1L).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        long timestamp = System.currentTimeMillis();
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        MemoryRecords records = this.createRecords(x$1, timestamp, x$2);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        byte x$11 = 2;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        int x$15 = -1;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, timestamp, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, x$11, x$13, x$14, x$15, (AppendOrigin)x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString());
        Assertions.assertTrue((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkCompressed(byte magic) {
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        boolean x$9 = false;
        TimestampType x$10 = TimestampType.CREATE_TIME;
        long x$11 = 1000L;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, magic, x$10, x$11, (int)var11_9, (AppendOrigin)x$13, x$14, x$15);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkCompressed$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (int)var11_9, i, arg_0));
        Assertions.assertEquals((long)(now + 1L), (long)validatedResults.maxTimestamp(), (String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString());
        Assertions.assertEquals((long)(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp(), (String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString());
        Assertions.assertFalse((boolean)validatedResults.messageSizeMaybeChanged(), (String)"Message size should not have been changed");
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()));
    }

    @Test
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        Assertions.assertThrows(RecordValidationException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()));
    }

    @Test
    public void testInvalidCreateTimeCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        Assertions.assertThrows(RecordValidationException.class, () -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            byte x$8 = 1;
            boolean x$9 = false;
            TimestampType x$10 = TimestampType.CREATE_TIME;
            long x$11 = 1000L;
            int x$12 = -1;
            AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
            ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
            BrokerTopicStats x$15 = this.brokerTopicStats();
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
        });
    }

    @Test
    public void testInvalidCreateTimeCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        Assertions.assertThrows(RecordValidationException.class, () -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            byte x$8 = 1;
            boolean x$9 = false;
            TimestampType x$10 = TimestampType.CREATE_TIME;
            long x$11 = 1000L;
            int x$12 = -1;
            AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
            ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
            BrokerTopicStats x$15 = this.brokerTopicStats();
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
        });
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef((long)offset);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        NoCompressionCodec$ x$9 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$10 = NoCompressionCodec$.MODULE$;
        byte x$11 = 0;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        int x$15 = -1;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, x$11, x$13, x$14, x$15, (AppendOrigin)x$16, x$17, x$18).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        Assertions.assertThrows(InvalidRecordException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()));
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        List batches = TestUtils.toList((Iterable)LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords().batches());
        Assertions.assertEquals((int)1, (int)batches.size());
        Assertions.assertFalse((boolean)((MutableRecordBatch)batches.get(0)).isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()));
    }

    @Test
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        Assertions.assertThrows(UnsupportedForMessageFormatException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()));
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records = this.createNonIncreasingOffsetRecords((byte)2, this.createNonIncreasingOffsetRecords$default$2(), this.createNonIncreasingOffsetRecords$default$3());
        ((MutableRecordBatch)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head()).setLastOffset(2L);
        Assertions.assertThrows(InvalidRecordException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()));
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(x$9))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        Assertions.assertThrows(UnsupportedCompressionTypeException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_0_IV1$.MODULE$, this.brokerTopicStats()));
    }

    @Test
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            byte x$8 = 1;
            boolean x$9 = false;
            TimestampType x$10 = TimestampType.CREATE_TIME;
            long x$11 = 1000L;
            int x$12 = -1;
            AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
            ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
            BrokerTopicStats x$15 = this.brokerTopicStats();
            LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
        });
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)3);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(this.recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assertions.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assertions.assertEquals((int)e.recordErrors().size(), (int)20);
        e.recordErrors().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            LogValidatorTest.$anonfun$testInvalidRecordExceptionHasBatchIndex$2(x$10);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testBatchWithInvalidRecordsAndInvalidTimestamp() {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)0);
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)1200L, null, (byte[])"timestamp".getBytes()));
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions.assertThrows(RecordValidationException.class, () -> this.validateMessages(invalidOffsetTimestampRecords, (byte)0, CompressionType.GZIP, CompressionType.GZIP));
        Assertions.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assertions.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assertions.assertEquals((int)6, (int)e.recordErrors().size());
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        long l = 1324L;
        short s = (short)10;
        int n = 984;
        boolean bl = true;
        int n2 = 40;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)l, (short)s, (int)n, (long)0L, (long)5L, (int)n2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)bl, (boolean)false);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        Assertions.assertThrows(InvalidRecordException.class, () -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()));
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    private MemoryRecords createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        Assertions.assertTrue((boolean)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).nonEmpty(), (String)"Message set should not be empty");
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    private MemoryRecords recordsWithNonSequentialInnerOffsets(byte magicValue, CompressionType codec, int numRecords) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithNonSequentialInnerOffsets$1(BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            builder.appendUncheckedWithOffset(0L, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private MemoryRecords recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue, BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.sizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)1234567);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        if (batch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)batch;
            Assertions.assertEquals((long)expected, (long)defaultRecordBatch.firstTimestamp(), (String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString());
            return;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assertions.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assertions.assertEquals((long)expectedLogAppendTime, (long)batch.maxTimestamp(), (String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assertions.assertNotNull((Object)stats, (String)"Records processing info is null");
        Assertions.assertEquals((int)numConvertedRecords, (int)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assertions.assertTrue((stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString());
            Assertions.assertTrue((stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0, (String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString());
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assertions.assertTrue((tempBytes > (long)originalSize ? 1 : 0) != 0, (String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString());
            return;
        }
        if (numConvertedRecords > 0 || compressed) {
            Assertions.assertTrue((tempBytes > 0L ? 1 : 0) != 0, (String)"Temp bytes not updated");
            return;
        }
        Assertions.assertEquals((long)0L, (long)tempBytes);
    }

    private final void testMessageValidation$1(byte magicValue) {
        int numRecords = 20;
        MemoryRecords invalidRecords = this.recordsWithNonSequentialInnerOffsets(magicValue, CompressionType.GZIP, numRecords);
        if (magicValue >= 2) {
            Assertions.assertThrows(InvalidRecordException.class, () -> this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP));
            return;
        }
        LogValidator.ValidationAndOffsetAssignResult result = this.validateMessages(invalidRecords, magicValue, CompressionType.GZIP, CompressionType.GZIP);
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords), (Object)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(result.validatedRecords().records()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()), Iterable$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$checkMismatchMagic$2(MetricName x$2) {
        return x$2.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(Seq timestampSeq$1, IntRef i$1, Record record) {
        Assertions.assertTrue((boolean)record.isValid());
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$1, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$1, (int)batch.baseSequence());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
        Assertions.assertEquals((int)partitionLeaderEpoch$1, (int)batch.partitionLeaderEpoch());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(Seq timestampSeq$2, IntRef i$2, Record record) {
        Assertions.assertTrue((boolean)record.isValid());
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$2, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$2, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$2, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$2, (int)batch.partitionLeaderEpoch());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assertions.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assertions.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
        Assertions.assertEquals((long)-1L, (long)batch.producerId());
        Assertions.assertEquals((int)-1, (int)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(Seq timestampSeq$3, IntRef i$3, Record record) {
        Assertions.assertTrue((boolean)record.isValid());
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assertions.assertTrue((boolean)batch.isValid());
        Assertions.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assertions.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assertions.assertEquals((short)producerEpoch$3, (short)batch.producerEpoch());
        Assertions.assertEquals((long)producerId$3, (long)batch.producerId());
        Assertions.assertEquals((int)baseSequence$3, (int)batch.baseSequence());
        Assertions.assertEquals((int)partitionLeaderEpoch$3, (int)batch.partitionLeaderEpoch());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(MetricName x$9) {
        return x$9.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$testInvalidRecordExceptionHasBatchIndex$2(ProduceResponse.RecordError x$10) {
        Assertions.assertNotNull((Object)x$10);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(int id) {
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(IntRef offset$4, MemoryRecordsBuilder builder$1, LegacyRecord record) {
        offset$4.elem += 30;
        builder$1.appendUncheckedWithOffset((long)offset$4.elem, record);
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$6, Record entry) {
        Assertions.assertEquals((long)offset$6.elem, (long)entry.offset(), (String)"Unexpected offset in message set iterator");
        ++offset$6.elem;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$recordsWithNonSequentialInnerOffsets$1(int id) {
        return new SimpleRecord(Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(byte recordMagicValue$1, int id) {
        return LegacyRecord.create((byte)recordMagicValue$1, (long)-1L, (byte[])Integer.toString(id).getBytes(), (byte[])Integer.toString(id).getBytes());
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$3, IntRef offset$7, LegacyRecord record) {
        builder$3.appendUncheckedWithOffset((long)offset$7.elem, record);
        ++offset$7.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        Assertions.assertTrue((boolean)record.isValid());
        Assertions.assertEquals((long)expectedLogAppendTime$1, (long)record.timestamp(), (String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString());
    }

    public static final /* synthetic */ Object $anonfun$checkNonCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkNonCompressed$1($this, timestampSeq$1, producerEpoch$1, producerId$1, baseSequence$1, isTransactional$1, partitionLeaderEpoch$1, i$1, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkRecompression$1$adapted(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkRecompression$1($this, timestampSeq$2, producerEpoch$2, producerId$2, baseSequence$2, partitionLeaderEpoch$2, i$2, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkCompressed$1($this, timestampSeq$3, producerEpoch$3, producerId$3, baseSequence$3, partitionLeaderEpoch$3, i$3, batch);
        return BoxedUnit.UNIT;
    }
}

