/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001B#G\u0001-CQA\u0015\u0001\u0005\u0002MCqA\u0016\u0001A\u0002\u0013\u0005q\u000bC\u0004a\u0001\u0001\u0007I\u0011A1\t\r\u001d\u0004\u0001\u0015)\u0003Y\u0011\u001dA\u0007\u00011A\u0005\u0002%Dq!\u001c\u0001A\u0002\u0013\u0005a\u000e\u0003\u0004q\u0001\u0001\u0006KA\u001b\u0005\bc\u0002\u0011\r\u0011\"\u0001s\u0011\u0019q\b\u0001)A\u0005g\"Aq\u0010\u0001b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\n\u0001\u0001\u000b\u0011BA\u0002\u0011%\tY\u0001\u0001b\u0001\n\u0003\ti\u0001\u0003\u0005\u0002\u0016\u0001\u0001\u000b\u0011BA\b\u0011%\t9\u0002\u0001b\u0001\n\u0003\tI\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u000e\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!a\u0011\u0001\t\u0003\tY\u0003C\u0004\u0002N\u0001!\t!a\u000b\t\u000f\u0005]\u0003\u0001\"\u0001\u0002,!9\u00111\f\u0001\u0005\u0002\u0005-\u0002bBA0\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003G\u0002A\u0011AA\u0016\u0011\u001d\t9\u0007\u0001C\u0001\u0003WAq!a\u001b\u0001\t\u0003\tY\u0003C\u0004\u0002p\u0001!\t!a\u000b\t\u000f\u0005M\u0004\u0001\"\u0001\u0002,!9\u0011q\u000f\u0001\u0005\u0002\u0005-\u0002bBA>\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003\u007f\u0002A\u0011AA\u0016\u0011\u001d\t\u0019\t\u0001C\u0001\u0003WAq!a\"\u0001\t\u0003\tY\u0003C\u0004\u0002\f\u0002!\t!a\u000b\t\u000f\u0005=\u0005\u0001\"\u0001\u0002,!9\u00111\u0013\u0001\u0005\u0002\u0005-\u0002bBAL\u0001\u0011\u0005\u00111\u0006\u0005\b\u00037\u0003A\u0011AA\u0016\u0011\u001d\ty\n\u0001C\u0001\u0003WAq!a)\u0001\t\u0003\tY\u0003C\u0004\u0002(\u0002!\t!a\u000b\t\u000f\u0005-\u0006\u0001\"\u0001\u0002,!9\u0011q\u0016\u0001\u0005\u0002\u0005-\u0002bBAZ\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003o\u0003A\u0011AA\u0016\u0011\u001d\tY\f\u0001C\u0001\u0003WAq!a0\u0001\t\u0003\tY\u0003C\u0004\u0002D\u0002!\t!a\u000b\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002,!9\u00111\u001a\u0001\u0005\u0002\u0005-\u0002bBAh\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003'\u0004A\u0011AA\u0016\u0011\u001d\t9\u000e\u0001C\u0001\u0003WAq!a7\u0001\t\u0003\tY\u0003C\u0004\u0002`\u0002!\t!a\u000b\t\u000f\u0005\r\b\u0001\"\u0001\u0002,!9\u0011q\u001d\u0001\u0005\u0002\u0005-\u0002bBAv\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003_\u0004A\u0011AA\u0016\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003WAq!a>\u0001\t\u0013\tI\u0010C\u0004\u0003\u0016\u0001!IAa\u0006\t\u0013\tE\u0003!%A\u0005\n\tM\u0003\"\u0003B5\u0001E\u0005I\u0011\u0002B6\u0011\u001d\u0011y\u0007\u0001C\u0005\u0005cB\u0011B!&\u0001#\u0003%IAa\u001b\t\u0013\t]\u0005!%A\u0005\n\te\u0005\"\u0003BO\u0001E\u0005I\u0011\u0002BP\u0011\u001d\u0011y\u0007\u0001C\u0005\u0005GCqAa.\u0001\t\u0013\u0011IL\u0001\rQe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d+fgRT!a\u0012%\u0002\u00071|wMC\u0001J\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0003=\u000bQa]2bY\u0006L!!\u0015(\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u000b\u0005\u0002V\u00015\ta)\u0001\u0004m_\u001e$\u0015N]\u000b\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0003S>T\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003E\u0016\u0004\"!T2\n\u0005\u0011t%\u0001B+oSRDqAZ\u0002\u0002\u0002\u0003\u0007\u0001,A\u0002yIE\nq\u0001\\8h\t&\u0014\b%\u0001\u0007ti\u0006$X-T1oC\u001e,'/F\u0001k!\t)6.\u0003\u0002m\r\n!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\f\u0001c\u001d;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\u0005\t|\u0007b\u00024\u0007\u0003\u0003\u0005\rA[\u0001\u000egR\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tW#A:\u0011\u0005QdX\"A;\u000b\u0005Y<\u0018AB2p[6|gN\u0003\u0002Jq*\u0011\u0011P_\u0001\u0007CB\f7\r[3\u000b\u0003m\f1a\u001c:h\u0013\tiXO\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\u0006qe>$WoY3s\u0013\u0012,\"!a\u0001\u0011\u00075\u000b)!C\u0002\u0002\b9\u0013A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u0003Ii\u0017\r\u001f)jI\u0016C\b/\u001b:bi&|g.T:\u0016\u0005\u0005=\u0001cA'\u0002\u0012%\u0019\u00111\u0003(\u0003\u0007%sG/A\nnCb\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\u0003uS6,WCAA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011k\u0006)Q\u000f^5mg&!\u0011QEA\u0010\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!B:fiV\u0003H#\u00012)\u0007A\ty\u0003\u0005\u0003\u00022\u0005}RBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002:\u0005m\u0012a\u00026va&$XM\u001d\u0006\u0004\u0003{Q\u0018!\u00026v]&$\u0018\u0002BA!\u0003g\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\t\u0002HA!\u0011\u0011GA%\u0013\u0011\tY%a\r\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0005;fgR\u0014\u0015m]5d\u0013\u0012l\u0015\r\u001d9j]\u001eD3AEA)!\u0011\t\t$a\u0015\n\t\u0005U\u00131\u0007\u0002\u0005)\u0016\u001cH/\u0001\u0014uKN$\u0018\t\u001d9f]\u0012$\u0006P\\'be.,'oV5uQ:{\u0007K]8ek\u000e,'o\u0015;bi\u0016D3aEA)\u0003y!Xm\u001d;Qe>$WoY3s'\u0016\fX/\u001a8dK^\u0013\u0018\r]!s_VtG\rK\u0002\u0015\u0003#\nQ\u0006^3tiB\u0013x\u000eZ;dKJ\u001cV-];f]\u000e,w+\u001b;i/J\f\u0007/\u0011:pk:$')\u0019;dQJ+7m\u001c:eQ\r)\u0012\u0011K\u0001&i\u0016\u001cH\u000f\u0015:pIV\u001cWM]*fcV,gnY3J]Z\fG.\u001b3Xe\u0006\u0004\u0018I]8v]\u0012D3AFA)\u0003)\"Xm\u001d;O_Z\u000bG.\u001b3bi&|gn\u00148GSJ\u001cH/\u00128uef<\u0006.\u001a8M_\u0006$\u0017N\\4M_\u001eD3aFA)\u0003\r\"Xm\u001d;D_:$(o\u001c7SK\u000e|'\u000f\u001a\"v[B\u001c\bK]8ek\u000e,'/\u00129pG\"D3\u0001GA)\u0003\u0001\"Xm\u001d;Uq:4\u0015N]:u\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a3)\u0007e\t\t&A\ruKN$8k[5q\u000b6\u0004H/\u001f+sC:\u001c\u0018m\u0019;j_:\u001c\bf\u0001\u000e\u0002R\u0005\u0001C/Z:u\u0019\u0006\u001cHo\u0015;bE2,wJ\u001a4tKR\u001cu.\u001c9mKR,G\r\u0016=oQ\rY\u0012\u0011K\u0001\u001fi\u0016\u001cH\u000f\u0015:fa\u0006\u0014X-\u00169eCR,Gi\\3t\u001d>$X*\u001e;bi\u0016D3\u0001HA)\u0003y)\b\u000fZ1uKB\u0013x\u000eZ;dKJ$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X\rK\u0002\u001e\u0003#\nA\u0006^3ti>+Ho\u00144TKF,XM\\2f\u0003\u001a$XM]\"p]R\u0014x\u000e\u001c*fG>\u0014H-\u00129pG\"\u0014U/\u001c9)\u0007y\t\t&\u0001\u0019uKN$hj\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\!qa\u0016tGmV5uQ>swm\\5oOR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004?\u0005E\u0013a\f;fgR$&/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a*f[>4Xm](vi>3'+\u00198hKNs\u0017\r]:i_R\u001c\bf\u0001\u0011\u0002R\u0005\u0001B/Z:u)\u0006\\Wm\u00158baNDw\u000e\u001e\u0015\u0004C\u0005E\u0013\u0001\f;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u+:4\u0017N\\5tQ\u0016$GK]1og\u0006\u001cG/[8oQ\r\u0011\u0013\u0011K\u0001+i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_R4\u0015N\\5tQ\u0016$GK]1og\u0006\u001cG/[8oQ\r\u0019\u0013\u0011K\u0001(i\u0016\u001cHOU3d_Z,'O\u0012:p[Ns\u0017\r]:i_R,U\u000e\u001d;z)J\fgn]1di&|g\u000eK\u0002%\u0003#\n\u0001\u0006^3tiB\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u0003\u001a$XM\u001d$f]\u000eLgnZ!c_J$X*\u0019:lKJD3!JA)\u0003u!Xm\u001d;SK6|g/Z#ya&\u0014X\r\u001a)jIN|eNU3m_\u0006$\u0007f\u0001\u0014\u0002R\u0005iC/Z:u\u0003\u000e\u001cW\r\u001d;BaB,g\u000eZ,ji\"|W\u000f\u001e)s_\u0012,8-\u001a:Ti\u0006$Xm\u00148SKBd\u0017nY1)\u0007\u001d\n\t&A\u0015uKN$\u0018iY2faR\f\u0005\u000f]3oI^KG\u000f[*fcV,gnY3HCB\u001cxJ\u001c*fa2L7-\u0019\u0015\u0004Q\u0005E\u0013!\u0007;fgR$U\r\\3uKNs\u0017\r]:i_R\u001c()\u001a4pe\u0016D3!KA)\u0003m!Xm\u001d;UeVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;Bi\"\u001a!&!\u0015\u0002MQ,7\u000f\u001e$jeN$XK\\:uC\ndWm\u00144gg\u0016$\u0018I\u001a;feR\u0013XO\\2bi&|g\u000eK\u0002,\u0003#\na\u0006^3ti2{\u0017\r\u001a$s_6\u001cf.\u00199tQ>$(+\u001a;bS:\u001chj\u001c8FqBL'/\u001a3Qe>$WoY3sg\"\u001aA&!\u0015\u0002CQ,7\u000f^*lSB\u001cf.\u00199tQ>$\u0018JZ(gMN,G/\u00168dQ\u0006tw-\u001a3)\u00075\n\t&\u0001\ruKN$\b+\u001b3FqBL'/\u0019;j_:$\u0016.\\3pkRD3ALA)\u0003]!Xm\u001d;GSJ\u001cH/\u00168ti\u0006\u0014G.Z(gMN,G\u000fK\u00020\u0003#\na\u0006^3tiB\u0013x\u000eZ;dKJ\u001cx+\u001b;i\u001f:<w.\u001b8h)J\fgn]1di&|gn\u001d#p]R,\u0005\u0010]5sK\"\u001a\u0001'!\u0015\u0002[Q,7\u000f^*fcV,gnY3O_R4\u0016\r\\5eCR,GMR8s\u000fJ|W\u000f]'fi\u0006$\u0017\r^1U_BL7\rK\u00022\u0003#\nA\u0004^3ti>cG-\u00129pG\"4uN]\"p]R\u0014x\u000e\u001c*fG>\u0014H\rK\u00023\u0003#\na\u0003^3ti\u000e{wN\u001d3j]\u0006$xN\u001d$f]\u000eLgn\u001a\u0015\u0004g\u0005E\u0013\u0001\t;fgR\u001cun\u001c:eS:\fGo\u001c:GK:\u001cW\rZ!gi\u0016\u0014(+\u001a7pC\u0012D3\u0001NA)\u0003u!Xm\u001d;M_\u0006$gI]8n\u000b6\u0004H/_*oCB\u001c\bn\u001c;GS2,\u0007fA\u001b\u0002R\u0005\tC/Z:u\u0019>\fGM\u0012:p[R\u0013XO\\2bi\u0016$7K\\1qg\"|GOR5mK\"\u001aa'!\u0015\u0002?Q,7\u000f\u001e'pC\u00124%o\\7D_J\u0014X\u000f\u001d;T]\u0006\u00048\u000f[8u\r&dW\rK\u00028\u0003#\n1\u0004^3ti\u0006\u0003\b/\u001a8e\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007f\u0001\u001d\u0002R\u0005\tD/Z:u%\u0016lwN^3TiJ\f\u0017p\u00158baNDw\u000e^:LK\u0016\u00048\t\\3b]NCW\u000f\u001e3po:\u001cf.\u00199tQ>$\bfA\u001d\u0002R\u0005YB/Z:u%\u0016lwN^3BY2\u001cFO]1z':\f\u0007o\u001d5piND3AOA)\u0003m!Xm\u001d;M_\u0006$gI]8n\u0007>\u0014(/\u001e9u':\f\u0007o\u001d5piR\u0019!-a?\t\u000f\u0005u8\b1\u0001\u0002\u0000\u0006yQ.Y6f\r&dWmQ8seV\u0004H\u000f\u0005\u0004N\u0005\u0003\u0011)AY\u0005\u0004\u0005\u0007q%!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u00119A!\u0005\u000e\u0005\t%!\u0002\u0002B\u0006\u0005\u001b\t\u0001b\u00195b]:,Gn\u001d\u0006\u0004\u0005\u001fa\u0016a\u00018j_&!!1\u0003B\u0005\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\u0002%\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u000b\u0011\u00053\u0011)C!\u000b\u0003,\tU\"Q\tB%\u0005\u001b\u0002R!\u0014B\u000e\u0005?I1A!\bO\u0005\u0019y\u0005\u000f^5p]B\u0019QK!\t\n\u0007\t\rbI\u0001\u0007D_6\u0004H.\u001a;fIRCh\u000e\u0003\u0004\u0003(q\u0002\rA[\u0001\b[\u0006\u0004\b/\u001b8h\u0011\u0019yH\b1\u0001\u0002\u0004!9!Q\u0006\u001fA\u0002\t=\u0012!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002N\u0005cI1Aa\rO\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\u00119\u0004\u0010a\u0001\u0005s\t1bY8oiJ|G\u000eV=qKB!!1\bB!\u001b\t\u0011iDC\u0002\u0003@U\faA]3d_J$\u0017\u0002\u0002B\"\u0005{\u0011\u0011cQ8oiJ|GNU3d_J$G+\u001f9f\u0011\u001d\u00119\u0005\u0010a\u0001\u0003\u0007\taa\u001c4gg\u0016$\b\"\u0003B&yA\u0005\t\u0019AA\b\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eC\u0005\u0003Pq\u0002\n\u00111\u0001\u0002\u0004\u0005IA/[7fgR\fW\u000e]\u0001\u001dCB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011)F\u000b\u0003\u0002\u0010\t]3F\u0001B-!\u0011\u0011YF!\u001a\u000e\u0005\tu#\u0002\u0002B0\u0005C\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\rd*\u0001\u0006b]:|G/\u0019;j_:LAAa\u001a\u0003^\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!Q\u000e\u0016\u0005\u0003\u0007\u00119&\u0001\u0004baB,g\u000e\u001a\u000b\u0012E\nM$Q\u000fB<\u0005s\u0012iHa \u0003\u0002\n-\u0005\"\u00025@\u0001\u0004Q\u0007BB@@\u0001\u0004\t\u0019\u0001C\u0004\u0003.}\u0002\rAa\f\t\u000f\tmt\b1\u0001\u0002\u0010\u0005\u00191/Z9\t\u000f\t\u001ds\b1\u0001\u0002\u0004!I!qJ \u0011\u0002\u0003\u0007\u00111\u0001\u0005\n\u0005\u0007{\u0004\u0013!a\u0001\u0005\u000b\u000bq\"[:Ue\u0006t7/Y2uS>t\u0017\r\u001c\t\u0004\u001b\n\u001d\u0015b\u0001BE\u001d\n9!i\\8mK\u0006t\u0007\"\u0003BG\u007fA\u0005\t\u0019\u0001BH\u0003\u0019y'/[4j]B\u0019QK!%\n\u0007\tMeI\u0001\u0007BaB,g\u000eZ(sS\u001eLg.\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$HeN\u000b\u0003\u00057SCA!\"\u0003X\u0005\u0001\u0012\r\u001d9f]\u0012$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005CSCAa$\u0003XQY!M!*\u0003(\n%&1\u0016B[\u0011\u0015A7\t1\u0001k\u0011\u0019y8\t1\u0001\u0002\u0004!9!qI\"A\u0002\u0005\r\u0001b\u0002BW\u0007\u0002\u0007!qV\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0005w\u0011\t,\u0003\u0003\u00034\nu\"a\u0003*fG>\u0014HMQ1uG\"DqA!$D\u0001\u0004\u0011y)\u0001\fdkJ\u0014XM\u001c;T]\u0006\u00048\u000f[8u\u001f\u001a47/\u001a;t+\t\u0011Y\f\u0005\u0004\u0003>\n-\u00171\u0001\b\u0005\u0005\u007f\u00139\rE\u0002\u0003B:k!Aa1\u000b\u0007\t\u0015'*\u0001\u0004=e>|GOP\u0005\u0004\u0005\u0013t\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003N\n='aA*fi*\u0019!\u0011\u001a(")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.append$default$7(), this.append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Replication$.MODULE$);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 2020L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.appendData$1(16L, 20L, firstAppend, producerEpoch, seq);
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), 16L), (Object)firstAppend.startedTransactions().head());
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Option firstCompletedTxn = this.appendEndTxn$1(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(30L, 31L, secondAppend, producerEpoch, seq);
        Assertions.assertEquals((int)2, (int)secondAppend.startedTransactions().size());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), TxnMetadata$.MODULE$.apply$default$3()), (Object)secondAppend.startedTransactions().head());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), TxnMetadata$.MODULE$.apply$default$3()), (Object)secondAppend.startedTransactions().last());
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.messageOffset())));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Option completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isDefined());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assertions.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            int x$20 = 2;
            long x$21 = 2L;
            boolean x$22 = true;
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = this.append$default$8();
            this.append(x$17, x$18, bumpedEpoch, x$20, x$21, x$23, x$22, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            int x$28 = 2;
            long x$29 = 2L;
            boolean x$30 = true;
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = this.append$default$8();
            this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        int x$36 = 0;
        long x$37 = 0L;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = this.append$default$8();
        this.append(x$33, x$34, bumpedEpoch, x$36, x$37, x$39, x$38, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            int x$12 = 1;
            long x$13 = 1L;
            boolean x$14 = false;
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = this.append$default$8();
            this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head())).nonEmpty(), (String)"Snapshot file is empty");
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        int x$20 = 2;
        long x$21 = 2L;
        boolean x$22 = true;
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = this.append$default$8();
        this.append(recoveredMapping, x$18, epoch, x$20, x$21, x$23, x$22, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        ControlRecordType x$4 = ControlRecordType.ABORT;
        long x$5 = 0L;
        int x$7 = this.appendEndTxnMarker$default$6();
        this.appendEndTxnMarker(x$1, x$2, epoch, x$4, x$5, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Option lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isDefined());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)((Tuple2)recoveredMapping.activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        long x$5 = 2L;
        long x$6 = 70001L;
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        boolean x$8 = this.append$default$7();
        this.append(recoveredMapping, x$2, epoch, sequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            long x$5 = 1L;
            long x$6 = 1L;
            AppendOrigin.Client$ x$7 = AppendOrigin.Client$.MODULE$;
            boolean x$8 = this.append$default$7();
            this.append(x$1, x$2, epoch, outOfOrderSequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        });
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$13 = 1L;
        long x$14 = 1L;
        AppendOrigin.Replication$ x$15 = AppendOrigin.Replication$.MODULE$;
        boolean x$16 = this.append$default$7();
        this.append(x$9, x$10, epoch, outOfOrderSequence, x$13, x$14, x$16, (AppendOrigin)x$15);
        Assertions.assertEquals((int)outOfOrderSequence, (int)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$52 = 99L;
        boolean x$62 = true;
        long x$72 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$52, x$72, x$62, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)((Tuple2)this.stateManager().activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$82 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$82);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$92 = this.stateManager();
        long x$132 = 105L;
        boolean x$142 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$92, anotherPid, epoch, sequence, x$132, x$15, x$142, x$16);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        long x$2 = this.producerId();
        int x$4 = -1;
        long x$5 = 99L;
        boolean x$6 = true;
        AppendOrigin.Coordinator$ x$7 = AppendOrigin.Coordinator$.MODULE$;
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, x$4, x$5, x$8, x$6, (AppendOrigin)x$7);
        long x$10 = this.producerId();
        int x$12 = -1;
        long x$13 = 100L;
        boolean x$14 = true;
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, x$12, x$13, x$16, x$14, (AppendOrigin)x$15);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, producerEpoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, baseOffset, batch, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)42)), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        Log$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L})));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
            mapping.completeTxn(completedTxn);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds());
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$3) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$3, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

