/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u000f\u001f\u0001\rBQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00016\u0011\u0019q\u0004\u0001)A\u0005m!9q\b\u0001b\u0001\n\u0003\u0001\u0005BB%\u0001A\u0003%\u0011\tC\u0004K\u0001\t\u0007I\u0011A&\t\rI\u0003\u0001\u0015!\u0003M\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001d\t\u0007A1A\u0005\u0002UBaA\u0019\u0001!\u0002\u00131\u0004\"B2\u0001\t\u0003!\u0007\"B;\u0001\t\u0003!\u0007\"B<\u0001\t\u0003!\u0007\"B=\u0001\t\u0003!\u0007\"B>\u0001\t\u0003!\u0007\"B?\u0001\t\u0003!\u0007\"B@\u0001\t\u0003!\u0007BBA\u0002\u0001\u0011\u0005A\r\u0003\u0004\u0002\b\u0001!\t\u0001\u001a\u0005\u0007\u0003\u0017\u0001A\u0011\u00013\t\r\u0005=\u0001\u0001\"\u0001e\u0011\u0019\t\u0019\u0002\u0001C\u0001I\"1\u0011q\u0003\u0001\u0005\u0002\u0011Dq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002D\u0001!I!!\u0012\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\tYQ*\u001a;sS\u000e\u001cH+Z:u\u0015\ty\u0002%A\u0004nKR\u0014\u0018nY:\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R!a\n\u0011\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003S\u0019\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[\u0001\nQ!\u001e;jYNL!a\f\u0017\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\r\t\u0003g\u0001i\u0011AH\u0001\t]Vlgj\u001c3fgV\ta\u0007\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0002J]R\f\u0011B\\;n\u001d>$Wm\u001d\u0011\u0002\u00119,X\u000eU1siN\f\u0011B\\;n!\u0006\u0014Ho\u001d\u0011\u00023I,\u0017/^5sK\u0012\\\u0015MZ6b'\u0016\u0014h/\u001a:Qe\u00164\u0017\u000e_\u000b\u0002\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005Y\u0006twMC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%AB*ue&tw-\u0001\u000esKF,\u0018N]3e\u0017\u000647.Y*feZ,'\u000f\u0015:fM&D\b%A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005a\u0005CA'Q\u001b\u0005q%BA(F\u0003\u0011)H/\u001b7\n\u0005Es%A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tQ\u000bE\u0002W3nk\u0011a\u0016\u0006\u00031b\n!bY8mY\u0016\u001cG/[8o\u0013\tQvKA\u0002TKF\u0004\"\u0001X0\u000e\u0003uS!A\u0018\u0011\u0002\rM,'O^3s\u0013\t\u0001WLA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00038NKN\u001c\u0018mZ3t\u0003)qW*Z:tC\u001e,7\u000fI\u0001&i\u0016\u001cH/T3ue&\u001c7OU3q_J$XM]!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000e$\u0012!\u001a\t\u0003o\u0019L!a\u001a\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001b%\u0004\"A[:\u000e\u0003-T!\u0001\\7\u0002\u0007\u0005\u0004\u0018N\u0003\u0002o_\u00069!.\u001e9ji\u0016\u0014(B\u00019r\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0018aA8sO&\u0011Ao\u001b\u0002\u0005)\u0016\u001cH/\u0001\u001buKN$(I]8lKJ$v\u000e]5d\u001b\u0016$(/[2t+:\u0014XmZ5ti\u0016\u0014X\rZ!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000eD#AD5\u0002'Q,7\u000f^\"mkN$XM]%e\u001b\u0016$(/[2)\u0005=I\u0017!\u0006;fgR\u0014%o\\6feN#\u0018\r^3NKR\u0014\u0018n\u0019\u0015\u0003!%\fA\u0004^3tif\u000bW.\\3s\u001b\u0016$(/[2t\u0007>,h\u000e^'fiJL7\r\u000b\u0002\u0012S\u0006\u0011B/Z:u\u0019&tW\u000f_%p\u001b\u0016$(/[2tQ\t\u0011\u0012.A\u0007uKN$(*\u0014-GS2$XM\u001d\u0015\u0003'%\f1\u0003^3tiV\u0003H-\u0019;f\u00156Cf)\u001b7uKJD#\u0001F5\u0002eQ,7\u000f^$f]\u0016\u0014\u0018\r\u001c\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN\f%/Z$sK\u0016$\u0017\u000e\\=SK\u001eL7\u000f^3sK\u0012D#!F5\u00021Q,7\u000f^,j]\u0012|wo]*us2,G+Y4OC6,7\u000f\u000b\u0002\u0017S\u0006\u0001C/Z:u\u0005J|7.\u001a:U_BL7-T3ue&\u001c7OQ=uKNLenT;uQ\t9\u0012.A\u000buKN$8i\u001c8ue>dG.\u001a:NKR\u0014\u0018nY:)\u0005aI\u0017\u0001\t;fgR\u001cVm]:j_:,\u0005\u0010]5sK2K7\u000f^3oKJlU\r\u001e:jGND#!G5\u0002\u0019Q|\u0007/[2NKR\u0014\u0018nY:\u0015\t\u0005}\u0011\u0011\b\t\u0006-\u0006\u0005\u0012QE\u0005\u0004\u0003G9&aA*fiB!\u0011qEA\u001b\u001d\u0011\tI#!\r\u0011\u0007\u0005-\u0002(\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0012\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\u0004O\u0001\u0007!J,G-\u001a4\n\u0007!\u000b9DC\u0002\u00024aBq!a\u000f\u001b\u0001\u0004\ti$A\u0003u_BL7\rE\u00038\u0003\u007f\t)#C\u0002\u0002Ba\u0012aa\u00149uS>t\u0017!\u0005;pa&\u001cW*\u001a;sS\u000e<%o\\;qgR!\u0011qDA$\u0011\u001d\tYd\u0007a\u0001\u0003K\t\u0001DZ5mi\u0016\u0014()\u001f+pa&\u001cW*\u001a;sS\u000e\u0014VmZ3y)\u0019\ty\"!\u0014\u0002P!1q\u0004\ba\u0001\u0003?Aq!a\u000f\u001d\u0001\u0004\ti\u0004")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final String requiredKafkaServerPrefix;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String requiredKafkaServerPrefix() {
        return this.requiredKafkaServerPrefix;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics don't exist");
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, s);
            return BoxedUnit.UNIT;
        });
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)this.servers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(this, x$2))), (int)1);
    }

    @Test
    public void testBrokerStateMetric() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerStateMetric$1(this, x$3))), (int)1);
    }

    @Test
    public void testYammerMetricsCountMetric() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testYammerMetricsCountMetric$1(this, x$4))), (int)1);
    }

    @Test
    public void testLinuxIoMetrics() {
        int expectedCount = new LinuxIoMetricsCollector("/proc", Time.SYSTEM, this.logger().underlying()).usable() ? 1 : 0;
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableLike)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linux-disk-read-bytes", "linux-disk-write-bytes"}))).foreach((Function1 & Serializable & scala.Serializable)name -> {
            MetricsTest.$anonfun$testLinuxIoMetrics$1(this, metrics, expectedCount, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testJMXFilter() {
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @Test
    public void testUpdateJMXFilter() {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            MetricsTest.$anonfun$testUpdateJMXFilter$1(server);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString())));
    }

    @Test
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        Assertions.assertTrue((boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty(), (String)"General topic metrics don't exist");
        Assertions.assertEquals((int)((KafkaServer)this.servers().head()).brokerTopicStats().allTopicsStats().metricMap().size(), (int)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).isEmpty(), (String)"Topic metrics aren't lazily registered");
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics aren't registered");
    }

    @Test
    public void testWindowsStyleTagNames() {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((TraversableOnce)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = KafkaMetricsGroup$.MODULE$.metricName("test-metric", tags);
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @Test
    public void testBrokerTopicMetricsBytesInOut() {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
        String replicationBytesOut = BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
        String bytesIn = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesInPerSec()).append(",topic=").append(topic).toString();
        String bytesOut = new StringBuilder(7).append(BrokerTopicStats$.MODULE$.BytesOutPerSec()).append(",topic=").append(topic).toString();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        Assertions.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        TestUtils$.MODULE$.consumeTopicRecords((Seq<KafkaServer>)this.servers(), topic, this.nMessages(), TestUtils$.MODULE$.consumeTopicRecords$default$4(), TestUtils$.MODULE$.consumeTopicRecords$default$5(), TestUtils$.MODULE$.consumeTopicRecords$default$6(), TestUtils$.MODULE$.consumeTopicRecords$default$7());
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @Test
    public void testControllerMetrics() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$1(x$8))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$2(x$9))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$3(x$10))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$4(x$11))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$5(x$12))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$6(x$13))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$7(x$14))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$8(x$15))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testControllerMetrics$9(x$16))), (int)1);
    }

    @Test
    public void testSessionExpireListenerMetrics() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$1(x$17))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$2(x$18))), (int)1);
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testSessionExpireListenerMetrics$3(x$19))), (int)1);
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.getMBeanName(), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(22).append(".*BrokerTopicMetrics.*").append(topic.map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(3).append("(").append((String)t).append(")$").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString())).r().pattern();
        return (Set)metrics.filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$21)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaServer s) {
        Assertions.assertNotNull((Object)s.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricsTest $this, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = new StringBuilder(10).append($this.requiredKafkaServerPrefix()).append("=ClusterId").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateMetric$1(MetricsTest $this, MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = new StringBuilder(12).append($this.requiredKafkaServerPrefix()).append("=BrokerState").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testYammerMetricsCountMetric$1(MetricsTest $this, MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = new StringBuilder(21).append($this.requiredKafkaServerPrefix()).append("=yammer-metrics-count").toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLinuxIoMetrics$2(MetricsTest $this, String name$1, MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = new StringBuilder(1).append($this.requiredKafkaServerPrefix()).append("=").append(name$1).toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testLinuxIoMetrics$1(MetricsTest $this, java.util.Map metrics$1, int expectedCount$1, String name) {
        Assertions.assertEquals((int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(metrics$1.keySet()).asScala()).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testLinuxIoMetrics$2($this, name, x$5))), (int)expectedCount$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdateJMXFilter$1(KafkaServer server) {
        server.kafkaYammerMetrics().reconfigure((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics.jmx.exclude"), (Object)"kafka.controller:type=KafkaController,name=ActiveControllerCount")}))).asJava());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = server.config().brokerId();
        Option logSize = log.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 > 0L), (String)new StringBuilder(64).append("Expected broker ").append(brokerId).append(" to have a Log for ").append(topicPartition$1).append(" with positive size, actual: ").append(logSize).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$1(MetricName x$8) {
        String string = x$8.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ActiveControllerCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$2(MetricName x$9) {
        String string = x$9.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=OfflinePartitionsCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$3(MetricName x$10) {
        String string = x$10.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$4(MetricName x$11) {
        String string = x$11.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalTopicCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$5(MetricName x$12) {
        String string = x$12.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=GlobalPartitionCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$6(MetricName x$13) {
        String string = x$13.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$7(MetricName x$14) {
        String string = x$14.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$8(MetricName x$15) {
        String string = x$15.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=TopicsIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMetrics$9(MetricName x$16) {
        String string = x$16.getMBeanName();
        String string2 = "kafka.controller:type=KafkaController,name=ReplicasIneligibleToDeleteCount";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$1(MetricName x$17) {
        String string = x$17.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=SessionState";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$2(MetricName x$18) {
        String string = x$18.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpireListenerMetrics$3(MetricName x$19) {
        String string = x$19.getMBeanName();
        String string2 = "kafka.server:type=SessionExpireListener,name=ZooKeeperDisconnectsPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$21) {
        return pattern$1.matcher(x$21).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.requiredKafkaServerPrefix = "kafka.server:type=KafkaServer,name";
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(this.numParts()));
        this.overridingProps().put("metrics.jmx.exclude", new StringBuilder(10).append(this.requiredKafkaServerPrefix()).append("=ClusterId").toString());
        this.nMessages = 2;
    }
}

