/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaRaftManager;
import org.apache.kafka.raft.KafkaRaftClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%2A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)q\u0005\u0001C\u0001-\ty!+\u00194u\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0007\u000f\u0005!!/\u00194u\u0015\u0005A\u0011!B6bM.\f7\u0001A\n\u0003\u0001-\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0006\u0003Q!Xm\u001d;TQV$Hm\\<o\u0013>$\u0006N]3bIR\tq\u0003\u0005\u0002\r1%\u0011\u0011$\u0004\u0002\u0005+:LG\u000f\u000b\u0002\u00037A\u0011A$J\u0007\u0002;)\u0011adH\u0001\u0004CBL'B\u0001\u0011\"\u0003\u001dQW\u000f]5uKJT!AI\u0012\u0002\u000b),h.\u001b;\u000b\u0003\u0011\n1a\u001c:h\u0013\t1SD\u0001\u0003UKN$\u0018a\b;fgR,fnY1vO\"$X\t_2faRLwN\\%o\u0013>$\u0006N]3bI\"\u00121a\u0007")
public class RaftManagerTest {
    @Test
    public void testShutdownIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft");
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        CompletableFuture<Object> shutdownFuture = new CompletableFuture<Object>();
        Mockito.when((Object)raftClient.shutdown(5000)).thenReturn(shutdownFuture);
        ioThread.initiateShutdown();
        Assertions.assertTrue((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownInitiated());
        ((KafkaRaftClient)Mockito.verify((Object)raftClient)).shutdown(5000);
        shutdownFuture.complete(null);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ioThread.run();
        Assertions.assertFalse((boolean)ioThread.isRunning());
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
    }

    @Test
    public void testUncaughtExceptionInIoThread() {
        KafkaRaftClient raftClient = (KafkaRaftClient)Mockito.mock(KafkaRaftClient.class);
        KafkaRaftManager.RaftIoThread ioThread = new KafkaRaftManager.RaftIoThread(raftClient, "test-raft");
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)raftClient.isRunning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertTrue((boolean)ioThread.isRunning());
        raftClient.poll();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException()});
        ioThread.run();
        Assertions.assertTrue((boolean)ioThread.isShutdownComplete());
        Assertions.assertTrue((boolean)ioThread.isThreadFailed());
        Assertions.assertFalse((boolean)ioThread.isRunning());
    }
}

