/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import kafka.common.KafkaException;
import kafka.security.auth.Group$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.Topic$;
import org.apache.kafka.common.resource.PatternType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0003\u0006\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)a\u0006\u0001C\u0001;!)\u0001\u0007\u0001C\u0001;!)!\u0007\u0001C\u0001;!)A\u0007\u0001C\u0001;!)a\u0007\u0001C\u0001;!)\u0001\b\u0001C\u0001;\ta!+Z:pkJ\u001cW\rV3ti*\u00111\u0002D\u0001\u0005CV$\bN\u0003\u0002\u000e\u001d\u0005A1/Z2ve&$\u0018PC\u0001\u0010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u001c\u00015\t!\"A\u0019tQ>,H\u000e\u001a+ie><xJ\u001c+x_B\u000b'\u000f^*ue&twmV5uQVs7N\\8x]J+7o\\;sG\u0016$\u0016\u0010]3\u0015\u0003y\u0001\"aE\u0010\n\u0005\u0001\"\"\u0001B+oSRD#A\u0001\u0012\u0011\u0005\rbS\"\u0001\u0013\u000b\u0005\u00152\u0013aA1qS*\u0011q\u0005K\u0001\bUV\u0004\u0018\u000e^3s\u0015\tI#&A\u0003kk:LGOC\u0001,\u0003\ry'oZ\u0005\u0003[\u0011\u0012A\u0001V3ti\u0006)3\u000f[8vY\u0012$\u0006N]8x\u001f:\u0014\u0015\r\u001a*fg>,(oY3UsB,7+\u001a9be\u0006$xN\u001d\u0015\u0003\u0007\t\n1d\u001d5pk2$\u0007+\u0019:tK>cG\rV<p!\u0006\u0014Ho\u0015;sS:<\u0007F\u0001\u0003#\u0003-\u001a\bn\\;mIB\u000b'o]3PY\u0012$vo\u001c)beR<\u0016\u000e\u001e5F[\n,G\rZ3e'\u0016\u0004\u0018M]1u_J\u001c\bFA\u0003#\u0003i\u0019\bn\\;mIB\u000b'o]3UQJ,W\rU1siN#(/\u001b8hQ\t1!%\u0001\u0016tQ>,H\u000e\u001a)beN,G\u000b\u001b:fKB\u000b'\u000f^,ji\",UNY3eI\u0016$7+\u001a9be\u0006$xN]:)\u0005\u001d\u0011\u0013\u0001G:i_VdGMU8v]\u0012$&/\u001b9WS\u0006\u001cFO]5oO\"\u0012\u0001B\t\u0015\u0005\u0001mr\u0004\t\u0005\u0002\u0014y%\u0011Q\b\u0006\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017%A \u0002iU\u001bX\rI8sO:\n\u0007/Y2iK:Z\u0017MZ6b]\r|W.\\8o]I,7o\\;sG\u0016t#+Z:pkJ\u001cW\rU1ui\u0016\u0014h.I\u0001B\u0003%\u0019\u0016N\\2fAIrS\u0007")
public class ResourceTest {
    @Test
    public void shouldThrowOnTwoPartStringWithUnknownResourceType() {
        Assertions.assertThrows(KafkaException.class, () -> Resource$.MODULE$.fromString("Unknown:fred"));
    }

    @Test
    public void shouldThrowOnBadResourceTypeSeparator() {
        Assertions.assertThrows(KafkaException.class, () -> Resource$.MODULE$.fromString("Topic-fred"));
    }

    @Test
    public void shouldParseOldTwoPartString() {
        Assertions.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, "fred", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Group:fred"));
        Assertions.assertEquals((Object)new Resource((ResourceType)Topic$.MODULE$, "t", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Topic:t"));
    }

    @Test
    public void shouldParseOldTwoPartWithEmbeddedSeparators() {
        Assertions.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, ":This:is:a:weird:group:name:", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Group::This:is:a:weird:group:name:"));
    }

    @Test
    public void shouldParseThreePartString() {
        Assertions.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, "fred", PatternType.PREFIXED), (Object)Resource$.MODULE$.fromString("Group:PREFIXED:fred"));
        Assertions.assertEquals((Object)new Resource((ResourceType)Topic$.MODULE$, "t", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Topic:LITERAL:t"));
    }

    @Test
    public void shouldParseThreePartWithEmbeddedSeparators() {
        Assertions.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, ":This:is:a:weird:group:name:", PatternType.PREFIXED), (Object)Resource$.MODULE$.fromString("Group:PREFIXED::This:is:a:weird:group:name:"));
        Assertions.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, ":This:is:a:weird:group:name:", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Group:LITERAL::This:is:a:weird:group:name:"));
    }

    @Test
    public void shouldRoundTripViaString() {
        Resource expected = new Resource((ResourceType)Group$.MODULE$, "fred", PatternType.PREFIXED);
        Resource actual = Resource$.MODULE$.fromString(expected.toString());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

