/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.TestableDigestLoginModule$;
import kafka.security.authorizer.TestableJaasSection;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.ZooKeeperClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\u0010 \u0001\u0019BQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004=\u0001\u0001\u0006I!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u00039\u0011\u0019q\u0004\u0001)A\u0005s!9q\b\u0001b\u0001\n\u0013\u0001\u0005BB'\u0001A\u0003%\u0011\tC\u0004O\u0001\t\u0007I\u0011B(\t\ra\u0003\u0001\u0015!\u0003Q\u0011\u001dI\u0006A1A\u0005\niCaA\u0019\u0001!\u0002\u0013Y\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007W\u0002\u0001\u000b\u0011B3\t\u000f1\u0004!\u0019!C\u0005[\"1a\u000f\u0001Q\u0001\n9D\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u0001\u0003\u0006\u0002\u0014\u0001\u0001\r\u0011!Q!\neDq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002.\u0001!\t%a\u0006\t\u000f\u0005]\u0002\u0001\"\u0001\u0002\u0018!9\u0011\u0011\t\u0001\u0005\u0002\u0005]\u0001bBA#\u0001\u0011%\u0011q\u0003\u0005\b\u0003\u000f\u0002A\u0011BA\f\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017Bq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002\u0006\u0002!I!a\"\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"I\u00111\u0017\u0001\u0012\u0002\u0013%\u0011Q\u0017\u0002\u001c\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:XSRD'l[*bg2$Vm\u001d;\u000b\u0005\u0001\n\u0013AC1vi\"|'/\u001b>fe*\u0011!eI\u0001\tg\u0016\u001cWO]5us*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011F\u0003\u0002+G\u0005\u0011!p[\u0005\u0003Y%\u0012ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019$\u0003\r\t\u0007/[\u0005\u0003e=\u0012\u0011bU1tYN+G/\u001e9\u0002\rqJg.\u001b;?)\u0005)\u0004C\u0001\u001c\u0001\u001b\u0005y\u0012!D1dY\u0006+H\u000f[8sSj,'/F\u0001:!\t1$(\u0003\u0002<?\ti\u0011i\u00197BkRDwN]5{KJ\fa\"Y2m\u0003V$\bn\u001c:ju\u0016\u0014\b%\u0001\bbG2\fU\u000f\u001e5pe&TXM\u001d\u001a\u0002\u001f\u0005\u001cG.Q;uQ>\u0014\u0018N_3se\u0001\n\u0001B]3t_V\u00148-Z\u000b\u0002\u0003B\u0011!iS\u0007\u0002\u0007*\u0011q\b\u0012\u0006\u0003\u000b\u001a\u000baaY8n[>t'B\u0001\u0013H\u0015\tA\u0015*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051\u001b%a\u0004*fg>,(oY3QCR$XM\u001d8\u0002\u0013I,7o\\;sG\u0016\u0004\u0013\u0001C;tKJt\u0017-\\3\u0016\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\t1\fgn\u001a\u0006\u0002+\u0006!!.\u0019<b\u0013\t9&K\u0001\u0004TiJLgnZ\u0001\nkN,'O\\1nK\u0002\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0016\u0003m\u0003\"\u0001\u00181\u000e\u0003uS!AX0\u0002\t\u0005,H\u000f\u001b\u0006\u0003E\u0011K!!Y/\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006Q\u0001O]5oG&\u0004\u0018\r\u001c\u0011\u0002\u001dI,\u0017/^3ti\u000e{g\u000e^3yiV\tQ\r\u0005\u0002gS6\tqM\u0003\u0002i\t\u0006A!/Z9vKN$8/\u0003\u0002kO\nq!+Z9vKN$8i\u001c8uKb$\u0018a\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0011\u0002\u0011\u0015DXmY;u_J,\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f!bY8oGV\u0014(/\u001a8u\u0015\t\u0019H+\u0001\u0003vi&d\u0017BA;q\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\nKb,7-\u001e;pe\u0002\naaY8oM&<W#A=\u0011\u0005ilX\"A>\u000b\u0005q\u001c\u0013AB:feZ,'/\u0003\u0002\u007fw\nY1*\u00194lC\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003\u0007\ty\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\t\tI!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u000e\u0005\u001d!\u0001B+oSRD\u0001\"!\u0005\u0012\u0003\u0003\u0005\r!_\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003\u0007A3aEA\u000e!\u0011\ti\"!\u000b\u000e\u0005\u0005}!b\u0001\u0019\u0002\")!\u00111EA\u0013\u0003\u001dQW\u000f]5uKJT1!a\nJ\u0003\u0015QWO\\5u\u0013\u0011\tY#a\b\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r!\u0012\u0011\u0007\t\u0005\u0003;\t\u0019$\u0003\u0003\u00026\u0005}!!C!gi\u0016\u0014X)Y2i\u0003\t\"Xm\u001d;BG2,\u0006\u000fZ1uK^KG\u000f[*fgNLwN\\#ya&\u0014\u0018\r^5p]\"\u001aQ#a\u000f\u0011\t\u0005u\u0011QH\u0005\u0005\u0003\u007f\tyB\u0001\u0003UKN$\u0018\u0001\b;fgR\f5\r\\+qI\u0006$XmV5uQ\u0006+H\u000f\u001b$bS2,(/\u001a\u0015\u0004-\u0005m\u0012\u0001J5oU\u0016\u001cG\u000f\u0016:b]NLWM\u001c;BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0002\u001fY,'/\u001b4z\u0003\u000edW\u000b\u001d3bi\u0016\f\u0001B_6DY&,g\u000e\u001e\u000b\u0005\u0003\u001b\n\u0019\u0006E\u0002)\u0003\u001fJ1!!\u0015*\u00055Y\u0015MZ6b5.\u001cE.[3oi\")\u0001%\u0007a\u0001s\u00059\u0011\r\u001a3BG2\u001cH\u0003CA\u0002\u00033\nY&!!\t\u000b\u0001R\u0002\u0019A\u001d\t\u000f\u0005u#\u00041\u0001\u0002`\u0005!\u0011mY3t!\u0019\t\t'a\u001c\u0002v9!\u00111MA6!\u0011\t)'a\u0002\u000e\u0005\u0005\u001d$bAA5K\u00051AH]8pizJA!!\u001c\u0002\b\u00051\u0001K]3eK\u001aLA!!\u001d\u0002t\t\u00191+\u001a;\u000b\t\u00055\u0014q\u0001\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111\u0010#\u0002\u0007\u0005\u001cG.\u0003\u0003\u0002\u0000\u0005e$AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uefDa!a!\u001b\u0001\u0004\t\u0015a\u0004:fg>,(oY3QCR$XM\u001d8\u0002\u000f\u001d,G/Q2mgR1\u0011qLAE\u0003\u0017CQ\u0001I\u000eA\u0002eBa!a!\u001c\u0001\u0004\t\u0015!\u00058foJ+\u0017/^3ti\u000e{g\u000e^3yiR9Q-!%\u0002\u0014\u0006\r\u0006\"B-\u001d\u0001\u0004Y\u0006bBAK9\u0001\u0007\u0011qS\u0001\u000eG2LWM\u001c;BI\u0012\u0014Xm]:\u0011\t\u0005e\u0015qT\u0007\u0003\u00037S1!!(U\u0003\rqW\r^\u0005\u0005\u0003C\u000bYJA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\b\"CAS9A\u0005\t\u0019AAT\u0003\u0019\t\u0007/[&fsB!\u0011\u0011VAX\u001b\t\tYKC\u0002\u0002.\u0012\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003c\u000bYKA\u0004Ba&\\U-_:\u000279,wOU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t9L\u000b\u0003\u0002(\u0006e6FAA^!\u0011\ti,a2\u000e\u0005\u0005}&\u0002BAa\u0003\u0007\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\u0005\u0015\u0017qA\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAe\u0003\u007f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class AclAuthorizerWithZkSaslTest
extends ZooKeeperTestHarness
implements SaslSetup {
    private final AclAuthorizer aclAuthorizer;
    private final AclAuthorizer aclAuthorizer2;
    private final ResourcePattern resource;
    private final String username;
    private final KafkaPrincipal principal;
    private final RequestContext requestContext;
    private final ScheduledExecutorService executor;
    private KafkaConfig config;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    private ResourcePattern resource() {
        return this.resource;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestContext requestContext() {
        return this.requestContext;
    }

    private ScheduledExecutorService executor() {
        return this.executor;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        System.setProperty("zookeeper.allowSaslFailedClients", "true");
        TestableDigestLoginModule$.MODULE$.reset();
        Seq<JaasTestUtils.JaasSection> jaasSections = JaasTestUtils$.MODULE$.zkSections();
        Seq serverJaas = (Seq)jaasSections.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerWithZkSaslTest.$anonfun$setUp$1(x$1)));
        Seq clientJaas = (Seq)((TraversableLike)jaasSections.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerWithZkSaslTest.$anonfun$setUp$2(x$2)))).map((Function1 & Serializable & scala.Serializable)section -> new TestableJaasSection(section.contextName(), section.modules()), Seq$.MODULE$.canBuildFrom());
        this.startSasl((Seq<JaasTestUtils.JaasSection>)((Seq)serverJaas.$plus$plus((GenTraversableOnce)clientJaas, Seq$.MODULE$.canBuildFrom())));
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        super.setUp();
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
    }

    @Override
    @AfterEach
    public void tearDown() {
        System.clearProperty("zookeeper.allowSaslFailedClients");
        TestableDigestLoginModule$.MODULE$.reset();
        this.executor().shutdownNow();
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        super.tearDown();
    }

    @Test
    public void testAclUpdateWithSessionExpiration() {
        this.zkClient(this.aclAuthorizer()).currentZooKeeper().getTestable().injectSessionExpiration();
        this.zkClient(this.aclAuthorizer2()).currentZooKeeper().getTestable().injectSessionExpiration();
        this.verifyAclUpdate();
    }

    @Test
    public void testAclUpdateWithAuthFailure() {
        this.injectTransientAuthenticationFailure();
        this.verifyAclUpdate();
    }

    private void injectTransientAuthenticationFailure() {
        TestableDigestLoginModule$.MODULE$.injectInvalidCredentials();
        this.zkClient(this.aclAuthorizer()).currentZooKeeper().getTestable().injectSessionExpiration();
        this.zkClient(this.aclAuthorizer2()).currentZooKeeper().getTestable().injectSessionExpiration();
        this.executor().schedule(() -> TestableDigestLoginModule$.MODULE$.reset(), (long)(ZooKeeperClient$.MODULE$.RetryBackoffMs() * 2), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyAclUpdate() {
        void var4_15;
        Tuple2 tuple2;
        AccessControlEntry allowReadAcl = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry allowWriteAcl = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowReadAcl, allowWriteAcl}));
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AclAuthorizerWithZkSaslTest.$anonfun$verifyAclUpdate$1(this, acls);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Set computeUntilTrue_result;
            Set set;
            if (AclAuthorizerWithZkSaslTest.$anonfun$verifyAclUpdate$3(acls, set = (computeUntilTrue_result = this.getAcls(this.aclAuthorizer2(), this.resource())))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set acls2 = (Set)tuple2._1();
        Assertions.assertEquals((Object)acls, (Object)var4_15);
    }

    private KafkaZkClient zkClient(AclAuthorizer authorizer) {
        return (KafkaZkClient)TestUtils.fieldValue((Object)authorizer, AclAuthorizer.class, (String)"zkClient");
    }

    private void addAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace), Set$.MODULE$.canBuildFrom());
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> (AclCreateResult)x$4.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            AclAuthorizerWithZkSaslTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.entry(), Set$.MODULE$.canBuildFrom());
    }

    private RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY, false);
    }

    private ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    public static final /* synthetic */ boolean $anonfun$setUp$1(JaasTestUtils.JaasSection x$1) {
        String string = x$1.contextName();
        String string2 = "Server";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$setUp$2(JaasTestUtils.JaasSection x$2) {
        String string = x$2.contextName();
        String string2 = "Client";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$verifyAclUpdate$1(AclAuthorizerWithZkSaslTest $this, Set acls$1) {
        try {
            $this.addAcls($this.aclAuthorizer(), (Set<AccessControlEntry>)acls$1, $this.resource());
        }
        catch (Exception exception) {}
        Assertions.assertEquals((Object)acls$1, $this.getAcls($this.aclAuthorizer(), $this.resource()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyAclUpdate$3(Set acls$1, Set x$3) {
        Set set = x$3;
        return !(set != null ? !set.equals(acls$1) : acls$1 != null);
    }

    public static final /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public AclAuthorizerWithZkSaslTest() {
        SaslSetup.$init$(this);
        this.aclAuthorizer = new AclAuthorizer();
        this.aclAuthorizer2 = new AclAuthorizer();
        this.resource = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        this.username = "alice";
        this.principal = new KafkaPrincipal("User", this.username());
        this.requestContext = this.newRequestContext(this.principal(), InetAddress.getByName("192.168.0.1"), this.newRequestContext$default$3());
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public static final /* synthetic */ Object $anonfun$verifyAclUpdate$3$adapted(Set acls$1, Set x$3) {
        return BoxesRunTime.boxToBoolean((boolean)AclAuthorizerWithZkSaslTest.$anonfun$verifyAclUpdate$3(acls$1, x$3));
    }
}

