/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import kafka.server.AuthHelper;
import kafka.server.AuthHelperTest$;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q3AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0013a\u0002BB\u0013\u0001A\u0003%Q\u0004C\u0003'\u0001\u0011\u0005q\u0005C\u00039\u0001\u0011\u0005qeB\u0003;\u0017!\u00051HB\u0003\u000b\u0017!\u0005A\bC\u0003\u0018\u000f\u0011\u0005Q\bC\u0003?\u000f\u0011\u0005qH\u0001\bBkRD\u0007*\u001a7qKJ$Vm\u001d;\u000b\u00051i\u0011AB:feZ,'OC\u0001\u000f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t1\"\u0001\u0005dY&,g\u000e^%e+\u0005i\u0002C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0011a\u0017M\\4\u000b\u0003\t\nAA[1wC&\u0011Ae\b\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013!\u0004;fgR\fU\u000f\u001e5pe&TX\rF\u0001)!\t\u0011\u0012&\u0003\u0002+'\t!QK\\5uQ\t!A\u0006\u0005\u0002.m5\taF\u0003\u00020a\u0005\u0019\u0011\r]5\u000b\u0005E\u0012\u0014a\u00026va&$XM\u001d\u0006\u0003gQ\nQA[;oSRT\u0011!N\u0001\u0004_J<\u0017BA\u001c/\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f\u001e$jYR,'OQ=BkRDwN]5{K\u0012D#!\u0002\u0017\u0002\u001d\u0005+H\u000f\u001b%fYB,'\u000fV3tiB\u0011!dB\n\u0003\u000fE!\u0012aO\u0001\u0012[\u0006$8\r[*b[\u0016,E.Z7f]R\u001cXC\u0001!J)\t\t%\u000bE\u0002C\u000b\u001ek\u0011a\u0011\u0006\u0003\t\u0006\nA!\u001e;jY&\u0011ai\u0011\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002I\u00132\u0001A!\u0002&\n\u0005\u0004Y%!\u0001+\u0012\u00051{\u0005C\u0001\nN\u0013\tq5CA\u0004O_RD\u0017N\\4\u0011\u0005I\u0001\u0016BA)\u0014\u0005\r\te.\u001f\u0005\u0006'&\u0001\r!Q\u0001\u0005Y&\u001cH\u000f")
public class AuthHelperTest {
    private final String clientId;

    public static <T> java.util.List<T> matchSameElements(java.util.List<T> list) {
        return AuthHelperTest$.MODULE$.matchSameElements(list);
    }

    private String clientId() {
        return this.clientId;
    }

    @Test
    public void testAuthorize() {
        Authorizer authorizer = (Authorizer)EasyMock.niceMock(Authorizer.class);
        AclOperation operation = AclOperation.WRITE;
        ResourceType resourceType = ResourceType.TOPIC;
        String resourceName = "topic-1";
        RequestHeader requestHeader = new RequestHeader(ApiKeys.PRODUCE, ApiKeys.PRODUCE.latestVersion(), this.clientId(), 0);
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        .colon.colon expectedActions = new .colon.colon((Object)new Action(operation, new ResourcePattern(resourceType, resourceName, PatternType.LITERAL), 1, true, true), (List)Nil$.MODULE$);
        EasyMock.expect((Object)authorizer.authorize((AuthorizableRequestContext)requestContext, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)expectedActions).asJava())).andReturn(CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)AuthorizationResult.ALLOWED, (List)Nil$.MODULE$)).asJava()).once();
        EasyMock.replay((Object[])new Object[]{authorizer});
        AuthHelper qual$1 = new AuthHelper((Option)new Some((Object)authorizer));
        boolean x$5 = qual$1.authorize$default$5();
        boolean x$6 = qual$1.authorize$default$6();
        int x$7 = qual$1.authorize$default$7();
        boolean result = qual$1.authorize(requestContext, operation, resourceType, resourceName, x$5, x$6, x$7);
        EasyMock.verify((Object[])new Object[]{authorizer});
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)result));
    }

    @Test
    public void testFilterByAuthorized() {
        Authorizer authorizer = (Authorizer)EasyMock.niceMock(Authorizer.class);
        AclOperation operation = AclOperation.WRITE;
        ResourceType resourceType = ResourceType.TOPIC;
        String resourceName1 = "topic-1";
        String resourceName2 = "topic-2";
        String resourceName3 = "topic-3";
        RequestHeader requestHeader = new RequestHeader(ApiKeys.PRODUCE, ApiKeys.PRODUCE.latestVersion(), this.clientId(), 0);
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        .colon.colon expectedActions = new .colon.colon((Object)new Action(operation, new ResourcePattern(resourceType, resourceName1, PatternType.LITERAL), 2, true, true), (List)new .colon.colon((Object)new Action(operation, new ResourcePattern(resourceType, resourceName2, PatternType.LITERAL), 1, true, true), (List)new .colon.colon((Object)new Action(operation, new ResourcePattern(resourceType, resourceName3, PatternType.LITERAL), 1, true, true), (List)Nil$.MODULE$)));
        EasyMock.expect((Object)authorizer.authorize((AuthorizableRequestContext)EasyMock.eq((Object)requestContext), AuthHelperTest$.MODULE$.matchSameElements((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)expectedActions).asJava()))).andAnswer(() -> {
            Buffer actions = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)EasyMock.getCurrentArguments()[1]).asScala();
            return (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)actions.map((Function1 & Serializable & scala.Serializable)action -> {
                if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resourceName1, resourceName3}))).contains((Object)action.resourcePattern().name())) {
                    return AuthorizationResult.ALLOWED;
                }
                return AuthorizationResult.DENIED;
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
        }).once();
        EasyMock.replay((Object[])new Object[]{authorizer});
        AuthHelper qual$1 = new AuthHelper((Option)new Some((Object)authorizer));
        .colon.colon x$4 = new .colon.colon((Object)resourceName1, (List)new .colon.colon((Object)resourceName2, (List)new .colon.colon((Object)resourceName1, (List)new .colon.colon((Object)resourceName3, (List)Nil$.MODULE$))));
        boolean x$5 = qual$1.filterByAuthorized$default$5();
        boolean x$6 = qual$1.filterByAuthorized$default$6();
        Function1 & Serializable & scala.Serializable x$7 = (Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x);
        Set result = qual$1.filterByAuthorized(requestContext, operation, resourceType, (Iterable)x$4, x$5, x$6, (Function1)x$7);
        EasyMock.verify((Object[])new Object[]{authorizer});
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resourceName1, resourceName3})), (Object)result);
    }

    public AuthHelperTest() {
        this.clientId = "";
    }
}

