/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiVersionManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerApis;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.SimpleApiVersionManager;
import kafka.test.MockController;
import kafka.utils.MockTime;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t%b\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001b\u0001\n\u0013y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\r]\u0003\u0001\u0015!\u0003N\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00021\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1A\u000e\u0001Q\u0001\n%Dq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001c\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0011\u0019A\b\u0001)A\u0005k\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bB\u0002@\u0001A\u0003%1\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\t)\u0003\u0001Q\u0001\n\u0005\r\u0001\"CA\u0014\u0001\t\u0007I\u0011BA\u0015\u0011!\t9\u0005\u0001Q\u0001\n\u0005-\u0002bBA%\u0001\u0011%\u00111\n\u0005\n\u0003\u000f\u0003\u0011\u0013!C\u0005\u0003\u0013Cq!a(\u0001\t\u0013\t\t\u000bC\u0005\u0002Z\u0002\t\n\u0011\"\u0003\u0002\\\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\bb\u0002B\u0002\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0005\u000f\u0001A\u0011AAs\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003KDqAa\u0004\u0001\t\u0003\t)\u000fC\u0004\u0003\u0014\u0001!\t!!:\t\u000f\t]\u0001\u0001\"\u0001\u0002f\"9!1\u0004\u0001\u0005\u0002\u0005\u0015\bb\u0002B\u0010\u0001\u0011\u0005\u0011Q\u001d\u0002\u0013\u0007>tGO]8mY\u0016\u0014\u0018\t]5t)\u0016\u001cHO\u0003\u0002*U\u000511/\u001a:wKJT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u0003!\naA\\8eK&#W#\u0001\u001e\u0011\u0005=Z\u0014B\u0001\u001f1\u0005\rIe\u000e^\u0001\b]>$W-\u00133!\u0003)\u0011'o\\6feJ\u000b7m[\u000b\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0005Y\u0006twMC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%AB*ue&tw-A\u0006ce>\\WM\u001d*bG.\u0004\u0013\u0001C2mS\u0016tG/\u0013#\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0003\u0013!\u0006:fcV,7\u000f^\"iC:tW\r\\'fiJL7m]\u000b\u0002\u001bB\u0011a\n\u0016\b\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#*\nqA\\3uo>\u00148.\u0003\u0002T!\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017BA+W\u0005\u001diU\r\u001e:jGNT!a\u0015)\u0002-I,\u0017/^3ti\u000eC\u0017M\u001c8fY6+GO]5dg\u0002\naB]3rk\u0016\u001cHo\u00115b]:,G.F\u0001[!\ty5,\u0003\u0002]!\nq!+Z9vKN$8\t[1o]\u0016d\u0017a\u0004:fcV,7\u000f^\"iC:tW\r\u001c\u0011\u0002\tQLW.Z\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111MK\u0001\u0006kRLGn]\u0005\u0003K\n\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0013G2LWM\u001c;Rk>$\u0018-T1oC\u001e,'/F\u0001j!\t9$.\u0003\u0002lQ\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003M\u0019G.[3oiF+x\u000e^1NC:\fw-\u001a:!\u0003e\u0019G.[3oiJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:\u0016\u0003=\u0004\"a\u000e9\n\u0005ED#!G\"mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ\f!d\u00197jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe\u0002\nAd\u00197jK:$8i\u001c8ue>dG.\u001a:Rk>$\u0018-T1oC\u001e,'/F\u0001v!\t9d/\u0003\u0002xQ\tq2i\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/Y'b]\u0006<WM]\u0001\u001eG2LWM\u001c;D_:$(o\u001c7mKJ\fVo\u001c;b\u001b\u0006t\u0017mZ3sA\u0005\u0019\"/\u001a9mS\u000e\f\u0017+^8uC6\u000bg.Y4feV\t1\u0010\u0005\u00028y&\u0011Q\u0010\u000b\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJ\fAC]3qY&\u001c\u0017-U;pi\u0006l\u0015M\\1hKJ\u0004\u0013a\u0003:bMRl\u0015M\\1hKJ,\"!a\u0001\u0011\r\u0005\u0015\u00111BA\b\u001b\t\t9AC\u0002\u0002\n)\nAA]1gi&!\u0011QBA\u0004\u0005-\u0011\u0016M\u001a;NC:\fw-\u001a:\u0011\t\u0005E\u0011\u0011E\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005AQ.\u001a;bI\u0006$\u0018MC\u0002,\u00033QA!a\u0007\u0002\u001e\u00051\u0011\r]1dQ\u0016T!!a\b\u0002\u0007=\u0014x-\u0003\u0003\u0002$\u0005M!\u0001F!qS6+7o]1hK\u0006sGMV3sg&|g.\u0001\u0007sC\u001a$X*\u00198bO\u0016\u0014\b%\u0001\u0004rk>$\u0018m]\u000b\u0003\u0003W\u0001B!!\f\u0002B9!\u0011qFA\u001f\u001d\u0011\t\t$a\u000f\u000f\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000e-\u0003\u0019a$o\\8u}%\t1&\u0003\u0002*U%\u0019\u0011q\b\u0015\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\t\u0005\r\u0013Q\t\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0007\u0005}\u0002&A\u0004rk>$\u0018m\u001d\u0011\u0002)\r\u0014X-\u0019;f\u0007>tGO]8mY\u0016\u0014\u0018\t]5t)!\ti%a\u0015\u0002j\u0005]\u0004cA\u001c\u0002P%\u0019\u0011\u0011\u000b\u0015\u0003\u001d\r{g\u000e\u001e:pY2,'/\u00119jg\"9\u0011Q\u000b\u000eA\u0002\u0005]\u0013AC1vi\"|'/\u001b>feB)q&!\u0017\u0002^%\u0019\u00111\f\u0019\u0003\r=\u0003H/[8o!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$\u0002BA+\u0003GR1!KA\f\u0013\u0011\t9'!\u0019\u0003\u0015\u0005+H\u000f[8sSj,'\u000fC\u0004\u0002li\u0001\r!!\u001c\u0002\u0015\r|g\u000e\u001e:pY2,'\u000f\u0005\u0003\u0002p\u0005MTBAA9\u0015\u0011\tY'a\u0006\n\t\u0005U\u0014\u0011\u000f\u0002\u000b\u0007>tGO]8mY\u0016\u0014\b\"CA=5A\u0005\t\u0019AA>\u0003\u0015\u0001(o\u001c9t!\u0011\ti(a!\u000e\u0005\u0005}$bAAA\t\u0006!Q\u000f^5m\u0013\u0011\t))a \u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0010de\u0016\fG/Z\"p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0012\u0016\u0005\u0003w\nii\u000b\u0002\u0002\u0010B!\u0011\u0011SAN\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015!C;oG\",7m[3e\u0015\r\tI\nM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAO\u0003'\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00031\u0011W/\u001b7e%\u0016\fX/Z:u+\u0011\t\u0019+!4\u0015\r\u0005\u0015\u00161VA`!\rq\u0015qU\u0005\u0004\u0003S3&a\u0002*fcV,7\u000f\u001e\u0005\b\u0003[c\u0002\u0019AAX\u0003\u001d\u0011X-];fgR\u0004B!!-\u0002<6\u0011\u00111\u0017\u0006\u0005\u0003k\u000b9,\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\tI,a\u0006\u0002\r\r|W.\\8o\u0013\u0011\ti,a-\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRD\u0011\"!1\u001d!\u0003\u0005\r!a1\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005\u0015\u0017\u0011Z\u0007\u0003\u0003\u000fT1!UA\\\u0013\u0011\tY-a2\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0005\u000f\u0005=GD1\u0001\u0002R\n\tA+\u0005\u0003\u0002T\u0006=\u0006cA\u0018\u0002V&\u0019\u0011q\u001b\u0019\u0003\u000f9{G\u000f[5oO\u00061\"-^5mIJ+\u0017/^3ti\u0012\"WMZ1vYR$#'\u0006\u0003\u0002^\u0006\u0005XCAApU\u0011\t\u0019-!$\u0005\u000f\u0005=WD1\u0001\u0002R\u00061B/Z:u\u0005J|7.\u001a:SK\u001eL7\u000f\u001e:bi&|g\u000e\u0006\u0002\u0002hB\u0019q&!;\n\u0007\u0005-\bG\u0001\u0003V]&$\bf\u0001\u0010\u0002pB!\u0011\u0011_A\u0000\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006]\u0018aA1qS*!\u0011\u0011`A~\u0003\u001dQW\u000f]5uKJTA!!@\u0002\u001e\u0005)!.\u001e8ji&!!\u0011AAz\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e\u001c()\u001f(b[\u0016D3aHAx\u0003Q!Xm\u001d;EK2,G/\u001a+pa&\u001c7OQ=JI\"\u001a\u0001%a<\u0002=Q,7\u000f^%om\u0006d\u0017\u000e\u001a#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$\bfA\u0011\u0002p\u0006QC/Z:u\u001d>$\u0018)\u001e;i_JL'0\u001a3U_\u0012+G.\u001a;f/&$\b\u000eV8qS\u000e,\u00050[:uS:<\u0007f\u0001\u0012\u0002p\u0006iC/Z:u\u001d>$\u0018)\u001e;i_JL'0\u001a3U_\u0012+G.\u001a;f/&$\b\u000eV8qS\u000etu\u000e^#ySN$\u0018N\\4)\u0007\r\ny/\u0001\u0017uKN$hj\u001c;D_:$(o\u001c7mKJ,%O]8s!J,g/\u001a8ug\u0012+G.\u001a;j]\u001e$v\u000e]5dg\"\u001aA%a<\u00021Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e\u001cH)[:bE2,G\rK\u0002&\u0003_\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004M\t\r\u0002\u0003BAy\u0005KIAAa\n\u0002t\nI\u0011I\u001a;fe\u0016\u000b7\r\u001b")
public class ControllerApisTest {
    private final int nodeId;
    private final String brokerRack;
    private final String clientID;
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
    private final RequestChannel requestChannel = (RequestChannel)EasyMock.createNiceMock(RequestChannel.class);
    private final MockTime time = new MockTime();
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)EasyMock.createNiceMock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)EasyMock.createNiceMock(ClientRequestQuotaManager.class);
    private final ControllerMutationQuotaManager clientControllerQuotaManager = (ControllerMutationQuotaManager)EasyMock.createNiceMock(ControllerMutationQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
    private final RaftManager<ApiMessageAndVersion> raftManager = (RaftManager)EasyMock.createNiceMock(RaftManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.clientControllerQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), (Option)None$.MODULE$);

    private int nodeId() {
        return this.nodeId;
    }

    private String brokerRack() {
        return this.brokerRack;
    }

    private String clientID() {
        return this.clientID;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private MockTime time() {
        return this.time;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ControllerMutationQuotaManager clientControllerQuotaManager() {
        return this.clientControllerQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private ControllerApis createControllerApis(Option<Authorizer> authorizer, Controller controller, Properties props) {
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Predef$.MODULE$.int2Integer(this.nodeId()));
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        return new ControllerApis(this.requestChannel(), authorizer, this.quotas(), (Time)this.time(), Predef$.MODULE$.Map().empty(), controller, this.raftManager(), new KafkaConfig((Map)props), new MetaProperties("JgxuGe9URy-E-ceaL04lEw", this.nodeId()), (Seq)Nil$.MODULE$, (ApiVersionManager)new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER));
    }

    private Properties createControllerApis$default$3() {
        return new Properties();
    }

    private <T extends AbstractRequest> RequestChannel.Request buildRequest(AbstractRequest request, ListenerName listenerName) {
        ByteBuffer buffer = RequestTestUtils.serializeRequestWithHeader((RequestHeader)new RequestHeader(request.apiKey(), request.version(), this.clientID(), 0), (AbstractRequest)request);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7());
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    @Test
    public void testBrokerRegistration() {
        BrokerRegistrationRequest brokerRegistrationRequest = (BrokerRegistrationRequest)new BrokerRegistrationRequest.Builder(new BrokerRegistrationRequestData().setBrokerId(this.nodeId()).setRack(this.brokerRack())).build();
        RequestChannel.Request request = this.buildRequest((AbstractRequest)brokerRegistrationRequest, this.buildRequest$default$2());
        Capture capturedResponse = EasyMock.newCapture();
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Some authorizer = new Some(EasyMock.createNiceMock(Authorizer.class));
        EasyMock.expect((Object)((Authorizer)authorizer.get()).authorize((AuthorizableRequestContext)EasyMock.anyObject(), (List)EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<List<AuthorizationResult>>(null){

            public List<AuthorizationResult> answer() {
                return new ArrayList<AuthorizationResult>(null){
                    {
                        this.add(AuthorizationResult.DENIED);
                    }
                };
            }
        });
        EasyMock.replay((Object[])new Object[]{this.requestChannel(), authorizer.get()});
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)authorizer, (Controller)EasyMock.createNiceMock(Controller.class), this.createControllerApis$default$3());
        ClusterAuthorizationException assertion = (ClusterAuthorizationException)Assertions.assertThrows(ClusterAuthorizationException.class, () -> controllerApis.handleBrokerRegistration(request));
        Errors errors = Errors.forException((Throwable)assertion);
        Errors errors2 = Errors.CLUSTER_AUTHORIZATION_FAILED;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    @Test
    public void testDeleteTopicsByName() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"foo", "bar", "quux", "quux"}));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage("This server does not host this topic-partition."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable & scala.Serializable)x$2 -> Predef$.MODULE$.Set().empty())).asScala()).toSet());
    }

    @Test
    public void testDeleteTopicsById() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid quuxId = Uuid.fromString((String)"ObXkLhL_S5W62FAE67U3MQ");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(quuxId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage("This server does not host this topic ID."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable & scala.Serializable)x$3 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable & scala.Serializable)x$4 -> Predef$.MODULE$.Set().empty())).asScala()).toSet());
    }

    @Test
    public void testInvalidDeleteTopicsRequest() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"YOS4oQ3UT9eSAZahN1ysSA");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Neither topic name nor id were specified."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("You may not specify both topic name and topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setTopicId(barId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("The provided topic name maps to an ID that was already supplied."), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(bazId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id.")}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)names -> names.toSet(), (Function1 & Serializable & scala.Serializable)names -> names.toSet())).asScala()).toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicExisting() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"hr4TVh3YQiu3p16Awkka6w");
        Uuid quuxId = Uuid.fromString((String)"5URoQzW_RJiERVZXJgUVLg");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).newInitialTopic("baz", bazId).newInitialTopic("quux", quuxId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("baz").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("baz").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$5 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "baz"})), (Function1 & Serializable & scala.Serializable)x$6 -> Predef$.MODULE$.Set().empty())).asScala()).toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicNotExisting() {
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_ID.message())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$7 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Function1 & Serializable & scala.Serializable)x$8 -> Predef$.MODULE$.Set().empty())).asScala()).toSet());
    }

    @Test
    public void testNotControllerErrorPreventsDeletingTopics() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        controller.setActive(false);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals(NotControllerException.class, Assertions.assertThrows(ExecutionException.class, () -> controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$9 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$10 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})))).getCause().getClass());
    }

    @Test
    public void testDeleteTopicsDisabled() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "false");
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, props);
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$11 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$12 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        Assertions.assertThrows(InvalidRequestException.class, () -> controllerApis.deleteTopics(request, 1, false, (Function1 & Serializable & scala.Serializable)x$13 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$14 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
    }

    @AfterEach
    public void tearDown() {
        this.quotas().shutdown();
    }

    public ControllerApisTest() {
        this.nodeId = 1;
        this.brokerRack = "Rack1";
        this.clientID = "Client1";
    }
}

