/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0003\u0006\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C!1!)\u0011\u0006\u0001C!U!)\u0001\b\u0001C\u0001U!)Q\b\u0001C\u0001U!)q\b\u0001C\u0001\u0001\")a\t\u0001C\u0005\u000f\"91\rAI\u0001\n\u0013!'A\u0007#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;UKN$(BA\u0006\r\u0003\u0019\u0019XM\u001d<fe*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005Q\u0011BA\n\u000b\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0017!\t\t\u0002!A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0005+:LG\u000fC\u0003!\u0005\u0001\u0007\u0011%\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u0005!!.\u0019<b\u0013\tA3E\u0001\u0006Qe>\u0004XM\u001d;jKN\fQa]3u+B$\u0012!\u0007\u0015\u0003\u00071\u0002\"!\f\u001c\u000e\u00039R!a\f\u0019\u0002\u0007\u0005\u0004\u0018N\u0003\u00022e\u00059!.\u001e9ji\u0016\u0014(BA\u001a5\u0003\u0015QWO\\5u\u0015\u0005)\u0014aA8sO&\u0011qG\f\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017A\u0010;fgR$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$\u0018J\\2mk\u0012LgnZ\"mkN$XM]!vi\"|'/\u001b>fI>\u0003XM]1uS>t7\u000f\u000b\u0002\u0005uA\u0011QfO\u0005\u0003y9\u0012A\u0001V3ti\u0006qD/Z:u\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+\u0017/^3ti\u0016C8\r\\;eS:<7\t\\;ti\u0016\u0014\u0018)\u001e;i_JL'0\u001a3Pa\u0016\u0014\u0018\r^5p]ND#!\u0002\u001e\u00025Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;\u0015\u0005e\t\u0005\"\u0002\"\u0007\u0001\u0004\u0019\u0015AI5oG2,H-Z\"mkN$XM]!vi\"|'/\u001b>fI>\u0003XM]1uS>t7\u000f\u0005\u0002\u001b\t&\u0011Qi\u0007\u0002\b\u0005>|G.Z1o\u0003i\u0019XM\u001c;EKN\u001c'/\u001b2f\u00072,8\u000f^3s%\u0016\fX/Z:u)\rA5\u000b\u0017\t\u0003\u0013Fk\u0011A\u0013\u0006\u0003\u00172\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003\u001b:\u000baaY8n[>t'BA\u0007P\u0015\t\u0001F'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003%*\u0013q\u0003R3tGJL'-Z\"mkN$XM\u001d*fgB|gn]3\t\u000bQ;\u0001\u0019A+\u0002\u000fI,\u0017/^3tiB\u0011\u0011JV\u0005\u0003/*\u0013a\u0003R3tGJL'-Z\"mkN$XM\u001d*fcV,7\u000f\u001e\u0005\b3\u001e\u0001\n\u00111\u0001[\u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\u0011\u0007iYV,\u0003\u0002]7\t1q\n\u001d;j_:\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0007\u0002\u000f9,Go^8sW&\u0011!m\u0018\u0002\r'>\u001c7.\u001a;TKJ4XM]\u0001%g\u0016tG\u000fR3tGJL'-Z\"mkN$XM\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\tQM\u000b\u0002[M.\nq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Yn\t!\"\u00198o_R\fG/[8o\u0013\tq\u0017NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DescribeClusterRequestTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.doSetup(false);
    }

    @Test
    public void testDescribeClusterRequestIncludingClusterAuthorizedOperations() {
        this.testDescribeClusterRequest(true);
    }

    @Test
    public void testDescribeClusterRequestExcludingClusterAuthorizedOperations() {
        this.testDescribeClusterRequest(false);
    }

    public void testDescribeClusterRequest(boolean includeClusterAuthorizedOperations) {
        scala.collection.immutable.Set expectedBrokers = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(server.config().brokerId()).setHost("localhost").setPort(server.socketServer().boundPort(this.listenerName())).setRack((String)server.config().rack().orNull(Predef$.MODULE$.$conforms())), Buffer$.MODULE$.canBuildFrom())).toSet();
        int expectedControllerId = ((KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeClusterRequestTest.$anonfun$testDescribeClusterRequest$2(x$1)))).last()).config().brokerId();
        String expectedClusterId = ((KafkaServer)this.servers().last()).clusterId();
        int expectedClusterAuthorizedOperations = includeClusterAuthorizedOperations ? Utils.to32BitField((java.util.Set)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)AclEntry$.MODULE$.supportedOperations(ResourceType.CLUSTER).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)x$2.code()), Set$.MODULE$.canBuildFrom())).asJava())) : Integer.MIN_VALUE;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.DESCRIBE_CLUSTER.oldestVersion()), (int)ApiKeys.DESCRIBE_CLUSTER.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(includeClusterAuthorizedOperations)).build((short)version);
            DescribeClusterResponse describeClusterResponse = this.sentDescribeClusterRequest(describeClusterRequest, this.sentDescribeClusterRequest$default$2());
            Assertions.assertEquals((int)expectedControllerId, (int)describeClusterResponse.data().controllerId());
            Assertions.assertEquals((Object)expectedClusterId, (Object)describeClusterResponse.data().clusterId());
            Assertions.assertEquals((int)expectedClusterAuthorizedOperations, (int)describeClusterResponse.data().clusterAuthorizedOperations());
            Assertions.assertEquals((Object)expectedBrokers, (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeClusterResponse.data().brokers()).asScala()).toSet());
        });
    }

    private DescribeClusterResponse sentDescribeClusterRequest(DescribeClusterRequest request, Option<SocketServer> destination) {
        return (DescribeClusterResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Option<SocketServer> sentDescribeClusterRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterRequest$2(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }
}

