/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.log.LogConfig$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.ProducerCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseRequestTest;
import kafka.server.FetchRequestTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u0010!\u0001\u0015BQA\u000b\u0001\u0005\u0002-Bq!\f\u0001A\u0002\u0013%a\u0006C\u0004I\u0001\u0001\u0007I\u0011B%\t\rA\u0003\u0001\u0015)\u00030\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u001d\ty\u0002\u0001C\u0005\u0003CA\u0011\"!\u0010\u0001#\u0003%I!a\u0010\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!1\u00111\u000f\u0001\u0005\nyCa!!\u001e\u0001\t\u0003q\u0006BBA@\u0001\u0011\u0005a\f\u0003\u0004\u0002\u0004\u0002!\tA\u0018\u0005\u0007\u0003\u000f\u0003A\u0011\u00010\t\r\u0005-\u0005\u0001\"\u0001_\u0011\u0019\ty\t\u0001C\u0001=\"1\u00111\u0013\u0001\u0005\u0002yCq!a&\u0001\t\u0013\tI\n\u0003\u0004\u0002(\u0002!\tA\u0018\u0005\u0007\u0003W\u0003A\u0011\u00010\t\r\u0005=\u0006\u0001\"\u0001_\u0011\u0019\t\u0019\f\u0001C\u0001=\"1\u0011q\u0017\u0001\u0005\u0002yCa!a/\u0001\t\u0003q\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\ty\u000f\u0001C\u0005\u0003cD\u0011Ba\u0001\u0001#\u0003%IA!\u0002\t\u000f\t%\u0001\u0001\"\u0003\u0003\f\t\u0001b)\u001a;dQJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003C\t\naa]3sm\u0016\u0014(\"A\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\n\t\u0003O!j\u0011\u0001I\u0005\u0003S\u0001\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"a\n\u0001\u0002\u0011A\u0014x\u000eZ;dKJ,\u0012a\f\t\u0005aeZ4(D\u00012\u0015\ti#G\u0003\u00024i\u000591\r\\5f]R\u001c(BA\u00126\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\n\u0005i\n$!D&bM.\f\u0007K]8ek\u000e,'\u000f\u0005\u0002=\u000b:\u0011Qh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0012\na\u0001\u0010:p_Rt$\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b\u0015A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001R!\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005)s\u0005CA&M\u001b\u0005\t\u0015BA'B\u0005\u0011)f.\u001b;\t\u000f=\u001b\u0011\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\tQ5\u000bC\u0003U\u000b\u0001\u0007Q+\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"AV.\u000e\u0003]S!\u0001W-\u0002\tU$\u0018\u000e\u001c\u0006\u00025\u0006!!.\u0019<b\u0013\tavK\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002\u0015\"\u0012a\u0001\u0019\t\u0003C\"l\u0011A\u0019\u0006\u0003G\u0012\f1!\u00199j\u0015\t)g-A\u0004kkBLG/\u001a:\u000b\u0005\u001d<\u0014!\u00026v]&$\u0018BA5c\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\nde\u0016\fG/\u001a$fi\u000eD'+Z9vKN$HC\u00027usn\fy\u0001\u0005\u0002ne6\taN\u0003\u0002pa\u0006A!/Z9vKN$8O\u0003\u0002ri\u000511m\\7n_:L!a\u001d8\u0003\u0019\u0019+Go\u00195SKF,Xm\u001d;\t\u000bU<\u0001\u0019\u0001<\u0002!5\f\u0007PU3ta>t7/\u001a\"zi\u0016\u001c\bCA&x\u0013\tA\u0018IA\u0002J]RDQA_\u0004A\u0002Y\f\u0011#\\1y!\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010^3t\u0011\u0015ax\u00011\u0001~\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b#\u0002@\u0002\u0004\u0005\u001dQ\"A@\u000b\u0007\u0005\u0005\u0011)\u0001\u0006d_2dWm\u0019;j_:L1!!\u0002\u0000\u0005\r\u0019V-\u001d\t\u0005\u0003\u0013\tY!D\u0001q\u0013\r\ti\u0001\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\tb\u0002a\u0001\u0003'\t\u0011b\u001c4gg\u0016$X*\u00199\u0011\u000fq\n)\"a\u0002\u0002\u001a%\u0019\u0011qC$\u0003\u00075\u000b\u0007\u000fE\u0002L\u00037I1!!\bB\u0005\u0011auN\\4\u0002%\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\u000b\t\u0003G\t9$!\u000f\u0002<A9a+!\n\u0002\b\u0005%\u0012bAA\u0014/\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004B!a\u000b\u000229\u0019Q.!\f\n\u0007\u0005=b.\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u00024\u0005U\"!\u0004)beRLG/[8o\t\u0006$\u0018MC\u0002\u000209DQA\u001f\u0005A\u0002YDQ\u0001 \u0005A\u0002uD\u0011\"!\u0005\t!\u0003\u0005\r!a\u0005\u00029\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\t\u0016\u0005\u0003'\t\u0019e\u000b\u0002\u0002FA!\u0011qIA)\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013!C;oG\",7m[3e\u0015\r\ty%Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA*\u0003\u0013\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003A\u0019XM\u001c3GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0004\u0002Z\u0005-\u0014q\u000e\t\u0006[\u0006m\u0013qL\u0005\u0004\u0003;r'!\u0004$fi\u000eD'+Z:q_:\u001cX\r\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)\u0007]\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005%\u00141\r\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\r\u00055$\u00021\u0001w\u0003!aW-\u00193fe&#\u0007BBA9\u0015\u0001\u0007A.A\u0004sKF,Xm\u001d;\u0002\u0019%t\u0017\u000e\u001e)s_\u0012,8-\u001a:\u0002]Q,7\u000f\u001e\"s_.,'OU3ta\u0016\u001cGo\u001d)beRLG/[8og>\u0013H-\u001a:B]\u0012\u001c\u0016N_3MS6LGo\u001d\u0015\u0004\u0019\u0005e\u0004cA1\u0002|%\u0019\u0011Q\u00102\u0003\tQ+7\u000f^\u0001'i\u0016\u001cHOR3uG\"\u0014V-];fgR4&gV5uQ>3XM]:ju\u0016$W*Z:tC\u001e,\u0007fA\u0007\u0002z\u0005\u0019C/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e,5/&$\bNU3bI\u000e{W.\\5ui\u0016$\u0007f\u0001\b\u0002z\u0005aB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e+p\u001d>t'+\u001a9mS\u000e\f\u0007fA\b\u0002z\u0005qB/Z:u\u0019\u0006\u001cHOR3uG\",G-\u00129pG\"4\u0016\r\\5eCRLwN\u001c\u0015\u0004!\u0005e\u0014A\u0007;fgR\u001cUO\u001d:f]R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>t\u0007fA\t\u0002z\u0005)C/Z:u\u000bB|7\r\u001b,bY&$\u0017\r^5p]^KG\u000f[5o\r\u0016$8\r[*fgNLwN\u001c\u0015\u0004%\u0005e\u0014\u0001\u0007<fe&4\u0017PR3uG\"\u001cVm]:j_:,%O]8sgR9!*a'\u0002 \u0006\r\u0006bBAO'\u0001\u0007\u0011qA\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t\tk\u0005a\u0001m\u0006YA.Z1eKJ,\u0005o\\2i\u0011\u0019\t)k\u0005a\u0001m\u0006\u0019B-Z:uS:\fG/[8o\u0005J|7.\u001a:JI\u00069C/Z:u\t><hnQ8om\u0016\u00148/[8o/&$\bnQ8o]\u0016\u001cG/[8o\r\u0006LG.\u001e:fQ\r!\u0012\u0011P\u00017i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gN\u0012:p[\n\u000bGo\u00195fIR{WK\u001c2bi\u000eDW\r\u001a*fgB,7\r^:PM\u001a\u001cX\r\u001e\u0015\u0004+\u0005e\u0014a\f;fgR\u001c%/Z1uK&s7M]3nK:$\u0018\r\u001c$fi\u000eDw+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c\u0018J\\#se>\u0014\bf\u0001\f\u0002z\u00059B/Z:u5N#HmQ8naJ,7o]3e)>\u0004\u0018n\u0019\u0015\u0004/\u0005e\u0014a\u0006;fgR\u0004\u0016M\u001d;ji&|g\u000eR1uC\u0016\u000bX/\u00197tQ\rA\u0012\u0011P\u0001\u001ai\u0016\u001cHOW*uI\u000e{W\u000e\u001d:fgN,GMU3d_J$7\u000fK\u0002\u001a\u0003s\nqA]3d_J$7\u000f\u0006\u0003\u0002D\u0006-\u0007#\u0002@\u0002\u0004\u0005\u0015\u0007\u0003BA1\u0003\u000fLA!!3\u0002d\t1!+Z2pe\u0012Dq!!4\u001b\u0001\u0004\ty-A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0007\u0003#\f9.a\u0018\u000f\u00075\f\u0019.C\u0002\u0002V:\fQBR3uG\"\u0014Vm\u001d9p]N,\u0017\u0002BA\u001a\u00033T1!!6o\u0003I\u0019\u0007.Z2l\r\u0016$8\r\u001b*fgB|gn]3\u0015\u0017)\u000by.a9\u0002h\u0006%\u00181\u001e\u0005\u0007\u0003C\\\u0002\u0019A?\u0002%\u0015D\b/Z2uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0003K\\\u0002\u0019AA-\u000351W\r^2i%\u0016\u001c\bo\u001c8tK\")!p\u0007a\u0001m\")Qo\u0007a\u0001m\"1\u0011Q^\u000eA\u0002Y\fqC\\;n\u001b\u0016\u001c8/Y4fgB+'\u000fU1si&$\u0018n\u001c8\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0015\u0011\u0005M\u0018Q_A}\u0003{\u0004b\u0001PA\u000b\u0003\u000f1\bBBA|9\u0001\u0007a/A\u0005ok6$v\u000e]5dg\"1\u00111 \u000fA\u0002Y\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\"CA\u00009A\u0005\t\u0019\u0001B\u0001\u0003\u001d\u0019wN\u001c4jON\u0004R\u0001PA\u000bwm\nac\u0019:fCR,Gk\u001c9jGN$C-\u001a4bk2$HeM\u000b\u0003\u0005\u000fQCA!\u0001\u0002D\u0005Y\u0001O]8ek\u000e,G)\u0019;b)\u0019\u0011iA!\u0006\u0003*A)a0a\u0001\u0003\u0010A\u0019\u0001G!\u0005\n\u0007\tM\u0011G\u0001\bSK\u000e|'\u000fZ'fi\u0006$\u0017\r^1\t\rqt\u0002\u0019\u0001B\f!\u0019\u0011IBa\t\u0002\b9!!1\u0004B\u0010\u001d\rq$QD\u0005\u0002\u0005&\u0019!\u0011E!\u0002\u000fA\f7m[1hK&!!Q\u0005B\u0014\u0005!IE/\u001a:bE2,'b\u0001B\u0011\u0003\"1\u0011Q\u001e\u0010A\u0002Y\u0004")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> producer = null;

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.FetchMaxBytes(), Integer.toString(Integer.MAX_VALUE));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> partitionMap.put((TopicPartition)tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty())));
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private void initProducer() {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3, x$16));
    }

    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new scala.Serializable(null, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    TopicPartition tp = (TopicPartition)x1._1();
                    if (x1._2$mcI$sp() == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                boolean bl = x1 != null && x1._2$mcI$sp() == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionsWithLargeMessages.contains(elem)));
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)new .colon.colon((Object)partitionWithLargeMessage1, (List)new .colon.colon((Object)partitionWithLargeMessage2, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assertions.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse3.responseData()).asScala()).values().map((Function1 & Serializable & scala.Serializable)partitionData -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(this, partitionData)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)partitionData3.error());
        Assertions.assertTrue((partitionData3.highWatermark() > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData3).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size3 <= maxResponseBytes ? 1 : 0) != 0, (String)new StringBuilder(29).append("Expected ").append(size3).append(" to be smaller than ").append(maxResponseBytes).toString());
        Assertions.assertTrue((size3 > maxPartitionBytes ? 1 : 0) != 0, (String)new StringBuilder(28).append("Expected ").append(size3).append(" to be larger than ").append(maxPartitionBytes).toString());
        Assertions.assertTrue((maxPartitionBytes < ((MemoryRecords)partitionData3.records()).sizeInBytes() ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)new .colon.colon((Object)partitionWithLargeMessage2, (List)new .colon.colon((Object)partitionWithLargeMessage1, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assertions.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((scala.collection.mutable.MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                if (x2 != null) {
                    TopicPartition tp = (TopicPartition)x2._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)x2._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$applyOrElse$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> x2) {
                FetchResponse.PartitionData partitionData;
                boolean bl = x2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)(partitionData = (FetchResponse.PartitionData)x2._2())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$isDefinedAt$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$1(Record x$3) {
                return x$3.sizeInBytes();
            }

            public static final /* synthetic */ int $anonfun$isDefinedAt$1(Record x$3) {
                return x$3.sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.kafka.common.record.Record ), $anonfun$isDefinedAt$1$adapted(org.apache.kafka.common.record.Record )}, serializedLambda);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)new .colon.colon((Object)partitionWithLargeMessage2, (List)Nil$.MODULE$), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)partitionData4.error());
        Assertions.assertTrue((partitionData4.highWatermark() > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData4).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size4 > maxResponseBytes ? 1 : 0) != 0, (String)new StringBuilder(28).append("Expected ").append(size4).append(" to be larger than ").append(maxResponseBytes).toString());
        Assertions.assertTrue((maxResponseBytes < ((MemoryRecords)partitionData4.records()).sizeInBytes() ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        void var3_3;
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build((short)2);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(n, fetchRequest).responseData().get(var3_3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)maxPartitionBytes, (int)((MemoryRecords)partitionData.records()).sizeInBytes());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchRequestV4WithReadCommitted() {
        void var3_3;
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(n, fetchRequest).responseData().get(var3_3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Assertions.assertTrue((partitionData.lastStableOffset() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestToNonReplica$1(leader, x$9)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(nonReplicaId, fetchRequest).responseData().get(topicPartition);
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)partitionData.error());
    }

    @Test
    public void testLastFetchedEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.initProducer();
        long firstEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        long secondEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        long fetchOffset = secondEpochEndOffset + (secondEpochEndOffset - firstEpochEndOffset) / 2L;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(fetchOffset, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), Optional.of(Predef$.MODULE$.int2Integer(firstLeaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(secondLeaderId, fetchRequest).responseData().get(topicPartition);
        Assertions.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Assertions.assertEquals((long)0L, (long)((MemoryRecords)partitionData.records()).sizeInBytes());
        Assertions.assertTrue((boolean)partitionData.divergingEpoch().isPresent());
        FetchResponseData.EpochEndOffset divergingEpoch = (FetchResponseData.EpochEndOffset)partitionData.divergingEpoch().get();
        Assertions.assertEquals((int)firstLeaderEpoch, (int)divergingEpoch.epoch());
        Assertions.assertEquals((long)firstEpochEndOffset, (long)divergingEpoch.endOffset());
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    @Test
    public void testEpochValidationWithinFetchSession() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, secondLeaderId);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, followerId);
    }

    private void verifyFetchSessionErrors(TopicPartition topicPartition, int leaderEpoch, int destinationBrokerId) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(0L, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).metadata(FetchMetadata.INITIAL).build();
        int sessionId = this.sendFetchRequest(destinationBrokerId, fetchRequest).sessionId();
        this.assertResponseErrorForEpoch$2(Errors.FENCED_LEADER_EPOCH, 1, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), topicPartition, sessionId, destinationBrokerId);
        this.assertResponseErrorForEpoch$2(Errors.UNKNOWN_LEADER_EPOCH, 2, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), topicPartition, sessionId, destinationBrokerId);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionWithConnectionFailure() {
        IndexedSeq indexedSeq;
        void var2_2;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$2 = Integer.MAX_VALUE;
        int x$3 = Integer.MAX_VALUE;
        StringSerializer x$5 = new StringSerializer();
        ByteArraySerializer x$6 = new ByteArraySerializer();
        int x$7 = TestUtils$.MODULE$.createProducer$default$2();
        long x$8 = TestUtils$.MODULE$.createProducer$default$3();
        long x$9 = TestUtils$.MODULE$.createProducer$default$4();
        int x$10 = TestUtils$.MODULE$.createProducer$default$5();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$122 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        byte[] bytes = new byte[msgValueLen];
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$7, x$8, x$9, x$10, x$3, x$2, batchSize, x$11, x$122, x$13, x$14, x$15, x$5, x$6, x$16);){
            indexedSeq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).map(arg_0 -> FetchRequestTest.$anonfun$testDownConversionWithConnectionFailure$1$adapted(producer, (TopicPartition)var2_2, bytes, arg_0), IndexedSeq$.MODULE$.canBuildFrom());
        }
        indexedSeq.foreach((Function1 & Serializable & scala.Serializable)x$12 -> (RecordMetadata)x$12.get());
        short version = (short)1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach(arg_0 -> FetchRequestTest.$anonfun$testDownConversionWithConnectionFailure$3$adapted(this, version, msgValueLen, (TopicPartition)var2_2, n, batchSize, arg_0));
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)((FetchResponse)this.fetch$1(version, batchSize, false, (TopicPartition)var2_2, n, batchSize).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No fetch response");
        })).responseData().get(var2_2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Buffer batches = ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records()).batches()).asScala()).toBuffer();
        Assertions.assertEquals((int)3, (int)batches.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        void var21_19;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$2 = 5;
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$5 = 30000;
        int x$6 = 60000;
        int x$7 = TestUtils$.MODULE$.createProducer$default$2();
        long x$8 = TestUtils$.MODULE$.createProducer$default$3();
        long x$9 = TestUtils$.MODULE$.createProducer$default$4();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$152 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$162 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$7, x$8, x$9, x$2, x$6, x$5, x$10, x$11, x$12, x$13, x$14, x$152, x$3, x$4, x$162));
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)KAFKA_0_11_0_IV2$.MODULE$.version())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        String topic = var21_19.topic();
        IndexedSeq firstBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        IndexedSeq secondBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 25).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        firstBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$15 -> (RecordMetadata)x$15.get());
        secondBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$16 -> (RecordMetadata)x$16.get());
        long x$17 = 3L;
        long x$18 = 3L;
        short x$19 = 1;
        int x$20 = 22;
        byte x$21 = 0;
        this.check$1(x$17, x$19, x$18, x$20, x$21, (TopicPartition)var21_19, n);
        long x$22 = 15L;
        long x$23 = 15L;
        short x$24 = 1;
        int x$25 = 10;
        byte x$26 = 0;
        this.check$1(x$22, x$24, x$23, x$25, x$26, (TopicPartition)var21_19, n);
        long x$27 = 3L;
        long x$28 = 3L;
        short x$29 = 3;
        int x$30 = 22;
        byte x$31 = 1;
        this.check$1(x$27, x$29, x$28, x$30, x$31, (TopicPartition)var21_19, n);
        long x$32 = 15L;
        long x$33 = 15L;
        short x$34 = 3;
        int x$35 = 10;
        byte x$36 = 1;
        this.check$1(x$32, x$34, x$33, x$35, x$36, (TopicPartition)var21_19, n);
        long x$37 = 3L;
        long x$38 = 0L;
        short x$39 = 4;
        int x$40 = 2;
        byte x$41 = 2;
        this.check$1(x$37, x$39, x$38, x$40, x$41, (TopicPartition)var21_19, n);
        long x$42 = 15L;
        long x$43 = 10L;
        short x$44 = 4;
        int x$45 = 1;
        byte x$46 = 2;
        this.check$1(x$42, x$44, x$43, x$45, x$46, (TopicPartition)var21_19, n);
        long x$47 = 10L;
        long x$48 = 10L;
        short x$49 = 4;
        int x$50 = 1;
        byte x$51 = 2;
        this.check$1(x$47, x$49, x$48, x$50, x$51, (TopicPartition)var21_19, n);
    }

    @Test
    public void testCreateIncrementalFetchWithPartitionsInError() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopic("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})))}))));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createFetchRequest$2((Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)Nil$.MODULE$))), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp1 = this.sendFetchRequest(0, req1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() > 0 ? 1 : 0) != 0, (String)"Expected the broker to create a new incremental fetch session");
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Test created an incremental fetch session ").append(resp1.sessionId()).toString());
        Assertions.assertTrue((boolean)resp1.responseData().containsKey(foo0));
        Assertions.assertTrue((boolean)resp1.responseData().containsKey(foo1));
        Assertions.assertTrue((boolean)resp1.responseData().containsKey(bar0));
        Assertions.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get(foo0)).error());
        Assertions.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get(foo1)).error());
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp1.responseData().get(bar0)).error());
        FetchRequest req2 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp2 = this.sendFetchRequest(0, req2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId(), (String)"Expected the broker to continue the incremental fetch session");
        Assertions.assertFalse((boolean)resp2.responseData().containsKey(foo0));
        Assertions.assertFalse((boolean)resp2.responseData().containsKey(foo1));
        Assertions.assertTrue((boolean)resp2.responseData().containsKey(bar0));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp2.responseData().get(bar0)).error());
        this.createTopic("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))));
        FetchRequest req3 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp3 = this.sendFetchRequest(0, req3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertFalse((boolean)resp3.responseData().containsKey(foo0));
        Assertions.assertFalse((boolean)resp3.responseData().containsKey(foo1));
        Assertions.assertTrue((boolean)resp3.responseData().containsKey(bar0));
        Assertions.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp3.responseData().get(bar0)).error());
        FetchRequest req4 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp4 = this.sendFetchRequest(0, req4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertFalse((boolean)resp4.responseData().containsKey(foo0));
        Assertions.assertFalse((boolean)resp4.responseData().containsKey(foo1));
        Assertions.assertFalse((boolean)resp4.responseData().containsKey(bar0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedTopic() {
        void var3_3;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ZStdCompressionCodec$.MODULE$.name())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3, x$16));
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key1", (Object)"value1")).get();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key2", (Object)"value2")).get();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key3", (Object)"value3")).get();
        this.producer().close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req0).responseData().get(var3_3);
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data0.error());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req1).responseData().get(var3_3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)data1.error());
        Assertions.assertEquals((int)3, (int)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data1).size());
    }

    @Test
    public void testPartitionDataEquals() {
        Assertions.assertEquals((Object)new FetchRequest.PartitionData(300L, 0L, 300, Optional.of(Predef$.MODULE$.int2Integer(300))), (Object)new FetchRequest.PartitionData(300L, 0L, 300, Optional.of(Predef$.MODULE$.int2Integer(300))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedRecords() {
        void var3_3;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ProducerCompressionCodec$.MODULE$.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp()), (Object)"2.0.0")}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$2 = GZIPCompressionCodec$.MODULE$.name();
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$5 = TestUtils$.MODULE$.createProducer$default$2();
        long x$6 = TestUtils$.MODULE$.createProducer$default$3();
        long x$7 = TestUtils$.MODULE$.createProducer$default$4();
        int x$8 = TestUtils$.MODULE$.createProducer$default$5();
        int x$9 = TestUtils$.MODULE$.createProducer$default$6();
        int x$10 = TestUtils$.MODULE$.createProducer$default$7();
        int x$11 = TestUtils$.MODULE$.createProducer$default$8();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$2, x$12, x$13, x$14, x$15, x$3, x$4, x$16);
        producer1.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key1", (Object)"value1")).get();
        producer1.close();
        String x$17 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$18 = ZStdCompressionCodec$.MODULE$.name();
        StringSerializer x$19 = new StringSerializer();
        StringSerializer x$20 = new StringSerializer();
        int x$21 = TestUtils$.MODULE$.createProducer$default$2();
        long x$22 = TestUtils$.MODULE$.createProducer$default$3();
        long x$23 = TestUtils$.MODULE$.createProducer$default$4();
        int x$24 = TestUtils$.MODULE$.createProducer$default$5();
        int x$25 = TestUtils$.MODULE$.createProducer$default$6();
        int x$26 = TestUtils$.MODULE$.createProducer$default$7();
        int x$27 = TestUtils$.MODULE$.createProducer$default$8();
        int x$28 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$29 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$30 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$31 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$32 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$17, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$18, x$28, x$29, x$30, x$31, x$19, x$20, x$32);
        producer2.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key2", (Object)"value2")).get();
        producer2.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key3", (Object)"value3")).get();
        producer2.close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req0).responseData().get(var3_3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)data0.error());
        Assertions.assertEquals((int)1, (int)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data0).size());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var3_3), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req1).responseData().get(var3_3);
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data1.error());
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(2, 3, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse.PartitionData data2 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req2).responseData().get(var3_3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)data2.error());
        Assertions.assertEquals((int)1, (int)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data2).size());
        FetchRequest req3 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var3_3), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponse.PartitionData data3 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req3).responseData().get(var3_3);
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data3.error());
        FetchRequest req4 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponse.PartitionData data4 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req4).responseData().get(var3_3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)data4.error());
        Assertions.assertEquals((int)3, (int)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data4).size());
    }

    public Seq<Record> kafka$server$FetchRequestTest$$records(FetchResponse.PartitionData<MemoryRecords> partitionData) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)partitionData.records()).records()).asScala()).toBuffer();
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse<MemoryRecords> fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assertions.assertEquals(expectedPartitions, (Object)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestTest.$anonfun$checkFetchResponse$1(fetchResponse, responseBufferSize, numMessagesPerPartition, responseSize, emptyResponseSeen, maxPartitionBytes, tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (int)responseBufferSize.elem);
        Assertions.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).map((Function1 & Serializable & scala.Serializable)t -> FetchRequestTest.$anonfun$createTopics$1(BoxesRunTime.unboxToInt((Object)t)), IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(2));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = topicConfig.setProperty(k, v);
            return object;
        });
        return ((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> (scala.collection.immutable.Map)this.createTopic((String)topic, numPartitions, 2, topicConfig).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int partition = x0$2._1$mcI$sp();
            int leader = x0$2._2$mcI$sp();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToInteger((int)leader));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private Seq<RecordMetadata> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        return (Seq)((Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable & scala.Serializable)tp -> (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessagesPerPartition).map((Function1 & Serializable & scala.Serializable)messageIndex -> FetchRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)messageIndex)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$20 -> (RecordMetadata)this.producer().send(x$20).get(), Seq$.MODULE$.canBuildFrom());
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private static final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ int $anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(FetchRequestTest $this, FetchResponse.PartitionData partitionData) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)$this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestToNonReplica$1(int leader$1, KafkaServer x$9) {
        return x$9.config().brokerId() != leader$1;
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(brokerId, fetchRequest).responseData().get(topicPartition$1);
        Assertions.assertEquals((Object)error, (Object)partitionData.error());
    }

    private final void assertResponseErrorForEpoch$2(Errors expectedError, int sessionFetchEpoch, Optional leaderEpoch, TopicPartition topicPartition$2, int sessionId$1, int destinationBrokerId$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$2, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).metadata(new FetchMetadata(sessionId$1, sessionFetchEpoch)).build();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(destinationBrokerId$1, fetchRequest).responseData().get(topicPartition$2);
        Assertions.assertEquals((Object)expectedError, (Object)partitionData.error());
    }

    private final Option fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1) {
        Some some;
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$3, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build(version);
        try (Socket socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
            if (closeAfterPartialResponse) {
                int size = new DataInputStream(socket.getInputStream()).readInt();
                Assertions.assertTrue((size > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0, (String)new StringBuilder(56).append("Fetch size too small ").append(size).append(", broker may have run out of memory").toString());
                some = None$.MODULE$;
            } else {
                some = new Some(this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())));
            }
        }
        return some;
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$4, int leaderId$3) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.size()) {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$4), (Object)BoxesRunTime.boxToLong((long)currentFetchOffset))}))))).build(requestVersion);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(leaderId$3, fetchRequest).responseData().get(topicPartition$4);
            Assertions.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
            Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
            batches = ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((MemoryRecords)partitionData.records()).batches()).asScala()).toBuffer();
            MutableRecordBatch batch = (MutableRecordBatch)batches.head();
            Assertions.assertEquals((byte)expectedMagic, (byte)batch.magic());
            Assertions.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assertions.assertEquals((int)expectedNumBatches, (int)batchesReceived);
    }

    private final FetchRequest createFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).toForget((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(toForget).asJava()).metadata(metadata).build();
    }

    public static final /* synthetic */ void $anonfun$checkFetchResponse$1(FetchResponse fetchResponse$1, IntRef responseBufferSize$1, int numMessagesPerPartition$1, IntRef responseSize$1, BooleanRef emptyResponseSeen$1, int maxPartitionBytes$3, TopicPartition tp) {
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse$1.responseData().get(tp);
        Assertions.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        MemoryRecords records = (MemoryRecords)partitionData.records();
        responseBufferSize$1.elem += records.sizeInBytes();
        Buffer batches = ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).toBuffer();
        Assertions.assertTrue((batches.size() < numMessagesPerPartition$1 ? 1 : 0) != 0);
        int batchesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches.map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.sizeInBytes()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        responseSize$1.elem += batchesSize;
        if (batchesSize == 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertEquals((int)0, (int)records.sizeInBytes());
            emptyResponseSeen$1.elem = true;
            return;
        }
        if (batchesSize != 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertTrue((batchesSize <= maxPartitionBytes$3 ? 1 : 0) != 0);
            Assertions.assertEquals((int)maxPartitionBytes$3, (int)records.sizeInBytes());
            return;
        }
        if (batchesSize != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)new StringBuilder(53).append("Expected partition with size 0, but found ").append(tp).append(" with size ").append(batchesSize).toString());
            return;
        }
        if (records.sizeInBytes() != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)new StringBuilder(60).append("Expected partition buffer with size 0, but found ").append(tp).append(" with size ").append(records.sizeInBytes()).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$createTopics$1(int t) {
        return new StringBuilder(5).append("topic").append(t).toString();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = new StringBuilder(1).append(tp$1).append("-").append(messageIndex).toString();
        return new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), (Object)new StringBuilder(4).append("key ").append(suffix).toString(), (Object)new StringBuilder(6).append("value ").append(suffix).toString());
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionWithConnectionFailure$1$adapted(KafkaProducer producer$1, TopicPartition topicPartition$3, byte[] bytes$1, Object x$11) {
        return producer$1.send(new ProducerRecord(topicPartition$3.topic(), Predef$.MODULE$.int2Integer(topicPartition$3.partition()), (Object)"key", (Object)bytes$1));
    }

    public static final /* synthetic */ Option $anonfun$testDownConversionWithConnectionFailure$3$adapted(FetchRequestTest $this, short version$1, int msgValueLen$1, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1, Object x$13) {
        return $this.fetch$1(version$1, msgValueLen$1 * 1000, true, topicPartition$3, leaderId$2, batchSize$1);
    }
}

