/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001q4A!\u0005\n\u0001/!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0001G!)A\u0007\u0001C\u0001k!)1\t\u0001C\u0005\t\")a\n\u0001C\u0001G!)\u0001\u000b\u0001C\u0001G!9!\u000b\u0001b\u0001\n\u0003\u0019\u0006BB3\u0001A\u0003%A\u000bC\u0003g\u0001\u0011\u00051\u0005C\u0003i\u0001\u0011\u00051\u0005C\u0003k\u0001\u0011\u00051\u0005C\u0003m\u0001\u0011\u00051\u0005C\u0003o\u0001\u0011\u00051\u0005C\u0003q\u0001\u0011\u00051\u0005C\u0003s\u0001\u0011\u00051\u0005C\u0003u\u0001\u0011\u00051E\u0001\tGKR\u001c\u0007nU3tg&|g\u000eV3ti*\u00111\u0003F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\n\u0002!Q,7\u000f\u001e(foN+7o]5p]&#G#\u0001\u0013\u0011\u0005e)\u0013B\u0001\u0014\u001b\u0005\u0011)f.\u001b;)\u0005\tA\u0003CA\u00153\u001b\u0005Q#BA\u0016-\u0003\r\t\u0007/\u001b\u0006\u0003[9\nqA[;qSR,'O\u0003\u00020a\u0005)!.\u001e8ji*\t\u0011'A\u0002pe\u001eL!a\r\u0016\u0003\tQ+7\u000f^\u0001\u0014CN\u001cXM\u001d;DC\u000eDWmQ8oi\u0006Lgn\u001d\u000b\u0004IYZ\u0004\"B\u001c\u0004\u0001\u0004A\u0014!B2bG\",\u0007CA\u0011:\u0013\tQ$CA\tGKR\u001c\u0007nU3tg&|gnQ1dQ\u0016DQ\u0001P\u0002A\u0002u\n!b]3tg&|g.\u00133t!\rIb\bQ\u0005\u0003\u007fi\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\tI\u0012)\u0003\u0002C5\t\u0019\u0011J\u001c;\u0002\u0017\u0011,X.\\=De\u0016\fG/\u001a\u000b\u0003\u000b2\u0003\"AR%\u000f\u0005\u0005:\u0015B\u0001%\u0013\u000311U\r^2i'\u0016\u001c8/[8o\u0013\tQ5JA\u0005D\u0003\u000eCUiX'B!*\u0011\u0001J\u0005\u0005\u0006\u001b\u0012\u0001\r\u0001Q\u0001\u0005g&TX-\u0001\tuKN$8+Z:tS>t7)Y2iK\"\u0012Q\u0001K\u0001\u0019i\u0016\u001cHOU3tSj,7)Y2iK\u0012\u001cVm]:j_:\u001c\bF\u0001\u0004)\u0003=)U\n\u0015+Z?B\u000b%\u000bV0M\u0013N#V#\u0001+\u0011\u0007USF,D\u0001W\u0015\t9\u0006,\u0001\u0003vi&d'\"A-\u0002\t)\fg/Y\u0005\u00037Z\u0013A\u0001T5tiB\u0011QlY\u0007\u0002=*\u0011q\fY\u0001\u0007G>lWn\u001c8\u000b\u0005U\t'B\u000121\u0003\u0019\t\u0007/Y2iK&\u0011AM\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A)U\n\u0015+Z?B\u000b%\u000bV0M\u0013N#\u0006%A\u000buKN$8)Y2iK\u0012dU-\u00193fe\u0016\u0003xn\u00195)\u0005%A\u0013\u0001\u0006;fgRd\u0015m\u001d;GKR\u001c\u0007.\u001a3Fa>\u001c\u0007\u000e\u000b\u0002\u000bQ\u0005\tB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f^:)\u0005-A\u0013a\u0007;fgRLen\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nU3tg&|g\u000e\u000b\u0002\rQ\u0005QB/Z:u\r\u0016$8\r[*fgNLwN\\#ya&\u0014\u0018\r^5p]\"\u0012Q\u0002K\u0001\u001ei\u0016\u001cH\u000f\u0015:jm&dWmZ3e'\u0016\u001c8/[8o\u0011\u0006tG\r\\5oO\"\u0012a\u0002K\u0001\u0019i\u0016\u001cHOW3s_NK'0\u001a$fi\u000eD7+Z:tS>t\u0007FA\b)\u0003I!Xm\u001d;ESZ,'oZ5oO\u0016\u0003xn\u00195)\u0005AA\u0003\u0006\u0002\u0001xun\u0004\"!\u000b=\n\u0005eT#a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002q\u0002")
public class FetchSessionTest {
    private final List<TopicPartition> EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());

    @Test
    public void testNewSessionId() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertTrue((cache.newSessionId() > 0 ? 1 : 0) != 0));
    }

    public void assertCacheContains(FetchSessionCache cache, Seq<Object> sessionIds) {
        IntRef i = IntRef.create((int)0);
        sessionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sessionId -> {
            ++i$1.elem;
            Assertions.assertTrue((boolean)cache.get(sessionId).isDefined(), (String)new StringBuilder(26).append("Missing session ").append(i$1.elem).append(" out of ").append(sessionIds.size()).append("(").append(sessionId).append(")").toString());
        });
        Assertions.assertEquals((int)sessionIds.size(), (int)cache.size());
    }

    /*
     * WARNING - void declaration
     */
    private ImplicitLinkedHashCollection<CachedPartition> dummyCreate(int size) {
        void var2_2;
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> cacheMap.add((ImplicitLinkedHashCollection.Element)new CachedPartition("test", i)));
        return var2_2;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        Assertions.assertEquals((int)0, (int)cache.size());
        int id1 = cache.maybeCreateSession(0L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id2 = cache.maybeCreateSession(10L, false, 20, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        int id3 = cache.maybeCreateSession(20L, false, 30, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(30));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(30L, false, 40, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(40)));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(40L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cache.touch((FetchSession)cache.get(id1).get(), 200L);
        int id4 = cache.maybeCreateSession(210L, false, 11, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(11));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 400L);
        cache.touch((FetchSession)cache.get(id3).get(), 390L);
        cache.touch((FetchSession)cache.get(id4).get(), 400L);
        int id5 = cache.maybeCreateSession(410L, false, 50, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(410L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        int id6 = cache.maybeCreateSession(410L, true, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assertions.assertEquals((long)0L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)0, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(2));
        Assertions.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assertions.assertEquals((int)2, (int)session1.size());
        Assertions.assertEquals((long)2L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        Assertions.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)6L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(200L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        Assertions.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)9L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        cache.remove(id3);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2}));
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)4L, (long)cache.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assertions.assertEquals((int)3, (int)session2.size());
        Assertions.assertEquals((int)4, (int)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assertions.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    public List<TopicPartition> EMPTY_PART_LIST() {
        return this.EMPTY_PART_LIST;
    }

    @Test
    public void testCachedLeaderEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 1);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request1.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        request1.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1))));
        request1.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(2))));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, request1, this.EMPTY_PART_LIST(), false);
        Map epochs1 = FetchSessionTest.cachedLeaderEpochs$1(context1);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs1.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs1.apply((Object)tp2));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> response = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        response.put(tp0, new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        response.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        response.put(tp2, new FetchResponse.PartitionData(Errors.NONE, 5L, 5L, 5L, null, null));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap request2 = new LinkedHashMap();
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(sessionId, 1), request2, this.EMPTY_PART_LIST(), false);
        Map epochs2 = FetchSessionTest.cachedLeaderEpochs$1(context2);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs2.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs2.apply((Object)tp2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request3.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6))));
        request3.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        request3.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3))));
        Map epochs3 = FetchSessionTest.cachedLeaderEpochs$1(fetchManager.newContext(new FetchMetadata(sessionId, 2), request3, this.EMPTY_PART_LIST(), false));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)6)), (Object)epochs3.apply((Object)tp0));
        Assertions.assertEquals(Optional.empty(), (Object)epochs3.apply((Object)tp1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)3)), (Object)epochs3.apply((Object)tp2));
    }

    @Test
    public void testLastFetchedEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 1);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request1.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty(), Optional.empty()));
        request1.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()));
        request1.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1))));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, request1, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context1));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context1));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> response = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        response.put(tp0, new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        response.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        response.put(tp2, new FetchResponse.PartitionData(Errors.NONE, 5L, 5L, 5L, null, null));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap request2 = new LinkedHashMap();
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(sessionId, 1), request2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request3.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6)), Optional.of(Predef$.MODULE$.int2Integer(5))));
        request3.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty(), Optional.empty()));
        request3.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3)), Optional.of(Predef$.MODULE$.int2Integer(3))));
        FetchContext context3 = fetchManager.newContext(new FetchMetadata(sessionId, 2), request3, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.of(BoxesRunTime.boxToInteger((int)6))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), Optional.of(BoxesRunTime.boxToInteger((int)5))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        FetchContext context = fetchManager.newContext(FetchMetadata.LEGACY, new HashMap(), this.EMPTY_PART_LIST(), true);
        Assertions.assertEquals(SessionlessFetchContext.class, context.getClass());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData2.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context2 = fetchManager.newContext(FetchMetadata.INITIAL, reqData2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        java.util.Iterator reqData2Iter = reqData2.entrySet().iterator();
        context2.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$1(reqData2Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 0)).get()));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData2.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData2.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals(respData2, (Object)resp2.responseData());
        FetchContext context3 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(SessionErrorContext.class, context3.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        FetchContext context4 = fetchManager.newContext(new FetchMetadata(resp2.sessionId() + 1, 1), reqData2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(SessionErrorContext.class, context4.getClass());
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData5 = new LinkedHashMap();
        FetchContext context5 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 1), reqData5, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        java.util.Iterator reqData5Iter = reqData2.entrySet().iterator();
        context5.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$2(reqData5Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(new TopicPartition("foo", 1)).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp5.sessionId());
        Assertions.assertEquals((int)0, (int)resp5.responseData().size());
        FetchContext context6 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(SessionErrorContext.class, context6.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData7 = new LinkedHashMap();
        FetchResponse resp7 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 2), reqData7, this.EMPTY_PART_LIST(), false).getThrottledResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp7.sessionId());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        int prevSessionId = resp5.sessionId();
        do {
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData8 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            reqData8.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
            reqData8.put(new TopicPartition("bar", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
            FetchContext context8 = fetchManager.newContext(new FetchMetadata(prevSessionId, -1), reqData8, this.EMPTY_PART_LIST(), false);
            Assertions.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assertions.assertEquals((int)0, (int)cache.size());
            LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData8 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
            respData8.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
            respData8.put(new TopicPartition("bar", 1), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while (resp8.sessionId() == prevSessionId);
    }

    @Test
    public void testIncrementalFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData().size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(15L, 0L, 0, Optional.empty()));
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Iterator reqData2Iter = ((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 1), new TopicPartition("bar", 0)}))).iterator();
        context2.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testIncrementalFetchSession$1(reqData2Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("foo", 0)));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("bar", 0)).get()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("bar", 2)));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData2.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        respData2.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)1, (int)resp2.responseData().size());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchSessionExpiration() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session1req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session1context1 = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, session1context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session1resp = session1context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session2req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session2context = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        session2RespData.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        session2RespData.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        time.sleep(500L);
        FetchContext context1v2 = fetchManager.newContext(new FetchMetadata(session1resp.sessionId(), 1), new LinkedHashMap(), new ArrayList(), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context1v2.getClass());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session3req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        FetchContext session3context = fetchManager.newContext(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData3.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData3.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by latest session, as session 1 was used more recently");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
    }

    @Test
    public void testPrivilegedSessionHandling() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session1req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session1context = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), true);
        Assertions.assertEquals(FullFetchContext.class, session1context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session1resp = session1context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData().size());
        Assertions.assertEquals((int)1, (int)cache.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session2req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session2context = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        session2RespData.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        session2RespData.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session3req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        FetchContext session3context = fetchManager.newContext(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), true);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData3.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData3.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by session 3");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session4req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session4req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session4req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        FetchContext session4context = fetchManager.newContext(FetchMetadata.INITIAL, session4req, this.EMPTY_PART_LIST(), true);
        Assertions.assertEquals(FullFetchContext.class, session4context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData4 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData4.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData4.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session4resp = session3context.updateAndGenerateResponseData(respData4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session4resp.error());
        Assertions.assertTrue((session4resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session4resp.responseData().size());
        Assertions.assertFalse((boolean)cache.get(session1resp.sessionId()).isDefined(), (String)"session 1 should have been evicted by session 4 even though it is privileged as it has hit eviction time");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session4resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData().size());
        LinkedHashMap reqData2 = new LinkedHashMap();
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        removed2.add(new TopicPartition("foo", 1));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assertions.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((int)0, (int)resp2.sessionId());
        Assertions.assertTrue((boolean)resp2.responseData().isEmpty());
        Assertions.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testDivergingEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 2);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData.put(tp1, new FetchRequest.PartitionData(100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        reqData.put(tp2, new FetchRequest.PartitionData(100L, 0L, 1000, Optional.of(Predef$.MODULE$.int2Integer(5)), Optional.of(Predef$.MODULE$.int2Integer(4))));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 105L, 105L, 0L, Optional.empty(), Collections.emptyList(), Optional.empty(), null));
        Optional<FetchResponseData.EpochEndOffset> divergingEpoch = Optional.of(new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(90L));
        respData.put(tp2, new FetchResponse.PartitionData(Errors.NONE, 105L, 105L, 0L, Optional.empty(), Collections.emptyList(), divergingEpoch, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp1.responseData().keySet());
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData, this.EMPTY_PART_LIST(), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.singleton(tp2), resp2.responseData().keySet());
        respData.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 105L, 105L, 0L, Optional.empty(), Collections.emptyList(), divergingEpoch, null));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp3.responseData().keySet());
        respData.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 110L, 110L, 0L, Optional.empty(), Collections.emptyList(), Optional.empty(), null));
        FetchResponse resp4 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp4.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp4.responseData().keySet());
    }

    private static final Map cachedLeaderEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch));
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    private static final Map cachedLeaderEpochs$2(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch));
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    private static final Map cachedLastFetchedEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.lastFetchedEpoch));
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$1(java.util.Iterator reqData2Iter$1, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData2Iter$1.next();
        Assertions.assertEquals(entry.getKey(), (Object)topicPart);
        Assertions.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$2(java.util.Iterator reqData5Iter$1, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData5Iter$1.next();
        Assertions.assertEquals(entry.getKey(), (Object)topicPart);
        Assertions.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testIncrementalFetchSession$1(Iterator reqData2Iter$2, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Assertions.assertEquals((Object)reqData2Iter$2.next(), (Object)topicPart);
    }
}

