/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.MockTime;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Parallel;
import scala.collection.Parallelizable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.FilterMonadic;
import scala.collection.generic.GenericCompanion;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.Combiner;
import scala.collection.parallel.ParIterable;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\n\u0015\u0001eAQA\b\u0001\u0005\u0002}A\u0001\"\t\u0001\t\u0006\u0004%IA\t\u0005\u0006S\u0001!\tE\u000b\u0005\u0006c\u0001!\tF\r\u0005\u0006k\u0001!\tF\u000e\u0005\u0006\t\u0002!\t!\u0012\u0005\u00067\u0002!\t!\u0012\u0005\u0006=\u0002!\t!\u0012\u0005\u0006A\u0002!\t!\u0012\u0005\u0006E\u0002!\t!\u0012\u0005\u0006O\u0002!\t!\u0012\u0005\u0006U\u0002!\t!\u0012\u0005\u0006Y\u0002!\t!\u0012\u0005\u0006+\u0001!IA\u001c\u0005\u0006e\u0002!Ia\u001d\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\t9\u0003\u0001C\u0005\u0003SAq!a!\u0001\t\u0013\t)IA\u0007M_\u001e|eMZ:fiR+7\u000f\u001e\u0006\u0003+Y\taa]3sm\u0016\u0014(\"A\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0007\t\u00037qi\u0011\u0001F\u0005\u0003;Q\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002\tQLW.Z\u000b\u0002GA\u0011AeJ\u0007\u0002K)\u0011aEF\u0001\u0006kRLGn]\u0005\u0003Q\u0015\u0012\u0001\"T8dWRKW.Z\u0001\fEJ|7.\u001a:D_VtG/F\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\rIe\u000e^\u0001\u000bEJ|7.\u001a:US6,GCA\u00124\u0011\u0015!D\u00011\u0001,\u0003!\u0011'o\\6fe&#\u0017a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t9$\b\u0005\u0002-q%\u0011\u0011(\f\u0002\u0005+:LG\u000fC\u0003<\u000b\u0001\u0007A(A\u0003qe>\u00048\u000f\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!Q\u000f^5m\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\u0015A\u0013x\u000e]3si&,7/A\u000fuKN$x)\u001a;PM\u001a\u001cX\r^:G_J,fn\u001b8po:$v\u000e]5d)\u00059\u0004F\u0001\u0004H!\tA\u0015+D\u0001J\u0015\tQ5*A\u0002ba&T!\u0001T'\u0002\u000f),\b/\u001b;fe*\u0011ajT\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002!\u0006\u0019qN]4\n\u0005IK%\u0001\u0002+fgRDCA\u0002+X3B\u0011A&V\u0005\u0003-6\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005A\u0016!\u0006'jgR|eMZ:fiN\u0014V-];fgR\u0004c\u000bM\u0011\u00025\u0006\u0001\u0011\u0001\t;fgR<U\r^(gMN,Go]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND#aB$)\t\u001d!v+W\u0001\u001fi\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3MCR,7\u000f\u001e+j[\u0016D#\u0001C$\u0002/Q,7\u000f^#naRLHj\\4t\u000f\u0016$xJ\u001a4tKR\u001c\bFA\u0005H\u0003]!Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK:{w\u000f\u000b\u0002\u000b\u000f\"\"!\u0002V3ZC\u00051\u0017\u0001\u00077fO\u0006\u001c\u0017PR3uG\"|eMZ:fiN\u0014UMZ8sK\u0006\u0001C/Z:u\u000f\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016,\u0015M\u001d7jKN$H+[7fQ\tYq\t\u000b\u0003\f)\u0016L\u0016!\f;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3XSRD7\t[1oO&twmU3h[\u0016tGoU5{K\"\u0012AbR\u0001+i\u0016\u001cHOR3uG\"|eMZ:fiN\u0014UMZ8sK^KG\u000f[\"iC:<\u0017N\\4TK\u001elWM\u001c;tQ\tiq)F\u0001p!\tY\u0002/\u0003\u0002r)\tY1*\u00194lCN+'O^3s\u0003Y\u0019XM\u001c3MSN$xJ\u001a4tKR\u001c(+Z9vKN$HC\u0001;\u0000!\t)X0D\u0001w\u0015\t9\b0\u0001\u0005sKF,Xm\u001d;t\u0015\tI(0\u0001\u0004d_6lwN\u001c\u0006\u0003/mT!\u0001`(\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tqhOA\nMSN$xJ\u001a4tKR\u001c(+Z:q_:\u001cX\rC\u0004\u0002\u0002=\u0001\r!a\u0001\u0002\u000fI,\u0017/^3tiB\u0019Q/!\u0002\n\u0007\u0005\u001daO\u0001\nMSN$xJ\u001a4tKR\u001c(+Z9vKN$\u0018\u0001E:f]\u00124U\r^2i%\u0016\fX/Z:u)\u0011\ti!a\b\u0011\u000bU\fy!a\u0005\n\u0007\u0005EaOA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004=\u0002\rI,7m\u001c:e\u0013\u0011\ti\"a\u0006\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\t\t\u0001\u0005a\u0001\u0003C\u00012!^A\u0012\u0013\r\t)C\u001e\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0001\u0011EVLG\u000e\u001a+be\u001e,G\u000fV5nKN$\u0002\"a\u000b\u0002j\u0005U\u0014q\u0010\t\u0007\u0003[\ti$a\u0011\u000f\t\u0005=\u0012\u0011\b\b\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013bAA\u001e[\u00059\u0001/Y2lC\u001e,\u0017\u0002BA \u0003\u0003\u0012A\u0001T5ti*\u0019\u00111H\u0017\u0011\t\u0005\u0015\u00131\r\b\u0005\u0003\u000f\niF\u0004\u0003\u0002J\u0005ec\u0002BA&\u0003/rA!!\u0014\u0002V9!\u0011qJA*\u001d\u0011\t\t$!\u0015\n\u0003AK!\u0001`(\n\u0005]Y\u0018BA={\u0013\r\tY\u0006_\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\ty&!\u0019\u0002-1K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e#bi\u0006T1!a\u0017y\u0013\u0011\t)'a\u001a\u0003!1K7\u000f^(gMN,Go\u001d+pa&\u001c'\u0002BA0\u0003CBq!a\u001b\u0012\u0001\u0004\ti'\u0001\u0002uaB!\u0011qNA9\u001b\u0005A\u0018bAA:q\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA<#\u0001\u0007\u0011\u0011P\u0001\ni&lWm\u001d;b[B\u00042\u0001LA>\u0013\r\ti(\f\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\u0002F\u0001\raK\u0001\u000e[\u0006Dh*^7PM\u001a\u001cX\r^:\u0002\u001b\u0019Lg\u000e\u001a)beRLG/[8o)\u0019\t9)!&\u00020B!\u0011\u0011RAH\u001d\u0011\t9%a#\n\t\u00055\u0015\u0011M\u0001\u0018\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a#bi\u0006LA!!%\u0002\u0014\naB*[:u\u001f\u001a47/\u001a;t!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,'\u0002BAG\u0003CBq!a&\u0013\u0001\u0004\tI*\u0001\u0004u_BL7m\u001d\t\u0007\u00037\u000b)+!+\u000e\u0005\u0005u%\u0002BAP\u0003C\u000bq!\\;uC\ndWMC\u0002\u0002$6\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9+!(\u0003\r\t+hMZ3s!\u0011\tI)a+\n\t\u00055\u00161\u0013\u0002\u0019\u0019&\u001cHo\u00144gg\u0016$8\u000fV8qS\u000e\u0014Vm\u001d9p]N,\u0007bBA6%\u0001\u0007\u0011Q\u000e")
public class LogOffsetTest
extends BaseRequestTest {
    private MockTime time;
    private volatile boolean bitmap$0;

    private MockTime time$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.time = new MockTime();
                this.bitmap$0 = true;
            }
        }
        return this.time;
    }

    private MockTime time() {
        if (!this.bitmap$0) {
            return this.time$lzycompute();
        }
        return this.time;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public MockTime brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @Test
    public void testGetOffsetsForUnknownTopic() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeLatestTime() {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$2(topicPartition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava())).build();
        Assertions.assertFalse((boolean)((MemoryRecords)((FetchResponse.PartitionData)this.sendFetchRequest(fetchRequest).responseData().get(topicPartition)).records()).batches().iterator().hasNext());
    }

    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala()).head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeNow() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, logManager.getOrCreateLog$default$2(), logManager.getOrCreateLog$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeNow$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, logManager.getOrCreateLog$default$2(), logManager.getOrCreateLog$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()));
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogOffsetTest.$anonfun$testGetOffsetsBeforeEarliestTime$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.buildTargetTimes(topicPartition, -2L, 10)).asJava()).build();
        Buffer consumerOffsets = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendListOffsetsRequest(request).topics()).asScala()), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).andStubAnswer((IAnswer)new IAnswer<Object>(null){
            private final AtomicInteger value;

            private AtomicInteger value() {
                return this.value;
            }

            public int answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        .colon.colon logSegments = new .colon.colon((Object)logSegment, (List)Nil$.MODULE$);
        EasyMock.expect((Object)log.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(null, logSegment){
            public final LogSegment logSegment$1;

            public Iterable<LogSegment> answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$2 $outer;

                    public GenericCompanion<Iterable> companion() {
                        return Iterable.companion$((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.seq$((Iterable)this);
                    }

                    public Iterable<LogSegment> thisCollection() {
                        return IterableLike.thisCollection$((IterableLike)this);
                    }

                    public Iterable toCollection(Object repr) {
                        return IterableLike.toCollection$((IterableLike)this, (Object)repr);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableLike.foreach$((IterableLike)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableLike.forall$((IterableLike)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableLike.exists$((IterableLike)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableLike.find$((IterableLike)this, p);
                    }

                    public boolean isEmpty() {
                        return IterableLike.isEmpty$((IterableLike)this);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.foldRight$((IterableLike)this, z, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableLike.reduceRight$((IterableLike)this, op);
                    }

                    public Iterable<LogSegment> toIterable() {
                        return IterableLike.toIterable$((IterableLike)this);
                    }

                    public Iterator<LogSegment> toIterator() {
                        return IterableLike.toIterator$((IterableLike)this);
                    }

                    public Object head() {
                        return IterableLike.head$((IterableLike)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableLike.slice$((IterableLike)this, (int)from, (int)until);
                    }

                    public Object take(int n) {
                        return IterableLike.take$((IterableLike)this, (int)n);
                    }

                    public Object drop(int n) {
                        return IterableLike.drop$((IterableLike)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableLike.takeWhile$((IterableLike)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size) {
                        return IterableLike.grouped$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size) {
                        return IterableLike.sliding$((IterableLike)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                        return IterableLike.sliding$((IterableLike)this, (int)size, (int)step);
                    }

                    public Object takeRight(int n) {
                        return IterableLike.takeRight$((IterableLike)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableLike.dropRight$((IterableLike)this, (int)n);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        IterableLike.copyToArray$((IterableLike)this, (Object)xs, (int)start, (int)len);
                    }

                    public <A1, B, That> That zip(GenIterable<B> that, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zip$((IterableLike)this, that, bf);
                    }

                    public <B, A1, That> That zipAll(GenIterable<B> that, A1 thisElem, B thatElem, CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, B>, That> bf) {
                        return (That)IterableLike.zipAll$((IterableLike)this, that, thisElem, thatElem, bf);
                    }

                    public <A1, That> That zipWithIndex(CanBuildFrom<Iterable<LogSegment>, Tuple2<A1, Object>, That> bf) {
                        return (That)IterableLike.zipWithIndex$((IterableLike)this, bf);
                    }

                    public <B> boolean sameElements(GenIterable<B> that) {
                        return IterableLike.sameElements$((IterableLike)this, that);
                    }

                    public Stream<LogSegment> toStream() {
                        return IterableLike.toStream$((IterableLike)this);
                    }

                    public boolean canEqual(Object that) {
                        return IterableLike.canEqual$((IterableLike)this, (Object)that);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view() {
                        return IterableLike.view$((IterableLike)this);
                    }

                    public IterableView<LogSegment, Iterable<LogSegment>> view(int from, int until) {
                        return IterableLike.view$((IterableLike)this, (int)from, (int)until);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newBuilder() {
                        return GenericTraversableTemplate.newBuilder$((GenericTraversableTemplate)this);
                    }

                    public <B> Builder<B, Iterable<B>> genericBuilder() {
                        return GenericTraversableTemplate.genericBuilder$((GenericTraversableTemplate)this);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return GenericTraversableTemplate.unzip$((GenericTraversableTemplate)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return GenericTraversableTemplate.unzip3$((GenericTraversableTemplate)this, asTriple);
                    }

                    public GenTraversable flatten(Function1 asTraversable) {
                        return GenericTraversableTemplate.flatten$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public GenTraversable transpose(Function1 asTraversable) {
                        return GenericTraversableTemplate.transpose$((GenericTraversableTemplate)this, (Function1)asTraversable);
                    }

                    public Object repr() {
                        return TraversableLike.repr$((TraversableLike)this);
                    }

                    public final boolean isTraversableAgain() {
                        return TraversableLike.isTraversableAgain$((TraversableLike)this);
                    }

                    public Combiner<LogSegment, ParIterable<LogSegment>> parCombiner() {
                        return TraversableLike.parCombiner$((TraversableLike)this);
                    }

                    public boolean hasDefiniteSize() {
                        return TraversableLike.hasDefiniteSize$((TraversableLike)this);
                    }

                    public <B, That> That $plus$plus(GenTraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(TraversableOnce<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That $plus$plus$colon(Traversable<B> that, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.$plus$plus$colon$((TraversableLike)this, that, bf);
                    }

                    public <B, That> That map(Function1<LogSegment, B> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.map$((TraversableLike)this, f, bf);
                    }

                    public <B, That> That flatMap(Function1<LogSegment, GenTraversableOnce<B>> f, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.flatMap$((TraversableLike)this, f, bf);
                    }

                    public Object filterImpl(Function1 p, boolean isFlipped) {
                        return TraversableLike.filterImpl$((TraversableLike)this, (Function1)p, (boolean)isFlipped);
                    }

                    public Object filter(Function1 p) {
                        return TraversableLike.filter$((TraversableLike)this, (Function1)p);
                    }

                    public Object filterNot(Function1 p) {
                        return TraversableLike.filterNot$((TraversableLike)this, (Function1)p);
                    }

                    public <B, That> That collect(PartialFunction<LogSegment, B> pf, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.collect$((TraversableLike)this, pf, bf);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return TraversableLike.partition$((TraversableLike)this, p);
                    }

                    public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return TraversableLike.groupBy$((TraversableLike)this, f);
                    }

                    public <B, That> That scan(B z, Function2<B, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> cbf) {
                        return (That)TraversableLike.scan$((TraversableLike)this, z, op, cbf);
                    }

                    public <B, That> That scanLeft(B z, Function2<B, LogSegment, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanLeft$((TraversableLike)this, z, op, bf);
                    }

                    public <B, That> That scanRight(B z, Function2<LogSegment, B, B> op, CanBuildFrom<Iterable<LogSegment>, B, That> bf) {
                        return (That)TraversableLike.scanRight$((TraversableLike)this, z, op, bf);
                    }

                    public Option<LogSegment> headOption() {
                        return TraversableLike.headOption$((TraversableLike)this);
                    }

                    public Object tail() {
                        return TraversableLike.tail$((TraversableLike)this);
                    }

                    public Object last() {
                        return TraversableLike.last$((TraversableLike)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return TraversableLike.lastOption$((TraversableLike)this);
                    }

                    public Object init() {
                        return TraversableLike.init$((TraversableLike)this);
                    }

                    public Object sliceWithKnownDelta(int from, int until, int delta) {
                        return TraversableLike.sliceWithKnownDelta$((TraversableLike)this, (int)from, (int)until, (int)delta);
                    }

                    public Object sliceWithKnownBound(int from, int until) {
                        return TraversableLike.sliceWithKnownBound$((TraversableLike)this, (int)from, (int)until);
                    }

                    public Object dropWhile(Function1 p) {
                        return TraversableLike.dropWhile$((TraversableLike)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return TraversableLike.span$((TraversableLike)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return TraversableLike.splitAt$((TraversableLike)this, (int)n);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return TraversableLike.tails$((TraversableLike)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return TraversableLike.inits$((TraversableLike)this);
                    }

                    public Traversable<LogSegment> toTraversable() {
                        return TraversableLike.toTraversable$((TraversableLike)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, LogSegment, Col> cbf) {
                        return (Col)TraversableLike.to$((TraversableLike)this, cbf);
                    }

                    public String toString() {
                        return TraversableLike.toString$((TraversableLike)this);
                    }

                    public String stringPrefix() {
                        return TraversableLike.stringPrefix$((TraversableLike)this);
                    }

                    public FilterMonadic<LogSegment, Iterable<LogSegment>> withFilter(Function1<LogSegment, Object> p) {
                        return TraversableLike.withFilter$((TraversableLike)this, p);
                    }

                    public Parallel par() {
                        return Parallelizable.par$((Parallelizable)this);
                    }

                    public List<LogSegment> reversed() {
                        return TraversableOnce.reversed$((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.nonEmpty$((TraversableOnce)this);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return TraversableOnce.count$((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.product$((TraversableOnce)this, num);
                    }

                    public Object min(Ordering cmp) {
                        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object max(Ordering cmp) {
                        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                    }

                    public List<LogSegment> toList() {
                        return TraversableOnce.toList$((TraversableOnce)this);
                    }

                    public Seq<LogSegment> toSeq() {
                        return TraversableOnce.toSeq$((TraversableOnce)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.toBuffer$((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.toSet$((TraversableOnce)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return TraversableOnce.toVector$((TraversableOnce)this);
                    }

                    public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<LogSegment, Tuple2<T, U>> ev) {
                        return TraversableOnce.toMap$((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.mkString$((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                    }

                    public int sizeHintIfCheap() {
                        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return new .colon.colon((Object)this.$outer.logSegment$1, (List)Nil$.MODULE$).iterator();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        GenTraversableOnce.$init$((GenTraversableOnce)this);
                        TraversableOnce.$init$((TraversableOnce)this);
                        Parallelizable.$init$((Parallelizable)this);
                        TraversableLike.$init$((TraversableLike)this);
                        GenericTraversableTemplate.$init$((GenericTraversableTemplate)this);
                        GenTraversable.$init$((GenTraversable)this);
                        Traversable.$init$((Traversable)this);
                        GenIterable.$init$((GenIterable)this);
                        IterableLike.$init$((IterableLike)this);
                        Iterable.$init$((Iterable)this);
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaServer server() {
        return (KafkaServer)this.servers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$1))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$2))).get();
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsAfterDeleteRecords$1(LogManager logManager$1, TopicPartition topicPartition$1) {
        return logManager$1.getLog(topicPartition$1, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$2() {
        return "Log for partition [topic,0] should be created";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsBeforeLatestTime$1(LogManager logManager$2, TopicPartition topicPartition$2) {
        return logManager$2.getLog(topicPartition$2, logManager$2.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$2(TopicPartition topicPartition$2) {
        return new java.lang.StringBuilder(36).append("Log for partition ").append(topicPartition$2).append(" should be created").toString();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$1) {
        String string = x$1.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$2) {
        return x$2.partitionIndex() == tp$1.partition();
    }
}

