/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.AbstractMetadataRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a2Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C!-!)!\u0006\u0001C!W!)q\u0006\u0001C\u0001-!)A\u0007\u0001C\u0001-!)a\u0007\u0001C\u0001-\t\tS*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHoV5uQ\u001a{'o^1sI&tw\rV3ti*\u0011\u0011BC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0011%\u0011\u0011\u0003\u0003\u0002\u001c\u0003\n\u001cHO]1di6+G/\u00193bi\u0006\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005!\u0002CA\b\u0001\u0003\u0015\u0019X\r^+q)\u00059\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"\u0001B+oSRD#A\u0001\u0010\u0011\u0005}AS\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013aA1qS*\u00111\u0005J\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)c%A\u0003kk:LGOC\u0001(\u0003\ry'oZ\u0005\u0003S\u0001\u0012!BQ3g_J,W)Y2i\u0003A)g.\u00192mK\u001a{'o^1sI&tw-F\u0001-!\tAR&\u0003\u0002/3\t9!i\\8mK\u0006t\u0017!\u0006;fgR\fU\u000f^8U_BL7m\u0011:fCRLwN\u001c\u0015\u0003\tE\u0002\"a\b\u001a\n\u0005M\u0002#\u0001\u0002+fgR\fq\u0006^3ti\u0006+Ho\\\"sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_JD#!B\u0019\u0002?Q,7\u000f^!vi>\u001c%/Z1uK>37i\u001c7mS\u0012Lgn\u001a+pa&\u001c7\u000f\u000b\u0002\u0007c\u0001")
public class MetadataRequestWithForwardingTest
extends AbstractMetadataRequestTest {
    @Override
    @BeforeEach
    public void setUp() {
        this.doSetup(false);
    }

    @Override
    public boolean enableForwarding() {
        return true;
    }

    @Test
    public void testAutoTopicCreation() {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        String topic5 = "t5";
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertNull(response1.errors().get(topic1));
        this.checkAutoCreatedTopic(topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic(topic3, response2);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)topic4, (List)Nil$.MODULE$), false), (short)3), this.sendMetadataRequest$default$2()));
        MetadataResponse response3 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic4, (List)new .colon.colon((Object)topic5, (List)Nil$.MODULE$))).asJava(), false, (short)4).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic5));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(topic5));
    }

    @Test
    public void testAutoCreateTopicWithInvalidReplicationFactor() {
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)1, (int)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).head();
        Assertions.assertEquals((Object)Errors.INVALID_REPLICATION_FACTOR, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assertions.assertEquals((int)0, (int)topicMetadata.partitionMetadata().size());
    }

    @Test
    public void testAutoCreateOfCollidingTopics() {
        String topic1 = "testAutoCreate.Topic";
        String topic2 = "testAutoCreate_Topic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)2, (int)response1.topicMetadata().size());
        Map responseMap = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response1.topicMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)metadata -> new Tuple2((Object)metadata.topic(), (Object)metadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (Object)responseMap.keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.LEADER_NOT_AVAILABLE, Errors.INVALID_TOPIC_EXCEPTION})), (Object)responseMap.values().toSet());
        String topicCreated = (String)((Tuple2)responseMap.head())._1();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topicCreated, 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)this.servers(), topicCreated, 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicCreated, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.TopicMetadata topicMetadata1 = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response2.topicMetadata()).asScala()).head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata1.error());
        Assertions.assertEquals((Object)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.error, Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((int)1, (int)topicMetadata1.partitionMetadata().size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata1.partitionMetadata()).asScala()).head();
        Assertions.assertEquals((int)0, (int)partitionMetadata.partition());
        Assertions.assertEquals((int)2, (int)partitionMetadata.replicaIds.size());
        Assertions.assertTrue((boolean)partitionMetadata.leaderId.isPresent());
        Assertions.assertTrue((Predef$.MODULE$.Integer2int((Integer)partitionMetadata.leaderId.get()) >= 0 ? 1 : 0) != 0);
    }
}

