/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.EpochEntry;
import kafka.utils.Logging;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E2A\u0001B\u0003\u0001\u0019!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=\tiB*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$h)\u001b7f)\u0016\u001cHO\u0003\u0002\u0007\u000f\u0005Y1\r[3dWB|\u0017N\u001c;t\u0015\tA\u0011\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0015\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!AF\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005a)\"a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\u0015\tae\u001d5pk2$\u0007+\u001a:tSN$\u0018I\u001c3Pm\u0016\u0014xO]5uK\u0006sGMU3m_\u0006$g)\u001b7f)\u0005y\u0002C\u0001\b!\u0013\t\tsB\u0001\u0003V]&$\bF\u0001\u0002$!\t!S&D\u0001&\u0015\t1s%A\u0002ba&T!\u0001K\u0015\u0002\u000f),\b/\u001b;fe*\u0011!fK\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Y\u0005\u0019qN]4\n\u00059*#\u0001\u0002+fgR\fQf\u001d5pk2$'+\u001a;bS:4\u0016\r\\;fg\u00163XM\\%g\u0007\",7m\u001b9pS:$\u0018j\u001d*fGJ,\u0017\r^3eQ\t\u00191\u0005")
public class LeaderEpochCheckpointFileTest
implements Logging {
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Test
    public void shouldPersistAndOverwriteAndReloadFile() {
        File file = File.createTempFile("temp-checkpoint-file", Long.toString(System.nanoTime()));
        file.deleteOnExit();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(file, LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        .colon.colon epochs = new .colon.colon((Object)new EpochEntry(0, 1L), (List)new .colon.colon((Object)new EpochEntry(1, 2L), (List)new .colon.colon((Object)new EpochEntry(2, 3L), (List)Nil$.MODULE$)));
        checkpoint.write((Iterable)epochs);
        Assertions.assertEquals((Object)epochs, (Object)checkpoint.read());
        .colon.colon epochs2 = new .colon.colon((Object)new EpochEntry(3, 4L), (List)new .colon.colon((Object)new EpochEntry(4, 5L), (List)Nil$.MODULE$));
        checkpoint.write((Iterable)epochs2);
        Assertions.assertEquals((Object)epochs2, (Object)checkpoint.read());
    }

    @Test
    public void shouldRetainValuesEvenIfCheckpointIsRecreated() {
        File file = File.createTempFile("temp-checkpoint-file", Long.toString(System.nanoTime()));
        file.deleteOnExit();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(file, LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        .colon.colon epochs = new .colon.colon((Object)new EpochEntry(0, 1L), (List)new .colon.colon((Object)new EpochEntry(1, 2L), (List)new .colon.colon((Object)new EpochEntry(2, 3L), (List)Nil$.MODULE$)));
        checkpoint.write((Iterable)epochs);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(file, LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        Assertions.assertEquals((Object)epochs, (Object)checkpoint2.read());
    }

    public LeaderEpochCheckpointFileTest() {
        Logging.$init$((Logging)this);
    }
}

