/*
 * Decompiled with CFR 0.152.
 */
package kafka.test;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.test.annotation.Type;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class ClusterConfig {
    private final Type type;
    private final int brokers;
    private final int controllers;
    private final String name;
    private final boolean autoStart;
    private final SecurityProtocol securityProtocol;
    private final String listenerName;
    private final File trustStoreFile;
    private final Properties serverProperties = new Properties();
    private final Properties producerProperties = new Properties();
    private final Properties consumerProperties = new Properties();
    private final Properties adminClientProperties = new Properties();
    private final Properties saslServerProperties = new Properties();
    private final Properties saslClientProperties = new Properties();

    ClusterConfig(Type type, int brokers, int controllers, String name, boolean autoStart, SecurityProtocol securityProtocol, String listenerName, File trustStoreFile) {
        this.type = type;
        this.brokers = brokers;
        this.controllers = controllers;
        this.name = name;
        this.autoStart = autoStart;
        this.securityProtocol = securityProtocol;
        this.listenerName = listenerName;
        this.trustStoreFile = trustStoreFile;
    }

    public Type clusterType() {
        return this.type;
    }

    public int numBrokers() {
        return this.brokers;
    }

    public int numControllers() {
        return this.controllers;
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public Properties serverProperties() {
        return this.serverProperties;
    }

    public Properties producerProperties() {
        return this.producerProperties;
    }

    public Properties consumerProperties() {
        return this.consumerProperties;
    }

    public Properties adminClientProperties() {
        return this.adminClientProperties;
    }

    public Properties saslServerProperties() {
        return this.saslServerProperties;
    }

    public Properties saslClientProperties() {
        return this.saslClientProperties;
    }

    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public Optional<String> listenerName() {
        return Optional.ofNullable(this.listenerName);
    }

    public Optional<File> trustStoreFile() {
        return Optional.ofNullable(this.trustStoreFile);
    }

    public Map<String, String> nameTags() {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>(3);
        this.name().ifPresent(name -> tags.put("Name", (String)name));
        tags.put("security", this.securityProtocol.name());
        this.listenerName().ifPresent(listener -> tags.put("listener", (String)listener));
        return tags;
    }

    public ClusterConfig copyOf() {
        ClusterConfig copy = new ClusterConfig(this.type, this.brokers, this.controllers, this.name, this.autoStart, this.securityProtocol, this.listenerName, this.trustStoreFile);
        copy.serverProperties.putAll((Map<?, ?>)this.serverProperties);
        copy.producerProperties.putAll((Map<?, ?>)this.producerProperties);
        copy.consumerProperties.putAll((Map<?, ?>)this.consumerProperties);
        copy.saslServerProperties.putAll((Map<?, ?>)this.saslServerProperties);
        copy.saslClientProperties.putAll((Map<?, ?>)this.saslClientProperties);
        return copy;
    }

    public static Builder defaultClusterBuilder() {
        return new Builder(Type.ZK, 1, 1, true, SecurityProtocol.PLAINTEXT);
    }

    public static Builder clusterBuilder(Type type, int brokers, int controllers, boolean autoStart, SecurityProtocol securityProtocol) {
        return new Builder(type, brokers, controllers, autoStart, securityProtocol);
    }

    public static class Builder {
        private Type type;
        private int brokers;
        private int controllers;
        private String name;
        private boolean autoStart;
        private SecurityProtocol securityProtocol;
        private String listenerName;
        private File trustStoreFile;

        Builder(Type type, int brokers, int controllers, boolean autoStart, SecurityProtocol securityProtocol) {
            this.type = type;
            this.brokers = brokers;
            this.controllers = controllers;
            this.autoStart = autoStart;
            this.securityProtocol = securityProtocol;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder brokers(int brokers) {
            this.brokers = brokers;
            return this;
        }

        public Builder controllers(int controllers) {
            this.controllers = controllers;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder autoStart(boolean autoStart) {
            this.autoStart = autoStart;
            return this;
        }

        public Builder securityProtocol(SecurityProtocol securityProtocol) {
            this.securityProtocol = securityProtocol;
            return this;
        }

        public Builder listenerName(String listenerName) {
            this.listenerName = listenerName;
            return this;
        }

        public Builder trustStoreFile(File trustStoreFile) {
            this.trustStoreFile = trustStoreFile;
            return this;
        }

        public ClusterConfig build() {
            return new ClusterConfig(this.type, this.brokers, this.controllers, this.name, this.autoStart, this.securityProtocol, this.listenerName, this.trustStoreFile);
        }
    }
}

